/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.formatter.AlreadyExistsDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.CreateProfileDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.RenameProfileDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CodingStyleConfigurationBlock {
    private static final String PREF_LASTLOADPATH = "org.eclipse.jdt.ui.codeformatter.loadpath";
    private static final String PREF_LASTSAVEPATH = "org.eclipse.jdt.ui.codeformatter.savepath";
    private static final String PREVIEW = "/**\n* " + FormatterMessages.getString("CodingStyleConfigurationBlock.preview.title") + "\n*/\n\n" + "package mypackage; import java.util.LinkedList; public class MyIntStack {" + "private final LinkedList fStack;" + "public MyIntStack(){fStack= new LinkedList();}" + "public int pop(){return ((Integer)fStack.removeFirst()).intValue();}" + "public void push(int elem){fStack.addFirst(new Integer(elem));}" + "public boolean isEmpty() {return fStack.isEmpty();}" + "}";
    protected Composite fComposite;
    protected Combo fProfileCombo;
    protected Button fEditButton;
    protected Button fRenameButton;
    protected Button fDeleteButton;
    protected Button fNewButton;
    protected Button fLoadButton;
    protected Button fSaveButton;
    protected final ProfileManager fProfileManager;
    protected CompilationUnitPreview fJavaPreview;
    private PixelConverter fPixConv;

    public CodingStyleConfigurationBlock() {
        ArrayList profiles = null;
        try {
            profiles = ProfileStore.readProfiles();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        if (profiles == null) {
            profiles = new ArrayList();
        }
        this.fProfileManager = new ProfileManager(profiles);
        new StoreUpdater();
    }

    public Composite createContents(Composite parent) {
        this.fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5, false);
        this.fProfileCombo = CodingStyleConfigurationBlock.createProfileCombo(this.fComposite, 2, this.fPixConv.convertWidthInCharsToPixels(20));
        this.fEditButton = CodingStyleConfigurationBlock.createButton(this.fComposite, FormatterMessages.getString("CodingStyleConfigurationBlock.edit_button.desc"), 32);
        this.fRenameButton = CodingStyleConfigurationBlock.createButton(this.fComposite, FormatterMessages.getString("CodingStyleConfigurationBlock.rename_button.desc"), 32);
        this.fDeleteButton = CodingStyleConfigurationBlock.createButton(this.fComposite, FormatterMessages.getString("CodingStyleConfigurationBlock.remove_button.desc"), 32);
        Composite group = this.createComposite(this.fComposite, 4, false);
        GridData groupData = new GridData(256);
        groupData.horizontalSpan = 5;
        group.setLayoutData((Object)groupData);
        this.fNewButton = CodingStyleConfigurationBlock.createButton(group, FormatterMessages.getString("CodingStyleConfigurationBlock.new_button.desc"), 32);
        ((GridData)this.createLabel((Composite)group, (String)"", (int)1).getLayoutData()).grabExcessHorizontalSpace = true;
        this.fLoadButton = CodingStyleConfigurationBlock.createButton(group, FormatterMessages.getString("CodingStyleConfigurationBlock.load_button.desc"), 128);
        this.fSaveButton = CodingStyleConfigurationBlock.createButton(group, FormatterMessages.getString("CodingStyleConfigurationBlock.save_button.desc"), 128);
        this.createLabel(this.fComposite, FormatterMessages.getString("CodingStyleConfigurationBlock.preview_label.text"), 5);
        this.configurePreview(this.fComposite, 5);
        new ButtonController();
        new ProfileComboController();
        new PreviewController();
        return this.fComposite;
    }

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        gd.heightHint = SWTUtil.getButtonHeightHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private static Combo createProfileCombo(Composite composite, int span, int widthHint) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private Label createLabel(Composite composite, String text, int numColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns, boolean margins) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(numColumns, false);
        if (margins) {
            layout.marginHeight = this.fPixConv.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixConv.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        layout.horizontalSpacing = this.fPixConv.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.fPixConv.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void configurePreview(Composite composite, int numColumns) {
        this.fJavaPreview = new CompilationUnitPreview(this.fProfileManager.getSelected().getSettings(), composite);
        this.fJavaPreview.setPreviewText(PREVIEW);
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fJavaPreview.getControl().setLayoutData((Object)gd);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JavaPlugin.getDefault().getPreferenceStore();
    }

    public void performOk() {
        this.fProfileManager.commitChanges();
    }

    public void performDefaults() {
        int defaultIndex;
        ProfileManager.Profile profile = this.fProfileManager.getProfile("org.eclipse.jdt.ui.default.sun_profile");
        if (profile != null && (defaultIndex = this.fProfileManager.getSortedProfiles().indexOf(profile)) != -1) {
            this.fProfileCombo.select(defaultIndex);
            this.fProfileManager.setSelected(profile);
        }
    }

    private class StoreUpdater
    implements Observer {
        public StoreUpdater() {
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    try {
                        ProfileStore.writeProfiles(CodingStyleConfigurationBlock.this.fProfileManager.getSortedProfiles());
                        break;
                    }
                    catch (CoreException x) {
                        JavaPlugin.log(x);
                    }
                }
            }
        }
    }

    private class ProfileComboController
    implements Observer,
    SelectionListener {
        private final List fSortedProfiles;

        public ProfileComboController() {
            this.fSortedProfiles = CodingStyleConfigurationBlock.this.fProfileManager.getSortedProfiles();
            CodingStyleConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            int index = CodingStyleConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            CodingStyleConfigurationBlock.this.fProfileManager.setSelected((ProfileManager.Profile)this.fSortedProfiles.get(index));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void update(Observable o, Object arg) {
            if (arg == null) {
                return;
            }
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            CodingStyleConfigurationBlock.this.fProfileCombo.setItems(CodingStyleConfigurationBlock.this.fProfileManager.getSortedNames());
        }

        private void updateSelection() {
            CodingStyleConfigurationBlock.this.fProfileCombo.setText(CodingStyleConfigurationBlock.this.fProfileManager.getSelected().getName());
        }
    }

    private class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
            CodingStyleConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fRenameButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fSaveButton.addSelectionListener((SelectionListener)this);
            CodingStyleConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            this.update(CodingStyleConfigurationBlock.this.fProfileManager, null);
        }

        public void update(Observable o, Object arg) {
            boolean state = ((ProfileManager)o).getSelected() instanceof ProfileManager.CustomProfile;
            CodingStyleConfigurationBlock.this.fEditButton.setText(state ? FormatterMessages.getString("CodingStyleConfigurationBlock.edit_button.desc") : FormatterMessages.getString("CodingStyleConfigurationBlock.show_button.desc"));
            CodingStyleConfigurationBlock.this.fDeleteButton.setEnabled(state);
            CodingStyleConfigurationBlock.this.fSaveButton.setEnabled(state);
            CodingStyleConfigurationBlock.this.fRenameButton.setEnabled(state);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == CodingStyleConfigurationBlock.this.fSaveButton) {
                this.saveButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            } else if (button == CodingStyleConfigurationBlock.this.fRenameButton) {
                this.renameButtonPressed();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void renameButtonPressed() {
            if (!(CodingStyleConfigurationBlock.this.fProfileManager.getSelected() instanceof ProfileManager.CustomProfile)) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)CodingStyleConfigurationBlock.this.fProfileManager.getSelected();
            RenameProfileDialog renameDialog = new RenameProfileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), profile, CodingStyleConfigurationBlock.this.fProfileManager);
            renameDialog.open();
        }

        private void modifyButtonPressed() {
            ModifyDialog modifyDialog = new ModifyDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), CodingStyleConfigurationBlock.this.fProfileManager.getSelected(), CodingStyleConfigurationBlock.this.fProfileManager, false);
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            if (MessageDialog.openQuestion((Shell)CodingStyleConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.getString("CodingStyleConfigurationBlock.delete_confirmation.title"), (String)FormatterMessages.getFormattedString("CodingStyleConfigurationBlock.delete_confirmation.question", CodingStyleConfigurationBlock.this.fProfileManager.getSelected().getName()))) {
                CodingStyleConfigurationBlock.this.fProfileManager.deleteSelected();
            }
        }

        private void newButtonPressed() {
            CreateProfileDialog p = new CreateProfileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), CodingStyleConfigurationBlock.this.fProfileManager);
            if (p.open() != 0) {
                return;
            }
            if (!p.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = new ModifyDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), p.getCreatedProfile(), CodingStyleConfigurationBlock.this.fProfileManager, true);
            modifyDialog.open();
        }

        private void saveButtonPressed() {
            String path;
            FileDialog dialog = new FileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), 8192);
            dialog.setText(FormatterMessages.getString("CodingStyleConfigurationBlock.save_profile.dialog.title"));
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(CodingStyleConfigurationBlock.PREF_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(CodingStyleConfigurationBlock.PREF_LASTSAVEPATH, dialog.getFilterPath());
            File file = new File(path);
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.add(CodingStyleConfigurationBlock.this.fProfileManager.getSelected());
            try {
                ProfileStore.writeProfilesToFile(profiles, file);
            }
            catch (CoreException e) {
                String title = FormatterMessages.getString("CodingStyleConfigurationBlock.save_profile.error.title");
                String message = FormatterMessages.getString("CodingStyleConfigurationBlock.save_profile.error.message");
                ExceptionHandler.handle(e, CodingStyleConfigurationBlock.this.fComposite.getShell(), title, message);
            }
        }

        private void loadButtonPressed() {
            AlreadyExistsDialog aeDialog;
            String message;
            String title;
            String path;
            FileDialog dialog = new FileDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), 4096);
            dialog.setText(FormatterMessages.getString("CodingStyleConfigurationBlock.load_profile.dialog.title"));
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(CodingStyleConfigurationBlock.PREF_LASTLOADPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(CodingStyleConfigurationBlock.PREF_LASTLOADPATH, dialog.getFilterPath());
            File file = new File(path);
            List profiles = null;
            try {
                profiles = ProfileStore.readProfilesFromFile(file);
            }
            catch (CoreException e) {
                title = FormatterMessages.getString("CodingStyleConfigurationBlock.load_profile.error.title");
                message = FormatterMessages.getString("CodingStyleConfigurationBlock.load_profile.error.message");
                ExceptionHandler.handle(e, CodingStyleConfigurationBlock.this.fComposite.getShell(), title, message);
            }
            if (profiles == null || profiles.isEmpty()) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)profiles.iterator().next();
            if (ProfileVersioner.getVersionStatus(profile) > 0) {
                title = FormatterMessages.getString("CodingStyleConfigurationBlock.load_profile.error_too_new.title");
                message = FormatterMessages.getString("CodingStyleConfigurationBlock.load_profile.error_too_new.message");
                MessageDialog.openWarning((Shell)CodingStyleConfigurationBlock.this.fComposite.getShell(), (String)title, (String)message);
            }
            if (CodingStyleConfigurationBlock.this.fProfileManager.containsName(profile.getName()) && (aeDialog = new AlreadyExistsDialog(CodingStyleConfigurationBlock.this.fComposite.getShell(), profile, CodingStyleConfigurationBlock.this.fProfileManager)).open() != 0) {
                return;
            }
            ProfileVersioner.updateAndComplete(profile);
            CodingStyleConfigurationBlock.this.fProfileManager.addProfile(profile);
        }
    }

    private class PreviewController
    implements Observer {
        public PreviewController() {
            CodingStyleConfigurationBlock.this.fProfileManager.addObserver(this);
            CodingStyleConfigurationBlock.this.fJavaPreview.setWorkingValues(CodingStyleConfigurationBlock.this.fProfileManager.getSelected().getSettings());
            CodingStyleConfigurationBlock.this.fJavaPreview.update();
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodingStyleConfigurationBlock.this.fJavaPreview.setWorkingValues(((ProfileManager)o).getSelected().getSettings());
                    CodingStyleConfigurationBlock.this.fJavaPreview.update();
                }
            }
        }
    }
}

