/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.SnippetPreview;

public final class WhiteSpaceOptions {
    private static final SnippetPreview.PreviewSnippet FOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "for (int i= 0, j= array.length; i < array.length; i++, j--) {}");
    private static final SnippetPreview.PreviewSnippet WHILE_PREVIEW = new SnippetPreview.PreviewSnippet(2, "while (condition) {}; do {} while (condition);");
    private static final SnippetPreview.PreviewSnippet CATCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "try { number= Integer.parseInt(value); } catch (NumberFormatException e) {}");
    private static final SnippetPreview.PreviewSnippet IF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (condition) { return foo; } else {return bar;}");
    private static final SnippetPreview.PreviewSnippet SYNCHRONIZED_PREVIEW = new SnippetPreview.PreviewSnippet(2, "synchronized (list) { list.add(element); }");
    private static final SnippetPreview.PreviewSnippet SWITCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "switch (number) { case RED: return GREEN; case GREEN: return BLUE; case BLUE: return RED; default: return BLACK;}");
    private static final SnippetPreview.PreviewSnippet CONSTRUCTOR_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "MyClass() throws E0, E1 { this(0,0,0);}MyClass(int x, int y, int z) throws E0, E1 { super(x, y, z, true);}");
    private static final SnippetPreview.PreviewSnippet METHOD_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "void foo() throws E0, E1 {};void bar(int x, int y) throws E0, E1 {}");
    private static final SnippetPreview.PreviewSnippet ARRAY_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int [] array0= new int [] {};\nint [] array1= new int [] {1, 2, 3};\nint [] array2= new int[3];");
    private static final SnippetPreview.PreviewSnippet ARRAY_REF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "array[i].foo();");
    private static final SnippetPreview.PreviewSnippet METHOD_CALL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "foo();\nbar(x, y);");
    private static final SnippetPreview.PreviewSnippet ALLOC_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String str= new String(); Point point= new Point(x, y);");
    private static final SnippetPreview.PreviewSnippet LABEL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "label: for (int i= 0; i<list.length; i++) {for (int j= 0; j < list[i].length; j++) continue label;}");
    private static final SnippetPreview.PreviewSnippet SEMICOLON_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= 4; foo(); bar(x, y);");
    private static final SnippetPreview.PreviewSnippet CONDITIONAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String value= condition ? TRUE : FALSE;");
    private static final SnippetPreview.PreviewSnippet CLASS_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(8, "class MyClass implements I0, I1, I2 {}");
    private static final SnippetPreview.PreviewSnippet ANON_CLASS_PREVIEW = new SnippetPreview.PreviewSnippet(2, "AnonClass= new AnonClass() {void foo(Some s) { }};");
    private static final SnippetPreview.PreviewSnippet OPERATOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "List list= new ArrayList(); int a= -4 + -9; b= a++ / --number; c += 4; boolean value= true && false;");
    private static final SnippetPreview.PreviewSnippet CAST_PREVIEW = new SnippetPreview.PreviewSnippet(2, "String s= ((String)object);");
    private static final SnippetPreview.PreviewSnippet MULT_LOCAL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= 0, b= 1, c= 2, d= 3;");
    private static final SnippetPreview.PreviewSnippet MULT_FIELD_PREVIEW = new SnippetPreview.PreviewSnippet(4, "int a=0,b=1,c=2,d=3;");
    private static final SnippetPreview.PreviewSnippet BLOCK_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (true) { return 1; } else { return 2; }");
    private static final SnippetPreview.PreviewSnippet PAREN_EXPR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "result= (a *( b +  c + d) * (e + f));");
    private static final SnippetPreview.PreviewSnippet ASSERT_PREVIEW = new SnippetPreview.PreviewSnippet(2, "assert condition : reportError();");

    public static ArrayList createTreeByPosition(Map workingValues) {
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        InnerNode before = new InnerNode(null, workingValues, "WhiteSpaceOptions.before");
        WhiteSpaceOptions.createBeforeOpenParenTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.opening_paren"));
        WhiteSpaceOptions.createBeforeClosingParenTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.closing_paren"));
        WhiteSpaceOptions.createBeforeOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.opening_brace"));
        WhiteSpaceOptions.createBeforeClosingBraceTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.closing_brace"));
        WhiteSpaceOptions.createBeforeOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.opening_bracket"));
        WhiteSpaceOptions.createBeforeClosingBracketTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.closing_bracket"));
        WhiteSpaceOptions.createBeforeOperatorTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.operator"));
        WhiteSpaceOptions.createBeforeCommaTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.comma"));
        WhiteSpaceOptions.createBeforeColonTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.colon"));
        WhiteSpaceOptions.createBeforeSemicolonTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.semicolon"));
        WhiteSpaceOptions.createBeforeQuestionTree(workingValues, WhiteSpaceOptions.createChild(before, workingValues, "WhiteSpaceOptions.question_mark"));
        roots.add(before);
        InnerNode after = new InnerNode(null, workingValues, "WhiteSpaceOptions.after");
        WhiteSpaceOptions.createAfterOpenParenTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.opening_paren"));
        WhiteSpaceOptions.createAfterCloseParenTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.closing_paren"));
        WhiteSpaceOptions.createAfterOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.opening_brace"));
        WhiteSpaceOptions.createAfterCloseBraceTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.closing_brace"));
        WhiteSpaceOptions.createAfterOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.opening_bracket"));
        WhiteSpaceOptions.createAfterOperatorTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.operator"));
        WhiteSpaceOptions.createAfterCommaTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.comma"));
        WhiteSpaceOptions.createAfterColonTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.colon"));
        WhiteSpaceOptions.createAfterSemicolonTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.semicolon"));
        WhiteSpaceOptions.createAfterQuestionTree(workingValues, WhiteSpaceOptions.createChild(after, workingValues, "WhiteSpaceOptions.question_mark"));
        roots.add(after);
        InnerNode between = new InnerNode(null, workingValues, "WhiteSpaceOptions.between");
        WhiteSpaceOptions.createBetweenEmptyBracesTree(workingValues, WhiteSpaceOptions.createChild(between, workingValues, "WhiteSpaceOptions.empty_braces"));
        WhiteSpaceOptions.createBetweenEmptyBracketsTree(workingValues, WhiteSpaceOptions.createChild(between, workingValues, "WhiteSpaceOptions.empty_brackets"));
        WhiteSpaceOptions.createBetweenEmptyParenTree(workingValues, WhiteSpaceOptions.createChild(between, workingValues, "WhiteSpaceOptions.empty_parens"));
        roots.add(between);
        return roots;
    }

    public static ArrayList createTreeBySyntaxElem(Map workingValues) {
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        InnerNode element = new InnerNode(null, workingValues, "WhiteSpaceOptions.opening_paren");
        WhiteSpaceOptions.createBeforeOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.closing_paren");
        WhiteSpaceOptions.createBeforeClosingParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterCloseParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.opening_brace");
        WhiteSpaceOptions.createBeforeOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.closing_brace");
        WhiteSpaceOptions.createBeforeClosingBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterCloseBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.opening_bracket");
        WhiteSpaceOptions.createBeforeOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.closing_bracket");
        WhiteSpaceOptions.createBeforeClosingBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.operator");
        WhiteSpaceOptions.createBeforeOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.comma");
        WhiteSpaceOptions.createBeforeCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.colon");
        WhiteSpaceOptions.createBeforeColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.semicolon");
        WhiteSpaceOptions.createBeforeSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.question_mark");
        WhiteSpaceOptions.createBeforeQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.before"));
        WhiteSpaceOptions.createAfterQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, "WhiteSpaceOptions.after"));
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.between_empty_parens");
        WhiteSpaceOptions.createBetweenEmptyParenTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.between_empty_braces");
        WhiteSpaceOptions.createBetweenEmptyBracesTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, "WhiteSpaceOptions.between_empty_brackets");
        WhiteSpaceOptions.createBetweenEmptyBracketsTree(workingValues, element);
        roots.add(element);
        return roots;
    }

    public static ArrayList createAltTree(Map workingValues) {
        ArrayList roots = new ArrayList();
        InnerNode parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_opening_paren");
        WhiteSpaceOptions.createBeforeOpenParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_opening_paren");
        WhiteSpaceOptions.createAfterOpenParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_closing_paren");
        WhiteSpaceOptions.createBeforeClosingParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_closing_paren");
        WhiteSpaceOptions.createAfterCloseParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.between_empty_parens");
        WhiteSpaceOptions.createBetweenEmptyParenTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_opening_brace");
        WhiteSpaceOptions.createBeforeOpenBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_opening_brace");
        WhiteSpaceOptions.createAfterOpenBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_closing_brace");
        WhiteSpaceOptions.createBeforeClosingBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_closing_brace");
        WhiteSpaceOptions.createAfterCloseBraceTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.between_empty_braces");
        WhiteSpaceOptions.createBetweenEmptyBracesTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_opening_bracket");
        WhiteSpaceOptions.createBeforeOpenBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_opening_bracket");
        WhiteSpaceOptions.createAfterOpenBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_closing_bracket");
        WhiteSpaceOptions.createBeforeClosingBracketTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.between_empty_brackets");
        WhiteSpaceOptions.createBetweenEmptyBracketsTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_operator");
        WhiteSpaceOptions.createBeforeOperatorTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_operator");
        WhiteSpaceOptions.createAfterOperatorTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_comma");
        WhiteSpaceOptions.createBeforeCommaTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_comma");
        WhiteSpaceOptions.createAfterCommaTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_colon");
        WhiteSpaceOptions.createAfterColonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_colon");
        WhiteSpaceOptions.createBeforeColonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_semicolon");
        WhiteSpaceOptions.createBeforeSemicolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_semicolon");
        WhiteSpaceOptions.createAfterSemicolonTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.before_question_mark");
        WhiteSpaceOptions.createBeforeQuestionTree(workingValues, parent);
        parent = WhiteSpaceOptions.createParentNode(roots, workingValues, "WhiteSpaceOptions.after_question_mark");
        WhiteSpaceOptions.createAfterQuestionTree(workingValues, parent);
        return roots;
    }

    private static InnerNode createParentNode(List roots, Map workingValues, String text) {
        InnerNode parent = new InnerNode(null, workingValues, text);
        roots.add(parent);
        return parent;
    }

    public static ArrayList createTreeByJavaElement(Map workingValues) {
        InnerNode declarations = new InnerNode(null, workingValues, "WhiteSpaceTabPage.declarations");
        WhiteSpaceOptions.createClassTree(workingValues, declarations);
        WhiteSpaceOptions.createFieldTree(workingValues, declarations);
        WhiteSpaceOptions.createLocalVariableTree(workingValues, declarations);
        WhiteSpaceOptions.createConstructorTree(workingValues, declarations);
        WhiteSpaceOptions.createMethodDeclTree(workingValues, declarations);
        WhiteSpaceOptions.createLabelTree(workingValues, declarations);
        InnerNode statements = new InnerNode(null, workingValues, "WhiteSpaceTabPage.statements");
        WhiteSpaceOptions.createOption(statements, workingValues, "WhiteSpaceOptions.before_semicolon", "org.eclipse.jdt.core.formatter.insert_space_before_semicolon", SEMICOLON_PREVIEW);
        WhiteSpaceOptions.createBlockTree(workingValues, statements);
        WhiteSpaceOptions.createIfStatementTree(workingValues, statements);
        WhiteSpaceOptions.createForStatementTree(workingValues, statements);
        WhiteSpaceOptions.createSwitchStatementTree(workingValues, statements);
        WhiteSpaceOptions.createDoWhileTree(workingValues, statements);
        WhiteSpaceOptions.createSynchronizedTree(workingValues, statements);
        WhiteSpaceOptions.createTryStatementTree(workingValues, statements);
        WhiteSpaceOptions.createAssertTree(workingValues, statements);
        InnerNode expressions = new InnerNode(null, workingValues, "WhiteSpaceTabPage.expressions");
        WhiteSpaceOptions.createFunctionCallTree(workingValues, expressions);
        WhiteSpaceOptions.createAssignmentTree(workingValues, expressions);
        WhiteSpaceOptions.createOperatorTree(workingValues, expressions);
        WhiteSpaceOptions.createParenthesizedExpressionTree(workingValues, expressions);
        WhiteSpaceOptions.createTypecastTree(workingValues, expressions);
        WhiteSpaceOptions.createConditionalTree(workingValues, expressions);
        InnerNode arrays = new InnerNode(null, workingValues, "WhiteSpaceTabPage.arrays");
        WhiteSpaceOptions.createArrayDeclarationTree(workingValues, arrays);
        WhiteSpaceOptions.createArrayAllocTree(workingValues, arrays);
        WhiteSpaceOptions.createArrayInitializerTree(workingValues, arrays);
        WhiteSpaceOptions.createArrayElementAccessTree(workingValues, arrays);
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        roots.add(declarations);
        roots.add(statements);
        roots.add(expressions);
        roots.add(arrays);
        return roots;
    }

    private static void createBeforeQuestionTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.conditional", "org.eclipse.jdt.core.formatter.insert_space_before_question_in_conditional", CONDITIONAL_PREVIEW);
    }

    private static void createBeforeSemicolonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.for", "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.statements", "org.eclipse.jdt.core.formatter.insert_space_before_semicolon", SEMICOLON_PREVIEW);
    }

    private static void createBeforeColonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.assert", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_assert", ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.conditional", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.label", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_labeled_statement", LABEL_PREVIEW);
        InnerNode switchStatement = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.switch");
        WhiteSpaceOptions.createOption(switchStatement, workingValues, "WhiteSpaceOptions.case", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_case", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, "WhiteSpaceOptions.default", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_default", SWITCH_PREVIEW);
    }

    private static void createBeforeCommaTree(Map workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.for");
        WhiteSpaceOptions.createOption(forStatement, workingValues, "WhiteSpaceOptions.initialization", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, "WhiteSpaceOptions.incrementation", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_increments", FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.arguments");
        WhiteSpaceOptions.createOption(invocation, workingValues, "WhiteSpaceOptions.method_call", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, "WhiteSpaceOptions.explicit_constructor_call", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, "WhiteSpaceOptions.alloc_expr", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_allocation_expression", ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.parameters");
        WhiteSpaceOptions.createOption(decl, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.throws");
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.mult_decls");
        WhiteSpaceOptions.createOption(multDecls, workingValues, "WhiteSpaceOptions.fields", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(multDecls, workingValues, "WhiteSpaceOptions.local_vars", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.initializer", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.implements_clause", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
    }

    private static void createBeforeOperatorTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.assignment_operator", "org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.unary_operator", "org.eclipse.jdt.core.formatter.insert_space_before_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.binary_operator", "org.eclipse.jdt.core.formatter.insert_space_before_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.prefix_operator", "org.eclipse.jdt.core.formatter.insert_space_before_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.postfix_operator", "org.eclipse.jdt.core.formatter.insert_space_before_postfix_operator", OPERATOR_PREVIEW);
    }

    private static void createBeforeClosingBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_alloc", "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_element_access", "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_reference", ARRAY_REF_PREVIEW);
    }

    private static void createBeforeOpenBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_decl", "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_type_reference", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_alloc", "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_element_access", "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
    }

    private static void createBeforeClosingBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_init", "org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", CLASS_DECL_PREVIEW);
    }

    private static void createBeforeOpenBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.class_decl", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.anon_class_decl", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_anonymous_type_declaration", ANON_CLASS_PREVIEW);
        InnerNode functionDecl = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.member_function_declaration");
        WhiteSpaceOptions.createOption(functionDecl, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.initializer", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.block", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block", BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.switch", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_switch", SWITCH_PREVIEW);
    }

    private static void createBeforeClosingParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.catch", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.for", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.if", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.switch", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.synchronized", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.while", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.type_cast", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_cast", CAST_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.member_function_declaration");
        WhiteSpaceOptions.createOption(decl, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.method_call", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.paren_expr", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
    }

    private static void createBeforeOpenParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.catch", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.for", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.if", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.switch", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.synchronized", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.while", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_while", WHILE_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.member_function_declaration");
        WhiteSpaceOptions.createOption(decls, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.method_call", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.paren_expr", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
    }

    private static void createAfterQuestionTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.conditional", "org.eclipse.jdt.core.formatter.insert_space_after_question_in_conditional", CONDITIONAL_PREVIEW);
    }

    private static void createAfterSemicolonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.for", "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_for", FOR_PREVIEW);
    }

    private static void createAfterColonTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.assert", "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_assert", ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.conditional", "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.label", "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_labeled_statement", LABEL_PREVIEW);
    }

    private static void createAfterCommaTree(Map workingValues, InnerNode parent) {
        InnerNode forStatement = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.for");
        WhiteSpaceOptions.createOption(forStatement, workingValues, "WhiteSpaceOptions.initialization", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(forStatement, workingValues, "WhiteSpaceOptions.incrementation", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_increments", FOR_PREVIEW);
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.arguments");
        WhiteSpaceOptions.createOption(invocation, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, "WhiteSpaceOptions.explicit_constructor_call", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(invocation, workingValues, "WhiteSpaceOptions.alloc_expr", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_allocation_expression", ALLOC_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.parameters");
        WhiteSpaceOptions.createOption(decl, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decl, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        InnerNode throwsDecl = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.throws");
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(throwsDecl, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        InnerNode multDecls = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.mult_decls");
        WhiteSpaceOptions.createOption(multDecls, workingValues, "WhiteSpaceOptions.fields", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(multDecls, workingValues, "WhiteSpaceOptions.local_vars", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.initializer", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.implements_clause", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
    }

    private static void createAfterOperatorTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.assignment_operator", "org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.unary_operator", "org.eclipse.jdt.core.formatter.insert_space_after_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.binary_operator", "org.eclipse.jdt.core.formatter.insert_space_after_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.prefix_operator", "org.eclipse.jdt.core.formatter.insert_space_after_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.postfix_operator", "org.eclipse.jdt.core.formatter.insert_space_after_postfix_operator", OPERATOR_PREVIEW);
    }

    private static void createAfterOpenBracketTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_alloc", "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_element_access", "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
    }

    private static void createAfterOpenBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.initializer", "org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
    }

    private static void createAfterCloseBraceTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.block", "org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block", BLOCK_PREVIEW);
    }

    private static void createAfterCloseParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.type_cast", "org.eclipse.jdt.core.formatter.insert_space_after_closing_paren_in_cast", CAST_PREVIEW);
    }

    private static void createAfterOpenParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.catch", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.for", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.if", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.switch", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.synchronized", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.while", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_while", WHILE_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, "WhiteSpaceOptions.member_function_declaration");
        WhiteSpaceOptions.createOption(decls, workingValues, "WhiteSpaceOptions.constructor", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(decls, workingValues, "WhiteSpaceOptions.method", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.type_cast", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.method_call", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.paren_expr", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
    }

    private static void createBetweenEmptyParenTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.constructor_decl", "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.method_decl", "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.method_call", "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", METHOD_CALL_PREVIEW);
    }

    private static void createBetweenEmptyBracketsTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_alloc", "org.eclipse.jdt.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.array_decl", "org.eclipse.jdt.core.formatter.insert_space_between_brackets_in_array_type_reference", ARRAY_DECL_PREVIEW);
    }

    private static void createBetweenEmptyBracesTree(Map workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, "WhiteSpaceOptions.initializer", "org.eclipse.jdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", ARRAY_DECL_PREVIEW);
    }

    private static InnerNode createClassTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.classes");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.classes.before_opening_brace_of_a_class", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.classes.before_opening_brace_of_anon_class", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_anonymous_type_declaration", ANON_CLASS_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.classes.before_comma_implements", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.classes.after_comma_implements", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_superinterfaces", CLASS_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createAssignmentTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.assignments");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.assignments.before_assignment_operator", "org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.assignments.after_assignment_operator", "org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", OPERATOR_PREVIEW);
        return root;
    }

    private static InnerNode createOperatorTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.operators");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.before_binary_operators", "org.eclipse.jdt.core.formatter.insert_space_before_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.after_binary_operators", "org.eclipse.jdt.core.formatter.insert_space_after_binary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.before_unary_operators", "org.eclipse.jdt.core.formatter.insert_space_before_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.after_unary_operators", "org.eclipse.jdt.core.formatter.insert_space_after_unary_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.before_prefix_operators", "org.eclipse.jdt.core.formatter.insert_space_before_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.after_prefix_operators", "org.eclipse.jdt.core.formatter.insert_space_after_prefix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.before_postfix_operators", "org.eclipse.jdt.core.formatter.insert_space_before_postfix_operator", OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.operators.after_postfix_operators", "org.eclipse.jdt.core.formatter.insert_space_after_postfix_operator", OPERATOR_PREVIEW);
        return root;
    }

    private static InnerNode createMethodDeclTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.methods");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.between_empty_parens", "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_brace", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_comma_in_params", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_comma_in_params", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_comma_in_throws", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_comma_in_throws", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_declaration_throws", METHOD_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createConstructorTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.constructors");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.between_empty_parens", "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_brace", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_constructor_declaration", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_comma_in_params", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_comma_in_params", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_parameters", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_comma_in_throws", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_comma_in_throws", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_constructor_declaration_throws", CONSTRUCTOR_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createFieldTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.fields");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.fields.before_comma", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_field_declarations", MULT_FIELD_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.fields.after_comma", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_field_declarations", MULT_LOCAL_PREVIEW);
        return root;
    }

    private static InnerNode createLocalVariableTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.localvars");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.localvars.before_comma", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.localvars.after_comma", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_multiple_local_declarations", MULT_LOCAL_PREVIEW);
        return root;
    }

    private static InnerNode createArrayInitializerTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.arrayinit");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_brace", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_brace", "org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_brace", "org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_comma", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_comma", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_array_initializer", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.between_empty_braces", "org.eclipse.jdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", ARRAY_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createArrayDeclarationTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.arraydecls");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_bracket", "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_type_reference", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.between_empty_brackets", "org.eclipse.jdt.core.formatter.insert_space_between_brackets_in_array_type_reference", ARRAY_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createArrayElementAccessTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.arrayelem");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_bracket", "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_bracket", "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_reference", ARRAY_REF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_bracket", "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_reference", ARRAY_REF_PREVIEW);
        return root;
    }

    private static InnerNode createArrayAllocTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.arrayalloc");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_bracket", "org.eclipse.jdt.core.formatter.insert_space_before_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_bracket", "org.eclipse.jdt.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_bracket", "org.eclipse.jdt.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.between_empty_brackets", "org.eclipse.jdt.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", ARRAY_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createFunctionCallTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.calls");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.between_empty_parens", "org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.calls.before_comma_in_method_args", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.calls.after_comma_in_method_args", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.calls.before_comma_in_alloc", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_allocation_expression", ALLOC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.calls.after_comma_in_alloc", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_allocation_expression", ALLOC_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.calls.before_comma_in_qalloc", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.calls.after_comma_in_qalloc", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_explicitconstructorcall_arguments", CONSTRUCTOR_DECL_PREVIEW);
        return root;
    }

    private static InnerNode createBlockTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.blocks");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_brace", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block", BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_closing_brace", "org.eclipse.jdt.core.formatter.insert_space_after_closing_brace_in_block", BLOCK_PREVIEW);
        return root;
    }

    private static InnerNode createSwitchStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.switch");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.switch.before_case_colon", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_case", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.switch.before_default_colon", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_default", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_brace", "org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_switch", SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_switch", SWITCH_PREVIEW);
        return root;
    }

    private static InnerNode createDoWhileTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.do");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_while", WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_while", WHILE_PREVIEW);
        return root;
    }

    private static InnerNode createSynchronizedTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.synchronized");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_synchronized", SYNCHRONIZED_PREVIEW);
        return root;
    }

    private static InnerNode createTryStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.try");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_catch", CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_catch", CATCH_PREVIEW);
        return root;
    }

    private static InnerNode createIfStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.if");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_if", IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_if", IF_PREVIEW);
        return root;
    }

    private static InnerNode createForStatementTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.for");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.for.before_comma_init", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.for.after_comma_init", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_inits", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.for.before_comma_inc", "org.eclipse.jdt.core.formatter.insert_space_before_comma_in_for_increments", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.for.after_comma_inc", "org.eclipse.jdt.core.formatter.insert_space_after_comma_in_for_increments", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_semicolon", "org.eclipse.jdt.core.formatter.insert_space_before_semicolon_in_for", FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_semicolon", "org.eclipse.jdt.core.formatter.insert_space_after_semicolon_in_for", FOR_PREVIEW);
        return root;
    }

    private static InnerNode createAssertTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.assert");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_colon", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_assert", ASSERT_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_colon", "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_assert", ASSERT_PREVIEW);
        return root;
    }

    private static InnerNode createLabelTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.labels");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_colon", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_labeled_statement", LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_colon", "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_labeled_statement", LABEL_PREVIEW);
        return root;
    }

    private static InnerNode createConditionalTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.conditionals");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_question", "org.eclipse.jdt.core.formatter.insert_space_before_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_question", "org.eclipse.jdt.core.formatter.insert_space_after_question_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_colon", "org.eclipse.jdt.core.formatter.insert_space_before_colon_in_conditional", CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_colon", "org.eclipse.jdt.core.formatter.insert_space_after_colon_in_conditional", CONDITIONAL_PREVIEW);
        return root;
    }

    private static InnerNode createTypecastTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.typecasts");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_cast", CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_after_closing_paren_in_cast", CAST_PREVIEW);
        return root;
    }

    private static InnerNode createParenthesizedExpressionTree(Map workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, "WhiteSpaceTabPage.parenexpr");
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.after_opening_paren", "org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, "WhiteSpaceTabPage.before_closing_paren", "org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", PAREN_EXPR_PREVIEW);
        return root;
    }

    private static InnerNode createChild(InnerNode root, Map workingValues, String messageKey) {
        return new InnerNode(root, workingValues, messageKey);
    }

    private static OptionNode createOption(InnerNode root, Map workingValues, String messageKey, String key, SnippetPreview.PreviewSnippet snippet) {
        return new OptionNode(root, workingValues, messageKey, key, snippet);
    }

    public static void makeIndexForNodes(List tree, List flatList) {
        Iterator iter = tree.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            node.index = flatList.size();
            flatList.add(node);
            WhiteSpaceOptions.makeIndexForNodes(node.getChildren(), flatList);
        }
    }

    public static abstract class Node {
        private final InnerNode fParent;
        private final String fName;
        public int index;
        protected final Map fWorkingValues;
        protected final ArrayList fChildren;

        public Node(InnerNode parent, Map workingValues, String messageKey) {
            if (workingValues == null || messageKey == null) {
                throw new IllegalArgumentException();
            }
            this.fParent = parent;
            this.fWorkingValues = workingValues;
            this.fName = FormatterMessages.getString(messageKey);
            this.fChildren = new ArrayList();
            if (this.fParent != null) {
                this.fParent.add(this);
            }
        }

        public abstract void setChecked(boolean var1);

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public List getChildren() {
            return Collections.unmodifiableList(this.fChildren);
        }

        public InnerNode getParent() {
            return this.fParent;
        }

        public final String toString() {
            return this.fName;
        }

        public abstract List getSnippets();

        public abstract void getCheckedLeafs(List var1);
    }

    public static class InnerNode
    extends Node {
        public InnerNode(InnerNode parent, Map workingValues, String messageKey) {
            super(parent, workingValues, messageKey);
        }

        public void setChecked(boolean checked) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).setChecked(checked);
            }
        }

        public void add(Node child) {
            this.fChildren.add(child);
        }

        public List getSnippets() {
            ArrayList snippets = new ArrayList(this.fChildren.size());
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                List childSnippets = ((Node)iter.next()).getSnippets();
                Iterator chIter = childSnippets.iterator();
                while (chIter.hasNext()) {
                    Object snippet = chIter.next();
                    if (snippets.contains(snippet)) continue;
                    snippets.add(snippet);
                }
            }
            return snippets;
        }

        public void getCheckedLeafs(List list) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((Node)iter.next()).getCheckedLeafs(list);
            }
        }
    }

    public static class OptionNode
    extends Node {
        private final String fKey;
        private final ArrayList fSnippets;

        public OptionNode(InnerNode parent, Map workingValues, String messageKey, String key, SnippetPreview.PreviewSnippet snippet) {
            super(parent, workingValues, messageKey);
            this.fKey = key;
            this.fSnippets = new ArrayList(1);
            this.fSnippets.add(snippet);
        }

        public void setChecked(boolean checked) {
            this.fWorkingValues.put(this.fKey, checked ? "insert" : "do not insert");
        }

        public boolean getChecked() {
            return "insert".equals(this.fWorkingValues.get(this.fKey));
        }

        public List getSnippets() {
            return this.fSnippets;
        }

        public void getCheckedLeafs(List list) {
            if (this.getChecked()) {
                list.add(this);
            }
        }
    }
}

