/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.search.GotoMarkerAction;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesGroupKey;
import org.eclipse.jdt.internal.ui.search.OccurrencesInFileLabelProvider;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class OccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private CompilationUnit fRoot;
    private Name fSelectedNode;
    private IBinding fTarget;
    private List fUsages = new ArrayList();
    private List fWriteUsages = new ArrayList();

    public OccurrencesFinder(IBinding target) {
        super(true);
        this.fTarget = target;
    }

    public OccurrencesFinder() {
        super(true);
    }

    public String initialize(CompilationUnit root, int offset, int length) {
        ASTNode node = NodeFinder.perform((ASTNode)root, offset, length);
        if (!(node instanceof Name)) {
            return SearchMessages.getString("OccurrencesFinder.no_element");
        }
        this.fRoot = root;
        this.fSelectedNode = (Name)node;
        this.fTarget = this.fSelectedNode.resolveBinding();
        if (this.fTarget == null) {
            return SearchMessages.getString("OccurrencesFinder.no_binding");
        }
        return null;
    }

    public List perform() {
        this.fRoot.accept((ASTVisitor)this);
        return this.fUsages;
    }

    public IMarker[] createMarkers(IResource file, IDocument document) throws CoreException {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        boolean isVariable = this.fTarget instanceof IVariableBinding;
        Iterator each = this.fUsages.iterator();
        while (each.hasNext()) {
            ASTNode node = (ASTNode)each.next();
            result.add(OccurrencesFinder.createMarker(file, document, node, this.fWriteUsages.contains(node), isVariable));
        }
        return result.toArray(new IMarker[result.size()]);
    }

    private static IMarker createMarker(IResource file, IDocument document, ASTNode node, boolean writeAccess, boolean isVariable) throws CoreException {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>(10);
        IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
        int startPosition = node.getStartPosition();
        MarkerUtilities.setCharStart(attributes, (int)startPosition);
        MarkerUtilities.setCharEnd(attributes, (int)(startPosition + node.getLength()));
        if (writeAccess) {
            attributes.put(IS_WRITEACCESS, new Boolean(true));
        }
        if (isVariable) {
            attributes.put(IS_VARIABLE, new Boolean(true));
        }
        try {
            int line = document.getLineOfOffset(startPosition);
            MarkerUtilities.setLineNumber(attributes, (int)line);
            IRegion region = document.getLineInformation(line);
            String lineContents = document.get(region.getOffset(), region.getLength());
            MarkerUtilities.setMessage(attributes, (String)lineContents.trim());
        }
        catch (BadLocationException badLocationException) {}
        marker.setAttributes(attributes);
        return marker;
    }

    public Match[] getOccurrenceMatches(IJavaElement element, IDocument document) {
        boolean isVariable = this.fTarget instanceof IVariableBinding;
        ArrayList<Match> matches = new ArrayList<Match>(this.fUsages.size());
        HashMap<Integer, OccurrencesGroupKey> lineToGroup = new HashMap<Integer, OccurrencesGroupKey>();
        Iterator iter = this.fUsages.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            try {
                boolean isWriteAccess = this.fWriteUsages.contains(node);
                int line = document.getLineOfOffset(startPosition);
                Integer lineInteger = new Integer(line);
                OccurrencesGroupKey groupKey = (OccurrencesGroupKey)lineToGroup.get(lineInteger);
                if (groupKey == null) {
                    IRegion region = document.getLineInformation(line);
                    String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                    groupKey = new OccurrencesGroupKey(element, line, lineContents, isWriteAccess, isVariable);
                    lineToGroup.put(lineInteger, groupKey);
                } else if (isWriteAccess) {
                    groupKey.setWriteAccess(true);
                }
                Match match = new Match((Object)groupKey, startPosition, length);
                matches.add(match);
            }
            catch (BadLocationException badLocationException) {}
        }
        return matches.toArray(new Match[matches.size()]);
    }

    public void searchStarted(ISearchResultView view, String inputName) {
        String elementName = ASTNodes.asString((ASTNode)this.fSelectedNode);
        view.searchStarted(null, this.getSingularLabel(elementName, inputName), this.getPluralLabelPattern(elementName, inputName), JavaPluginImages.DESC_OBJS_SEARCH_REF, "org.eclipse.jdt.ui.JavaFileSearch", (ILabelProvider)new OccurrencesInFileLabelProvider(), (IAction)new GotoMarkerAction(), (IGroupByKeyComputer)new IOccurrencesFinder.SearchGroupByKeyComputer(), null);
    }

    public String getJobLabel() {
        return SearchMessages.getString("OccurrencesFinder.searchfor");
    }

    public String getPluralLabelPattern(String documentName) {
        return this.getPluralLabelPattern(ASTNodes.asString((ASTNode)this.fSelectedNode), documentName);
    }

    public String getSingularLabel(String documentName) {
        return this.getSingularLabel(ASTNodes.asString((ASTNode)this.fSelectedNode), documentName);
    }

    private String getPluralLabelPattern(String nodeContents, String elementName) {
        Object[] args = new String[]{nodeContents, "{0}", elementName};
        return SearchMessages.getFormattedString("OccurrencesFinder.label.plural", args);
    }

    private String getSingularLabel(String nodeContents, String elementName) {
        Object[] args = new String[]{nodeContents, elementName};
        return SearchMessages.getFormattedString("OccurrencesFinder.label.singular", args);
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            SimpleName name = node.getName();
            return !this.match((Name)name, this.fUsages, name.resolveBinding());
        }
        return !this.match((Name)node, this.fUsages, node.resolveBinding());
    }

    public boolean visit(SimpleName node) {
        return !this.match((Name)node, this.fUsages, node.resolveBinding());
    }

    public boolean visit(ClassInstanceCreation node) {
        Name name = node.getName();
        if (name instanceof QualifiedName) {
            name = ((QualifiedName)name).getName();
        }
        this.match(name, this.fUsages, (IBinding)node.resolveConstructorBinding());
        return super.visit(node);
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        Name name = this.getName(lhs);
        if (name != null) {
            this.match(name, this.fWriteUsages, name.resolveBinding());
        }
        lhs.accept((ASTVisitor)this);
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (node.getInitializer() != null) {
            this.match((Name)node.getName(), this.fWriteUsages, (IBinding)node.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PrefixExpression node) {
        Expression operand;
        Name name;
        PrefixExpression.Operator operator = node.getOperator();
        if ((operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) && (name = this.getName(operand = node.getOperand())) != null) {
            this.match(name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        Name name = this.getName(operand);
        if (name != null) {
            this.match(name, this.fWriteUsages, name.resolveBinding());
        }
        return super.visit(node);
    }

    private boolean match(Name node, List result, IBinding binding) {
        if (binding != null && Bindings.equals(binding, this.fTarget)) {
            result.add(node);
            return true;
        }
        return false;
    }

    private Name getName(Expression expression) {
        if (expression instanceof SimpleName) {
            return (SimpleName)expression;
        }
        if (expression instanceof QualifiedName) {
            return (QualifiedName)expression;
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        return null;
    }
}

