/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public abstract class SearchLabelProvider
extends LabelProvider
implements IColorProvider,
IPropertyChangeListener {
    public static final String PROPERTY_MATCH_COUNT = "org.eclipse.jdt.search.matchCount";
    private Color fPotentialMatchFgColor;
    private Map fLabelProviderMap;
    protected JavaSearchResultPage fPage;
    private AppearanceAwareLabelProvider fLabelProvider;

    public SearchLabelProvider(JavaSearchResultPage page, AppearanceAwareLabelProvider inner) {
        this.fPage = page;
        this.fLabelProvider = inner;
        this.fLabelProviderMap = new HashMap(5);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator());
        SearchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fPotentialMatchFgColor == null) {
            return;
        }
        if ("org.eclipse.search.potentialMatch.fgColor".equals(event.getProperty()) || "org.eclipse.search.potentialMatch.emphasize".equals(event.getProperty())) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
            LabelProviderChangedEvent lpEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
            this.fireLabelProviderChanged(lpEvent);
        }
    }

    public AppearanceAwareLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public Color getForeground(Object element) {
        if (SearchPreferencePage.arePotentialMatchesEmphasized() && this.hasPotentialMatches(element)) {
            return this.getForegroundColor();
        }
        if (this.fLabelProvider != null) {
            return this.fLabelProvider.getForeground(element);
        }
        return null;
    }

    protected boolean hasPotentialMatches(Object element) {
        AbstractTextSearchResult result = this.fPage.getInput();
        if (result != null) {
            Match[] matches = result.getMatches(element);
            int i = 0;
            while (i < matches.length) {
                if (matches[i] instanceof JavaElementMatch && ((JavaElementMatch)matches[i]).getAccuracy() == 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Color getBackground(Object element) {
        if (this.fLabelProvider != null) {
            return this.fLabelProvider.getBackground(element);
        }
        return null;
    }

    private Color getForegroundColor() {
        if (this.fPotentialMatchFgColor == null) {
            this.fPotentialMatchFgColor = new Color((Device)JavaPlugin.getActiveWorkbenchShell().getDisplay(), SearchPreferencePage.getPotentialMatchForegroundColor());
        }
        return this.fPotentialMatchFgColor;
    }

    public void dispose() {
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
        }
        SearchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fLabelProvider.dispose();
        Iterator labelProviders = this.fLabelProviderMap.values().iterator();
        while (labelProviders.hasNext()) {
            ILabelProvider labelProvider = (ILabelProvider)labelProviders.next();
            labelProvider.dispose();
        }
        super.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.getLabelProvider().addListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        if (PROPERTY_MATCH_COUNT.equals(property)) {
            return true;
        }
        return this.getLabelProvider().isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.getLabelProvider().removeListener(listener);
    }

    protected String getParticipantText(Object element) {
        ILabelProvider labelProvider = this.getLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getText(element);
        }
        return "";
    }

    protected Image getParticipantImage(Object element) {
        ILabelProvider lp = this.getLabelProvider(element);
        if (lp == null) {
            return null;
        }
        return lp.getImage(element);
    }

    private ILabelProvider getLabelProvider(Object element) {
        IMatchPresentation participant = ((JavaSearchResult)this.fPage.getInput()).getSearchParticpant(element);
        if (participant == null) {
            return null;
        }
        ILabelProvider lp = (ILabelProvider)this.fLabelProviderMap.get(participant);
        if (lp == null) {
            lp = participant.createLabelProvider();
            this.fLabelProviderMap.put(participant, lp);
        }
        return lp;
    }
}

