/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;

public class ASTResolving {
    private static final PrimitiveType.Code[] CODE_ORDER = new PrimitiveType.Code[]{PrimitiveType.CHAR, PrimitiveType.SHORT, PrimitiveType.INT, PrimitiveType.LONG, PrimitiveType.FLOAT, PrimitiveType.DOUBLE};

    public static ITypeBinding guessBindingForReference(ASTNode node) {
        return Bindings.normalizeTypeBinding(ASTResolving.getPossibleReferenceBinding(node));
    }

    private static ITypeBinding getPossibleReferenceBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 7: {
                Assignment assignment = (Assignment)parent;
                if (node.equals((Object)assignment.getLeftHandSide())) {
                    return assignment.getRightHandSide().resolveTypeBinding();
                }
                return assignment.getLeftHandSide().resolveTypeBinding();
            }
            case 27: {
                InfixExpression infix = (InfixExpression)parent;
                InfixExpression.Operator op = infix.getOperator();
                if (op == InfixExpression.Operator.CONDITIONAL_AND || op == InfixExpression.Operator.CONDITIONAL_OR) {
                    return infix.getAST().resolveWellKnownType("boolean");
                }
                if (op == InfixExpression.Operator.LEFT_SHIFT || op == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED || op == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
                    return infix.getAST().resolveWellKnownType("int");
                }
                if (node.equals((Object)infix.getLeftOperand())) {
                    ITypeBinding rigthHandBinding = infix.getRightOperand().resolveTypeBinding();
                    if (rigthHandBinding != null) {
                        return rigthHandBinding;
                    }
                } else {
                    ITypeBinding leftHandBinding = infix.getLeftOperand().resolveTypeBinding();
                    if (leftHandBinding != null) {
                        return leftHandBinding;
                    }
                }
                if (op == InfixExpression.Operator.EQUALS || op == InfixExpression.Operator.NOT_EQUALS) break;
                return infix.getAST().resolveWellKnownType("int");
            }
            case 62: {
                InstanceofExpression instanceofExpression = (InstanceofExpression)parent;
                return instanceofExpression.getRightOperand().resolveBinding();
            }
            case 59: {
                VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
                if (!frag.getInitializer().equals((Object)node)) break;
                return frag.getName().resolveTypeBinding();
            }
            case 48: {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
                IMethodBinding superMethodBinding = ASTNodes.getMethodBinding((Name)superMethodInvocation.getName());
                if (superMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superMethodInvocation.arguments(), superMethodBinding);
            }
            case 32: {
                MethodInvocation methodInvocation = (MethodInvocation)parent;
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, methodInvocation.arguments(), methodBinding);
            }
            case 46: {
                SuperConstructorInvocation superInvocation = (SuperConstructorInvocation)parent;
                IMethodBinding superBinding = superInvocation.resolveConstructorBinding();
                if (superBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superInvocation.arguments(), superBinding);
            }
            case 17: {
                ConstructorInvocation constrInvocation = (ConstructorInvocation)parent;
                IMethodBinding constrBinding = constrInvocation.resolveConstructorBinding();
                if (constrBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, constrInvocation.arguments(), constrBinding);
            }
            case 14: {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                IMethodBinding creationBinding = creation.resolveConstructorBinding();
                if (creationBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, creation.arguments(), creationBinding);
            }
            case 36: {
                return ASTResolving.guessBindingForReference(parent);
            }
            case 2: {
                if (((ArrayAccess)parent).getIndex().equals((Object)node)) {
                    return parent.getAST().resolveWellKnownType("int");
                }
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 3: {
                if (!((ArrayCreation)parent).dimensions().contains(node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 4: {
                ASTNode initializerParent = parent.getParent();
                int dim = 1;
                while (initializerParent instanceof ArrayInitializer) {
                    initializerParent = initializerParent.getParent();
                    ++dim;
                }
                ArrayType creationType = null;
                if (initializerParent instanceof ArrayCreation) {
                    creationType = ((ArrayCreation)initializerParent).getType();
                } else if (initializerParent instanceof VariableDeclaration) {
                    VariableDeclaration varDecl = (VariableDeclaration)initializerParent;
                    creationType = ASTNodes.getType(varDecl);
                    dim -= ASTNodes.getExtraDimensions(varDecl);
                }
                if (creationType == null) break;
                while (creationType instanceof ArrayType && dim > 0) {
                    creationType = creationType.getComponentType();
                    --dim;
                }
                return creationType.resolveBinding();
            }
            case 16: {
                ConditionalExpression expression = (ConditionalExpression)parent;
                if (node.equals((Object)expression.getExpression())) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                if (node.equals((Object)expression.getElseExpression())) {
                    return expression.getThenExpression().resolveTypeBinding();
                }
                return expression.getElseExpression().resolveTypeBinding();
            }
            case 37: {
                return parent.getAST().resolveWellKnownType("int");
            }
            case 38: {
                if (((PrefixExpression)parent).getOperator() == PrefixExpression.Operator.NOT) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                return parent.getAST().resolveWellKnownType("int");
            }
            case 19: 
            case 25: 
            case 61: {
                if (!(node instanceof Expression)) break;
                return parent.getAST().resolveWellKnownType("boolean");
            }
            case 50: {
                if (!((SwitchStatement)parent).getExpression().equals((Object)node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 41: {
                MethodDeclaration decl = ASTResolving.findParentMethodDeclaration(parent);
                if (decl == null) break;
                return decl.getReturnType().resolveBinding();
            }
            case 11: {
                return ((CastExpression)parent).getType().resolveBinding();
            }
            case 12: 
            case 53: {
                return parent.getAST().resolveWellKnownType("java.lang.Exception");
            }
            case 22: {
                if (!node.equals((Object)((FieldAccess)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 47: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 40: {
                if (!node.equals((Object)((QualifiedName)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 49: {
                if (!node.equals((Object)((SwitchCase)parent).getExpression()) || !(parent.getParent() instanceof SwitchStatement)) break;
                return ((SwitchStatement)parent.getParent()).getExpression().resolveTypeBinding();
            }
        }
        return null;
    }

    public static Type guessTypeForReference(AST ast, ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent != null) {
            switch (parent.getNodeType()) {
                case 59: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 44: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 2: {
                    Type type;
                    if (!((ArrayAccess)parent).getIndex().equals((Object)node) && (type = ASTResolving.guessTypeForReference(ast, parent)) != null) {
                        return ast.newArrayType(type);
                    }
                    return null;
                }
                case 22: {
                    if (node.equals((Object)((FieldAccess)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                case 36: 
                case 47: {
                    node = parent;
                    parent = parent.getParent();
                    break;
                }
                case 40: {
                    if (node.equals((Object)((QualifiedName)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static ITypeBinding getParameterTypeBinding(ASTNode node, List args, IMethodBinding binding) {
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        int index = args.indexOf(node);
        if (index >= 0 && index < paramTypes.length) {
            return paramTypes[index];
        }
        return null;
    }

    public static ITypeBinding guessBindingForTypeReference(ASTNode node) {
        return Bindings.normalizeTypeBinding(ASTResolving.getPossibleTypeBinding(node));
    }

    private static ITypeBinding getPossibleTypeBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent instanceof Type) {
            parent = parent.getParent();
        }
        switch (parent.getNodeType()) {
            case 60: {
                return ASTResolving.guessVariableType(((VariableDeclarationStatement)parent).fragments());
            }
            case 23: {
                return ASTResolving.guessVariableType(((FieldDeclaration)parent).fragments());
            }
            case 58: {
                return ASTResolving.guessVariableType(((VariableDeclarationExpression)parent).fragments());
            }
            case 44: {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)parent;
                if (varDecl.getInitializer() == null) break;
                return varDecl.getInitializer().resolveTypeBinding();
            }
            case 3: {
                ArrayCreation creation = (ArrayCreation)parent;
                if (creation.getInitializer() != null) {
                    return creation.getInitializer().resolveTypeBinding();
                }
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 14: 
            case 57: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 65: {
                List thrownExcpetions;
                ASTNode methNode;
                TagElement tagElement = (TagElement)parent;
                if (!"@throws".equals(tagElement.getTagName()) && !"@exception".equals(tagElement.getTagName()) || !((methNode = tagElement.getParent().getParent()) instanceof MethodDeclaration) || (thrownExcpetions = ((MethodDeclaration)methNode).thrownExceptions()).size() != 1) break;
                return ((Name)thrownExcpetions.get(0)).resolveTypeBinding();
            }
        }
        return null;
    }

    private static ITypeBinding guessVariableType(List fragments) {
        Iterator iter = fragments.iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)iter.next();
            if (frag.getInitializer() == null) continue;
            return frag.getInitializer().resolveTypeBinding();
        }
        return null;
    }

    public static ITypeBinding[] getQualifierGuess(ASTNode searchRoot, final String selector, List arguments) {
        final int nArgs = arguments.size();
        final ArrayList result = new ArrayList();
        Bindings.visitAllBindings(searchRoot, new TypeBindingVisitor(){
            private HashSet fVisitedBindings = new HashSet(100);

            public boolean visit(ITypeBinding node) {
                if (!this.fVisitedBindings.add(node.getKey())) {
                    return true;
                }
                IMethodBinding[] methods = node.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    IMethodBinding meth = methods[i];
                    if (meth.getName().equals(selector) && meth.getParameterTypes().length == nArgs) {
                        result.add(node);
                    }
                    ++i;
                }
                return true;
            }
        });
        return result.toArray(new ITypeBinding[result.size()]);
    }

    public static boolean hasQualifierGuess(ASTNode searchRoot, final String selector, List arguments) {
        final boolean[] res = new boolean[1];
        final int nArgs = arguments.size();
        Bindings.visitAllBindings(searchRoot, new TypeBindingVisitor(){
            private HashSet fVisitedBindings = new HashSet(100);

            public boolean visit(ITypeBinding node) {
                if (!this.fVisitedBindings.add(node.getKey())) {
                    return true;
                }
                IMethodBinding[] methods = node.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    IMethodBinding meth = methods[i];
                    if (meth.getName().equals(selector) && meth.getParameterTypes().length == nArgs) {
                        res[0] = true;
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        return res[0];
    }

    public static MethodDeclaration findParentMethodDeclaration(ASTNode node) {
        while (node != null && node.getNodeType() != 31) {
            node = node.getParent();
        }
        return (MethodDeclaration)node;
    }

    public static BodyDeclaration findParentBodyDeclaration(ASTNode node) {
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        return (BodyDeclaration)node;
    }

    public static CompilationUnit findParentCompilationUnit(ASTNode node) {
        return (CompilationUnit)ASTResolving.findAncestor(node, 15);
    }

    public static ASTNode findParentType(ASTNode node) {
        while (node != null && node.getNodeType() != 55 && node.getNodeType() != 1) {
            node = node.getParent();
        }
        return node;
    }

    public static ASTNode findAncestor(ASTNode node, int nodeType) {
        while (node != null && node.getNodeType() != nodeType) {
            node = node.getParent();
        }
        return node;
    }

    public static Statement findParentStatement(ASTNode node) {
        while (node != null && !(node instanceof Statement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (Statement)node;
    }

    public static TryStatement findParentTryStatement(ASTNode node) {
        while (node != null && !(node instanceof TryStatement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (TryStatement)node;
    }

    public static boolean isInStaticContext(ASTNode selectedNode) {
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            Statement statement;
            MethodDeclaration methodDecl = (MethodDeclaration)decl;
            if (methodDecl.isConstructor() && ((statement = ASTResolving.findParentStatement(selectedNode)) instanceof ConstructorInvocation || statement instanceof SuperConstructorInvocation)) {
                return true;
            }
            return Modifier.isStatic((int)methodDecl.getModifiers());
        }
        if (decl instanceof Initializer) {
            return Modifier.isStatic((int)((Initializer)decl).getModifiers());
        }
        if (decl instanceof FieldDeclaration) {
            return Modifier.isStatic((int)((FieldDeclaration)decl).getModifiers());
        }
        return false;
    }

    public static boolean isWriteAccess(Name selectedNode) {
        Name curr = selectedNode;
        ASTNode parent = curr.getParent();
        while (parent != null) {
            switch (parent.getNodeType()) {
                case 40: {
                    if (((QualifiedName)parent).getQualifier() != curr) break;
                    return false;
                }
                case 22: {
                    if (((FieldAccess)parent).getExpression() != curr) break;
                    return false;
                }
                case 47: {
                    break;
                }
                case 7: {
                    return ((Assignment)parent).getLeftHandSide() == curr;
                }
                case 44: 
                case 59: {
                    return ((VariableDeclaration)parent).getName() == curr;
                }
                case 37: 
                case 38: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            curr = parent;
            parent = curr.getParent();
        }
        return false;
    }

    public static Type getTypeFromTypeBinding(AST ast, ITypeBinding binding) {
        if (binding.isArray()) {
            int dim = binding.getDimensions();
            return ast.newArrayType(ASTResolving.getTypeFromTypeBinding(ast, binding.getElementType()), dim);
        }
        if (binding.isPrimitive()) {
            String name = binding.getName();
            return ast.newPrimitiveType(PrimitiveType.toCode((String)name));
        }
        if (!binding.isNullType() && !binding.isAnonymous()) {
            return ast.newSimpleType((Name)ast.newSimpleName(binding.getName()));
        }
        return null;
    }

    private static TypeDeclaration findTypeDeclaration(List decls, String name) {
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            TypeDeclaration decl;
            ASTNode elem = (ASTNode)iter.next();
            if (!(elem instanceof TypeDeclaration) || !name.equals((decl = (TypeDeclaration)elem).getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }

    public static TypeDeclaration findTypeDeclaration(CompilationUnit root, ITypeBinding binding) {
        ArrayList<String> names = new ArrayList<String>(5);
        while (binding != null) {
            names.add(binding.getName());
            binding = binding.getDeclaringClass();
        }
        List types = root.types();
        int i = names.size() - 1;
        while (i >= 0) {
            String name = (String)names.get(i);
            TypeDeclaration decl = ASTResolving.findTypeDeclaration(types, name);
            if (decl == null || i == 0) {
                return decl;
            }
            types = decl.bodyDeclarations();
            --i;
        }
        return null;
    }

    public static String getFullName(Name name) {
        return ASTNodes.asString((ASTNode)name);
    }

    public static ICompilationUnit findCompilationUnitForBinding(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding) throws JavaModelException {
        if (binding != null && binding.isFromSource() && astRoot.findDeclaringNode((IBinding)binding) == null) {
            ICompilationUnit targetCU = Bindings.findCompilationUnit(binding, cu.getJavaProject());
            if (targetCU != null) {
                return targetCU;
            }
            return null;
        }
        return cu;
    }

    public static ITypeBinding[] getRelaxingTypes(AST ast, ITypeBinding type) {
        ArrayList<ITypeBinding> res = new ArrayList<ITypeBinding>();
        res.add(type);
        if (type.isArray()) {
            res.add(ast.resolveWellKnownType("java.lang.Object"));
            res.add(ast.resolveWellKnownType("java.io.Serializable"));
            res.add(ast.resolveWellKnownType("java.lang.Cloneable"));
        } else if (type.isPrimitive()) {
            PrimitiveType.Code code = PrimitiveType.toCode((String)type.getName());
            boolean found = false;
            int i = 0;
            while (i < CODE_ORDER.length) {
                if (found) {
                    String typeName = CODE_ORDER[i].toString();
                    res.add(ast.resolveWellKnownType(typeName));
                }
                if (code == CODE_ORDER[i]) {
                    found = true;
                }
                ++i;
            }
        } else {
            ASTResolving.collectRelaxingTypes(res, type);
        }
        return res.toArray(new ITypeBinding[res.size()]);
    }

    private static void collectRelaxingTypes(Collection res, ITypeBinding type) {
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ITypeBinding curr = interfaces[i];
            if (!res.contains(curr)) {
                res.add(curr);
            }
            ASTResolving.collectRelaxingTypes(res, curr);
            ++i;
        }
        ITypeBinding binding = type.getSuperclass();
        if (binding != null) {
            if (!res.contains(binding)) {
                res.add(binding);
            }
            ASTResolving.collectRelaxingTypes(res, binding);
        }
    }

    public static String getBaseNameFromExpression(IJavaProject project, Expression assignedExpression) {
        String name = null;
        if (assignedExpression instanceof Name) {
            Name simpleNode = (Name)assignedExpression;
            IBinding binding = simpleNode.resolveBinding();
            String varName = ASTNodes.getSimpleNameIdentifier(simpleNode);
            if (binding instanceof IVariableBinding) {
                CompilationUnit astRoot;
                varName = ((IVariableBinding)binding).isField() ? NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)project, (String)varName, (int)binding.getModifiers()) : ((astRoot = (CompilationUnit)assignedExpression.getRoot()).findDeclaringNode(binding) instanceof SingleVariableDeclaration ? NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)project, (String)varName) : NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)project, (String)varName));
            }
            return varName;
        }
        if (assignedExpression instanceof MethodInvocation) {
            name = ((MethodInvocation)assignedExpression).getName().getIdentifier();
        } else if (assignedExpression instanceof SuperMethodInvocation) {
            name = ((SuperMethodInvocation)assignedExpression).getName().getIdentifier();
        }
        if (name != null && name.length() > 3 && name.startsWith("get")) {
            return name.substring(3);
        }
        return null;
    }
}

