/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.ExperimentalProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.internal.ui.text.java.ResultCollector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;

public class ExperimentalResultCollector
extends ResultCollector {
    private ITextViewer fViewer;

    private static boolean appendArguments(ITextViewer viewer, int offset) {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("content_assist_insert_completion")) {
            return true;
        }
        if (viewer == null) {
            return true;
        }
        try {
            IDocument document = viewer.getDocument();
            IRegion region = document.getLineInformationOfOffset(offset);
            String line = document.get(region.getOffset(), region.getLength());
            int index = offset - region.getOffset();
            while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                ++index;
            }
            if (index == line.length()) {
                return true;
            }
            return line.charAt(index) != '(';
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    protected JavaCompletionProposal createMethodCallCompletion(char[] declaringTypeName, char[] name, char[][] parameterTypePackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypeName, char[] completionName, int modifiers, int start, int end, int relevance) {
        int[] lengths;
        int[] offsets;
        JavaCompletionProposal original = super.createMethodCallCompletion(declaringTypeName, name, parameterTypePackageNames, parameterTypeNames, parameterNames, returnTypeName, completionName, modifiers, start, end, relevance);
        if (completionName.length == 0 || completionName.length == 1 && completionName[0] == ')') {
            return original;
        }
        if (parameterNames.length == 0) {
            return original;
        }
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("content_assist_guess_method_arguments")) {
            return new ParameterGuessingProposal("" + name + '(', start, end - start, original.getImage(), original.getDisplayString(), this.fViewer, relevance, name, parameterTypePackageNames, parameterTypeNames, parameterNames, this.fCodeAssistOffset, this.fCompilationUnit);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(name);
        if (ExperimentalResultCollector.appendArguments(this.fViewer, start)) {
            int count = parameterNames.length;
            offsets = new int[count];
            lengths = new int[count];
            buffer.append('(');
            int i = 0;
            while (i != count) {
                if (i != 0) {
                    buffer.append(", ");
                }
                offsets[i] = buffer.length();
                buffer.append(parameterNames[i]);
                lengths[i] = buffer.length() - offsets[i];
                ++i;
            }
            buffer.append(')');
        } else {
            boolean count = false;
            offsets = new int[]{};
            lengths = new int[]{};
        }
        return new ExperimentalProposal(buffer.toString(), start, end - start, original.getImage(), original.getDisplayString(), offsets, lengths, this.fViewer, relevance);
    }

    public void setViewer(ITextViewer viewer) {
        this.fViewer = viewer;
    }
}

