/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.ui.IWorkingCopyProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected TreeViewer fViewer;
    private ViewerFilter fWorkingSetFilter;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fTypeHierarchy = lifecycle;
        this.fMemberFilter = null;
        this.fWorkingSetFilter = null;
    }

    public final void setMemberFilter(IMember[] memberFilter) {
        this.fMemberFilter = memberFilter;
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void setWorkingSetFilter(ViewerFilter filter) {
        this.fWorkingSetFilter = filter;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public Object[] getElements(Object parent) {
        ArrayList types = new ArrayList();
        this.getRootTypes(types);
        int i = types.size() - 1;
        while (i >= 0) {
            IType curr = (IType)types.get(i);
            try {
                if (!this.isInTree(curr)) {
                    types.remove(i);
                }
            }
            catch (JavaModelException javaModelException) {}
            --i;
        }
        return types.toArray();
    }

    protected void getRootTypes(List res) {
        IType input;
        ITypeHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null && (input = hierarchy.getType()) != null) {
            res.add(input);
        }
    }

    protected abstract void getTypesInHierarchy(IType var1, List var2);

    protected abstract IType getParentType(IType var1);

    private boolean isInScope(IType type) {
        if (this.fWorkingSetFilter != null && !this.fWorkingSetFilter.select(null, null, (Object)type)) {
            return false;
        }
        IJavaElement input = this.fTypeHierarchy.getInputElement();
        int inputType = input.getElementType();
        if (inputType == 7) {
            return true;
        }
        IJavaElement parent = type.getAncestor(input.getElementType());
        return inputType == 4 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                ArrayList children = new ArrayList();
                if (this.fMemberFilter != null) {
                    this.addFilteredMemberChildren(type, children);
                }
                this.addTypeChildren(type, children);
                return children.toArray();
            }
            catch (JavaModelException javaModelException) {}
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                return this.hasTypeChildren(type) || this.fMemberFilter != null && this.hasMemberFilterChildren(type);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private void addFilteredMemberChildren(IType parent, List children) throws JavaModelException {
        IMethod[] methods = parent.getMethods();
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMethod curr;
            IMethod meth;
            IMember member = this.fMemberFilter[i];
            if (parent.equals(member.getDeclaringType())) {
                if (!children.contains(member)) {
                    children.add(member);
                }
            } else if (member instanceof IMethod && (meth = JavaModelUtil.findMethod((curr = (IMethod)member).getElementName(), curr.getParameterTypes(), curr.isConstructor(), methods)) != null && !children.contains(meth)) {
                children.add(meth);
            }
            ++i;
        }
    }

    private void addTypeChildren(IType type, List children) throws JavaModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = (IType)types.get(i);
            if (this.isInTree(curr)) {
                children.add(curr);
            }
            ++i;
        }
    }

    protected final boolean isInTree(IType type) throws JavaModelException {
        if (this.isInScope(type)) {
            if (this.fMemberFilter != null) {
                return this.hasMemberFilterChildren(type) || this.hasTypeChildren(type);
            }
            return true;
        }
        return this.hasTypeChildren(type);
    }

    private boolean hasMemberFilterChildren(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMethod curr;
            IMethod meth;
            IMember member = this.fMemberFilter[i];
            if (type.equals(member.getDeclaringType())) {
                return true;
            }
            if (member instanceof IMethod && (meth = JavaModelUtil.findMethod((curr = (IMethod)member).getElementName(), curr.getParameterTypes(), curr.isConstructor(), methods)) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeChildren(IType type) throws JavaModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = (IType)types.get(i);
            if (this.isInTree(curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer part, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(part instanceof TreeViewer));
        this.fViewer = (TreeViewer)part;
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            if (member.getElementType() == 7) {
                return this.getParentType((IType)member);
            }
            return member.getDeclaringType();
        }
        return null;
    }

    protected final boolean isAnonymous(IType type) {
        return type.getElementName().length() == 0;
    }

    protected final boolean isObject(IType type) {
        return "Object".equals(type.getElementName()) && type.getDeclaringType() == null && "java.lang".equals(type.getPackageFragment().getElementName());
    }
}

