/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ExclusionInclusionEntryDialog
extends StatusDialog {
    private StringButtonDialogField fExclusionPatternDialog;
    private StatusInfo fExclusionPatternStatus;
    private IContainer fCurrSourceFolder;
    private String fExclusionPattern;
    private List fExistingPatterns;
    private boolean fIsExclusion;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExclusionInclusionEntryDialog(Shell parent, boolean isExclusion, String patternToEdit, List existingPatterns, CPListElement entryToEdit) {
        super(parent);
        IWorkspaceRoot root;
        IResource res;
        String message;
        String title;
        this.fIsExclusion = isExclusion;
        this.fExistingPatterns = existingPatterns;
        if (isExclusion) {
            title = patternToEdit == null ? NewWizardMessages.getString("ExclusionInclusionEntryDialog.exclude.add.title") : NewWizardMessages.getString("ExclusionInclusionEntryDialog.exclude.edit.title");
            message = NewWizardMessages.getFormattedString("ExclusionInclusionEntryDialog.exclude.pattern.label", entryToEdit.getPath().makeRelative().toString());
        } else {
            title = patternToEdit == null ? NewWizardMessages.getString("ExclusionInclusionEntryDialog.include.add.title") : NewWizardMessages.getString("ExclusionInclusionEntryDialog.include.edit.title");
            message = NewWizardMessages.getFormattedString("ExclusionInclusionEntryDialog.include.pattern.label", entryToEdit.getPath().makeRelative().toString());
        }
        this.setTitle(title);
        if (patternToEdit != null) {
            this.fExistingPatterns.remove(patternToEdit);
        }
        if ((res = (root = entryToEdit.getJavaProject().getProject().getWorkspace().getRoot()).findMember(entryToEdit.getPath())) instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        this.fExclusionPatternStatus = new StatusInfo();
        ExclusionPatternAdapter adapter = new ExclusionPatternAdapter();
        this.fExclusionPatternDialog = new StringButtonDialogField(adapter);
        this.fExclusionPatternDialog.setLabelText(message);
        this.fExclusionPatternDialog.setButtonLabel(NewWizardMessages.getString("ExclusionInclusionEntryDialog.pattern.button"));
        this.fExclusionPatternDialog.setDialogFieldListener(adapter);
        this.fExclusionPatternDialog.enableButton(this.fCurrSourceFolder != null);
        if (patternToEdit == null) {
            this.fExclusionPatternDialog.setText("");
        } else {
            this.fExclusionPatternDialog.setText(patternToEdit.toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int widthHint = this.convertWidthInCharsToPixels(60);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        Label description = new Label(inner, 64);
        if (this.fIsExclusion) {
            description.setText(NewWizardMessages.getString("ExclusionInclusionEntryDialog.exclude.description"));
        } else {
            description.setText(NewWizardMessages.getString("ExclusionInclusionEntryDialog.include.description"));
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        description.setLayoutData((Object)gd);
        this.fExclusionPatternDialog.doFillIntoGrid(inner, 3);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getLabelControl(null), widthHint);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternDialog.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fExclusionPatternDialog.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fExclusionPatternDialog.getTextControl(null));
        this.fExclusionPatternDialog.postSetFocusOnDialogField(parent.getDisplay());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doChangeControlPressed() {
        IPath pattern = this.chooseExclusionPattern();
        if (pattern != null) {
            this.fExclusionPatternDialog.setText(pattern.toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPatternValid();
        this.updateStatus(this.fExclusionPatternStatus);
    }

    protected void checkIfPatternValid() {
        String pattern = this.fExclusionPatternDialog.getText().trim();
        if (pattern.length() == 0) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.getString("ExclusionInclusionEntryDialog.error.empty"));
            return;
        }
        Path path = new Path(pattern);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.getString("ExclusionInclusionEntryDialog.error.notrelative"));
            return;
        }
        if (this.fExistingPatterns.contains(pattern)) {
            this.fExclusionPatternStatus.setError(NewWizardMessages.getString("ExclusionInclusionEntryDialog.error.exists"));
            return;
        }
        this.fExclusionPattern = pattern;
        this.fExclusionPatternStatus.setOK();
    }

    public String getExclusionPattern() {
        return this.fExclusionPattern;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.exclusion_pattern_dialog_context");
    }

    private IPath chooseExclusionPattern() {
        String message;
        String title;
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Path initialPath = new Path(this.fExclusionPatternDialog.getText());
        IResource initialElement = null;
        IContainer curr = this.fCurrSourceFolder;
        int nSegments = initialPath.segmentCount();
        int i = 0;
        while (i < nSegments) {
            IResource elem = curr.findMember(initialPath.segment(i));
            if (elem != null) {
                initialElement = elem;
            }
            if (!(elem instanceof IContainer)) break;
            curr = (IContainer)elem;
            ++i;
        }
        if (this.fIsExclusion) {
            title = NewWizardMessages.getString("ExclusionInclusionEntryDialog.ChooseExclusionPattern.title");
            message = NewWizardMessages.getString("ExclusionInclusionEntryDialog.ChooseExclusionPattern.description");
        } else {
            title = NewWizardMessages.getString("ExclusionInclusionEntryDialog.ChooseInclusionPattern.title");
            message = NewWizardMessages.getString("ExclusionInclusionEntryDialog.ChooseInclusionPattern.description");
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrSourceFolder);
        dialog.setInitialSelection((Object)initialElement);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            IResource res = (IResource)dialog.getFirstResult();
            IPath path = res.getFullPath().removeFirstSegments(this.fCurrSourceFolder.getFullPath().segmentCount()).makeRelative();
            if (res instanceof IContainer) {
                return path.addTrailingSeparator();
            }
            return path;
        }
        return null;
    }

    private class ExclusionPatternAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        ExclusionPatternAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            ExclusionInclusionEntryDialog.this.doStatusLineUpdate();
        }

        public void changeControlPressed(DialogField field) {
            ExclusionInclusionEntryDialog.this.doChangeControlPressed();
        }
    }
}

