/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProjectsWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private CheckedListDialogField fProjectsList;

    public ProjectsWorkbookPage(ListDialogField classPathList) {
        this.fClassPathList = classPathList;
        ProjectsListListener listener = new ProjectsListListener();
        String[] buttonLabels = new String[]{NewWizardMessages.getString("ProjectsWorkbookPage.projects.checkall.button"), NewWizardMessages.getString("ProjectsWorkbookPage.projects.uncheckall.button")};
        this.fProjectsList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fProjectsList.setDialogFieldListener(listener);
        this.fProjectsList.setLabelText(NewWizardMessages.getString("ProjectsWorkbookPage.projects.label"));
        this.fProjectsList.setCheckAllButtonIndex(0);
        this.fProjectsList.setUncheckAllButtonIndex(1);
        this.fProjectsList.setViewerSorter(new CPListElementSorter());
    }

    public void init(IJavaProject jproject) {
        this.updateProjectsList(jproject);
    }

    private void updateProjectsList(IJavaProject currJProject) {
        try {
            IJavaModel jmodel = currJProject.getJavaModel();
            IJavaProject[] jprojects = jmodel.getJavaProjects();
            ArrayList<CPListElement> projects = new ArrayList<CPListElement>(jprojects.length);
            ArrayList<Object> existingProjects = new ArrayList<Object>(jprojects.length);
            existingProjects.add(currJProject.getProject());
            ArrayList<CPListElement> checkedProjects = new ArrayList<CPListElement>(jprojects.length);
            List cpelements = this.fClassPathList.getElements();
            int i = cpelements.size() - 1;
            while (i >= 0) {
                CPListElement cpelem = (CPListElement)cpelements.get(i);
                if (this.isEntryKind(cpelem.getEntryKind())) {
                    existingProjects.add(cpelem.getResource());
                    projects.add(cpelem);
                    checkedProjects.add(cpelem);
                }
                --i;
            }
            i = 0;
            while (i < jprojects.length) {
                IProject proj = jprojects[i].getProject();
                if (!existingProjects.contains(proj)) {
                    projects.add(new CPListElement(this.fCurrJProject, 2, proj.getFullPath(), (IResource)proj));
                }
                ++i;
            }
            this.fProjectsList.setElements(projects);
            this.fProjectsList.setCheckedElements(checkedProjects);
        }
        catch (JavaModelException javaModelException) {
            this.fProjectsList.setElements(new ArrayList(5));
        }
        this.fCurrJProject = currJProject;
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fProjectsList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getListControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        return composite;
    }

    private void updateClasspathList() {
        List projelements = this.fProjectsList.getCheckedElements();
        boolean remove = false;
        List cpelements = this.fClassPathList.getElements();
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind()) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            cpelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    public boolean isEntryKind(int kind) {
        return kind == 2;
    }

    private class ProjectsListListener
    implements IDialogFieldListener {
        ProjectsListListener() {
        }

        public void dialogFieldChanged(DialogField field) {
            if (ProjectsWorkbookPage.this.fCurrJProject != null) {
                ProjectsWorkbookPage.this.updateClasspathList();
            }
        }
    }
}

