/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlockRetrieval;
import org.eclipse.debug.internal.core.memory.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.BasicDebugViewContentProvider;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewLine;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.TabItem;

public class MemoryViewContentProvider
extends BasicDebugViewContentProvider {
    private static final String PREFIX = "MemoryViewContentProvider.";
    private static final String UNABLE_TO_RETRIEVE_CONTENT = "MemoryViewContentProvider.Unable_to_retrieve_content";
    private static final String DEFAULT_PADDED_STR = "--";
    protected Vector lineCache;
    protected Hashtable contentCache;
    private BigInteger fBufferTopAddress;
    private BigInteger fBaseAddress;
    private IMemoryBlock fMemoryBlock;
    private TabItem fTabItem;
    private MemoryViewTab fViewTab;
    private boolean fLockRefresh = false;

    public MemoryViewContentProvider(IMemoryBlock memoryBlock, TabItem newTab) {
        this.fMemoryBlock = memoryBlock;
        this.fTabItem = newTab;
        this.lineCache = new Vector();
        this.contentCache = new Hashtable();
        this.fViewTab = (MemoryViewTab)this.fTabItem.getData();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    public Object[] getElements(Object parent) {
        if (this.lineCache.isEmpty()) {
            try {
                if (this.fMemoryBlock instanceof IExtendedMemoryBlock) {
                    BigInteger address = ((IExtendedMemoryBlock)this.fMemoryBlock).getBigBaseAddress();
                    if (address == null) {
                        address = new BigInteger("0");
                    }
                    MemoryViewTab viewTab = (MemoryViewTab)this.fTabItem.getData();
                    BigInteger bigInt = address;
                    viewTab.TABLE_PREBUFFER = bigInt.compareTo(BigInteger.valueOf(32L)) <= 0 ? 0 : bigInt.divide(BigInteger.valueOf(32L)).min(BigInteger.valueOf(viewTab.TABLE_DEFAULTBUFFER)).intValue();
                    address = bigInt.subtract(BigInteger.valueOf(this.fViewTab.getBytesPerLine() * viewTab.TABLE_PREBUFFER));
                    this.getMemoryToFitTable(address, this.fViewTab.getNumberOfVisibleLines() + viewTab.TABLE_PREBUFFER + viewTab.TABLE_POSTBUFFER, true);
                } else {
                    MemoryViewTab viewTab = (MemoryViewTab)this.fTabItem.getData();
                    viewTab.TABLE_PREBUFFER = 0;
                    viewTab.TABLE_POSTBUFFER = 0;
                    viewTab.TABLE_DEFAULTBUFFER = 0;
                    long startAddress = this.fMemoryBlock.getStartAddress();
                    BigInteger address = BigInteger.valueOf(startAddress);
                    long length = this.fMemoryBlock.getLength();
                    long numLines = length / (long)this.fViewTab.getBytesPerLine();
                    this.getMemoryToFitTable(address, numLines, true);
                }
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e.getStatus());
                ((MemoryViewTab)this.fTabItem.getData()).displayError(e);
                return this.lineCache.toArray();
            }
        }
        return this.lineCache.toArray();
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    public void getMemoryToFitTable(BigInteger startingAddress, long numberOfLines, boolean updateDelta) throws DebugException {
        int i;
        boolean error = false;
        DebugException dbgEvt = null;
        String adjustedAddress = startingAddress.toString(16);
        int addressSize = this.getAddressSize(startingAddress);
        int addressLength = addressSize * 2;
        if (this.fMemoryBlock instanceof IExtendedMemoryBlock && !adjustedAddress.endsWith("0")) {
            adjustedAddress = adjustedAddress.substring(0, adjustedAddress.length() - 1);
            adjustedAddress = String.valueOf(adjustedAddress) + "0";
            startingAddress = new BigInteger(adjustedAddress, 16);
        }
        IExtendedMemoryBlock extMemoryBlock = null;
        MemoryByte[] memoryBuffer = null;
        long reqNumBytes = (long)this.fViewTab.getBytesPerLine() * numberOfLines;
        String paddedString = DEFAULT_PADDED_STR;
        try {
            if (this.fMemoryBlock instanceof IExtendedMemoryBlock) {
                extMemoryBlock = (IExtendedMemoryBlock)this.fMemoryBlock;
                memoryBuffer = extMemoryBlock.getBytesFromAddress(startingAddress, reqNumBytes);
                if (memoryBuffer == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                IMemoryBlockRetrieval retrieval = extMemoryBlock.getMemoryBlockRetrieval();
                if (retrieval != null && retrieval instanceof IExtendedMemoryBlockRetrieval && (paddedString = ((IExtendedMemoryBlockRetrieval)retrieval).getPaddedString()) == null) {
                    paddedString = DEFAULT_PADDED_STR;
                }
            } else {
                byte[] memory = this.fMemoryBlock.getBytes();
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                memoryBuffer = new MemoryByte[memory.length];
                i = 0;
                while (i < memory.length) {
                    MByte tmp = new MByte();
                    tmp.value = memory[i];
                    tmp.flags = (byte)(tmp.flags | 2);
                    memoryBuffer[i] = tmp;
                    ++i;
                }
                paddedString = DEFAULT_PADDED_STR;
            }
        }
        catch (DebugException e) {
            memoryBuffer = this.makeDummyContent(numberOfLines);
            error = true;
            dbgEvt = e;
        }
        if ((long)memoryBuffer.length < reqNumBytes) {
            ArrayList<MemoryByte> newBuffer = new ArrayList<MemoryByte>();
            i = 0;
            while (i < memoryBuffer.length) {
                newBuffer.add(memoryBuffer[i]);
                ++i;
            }
            i = memoryBuffer.length;
            while ((long)i < reqNumBytes) {
                byte value = 0;
                byte flags = 0;
                flags = (byte)(flags | 1);
                newBuffer.add(new MByte(value, flags));
                ++i;
            }
        }
        if (!this.lineCache.isEmpty()) {
            this.lineCache.clear();
        }
        String address = startingAddress.toString(16);
        this.fBufferTopAddress = startingAddress;
        this.fBaseAddress = this.fMemoryBlock instanceof IExtendedMemoryBlock ? ((IExtendedMemoryBlock)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
        if (this.fBaseAddress == null) {
            this.fBaseAddress = new BigInteger("0");
        }
        this.fViewTab.setTabName(this.fMemoryBlock, true);
        boolean manageDelta = true;
        if (this.fMemoryBlock instanceof IExtendedMemoryBlock) {
            manageDelta = !((IExtendedMemoryBlock)this.fMemoryBlock).isMemoryChangesManaged();
        }
        int i2 = 0;
        while ((long)i2 < numberOfLines) {
            String tmpAddress = address.toUpperCase();
            if (tmpAddress.length() < addressLength) {
                int j = 0;
                while (tmpAddress.length() < addressLength) {
                    tmpAddress = "0" + tmpAddress;
                    ++j;
                }
            }
            MemoryByte[] memory = new MemoryByte[this.fViewTab.getBytesPerLine()];
            boolean isMonitored = true;
            int k = 0;
            int j = i2 * this.fViewTab.getBytesPerLine();
            while (j < i2 * this.fViewTab.getBytesPerLine() + this.fViewTab.getBytesPerLine()) {
                byte changeFlag = memoryBuffer[j].flags;
                if (manageDelta) {
                    changeFlag = (byte)(changeFlag | 4);
                    changeFlag = (byte)(changeFlag ^ 4);
                    changeFlag = (byte)(changeFlag | 8);
                    changeFlag = (byte)(changeFlag ^ 8);
                }
                MByte newByteObj = new MByte(memoryBuffer[j].value, changeFlag);
                memory[k] = newByteObj;
                ++k;
                if (!manageDelta && (memoryBuffer[j].flags & 4) == 0 && (memoryBuffer[j].flags & 8) == 0) {
                    isMonitored = false;
                }
                ++j;
            }
            MemoryViewLine newLine = new MemoryViewLine(tmpAddress, memory, this.lineCache.size(), paddedString);
            MemoryViewLine oldLine = (MemoryViewLine)this.contentCache.get(newLine.getAddress());
            if (manageDelta) {
                if (oldLine != null) {
                    newLine.isMonitored = true;
                }
            } else {
                newLine.isMonitored = isMonitored;
            }
            if (manageDelta) {
                if (updateDelta) {
                    if (oldLine != null) {
                        newLine.markDeltas(oldLine);
                    }
                } else if (oldLine != null) {
                    if (newLine.isLineChanged(oldLine)) {
                        newLine.markDeltas(oldLine);
                    } else {
                        newLine.copyDeltas(oldLine);
                    }
                }
            }
            this.lineCache.add(newLine);
            BigInteger bigInt = new BigInteger(address, 16);
            address = bigInt.add(BigInteger.valueOf(this.fViewTab.getBytesPerLine())).toString(16);
            ++i2;
        }
        if (error) {
            throw dbgEvt;
        }
    }

    private MemoryByte[] makeDummyContent(long numberOfLines) {
        int numBytes = (int)((long)this.fViewTab.getBytesPerLine() * numberOfLines);
        MemoryByte[] memoryBuffer = new MemoryByte[numBytes];
        int i = 0;
        while (i < memoryBuffer.length) {
            memoryBuffer[i] = new MByte();
            memoryBuffer[i].value = 0;
            memoryBuffer[i].flags = (byte)(memoryBuffer[i].flags | 1);
            ++i;
        }
        return memoryBuffer;
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        if (!(event.getSource() instanceof IDebugElement)) {
            return;
        }
        IDebugElement src = (IDebugElement)event.getSource();
        if (event.getKind() == 16 && event.getSource() == this.fMemoryBlock) {
            if (event.getDetail() == 256) {
                this.fViewTab.updateLabels();
            } else {
                this.updateContent();
            }
        }
        if (event.getKind() == 2 && src.getDebugTarget() == this.fMemoryBlock.getDebugTarget()) {
            this.updateContent();
        }
    }

    protected boolean isRefreshNeeded() {
        boolean refreshNeeded = false;
        try {
            if (this.isBaseAddressChanged()) {
                return true;
            }
            MemoryViewLine[] cached = this.lineCache.toArray(new MemoryViewLine[this.lineCache.size()]);
            ArrayList<MemoryByte> newMemory = new ArrayList<MemoryByte>();
            if (!(this.fMemoryBlock instanceof IExtendedMemoryBlock)) {
                byte[] memory = this.fMemoryBlock.getBytes();
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                int i = 0;
                while (i < memory.length) {
                    MByte tmp = new MByte();
                    tmp.value = memory[i];
                    tmp.flags = (byte)(tmp.flags | 2);
                    newMemory.add(tmp);
                    ++i;
                }
            } else {
                IExtendedMemoryBlock extMB = (IExtendedMemoryBlock)this.fMemoryBlock;
                MemoryByte[] memory = extMB.getBytesFromAddress(this.fBufferTopAddress, (long)(this.lineCache.size() * this.fViewTab.getBytesPerLine()));
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.getString(UNABLE_TO_RETRIEVE_CONTENT), null));
                    throw e;
                }
                int i = 0;
                while (i < memory.length) {
                    newMemory.add(memory[i]);
                    ++i;
                }
            }
            int i = 0;
            while (i < newMemory.size()) {
                MemoryByte newByte = (MemoryByte)newMemory.get(i);
                if (i / this.fViewTab.getBytesPerLine() >= cached.length) {
                    refreshNeeded = true;
                    break;
                }
                MemoryViewLine lineToCheck = cached[i / this.fViewTab.getBytesPerLine()];
                MemoryByte oldByte = lineToCheck.getByte(i % this.fViewTab.getBytesPerLine());
                if ((newByte.flags & 2) != (oldByte.flags & 2)) {
                    refreshNeeded = true;
                    break;
                }
                if ((newByte.flags & 2) == 2 && (oldByte.flags & 2) == 2 && newByte.value != oldByte.value) {
                    refreshNeeded = true;
                    break;
                }
                ++i;
            }
        }
        catch (DebugException e) {
            this.fViewTab.displayError(e);
            return false;
        }
        return refreshNeeded;
    }

    private boolean isBaseAddressChanged() {
        if (!(this.fMemoryBlock instanceof IExtendedMemoryBlock)) {
            return false;
        }
        IExtendedMemoryBlock extMB = (IExtendedMemoryBlock)this.fMemoryBlock;
        BigInteger newBaseAddress = extMB.getBigBaseAddress();
        if (newBaseAddress == null) {
            newBaseAddress = new BigInteger("0");
        }
        return newBaseAddress.compareTo(this.fBaseAddress) != 0;
    }

    public void forceRefresh() {
        if (!this.fLockRefresh) {
            this.fLockRefresh = true;
            this.refresh();
            this.fLockRefresh = false;
        }
    }

    protected void refresh() {
        super.refresh();
    }

    public void updateContent() {
        IDebugTarget dt = this.fMemoryBlock.getDebugTarget();
        if (dt.isDisconnected() || dt.isTerminated()) {
            return;
        }
        MemoryViewLine[] lines = this.lineCache.toArray(new MemoryViewLine[this.lineCache.size()]);
        if (this.contentCache != null) {
            this.contentCache.clear();
        }
        if (!this.fViewTab.isEnabled()) {
            return;
        }
        int i = 0;
        while (i < lines.length) {
            this.contentCache.put(lines[i].getAddress(), lines[i]);
            lines[i].isMonitored = true;
            ++i;
        }
        if (this.fViewTab.getMemoryBlock() instanceof IExtendedMemoryBlock && !((IExtendedMemoryBlock)this.fViewTab.getMemoryBlock()).isEnabled()) {
            ((IExtendedMemoryBlock)this.fViewTab.getMemoryBlock()).enable();
        }
        boolean updateTopAddress = false;
        if (this.isBaseAddressChanged()) {
            updateTopAddress = true;
            if (this.fMemoryBlock instanceof IExtendedMemoryBlock) {
                BigInteger address = ((IExtendedMemoryBlock)this.fMemoryBlock).getBigBaseAddress();
                if (address == null) {
                    address = new BigInteger("0");
                }
                this.fViewTab.setSelectedAddress(address, true);
            } else {
                BigInteger address = BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
                this.fViewTab.setSelectedAddress(address, true);
            }
        }
        this.resetDeltas();
        this.fViewTab.refresh();
        if (updateTopAddress) {
            this.fViewTab.updateSyncTopAddress(true);
        }
    }

    public BigInteger getBufferTopAddress() {
        return this.fBufferTopAddress;
    }

    public int getAddressSize(BigInteger address) {
        String adjustedAddress = address.toString(16);
        int addressSize = 0;
        if (this.fMemoryBlock instanceof IExtendedMemoryBlock) {
            addressSize = ((IExtendedMemoryBlock)this.fMemoryBlock).getAddressSize();
        }
        if (addressSize <= 0) {
            addressSize = adjustedAddress.length() > 8 ? 8 : 4;
        }
        return addressSize;
    }

    public BigInteger getContentBaseAddress() {
        return this.fBaseAddress;
    }

    public void resetDeltas() {
        Enumeration enumeration = this.contentCache.elements();
        while (enumeration.hasMoreElements()) {
            MemoryViewLine line = (MemoryViewLine)enumeration.nextElement();
            line.unmarkDeltas();
        }
    }

    protected boolean isAddressOutOfRange(BigInteger address) {
        if (this.lineCache != null) {
            MemoryViewLine first = (MemoryViewLine)this.lineCache.firstElement();
            MemoryViewLine last = (MemoryViewLine)this.lineCache.lastElement();
            if (first == null || last == null) {
                return true;
            }
            BigInteger startAddress = new BigInteger(first.getAddress(), 16);
            BigInteger lastAddress = new BigInteger(last.getAddress(), 16);
            lastAddress = lastAddress.add(BigInteger.valueOf(this.fViewTab.getBytesPerLine()));
            return startAddress.compareTo(address) > 0 || lastAddress.compareTo(address) < 0;
        }
        return true;
    }

    private class MByte
    extends MemoryByte {
        protected MByte(byte value, byte flags) {
            this.value = value;
            this.flags = flags;
        }

        protected MByte() {
        }
    }
}

