/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryAction;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractTableViewTabLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.IFixedLengthOutputRenderer;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.ITableMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrintViewTabAction
extends AbstractMemoryAction {
    TableViewer fViewer;
    private static final String PREFIX = "PrintViewTabAction.";
    private static final String TITLE = "PrintViewTabAction.title";
    private static final String TOOLTIP = "PrintViewTabAction.tooltip";
    private static final String JOB_TITLE = "PrintViewTabAction.jobtitle";
    private static final String COLUMN_SEPERATOR = "  ";

    public PrintViewTabAction() {
        super(DebugUIMessages.getString(TITLE));
        this.setToolTipText(DebugUIMessages.getString(TOOLTIP));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_PRINT_TOP_VIEW_TAB"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_PRINT_TOP_VIEW_TAB"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_PRINT_TOP_VIEW_TAB"));
    }

    private void printTable(TableItem[] itemList, GC printGC, Printer printer) {
        AbstractMemoryRenderer renderer;
        if (!(this.getViewTab() instanceof ITableMemoryViewTab)) {
            return;
        }
        String tableContents = new String();
        int numColumns = ((Table)this.fViewer.getControl()).getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
        int lineNum = 1;
        int charPerByte = 4;
        if (labelProvider instanceof AbstractTableViewTabLabelProvider && (renderer = ((AbstractTableViewTabLabelProvider)labelProvider).getRenderer()) instanceof IFixedLengthOutputRenderer) {
            charPerByte = ((IFixedLengthOutputRenderer)((Object)renderer)).getNumCharPerByte();
        }
        lineNum = this.printColumnLabels(printGC, lineNum);
        int i = 0;
        while (i < itemList.length) {
            tableContents = "";
            int j = 0;
            while (j < numColumns) {
                String columnText = labelProvider.getColumnText(itemList[i].getData(), j);
                while (columnText.length() < ((ITableMemoryViewTab)this.getViewTab()).getColumnSize() * charPerByte) {
                    columnText = String.valueOf(columnText) + " ";
                }
                tableContents = String.valueOf(tableContents) + COLUMN_SEPERATOR + columnText;
                ++j;
            }
            printGC.drawString(tableContents, 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
            if (20 + ++lineNum * printGC.getFontMetrics().getHeight() > printer.getClientArea().height) {
                lineNum = 1;
                printer.endPage();
                printer.startPage();
                lineNum = this.printColumnLabels(printGC, lineNum);
            }
            ++i;
        }
    }

    private int printColumnLabels(GC printGC, int lineNum) {
        AbstractMemoryRenderer renderer;
        if (!(this.getViewTab() instanceof ITableMemoryViewTab)) {
            return lineNum;
        }
        String tableContents = "";
        int numColumns = ((Table)this.fViewer.getControl()).getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
        TableColumn[] columns = ((Table)this.fViewer.getControl()).getColumns();
        int charPerByte = 4;
        if (labelProvider instanceof AbstractTableViewTabLabelProvider && (renderer = ((AbstractTableViewTabLabelProvider)labelProvider).getRenderer()) instanceof IFixedLengthOutputRenderer) {
            charPerByte = ((IFixedLengthOutputRenderer)((Object)renderer)).getNumCharPerByte();
        }
        int k = 0;
        while (k < numColumns) {
            StringBuffer columnLabel = new StringBuffer(columns[k].getText());
            int numBytes = 0;
            if (k > 0) {
                numBytes = ((ITableMemoryViewTab)this.getViewTab()).getColumnSize();
            } else {
                IMemoryBlock memBlock = this.getViewTab().getMemoryBlock();
                if (memBlock instanceof IExtendedMemoryBlock) {
                    numBytes = ((IExtendedMemoryBlock)memBlock).getAddressSize();
                    if (numBytes <= 0) {
                        numBytes = 4;
                    }
                } else {
                    numBytes = 4;
                }
            }
            while (columnLabel.length() < numBytes * charPerByte) {
                columnLabel.append(" ");
            }
            tableContents = String.valueOf(tableContents) + COLUMN_SEPERATOR + columnLabel;
            ++k;
        }
        printGC.drawString(tableContents, 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
        return ++lineNum;
    }

    public void run() {
        this.fViewer = ((MemoryViewTab)this.getViewTab()).getTableViewer();
        if (this.fViewer == null) {
            return;
        }
        if (this.fViewer.getControl() == null) {
            return;
        }
        PrintDialog printDialog = new PrintDialog(this.fViewer.getControl().getDisplay().getActiveShell());
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            this.setChecked(false);
            return;
        }
        Printer printer = new Printer(printerData);
        GC gc = new GC((Drawable)printer);
        TableItem[] tableItems = ((Table)this.fViewer.getControl()).getItems();
        printer.startJob(String.valueOf(DebugUIMessages.getString(JOB_TITLE)) + this.getViewTab().getTabLabel());
        printer.startPage();
        this.printTable(tableItems, gc, printer);
        printer.endPage();
        printer.endJob();
        gc.dispose();
        printer.dispose();
        this.setChecked(false);
    }

    IMemoryViewTab getViewTab() {
        return this.getTopViewTabFromView("org.eclipse.debug.ui.MemoryView");
    }
}

