/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import mergedoc.MergeDocException;
import mergedoc.xml.ConfigManager;

public class Persister {
    public static final Key DOC_DIR = new Key("api.document.directory");
    public static final Key IN_FILE = new Key("input.source.archeve.file");
    public static final Key OUT_FILE = new Key("output.source.archeve.file");
    public static final Key DOC_ENC = new Key("api.document.charset");
    public static final Key IN_ENC = new Key("input.source.charset");
    public static final Key OUT_ENC = new Key("output.source.charset");
    public static final Key REPLACE_DESCRIPTION_ARRAY = new Key("replace.entry.descprition");
    public static final Key WINDOW_WIDTH = new Key("window.dimention.width");
    public static final Key WINDOW_HEIGHT = new Key("window.dimention.height");
    public static final Key WINDOW_X = new Key("window.position.x");
    public static final Key WINDOW_Y = new Key("window.position.y");
    public static final Key WINDOW_STATE = new Key("window.state");
    public static final Key DETAIL_PANEL_HEIGHT = new Key("window.replace.panel.height");
    private final File parsistFile;
    private final Properties prop = new Properties();
    private static Persister parsister;

    private Persister() throws MergeDocException {
        ConfigManager configManager = ConfigManager.getInstance();
        this.parsistFile = configManager.getFile("mergedoc.properties");
        try {
            this.parsistFile.createNewFile();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.parsistFile));
            this.prop.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new MergeDocException(this.parsistFile + " \u306e\u64cd\u4f5c\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public static Persister getInstance() throws MergeDocException {
        if (parsister == null) {
            parsister = new Persister();
        }
        return parsister;
    }

    public void store() throws MergeDocException {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.parsistFile));
            this.prop.store(bufferedOutputStream, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new MergeDocException(this.parsistFile + " \u306e\u66f8\u304d\u8fbc\u307f\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public int size() {
        return this.prop.size();
    }

    public void setString(Key key, String string) {
        this.prop.setProperty(key.toString(), string == null ? "" : string);
    }

    public String getString(Key key) {
        return this.getString(key, null);
    }

    public String getString(Key key, String string) {
        String string2 = this.prop.getProperty(key.toString());
        return string2 == null ? string : string2;
    }

    public void setInt(Key key, int n) {
        this.setString(key, String.valueOf(n));
    }

    public int getInt(Key key) {
        return Integer.parseInt(this.getString(key));
    }

    public int getInt(Key key, int n) {
        try {
            return this.getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public void setStrings(Key key, String[] stringArray) {
        String string;
        int n = 0;
        while ((string = this.prop.getProperty(key.toString() + n)) != null) {
            this.prop.remove(key.toString() + n);
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.prop.setProperty(key.toString() + n, stringArray[n]);
        }
    }

    public String[] getStrings(Key key) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((string = this.prop.getProperty(key.toString() + n)) != null) {
            arrayList.add(string);
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static class Key {
        private final String str;

        private Key(String string) {
            this.str = string;
        }

        public String toString() {
            return this.str;
        }
    }
}

