/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatternCache {
    private static final Log log = LogFactory.getLog(PatternCache.class);
    private static final Map<String, Pattern> regexCache = new HashMap<String, Pattern>();
    private static final Map<String, Pattern> literalCache = new HashMap<String, Pattern>();

    private PatternCache() {
    }

    public static Pattern getPattern(String regex) {
        Pattern pattern = regexCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            regexCache.put(regex, pattern);
        }
        return pattern;
    }

    public static Pattern getLiteralPattern(String target) {
        Pattern pattern = literalCache.get(target);
        if (pattern == null) {
            pattern = Pattern.compile(target, 16);
            literalCache.put(target, pattern);
        }
        return pattern;
    }
}

