/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mergedoc.MergeDocException;
import mergedoc.core.FastStringUtils;
import mergedoc.xml.ListingHandler;
import mergedoc.xml.ReplaceEntry;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private static ConfigManager configManager;
    private final SAXParser saxParser;
    private final File configRoot;
    private final File globalXML;

    private ConfigManager() throws MergeDocException {
        try {
            this.saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MergeDocException("SAX \u30d1\u30fc\u30b5\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n" + e);
        }
        String globalXMLName = "/global.xml";
        URL url = this.getClass().getResource(globalXMLName);
        if (url == null) {
            throw new MergeDocException(globalXMLName + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        }
        this.globalXML = new File(url.getPath());
        String parent = null;
        try {
            parent = URLDecoder.decode(this.globalXML.getParent(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.configRoot = new File(parent);
    }

    public static ConfigManager getInstance() throws MergeDocException {
        if (configManager == null) {
            configManager = new ConfigManager();
        }
        return configManager;
    }

    public SAXParser getSAXPerser() {
        return this.saxParser;
    }

    public File getFile(String path) {
        return new File(this.configRoot, path);
    }

    public List<ReplaceEntry> getGlobalEntries() throws MergeDocException {
        ListingHandler handler = new ListingHandler();
        try {
            this.saxParser.parse(this.globalXML, (DefaultHandler)handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MergeDocException(this.globalXML.getName() + " \u306e\u30d1\u30fc\u30b9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n" + e);
        }
        return handler.getReplaceEntries();
    }

    public String getPrevewTemplate() throws MergeDocException {
        File file = this.getFile("preview.tpl");
        String template = null;
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] buf = new byte[((InputStream)is).available()];
            ((InputStream)is).read(buf);
            ((InputStream)is).close();
            template = new String(buf, "UTF-8");
        }
        catch (IOException e) {
            throw new MergeDocException(file + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        }
        template = FastStringUtils.optimizeLineSeparator(template);
        return template;
    }
}

