/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.aspect.AgentOption;
import jp.sourceforge.mergedoc.pleiades.aspect.ExcludesClassCache;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CachedDictionary;
import jp.sourceforge.mergedoc.pleiades.io.FileSystem;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import org.apache.commons.lang.ArrayUtils;

public class LauncherTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(LauncherTransformer.class);

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        if (className.equals("org.eclipse.core.launcher.Main")) {
            log.info("Eclipse \u306e\u8d77\u52d5\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002");
            CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
            CtMethod run = ctClass.getMethod("run", "([Ljava/lang/String;)I");
            run.insertBefore("$1 = " + this.getClass().getName() + ".startTranslationTransformer($$);");
            run.insertAfter(String.valueOf(this.getClass().getName()) + ".destroyTranslationTransformer();", true);
            if (!Agent.getInstance().getAgentOption().isDefaultSplash()) {
                File file = FileSystem.getResourceFile("splash.bmp");
                if (file.exists()) {
                    CtMethod searchForSplash = ctClass.getMethod("searchForSplash", "([Ljava/lang/String;)Ljava/lang/String;");
                    searchForSplash.setBody("return " + FileSystem.class.getName() + ".getResourceFile(\"splash.bmp\").getAbsolutePath();");
                } else {
                    log.warn("Pleiades \u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u753b\u50cf\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + file.getAbsolutePath());
                }
            }
            return ctClass.toBytecode();
        }
        if (className.equals("org.eclipse.ui.internal.Workbench")) {
            Agent.getInstance().getInstrumentation().removeTransformer(this);
            CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
            CtMethod runStartupWithProgress = ctClass.getMethod("runStartupWithProgress", "(ILjava/lang/Runnable;)V");
            runStartupWithProgress.insertAfter(String.valueOf(this.getClass().getName()) + ".startTime();");
            return ctClass.toBytecode();
        }
        return null;
    }

    public static void startTime() {
        long startTime = Long.valueOf(System.getProperty("eclipse.startTime"));
        double time = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        log.info(String.format("Eclipse \u306e\u8d77\u52d5\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\u51e6\u7406\u6642\u9593: %.3f \u79d2", time));
    }

    public static String[] startTranslationTransformer(String ... args) {
        String[] newArgs = args;
        Agent agent = Agent.getInstance();
        AgentOption agentOption = agent.getAgentOption();
        agentOption.setClean(Arrays.asList(args).contains("-clean"));
        if (!agentOption.isClean()) {
            boolean isClean = false;
            if (!ExcludesClassCache.file.exists()) {
                isClean = true;
                log.info("\u30a2\u30b9\u30da\u30af\u30c8\u9664\u5916\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002");
            }
            if (!CachedDictionary.cacheFile.exists() && !agentOption.isNoCache()) {
                isClean = true;
                log.info("\u8f9e\u66f8\u30ad\u30e3\u30c3\u30b7\u30e5\u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u3001\u5f37\u5236\u7684\u306b -clean \u30e2\u30fc\u30c9\u3067\u8d77\u52d5\u3057\u307e\u3059\u3002");
            }
            if (isClean) {
                newArgs = (String[])ArrayUtils.add((Object[])args, (Object)"-clean");
                agentOption.setClean(true);
            }
        }
        log.info("-clean: " + agentOption.isClean());
        agent.getInstrumentation().addTransformer(new TranslationTransformer());
        return newArgs;
    }

    public static void destroyTranslationTransformer() {
        TranslationTransformer.destroy();
    }
}

