/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.aspect.ExcludesClassCache;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationEditor;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DictionaryFactory;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(TranslationTransformer.class);

    public TranslationTransformer() {
        AspectMapping.getInstance();
        ExcludesClassCache.getInstance();
        DictionaryFactory.create();
        TranslationExcludeProperties.getInstance();
        RegexDictionary.getInstance();
    }

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        boolean isClean = Agent.getInstance().getAgentOption().isClean();
        ExcludesClassCache excludeList = ExcludesClassCache.getInstance();
        if (!isClean && excludeList.remove(className)) {
            return null;
        }
        CtClass ctClass = this.createCtClass(bytecode, protectionDomain);
        TranslationEditor editor = new TranslationEditor(ctClass);
        CtBehavior[] ctBehaviorArray = ctClass.getDeclaredBehaviors();
        int n = 0;
        int n2 = ctBehaviorArray.length;
        while (n < n2) {
            CtBehavior ctBehavior = ctBehaviorArray[n];
            ctBehavior.instrument((ExprEditor)editor);
            editor.editBehavior(ctBehavior);
            ++n;
        }
        CtConstructor ctInitializer = ctClass.getClassInitializer();
        if (ctInitializer != null) {
            ctInitializer.instrument((ExprEditor)editor);
        }
        byte[] editedBytecode = editor.toBytecode();
        if (isClean && editedBytecode == null) {
            excludeList.add(className);
        }
        return editedBytecode;
    }

    public static void destroy() {
        if (Agent.getInstance().getAgentOption().isClean()) {
            ExcludesClassCache.getInstance().store();
            DictionaryFactory.storeCache();
        }
    }
}

