/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.IDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.NotFoundLog;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.io.FileSystem;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDictionary
implements IDictionary {
    private static final Logger log = Logger.getLogger(AbstractDictionary.class);
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "translation.properties";
    private static final String ADDITIONS_DIRECTORY = "additions";
    private final Map<String, String> map = new HashMap<String, String>();

    protected AbstractDictionary() {
        this.load();
    }

    protected void load() {
        File file;
        File additions = FileSystem.getResourceFile(ADDITIONS_DIRECTORY);
        if (additions.exists()) {
            Object[] files = additions.listFiles();
            Arrays.sort(files);
            Object[] objectArray = files;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object file2 = objectArray[n];
                if (((File)file2).isFile() && ((File)file2).getName().endsWith(".properties")) {
                    this.map.putAll(this.loadProperties((File)file2));
                }
                ++n;
            }
        }
        if (!(file = FileSystem.getResourceFile(DEFAULT_PROPERTIES_FILE_NAME)).exists()) {
            FileNotFoundException e = new FileNotFoundException(file.getPath());
            log.fatal(e.toString(), e);
            throw new IllegalStateException(e);
        }
        this.map.putAll(this.loadProperties(file));
        log.info("\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.map.size());
    }

    protected Map<String, String> getMap() {
        return this.map;
    }

    private Map<? extends String, ? extends String> loadProperties(File file) {
        Properties prop = FileSystem.loadProperties(file);
        return prop;
    }

    @Override
    public String lookup(String enValue, JointPoint jointPoint) {
        if (enValue.matches("(?s)^.*?\\(\\&[\\w\\.]\\).*$")) {
            return enValue;
        }
        String enValueNonMnemonic = enValue.replaceFirst("\\&([\\w\\.])", "$1");
        String result = null;
        if (this.isNoTranslation(enValueNonMnemonic, jointPoint)) {
            result = enValue;
        } else {
            result = this.map.get(enValueNonMnemonic);
            if (result == null && enValue.matches("([\\p{ASCII}\u2018\u2019\u2026]+|\\[\\p{ASCII}+\\].+)") && (result = RegexDictionary.getInstance().lookup(enValueNonMnemonic)) == null) {
                NotFoundLog.getInstance().println(enValueNonMnemonic);
            }
            if (result == null) {
                result = enValue;
            }
        }
        result = this.editMnemonicEnToJa(enValue, enValueNonMnemonic, result);
        return result;
    }

    private boolean isNoTranslation(String enValueNonMnemonic, JointPoint jointPoint) {
        Set<String> noTransPathEntries;
        PointCut pointCut;
        List<String> excludeTrace;
        StackTraceElement[] stes = null;
        if (jointPoint != null && (excludeTrace = (pointCut = AspectMapping.getInstance().getPointCut(jointPoint)).getExcludeTrace()).size() > 0) {
            stes = Thread.currentThread().getStackTrace();
            for (String prefix : excludeTrace) {
                StackTraceElement[] stackTraceElementArray = stes;
                int n = 0;
                int n2 = stackTraceElementArray.length;
                while (n < n2) {
                    Object ste = stackTraceElementArray[n];
                    String className = ((StackTraceElement)ste).getClassName();
                    if (className.startsWith(prefix)) {
                        return true;
                    }
                    ++n;
                }
            }
        }
        if ((noTransPathEntries = TranslationExcludeProperties.getInstance().getPathEntries(enValueNonMnemonic)) != null) {
            if (stes == null) {
                stes = Thread.currentThread().getStackTrace();
            }
            StackTraceElement[] stackTraceElementArray = stes;
            int n = 0;
            int n3 = stackTraceElementArray.length;
            while (n < n3) {
                StackTraceElement ste = stackTraceElementArray[n];
                String className = ste.getClassName();
                for (String noTransPath : noTransPathEntries) {
                    if (!className.startsWith(noTransPath)) continue;
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private String editMnemonicEnToJa(String enValue, String enValueNonMnemonic, String result) {
        if (Agent.getInstance().getAgentOption().isNoMnemonic()) {
            return result;
        }
        if (enValue.equals(enValueNonMnemonic)) {
            return result;
        }
        String mnemonicChar = enValue.replaceFirst("(?s)^.*?\\&([\\w\\.]).*$", "$1");
        String mnemonicJa = "(&" + mnemonicChar.toUpperCase() + ")";
        if (mnemonicChar.length() != 1) {
            log.error("Mnemonic invalid length: " + mnemonicChar.length());
            log.error(" enValue:            " + enValue);
            log.error(" enValueNonMnemonic: " + enValueNonMnemonic);
            log.error(" mnemonicChar:       " + mnemonicChar);
            result = enValue;
        } else {
            result = result.replaceFirst("(?s)(@\\p{ASCII}+|\\s*|:\\s*|:\\s+\\{[0-9]\\}\\s*|\\.\\.\\.(</a>|)\\s*|(:|)\\s+\\(.+\\)\\s*)$", String.valueOf(mnemonicJa) + "$1");
        }
        return result;
    }
}

