/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DictionaryFactory;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.IDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class TranslationUtils {
    private static final Logger log = Logger.getLogger(TranslationUtils.class);
    private static final IDictionary dictionary = DictionaryFactory.create();
    private static final Map<String, String> comboMap = new HashMap<String, String>();

    private TranslationUtils() {
    }

    public static String translate(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        return dictionary.lookup(enValue, jointPoint);
    }

    public static String[] translate(String[] enValues, JointPoint jointPoint) {
        if (enValues == null) {
            return null;
        }
        int i = 0;
        while (i < enValues.length) {
            enValues[i] = TranslationUtils.translate(enValues[i], jointPoint);
            ++i;
        }
        return enValues;
    }

    public static Object translate(Object enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        if (enValue instanceof String) {
            return TranslationUtils.translate((String)enValue, jointPoint);
        }
        if (enValue instanceof String[]) {
            return TranslationUtils.translate((String[])enValue, jointPoint);
        }
        if (enValue instanceof Object[]) {
            return TranslationUtils.translate((Object[])enValue, jointPoint);
        }
        return enValue;
    }

    public static Object[] translate(Object[] enValue, JointPoint jointPoint) {
        if (enValue instanceof String[]) {
            return TranslationUtils.translate((String[])enValue, jointPoint);
        }
        return enValue;
    }

    public static String translateMenu(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        String[] splitsAccelerator = enValue.split("\t");
        String enMenuText = splitsAccelerator[0];
        if (!enMenuText.matches("\\p{ASCII}+")) {
            enMenuText = enMenuText.replaceFirst("^&", "");
        }
        if (splitsAccelerator.length == 1) {
            return dictionary.lookup(enMenuText, jointPoint);
        }
        return String.valueOf(dictionary.lookup(enMenuText, jointPoint)) + "\t" + splitsAccelerator[1];
    }

    public static String translateCombo(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        String jaValue = dictionary.lookup(enValue, jointPoint);
        comboMap.put(jaValue, enValue);
        return jaValue;
    }

    public static String[] translateCombo(String[] enValues, JointPoint jointPoint) {
        if (enValues == null) {
            return null;
        }
        int i = 0;
        while (i < enValues.length) {
            enValues[i] = TranslationUtils.translateCombo(enValues[i], jointPoint);
            ++i;
        }
        return enValues;
    }

    public static String restoreCombo(String jaValue, JointPoint jointPoint) {
        if (jaValue == null) {
            return null;
        }
        String enValue = comboMap.get(jaValue);
        if (enValue == null) {
            return jaValue;
        }
        return enValue;
    }

    public static String translateSentence(String enValue, JointPoint jointPoint) {
        if (enValue == null) {
            return null;
        }
        if (enValue.contains(" ")) {
            return dictionary.lookup(enValue, jointPoint);
        }
        return enValue;
    }

    public static void debug(Object value, JointPoint jointPoint) {
        log.info("Translator#debug " + (value == null ? "" : value.getClass().getName()) + "[" + value + "] -> [" + TranslationUtils.translate(value, jointPoint) + "]");
    }

    public static void debug(String[] value, JointPoint jointPoint) {
        log.info("Translator#debug " + (value == null ? "null" : String.valueOf(value.getClass().getName()) + Arrays.asList(value) + " -> " + Arrays.asList(TranslationUtils.translate(value, jointPoint))));
    }

    public static void printStackTrace(Object value, JointPoint jointPoint) {
        log.info("Translator#debug " + (value == null ? "" : value.getClass().getName()) + "[" + value + "] -> [" + TranslationUtils.translate(value, jointPoint) + "]", new Exception());
    }
}

