/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.PrintStream;
import java.util.Date;
import jp.sourceforge.mergedoc.pleiades.log.SystemOutLogger;

public abstract class Logger {
    public static final String LOGGER_CLASS_NAME = "pleiades.logger.class.name";
    public static final String LOG_LEVEL = "pleiades.log.level";
    private static Level level;
    private final String className;

    public static Logger getLogger(Class clazz) {
        if (level == null) {
            String logLevel = System.getProperty(LOG_LEVEL, Level.INFO.toString());
            try {
                level = Level.valueOf(logLevel.toUpperCase());
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3 pleiades.log.level=" + logLevel + " \u306b\u6307\u5b9a\u3059\u308b\u5024\u306f " + Level.class.getName() + "\u3067\u5b9a\u7fa9\u3055\u308c\u305f\u578b\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
        }
        String loggerClassName = System.getProperty(LOGGER_CLASS_NAME, SystemOutLogger.class.getName());
        try {
            return (Logger)Class.forName(loggerClassName).getDeclaredConstructor(Class.class).newInstance(clazz);
        }
        catch (Exception e) {
            throw new IllegalStateException("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3 pleiades.logger.class.name=" + loggerClassName + " \u306b\u6307\u5b9a\u3055\u308c\u305f\u30ed\u30ac\u30fc\u30af\u30e9\u30b9\u304c\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
        }
    }

    Logger(Class clazz) {
        this.className = clazz.getName().replaceFirst("(\\w+\\.)+", "");
    }

    protected abstract PrintStream getOut();

    protected void println(String message, Throwable t) {
        Date date = new Date();
        String s = String.format("%-5s %tT.%tL [%s] %s", new Object[]{level, date, date, this.className, message});
        PrintStream out = this.getOut();
        out.println(s);
        if (t != null) {
            t.printStackTrace(out);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.println(message, null);
        }
    }

    public void debug(String message, Throwable e) {
        if (this.isDebugEnabled()) {
            this.println(message, e);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.println(message, null);
        }
    }

    public void info(String message, Throwable e) {
        if (this.isInfoEnabled()) {
            this.println(message, e);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.println(message, null);
        }
    }

    public void warn(String message, Throwable e) {
        if (this.isWarnEnabled()) {
            this.println(message, e);
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.println(message, null);
        }
    }

    public void error(String message, Throwable e) {
        if (this.isErrorEnabled()) {
            this.println(message, e);
        }
    }

    public void fatal(String message) {
        if (this.isFatalEnabled()) {
            this.println(message, null);
        }
    }

    public void fatal(String message, Throwable e) {
        if (this.isFatalEnabled()) {
            this.println(message, e);
        }
    }

    public boolean isDebugEnabled() {
        return level == Level.DEBUG;
    }

    public boolean isInfoEnabled() {
        return level == Level.DEBUG || level == Level.INFO;
    }

    public boolean isWarnEnabled() {
        return level == Level.DEBUG || level == Level.INFO || level == Level.WARN;
    }

    public boolean isErrorEnabled() {
        return level == Level.DEBUG || level == Level.INFO || level == Level.WARN || level == Level.ERROR;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

