/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

import jp.sourceforge.mergedoc.pleiades.io.FileSystem;
import jp.sourceforge.mergedoc.pleiades.log.FileLogger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * Pleiades N邽߂̃G[WFgłB
 * <p>
 * @author C/pHeR
 */
public class Agent {
	
	/** K[ */
	private static Logger log;
	
	/** RtBO[VEpX */
	public static final File configurationPath = getConfigurationPath();
	
	/** ̃NX̃VOgECX^X */
	private static Agent agent;
	
	/**
	 * RtBO[VEpX擾܂B
	 * @return RtBO[VEpX
	 */
	private static File getConfigurationPath() {
		
		File eclipseHome = FileSystem.resourceRoot.getParentFile().getParentFile().getParentFile();
		File configPath = new File(eclipseHome, "configuration");
		Properties configIni = FileSystem.loadProperties(new File(configPath, "config.ini"));
		
		String configAreaKey = "osgi.configuration.area";
		String configArea = configIni.getProperty(configAreaKey);
		if (configArea == null) {
			configArea = System.getProperty(configAreaKey);
		}
		
		File userConfigPath = null;
		if (configArea != null) {
			Matcher mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea);
			if (mat.find()) {
				String base = System.getProperty(mat.group(1));
				if (base != null) {
					File baseDir = new File(base);
					if (baseDir.exists()) {
						String childPath = mat.group(2);
						userConfigPath = new File(baseDir, childPath);
					}
				}
			}
		}
		if (userConfigPath == null) {
			userConfigPath = configPath;
		}
		File pleiadesConfigPath = new File(userConfigPath, "jp.sourceforge.mergedoc.pleiades/");
		pleiadesConfigPath.mkdirs();
		return pleiadesConfigPath;
	}
	
	/**
	 * NGg[E|CgƂȂ premain \bhłB
	 * <p>
	 * @param agentArg -javaagent N
	 * @param inst CXgDe[V
	 * @throws Throwable łȂG[ꍇ
	 */
	public static void premain(String agentArg, Instrumentation inst) throws Throwable {
		
		// K[̏
		System.setProperty(Logger.LOGGER_CLASS_NAME, FileLogger.class.getName());
		System.setProperty(FileLogger.LOG_FILE_NAME, new File(
				configurationPath, "pleiades.log").getAbsolutePath());
		log = Logger.getLogger(Agent.class);
		
		// G[WFgs
		try {
			agent = new Agent();
			agent.run(agentArg, inst);
		} catch (Throwable e) {
			log.fatal("Pleiades G[WFg̋NɎs܂B", e);
		}
	}
	
	/**
	 * G[WFgEIuWFNg擾܂B
	 * <p>
	 * @return Agent IuWFNg
	 */
	public static Agent getInstance() {
		return agent;
	}
	
	/** CXgDe[V */
	private Instrumentation instrumentation;
	
	/** G[WFg̋NIvV */
	private AgentOption agentOption;
	
	/**
	 * CXgDe[V擾܂B
	 * <p>
	 * @return CXgDe[V
	 */
	public Instrumentation getInstrumentation() {
		return instrumentation;
	}
	
	/**
	 * G[WFg̋NIvV擾܂B
	 * <p>
	 * @return G[WFg̋NIvV
	 */
	public AgentOption getAgentOption() {
		return agentOption;
	}
	
	/**
	 * G[WFgs܂B
	 * <p>
	 * @param agentArg -javaagent N
	 * @param inst CXgDe[V
	 * @throws Throwable łȂG[ꍇ
	 */
	private void run(String agentArg, Instrumentation inst) throws Throwable {
		
		// G[WFg
		agentOption = new AgentOption(agentArg);
		instrumentation = inst;
		instrumentation.addTransformer(new LauncherTransformer());
		log.info("Pleiades AOP |ReiJn܂BG[WFg=" + agentArg);
		
		// Swing ̃tHg
		initSwingFont();
	}

    /**
     * Swing ŎgptHg܂B
     * Eclipse ̃vOC͒ʏ SWT gpĂ܂A
     * ꕔ̃vOCł Swing pĂ܂B
	 * <p>
     * @throws ClassNotFoundException LookAndFeel NXȂꍇ
     * @throws InstantiationException NX̐VCX^X𐶐łȂꍇ
     * @throws IllegalAccessException NX܂͏qɃANZXłȂꍇ
     * @throws UnsupportedLookAndFeelException lnf.isSupportedLookAndFeel()  false ̏ꍇ
     */
    private void initSwingFont() throws
        ClassNotFoundException,
        InstantiationException,
        IllegalAccessException,
        UnsupportedLookAndFeelException
    {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        
        // tHgݒ
        Object propoFont = new FontUIResource("MS UI Gothic", Font.TRUETYPE_FONT, 12);
        Object fixedFont = new FontUIResource("MS Gothic", Font.TRUETYPE_FONT, 12);
        String osName = System.getProperty("os.name", "");
        if (!osName.contains("Windows")) {
        	
        	// Windows ȊO͘_tHgŎw
            propoFont = new FontUIResource("sansserif", Font.TRUETYPE_FONT, 12);
            fixedFont = new FontUIResource("sansserif", Font.TRUETYPE_FONT, 12);
        }
        
        // UׂẴR|[lg̃tHgv|[ViɂB
        // tHg\[X̔͒l擾 instanceof FontUIResource 
        // SAUIDefaults  Lazy Value 𐶂ߖ̕ŔB
        for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
            String key = keyObj.toString();
            if (key.endsWith("font") || key.endsWith("Font")) {
                UIManager.put(key, propoFont);
            }
        }
        
        // R|[lg̃tHg𓙕ɂ
        UIManager.put("TextPane.font", fixedFont);
        UIManager.put("TextArea.font", fixedFont);
    }
}
