/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.FileUtils;

/**
 * AXyNgONXELbVłB
 * <p>
 * @author C/pHeR
 */
public class ExcludesClassCache {

	/** K[ */
	private static final Logger log = Logger.getLogger(ExcludesClassCache.class);
	
	/** AXyNgONXELbVEt@C */
	public static final File file = new File(Agent.configurationPath, "excludes-class.cache");
	
	/** ̃NX̃VOgECX^X */
	private static final ExcludesClassCache singleton = new ExcludesClassCache();
	
	/**
	 * AXyNgONXELbVEIuWFNg擾܂B
	 * <p>
	 * @return ExcludesClassCache IuWFNg
	 */
	public static ExcludesClassCache getInstance() {
		return singleton;
	}
	
	/** AXyNgONXEZbg */
	private Set<String> excludeSet = new HashSet<String>();
	
	/**
	 * AXyNgONXELbV\z܂B
	 */
	@SuppressWarnings("unchecked")
	private ExcludesClassCache() {
		if (Agent.getInstance().getAgentOption().isClean()) {
			log.info("-clean ɂAXyNgONXELbV̓[h܂B");
			return;
		}
		if (!file.exists()) {
			log.info("AXyNgONXELbV݂܂B");
			return;
		}
		try {
			excludeSet.addAll(FileUtils.readLines(file, null));
			log.info("AXyNgONXELbV[h܂B" + excludeSet.size());
		} catch (IOException e) {
			log.error("AXyNgONXELbṼ[hɎs܂B", e);
		}
	}
	
	/**
	 * ǉꂽNXLbVƂĉi܂B
	 */
	public void store() {
		try {
			FileUtils.writeLines(file, null, excludeSet);
			log.info("AXyNgONXELbVۊǂ܂B" + excludeSet.size());
		} catch (IOException e) {
			log.error("AXyNgONXELbV̕ۊǂɎs܂B", e);
		}
	}
	
	/**
	 * AXyNg珜ONXǉ܂B
	 * <p>
	 * @param className NX
	 */
	public void add(String className) {
		excludeSet.add(className);
	}
	
	/**
	 * AXyNg珜ONX폜܂B
	 * <p>
	 * @param className NX
	 * @return w肳ꂽNX݂ꍇ true
	 */
	public boolean remove(String className) {
		return excludeSet.remove(className);
	}
}
