/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.Arrays;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.CachedDictionary;
import jp.sourceforge.mergedoc.pleiades.io.FileSystem;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.lang.ArrayUtils;

/**
 * Eclipse ÑoCgR[hϊsgXtH[}[łB
 * <p>
 * @author C/pHeR
 */
public class LauncherTransformer extends AbstractTransformer {

	/** K[ */
	private static final Logger log = Logger.getLogger(LauncherTransformer.class);
	
	/**
	 * NgXtH[}[\z܂B
	 */
	public LauncherTransformer() {
	}
	
	/**
	 * oCgR[hϊs܂B
	 * <p>
	 * ̃\bh Eclipse ̃`[ƂȂNXɈȉ̏ǉ܂B
	 * <ul>
	 * <li>OF {@link #startTranslationTransformer(String[])} Ăяo
	 * <li>㏈F {@link #destroyTranslationTransformer()} Ăяo
	 * </ul>
	 */
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {
		
		if (className.equals("org.eclipse.core.launcher.Main")) {
			
			log.info("Eclipse ̋NJn܂B");
			
			// Eclipse Main NXɊJnǉ
			CtClass ctClass = createCtClass(bytecode, protectionDomain);
			CtMethod run = ctClass.getMethod("run", "([Ljava/lang/String;)I");
			run.insertBefore("$1 = " + getClass().getName() + ".startTranslationTransformer($$);");
			
			// Eclipse Main NXɏIǉ
			run.insertAfter(getClass().getName() + ".destroyTranslationTransformer();", true);
			
			// XvbV摜̕ύXZbg
			if (!Agent.getInstance().getAgentOption().isDefaultSplash()) {
				File file = FileSystem.getResourceFile("splash.bmp");
				if (file.exists()) {
					CtMethod searchForSplash = ctClass.getMethod(
							"searchForSplash", "([Ljava/lang/String;)Ljava/lang/String;");
					searchForSplash.setBody(
							"return " +
							FileSystem.class.getName() +
							".getResourceFile(\"splash.bmp\").getAbsolutePath();");
				} else {
					log.warn("Pleiades XvbV摜܂B" +
							file.getAbsolutePath());
				}
			}
			return ctClass.toBytecode();
			
		} else if (className.equals("org.eclipse.ui.internal.Workbench")) {
			
			// ̃gXtH[}[G[WFg폜
			Agent.getInstance().getInstrumentation().removeTransformer(this);
			
			// NԂ̌vIǉ
			CtClass ctClass = createCtClass(bytecode, protectionDomain);
			CtMethod runStartupWithProgress =
				ctClass.getMethod("runStartupWithProgress", "(ILjava/lang/Runnable;)V");
			runStartupWithProgress.insertAfter(getClass().getName() + ".startTime();");
			return ctClass.toBytecode();
		}
		return null;
	}
	
	/**
	 * NԂv܂B
	 */
	public static void startTime() {
		
		long startTime = Long.valueOf(System.getProperty("eclipse.startTime"));
		double time = (System.currentTimeMillis() - startTime) / 1000d;
		log.info(String.format(
				"Eclipse ̋N܂B: %.3f b", time));
	}
	
	/**
	 * |gXtH[}[Jn܂B
	 * <p>
	 * @param args Eclipse NIvVz
	 * @return NIvVz
	 */
	public static String[] startTranslationTransformer(String... args) {
		
		String[] newArgs = args;
		
		// N -clean 擾
		Agent agent = Agent.getInstance();
		AgentOption agentOption = agent.getAgentOption();
		agentOption.setClean(Arrays.asList(args).contains("-clean"));
		
		// LbVꍇ͋I -claen w
		if (!agentOption.isClean()) {
			boolean isClean = false;
			if (!ExcludesClassCache.file.exists()) {
				isClean = true;
				log.info("AXyNgOLbV݂Ȃ߁A" +
					"I -clean [hŋN܂B");
			}
			if (!CachedDictionary.cacheFile.exists() && !agentOption.isNoCache()) {
				isClean = true;
				log.info("LbV݂Ȃ߁A" +
					"I -clean [hŋN܂B");
			}
			if (isClean) {
				newArgs = (String[]) ArrayUtils.add(args, "-clean");
				agentOption.setClean(true);
			}
		}
		log.info("-clean: " + agentOption.isClean());
		
		// |gXtH[}[Jn
		agent.getInstrumentation().addTransformer(new TranslationTransformer());
		
		return newArgs;
	}
	
	/**
	 * |gXtH[}[j܂B
	 */
	public static void destroyTranslationTransformer() {
		TranslationTransformer.destroy();
	}
}
