/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint.EditPoint;
import jp.sourceforge.mergedoc.pleiades.io.FileSystem;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * AXyNgE}bsOłB<br>
 * WCgE|Cgƃ|CgEJbg̊֘Atێ܂B
 * <p>
 * @author C/pHeR
 */
public class AspectMapping {

	/** K[ */
	private static final Logger log = Logger.getLogger(AspectMapping.class);

	/** ݒt@C */
	private static final String CONFIG_FILE_NAME = "pleiades-config.xml";

	/** ̃NX̃CX^X */
	private static final AspectMapping singleton = new AspectMapping();
	
	/**
	 * AXyNgE}bsO擾܂B
	 * <p>
	 * @return AXyNgE}bsO
	 */
	public static AspectMapping getInstance() {
		return singleton;
	}
	
	/** WCgE|Cgƃ|CgEJbgێ}bv */
	private Map<JointPoint, PointCut> jointMap = new HashMap<JointPoint, PointCut>();
	
	/** EB[rOΏۂ̃\bhĂяoOZbg */
	private Set<String> methodCalls = new HashSet<String>();
	
	/**
	 * AXyNgE}bsO\z܂B
	 */
	private AspectMapping() {
		
	    File configFile = FileSystem.getResourceFile(CONFIG_FILE_NAME);
		try {
		    if (!configFile.exists()) {
		    	throw new FileNotFoundException(configFile.getPath());
		    }
		    SAXParserFactory factory = SAXParserFactory.newInstance();
		    SAXParser parser = factory.newSAXParser();
		    parser.parse(configFile, new AspectMappingLoader(jointMap));
		    
		    for (JointPoint jointPoint : jointMap.keySet()) {
				if (jointPoint.getEditPoint() == EditPoint.CALL) {
					methodCalls.add(
							jointPoint.getClassName() + "#" +
							jointPoint.getMethodName());
				}
			}
			log.info("AXyNgݒt@C[h܂B");
		    
		} catch (Exception e) {
			String msg = "AXyNgݒt@C̃[hɎs܂B";
			log.fatal(msg, e);
			throw new IllegalStateException(msg, e);
		}
	}
	
	/**
	 * |CgEJbg擾܂B
	 * <p>
	 * @param jointPoint WCgE|Cg
	 * @return |CgEJbg
	 */
	public PointCut getPointCut(JointPoint jointPoint) {
		
		String descBackup = jointPoint.getDescriptor();
		jointPoint.setDescriptor(null);
		PointCut pointCut = jointMap.get(jointPoint);
		jointPoint.setDescriptor(descBackup);
		if (pointCut == null) {
			pointCut = jointMap.get(jointPoint);
		}
		return pointCut;
	}
	
	/**
	 * \bhĂяoEB[rOΏۂ肵܂B
	 * <p>
	 * @param className NX
	 * @param methodName \bh
	 * @return EB[rOΏۂ̏ꍇ true
	 */
	public boolean containesMethodCall(String className, String methodName) {
		return methodCalls.contains(className + "#" + methodName);
	}
	
	/**
	 * ̃IuWFNg̕\擾܂B
	 */
	public String toString() {
		return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
			.append(jointMap)
			.toString();
	}
}
