/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.advice;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * AXyNgE}bsO̐ݒt@CE[_[łB<br>
 * WCgE|Cgƃ|CgEJbg̊֘Ats܂B
 * <p>
 * @author C/pHeR
 */
public class AspectMappingLoader extends DefaultHandler {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(AspectMappingLoader.class);

	/** vpeB[ێ}bv */
	private Set<Property> properties = new HashSet<Property>();

	/** WCgE|Cgƃ|CgEJbgێ}bv */
	private final Map<JointPoint, PointCut> jointMap;

	/** |CgEJbg */
	private PointCut pointCut;

	/** AhoCXobt@ */
	private StringBuilder adviceBuffer;

	/** WCgE|Cg */
	private JointPoint jointPoint;
	
	/** ҏW|Cg */
	private String editPoint;
	
	/**
	 * AXyNgE}bsOEnh\z܂B
	 * <p>
	 * @param jointMap WCgE|Cgƃ|CgEJbgێ}bv
	 */
	public AspectMappingLoader(Map<JointPoint, PointCut> jointMap) {
		this.jointMap = jointMap;
	}
	
	/**
	 * XML vfJn̏łB
	 */
	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		
		if (qName.equals("pleiades")) {
			
		} else if (qName.equals("property")) {
			
			Property property = new Property();
			property.setName(attributes.getValue("name"));
			property.setValue(attributes.getValue("value"));
			properties.add(property);
			
		} else if (qName.equals("pointCut")) {
			
			pointCut = new PointCut();
			pointCut.setTiming(attributes.getValue("timing"));
			editPoint = attributes.getValue("editPoint");
			
		} else if (qName.equals("advice")) {
			
			adviceBuffer = new StringBuilder();
			
		} else if (qName.equals("jointPoint")) {
			
			jointPoint = new JointPoint();
			jointPoint.setEditPoint(editPoint);
			jointPoint.setClassName(attributes.getValue("className"));
			jointPoint.setMethodName(attributes.getValue("methodName"));
			jointPoint.setModifier(attributes.getValue("modifier"));
			jointPoint.setDescriptor(attributes.getValue("descriptor"));
			
			if (jointMap.containsKey(jointPoint)) {
				log.warn("WCgE|Cg`dĂ܂B" + jointPoint);
			}
			PointCut curPointCut = new PointCut(pointCut);
			jointMap.put(jointPoint, curPointCut);
			curPointCut.setJointPoint(jointPoint);
			
		} else if (qName.endsWith(/* include` or exclude` */"cludeWhere")) {
			
			JointPoint where = new JointPoint();
			where.setClassName(attributes.getValue("className"));
			where.setMethodName(attributes.getValue("methodName"));
			//where.setModifier(attributes.getValue("modifier"));
			//where.setDescriptor(attributes.getValue("descriptor"));
			//  includeAexclude  modefierAdescriptor ͖T|[g
			
			PointCut curPointCut = jointMap.get(jointPoint);
			if (qName.equals("excludeWhere")) {
				curPointCut.addExcludeWhere(where);
			} else if (qName.equals("includeWhere")) {
				curPointCut.addIncludeWhere(where);
			} else {
				throw new IllegalStateException("sȑłB" + qName);
			}
			
		} else if (qName.endsWith(/* include` or exclude` */"cludeTrace")) {
			
			String prefix = attributes.getValue("prefix");
			
			PointCut curPointCut = jointMap.get(jointPoint);
			if (qName.equals("excludeTrace")) {
				curPointCut.addExcludeTrace(prefix);
			} else if (qName.equals("includeTrace")) {
				curPointCut.addIncludeTrace(prefix);
			} else {
				throw new IllegalStateException("sȑłB" + qName);
			}
			
		} else {
			throw new IllegalStateException("sȑłB" + qName);
		}
	}

	/**
	 * XML vfȈłB
	 */
	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		
		if (qName.equals("advice")) {
			
			String advice = adviceBuffer.toString();
			for (Property property : properties) {
				advice = advice.replaceAll(
					"\\?\\{" + property.getName() + "\\}",
					property.getValue());
			}
			pointCut.setAdvice(advice);
		}
	}

	/**
	 * XML vf{fB̏łB
	 */
	@Override
	public void characters(char[] ch, int start, int length) throws SAXException {
		
		if (adviceBuffer != null) {
			adviceBuffer.append(ch, start, length);
		}
	}
}
