/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import jp.sourceforge.mergedoc.pleiades.aspect.Agent;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.io.FileSystem;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * \钊ۃNXłB
 * <p>
 * @author C/pHeR
 */
abstract public class AbstractDictionary implements IDictionary {
	
	/** K[ */
	private static final Logger log = Logger.getLogger(AbstractDictionary.class);
	
	/** ftHg|vpeB[Et@C */
	public static final String DEFAULT_PROPERTIES_FILE_NAME = "translation.properties";
	
	/** |vpeB[ǉfBNg[ */
	private static final String ADDITIONS_DIRECTORY = "additions";
	
	/** |vpeB[ێ}bv */
	private final Map<String, String> map = new HashMap<String, String>();
	
	/**
	 * ftHg\z܂B
	 */
	protected AbstractDictionary() {
		load();
	}
	
	/**
	 * t@C[h܂B
	 */
	protected void load() {
		
		File additions = FileSystem.getResourceFile(ADDITIONS_DIRECTORY);
		if (additions.exists()) {
			
			File[] files = additions.listFiles();
			Arrays.sort(files); // 
			
			for (File file : files) {
				if (file.isFile() && file.getName().endsWith(".properties")) {
					map.putAll(loadProperties(file));
				}
			}
		}
		File file = FileSystem.getResourceFile(DEFAULT_PROPERTIES_FILE_NAME);
		if (!file.exists()) {
			Exception e = new FileNotFoundException(file.getPath());
			log.fatal(e.toString(), e);
			throw new IllegalStateException(e);
		}
		map.putAll(loadProperties(file));
		log.info("|vpeB[h܂B" + map.size());
	}
	
	/**
	 * |vpeB[ێ}bv擾܂B
	 * <p>
	 * @return |vpeB[ێ}bv
	 */
	protected Map<String, String> getMap() {
		return map;
	}
	
	/**
	 * w肵vpeB[Et@C[h܂B
	 * <p>
	 * @param file vpeB[Et@C
	 * @return }bv
	 */
	@SuppressWarnings("unchecked")
	private Map<? extends String, ? extends String> loadProperties(File file) {
		
		Properties prop = FileSystem.loadProperties(file);
		return (Map<? extends String, ? extends String>) prop;
	}
	
	/* ( Javadoc)
	 * @see IDictionary#lookup(String, JointPoint)
	 */
	public String lookup(String enValue, JointPoint jointPoint) {
		
		// {p̃j[jbNɊ܂܂Ăꍇ͉Ȃ
		if (enValue.matches("(?s)^.*?\\(\\&[\\w\\.]\\).*$")) {
			return enValue;
		}
		
		// pꃊ\[X񂩂j[jbN
		String enValueNonMnemonic = enValue.replaceFirst("\\&([\\w\\.])", "$1");
		String result = null;
		
		// |svȏꍇ́A|󂵂Ȃ
		if (isNoTranslation(enValueNonMnemonic, jointPoint)) {
			result = enValue;
		}
		// |vpeB[{擾
		else {
			result = map.get(enValueNonMnemonic);
			
			// |vpeB[ɖAp݂̂ō\ or ~[TCgx`i2 oCg݁j
			// ̏ꍇ͖|󐳋K\vpeB[gp
			if (result == null && enValue.matches("([\\p{ASCII}efc]+|\\[\\p{ASCII}+\\].+)")) {
				result = RegexDictionary.getInstance().lookup(enValueNonMnemonic);
				if (result == null) {
					NotFoundLog.getInstance().println(enValueNonMnemonic);
				}
			}
			// 󂹂Ȃꍇ͉p̂܂
			if (result == null) {
				result = enValue;
			}
		}
		
		// j[jbN{pɕϊB
		// ̕ϊ͖ꂪȂꍇsB
		result = editMnemonicEnToJa(enValue, enValueNonMnemonic, result);
		
		//if (enValueNonMnemonic.equals("PHP Search")) {
		//	log.info("ǐ [" + enValue + "]  [" + result + "]", new Exception());
		//	return "[" + enValue + "" + result + "]";
		//}
		
		return result;
	}
	
	/**
	 * |󂪕sv肵܂B
	 * ĂяõpbP[WNXɔ肳܂B
	 * <p>
	 * @param enValueNonMnemonic pꃊ\[Xij[jbNj
	 * @param jointPoint WCgE|Cg
	 * @return |󂪕svȏꍇ true
	 */
	private boolean isNoTranslation(String enValueNonMnemonic, JointPoint jointPoint) {
		
		StackTraceElement[] stes = null;
		
		// xml [exclludeTrace] Ăяog[Xɂ鏜OiċAIɑkj
		if (jointPoint != null) {
			
			PointCut pointCut = AspectMapping.getInstance().getPointCut(jointPoint);
			List<String> excludeTrace = pointCut.getExcludeTrace();
			
			if (excludeTrace.size() > 0) {
				stes = Thread.currentThread().getStackTrace();
				
				for (String prefix : excludeTrace) {
					
					for (StackTraceElement ste : stes) {
						String className = ste.getClassName();
						if (className.startsWith(prefix)) {
							return true;
						}
					}
				}
			}
		}
		
		// properties [%EXCULUDE%] Ăяoɂ鏜OiPʁj
		Set<String> noTransPathEntries =
			TranslationExcludeProperties.getInstance().getPathEntries(enValueNonMnemonic);
		
		if (noTransPathEntries != null) {
			if (stes == null) {
				stes = Thread.currentThread().getStackTrace();
			}
			for (StackTraceElement ste : stes) {
				String className = ste.getClassName();
				
				for (String noTransPath : noTransPathEntries) {
					if (className.startsWith(noTransPath)) {
						return true;
					}
				}
			}
		}
		return false;
	}
	
	/**
	 * j[jbNpp{pɕҏW܂B<br>
	 * j&x  (&X)
	 * <p>
	 * @param enValue				pꃊ\[X  ij[jbNLj
	 * @param enValueNonMnemonic	pꃊ\[X  ij[jbNj
	 * @param result				{ꃊ\[Xij[jbNj
	 * @return						{ꃊ\[Xij[jbNLj
	 */
	private String editMnemonicEnToJa(
			String enValue, String enValueNonMnemonic, String result) {
		
		if (Agent.getInstance().getAgentOption().isNoMnemonic()) {
			return result;
		}
		if (enValue.equals(enValueNonMnemonic)) {
			return result;
		}
		
		String mnemonicChar = enValue.replaceFirst("(?s)^.*?\\&([\\w\\.]).*$", "$1");
		String mnemonicJa = "(&" + mnemonicChar.toUpperCase() + ")";
		
		if (mnemonicChar.length() != 1) {
			log.error("Mnemonic invalid length: " + mnemonicChar.length());
			log.error(" enValue:            " + enValue);
			log.error(" enValueNonMnemonic: " + enValueNonMnemonic);
			log.error(" mnemonicChar:       " + mnemonicChar);
			result = enValue;
			
		} else {
			
			result = result.replaceFirst(
				"(?s)(" +
				"@\\p{ASCII}+|" +			// j @Ctrl+Shift+X
				"\\s*|" +					// j 
				":\\s*|" +					// j :
				":\\s+\\{[0-9]\\}\\s*|" +	// j :{}
				"\\.\\.\\.(</a>|)\\s*|" +	// j ...
				"(:|)\\s+\\(.+\\)\\s*" +	// j :()
				")$",
				mnemonicJa + "$1");
		}
		return result;
	}
}
