/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import jp.sourceforge.mergedoc.pleiades.io.FileSystem;

import org.apache.commons.io.IOUtils;

/**
 * vOCE\[XێNXłB
 * <p>
 * @author C/pHeR
 */
public class Plugin extends PropertiesUnit {

	/** vOCE[g */
	private final File root;

	/** vOC ID */
	private String id;

	/**
	 * vOC\z܂B
	 * <p>
	 * @param pluginFile vOCEtH_[܂̓t@C
	 */
	public Plugin(File pluginFile) {

		this.root = pluginFile;
		if (pluginFile.isDirectory()) {
			loadFolder(pluginFile);
		} else {
			loadJar(pluginFile);
		}

		if (id == null) {
			throw new NullPointerException(
					"vOC ID 擾ł܂łB"
					+ pluginFile.getName());
		}
	}

	/**
	 * w肳ꂽtH_[̃\[X[h܂B
	 * <p>
	 * @param pluginFolder vOCEtH_[
	 */
	protected void loadFolder(File pluginFolder) {

		InputStream is = null;
		try {

			File manifest = new File(pluginFolder, "META-INF/MANIFEST.MF");
			if (manifest.exists()) {

				// }jtFXgEt@C΁AꂩvOC ID 擾
				is = new BufferedInputStream(new FileInputStream(manifest));
				setIdInManifestFile(is);

			} else {

				File fragmentXML = new File(pluginFolder, "fragment.xml");
				if (fragmentXML.exists()) {

					// tOg XML ΁AꂩvOC ID 擾
					is = new BufferedInputStream(new FileInputStream(fragmentXML));
					setIdInFragmentXML(is);

				} else {

					// tH_[vOC ID 擾
					setIdInFileName(pluginFolder);
				}
			}

		} catch (IOException e) {
			throw new IllegalArgumentException(e);

		} finally {
			IOUtils.closeQuietly(is);
		}

		getEnProperties().putAll(FileSystem.loadProperties(
				new File(pluginFolder, "plugin.properties")));
		getJaProperties().putAll(FileSystem.loadProperties(
				new File(pluginFolder, "plugin_ja.properties")));
		getJaProperties().putAll(FileSystem.loadProperties(
				new File(pluginFolder, "plugin_ja_JP.properties")));

		File[] files = pluginFolder.listFiles();
		for (File file : files) {
			if (file.isFile() && file.getName().endsWith(".jar")) {
				loadJar(file);
			}
		}
	}

	/**
	 * w肳ꂽ jar t@C[h܂B
	 * <p>
	 * @param jar jar t@C
	 */
	private void loadJar(File jar) {

		// jar t@CvOC ID 擾
		setIdInFileName(jar);

		ZipInputStream in = null;
		try {
			in = new ZipInputStream(new BufferedInputStream(new FileInputStream(jar)));

            for (ZipEntry inEntry = null; (inEntry = in.getNextEntry()) != null;) {

                String entryName = inEntry.getName();

                if (entryName.equals("META-INF/MANIFEST.MF")) {
                	// vOC ID ̃Zbgi}jtFXgt@Cj
                	setIdInManifestFile(in);

                } else if (entryName.equals("fragment.xml")) {
                	// vOC ID ̃ZbgitOg XMLj
                	setIdInFragmentXML(in);

                } else if (entryName.endsWith("_ja.properties") ||
                		   entryName.endsWith("_ja_JP.properties")) {
                	// {vpeB
        			Properties prop = new Properties();
                    prop.load(in);
                    getJaProperties().putAll(prop);

                } else if (entryName.matches("^.*_\\w{2}\\.properties$")) {
                	// pE{ȊÕvpeB

                } else if (entryName.endsWith(".properties")) {
                	// pvpeB
                	String rootName = root.getName();
                	if (!rootName.matches("^.*?(\\.nls1_|\\.nl1_).*$")) {
                		// ja ŏ㏑Ăꍇ̑Ήi_ja 邱ƂOj
            			Properties prop = new Properties();
                        prop.load(in);
                        getEnProperties().putAll(prop);
                	}
                }
            }

		} catch (IOException e) {
			throw new IllegalStateException(e);

		} finally {

			IOUtils.closeQuietly(in);
		}
	}

	/**
	 * }jtFXgEt@C̓Xg[vOC ID Zbg܂B
	 * <p>
	 * @param is }jtFXgEt@C̓Xg[
	 * @throws IOException o͗Oꍇ
	 */
	private void setIdInManifestFile(InputStream is) throws IOException {

		if (getId() != null) return;
		Attributes attributes = new Manifest(is).getMainAttributes();
		String value = attributes.getValue("Fragment-Host");
		if (value == null) {
			value = attributes.getValue("Bundle-SymbolicName");
		}
		if (value != null) {
			setId(value.split(";")[0].trim());
		}
	}

	/**
	 * tOg XML ̓Xg[vOC ID Zbg܂B
	 * <p>
	 * @param is tOg XML t@C̓Xg[
	 * @throws IOException o͗Oꍇ
	 */
	private void setIdInFragmentXML(InputStream is) throws IOException {

		if (getId() != null) return;
		String fragment = IOUtils.toString(is);
		setId(fragment.replaceFirst("(?s)^.*plugin-id=\"(.*?)\".*$", "$1"));
	}

	/**
	 * vOCEtH_[܂̓t@CvOC ID Zbg܂B
	 * <p>
	 * @param pluginFolder vOCEtH_[܂̓t@C
	 */
	protected void setIdInFileName(File pluginFolder) {
		if (getId() != null) return;
		String name = pluginFolder.getName();
		name = name.replaceFirst("(\\.nls1|\\.nl1)", "");
		name = name.replaceFirst("_[0-9]+\\.[0-9]+\\.[0-9]+.*$", "");
		setId(name);
	}

	/**
	 * vOC ID Zbg܂B
	 * <p>
	 * @param id vOC ID
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * vOC ID 擾܂B
	 * <p>
	 * @return vOC ID
	 */
	public String getId() {
		return id;
	}
}
