/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

/**
 * t@C샆[eBeB[łB
 * <p>
 * @author C/pHeR
 */
public class FileSystem {

	/** K[ */
	private static final Logger log = Logger.getLogger(FileSystem.class);

	/** \[XE[g */
	public static final File resourceRoot;

	// [g̎擾
	static {
		String markResource = "/.marker";
        URL url = FileSystem.class.getResource(markResource);
        if (url == null) {
        	String msg = "NXpXɃt@C܂B" + markResource;
			Exception e = new FileNotFoundException(msg);
			log.fatal(msg, e);
			throw new IllegalStateException(e);
        }
        String path = new File(url.getPath()).getParent();
		try {
			String unicodePath = URLDecoder.decode(path, "UTF-8");
	        resourceRoot = new File(unicodePath);
		} catch (UnsupportedEncodingException e) {
        	throw new IllegalStateException(e);
		}
	}
	
	/**
	 * CX^Xł܂B
	 */
	private FileSystem() {
	}

	/**
	 * \[XE[gȉ̃pXw肵AFile IuWFNg擾܂B
	 * <p>
	 * @param resourcePath \[XEpX
	 * @return \[X File IuWFNg
	 */
	public static File getResourceFile(String resourcePath) {
		return new File(resourceRoot, resourcePath);
	}

	/**
	 * w肵tH_[t@Cւ̑΃pX擾܂B
	 * <p>
	 * @param folder tH_[
	 * @param file t@C
	 * @return ΃pX
	 */
	public static String relativePath(File folder, File file) {

		try {
			String folderPath = folder.getCanonicalPath();
			String filePath = file.getCanonicalPath();
			return filePath.replace(folderPath, "");

		} catch (IOException e) {
			throw new IllegalArgumentException(folder + ", " + file, e);
		}
	}
	
	/**
	 * w肳ꂽvpeB[Et@C[h܂B
	 * <p>
	 * @param file vpeB[Et@C
	 * @return vpeB[
	 */
	public static Properties loadProperties(File file) {

		Properties prop = new Properties();
		if (!file.exists()) {
			return prop;
		}

		InputStream is = null;
		try {
			is = new BufferedInputStream(new FileInputStream(file));
			prop.load(is);

		} catch (IOException e) {
			throw new IllegalArgumentException(file.toString(), e);

		} finally {
			IOUtils.closeQuietly(is);
		}
		return prop;
	}

	/**
	 * w肳ꂽvpeB[\[găt@Cɕۊǂ܂B
	 * <p>
	 * @param prop vpeB[
	 * @param file t@C
	 */
	@SuppressWarnings("unchecked")
	public static void storeProperties(Properties prop, File file) {

		OutputStream os = null;
		try {
			os = new BufferedOutputStream(new FileOutputStream(file));
			prop.store(os, "Generated by Pleiades. " + prop.size() + " entries.");
			
			List<String> list = FileUtils.readLines(file, "ISO-8859-1");
			List<String> resultList = new LinkedList<String>();
			resultList.add(list.remove(0));
			resultList.add(list.remove(0));
			Collections.<String>sort(list, String.CASE_INSENSITIVE_ORDER);
			resultList.addAll(list);
			FileUtils.writeLines(file, "ISO-8859-1", resultList);
			
		} catch (IOException e) {
			throw new IllegalArgumentException(file.toString(), e);

		} finally {
			IOUtils.closeQuietly(os);
		}
	}
}
