/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.PrintStream;
import java.util.Date;

/**
 * Log4J CNȃC^tF[XۃK[łB
 * <p>
 * @author C/pHeR
 */
public abstract class Logger {
	
	/** K[ENXVXeEvpeB[̃L[ */
	public static final String LOGGER_CLASS_NAME = "pleiades.logger.class.name";
	
	/** OExVXeEvpeB[̃L[ */
	public static final String LOG_LEVEL = "pleiades.log.level";
	
	/** OEx񋓌^ */
	private static enum Level {
		DEBUG, INFO, WARN, ERROR, FATAL
	}
	
	/** OEx */
	private static Level level;
	
	/** ̃K[𐶐NX */
	private final String className;
	
	/**
	 * K[擾܂B
	 * <p>
	 * @param clazz NX
	 * @return K[
	 */
	public static Logger getLogger(Class clazz) {
		
		if (level == null) {
			String logLevel = System.getProperty(LOG_LEVEL, Level.INFO.toString());
			try {
				level = Level.valueOf(logLevel.toUpperCase());
			} catch (RuntimeException e) {
				throw new IllegalStateException(
						"VXevpeB " + LOG_LEVEL + "=" + logLevel +
						" Ɏw肷l " + Level.class.getName() +
						"Œ`ꂽ^łKv܂B");
			}
		}
		
		String loggerClassName =
			System.getProperty(LOGGER_CLASS_NAME, SystemOutLogger.class.getName());
		try {
			return (Logger) Class.forName(loggerClassName)
				.getDeclaredConstructor(Class.class).newInstance(clazz);
		} catch (Exception e) {
			throw new IllegalStateException(
					"VXevpeB " + LOGGER_CLASS_NAME + "=" +
					loggerClassName +
					" Ɏw肳ꂽK[NX[hł܂łB", e);
		}
	}
	
	/**
	 * K[\z܂B
	 * <p>
	 * @param clazz NX
	 */
	Logger(Class clazz) {
		this.className = clazz.getName().replaceFirst("(\\w+\\.)+", "");
	}
	
	/**
	 * o͐ƂȂ PrintStream 擾܂B
	 * <p>
	 * @return o͐ƂȂ PrintStream
	 */
	abstract protected PrintStream getOut();
	
	/**
	 * bZ[Wo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param t OBnull ̏ꍇ message ݂̂óB
	 */
	protected void println(String message, Throwable t) {
		
		Date date = new Date();
		String s = String.format(
				"%-5s %tT.%tL [%s] %s",
				level, date, date, className, message);
		
		PrintStream out = getOut();
		out.println(s);
		if (t != null) {
			t.printStackTrace(out);
		}
	}
	
	/**
	 * fobOEOo͂܂B
	 * <p>
	 * @param message bZ[W
	 */
	public void debug(String message) {
		if (isDebugEnabled()) println(message, null);
	}

	/**
	 * fobOEOo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void debug(String message, Throwable e) {
		if (isDebugEnabled()) println(message, e);
	}

	/**
	 * 񃍃Oo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void info(String message) {
		if (isInfoEnabled()) println(message, null);
	}

	/**
	 * 񃍃Oo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void info(String message, Throwable e) {
		if (isInfoEnabled()) println(message, e);
	}

	/**
	 * xOo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void warn(String message) {
		if (isWarnEnabled()) println(message, null);
	}

	/**
	 * xOo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void warn(String message, Throwable e) {
		if (isWarnEnabled()) println(message, e);
	}

	/**
	 * G[EOo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void error(String message) {
		if (isErrorEnabled()) println(message, null);
	}

	/**
	 * G[EOo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void error(String message, Throwable e) {
		if (isErrorEnabled()) println(message, e);
	}

	/**
	 * vIG[EOo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void fatal(String message) {
		if (isFatalEnabled()) println(message, null);
	}

	/**
	 * vIG[EOo͂܂B
	 * <p>
	 * @param message bZ[W
	 * @param e O
	 */
	public void fatal(String message, Throwable e) {
		if (isFatalEnabled()) println(message, e);
	}
	
	/**
	 * fobOEOL肵܂B
	 * <p>
	 * @return Lȏꍇ true
	 */
	public boolean isDebugEnabled() {
		return	level == Level.DEBUG;
	}
	
	/**
	 * 񃍃OL肵܂B
	 * <p>
	 * @return Lȏꍇ true
	 */
	public boolean isInfoEnabled() {
		return	level == Level.DEBUG || level == Level.INFO ;
	}
	
	/**
	 * xOL肵܂B
	 * <p>
	 * @return Lȏꍇ true
	 */
	public boolean isWarnEnabled() {
		return	level == Level.DEBUG || level == Level.INFO  ||
				level == Level.WARN ;
	}
	
	/**
	 * G[EOL肵܂B
	 * <p>
	 * @return Lȏꍇ true
	 */
	public boolean isErrorEnabled() {
		return	level == Level.DEBUG || level == Level.INFO  ||
				level == Level.WARN  || level == Level.ERROR;
	}
	
	/**
	 * vIG[EOL肵܂B
	 * <p>
	 * @return Lȏꍇ true
	 */
	public boolean isFatalEnabled() {
		return true;
	}
}
