/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BooleanColorFieldEditor
extends FieldEditor {
    private boolean wasSelected;
    private Button checkBox;
    private ColorSelector colorSelector;

    protected BooleanColorFieldEditor() {
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 0;
        layout.marginHeight = 20;
        layout.horizontalSpacing = 8;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    public BooleanColorFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.checkBox = this.getBooleanChangeControl(parent);
        this.checkBox.setText(this.getLabelText());
        Button colorButton = this.getColorChangeControl(parent);
        GridData gd = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels((Control)colorButton, 61);
        gd.widthHint = Math.max(widthHint, colorButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        colorButton.setLayoutData((Object)gd);
    }

    private String getBooleanPreferenceName() {
        return this.getPreferenceName() + "_SHOW";
    }

    private String getColorPreferenceName() {
        return this.getPreferenceName() + "_COLOR";
    }

    protected void doLoad() {
        if (this.checkBox != null) {
            boolean value = this.getPreferenceStore().getBoolean(this.getBooleanPreferenceName());
            this.checkBox.setSelection(value);
            this.wasSelected = value;
            this.colorSelector.setEnabled(this.wasSelected);
        }
        if (this.colorSelector != null) {
            this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorPreferenceName()));
        }
    }

    protected void doLoadDefault() {
        if (this.checkBox != null) {
            boolean value = this.getPreferenceStore().getDefaultBoolean(this.getBooleanPreferenceName());
            this.checkBox.setSelection(value);
            this.wasSelected = value;
            this.colorSelector.setEnabled(this.wasSelected);
        }
        if (this.colorSelector != null) {
            this.colorSelector.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorPreferenceName()));
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getBooleanPreferenceName(), this.checkBox.getSelection());
        PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)this.getColorPreferenceName(), (RGB)this.colorSelector.getColorValue());
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getBooleanChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 16416);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = BooleanColorFieldEditor.this.checkBox.getSelection();
                    BooleanColorFieldEditor.this.valueChanged(BooleanColorFieldEditor.this.wasSelected, isSelected);
                    BooleanColorFieldEditor.this.wasSelected = isSelected;
                    BooleanColorFieldEditor.this.colorSelector.setEnabled(BooleanColorFieldEditor.this.wasSelected);
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BooleanColorFieldEditor.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    protected Button getColorChangeControl(Composite parent) {
        if (this.colorSelector == null) {
            this.colorSelector = new ColorSelector(parent);
            this.colorSelector.addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    BooleanColorFieldEditor.this.fireValueChanged(event.getProperty(), event.getOldValue(), event.getNewValue());
                    BooleanColorFieldEditor.this.setPresentsDefaultValue(false);
                }
            });
        } else {
            this.checkParent((Control)this.colorSelector.getButton(), parent);
        }
        return this.colorSelector.getButton();
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getBooleanChangeControl(parent).setEnabled(enabled);
        this.getColorChangeControl(parent).setEnabled(enabled);
    }

    public void store() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore != null) {
            this.doStore();
        }
    }
}

