/*
 * Copyright(c) 2005- C/pHeR.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

/**
 * Constant definitions for plug-in preferences
 */
public class JStyleConstants {

	public static final String P_LINE_BREAK = "LineBreakPreference";
	public static final String P_TAB = "TabPreference";
	public static final String P_FULL_WIDTH_SPACE = "FullWidthSpacePreference";
	public static final String P_HALF_WIDTH_SPACE = "HalfWidthSpacePreference";
	public static final String P_FORCE_MONOSPACE = "ForceMonospacePreference";
	
	public static final String SUFFIX_SHOW = "_SHOW";
	public static final String SUFFIX_COLOR = "_COLOR";
	public static final String SUFFIX_COMBO = "_COMBO";
	
	public static final String DEFAULT_RGB_STRING =
		StringConverter.asString(new RGB(192, 192, 192));
	
	public static final String TAB_GT = ">";
	public static final String TAB_ARROW = "";
	public static final String TAB_HAT = "^";
	
	public static final String[][] comboNamesAndValues = new String[][]{
			{JStyleConstants.TAB_GT,	JStyleConstants.TAB_GT},
			{JStyleConstants.TAB_ARROW,	JStyleConstants.TAB_ARROW},
			{JStyleConstants.TAB_HAT,	JStyleConstants.TAB_HAT},
	};
}
