/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.generator.ValidationResult;
import jp.sourceforge.mergedoc.pleiades.log.FileLogger;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.SystemOutLogger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PatternCache;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public abstract class AbstractValidator {
    protected static final PropertySet vTermProp = new PropertySet("props/validation-term.properties");
    protected static final PropertySet vTransProp = new PropertySet("props/validation-translation.properties");
    protected static final PropertySet vTransReverseProp = new PropertySet("props/validation-translation-reverse.properties");
    protected static final Set<String> vForbiddenTransSet = new PropertySet("props/validation-forbidden-translation.properties").keySet();
    protected static final Set<String> vIgnoreSet = new PropertySet("props/validation-ignore.properties").keySet();
    protected static final List<Pattern> ADJACENT_WORD_SPACE_PATTERN_LIST = Collections.unmodifiableList(new ArrayList<Pattern>(){
        {
            String IGNORE_CHAR = "\\p{ASCII}\uff08\uff09\u300c\u300d\u3001\u3002\u2026\u00ae";
            this.add(Pattern.compile("([^" + IGNORE_CHAR + "\\(])(\\p{Alnum})"));
            this.add(Pattern.compile("(\\p{Alnum})([^" + IGNORE_CHAR + "\\)])"));
        }
    });
    protected final Logger log = Logger.getLogger(this.getClass());
    protected final Logger validationLog;
    protected final String validationLogFileName;
    protected int totalErrorCount;
    protected int totalWarnCount;
    protected final PropertySet existsProp = new PropertySet();

    public AbstractValidator(PropertySet ... existsProps) {
        this.validationLogFileName = "";
        this.validationLog = Logger.getLogger("Validator", SystemOutLogger.class, Logger.Level.ERROR);
        for (PropertySet ps : existsProps) {
            this.existsProp.putAll(ps);
        }
    }

    public AbstractValidator(String logFileName, PropertySet ... existsProps) {
        if (!logFileName.endsWith(".log")) {
            throw new IllegalArgumentException("\u30ed\u30b0\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u62e1\u5f35\u5b50\u304c\u4e0d\u6b63\u3067\u3059\u3002" + logFileName);
        }
        this.validationLogFileName = Files.toVcIgnoreName(logFileName);
        this.validationLog = Logger.getLogger("Validator", FileLogger.class, this.getLogFileLogLevel(), Files.conf(this.validationLogFileName));
        for (PropertySet ps : existsProps) {
            this.existsProp.putAll(ps);
        }
    }

    protected Logger.Level getLogFileLogLevel() {
        return Logger.Level.WARN;
    }

    public boolean isSuccess() {
        return this.totalErrorCount == 0 && this.totalWarnCount == 0;
    }

    public String getLogFileName() {
        return this.validationLogFileName;
    }

    public void logEndMessage(String message) {
        String msg = message + " \u30a8\u30e9\u30fc:" + this.totalErrorCount + "\u3001\u8b66\u544a:" + this.totalWarnCount;
        this.log.info(msg + "\u3001conf/" + this.validationLogFileName, new Object[0]);
        if (this.isSuccess()) {
            this.validationLog.info(msg, new Object[0]);
        } else {
            this.validationLog.error(msg, new Object[0]);
        }
    }

    protected ValidationContext createValidationContext(String en, String ja, String name) {
        return new ValidationContext(en, ja, name);
    }

    protected Property getIllegalTranslationProperty(String en, String ja) {
        for (Property vTrans : vTransProp) {
            String enPart = "(?s)" + vTrans.key;
            String jaPart = "(?s)" + vTrans.value;
            if (!en.matches(enPart) || ja.matches(jaPart)) continue;
            return vTrans;
        }
        for (Property vTrans : vTransReverseProp) {
            String jaPart = "(?s)" + vTrans.key;
            String enPart = "(?s)" + vTrans.value;
            if (!ja.matches(jaPart) || en.matches(enPart)) continue;
            return vTrans;
        }
        return null;
    }

    protected String getIllegalBindParameter(String en, String ja) {
        Matcher mat = PatternCache.get("\\{[0-9]\\}").matcher(ja);
        while (mat.find()) {
            String group = mat.group();
            if (en.contains(group)) continue;
            return group;
        }
        return null;
    }

    public boolean isForbidden(String en) {
        if (vForbiddenTransSet.contains(en)) {
            return true;
        }
        return en.matches("[\\d+\\{\\}\\.,'\"\\s]+");
    }

    protected class ValidationContext
    extends ValidationResult {
        protected final String en;
        protected final String ja;
        protected final String name;

        public ValidationContext(String en, String ja, String name) {
            this.en = en;
            this.ja = ja;
            this.name = name;
        }

        protected void info(String msg) {
            AbstractValidator.this.validationLog.info(this.formatMessage(msg), new Object[0]);
        }

        protected void warn(String msg) {
            AbstractValidator.this.validationLog.warn(this.formatMessage(msg), new Object[0]);
            ++this.warnCount;
            ++AbstractValidator.this.totalWarnCount;
        }

        protected void error(String msg) {
            AbstractValidator.this.validationLog.error(this.formatMessage(msg), new Object[0]);
            ++this.errorCount;
            ++AbstractValidator.this.totalErrorCount;
        }

        protected String formatMessage(String msg) {
            String m = "\n\u82f1: " + Property.escapeKey(this.en) + "\n" + "\u65e5: " + Property.escapeValue(this.ja) + "\n" + msg + "\n";
            if (this.name != null && this.name.length() > 0) {
                m = this.name + m;
            }
            String indent = "      ";
            m = m.replace("\n", "\n" + indent);
            return m;
        }
    }
}

