/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.mergedoc.org.apache.commons.io.FileUtils;
import jp.sourceforge.mergedoc.org.apache.commons.lang.ArrayUtils;
import jp.sourceforge.mergedoc.pleiades.generator.TranslationRule;
import jp.sourceforge.mergedoc.pleiades.generator.Validator;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.RegexDictionary;

public class Generator {
    private static final Logger log = Logger.getLogger(Generator.class);
    private static final String REGEX_KEY_PREFIX = "%REGEX%";
    private static final String EXCLUDE_KEY_PREFIX = "%EXCLUDE%";
    private static final String IF_KEY_PREFIX = "%IF%";
    private static boolean isClean;

    public static void main(String ... args) throws IOException {
        String argStr = ArrayUtils.toString(args);
        isClean = argStr.contains("-clean");
        new Generator().run();
    }

    private void run() throws IOException {
        for (File logFile : Files.conf("props").listFiles(Files.createSuffixFilter(".log"))) {
            logFile.delete();
        }
        PropertySet babelProp = null;
        boolean updatedFile = false;
        if (!isClean && (this.isModified((Object)"translation.properties", "props/source/Eclipse_Babel.properties", "props/source/Eclipse_Help.properties") || this.isModified((Object)"translation.properties", Files.conf("props").listFiles(Files.createFileFilter())))) {
            log.info("Babel \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u66f4\u65b0\u3092\u691c\u51fa\u3057\u305f\u305f\u3081 -clean \u3067\u5b9f\u884c\u3057\u307e\u3059\u3002", new Object[0]);
            isClean = true;
            updatedFile = true;
        }
        if (isClean) {
            log.info("\u6821\u6b63\u6e08\u307f Babel \u8a00\u8a9e\u30d1\u30c3\u30af\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3059\u3002", new Object[0]);
            babelProp = new PropertySet("props/source/Eclipse_Babel.properties");
            log.info("\u6821\u6b63\u6e08\u307f Babel \u8a00\u8a9e\u30d1\u30c3\u30af\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306b\u7ffb\u8a33\u30eb\u30fc\u30eb\u3092\u9069\u7528\u5206\u5272\u4e2d...", new Object[0]);
            babelProp = new TranslationRule("props/source/Eclipse_Babel.properties_rule.log", new PropertySet[0]).apply(babelProp);
            babelProp.store("props/temp-Eclipse_Babel.properties", "\u6821\u6b63\uff06\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (\u691c\u8a3c\u524d\u4e00\u6642\u30d5\u30a1\u30a4\u30eb)");
            log.info("\u6821\u6b63\u6e08\u307f Babel \u8a00\u8a9e\u30d1\u30c3\u30af\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u554f\u984c\u9664\u53bb\u4e2d (\u7ffb\u8a33\u30eb\u30fc\u30eb\u9069\u7528\u5206\u5272\u5f8c) ...", new Object[0]);
            Validator v = new Validator("props/source/Eclipse_Babel.properties_validate.log", new PropertySet[0]);
            v.validate(babelProp);
            this.exitIfValidationError(v);
            babelProp.store("props/temp-Eclipse_Babel.properties", "\u6821\u6b63\uff06\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f\u8a00\u8a9e\u30d1\u30c3\u30af\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
        } else {
            log.info("\u6821\u6b63\uff06\u30eb\u30fc\u30eb\u9069\u7528\u6e08\u307f Babel \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3059\u3002", new Object[0]);
            babelProp = new PropertySet("props/temp-Eclipse_Babel.properties");
        }
        PropertySet outTransProp = new PropertySet();
        PropertySet outRegexProp = new PropertySet();
        PropertySet outExcludeProp = new PropertySet();
        Validator v = new Validator("props/temp-all.properties_validate.log", babelProp);
        File[] dirs = Files.conf("props/source").listFiles(Files.createDirectoryFilter());
        Arrays.sort(dirs, new Comparator<File>(){

            @Override
            public int compare(File dir1, File dir2) {
                String dir1Name = dir1.getName();
                return dir1Name.equals("EPL") ? 1 : dir1Name.compareTo(dir2.getName());
            }
        });
        for (File file : dirs) {
            String license = file.getName();
            if (license.startsWith(".")) continue;
            File regexPropFile = Files.conf("props/source/regex-" + license + ".properties");
            File excludePropFile = Files.conf("props/source/exclude-" + license + ".properties");
            File transPropFile = Files.conf("props/translation-" + license + ".properties");
            PropertySet regexProp = new PropertySet();
            PropertySet excludeProp = new PropertySet();
            PropertySet transProp = new PropertySet();
            Object[] propFiles = file.listFiles(Files.createSuffixFilter(".properties"));
            boolean updatedPerLicense = false;
            if (!isClean && this.isModified((Object)"translation.properties", (File[])propFiles)) {
                updatedPerLicense = true;
                updatedFile = true;
                log.info("\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u3092\u691c\u51fa\u3057\u307e\u3057\u305f\u3002" + license, new Object[0]);
            }
            if (isClean || updatedPerLicense) {
                Arrays.sort(propFiles);
                for (Object propFile : propFiles) {
                    PropertySet addProp = new PropertySet(new File[]{propFile});
                    log.debug("Loaded %s %d", ((File)propFile).getName(), addProp.size());
                    for (Property p : addProp) {
                        String newKey;
                        if (p.key.startsWith(REGEX_KEY_PREFIX)) {
                            newKey = p.key.replaceFirst("^%REGEX%", "").trim();
                            String newVal = p.value.trim();
                            if (newKey.endsWith(".") && !newKey.endsWith("\\.")) {
                                log.warn("\u6b63\u898f\u8868\u73fe\u4e0d\u6b63 - \u672b\u5c3e\u30c9\u30c3\u30c8\u672a\u30a8\u30b9\u30b1\u30fc\u30d7: " + ((File)propFile).getName() + ": " + newKey, new Object[0]);
                            }
                            if (newKey.endsWith("?") && !newKey.endsWith("\\?")) {
                                log.error("\u6b63\u898f\u8868\u73fe\u4e0d\u6b63 - \u672b\u5c3e ? \u672a\u30a8\u30b9\u30b1\u30fc\u30d7: " + ((File)propFile).getName() + ": " + newKey, new Object[0]);
                                System.exit(-1);
                            }
                            if (newKey.startsWith("(?s)")) {
                                log.warn("\u6b63\u898f\u8868\u73fe\u4e0d\u6b63 - DOTALL (?s) \u30d5\u30e9\u30b0\u9664\u53bb: " + ((File)propFile).getName() + ": " + newKey, new Object[0]);
                                newKey = newKey.substring(4);
                            }
                            regexProp.put(newKey, newVal);
                            continue;
                        }
                        if (p.key.startsWith(EXCLUDE_KEY_PREFIX)) {
                            newKey = p.key.replaceFirst("^%EXCLUDE%", "").trim();
                            Object existsValue = outExcludeProp.get(newKey);
                            if (existsValue != null) {
                                p.value = existsValue + "," + p.value;
                            }
                            excludeProp.put(newKey, p.value);
                            continue;
                        }
                        v.validate(p, ((File)propFile).getName());
                        transProp.put(p);
                    }
                }
                v.logEndMessage("\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ") \u691c\u8a3c\u7d50\u679c");
                this.exitIfValidationError(v);
                log.info("\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ") \u306b\u7ffb\u8a33\u30eb\u30fc\u30eb\u3092\u9069\u7528\u5206\u5272\u4e2d...", new Object[0]);
                transProp = new TranslationRule("props/temp-all.properties_rule.log", babelProp).apply(transProp);
                log.info("\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ") \u306e\u554f\u984c\u9664\u53bb\u4e2d (\u7ffb\u8a33\u30eb\u30fc\u30eb\u9069\u7528\u5206\u5272\u5f8c) ...", new Object[0]);
                v = new Validator("props/temp-all.properties_validate.log", babelProp);
                transProp = v.remove(transProp);
                this.exitIfValidationError(v);
                if (license.equals("EPL")) {
                    PropertySet mergedProp = new PropertySet();
                    mergedProp.load("props/source/Eclipse_Help.properties");
                    mergedProp.putAll(transProp);
                    mergedProp.putAll(babelProp);
                    transProp = mergedProp;
                }
                transProp.store(transPropFile, "\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ")");
                regexProp.store(regexPropFile, "\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u6b63\u898f\u8868\u73fe\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ")");
                excludeProp.store(excludePropFile, "\u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u9664\u5916\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (" + license + ")");
            } else {
                transProp.load(transPropFile);
                regexProp.load(regexPropFile);
                excludeProp.load(excludePropFile);
            }
            outTransProp.putAll(transProp);
            outRegexProp.putAll(regexProp);
            outExcludeProp.putAll(excludeProp);
        }
        if (!updatedFile && !isClean) {
            log.info("\u66f4\u65b0\u306a\u3057", new Object[0]);
            return;
        }
        HashMap<String, PropertySet> pkgConditionMap = new HashMap<String, PropertySet>();
        ArrayList<String> pkgRemoveKeys = new ArrayList<String>();
        for (Property property : outTransProp) {
            if (!property.key.startsWith(IF_KEY_PREFIX)) continue;
            pkgRemoveKeys.add(property.key);
            String check = property.key + property.value;
            if (check.contains(",") || check.contains("=")) {
                throw new IllegalStateException("[,=] \u4f7f\u7528\u4e0d\u53ef: " + property);
            }
            String[] key = property.key.replaceFirst("^%IF%", "").trim().split(">");
            if (key.length != 2) {
                throw new IllegalStateException("\u533a\u5207\u308a\u6587\u5b57 '>' \u6b20\u843d " + property);
            }
            String pkg = key[0];
            String en = key[1];
            PropertySet pkgJaMap = (PropertySet)pkgConditionMap.get(en);
            if (pkgJaMap == null) {
                pkgJaMap = new PropertySet();
                pkgConditionMap.put(en, pkgJaMap);
            }
            pkgJaMap.put(pkg, property.value);
        }
        for (String string : pkgRemoveKeys) {
            outTransProp.remove(string);
        }
        for (Map.Entry entry : pkgConditionMap.entrySet()) {
            String en = (String)entry.getKey();
            String jaDefault = (String)outTransProp.get(en);
            StringBuilder sb = new StringBuilder();
            sb.append(IF_KEY_PREFIX);
            sb.append(jaDefault);
            sb.append(",");
            for (Property pkgJa : (PropertySet)entry.getValue()) {
                sb.append(pkgJa.key);
                sb.append("=");
                sb.append(pkgJa.value);
                sb.append(",");
            }
            String pkgValues = sb.toString().replaceFirst(",$", "");
            outTransProp.put(en, pkgValues);
            log.info("\u30d1\u30c3\u30b1\u30fc\u30b8\u6761\u4ef6\u30d7\u30ed\u30d1\u30c6\u30a3: " + en + "=" + pkgValues, new Object[0]);
            if (jaDefault != null) continue;
            throw new IllegalStateException("\u30d1\u30c3\u30b1\u30fc\u30b8\u6761\u4ef6\u30d7\u30ed\u30d1\u30c6\u30a3\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        log.info("\u512a\u5148\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u62bd\u51fa\u3057\u307e\u3059\u3002", new Object[0]);
        PropertySet outFirstProp = new PropertySet();
        RegexDictionary regexDictionary = RegexDictionary.getInstance();
        for (Property p : outTransProp) {
            if (p.key.length() != p.key.getBytes().length) {
                outFirstProp.put(p);
                continue;
            }
            String enRegexResult = regexDictionary.lookup(p.key);
            if (enRegexResult == null) continue;
            outFirstProp.put(p);
            log.debug("--------------------------------------------------------------", new Object[0]);
            log.debug("\u901a\u5e38\u7ffb\u8a33: %s [%s]", p.value, p.key);
            log.debug("\u6b63\u898f\u8868\u73fe: %s", enRegexResult);
        }
        PropertySet noSplitProp = new PropertySet("props/validation-no-split.properties");
        Validator noSpV = new Validator("props/validation-no-split.properties_validate.log", outTransProp);
        noSpV.validate(noSplitProp);
        this.exitIfValidationError(noSpV);
        outFirstProp.putAll(noSplitProp);
        for (Property p : new TranslationRule(new PropertySet[0]).apply(noSplitProp)) {
            if (outTransProp.containsKey(p.key)) continue;
            outTransProp.put(p);
        }
        for (Property p : outFirstProp) {
            outTransProp.remove(p.key);
        }
        log.info("\u5f37\u5236\u30c8\u30ea\u30e0\u3057\u307e\u3059\u3002", new Object[0]);
        int dupl = 0;
        int same = 0;
        int diff = 0;
        int repl = 0;
        for (Property p : new PropertySet(outTransProp)) {
            String enTrim = new TranslationString(p.key).trimForce();
            String jaTrim = new TranslationString(p.value).trimForce();
            if (v.isForbidden(enTrim)) continue;
            if (enTrim.equals(jaTrim)) {
                outTransProp.remove(p.key);
                ++same;
                continue;
            }
            if (p.key.equals(enTrim) || p.value.equals(jaTrim)) continue;
            String jaOther = (String)outTransProp.get(enTrim);
            if (jaOther != null) {
                TranslationString jaTsDup = new TranslationString(jaOther);
                String jaTrimOther = jaTsDup.trimForce();
                if (jaTrimOther.equals(jaTrim)) {
                    outTransProp.remove(p.key);
                    ++dupl;
                    continue;
                }
                ++diff;
                continue;
            }
            outTransProp.remove(p.key);
            outTransProp.put(enTrim, jaTrim);
            ++repl;
        }
        log.info("\u5f37\u5236\u30c8\u30ea\u30e0 (\u65e2\u5b58\u91cd\u8907\u524a\u9664:%d, \u30ad\u30fc\u3068\u5024\u540c\u4e00\u524a\u9664:%d, \u76f8\u9055\u306e\u305f\u3081\u5909\u66f4\u7121\u3057:%d, \u30c8\u30ea\u30e0\u5f8c\u306b\u7f6e\u63db:%d)", dupl, same, diff, repl);
        int maxLen = 0;
        for (Property p : outTransProp) {
            maxLen = Math.max(maxLen, p.key.length());
        }
        log.info("\u82f1\u8a9e\u6700\u5927\u9577: " + maxLen, new Object[0]);
        Generator.storeHistory(outTransProp, "props/temp-all.properties", "\u8f9e\u66f8\u5168\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\uff08\u751f\u6210\u78ba\u8a8d\u7528\u30c6\u30f3\u30dd\u30e9\u30ea\u30fc\uff09");
        outTransProp.store("translation.properties", "\u7ffb\u8a33\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u30e9\u30a4\u30bb\u30f3\u30b9\u5225\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30de\u30fc\u30b8\u3057\u305f\u3082\u306e\u3067\u3001\n  Pleiades \u304c\u5b9f\u884c\u6642\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  \n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/translation-*.properties\n  \n  \u53e5\u70b9\u89e3\u6790\u306b\u3088\u308a\u30a8\u30f3\u30c8\u30ea\u30fc\u306f\u53ef\u80fd\u306a\u9650\u308a\u6587\u5358\u4f4d\u306b\u5206\u5272\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u307e\u305f\u3001\n  \u91cd\u8907\u9632\u6b62\u3084\u30ea\u30bd\u30fc\u30b9\u3001\u30e1\u30e2\u30ea\u30fc\u6d88\u8cbb\u91cf\u4f4e\u6e1b\u306e\u305f\u3081\u3001\u6b21\u306e\u3088\u3046\u306a\u6587\u5b57\u306f\n  \u9664\u53bb\u3055\u308c\u3066\u304a\u308a\u3001\u7ffb\u8a33\u6642\u306f\u539f\u6587\u3092\u5143\u306b\u81ea\u52d5\u7684\u306b\u88dc\u5b8c\u3055\u308c\u307e\u3059\u3002\n  \n  \u30fb\u30cb\u30fc\u30e2\u30cb\u30c3\u30af\uff1a\u82f1\u8a9e\u306e\u5834\u5408\u306f & 1 \u6587\u5b57\u3001\u65e5\u672c\u8a9e\u306e\u5834\u5408\u306f (&x) 4 \u6587\u5b57\n  \u30fb\u5148\u982d\u30fb\u672b\u5c3e\u306e\u9023\u7d9a\u3059\u308b\u7a7a\u767d\uff1a\\r\u3001\\n\u3001\\t\u3001\u534a\u89d2\u30b9\u30da\u30fc\u30b9\n  \u30fb\u524d\u5f8c\u306e\u56f2\u307f\u6587\u5b57 ()\u3001[]\u3001<>\u3001\"\"\u3001''\u3001!! \u306a\u3069 (\u524d\u5f8c\u306e\u7d44\u307f\u5408\u308f\u305b\u304c\u4e00\u81f4\u3059\u308b\u5834\u5408)\n  \u30fb\u5148\u982d\u306e IWAB0001E \u306e\u3088\u3046\u306a Eclipse \u56fa\u6709\u30e1\u30c3\u30bb\u30fc\u30b8\u30fb\u30b3\u30fc\u30c9\n  \u30fb\u8907\u6570\u5f62\u3092\u793a\u3059 (s) (\u79d2\u3092\u793a\u3059\u3082\u306e\u3067\u306f\u306a\u3044\u5834\u5408)");
        if (updatedFile) {
            Files.conf("translation.properties").setLastModified(System.currentTimeMillis());
        }
        outRegexProp.store("translation-regex.properties", "\u6b63\u898f\u8868\u73fe\u8f9e\u66f8\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u6b63\u898f\u8868\u73fe\u3067\u7ffb\u8a33\u3059\u308b\u305f\u3081\u306e\u8f9e\u66f8\u3067\u3001Pleiades \u304c\u5b9f\u884c\u6642\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  \u5e38\u306b DOTALL \u30e2\u30fc\u30c9\u3067\u52d5\u4f5c\u3059\u308b\u305f\u3081\u5b9a\u7fa9\u3067\u306f\u5148\u982d\u306e (?s) \u306f\u4e0d\u8981\u3067\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/source/*.properties \u306e\u30ad\u30fc\u5148\u982d\u306b %REGEX% \u304c\u3042\u308b\u9805\u76ee");
        outExcludeProp.store("translation-exclude-package.properties", "\u7ffb\u8a33\u9664\u5916\u30d1\u30c3\u30b1\u30fc\u30b8\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u7ffb\u8a33\u3092\u547c\u3073\u51fa\u3057\u5143\u968e\u5c64 Java \u30d1\u30c3\u30b1\u30fc\u30b8\u5358\u4f4d\u3067\u9664\u5916\u8a33\u3059\u308b\u305f\u3081\u306e\u8f9e\u66f8\u3067\u3001Pleiades \u304c\u5b9f\u884c\u6642\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  xml \u5b9a\u7fa9\u306e excludeTrace \u3068\u7570\u306a\u308a advice \u306b ?{JOINT_POINT} \u6307\u5b9a\u306f\u4e0d\u8981\u3067\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/source/*.properties \u306e\u30ad\u30fc\u5148\u982d\u306b %EXCLUDE% \u304c\u3042\u308b\u9805\u76ee");
        outFirstProp.store("translation-first.properties", "\u7ffb\u8a33\u512a\u5148\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304b\u3089\u30ad\u30fc\u306b\u30de\u30eb\u30c1\u30fb\u30d0\u30a4\u30c8\u304c\u542b\u307e\u308c\u308b\u3082\u306e\u3001\u304a\u3088\u3073\u6b63\u898f\u8868\u73fe\u8f9e\u66f8\u306b\u4e00\u81f4\u3059\u308b\u30a8\u30f3\u30c8\u30ea\u30fc\u3092\n  \u62bd\u51fa\u3057\u305f\u8f9e\u66f8\u3067\u3001Pleiades \u304c\u5b9f\u884c\u6642\u306b\u6b63\u898f\u8868\u73fe\u8f9e\u66f8\u3088\u308a\u5148\u306b\u53c2\u7167\u3057\u307e\u3059\u3002\n  \u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30ed\u30fc\u30c9\u6291\u6b62\u5224\u5b9a\u306e\u305f\u3081\u306b\u4f7f\u7528\u3055\u308c\u307e\u3059\u3002");
    }

    private boolean isModified(Object dstObj, String ... srcs) {
        ArrayList<File> list = new ArrayList<File>();
        for (String src : srcs) {
            list.add(Files.conf(src));
        }
        File[] srcArray = list.toArray(new File[list.size()]);
        File dstFile = dstObj instanceof String ? Files.conf((String)dstObj) : (File)dstObj;
        return this.isModified((Object)dstFile, srcArray);
    }

    private boolean isModified(Object dstObj, File ... srcs) {
        File dstFile = dstObj instanceof String ? Files.conf((String)dstObj) : (File)dstObj;
        for (File src : srcs) {
            if (src.lastModified() <= dstFile.lastModified()) continue;
            log.info("\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u66f4\u65b0\u691c\u51fa %s", src.getName());
            log.info("\u66f4\u65b0\u6642\u523b (\u51fa\u529b): %1$tF %1$tT - %2$s", dstFile.lastModified(), dstFile.getName());
            log.info("\u66f4\u65b0\u6642\u523b (\u5165\u529b): %1$tF %1$tT - %2$s", src.lastModified(), src.getName());
            return true;
        }
        return false;
    }

    private void exitIfValidationError(Validator validator) throws IOException {
        if (!validator.isSuccess()) {
            File logFile = Files.conf(validator.getLogFileName());
            String s = FileUtils.readFileToString(logFile, "UTF-8");
            log.info(s, new Object[0]);
            log.error("\u691c\u8a3c\u30a8\u30e9\u30fc\u306e\u305f\u3081\u3001\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3059\u3002", new Object[0]);
            System.exit(-1);
        }
    }

    public static void storeHistory(PropertySet prop, String path, String comment) throws IOException {
        List<String> keyList = prop.store(path, comment);
        if (keyList == null) {
            return;
        }
        File textFile = Files.conf(Files.toVcIgnoreName(path + ".txt"));
        if (textFile.exists()) {
            File textOldFile = Files.conf(Files.toVcIgnoreName(path + "_old.txt"));
            textOldFile.delete();
            textFile.renameTo(textOldFile);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("#" + prop.size() + " \u30a8\u30f3\u30c8\u30ea\u30fc");
        for (String key : keyList) {
            String line = Property.toString(key, (String)prop.get(key));
            lines.add(line);
        }
        FileUtils.writeLines(textFile, "UTF-8", lines);
    }
}

