/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import jp.sourceforge.mergedoc.org.apache.commons.io.FileUtils;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.generator.Generator;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.SystemOutLogger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public abstract class AbstractExtractor {
    protected static final Logger log = Logger.getLogger("Extractor", SystemOutLogger.class, Logger.Level.INFO);
    protected static File inNlsFolder = Files.conf("../../Pleiades.nls/90.current");
    protected final String tempRoot = "props/temp";
    protected File extractTempFolder;
    protected String extractPropPath;
    protected int count;
    protected String debugEnValue;
    protected final PropertySet missingProp = new PropertySet();

    protected void run(String outFolderName, String ... args) throws IOException {
        if (args.length != 0 && StringUtils.isNotBlank(args[0])) {
            this.debugEnValue = args[0];
            log.info("\u5f15\u6570\u306b\u6307\u5b9a\u3055\u308c\u305f [" + this.debugEnValue + "] \u306e NLS \u53d6\u5f97\u5143\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u78ba\u8a8d\u3057\u307e\u3059\u3002\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306f\u51fa\u529b\u3055\u308c\u307e\u305b\u3093\u3002", new Object[0]);
        }
        if (!inNlsFolder.exists()) {
            String msg = "\u8a00\u8a9e\u30d1\u30c3\u30af\u3068\u305d\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u672c\u5916\u304c\u683c\u7d0d\u3055\u308c\u305f " + inNlsFolder + " \u304c\u5b58\u5728\u3057\u306a\u3044\u305f\u3081\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002";
            log.error(msg, new Object[0]);
            throw new IllegalStateException(msg);
        }
        this.extractTempFolder = Files.conf("props/temp/" + outFolderName);
        this.doExtract();
        this.extractPropPath = "props/temp/nls-" + outFolderName + ".properties";
        String missingPropPath = "props/temp/nls-" + outFolderName + "-missing.properties";
        this.extractTempFolder.mkdirs();
        PropertySet extracteProp = new PropertySet(this.extractTempFolder);
        if (StringUtils.isBlank(this.debugEnValue)) {
            Generator.storeHistory(extracteProp, this.extractPropPath, "eclipse.org \u8a00\u8a9e\u30d1\u30c3\u30af " + outFolderName + " \u62bd\u51fa\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n" + "  \u30d7\u30e9\u30b0\u30a4\u30f3\u5225\u306e\u8a00\u8a9e\u30d1\u30c3\u30af\u8f9e\u66f8\u3092\u30de\u30fc\u30b8\u3057\u305f\u3082\u306e\u3067\u3059\u3002\n" + "  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1aprops/temp/" + outFolderName + "/*.properties");
            Generator.storeHistory(this.missingProp, missingPropPath, "eclipse.org \u8a00\u8a9e\u30d1\u30c3\u30af\u62bd\u51fa\u672a\u7ffb\u8a33\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\n\n  \u8a00\u8a9e\u30d1\u30c3\u30af\u62bd\u51fa\u6642\u306b\u8a33\u304c\u898b\u3064\u304b\u3089\u306a\u304b\u3063\u305f\u9805\u76ee\u306e\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3067\u3059\u3002\n  \u5165\u529b\u5143\u30d5\u30a1\u30a4\u30eb\uff1anls/*/*/*");
        }
        log.info(this.extractPropPath + " " + extracteProp.size() + " (" + this.count + ")", new Object[0]);
        log.info(missingPropPath + " " + this.missingProp.size(), new Object[0]);
        this.afterExtract(extracteProp);
    }

    protected void doExtract() throws IOException {
        if (StringUtils.isBlank(this.debugEnValue)) {
            FileUtils.deleteDirectory(this.extractTempFolder);
            this.extractTempFolder.mkdirs();
        }
        this.extract(inNlsFolder);
    }

    protected void afterExtract(PropertySet extractProp) throws IOException {
    }

    protected void extract(File nlsFolder) throws IOException {
        Object[] dirs = nlsFolder.listFiles(Files.createDirectoryFilter());
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            String name = ((File)dir).getName();
            if (name.equals("plugins") || name.equals("features")) {
                this.extractPlugins((File)dir);
                continue;
            }
            this.extract((File)dir);
        }
    }

    protected abstract void extractPlugins(File var1) throws IOException;
}

