/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jp.sourceforge.mergedoc.org.apache.commons.io.IOUtils;
import jp.sourceforge.mergedoc.pleiades.generator.nls.PropertySetUnit;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;

public class Plugin
extends PropertySetUnit {
    private static final Logger log = Logger.getLogger(Plugin.class);
    private final File root;
    private String id;

    public Plugin(File pluginFile) {
        this.root = pluginFile;
        if (pluginFile.isDirectory()) {
            this.loadFolderPlugin(pluginFile);
        } else {
            this.loadJarPlugin(pluginFile);
        }
        if (this.id == null) {
            throw new NullPointerException("\u30d7\u30e9\u30b0\u30a4\u30f3 ID \u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + pluginFile.getName());
        }
    }

    protected void loadFolderPlugin(File pluginFolder) {
        BufferedInputStream is;
        block6: {
            is = null;
            try {
                File manifest = new File(pluginFolder, "META-INF/MANIFEST.MF");
                if (manifest.exists()) {
                    is = new BufferedInputStream(new FileInputStream(manifest));
                    this.setIdInManifestFile(is);
                    break block6;
                }
                File fragmentXML = new File(pluginFolder, "fragment.xml");
                if (fragmentXML.exists()) {
                    is = new BufferedInputStream(new FileInputStream(fragmentXML));
                    this.setIdInFragmentXML(is);
                    break block6;
                }
                this.setIdInFileName(pluginFolder);
            }
            catch (IOException e) {
                try {
                    throw new IllegalArgumentException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(is);
        this.loadFolder(pluginFolder);
    }

    private void loadJarPlugin(File jar) {
        this.setIdInFileName(jar);
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(jar)));
            ZipEntry inEntry = null;
            while ((inEntry = zis.getNextEntry()) != null) {
                String entryName = inEntry.getName();
                if (entryName.equals("META-INF/MANIFEST.MF")) {
                    this.setIdInManifestFile(zis);
                    continue;
                }
                if (entryName.equals("fragment.xml")) {
                    this.setIdInFragmentXML(zis);
                    continue;
                }
                if (entryName.matches(".*?(.jar|.zip)$")) {
                    ZipInputStream zisI = new ZipInputStream(zis);
                    ZipEntry inEntryI = null;
                    while ((inEntryI = zisI.getNextEntry()) != null) {
                        String name = this.getPluginPath(jar) + "/" + entryName + "/" + inEntryI.getName();
                        this.setupProperties(name, zisI);
                    }
                    continue;
                }
                String path = this.getPluginPath(jar) + "/" + entryName;
                this.setupProperties(path, zis);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zis);
    }

    protected void loadFolder(File folder) {
        Object[] files = folder.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            if (((File)file).isDirectory()) {
                this.loadFolder((File)file);
                continue;
            }
            if (((File)file).getName().matches(".*?(.jar|.zip)$")) {
                this.loadZipFile((File)file);
                continue;
            }
            this.setupProperties(this.getPluginPath((File)file), file);
        }
    }

    private void loadZipFile(File zip) {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            ZipEntry inEntry = null;
            while ((inEntry = zis.getNextEntry()) != null) {
                String path = this.getPluginPath(zip) + "/" + inEntry.getName();
                this.setupProperties(path, zis);
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(this.getPluginPath(zip), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zis);
    }

    protected String getPluginPath(File file) {
        return this.root.getName() + Files.relativePath(this.root, file).replace("\\", "/");
    }

    protected void setupProperties(String path, Object in) {
        String rootName;
        if (path.endsWith("_ja.properties") || path.endsWith("_ja_JP.properties")) {
            this.processProperties(this.getJaPropertySet(), in);
        } else if (!path.matches("^.*_\\w{2}\\.properties$") && path.endsWith(".properties") && !(rootName = this.root.getName()).matches("^.*?(\\.nls1_|\\.nl1_).*$")) {
            this.processProperties(this.getEnPropertySet(), in);
        }
    }

    private void processProperties(PropertySet prop, Object in) {
        if (in instanceof File) {
            prop.load((File)in);
        } else if (in instanceof InputStream) {
            prop.load((InputStream)in);
        } else {
            throw new IllegalArgumentException("\u4e88\u671f\u3057\u306a\u3044\u578b\uff1a" + in.getClass().getName());
        }
    }

    private void setIdInManifestFile(InputStream is) throws IOException {
        if (this.getId() != null) {
            return;
        }
        Attributes attributes = new Manifest(is).getMainAttributes();
        String value = attributes.getValue("Fragment-Host");
        if (value == null) {
            value = attributes.getValue("Bundle-SymbolicName");
        }
        if (value != null) {
            this.setId(value.split(";")[0].trim());
        }
    }

    private void setIdInFragmentXML(InputStream is) throws IOException {
        if (this.getId() != null) {
            return;
        }
        String fragment = IOUtils.toString(is, "UTF-8");
        this.setId(fragment.replaceFirst("(?s)^.*plugin-id=\"(.*?)\".*$", "$1"));
    }

    protected void setIdInFileName(File pluginFolder) {
        if (this.getId() != null) {
            return;
        }
        String name = pluginFolder.getName();
        name = name.replaceFirst("\\.(nls1|nl1|nl_ja)", "");
        name = name.replaceFirst("_[0-9]+\\.[0-9]+\\.[0-9]+.*$", "");
        this.setId(name);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

