/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.generator.nls;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.generator.nls.AbstractExtractor;
import jp.sourceforge.mergedoc.pleiades.generator.nls.Feature;
import jp.sourceforge.mergedoc.pleiades.generator.nls.Plugin;
import jp.sourceforge.mergedoc.pleiades.generator.nls.PropertySetUnit;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.SystemOutLogger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;

public class UIExtractor
extends AbstractExtractor {
    public static void main(String ... args) throws IOException {
        Logger.init(SystemOutLogger.class, Logger.Level.ERROR);
        new UIExtractor().run("ui", "");
    }

    @Override
    protected void extractPlugins(File pluginsFolder) throws IOException {
        HashMap<String, PropertySetUnit> pluginMap = new HashMap<String, PropertySetUnit>();
        Object[] pluginFiles = pluginsFolder.listFiles();
        Arrays.sort(pluginFiles);
        for (Object pluginFile : pluginFiles) {
            Plugin plugin = pluginsFolder.getName().equals("plugins") ? new Plugin((File)pluginFile) : new Feature((File)pluginFile);
            String msg = "%-46s en:%4d ja:%4d %s";
            log.info(String.format(msg, plugin.getId(), plugin.getEnPropertySet().size(), plugin.getJaPropertySet().size(), Files.relativePath(inNlsFolder, (File)pluginFile)), new Object[0]);
            String pluginId = plugin.getId();
            PropertySetUnit propUnit = (PropertySetUnit)pluginMap.get(pluginId);
            if (propUnit == null) {
                propUnit = new PropertySetUnit();
                pluginMap.put(pluginId, propUnit);
            }
            propUnit.getEnPropertySet().putAll(plugin.getEnPropertySet());
            propUnit.getJaPropertySet().putAll(plugin.getJaPropertySet());
        }
        String pluginPath = Files.relativePath(inNlsFolder, pluginsFolder);
        for (Map.Entry entry : pluginMap.entrySet()) {
            PropertySetUnit propUnit = (PropertySetUnit)entry.getValue();
            PropertySet enProp = propUnit.getEnPropertySet();
            PropertySet jaProp = propUnit.getJaPropertySet();
            PropertySet outProp = new PropertySet();
            for (Property ja : jaProp) {
                String en;
                String trimEn;
                String enValue = (String)enProp.get(ja.key);
                if (!StringUtils.isNotEmpty(enValue) || enValue.equals(ja.value) || ja.value.matches("\\p{ASCII}+") || ja.value.contains("\u306e\u7ffb\u8a33\u7248\u3067\u3059") || ja.value.contains("\u306e\u305f\u3081\u306e\u30c9\u30a4\u30c4\u8a9e")) continue;
                String s = "/ [en]-(";
                if (ja.value.contains(s)) {
                    ja.value = ja.value.replaceFirst("\\s*" + Pattern.quote(s) + ".+", "");
                }
                outProp.put(enValue, ja.value);
                if (!StringUtils.isNotBlank(this.debugEnValue) || !(trimEn = new TranslationString(en = Mnemonics.removeEn(enValue).toLowerCase()).trimForce()).contains(this.debugEnValue)) continue;
                String pluginBaseName = pluginsFolder.getPath().replace("\\", "/");
                pluginBaseName = pluginBaseName.replaceFirst(".+/([^/]+?/[^/]+?)", "$1");
                String jaValue = Mnemonics.removeJa(ja.value);
                System.out.println(pluginBaseName + "/" + ja.key + "=" + new TranslationString(jaValue).trimForce());
            }
            int outPropSize = outProp.size();
            if (outPropSize > 0) {
                this.count += outPropSize;
                if (StringUtils.isBlank(this.debugEnValue)) {
                    String pluginId = (String)entry.getKey();
                    String outFileName = pluginPath.replace('\\', '@') + "@" + pluginId + ".properties";
                    File outFile = new File(this.extractTempFolder, outFileName);
                    outProp.store(outFile, "eclipse.org \u8a00\u8a9e\u30d1\u30c3\u30af\u62bd\u51fa\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc (\u30d7\u30e9\u30b0\u30a4\u30f3\u5225)");
                }
            }
            for (Property en : enProp) {
                String jaValue = (String)jaProp.get(en.key);
                if (jaValue != null || en.value == null || !en.value.matches("(?s).*[a-zA-Z].*") || en.value.length() <= 1) continue;
                this.missingProp.put(en.value, "");
            }
        }
    }
}

