/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.org.apache.commons.lang.ArrayUtils;
import jp.sourceforge.mergedoc.pleiades.log.SystemOutLogger;

public abstract class Logger {
    private static Map<String, Logger> loggerMap = new HashMap<String, Logger>();
    public static final String LOGGER_CLASS_NAME = "pleiades.logger.class.name";
    public static final String LOG_LEVEL = "pleiades.log.level";
    private final String category;
    private Level minLevel;

    public static Logger getLogger(Class<?> clazz) {
        return Logger.getLoggerInternal(Logger.getShortClassName(clazz));
    }

    public static Logger getLogger(String category) {
        return Logger.getLoggerInternal(category + "-Category");
    }

    public static Logger getLogger(String category, Class<? extends Logger> loggerClass, Level logLevel) {
        return Logger.getLogger(category, loggerClass, logLevel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String category, Class<? extends Logger> loggerClass, Level logLevel, File logFile) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            Logger logger;
            String lcn = System.getProperty(LOGGER_CLASS_NAME);
            String ll = System.getProperty(LOG_LEVEL);
            String lfn = System.getProperty("pleiades.log.file.name");
            try {
                Logger.init(loggerClass, logLevel, logFile);
                logger = Logger.getLogger(category);
            }
            catch (Throwable throwable) {
                Logger.setSystemProperty(LOGGER_CLASS_NAME, lcn);
                Logger.setSystemProperty(LOG_LEVEL, ll);
                Logger.setSystemProperty("pleiades.log.file.name", lfn);
                throw throwable;
            }
            Logger.setSystemProperty(LOGGER_CLASS_NAME, lcn);
            Logger.setSystemProperty(LOG_LEVEL, ll);
            Logger.setSystemProperty("pleiades.log.file.name", lfn);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return logger;
        }
    }

    public static void init(Class<? extends Logger> loggerClass, Level logLevel) {
        Logger.init(loggerClass, logLevel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Class<? extends Logger> loggerClass, Level logLevel, File logFile) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            Logger.setSystemProperty(LOGGER_CLASS_NAME, loggerClass == null ? null : loggerClass.getName());
            Logger.setSystemProperty(LOG_LEVEL, logLevel == null ? null : logLevel.toString());
            Logger.setSystemProperty("pleiades.log.file.name", logFile == null ? null : logFile.getAbsolutePath());
            loggerMap.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void setSystemProperty(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getLoggerInternal(String category) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            Logger logger = loggerMap.get(category);
            if (logger != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return logger;
            }
            String loggerClassName = System.getProperty(LOGGER_CLASS_NAME, SystemOutLogger.class.getName());
            try {
                Class<?> loggerClass = Class.forName(loggerClassName);
                Class<Logger> subClass = loggerClass.asSubclass(Logger.class);
                Constructor<Logger> cons = subClass.getDeclaredConstructor(String.class);
                cons.setAccessible(true);
                logger = cons.newInstance(category);
            }
            catch (Exception e) {
                throw new IllegalStateException("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3 pleiades.logger.class.name=" + loggerClassName + " \u306b\u6307\u5b9a\u3055\u308c\u305f\u30ed\u30ac\u30fc\u30af\u30e9\u30b9\u304c\u30ed\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
            }
            String logLevel = System.getProperty(LOG_LEVEL, Level.INFO.toString());
            try {
                logger.minLevel = Level.valueOf(logLevel.toUpperCase());
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("\u30b7\u30b9\u30c6\u30e0\u30d7\u30ed\u30d1\u30c6\u30a3 pleiades.log.level=" + logLevel + " \u306b\u6307\u5b9a\u3059\u308b\u5024\u306f " + Level.class.getName() + "\u3067\u5b9a\u7fa9\u3055\u308c\u305f\u578b\u3067\u3042\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            }
            loggerMap.put(category, logger);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return logger;
        }
    }

    private static String getShortClassName(Class<?> clazz) {
        return clazz.getName().replaceFirst("(\\w+\\.)+", "");
    }

    protected Logger(String category) {
        this.category = category;
    }

    protected abstract PrintStream getOut();

    protected void println(Level level, Throwable t, String message, Object ... args) {
        if (args.length == 1 && args[0] instanceof Exception) {
            throw new IllegalArgumentException("args \u306b\u4f8b\u5916\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\u3002");
        }
        message = this.format(message, args);
        Date date = new Date();
        String threadName = Thread.currentThread().getName();
        String s = this.format("%-5s %tT.%tL [%.20s] (%s) %s", new Object[]{level, date, date, threadName, this.category, message});
        PrintStream out = this.getOut();
        out.print(s + "\n");
        if (t != null) {
            t.printStackTrace(out);
        }
    }

    protected String format(String message, Object ... args) {
        if (message == null) {
            return "null";
        }
        if (args == null || args.length == 0) {
            return message;
        }
        try {
            return String.format(message, args);
        }
        catch (Exception e) {
            return message + ArrayUtils.toString(args) + " \u30ed\u30b0\u30fb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30fb\u30a8\u30e9\u30fc: " + e;
        }
    }

    public void debug(String message, Object ... args) {
        this.debug(null, message, args);
    }

    public void debug(Throwable e, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.println(Level.DEBUG, e, message, args);
        }
    }

    public void info(String message, Object ... args) {
        this.info(null, message, args);
    }

    public void info(Throwable e, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.println(Level.INFO, e, message, args);
        }
    }

    public void warn(String message, Object ... args) {
        this.warn(null, message, args);
    }

    public void warn(Throwable e, String message, Object ... args) {
        if (this.isWarnEnabled()) {
            this.println(Level.WARN, e, message, args);
        }
    }

    public void error(String message, Object ... args) {
        this.error(null, message, args);
    }

    public void error(Throwable e, String message, Object ... args) {
        if (this.isErrorEnabled()) {
            this.println(Level.ERROR, e, message, args);
        }
    }

    public void fatal(String message, Object ... args) {
        this.fatal(null, message, args);
    }

    public void fatal(Throwable e, String message, Object ... args) {
        if (this.isFatalEnabled()) {
            this.println(Level.FATAL, e, message, args);
        }
    }

    public boolean isDebugEnabled() {
        return this.minLevel == Level.DEBUG;
    }

    public boolean isInfoEnabled() {
        return this.minLevel == Level.DEBUG || this.minLevel == Level.INFO;
    }

    public boolean isWarnEnabled() {
        return this.minLevel == Level.DEBUG || this.minLevel == Level.INFO || this.minLevel == Level.WARN;
    }

    public boolean isErrorEnabled() {
        return this.minLevel == Level.DEBUG || this.minLevel == Level.INFO || this.minLevel == Level.WARN || this.minLevel == Level.ERROR;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isEnabled(Level level) {
        if (level == Level.DEBUG) {
            return this.isDebugEnabled();
        }
        if (level == Level.INFO) {
            return this.isInfoEnabled();
        }
        if (level == Level.WARN) {
            return this.isWarnEnabled();
        }
        if (level == Level.ERROR) {
            return this.isErrorEnabled();
        }
        if (level == Level.FATAL) {
            return this.isFatalEnabled();
        }
        throw new IllegalArgumentException("\u4e0d\u6b63\u306a\u30ec\u30d9\u30eb: " + (Object)((Object)level));
    }

    public String toString() {
        String format = "%-5s %-15s (%s)";
        return String.format(format, new Object[]{this.minLevel, Logger.getShortClassName(this.getClass()), this.category});
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

