/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import jp.sourceforge.mergedoc.pleiades.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.resource.Mnemonics;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationNotFoundProperties;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationString;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.runtime.util.ConcurrentPropertySet;

public abstract class AbstractTranslationDictionary {
    private static final Logger log = Logger.getLogger(AbstractTranslationDictionary.class);
    private static final String REGEX_KEY_PREFIX = "%REGEX%";
    private final PropertySet transProp = new ConcurrentPropertySet(200000){
        private static final int VALID_CASE_MAX_LENGTH = 10;

        @Override
        public String get(Object keyObj) {
            String key = (String)keyObj;
            if (key.length() > 10) {
                key = key.toLowerCase();
            }
            return super.get(key);
        }

        @Override
        public String put(String key, String value) {
            if (key.length() > 10) {
                key = key.toLowerCase();
            }
            return super.put(key, value);
        }
    };
    protected final PropertySet transOverrideProp = new PropertySet();
    protected volatile boolean isResolveFirstRegex = true;
    protected volatile boolean isLoadedDefault;
    private final TranslationNotFoundProperties notFoundLog = TranslationNotFoundProperties.getInstance();

    protected AbstractTranslationDictionary() {
        this.load();
    }

    protected synchronized boolean load() {
        File additionsDir;
        if (this.isLoadedDefault) {
            return false;
        }
        this.transProp.load(AbstractTranslationDictionary.validateExists("translation.properties"));
        this.transOverrideProp.load(AbstractTranslationDictionary.validateExists("translation-first.properties"));
        String overrideProp = Pleiades.getPleiadesOption().appOverrideProp;
        if (overrideProp != null) {
            this.transOverrideProp.load(overrideProp);
        }
        if ((additionsDir = Files.conf("additions")).exists()) {
            new PropertySet(new File[]{additionsDir}){

                @Override
                public String put(String en, String ja) {
                    if (en.startsWith(AbstractTranslationDictionary.REGEX_KEY_PREFIX)) {
                        String enTrim = en.replaceFirst("^%REGEX%", "").trim();
                        String jaTrim = ja.trim();
                        RegexDictionary.getInstance().put(enTrim, jaTrim);
                        return null;
                    }
                    String enTrim = TranslationString.trim(Mnemonics.removeEn(en));
                    String jaTrim = TranslationString.trim(Mnemonics.removeJa(ja));
                    return AbstractTranslationDictionary.this.transOverrideProp.put(enTrim, jaTrim);
                }
            };
        }
        this.transProp.putAll(this.transOverrideProp);
        File convFile = Files.conf("translation-converter.properties");
        if (convFile.exists()) {
            PropertySet convMap = new PropertySet(convFile);
            for (Property p : this.transProp) {
                String resultValue = p.value;
                for (Property conv : convMap) {
                    resultValue = resultValue.replaceAll(conv.key, conv.value);
                }
                if (p.value.equals(resultValue)) continue;
                this.transProp.put(p.key, resultValue);
            }
        }
        this.isLoadedDefault = true;
        return true;
    }

    public static File validateExists(String fileName) {
        File propFile = Files.conf(fileName);
        if (!propFile.exists()) {
            String msg = String.valueOf(propFile.getName()) + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            log.fatal(msg, new Object[0]);
            FileNotFoundException e = new FileNotFoundException(propFile.getPath());
            throw new IllegalStateException(msg, e);
        }
        return propFile;
    }

    protected String getValue(String en, String separator) {
        if (en.isEmpty()) {
            return en;
        }
        String ja = (String)this.transProp.get(en);
        if (ja != null) {
            return ja;
        }
        TranslationString enTs = new TranslationString(en);
        if (this.isResolveFirstRegex && (ja = this.getValueByRegex(enTs)) != null) {
            this.transProp.put(en, ja);
            return ja;
        }
        ja = this.getValueToTrim(enTs);
        if (ja != null) {
            this.transProp.put(en, ja);
            return ja;
        }
        List<TranslationString> enPartTsList = enTs.split(separator);
        if (enPartTsList == null) {
            this.notFoundLog.put(enTs);
            this.transProp.put(en, en);
            return en;
        }
        boolean containsNoTransPart = false;
        StringBuilder sb = new StringBuilder();
        for (TranslationString enPartTs : enPartTsList) {
            String jaPart = this.getValueToTrim(enPartTs);
            if (jaPart == null) {
                jaPart = this.getValueByRegex(enPartTs);
            }
            if (jaPart == null && enPartTs.trim().contains(": ") && (jaPart = this.getValue(enPartTs.toString(), null)).equals(enPartTs.toString())) {
                containsNoTransPart = true;
            }
            if (jaPart == null) {
                jaPart = enPartTs.toString();
                containsNoTransPart = true;
                this.notFoundLog.put(enPartTs);
            }
            sb.append(jaPart);
        }
        ja = enTs.revert(sb.toString());
        if (containsNoTransPart) {
            this.notFoundLog.put(enTs);
        }
        this.transProp.put(en, ja);
        return ja;
    }

    protected String getValueToTrim(TranslationString enTs) {
        String enTrim = enTs.trim();
        if (enTrim.isEmpty()) {
            return enTs.toString();
        }
        String ja = this.getValueRemoveS(enTs, enTrim);
        if (ja != null) {
            return ja;
        }
        if (enTrim.contains(">'")) {
            enTrim = enTrim.replaceAll("(?s)(<a[^>]*>)'+", "$1");
            ja = this.getValueRemoveS(enTs, enTrim = enTrim.replaceAll("(?s)'+(</a>)", "$1"));
            if (ja != null) {
                return ja;
            }
        }
        if ((ja = this.getValueRemoveS(enTs, enTrim = enTs.trimForce())) != null) {
            return ja;
        }
        return null;
    }

    protected String getValueRemoveS(TranslationString enTs, String enTrim) {
        String ja = (String)this.transProp.get(enTrim);
        if (ja != null) {
            return enTs.revert(ja);
        }
        if ((enTrim = TranslationString.removeSorNull(enTrim)) != null && (ja = (String)this.transProp.get(enTrim)) != null) {
            return enTs.revert(ja);
        }
        return null;
    }

    protected String getValueByRegex(TranslationString enTs) {
        String ja = RegexDictionary.getInstance().lookup(enTs.trim());
        if (ja != null) {
            return enTs.revert(ja);
        }
        return null;
    }
}

