/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.org.apache.commons.lang.StringUtils;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.PatternCache;
import jp.sourceforge.mergedoc.pleiades.resource.Property;
import jp.sourceforge.mergedoc.pleiades.resource.PropertySet;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationProperty;

public class TranslationString {
    private static final Logger log = Logger.getLogger(TranslationString.class);
    private static final char[] TRIM_SPACE_CHAR_ARRAY = new char[]{' ', '\t', '\r', '\n', '\u00a0'};
    private final String original;
    protected StringBuilder starts;
    protected StringBuilder ends;
    private String body;

    public static String trim(String value) {
        return new TranslationString(value).trim();
    }

    public static String removeS(String en) {
        String result = TranslationString.removeSorNull(en);
        return result == null ? en : result;
    }

    public static String removeSorNull(String en) {
        if (en.contains("(s)") && !en.contains(" (s)")) {
            return en.replace("(s)", "");
        }
        return null;
    }

    public static boolean endsWithAbbrev(String en) {
        return en.matches("(?si).*?[\\s\\p{Punct}](Inc|Ltd|etc|sec|max|min|Reg|Exp|Misc|e\\.g|i\\.e)\\.");
    }

    public TranslationString(String value) {
        this.original = value;
        this.init();
    }

    protected void init() {
        this.starts = new StringBuilder();
        this.ends = new StringBuilder();
        this.body = null;
    }

    public String toString() {
        return this.original;
    }

    public String trim() {
        if (this.body != null) {
            return this.body;
        }
        this.body = this.original;
        this.trimInternal();
        return this.body;
    }

    private void trimInternal() {
        Pattern pat;
        Matcher mat;
        this.trimSpace();
        this.trimEnclosed("(", ")");
        this.trimEnclosed("[", "]");
        this.trimEnclosed("<!--", "-->");
        this.trimEnclosed("<a>", "</a>");
        this.trimEnclosed("<", ">");
        this.trimEnclosed("\u300c", "\u300d");
        this.trimEnclosed("\"");
        this.trimEnclosed("'");
        this.trimEnclosed("!");
        this.trimSpecific("&nbsp;");
        if (this.body.startsWith("<") || this.body.endsWith(">")) {
            String BLOCK_TAG_NAMES = "br|hr|div|p|ul|ol|dl|li|dd|h[1-5]|table|t[rdh]|html|body|!-- .+ --)(\\s+[^<>]+?|/?)";
            if (this.body.matches("(?si)<(!DOCTYPE|html|table|hr)(.+)</[a-z]+>")) {
                this.body = this.body.replaceAll("(?si)\\s*(</?(br|hr|div|p|ul|ol|dl|li|dd|h[1-5]|table|t[rdh]|html|body|!-- .+ --)(\\s+[^<>]+?|/?)>)\\s*", "$1");
                this.body = this.body.replaceAll("(?si)\\s*((</[^<>]+>|)</?(br|hr|div|p|ul|ol|dl|li|dd|h[1-5]|table|t[rdh]|html|body|!-- .+ --)(\\s+[^<>]+?|/?)>(<[^/<>]+>|))\\s*", "$1");
                this.body = this.body.replaceAll("\\s+", " ");
            }
            String BLOCK = "((</?(img|br|hr|div|p|ul|ol|dl|li|dd|h[1-5]|table|t[rdh]|html|body|!-- .+ --)(\\s+[^<>]+?|/?)>|<head>.*</head>|<style>.*</style>)*)";
            Pattern blockPat = PatternCache.get("(?si)^((</?(img|br|hr|div|p|ul|ol|dl|li|dd|h[1-5]|table|t[rdh]|html|body|!-- .+ --)(\\s+[^<>]+?|/?)>|<head>.*</head>|<style>.*</style>)*)(\\S.*?\\S)((</?(img|br|hr|div|p|ul|ol|dl|li|dd|h[1-5]|table|t[rdh]|html|body|!-- .+ --)(\\s+[^<>]+?|/?)>|<head>.*</head>|<style>.*</style>)*)$");
            Matcher blockMat = blockPat.matcher(this.body);
            if (blockMat.find()) {
                this.starts.append(blockMat.group(1));
                this.body = blockMat.group(5);
                this.ends.insert(0, blockMat.group(6));
            }
            Pattern inlinePat = PatternCache.get("(?si)^(<[^<>]+>|)(\\S.*?\\S)(</[^<>]+>|)$");
            Matcher inlineMat = inlinePat.matcher(this.body);
            while (inlineMat.find()) {
                String sTag = inlineMat.group(1);
                String eTag = inlineMat.group(3);
                if (sTag.isEmpty() && eTag.isEmpty()) break;
                String sTagName = "";
                if (!sTag.isEmpty()) {
                    sTagName = sTag.replaceFirst("(?s)<(\\w+).*", "$1").toLowerCase();
                }
                String eTagName = "";
                if (!eTag.isEmpty()) {
                    eTagName = eTag.replaceFirst("(?s)\\s*</(.+?)>", "$1").toLowerCase();
                }
                String inside = inlineMat.group(2);
                if (!sTagName.isEmpty() && !eTagName.isEmpty() ? !sTagName.equals(eTagName) || inside.contains(eTag) : sTagName.isEmpty() && inside.contains("<" + eTagName) || eTagName.isEmpty() && inside.contains("</" + sTagName)) break;
                this.starts.append(sTag);
                this.body = inside;
                this.ends.insert(0, eTag);
                inlineMat = inlinePat.matcher(this.body);
            }
        }
        if (this.body.startsWith("(") && !this.body.startsWith("( ") && !this.body.contains(")")) {
            this.trimStarts("(");
        } else if (this.body.endsWith(")") && !this.body.endsWith(" )") && !this.body.contains("(") && !this.body.endsWith(":)")) {
            this.trimEnds(")");
        } else if (this.body.endsWith(">-") && (mat = (pat = PatternCache.get("(?si)^(.+?)(<br/?>-)$")).matcher(this.body)).find()) {
            this.body = mat.group(1);
            this.ends.insert(0, mat.group(2));
        }
        this.trimHyphen();
        if ((this.body.startsWith("I") || this.body.startsWith("C")) && (mat = (pat = PatternCache.get("(?s)^([A-Z]{3,4}\\d{4}[A-Z]{0,1}[\\s:]+)(.+)$")).matcher(this.body)).find()) {
            this.starts.append(mat.group(1));
            this.body = mat.group(2);
        }
        if (this.body.endsWith("//") && (mat = (pat = PatternCache.get("(?si)^(.+[^:/\\s])(//)$")).matcher(this.body)).find()) {
            this.body = mat.group(1);
            this.ends.insert(0, mat.group(2));
        }
        String LOC = " #loc";
        if (this.body.endsWith(" #loc")) {
            this.body = this.body.substring(0, this.body.length() - " #loc".length());
            this.ends.insert(0, " #loc");
        }
    }

    public String trimForce() {
        int pos;
        int posNext;
        this.trim();
        String bodyBefore = this.body;
        while (true) {
            if (this.body.startsWith("<") || this.body.endsWith(">")) {
                String TAG = "(</?\\w+/?>|<\\w\\s+\\w+=[^<>]+?>)*";
                Pattern pat = PatternCache.get("(?s)^((</?\\w+/?>|<\\w\\s+\\w+=[^<>]+?>)*\\s*)([^<>]+?)(\\s*(</?\\w+/?>|<\\w\\s+\\w+=[^<>]+?>)*)$");
                Matcher mat = pat.matcher(this.body);
                if (mat.find()) {
                    this.starts.append(mat.group(1));
                    this.body = mat.group(3);
                    this.ends.insert(0, mat.group(4));
                }
            }
            if (this.body.startsWith(".") && this.body.matches("\\.[a-z]+")) {
                return this.body;
            }
            this.trimSpecific(".", "\u3002", ":", "\u2026");
            this.trimEnds("?");
            if (this.body.length() >= 2) {
                if (this.body.charAt(0) == '!' && this.body.charAt(1) != ' ') {
                    this.trimStarts("!");
                }
                if (this.body.length() >= 2 && this.body.charAt(this.body.length() - 1) == '!' && this.body.charAt(this.body.length() - 2) != ' ') {
                    this.trimEnds("!");
                }
            }
            this.trimInternal();
            if (bodyBefore.equals(this.body)) break;
            bodyBefore = this.body;
        }
        String e = this.ends.toString();
        if (!(!e.contains(".") || e.contains("..") || this.body.length() <= 2 || (posNext = (pos = e.indexOf(".")) + 1) < this.ends.length() && Character.isLetter(this.ends.charAt(posNext)) || !this.body.contains(" ") && this.body.contains("."))) {
            this.ends.replace(pos, pos + 1, "\u3002");
        }
        return this.body;
    }

    private void trimSpace() {
        char c;
        char c2;
        if (this.body.trim().isEmpty()) {
            this.starts.append(this.body);
            this.body = "";
            return;
        }
        char[] cs = this.body.toCharArray();
        int sCount = 0;
        for (int i = 0; i < cs.length && Arrays.binarySearch(TRIM_SPACE_CHAR_ARRAY, c2 = cs[i]) >= 0; ++i) {
            this.starts.append(c2);
            ++sCount;
        }
        int eCount = 0;
        for (int i = cs.length - 1; i > 0 && Arrays.binarySearch(TRIM_SPACE_CHAR_ARRAY, c = cs[i]) >= 0; --i) {
            this.ends.insert(0, c);
            ++eCount;
        }
        this.body = this.body.substring(sCount, this.body.length() - eCount);
    }

    private void trimEnclosed(String s) {
        this.trimEnclosed(s, s);
    }

    private void trimEnclosed(String s, String e) {
        if (!this.body.startsWith(s)) {
            return;
        }
        if (StringUtils.countMatches(this.body, s) != (s.equals(e) ? 2 : 1)) {
            return;
        }
        if (this.body.endsWith(".") || this.body.endsWith("\u3002")) {
            e = e + this.body.substring(this.body.length() - 1);
        }
        if (!this.body.endsWith(e)) {
            return;
        }
        int sLen = s.length();
        int eLen = e.length();
        int bLen = this.body.length();
        this.starts.append(this.body.substring(0, sLen));
        this.ends.insert(0, this.body.substring(bLen - eLen).replace('.', '\u3002'));
        this.body = this.body.substring(sLen, bLen - eLen);
        this.trimSpace();
    }

    private void trimSpecific(String ... ss) {
        this.trimStarts(ss);
        this.trimEnds(ss);
    }

    private void trimStarts(String ... ss) {
        int len;
        do {
            len = this.body.length();
            for (String s : ss) {
                if (!this.body.startsWith(s)) continue;
                this.starts.append(s);
                this.body = this.body.substring(s.length());
                this.trimSpace();
            }
        } while (this.body.length() != len && !this.body.isEmpty());
    }

    private void trimEnds(String ... ss) {
        int len;
        do {
            len = this.body.length();
            for (String s : ss) {
                if (!this.body.endsWith(s)) continue;
                this.ends.insert(0, s);
                this.body = this.body.substring(0, this.body.length() - s.length());
                this.trimSpace();
            }
        } while (this.body.length() != len && !this.body.isEmpty());
    }

    protected void trimHyphen() {
        if (this.trimStartsWithSpace("-")) {
            this.trimEndsWithSpace("-");
        }
    }

    protected boolean trimStartsWithSpace(String s) {
        Pattern pat;
        Matcher mat;
        if (this.body.startsWith(s) && (mat = (pat = PatternCache.get("(?s)^(" + s + "+\\s+)(.+)$")).matcher(this.body)).find()) {
            this.starts.append(mat.group(1));
            this.body = mat.group(2);
            return true;
        }
        return false;
    }

    protected boolean trimEndsWithSpace(String s) {
        Pattern pat;
        Matcher mat;
        if (this.body.endsWith(s) && (mat = (pat = PatternCache.get("(?s)^(.+?)(\\s+" + s + "+)$")).matcher(this.body)).find()) {
            this.body = mat.group(1);
            this.ends.insert(0, mat.group(2));
            return true;
        }
        return false;
    }

    public String revert() {
        this.trim();
        return this.starts + this.body + this.ends;
    }

    public String revert(String jaBody) {
        this.trim();
        return this.starts + jaBody + this.ends;
    }

    public List<TranslationString> split() {
        return this.split(null);
    }

    public List<TranslationString> split(String additionalPattern) {
        this.init();
        this.trim();
        if (additionalPattern == null && this.original.contains("\n") && !this.original.matches("(?is).*<(html|body|table).*") && (this.original.matches("(?s).*?\\n+[ \t].*") || this.original.matches("(?s).*?[^\\.!\u3002\\n]\\n.+"))) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.splitParenthesis(this.body)) {
            list.addAll(this.splitPunct(s, additionalPattern));
        }
        if (list.size() == 1) {
            return null;
        }
        ArrayList<TranslationString> tsList = new ArrayList<TranslationString>();
        for (int i = 0; i < list.size(); ++i) {
            if (i < list.size() - 1) {
                tsList.add(new SplitTranslationString((String)list.get(i)));
                continue;
            }
            tsList.add(new TranslationString((String)list.get(i)));
        }
        return tsList;
    }

    private List<String> splitParenthesis(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (!value.contains("(") && !value.contains("[")) {
            list.add(value);
            return list;
        }
        if (value.contains("<span")) {
            list.add(value);
            return list;
        }
        String PARENTH = "[\\(\\[][^\\{]+[\\)\\]]";
        String SPACE_GROUP = "([\\s\u00a0]|&nbsp;)";
        Pattern pat = PatternCache.get("(?s)^([\\(\\[][^\\{]+[\\)\\]]([\\s\u00a0]|&nbsp;))(.+)$");
        Matcher mat = pat.matcher(value);
        boolean isFound = false;
        if (mat.find()) {
            isFound = true;
        } else {
            String ENDS_PARENTH_GROUP = "([\\(\\[][^\\{]+[\\)\\]][\\.\u3002:]?\\s*)$";
            pat = PatternCache.get("(?s)^(.+([\\s\u00a0]|&nbsp;))([\\(\\[][^\\{]+[\\)\\]][\\.\u3002:]?\\s*)$");
            mat = pat.matcher(value);
            if (mat.find()) {
                if (this.invalidParenthesis(mat.group(2))) {
                    pat = PatternCache.get("(?s)^(.+?([\\s\u00a0]|&nbsp;))([\\(\\[][^\\{]+[\\)\\]][\\.\u3002:]?\\s*)$");
                    mat = pat.matcher(value);
                    isFound = mat.find();
                } else {
                    isFound = true;
                }
            }
        }
        if (isFound) {
            String g1 = mat.group(1);
            String g2 = mat.group(3);
            if (this.invalidParenthesis(g1) || this.invalidParenthesis(g2)) {
                list.add(value);
            } else {
                list.addAll(this.splitParenthesis(g1));
                list.addAll(this.splitParenthesis(g2));
            }
        } else {
            list.add(value);
        }
        return list;
    }

    private boolean invalidParenthesis(String value) {
        return StringUtils.countMatches(value, "(") != StringUtils.countMatches(value, ")") || StringUtils.countMatches(value, "[") != StringUtils.countMatches(value, "]");
    }

    private List<String> splitPunct(String value, String additionalPattern) {
        ArrayList<String> list = new ArrayList<String>();
        if (value.startsWith("...")) {
            list.add(value);
            return list;
        }
        String PUNCT_BR_PATTERN = "\\s*<br/?>(<[^<>]+>)*|</b>(<br>)*\\s+|&nbsp;";
        String additional = "";
        if (additionalPattern != null && !additionalPattern.isEmpty()) {
            additional = additionalPattern + "|";
        }
        String BLOCK_START = "(ul|ol|dl|su[pb]|div|p)(\\s+[^>]+|)";
        Pattern pat = PatternCache.get("(?si)\\s*(" + additional + "[\u3002\uff1a\uff1f\uff01]+(" + "\\s*<br/?>(<[^<>]+>)*|</b>(<br>)*\\s+|&nbsp;" + "|)+|" + "[\\.:;\\?!]+(" + "\\s*<br/?>(<[^<>]+>)*|</b>(<br>)*\\s+|&nbsp;" + "|\\s)+|" + "(<(/p|p/|/li|/h[1-5]|/td|/tr|/table|" + "(ul|ol|dl|su[pb]|div|p)(\\s+[^>]+|)" + ")>)+|" + "</b>(<br/?>)+|" + "(<br/?>){2,}(<[^<>]+>)*|" + "<br/?>-\\s|" + "\\s-\\s|" + "<!-- .+ -->|" + "[^:/<>\\s]//" + ")\\s*");
        Matcher mat = pat.matcher(value);
        try {
            StringBuffer sb = new StringBuffer();
            int prevEndPos = 0;
            while (mat.find()) {
                String sep = mat.group();
                int sPos = mat.start();
                int ePos = mat.end();
                if (sPos > 0 && ePos < value.length()) {
                    String s = value.substring(prevEndPos, sPos);
                    String e = value.substring(ePos);
                    if (sep.contains(":") || sep.contains("-")) {
                        Matcher nextMat = pat.matcher(e);
                        if (nextMat.find()) {
                            e = e.substring(0, nextMat.start());
                        }
                        if (e.contains("{") && e.matches("(?s).*?[^\\p{Punct}\\d].*")) continue;
                    }
                    if (sep.contains(":") ? s.contains("(") && e.contains(")") || s.contains("[") && e.contains("]") || s.contains(" style=\"") && e.contains("\"") : (sep.contains("-") ? s.endsWith("_") || s.matches("(?s).*\\d") && e.matches("(?s)\\d.*") : (sep.contains(".") ? sep.contains("... ") || sep.contains(" .") || TranslationString.endsWithAbbrev(s + sep.charAt(0)) : (sep.startsWith(";") ? s.contains("&") && s.matches("(?si).*&[a-z]+") : (sep.endsWith("\u3002") ? e.startsWith(")") : (sep.contains("?") ? e.startsWith("=") : sep.contains(" <") && sep.contains("> ") && sep.matches(" +<.+?> +") || sep.contains("<!-- ") && sep.contains(" -->") && (sep.contains(" <!-- ") || sep.contains(" --> ")))))))) continue;
                }
                mat.appendReplacement(sb, Matcher.quoteReplacement(sep));
                list.add(sb.toString());
                sb.delete(0, sb.length());
                prevEndPos = ePos;
            }
            mat.appendTail(sb);
            if (sb.length() > 0) {
                list.add(sb.toString());
            }
            Pattern endPat = PatternCache.get("(?si)^(.*?)((<(b|font[^>]*|(ul|ol|dl|su[pb]|div|p)(\\s+[^>]+|))>)+\\s*)$");
            for (int i = 0; i < list.size() - 1; ++i) {
                Matcher endMat;
                String s = (String)list.get(i);
                if (!s.contains("<") || !(endMat = endPat.matcher(s)).find()) continue;
                list.set(i, endMat.group(1));
                list.set(i + 1, endMat.group(2) + (String)list.get(i + 1));
            }
            list.remove("");
        }
        catch (RuntimeException e) {
            log.error(e, "value[" + value + "] group[" + mat.group() + "]", new Object[0]);
            throw e;
        }
        return list;
    }

    public static void main(String[] args) {
        PropertySet prop = new PropertySet("translation.properties");
        long s = System.currentTimeMillis();
        for (Property p : prop) {
            TranslationProperty tp = new TranslationProperty(p);
            List<TranslationString> enList = tp.en.split();
            if (enList == null) {
                new TranslationString(p.key).trimForce();
            } else {
                for (TranslationString ts : enList) {
                    ts.trimForce();
                }
            }
            List<TranslationString> jaList = tp.ja.split();
            if (jaList == null) {
                new TranslationString(p.value).trimForce();
                continue;
            }
            for (TranslationString ts : jaList) {
                ts.trimForce();
            }
        }
        log.info("%.3f ms", (double)(System.currentTimeMillis() - s) / 1000.0);
    }

    static {
        Arrays.sort(TRIM_SPACE_CHAR_ARRAY);
    }

    private static class SplitTranslationString
    extends TranslationString {
        public SplitTranslationString(String value) {
            super(value);
        }

        @Override
        protected void trimHyphen() {
            this.trimEndsWithSpace("-");
        }

        @Override
        public String revert(String jaBody) {
            this.trim();
            if (jaBody.endsWith("\u3002") && this.ends.length() != 0) {
                if (this.ends.charAt(0) == ' ') {
                    this.ends.deleteCharAt(0);
                } else if (this.ends.toString().startsWith("&nbsp;")) {
                    this.ends.delete(0, 6);
                }
            } else if (this.ends.toString().startsWith("\u3002 ")) {
                this.ends.deleteCharAt(1);
            }
            return this.starts + jaBody + this.ends;
        }
    }
}

