/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.Files;
import jp.sourceforge.mergedoc.pleiades.runtime.Analyses;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.ExcludeClassNameCache;
import jp.sourceforge.mergedoc.pleiades.runtime.resource.TransformedClassCache;

public abstract class AbstractTransformer
implements ClassFileTransformer {
    private static final Logger log = Logger.getLogger(AbstractTransformer.class);
    private static final ClassPool classPool = new ClassPool(true);
    private static final Set<String> appendedLocationPathSet = Collections.synchronizedSet(new HashSet());
    private DefaultTransformerBroker transformer = log.isDebugEnabled() ? new AnalysesTransformerBroker() : new DefaultTransformerBroker();

    @Override
    public final byte[] transform(ClassLoader loader, String vmClassName, Class<?> classBeingRedefined, ProtectionDomain domain, byte[] bytecode) throws IllegalClassFormatException {
        return this.transformer.execute(vmClassName, domain, bytecode);
    }

    protected void handleException(Throwable e, String msg) {
        log.debug(msg, new Object[0]);
    }

    protected boolean isClassPathTarget(String fullPath, String jarFileName) throws IOException, NotFoundException {
        return false;
    }

    protected void addClassPath(String fullPath, String jarFileName) throws NotFoundException {
        appendedLocationPathSet.add(jarFileName);
        String classPath = Files.decodeURL(fullPath);
        classPool.appendClassPath(classPath);
    }

    protected void addClassPath(File jarFile) throws IOException, NotFoundException {
        String jarFullPath = jarFile.getCanonicalPath().replace('\\', '/');
        this.addClassPath(jarFullPath, jarFile.getName());
    }

    protected abstract byte[] transformBytecode(String var1, String var2, byte[] var3) throws CannotCompileException, NotFoundException, IOException;

    protected CtClass createCtClass(byte[] bytecode) throws IOException, NotFoundException {
        return this.transformer.createCtClass(bytecode);
    }

    protected CtClass createCtClass(String className) throws IOException, NotFoundException {
        return this.transformer.createCtClass(className);
    }

    protected void logDescriptor(CtClass ctClass) {
        for (CtBehavior behavior : ctClass.getDeclaredBehaviors()) {
            log.info("DESCRIPTOR: " + ctClass.getName() + "#" + behavior.getName() + " " + behavior.getMethodInfo().getDescriptor(), new Object[0]);
        }
    }

    private class AnalysesTransformerBroker
    extends DefaultTransformerBroker {
        private AnalysesTransformerBroker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String getPluginLocation(String vmClassName, ProtectionDomain domain) throws IllegalClassFormatException {
            long start = System.nanoTime();
            try {
                String string = super.getPluginLocation(vmClassName, domain);
                return string;
            }
            finally {
                Analyses.end(DefaultTransformerBroker.class, "getPluginLocation", start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected byte[] transform(String vmClassName, byte[] bytecode, String pluginLocation) {
            long start = System.nanoTime();
            try {
                byte[] byArray = super.transform(vmClassName, bytecode, pluginLocation);
                return byArray;
            }
            finally {
                Analyses.end(DefaultTransformerBroker.class, "transform", start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CtClass createCtClass(byte[] bytecode) throws IOException, NotFoundException {
            long start = System.nanoTime();
            try {
                CtClass ctClass = super.createCtClass(bytecode);
                return ctClass;
            }
            finally {
                Analyses.end(DefaultTransformerBroker.class, "createCtClass(bytecode)", start);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CtClass createCtClass(String className) throws IOException, NotFoundException {
            long start = System.nanoTime();
            try {
                CtClass ctClass = super.createCtClass(className);
                return ctClass;
            }
            finally {
                Analyses.end(DefaultTransformerBroker.class, "createCtClass(className)", start);
            }
        }
    }

    private class DefaultTransformerBroker {
        private DefaultTransformerBroker() {
        }

        public byte[] execute(String vmClassName, ProtectionDomain domain, byte[] bytecode) throws IllegalClassFormatException {
            String pluginLocation = this.getPluginLocation(vmClassName, domain);
            if (pluginLocation != null) {
                return this.transform(vmClassName, bytecode, pluginLocation);
            }
            return null;
        }

        protected String getPluginLocation(String vmClassName, ProtectionDomain domain) throws IllegalClassFormatException {
            try {
                CodeSource codeSource;
                String pluginLocation = "";
                if (vmClassName == null || vmClassName.startsWith("java/") && !vmClassName.startsWith("java/awt/") || vmClassName.startsWith("jdk/") || vmClassName.startsWith("sun/") || vmClassName.startsWith("com/sun/") || vmClassName.startsWith("org/apache/commons")) {
                    return null;
                }
                if (vmClassName.startsWith("jp/sourceforge/mergedoc/pleiades/runtime/resource/") && (vmClassName.endsWith(TransformedClassCache.class.getSimpleName()) || vmClassName.endsWith(ExcludeClassNameCache.class.getSimpleName()))) {
                    return null;
                }
                if (domain != null && (codeSource = domain.getCodeSource()) != null) {
                    URL location = codeSource.getLocation();
                    if (location == null) {
                        ClassLoader classLoader = domain.getClassLoader();
                        if (classLoader.getClass().getSimpleName().equals("PluginClassLoader")) {
                            pluginLocation = classLoader.toString();
                        }
                    } else {
                        String locationPath = location.getPath();
                        if (locationPath.contains("org.apache.jasper_")) {
                            return null;
                        }
                        int lastSlashPos = locationPath.lastIndexOf(47);
                        if (lastSlashPos != -1) {
                            pluginLocation = locationPath.substring(lastSlashPos + 1);
                            if (!appendedLocationPathSet.contains(pluginLocation) && AbstractTransformer.this.isClassPathTarget(locationPath, pluginLocation)) {
                                AbstractTransformer.this.addClassPath(locationPath, pluginLocation);
                            }
                        }
                    }
                }
                return pluginLocation;
            }
            catch (Throwable e) {
                String msg = "\u30d0\u30a4\u30c8\u30b3\u30fc\u30c9\u5909\u63db\u4e8b\u524d\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + vmClassName;
                log.error(e, msg, new Object[0]);
                throw new IllegalClassFormatException(msg + " \u539f\u56e0:" + e);
            }
        }

        protected byte[] transform(String vmClassName, byte[] bytecode, String pluginLocation) {
            try {
                String className = vmClassName.replace('/', '.');
                String classId = pluginLocation + "/" + className;
                return AbstractTransformer.this.transformBytecode(classId, className, bytecode);
            }
            catch (Throwable e) {
                StringBuilder msg = new StringBuilder();
                msg.append("\u30d0\u30a4\u30c8\u30b3\u30fc\u30c9\u5909\u63db\u4e0d\u53ef ");
                msg.append(pluginLocation);
                msg.append("/");
                msg.append(vmClassName);
                msg.append(" ");
                msg.append(e);
                msg.append(" ");
                msg.append(e.getStackTrace()[0]);
                Throwable cause = e;
                while ((cause = cause.getCause()) != null) {
                    msg.append(" => ");
                    msg.append(cause);
                }
                AbstractTransformer.this.handleException(e, msg.toString());
                return null;
            }
        }

        protected CtClass createCtClass(byte[] bytecode) throws IOException, NotFoundException {
            CtClass ctClass = classPool.makeClass((InputStream)new ByteArrayInputStream(bytecode));
            ctClass.detach();
            return ctClass;
        }

        protected CtClass createCtClass(String className) throws IOException, NotFoundException {
            CtClass ctClass = classPool.makeClass(className);
            ctClass.detach();
            return ctClass;
        }
    }
}

