/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.runtime.AsyncCommand;

public class AsyncQueue {
    private static final Logger log = Logger.getLogger(AsyncQueue.class);
    private static ExecutorService threadPool = Executors.newCachedThreadPool();
    private static ExecutorService threadPoolAwait = Executors.newCachedThreadPool();

    private AsyncQueue() {
    }

    private static void add(AsyncCommand command, ExecutorService pool) {
        if (pool == null) {
            log.warn("\u975e\u540c\u671f\u5b9f\u884c\u306f\u3059\u3067\u306b\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u540c\u671f\u5b9f\u884c\u3057\u307e\u3059\u3002", new Object[0]);
            command.run();
            return;
        }
        try {
            pool.execute(command);
        }
        catch (RejectedExecutionException e) {
            log.warn("RejectedExecutionException \u304c\u767a\u751f\u3057\u305f\u305f\u3081\u3001\u540c\u671f\u5b9f\u884c\u3057\u307e\u3059\u3002", new Object[0]);
            command.run();
        }
    }

    public static void add(AsyncCommand command) {
        AsyncQueue.add(command, threadPool);
    }

    public static void addAwait(AsyncCommand command) {
        AsyncQueue.add(command, threadPoolAwait);
    }

    public static synchronized void awaitTermination() {
        if (threadPoolAwait != null) {
            log.debug("\u975e\u540c\u671f\u5b9f\u884c\u5f85\u3061\u53d7\u3051\u30ad\u30e5\u30fc\u306e\u7d42\u4e86\u5f85\u3061\u3092\u958b\u59cb\u3057\u307e\u3059\u3002", new Object[0]);
            threadPoolAwait.shutdown();
            try {
                threadPoolAwait.awaitTermination(5L, TimeUnit.SECONDS);
                log.debug("\u975e\u540c\u671f\u5b9f\u884c\u5f85\u3061\u53d7\u3051\u30ad\u30e5\u30fc\u306e\u7d42\u4e86\u5f85\u3061\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002", new Object[0]);
            }
            catch (InterruptedException e) {
                log.warn("\u975e\u540c\u671f\u5b9f\u884c\u5f85\u3061\u53d7\u3051\u30ad\u30e5\u30fc\u306e\u7d42\u4e86\u5f85\u3061\u3067\u5272\u308a\u8fbc\u307f\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", new Object[0]);
            }
            threadPoolAwait = null;
        }
    }

    public static synchronized void shutdown() {
        log.debug("\u975e\u540c\u671f\u5b9f\u884c\u3092\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u3057\u307e\u3059\u3002", new Object[0]);
        if (threadPool != null) {
            threadPool.shutdown();
            threadPool = null;
        }
        if (threadPoolAwait != null) {
            threadPoolAwait.shutdown();
            threadPoolAwait = null;
        }
    }
}

