/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.runtime.resource;

import jp.sourceforge.mergedoc.pleiades.runtime.resource.RuntimeTranslationDictionary;
import junit.framework.TestCase;

public class RuntimeTranslationDictionaryTest
extends TestCase {
    protected final RuntimeTranslationDictionary dynamicDic = new RuntimeTranslationDictionary();

    protected void assertLookup(String input, String expected) {
        String result = this.dynamicDic.lookup(input, null);
        System.out.println(input + "=" + result);
        RuntimeTranslationDictionaryTest.assertEquals((String)expected, (String)result);
    }

    protected void assertLookupFalse(String input) {
        String result = this.dynamicDic.lookup(input, null);
        System.out.println(input + "=" + result);
        RuntimeTranslationDictionaryTest.assertEquals((String)input, (String)result);
    }

    protected void assertLookupFalse(String input, String expected) {
        String result = this.dynamicDic.lookup(input, null);
        System.out.println(input + "=" + result);
        RuntimeTranslationDictionaryTest.assertEquals((String)expected, (String)result);
    }

    public void testLookup() {
        this.assertLookup("Sets the language module the spell checking engine should use when you enter a log message. ", "\u30ed\u30b0\u30fb\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u5165\u529b\u3059\u308b\u6642\u306b\u30b9\u30da\u30eb\u30fb\u30c1\u30a7\u30c3\u30af\u30fb\u30a8\u30f3\u30b8\u30f3\u304c\u4f7f\u7528\u3059\u3079\u304d\u8a00\u8a9e\u30e2\u30b8\u30e5\u30fc\u30eb\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002 ");
        this.assertLookup("assertion failed;", "\u30a2\u30b5\u30fc\u30b7\u30e7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        this.assertLookup("{n,} - Greedy match >= n times", "{n,} - \u6b63\u898f\u8868\u73fe\u306b\u3088\u308b\u4e00\u81f4 n \u56de\u4ee5\u4e0a");
        this.assertLookup("Type named ''{0}'' is imported (single-type-import) in ''{1}'' (a compilation unit must not import and declare a type with the same name)", "''{0}'' \u3068\u3044\u3046\u540d\u524d\u306e\u578b\u306f ''{1}'' \u5185\u306b\u30a4\u30f3\u30dd\u30fc\u30c8 (\u5358\u4e00\u306e\u578b\u306e\u30a4\u30f3\u30dd\u30fc\u30c8) \u3055\u308c\u3066\u3044\u307e\u3059 (\u30b3\u30f3\u30d1\u30a4\u30eb\u5358\u4f4d\u306f\u540c\u3058\u540d\u524d\u3067\u578b\u3092\u30a4\u30f3\u30dd\u30fc\u30c8\u304a\u3088\u3073\u5ba3\u8a00\u3067\u304d\u307e\u305b\u3093)");
        this.assertLookup("Archive file ''{0}'' is referenced by the following project(s). Do you still want to delete it?", "\u30a2\u30fc\u30ab\u30a4\u30d6\u30fb\u30d5\u30a1\u30a4\u30eb ''{0}'' \u306f\u6b21\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306b\u3088\u3063\u3066\u53c2\u7167\u3055\u308c\u307e\u3059\u3002\u524a\u9664\u3057\u307e\u3059\u304b?");
        this.assertLookup("\"Malformed file transmission received\"", "\"\u8aa4\u3063\u305f\u5f62\u5f0f\u306e\u30d5\u30a1\u30a4\u30eb\u4f1d\u9001\u304c\u53d7\u4fe1\u3055\u308c\u307e\u3057\u305f\"");
        this.assertLookup("Problems tagging the resources. {0} project(s) successfully tagged and {1} project(s) with errors.", "\u30ea\u30bd\u30fc\u30b9\u306e\u30bf\u30b0\u4ed8\u3051\u3067\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002{0} \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u304c\u6b63\u5e38\u306b\u30bf\u30b0\u4ed8\u3051\u3055\u308c\u3001{1} \u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3057\u305f\u3002");
        this.assertLookup("You have chosen to ignore {0} resources. Select what to add to the .cvsignore file(s).", "{0} \u500b\u306e\u30ea\u30bd\u30fc\u30b9\u3092\u7121\u8996\u3059\u308b\u3088\u3046\u9078\u629e\u3057\u307e\u3057\u305f\u3002.cvsignore \u30d5\u30a1\u30a4\u30eb\u306b\u8ffd\u52a0\u3059\u308b\u3082\u306e\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.assertLookupFalse("{0}, Function: {1}.");
        this.assertLookupFalse("/aaa/bbb?xxx=1&yyy=2");
        this.assertLookup("{0} does not exist.\nAre you sure you want to create it?", "{0} \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\n\u3053\u308c\u3092\u4f5c\u6210\u3057\u307e\u3059\u304b?");
        this.assertLookup("Error copying file {0}: {1}", "\u30d5\u30a1\u30a4\u30eb {0} \u306e\u30b3\u30d4\u30fc\u30fb\u30a8\u30e9\u30fc: {1}");
        this.assertLookup("Unable to initialize source location - directory does not exist: {0}", "\u30bd\u30fc\u30b9\u30fb\u30ed\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3002\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc {0} \u304c\u3042\u308a\u307e\u305b\u3093");
        this.assertLookup("The selected enterprise bean cannot be deleted because it is involved in\nrelationships with other enterprise beans.  You must first delete these\nrelationships before deleting the bean.", "\u5225\u306e\u30a8\u30f3\u30bf\u30fc\u30d7\u30e9\u30a4\u30ba Bean \u3068\u306e\u95a2\u4fc2\u304c\u542b\u307e\u308c\u308b\u305f\u3081\u3001\n\u9078\u629e\u3057\u305f\u30a8\u30f3\u30bf\u30fc\u30d7\u30e9\u30a4\u30ba Bean \u306f\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002\nBean \u3092\u524a\u9664\u3059\u308b\u524d\u306b\u3001\u307e\u305a\u95a2\u4fc2\u3092\u524a\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
        this.assertLookupFalse("The resulting string is too long to fit in a DOMString: ''{0}''.");
        this.assertLookup("Minimum VM Size (kB)", "\u6700\u5c0f VM \u30b5\u30a4\u30ba (kB)");
        this.assertLookupFalse("kB.");
        this.assertLookup("&Enable annotation roll-over (on new editors)", "(\u65b0\u3057\u3044\u30a8\u30c7\u30a3\u30bf\u30fc\u4e0a\u3067) \u6ce8\u91c8\u306e\u30ed\u30fc\u30eb\u30aa\u30fc\u30d0\u30fc\u3092\u4f7f\u7528\u53ef\u80fd\u306b\u3059\u308b(&E)");
        this.assertLookup("Unable to locate JAR/zip in file system as specified by the driver definition: {0}.", "\u30c9\u30e9\u30a4\u30d0\u30fc\u5b9a\u7fa9\u3067\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u30fb\u30b7\u30b9\u30c6\u30e0\u5185\u306b jar/zip \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: {0}.");
        this.assertLookup("'?' is not expected. '(?:' or '(?=' or '(?!' or '(?<' or '(?#' or '(?>'?", "'?' \u3092\u3053\u3053\u306b\u66f8\u304f\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002\u3082\u3057\u304b\u3057\u3066 '(?:' \u304b '(?=' \u304b '(?!' \u304b '(?<' \u304b '(?#' \u304b '(?>' \u3067\u3059\u304b?");
        this.assertLookup("Invalid timeout! Timeout should be positive integer or -1 to disable.", "\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u5024\u304c\u7121\u52b9\u3067\u3059! \u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u5024\u306f\u3001\u6b63\u6574\u6570\u307e\u305f\u306f -1 (\u4f7f\u7528\u4e0d\u53ef\u306b\u3059\u308b\u5834\u5408) \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002");
        this.assertLookup("none (no sides, default value)", "none (\u7dda\u306a\u3057\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u5024)");
        this.assertLookup("groups (between row groups)", "groups (\u884c\u30b0\u30eb\u30fc\u30d7\u9593)");
        this.assertLookup("It is strongly recommended you restart {0} for the changes to take effect. For some add-ons, it may be possible to apply the changes you have made without restarting. Would you like to restart now?", "\u5909\u66f4\u3092\u53cd\u6620\u3055\u305b\u308b\u305f\u3081\u306b {0} \u306e\u518d\u59cb\u52d5\u3092\u5f37\u304f\u304a\u52e7\u3081\u3057\u307e\u3059\u3002\u3044\u304f\u3064\u304b\u306e\u30a2\u30c9\u30aa\u30f3\u3067\u306f\u3001\u518d\u59cb\u52d5\u3057\u306a\u304f\u3066\u3082\u5909\u66f4\u304c\u53cd\u6620\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u3082\u3042\u308a\u307e\u3059\u3002\u3059\u3050\u306b\u518d\u59cb\u52d5\u3057\u307e\u3059\u304b?");
        this.assertLookup("Bundle symbolic name contains illegal characters. Legal characters are A-Z a-z 0-9 . _ -", "\u30d0\u30f3\u30c9\u30eb\u306e\u30b7\u30f3\u30dc\u30eb\u540d\u306b\u6b63\u3057\u304f\u306a\u3044\u6587\u5b57\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u6b63\u3057\u3044\u6587\u5b57\u306f A-Z a-z 0-9 . _ - \u3067\u3059");
        this.assertLookup("Unable to restore source location - class not found: {0}", "\u30bd\u30fc\u30b9\u30fb\u30ed\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u5fa9\u5143\u3067\u304d\u307e\u305b\u3093\u3002{0} \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
        this.assertLookup("Error: File not found.", "\u30a8\u30e9\u30fc: \u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        this.assertLookup("Update the related faces config file. Are you sure?", "\u95a2\u9023\u3059\u308b faces \u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u3092\u66f4\u65b0\u3057\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b?");
        this.assertLookup("<details unavailable - not supported by VM>", "<\u8a73\u7d30\u306f\u4f7f\u7528\u4e0d\u53ef - VM \u306b\u3088\u3063\u3066\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093>");
        this.assertLookup("Inclusion or exclusion patterns are disabled in project {1}, cannot selectively include or exclude from entry: ''{0}''", "\u5305\u542b\u307e\u305f\u306f\u9664\u5916\u30d1\u30bf\u30fc\u30f3\u306f\u30d7\u30ed\u30b8\u30a7\u30af\u30c8 {1} \u5185\u3067\u4f7f\u7528\u4e0d\u53ef\u3067\u3059\u3002\u30a8\u30f3\u30c8\u30ea\u30fc ''{0}'' \u304b\u3089\u9078\u629e\u7684\u306b\u5305\u542b\u307e\u305f\u306f\u9664\u5916\u3067\u304d\u307e\u305b\u3093");
        this.assertLookup("Profile name is empty.", "\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u7a7a\u3067\u3059\u3002");
        this.assertLookup("An error has occurred: {0}. See error log for more details. Do you want to exit?", "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: {0}\u3002\u8a73\u7d30\u306b\u3064\u3044\u3066\u306f\u30a8\u30e9\u30fc\u30fb\u30ed\u30b0\u3092\u53c2\u7167\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u7d42\u4e86\u3057\u307e\u3059\u304b?");
        this.assertLookup("Select a set of UDDI businesses and click <strong>Add to Favorites</strong> to add these to the list of favorites. Click <strong>Add to UDDI Page</strong> to add these to the UDDI Page. Click <strong>Refresh</strong> to refresh the selections.", "UDDI \u30d3\u30b8\u30cd\u30b9\u306e\u30bb\u30c3\u30c8\u3092\u9078\u629e\u3057\u3001\u300c<strong>\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0</strong>\u300d\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3053\u308c\u3089\u306e\u30d3\u30b8\u30cd\u30b9\u3092\u304a\u6c17\u306b\u5165\u308a\u306e\u30ea\u30b9\u30c8\u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002\u300c<strong>UDDI \u30da\u30fc\u30b8\u306b\u8ffd\u52a0</strong>\u300d\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u3053\u308c\u3089\u306e\u30d3\u30b8\u30cd\u30b9\u3092 UDDI \u30da\u30fc\u30b8\u306b\u8ffd\u52a0\u3057\u307e\u3059\u3002\u300c<strong>\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5</strong>\u300d\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u9078\u629e\u3092\u30ea\u30d5\u30ec\u30c3\u30b7\u30e5\u3057\u307e\u3059\u3002");
        this.assertLookup("-- Java Generation :: Generating...", "-- Java \u306e\u751f\u6210 :: \u751f\u6210\u4e2d...");
        this.assertLookup("Inclusion or exclusion patterns are disabled in project {1}, cannot selectively include or exclude from entry: ''{0}''", "\u5305\u542b\u307e\u305f\u306f\u9664\u5916\u30d1\u30bf\u30fc\u30f3\u306f\u30d7\u30ed\u30b8\u30a7\u30af\u30c8 {1} \u5185\u3067\u4f7f\u7528\u4e0d\u53ef\u3067\u3059\u3002\u30a8\u30f3\u30c8\u30ea\u30fc ''{0}'' \u304b\u3089\u9078\u629e\u7684\u306b\u5305\u542b\u307e\u305f\u306f\u9664\u5916\u3067\u304d\u307e\u305b\u3093");
        this.assertLookup("CHKJ2017E: This interface must extend javax.ejb.EJBHome (EJB 2.0: 6.3, 7.10.6).", "CHKJ2017E: \u3053\u306e\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306f javax.ejb.EJBHome \u3092\u62e1\u5f35\u3057\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093 (EJB 2.0: 6.3\u30017.10.6)\u3002");
        this.assertLookup("Warning: Invalid value for the initParam xpoweredBy. Will use the default value of \"false\"", "\u8b66\u544a: Invalid value for the initParam xpoweredBy. \u30c7\u30d5\u30a9\u30eb\u30c8\u5024 \"false\" \u3092\u4f7f\u7528\u3057\u307e\u3059");
        this.assertLookup("Problems encountered during code generation. Select detail entries for more information.", "\u30b3\u30fc\u30c9\u751f\u6210\u4e2d\u306b\u554f\u984c\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002Select detail entries for more information.");
        this.assertLookup("No custom build file found in {0}. If you want to generate a new build file, temporarily disable the ''custom'' property. ", "{0} \u3067\u30ab\u30b9\u30bf\u30e0\u30fb\u30d3\u30eb\u30c9\u30fb\u30d5\u30a1\u30a4\u30eb\u304c\u691c\u51fa\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002If you want to generate a new build file, temporarily disable the ''custom'' property. ");
        this.assertLookup("Missing directory entry: {0}.", "\u6b20\u843d\u3057\u3066\u3044\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc\u30fb\u30a8\u30f3\u30c8\u30ea\u30fc: {0}.");
        this.assertLookup("Missing directory entry: {1}.", "\u6b20\u843d\u3057\u3066\u3044\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u30fc\u30fb\u30a8\u30f3\u30c8\u30ea\u30fc: {1}.");
        this.assertLookup("IO exception.", "IO \u4f8b\u5916\u3002");
        this.assertLookup("IO exception", "IO \u4f8b\u5916");
        this.assertLookup("When selecting {0} compliance, make sure to have a compatible JRE installed and activated (Currently {1}). Configure the <a href=\"1\" >Installed JREs</a> or change the JRE on the <a href=\"2\" >Java build path</a>.", "{0} \u6e96\u62e0\u3092\u9078\u629e\u3059\u308b\u5834\u5408\u306f\u3001\u4e92\u63db\u6027\u304c\u3042\u308b JRE \u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u6e08\u307f\u3067\u30a2\u30af\u30c6\u30a3\u30d6\u306b\u3055\u308c\u3066\u3044\u308b\u3053\u3068\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044 (\u73fe\u5728\u306f {1})\u3002<a href=\"1\" >\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u6e08\u307f JRE</a> \u3092\u69cb\u6210\u3059\u308b\u304b\u3001<a href=\"2\" >Java \u30d3\u30eb\u30c9\u30fb\u30d1\u30b9</a> \u306b\u3042\u308b JRE \u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        this.assertLookup("Package: Generate Javadoc for all but private classes and members.", "Package: private \u306e\u30af\u30e9\u30b9\u304a\u3088\u3073\u30e1\u30f3\u30d0\u30fc\u4ee5\u5916\u306b\u3064\u3044\u3066 Javadoc \u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        this.assertLookup("Package: Generate Jsdoc for all but private classes and members.", "Package: private \u306e\u30af\u30e9\u30b9\u304a\u3088\u3073\u30e1\u30f3\u30d0\u30fc\u4ee5\u5916\u306b\u3064\u3044\u3066 Jsdoc \u3092\u751f\u6210\u3057\u307e\u3059\u3002");
        this.assertLookupFalse("visibility scope where Javadoc comments are not checked.");
        this.assertLookupFalse("A type.");
        this.assertLookup("n/a", "\u306a\u3057");
        this.assertLookup("N/A", "\u306a\u3057");
        this.assertLookupFalse("C&VS", "CVS(&V)");
        this.assertLookupFalse("Policy on how to pad parentheses. nospace = do not pad (e.g. method(a, b)). space = ensure padding (e.g. method( a, b )).");
        this.assertLookup("Project Validator that validates the Spring Config files (e.g. class and property names, referenced beans etc.)", "Spring \u69cb\u6210\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u8a3c\u3059\u308b\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30fb\u30d0\u30ea\u30c7\u30fc\u30bf\u30fc (\u4f8b \u30af\u30e9\u30b9\u3068\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u306e\u540d\u524d\u3001 \u53c2\u7167\u3055\u308c\u308b bean \u306a\u3069)");
        this.assertLookup("Label", "\u30e9\u30d9\u30eb");
        this.assertLookupFalse("... undefined string in dictionary ...");
        this.assertLookup("Error reading configuration", "\u69cb\u6210\u306e\u8aad\u307f\u53d6\u308a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        this.assertLookup("Add &Include@Ctrl+Shift+N", "Include \u306e\u8ffd\u52a0(&I)@Ctrl+Shift+N");
        this.assertLookup("Go to &Line...@Ctrl+L", "\u6307\u5b9a\u884c\u3078\u30b8\u30e3\u30f3\u30d7(&L)...@Ctrl+L");
        this.assertLookup("A resource named \"&1\" already exists.", "\u30ea\u30bd\u30fc\u30b9 \"&1\" \u306f\u3059\u3067\u306b\u5b58\u5728\u3057\u307e\u3059\u3002");
        this.assertLookup("K&R [built-in]", "K&R [\u30d3\u30eb\u30c8\u30a4\u30f3]");
        this.assertLookup("Appearance & Behavior", "\u5916\u89b3 & \u632f\u308b\u821e\u3044");
        this.assertLookup("Tasks & Contexts", "\u30bf\u30b9\u30af\u304a\u3088\u3073\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8");
        this.assertLookup("Ignore '&&' in &Java properties files", "Java \u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u306e '&&' \u3092\u7121\u8996(&J)");
        this.assertLookup("P&ackage", "\u30d1\u30c3\u30b1\u30fc\u30b8(&A)");
        this.assertLookup("\u518d\u30d3\u30eb\u30c9(&E) \u30e2\u30b8\u30e5\u30fc\u30eb 'Pleiades'", "\u30e2\u30b8\u30e5\u30fc\u30eb\u306e\u518d\u30d3\u30eb\u30c9(&E) 'Pleiades'");
        this.assertLookup("&A. \u30b5\u30e0\u30cd\u30a4\u30eb", "&A. \u30b5\u30e0\u30cd\u30a4\u30eb");
        this.assertLookup("L&abel", "\u30e9\u30d9\u30eb(&A)");
        this.assertLookup("&Left", "\u5de6(&L)");
        this.assertLookup("\u5de6(&L)", "\u5de6(&L)");
        this.assertLookup("Remo&ve Buildfile", "\u30d3\u30eb\u30c9\u30d5\u30a1\u30a4\u30eb\u306e\u9664\u53bb(&V)");
        this.assertLookup("JavaHL 1.4.5 Win32 Binaries (Optional)", "JavaHL 1.4.5 Win32 \u30d0\u30a4\u30ca\u30ea\u30fc (\u30aa\u30d7\u30b7\u30e7\u30f3)");
        this.assertLookup("Filter \u5217", "\u5217\u306e\u30d5\u30a3\u30eb\u30bf\u30fc");
        this.assertLookup("Filter \u5217 ...", "\u5217\u306e\u30d5\u30a3\u30eb\u30bf\u30fc ...");
        this.assertLookup("Loading files", "\u30d5\u30a1\u30a4\u30eb\u306e\u30ed\u30fc\u30c9\u6642");
        this.assertLookup("Search results for {0}:", "{0} \u306e\u691c\u7d22\u7d50\u679c:");
        this.assertLookup("&Extension....", "\u62e1\u5f35(&E)....");
        this.assertLookup("Label...", "\u30e9\u30d9\u30eb...");
        this.assertLookup("sec.", "\u79d2");
        this.assertLookup("&Next >", "\u6b21\u3078(&N) >");
        this.assertLookup("&Next >>", "\u6b21\u3078(&N) >>");
        this.assertLookup("&Add -->", "\u8ffd\u52a0(&A) -->");
        this.assertLookup("Label ", "\u30e9\u30d9\u30eb ");
        this.assertLookup("Label\t", "\u30e9\u30d9\u30eb\t");
        this.assertLookup("Label (Incubation)", "\u30e9\u30d9\u30eb (\u30a4\u30f3\u30ad\u30e5\u30d9\u30fc\u30b7\u30e7\u30f3)");
        this.assertLookup("Label [Experimental]", "\u30e9\u30d9\u30eb [\u5b9f\u9a13\u7528]");
        this.assertLookup("<< &Previous", "<< \u524d\u3078(&P)");
        this.assertLookup("&Using {0} - <a>Select other...</a>", "{0} \u3092\u4f7f\u7528\u4e2d - <a>\u305d\u306e\u4ed6\u306e\u9078\u629e(&U)...</a>");
        this.assertLookup("<html>Previous</html>", "<html>\u524d\u3078</html>");
        this.assertLookup("<html><font color=gray>Previous</font></html>", "<html><font color=gray>\u524d\u3078</font></html>");
        this.assertLookup("&nbsp;&nbsp;Label&nbsp;&nbsp;", "&nbsp;&nbsp;\u30e9\u30d9\u30eb&nbsp;&nbsp;");
        this.assertLookup("<!DOCTYPE html>\n<html>\n<head>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\">\n</head>\n<body>\n\n\n      <p>Did you know that you can close tabs in the editor and the tool windows of &productName; without actually\n          using the context menu commands?\n      It is enough to point with your mouse cursor to a tab to be closed, and click the middle mouse button, or just\n      use the <span class=\"shortcut\">Shift+click</span> combination.</p>\n\n\n</body>\n</html>", "<!DOCTYPE html><html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\"></head><body><p>\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u30fb\u30e1\u30cb\u30e5\u30fc\u306e\u30b3\u30de\u30f3\u30c9\u3092\u5b9f\u969b\u306b\u4f7f\u7528\u3057\u306a\u304f\u3066\u3082 &productName; \u306e\u30a8\u30c7\u30a3\u30bf\u30fc\u3068\u30c4\u30fc\u30eb\u30fb\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u30bf\u30d6\u3092\u9589\u3058\u308b\u3053\u3068\u304c\u3067\u304d\u308b\u3053\u3068\u3092\u3054\u5b58\u77e5\u3067\u3059\u304b? \u9589\u3058\u305f\u3044\u30bf\u30d6\u306b\u30de\u30a6\u30b9\u30fb\u30ab\u30fc\u30bd\u30eb\u3092\u5408\u308f\u305b\u3066\u30de\u30a6\u30b9\u306e\u4e2d\u30dc\u30bf\u30f3\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u304b <span class=\"shortcut\">Shift+click</span> \u306e\u7d44\u307f\u5408\u308f\u305b\u3092\u4f7f\u7528\u3059\u308b\u3060\u3051\u3067\u5341\u5206\u3067\u3059\u3002</p></body></html>");
        this.assertLookup(" Label", " \u30e9\u30d9\u30eb");
        this.assertLookup("\tLabel", "\t\u30e9\u30d9\u30eb");
        this.assertLookup("Delete Bookmark", "\u30d6\u30c3\u30af\u30de\u30fc\u30af\u306e\u524a\u9664");
        this.assertLookup("Delete Bookmark(s)", "\u30d6\u30c3\u30af\u30de\u30fc\u30af\u306e\u524a\u9664");
        this.assertLookupFalse(".test");
        this.assertLookup("Add, remove, or edit installed Web browsers.\nThe selected Web browser will be used by default when Web pages are opened, although some applications may always use the external browser.", "\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u6e08\u307f Web \u30d6\u30e9\u30a6\u30b6\u30fc\u3092\u8ffd\u52a0\u3001\u9664\u53bb\u3001\u307e\u305f\u306f\u7de8\u96c6\u3057\u307e\u3059\u3002\n\u9078\u629e\u3055\u308c\u305f Web \u30d6\u30e9\u30a6\u30b6\u30fc\u306f\u3001Web \u30da\u30fc\u30b8\u304c\u958b\u3044\u3066\u3044\u308b\u3068\u304d\u306b\u30c7\u30d5\u30a9\u30eb\u30c8\u3067\u4f7f\u7528\u3055\u308c\u307e\u3059\u304c\u3001\u4e00\u90e8\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3067\u306f\u3001\u5e38\u306b\u5916\u90e8\u30d6\u30e9\u30a6\u30b6\u30fc\u304c\u4f7f\u7528\u3055\u308c\u307e\u3059\u3002");
        this.assertLookup("Filter files may be used to include or exclude bug detection for particular classes and methods.\n<a href=\"http://findbugs.sourceforge.net/manual/filter.html\">Details...</a>\n", "\u30d5\u30a3\u30eb\u30bf\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u306f\u7279\u5b9a\u306e\u30af\u30e9\u30b9\u3084\u30e1\u30bd\u30c3\u30c9\u306e\u30d0\u30b0\u691c\u51fa\u3092\u542b\u3081\u305f\u308a\u9664\u5916\u3057\u305f\u308a\u3059\u308b\u305f\u3081\u306b\u4f7f\u7528\u3057\u307e\u3059\u3002\n<a href=\"http://findbugs.sourceforge.net/manual/filter.html\">\u8a73\u7d30...</a>\n");
        this.assertLookup("MySQL driver files are missing.\nDBeaver can download these files automatically.\n\n", "MySQL \u30c9\u30e9\u30a4\u30d0\u30fc\u30fb\u30d5\u30a1\u30a4\u30eb\u304c\u6b20\u843d\u3057\u3066\u3044\u307e\u3059\u3002\nDBeaver \u306f\u81ea\u52d5\u7684\u306b\u3053\u308c\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059\u3002\n\n");
        this.assertLookup("{0} must be public. (EJB 1.1: 9.2.3). ", "{0} \u306f public \u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093\u3002(EJB 1.1: 9.2.3)\u3002 ");
        this.assertLookup("Detected charset %s (Current setting: %s)", "\u691c\u51fa\u3055\u308c\u305f\u6587\u5b57\u30bb\u30c3\u30c8 %s (\u73fe\u5728\u306e\u8a2d\u5b9a: %s)");
        this.assertLookup("Subversive SVN JDT Ignore Extensions Sources (Optional) (Incubation)", "Subversive SVN JDT \u7121\u8996\u62e1\u5f35\u30bd\u30fc\u30b9 (\u30aa\u30d7\u30b7\u30e7\u30f3) (\u30a4\u30f3\u30ad\u30e5\u30d9\u30fc\u30b7\u30e7\u30f3)");
        this.assertLookup("Full user name (first and last):", "\u5b8c\u5168\u30e6\u30fc\u30b6\u30fc\u540d (\u59d3\u540d):");
        this.assertLookup("Performs a line-by-line comparison of all code lines and reports duplicate code if a sequence of lines differs only in indentation. All import statements in Java code are ignored, any other line - including javadoc, whitespace lines between methods, etc. - is considered (which is why the check is called strict).", "\u3059\u3079\u3066\u306e\u30b3\u30fc\u30c9\u884c\u306e\u884c\u5358\u4f4d\u6bd4\u8f03\u3092\u5b9f\u884c\u3057\u3001\u884c\u30b7\u30fc\u30b1\u30f3\u30b9\u306e\u30a4\u30f3\u30c7\u30f3\u30c8\u3060\u3051\u304c\u7570\u306a\u308b\u5834\u5408\u3001\u91cd\u8907\u3057\u305f\u30b3\u30fc\u30c9\u3092\u5831\u544a\u3057\u307e\u3059\u3002Java \u30b3\u30fc\u30c9\u5185\u306e\u3059\u3079\u3066\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u30fb\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u306f\u7121\u8996\u3055\u308c\u3001\u305d\u306e\u4ed6\u306e\u884c - javadoc\u3001 \u30e1\u30bd\u30c3\u30c9\u9593\u306e\u7a7a\u767d\u884c\u306a\u3069\u3092\u542b\u3080 - \u306f\u8003\u616e\u3055\u308c\u307e\u3059 (\u3053\u306e\u30c1\u30a7\u30c3\u30af\u304c\u53b3\u5bc6\u3068\u547c\u3070\u308c\u308b\u7406\u7531)\u3002");
        this.assertLookup("1. Project", "1. \u30d7\u30ed\u30b8\u30a7\u30af\u30c8");
        this.assertLookup("Marketplace Client\u00a0(Sources)", "\u30de\u30fc\u30b1\u30c3\u30c8\u30d7\u30ec\u30fc\u30b9\u30fb\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u00a0(\u30bd\u30fc\u30b9)");
        this.assertLookup("File Properties... (UTF-8)", "\u30d5\u30a1\u30a4\u30eb\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc... (UTF-8)");
        this.assertLookup("Invalid input url:", "\u7121\u52b9\u306a URL \u5165\u529b:");
        this.assertLookup("Invalid input url", "\u7121\u52b9\u306a URL \u5165\u529b");
        this.assertLookup("Space ( \u30fb )", "\u7a7a\u767d");
        this.assertLookup("Ideographic space ( \u00b0 )", "\u5168\u89d2\u7a7a\u767d");
        this.assertLookup("Tab ( \u226b )", "\u30bf\u30d6");
        this.assertLookup("Carriage Return ( \u00a4 )", "\u5fa9\u5e30");
        this.assertLookup("Line Feed ( \u00b6 )", "\u6539\u884c");
        this.assertLookup("Convert Line Delimiters to Windows (CRLF, \\r\\n, 0D0A, \u00a4\u00b6)", "\u884c\u533a\u5207\u308a\u6587\u5b57\u3092 Windows \u306b\u5909\u63db (CRLF, \\r\\n, 0D0A, \u00a4\u00b6)");
        this.assertLookup("Browsing for updates", "\u66f4\u65b0\u306e\u53c2\u7167");
        this.assertLookup("Browsing for xxx.xxx", "\u53c2\u7167 xxx.xxx");
        this.assertLookupFalse("Browsing for xxx");
        this.assertLookup("Misc.", "\u305d\u306e\u4ed6");
        this.assertLookupFalse("com.xxxxx");
        this.assertLookupFalse("com.xxxxx.");
        this.assertLookup("To go to the next frame, or toolbar press Ctrl+Tab", "\u6b21\u306e\u30d5\u30ec\u30fc\u30e0\u307e\u305f\u306f\u30c4\u30fc\u30eb\u30d0\u30fc\u306b\u30b8\u30e3\u30f3\u30d7\u3059\u308b\u306b\u306f\u3001Ctrl+TAB \u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044");
        this.assertLookup("Show Project Tasks", "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30fb\u30bf\u30b9\u30af\u306e\u8868\u793a");
        this.assertLookup("Show Project aaa", "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8 aaa \u306e\u8868\u793a");
        this.assertLookup("Displays the configuration model of root project 'a'. [incubating]", "\u30eb\u30fc\u30c8\u30fb\u30d7\u30ed\u30b8\u30a7\u30af\u30c8 'a' \u306e\u69cb\u6210\u30e2\u30c7\u30eb\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        this.assertLookup("Displays the configuration model of root project 'a'.", "\u30eb\u30fc\u30c8\u30fb\u30d7\u30ed\u30b8\u30a7\u30af\u30c8 'a' \u306e\u69cb\u6210\u30e2\u30c7\u30eb\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        this.assertLookup("The file size (9666013 bytes) exceeds configured limit (2560000 bytes). Code insight features are not available.", "\u30d5\u30a1\u30a4\u30eb\u30fb\u30b5\u30a4\u30ba (9666013 \u30d0\u30a4\u30c8) \u304c\u8a2d\u5b9a\u6e08\u307f\u306e\u5236\u9650 (2560000 \u30d0\u30a4\u30c8) \u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002\u30b3\u30fc\u30c9\u30fb\u30a4\u30f3\u30b5\u30a4\u30c8\u6a5f\u80fd\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
        this.assertLookup("Extensions", "\u62e1\u5f35");
        this.assertLookup("Label.<img src=\"a.png\">", "\u30e9\u30d9\u30eb\u3002<img src=\"a.png\">");
        this.assertLookup("Label<img src=\"a.png\">", "\u30e9\u30d9\u30eb<img src=\"a.png\">");
        this.assertLookup("<p>&s</p><p>Then return to your source code and press <span class=\"shortcut\">&shortcut:$Paste;</span></p>", "<p>&s</p><p>\u305d\u306e\u5f8c\u3001\u30bd\u30fc\u30b9\u30fb\u30b3\u30fc\u30c9\u306b\u623b\u308a <span class=\"shortcut\">&shortcut:$Paste;</span> \u3092\u62bc\u3057\u307e\u3059</p>");
        this.assertLookup("You don't need to invoke quick documentation explicitly (<span class=\"shortcut\">&shortcut:QuickJavaDoc;</span>)", "\u30af\u30a4\u30c3\u30af\u30fb\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u660e\u793a\u7684\u306b\u547c\u3073\u51fa\u3059\u5fc5\u8981\u306f\u3042\u308a\u307e\u305b\u3093 (<span class=\"shortcut\">&shortcut:QuickJavaDoc;</span>)");
        this.assertLookup("<html> <head>     <link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\"> </head> <body>  <p>You don't need to invoke quick documentation explicitly  (<span class=\"shortcut\">&shortcut:QuickJavaDoc;</span>) - if you just move your mouse  pointer over the desired symbol, the quick documentation pop-up window will show automatically.</p> <p>To enable this feature, select the check box <span class=\"control\">Show quick doc on mouse move</span>  in the editor settings. </p> </body> </html>", "<html><head><link rel=\"stylesheet\" type=\"text/css\" href=\"css/tips.css\"></head><body><p>\u30af\u30a4\u30c3\u30af\u30fb\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u660e\u793a\u7684\u306b\u547c\u3073\u51fa\u3059\u5fc5\u8981\u306f\u3042\u308a\u307e\u305b\u3093 (<span class=\"shortcut\">&shortcut:QuickJavaDoc;</span>) - \u30de\u30a6\u30b9\u30fb\u30dd\u30a4\u30f3\u30bf\u30fc\u3092\u76ee\u7684\u306e\u30b7\u30f3\u30dc\u30eb\u306e\u4e0a\u306b\u79fb\u52d5\u3059\u308b\u3060\u3051\u3067\u3001\u30af\u30a4\u30c3\u30af\u30fb\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u306e\u30dd\u30c3\u30d7\u30a2\u30c3\u30d7\u30fb\u30a6\u30a3\u30f3\u30c9\u30a6\u304c\u81ea\u52d5\u7684\u306b\u8868\u793a\u3055\u308c\u307e\u3059\u3002</p><p>\u3053\u306e\u6a5f\u80fd\u3092\u6709\u52b9\u306b\u3059\u308b\u306b\u306f\u3001\u30a8\u30c7\u30a3\u30bf\u30fc\u8a2d\u5b9a\u3067 <span class=\"control\">\u30de\u30a6\u30b9\u79fb\u52d5\u3067\u30af\u30a4\u30c3\u30af\u30fb\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u8868\u793a\u3059\u308b</span> \u30c1\u30a7\u30c3\u30af\u30fb\u30dc\u30c3\u30af\u30b9\u3092\u30aa\u30f3\u306b\u3057\u307e\u3059\u3002</p></body></html>");
        this.assertLookupFalse("?s");
        this.assertLookup("add entries prefixed with !", "! \u3092\u524d\u306b\u4ed8\u3051\u305f\u30a8\u30f3\u30c8\u30ea\u30fc\u3092\u8ffd\u52a0");
        this.assertLookup("<div style=\"text-align:right\" vertical-align=\"top\">'\u30c6\u30ad\u30b9\u30c8\u2192\u6298\u308a\u8fd4\u3057\u30c6\u30ad\u30b9\u30c8'<br>of <a href=\"\u30c6\u30ad\u30b9\u30c8//\u6298\u308a\u8fd4\u3057\u30c6\u30ad\u30b9\u30c8\">\u4e00\u822c", "<div style=\"text-align:right\" vertical-align=\"top\">'\u30c6\u30ad\u30b9\u30c8\u2192\u6298\u308a\u8fd4\u3057\u30c6\u30ad\u30b9\u30c8'<br><a href=\"\u30c6\u30ad\u30b9\u30c8//\u6298\u308a\u8fd4\u3057\u30c6\u30ad\u30b9\u30c8\">\u4e00\u822c");
        this.assertLookup("Context: <no context>", "\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8: <\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u306a\u3057>");
        this.assertLookup("Label. (Note: Status)", "\u30e9\u30d9\u30eb\u3002(\u6ce8: \u72b6\u6cc1)");
        this.assertLookup("Zen HTML: !!! (<!doctype html>)", "Zen HTML: !!! (<!doctype html>)");
    }
}

