#ifndef MFILER3_COMMON_H
#define MFILER3_COMMON_H

#include "config.h"
#include <xyzsh/xyzsh.h>

#if defined(__CYGWIN__)

#define _LARGEFILE64_SOURCE       // サイズが大きいファイルを扱うために必要
#include <sys/stat.h>     // ↑のマクロを使ってコンパイルしないといけない
#define stat64 stat
#define __off64_t long long int
#define lstat64 lstat
#undef _LARGEFILE64_SOURCE

#elif defined(__DARWIN__) || defined(__FREEBSD__) || defined(__LINUX__)

#define _LARGEFILE64_SOURCE       // サイズが大きいファイルを扱うために必要
#include <sys/stat.h>     // ↑のマクロを使ってコンパイルしないといけない
#define __off64_t long long int
#define stat64 stat
#define lstat64 lstat
#undef _LARGEFILE64_SOURCE

#endif

#include <unistd.h>

#ifndef	NSIG
# ifdef	_NSIG
# define	NSIG		_NSIG
# else
#  ifdef	DJGPP
#  define	NSIG		301
#  else
#  define	NSIG		64
#  endif
# endif
#endif

#include <limits.h>
#include <signal.h>
#include <sys/wait.h>

#include "filer.h"

#include <oniguruma.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined(S_ISTXT)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISTXT)
#elif defined(S_ISVTX)
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID|S_ISVTX)
#else
    #define S_ALLPERM (S_IRWXU|S_IRWXG|S_IRWXO|S_ISUID|S_ISGID)
#endif

#define S_IXUGO (S_IXOTH | S_IXGRP | S_IXUSR)

//////////////////////////////////////////////
// main.c
///////////////////////////////////////////////
void extname(char* result, int result_size, char* name);
int correct_path(char* current_path, char* path, char* path2, int path2_size);

extern char gHomeDir[PATH_MAX];     // ~/.mfiler3/のパス
extern char gTempDir[PATH_MAX];     // 一時ディレクトリのパス
extern int gMainLoop;               // メインループを回すかどうか -1の間回す。終了時はリターンコードとなる
extern BOOL gExitCode;              // 終了コード

extern void (*gView)();             // 登録描写関数(関数を登録しておけばviewで実行される)

void set_signal_mfiler();

void view();                        // 全体の描写関数

///////////////////////////////////////////////
// menu.c
///////////////////////////////////////////////
typedef struct {
    char* mName;
    int mKey;
    sObject* mBlock;
    BOOL mExternal;
} sMenuItem;

typedef struct {
    char mTitle[256];

    int mScrollTop;
    int mCursor;

    sObject* mMenuItems; 
} sMenu;

extern sObject* gMenu;
extern sMenu* gActiveMenu;

sMenu* sMenu_new(char* title);
void menu_view(sMenu* self);
void menu_input(sMenu* self, int meta, int key);
void menu_append(sMenu* self, char* name, int key, sObject* block, BOOL external);
void menu_init();
void menu_final();
void menu_start(char* menu_name);
void sweep_overrided_menu();

///////////////////////////////////////////////////
// isearch.c
///////////////////////////////////////////////////
extern BOOL gISearch;        // インクリメンタルサーチ中かどうか
void isearch_init();         // インクリメンタルサーチ初期化
void isearch_final();        // インクリメンタルサーチ解放

void isearch_input(int meta, int key); // インクリメンタルサーチキー入力
void isearch_view();                  // インクリメンタルサーチ描写

BOOL IsISearchExploreChar(int meta, int key);
BOOL IsISearchNULL();
void ISearchClear();

///////////////////////////////////////////////////
// gui.c
///////////////////////////////////////////////////
char* choise(char* msg, char* str[], int len, int cancel);
void merr_msg(char* msg, ...);
void msg_nonstop(char* msg, ...);
int select_str(char* msg, char* str[], int len, int cancel);
int select_str2(char* msg, char* str[], int len, int cancel);
int input_box(char* msg, char* result, int result_size, char* def_input, int def_cursor);

///////////////////////////////////////////////////
// commands.c
///////////////////////////////////////////////////
void commands_init();
void commands_final();

///////////////////////////////////////////////////
// file.c
///////////////////////////////////////////////////
enum eCopyOverride { kNone, kYesAll, kNoAll, kCancel, kSelectNewer, kYesAllRemainPermission };
extern enum eCopyOverride gCopyOverride;

enum eWriteProtected { kWPNone, kWPYesAll, kWPNoAll, kWPCancel };
extern enum eWriteProtected gWriteProtected;

BOOL file_copy(char* spath, char* dpath, BOOL move, BOOL preserve);
BOOL file_remove(char* path, BOOL no_ctrl_c, BOOL msg);

extern sObject* gMFiler4;
extern sObject* gMFiler4Prompt;

#endif

