/*
Midbar
Distributed under the MIT License
© Copyright Maxim Bortnikov 2023
For more information please visit
https://sourceforge.net/projects/midbar/
https://osdn.net/projects/midbar/
https://github.com/Northstrix/Midbar
Required libraries:
https://github.com/zhouyangchao/AES
https://github.com/peterferrie/serpent
https://github.com/ddokkaebi/Blowfish
https://github.com/Northstrix/DES_and_3DES_Library_for_MCUs
https://github.com/ulwanski/sha512
https://github.com/moononournation/Arduino_GFX
https://github.com/techpaul/PS2KeyAdvanced
https://github.com/intrbiz/arduino-crypto
https://github.com/GyverLibs/EncButton
*/
/*  Simple keyboard to serial port at 115200 baud

  PS2KeyAdvanced library example

  Advanced support PS2 Keyboard to get every key code byte from a PS2 Keyboard
  for testing purposes.

  IMPORTANT WARNING

    If using a DUE or similar board with 3V3 I/O you MUST put a level translator
    like a Texas Instruments TXS0102 or FET circuit as the signals are
    Bi-directional (signals transmitted from both ends on same wire).

    Failure to do so may damage your Arduino Due or similar board.

  Test History
    September 2014 Uno and Mega 2560 September 2014 using Arduino V1.6.0
    January 2016   Uno, Mega 2560 and Due using Arduino 1.6.7 and Due Board
                    Manager V1.6.6

  This is for a LATIN style keyboard using Scan code set 2. See various
  websites on what different scan code sets use. Scan Code Set 2 is the
  default scan code set for PS2 keyboards on power up.

  Will support most keyboards even ones with multimedia keys or even 24 function keys.

  The circuit:
   * KBD Clock (PS2 pin 1) to an interrupt pin on Arduino ( this example pin 3 )
   * KBD Data (PS2 pin 5) to a data pin ( this example pin 4 )
   * +5V from Arduino to PS2 pin 4
   * GND from Arduino to PS2 pin 3

   The connector to mate with PS2 keyboard is a 6 pin Female Mini-Din connector
   PS2 Pins to signal
    1       KBD Data
    3       GND
    4       +5V
    5       KBD Clock

   Keyboard has 5V and GND connected see plenty of examples and
   photos around on Arduino site and other sites about the PS2 Connector.

 Interrupts

   Clock pin from PS2 keyboard MUST be connected to an interrupt
   pin, these vary with the different types of Arduino

  PS2KeyAdvanced requires both pins specified for begin()

    keyboard.begin( data_pin, irq_pin );

  Valid irq pins:
     Arduino Uno:  2, 3
     Arduino Due:  All pins, except 13 (LED)
     Arduino Mega: 2, 3, 18, 19, 20, 21
     Teensy 2.0:   All pins, except 13 (LED)
     Teensy 2.0:   5, 6, 7, 8
     Teensy 1.0:   0, 1, 2, 3, 4, 6, 7, 16
     Teensy++ 2.0: 0, 1, 2, 3, 18, 19, 36, 37
     Teensy++ 1.0: 0, 1, 2, 3, 18, 19, 36, 37
     Sanguino:     2, 10, 11

  Read method Returns an UNSIGNED INT containing
        Make/Break status
        Caps status
        Shift, CTRL, ALT, ALT GR, GUI keys
        Flag for function key not a displayable/printable character
        8 bit key code

  Code Ranges (bottom byte of unsigned int)
        0       invalid/error
        1-1F    Functions (Caps, Shift, ALT, Enter, DEL... )
        1A-1F   Functions with ASCII control code
                    (DEL, BS, TAB, ESC, ENTER, SPACE)
        20-61   Printable characters noting
                    0-9 = 0x30 to 0x39 as ASCII
                    A to Z = 0x41 to 0x5A as upper case ASCII type codes
                    8B Extra European key
        61-A0   Function keys and other special keys (plus F2 and F1)
                    61-78 F1 to F24
                    79-8A Multimedia
                    8B NOT included
                    8C-8E ACPI power
                    91-A0 and F2 and F1 - Special multilingual
        A8-FF   Keyboard communications commands (note F2 and F1 are special
                codes for special multi-lingual keyboards)

    By using these ranges it is possible to perform detection of any key and do
    easy translation to ASCII/UTF-8 avoiding keys that do not have a valid code.

    Top Byte is 8 bits denoting as follows with defines for bit code

        Define name bit     description
        PS2_BREAK   15      1 = Break key code
                   (MSB)    0 = Make Key code
        PS2_SHIFT   14      1 = Shift key pressed as well (either side)
                            0 = NO shift key
        PS2_CTRL    13      1 = Ctrl key pressed as well (either side)
                            0 = NO Ctrl key
        PS2_CAPS    12      1 = Caps Lock ON
                            0 = Caps lock OFF
        PS2_ALT     11      1 = Left Alt key pressed as well
                            0 = NO Left Alt key
        PS2_ALT_GR  10      1 = Right Alt (Alt GR) key pressed as well
                            0 = NO Right Alt key
        PS2_GUI      9      1 = GUI key pressed as well (either)
                            0 = NO GUI key
        PS2_FUNCTION 8      1 = FUNCTION key non-printable character (plus space, tab, enter)
                            0 = standard character key

  Error Codes
     Most functions return 0 or 0xFFFF as error, other codes to note and
     handle appropriately
        0xAA   keyboard has reset and passed power up tests
               will happen if keyboard plugged in after code start
        0xFC   Keyboard General error or power up fail

  See PS2Keyboard.h file for returned definitions of Keys

  Note defines starting
            PS2_KEY_* are the codes this library returns
            PS2_*     remaining defines for use in higher levels

  To get the key as ASCII/UTF-8 single byte character conversion requires use
  of PS2KeyMap library AS WELL.

  Written by Paul Carpenter, PC Services <sales@pcserviceselectronics.co.uk>
*/

#include <PS2KeyAdvanced.h>

#include <EncButton2.h>

/* Keyboard constants  Change to suit your Arduino
   define pins used for data and clock from keyboard */
#define DATAPIN 14
#define IRQPIN 15

#include <Arduino_GFX_Library.h>

#define GFX_BL DF_GFX_BL // default backlight pin, you may replace DF_GFX_BL to actual backlight pin

/* More dev device declaration: https://github.com/moononournation/Arduino_GFX/wiki/Dev-Device-Declaration */
#if defined(DISPLAY_DEV_KIT)
Arduino_GFX * gfx = create_default_Arduino_GFX();
#else /* !defined(DISPLAY_DEV_KIT) */

/* More data bus class: https://github.com/moononournation/Arduino_GFX/wiki/Data-Bus-Class */
Arduino_DataBus * bus = create_default_Arduino_DataBus();

/* More display class: https://github.com/moononournation/Arduino_GFX/wiki/Display-Class */
Arduino_GFX * gfx = new Arduino_ILI9341(bus, DF_GFX_RST, 0 /* rotation */ , false /* IPS */ );

#endif /* !defined(DISPLAY_DEV_KIT) */
/*******************************************************************************
 * End of Arduino_GFX setting
 ******************************************************************************/

/* more fonts at: https://github.com/moononournation/ArduinoFreeFontFile.git */

uint16_t c;
String keyboard_input;
int curr_key;
const uint16_t current_inact_clr = 0x051b;
const uint16_t five_six_five_red_color = 0xf940;
bool finish_input;
bool act;

EncButton2 < EB_ENC > enc0(INPUT, 12, 13);
EncButton2 < EB_BTN > encoder_button(INPUT, 9);
EncButton2 < EB_BTN > a_button(INPUT, 11);
EncButton2 < EB_BTN > b_button(INPUT, 10);

PS2KeyAdvanced keyboard;

const uint16_t handwritten_midbar PROGMEM [320][41] = {
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,261,261,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,621,1013,1308,1308,1308,1308,1308,1209,1013,752,163,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,784,1275,1275,1079,882,653,653,784,850,1242,1308,1308,1308,883,229,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,294,1242,1046,294,32,0,0,0,0,0,0,32,392,948,1308,1308,1308,817,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,425,1242,621,0,0,0,0,0,0,0,0,0,0,0,0,392,1111,1308,1308,882,32,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,327,1209,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1013,1308,1308,1013,32,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,98,1177,556,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1013,1308,1308,719,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,817,1079,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1209,1308,1275,261,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,131,1275,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,1308,1308,1046,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,719,1177,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,948,1308,1308,425,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,1111,948,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,359,1308,1308,883,0,0,0,0},
{0,0,0,0,0,0,0,0,0,98,1308,719,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1111,1308,1275,98,0,0,0},
{0,0,0,0,0,0,0,0,0,425,1308,490,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,654,1308,1308,490,0,0,0},
{0,0,0,0,0,0,0,0,0,556,1308,392,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,1308,1308,752,0,0,0},
{0,0,0,0,0,0,0,0,0,653,1308,556,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1308,1308,883,0,0,0},
{0,0,0,0,0,0,0,0,0,784,1308,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1144,1308,1046,0,0,0},
{0,0,0,0,0,0,0,0,0,719,1308,1013,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1111,1308,1144,0,0,0},
{0,0,0,0,0,0,0,0,0,621,1308,1242,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,980,1308,1144,0,0,0},
{0,0,0,0,0,0,0,0,0,490,1308,1308,490,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,980,1308,1046,0,0,0},
{0,0,0,0,0,0,0,0,0,262,1308,1308,1013,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,980,1308,948,0,0,0},
{0,0,0,0,0,0,0,0,0,0,1209,1308,1308,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1144,1308,686,0,0,0},
{0,0,0,0,0,0,0,0,0,0,784,1308,1308,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1242,1308,359,0,0,0},
{0,0,0,0,0,0,0,0,0,0,327,1308,1308,1275,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,1308,1275,65,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,1079,1308,1308,1046,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,555,1308,915,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,294,1308,1308,1308,588,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,882,1308,327,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,817,1308,1308,1242,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1275,1046,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,98,1242,1308,1308,1013,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,621,1308,458,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,392,1308,1308,1308,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,1177,1013,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,719,1308,1308,1308,555,0,0,0,0,0,0,0,0,0,0,0,0,0,621,1308,261,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1046,1308,1308,1275,327,0,0,0,0,0,0,0,0,0,0,0,98,1242,784,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,1242,1308,1308,1242,196,0,0,0,0,0,0,0,0,0,0,784,1111,65,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,1308,1308,1308,1177,32,0,0,0,0,0,0,0,0,392,1275,229,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,784,1308,1308,817,0,0,0,0,0,0,0,0,131,1242,556,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1275,1275,163,0,0,0,0,0,0,0,0,1046,784,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,1275,719,0,0,0,0,0,0,0,0,882,882,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,326,1242,65,0,0,0,0,0,0,0,817,1013,65,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,883,588,0,0,0,0,0,0,0,719,1013,65,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,1144,32,0,0,0,0,0,0,817,980,65,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,0,0,65,948,882,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,1013,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,327,1177,490,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,65,131,131,131,0,0,0,653,1176,262,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,163,621,980,1111,1242,1308,1308,1308,1308,1275,1079,1079,1275,490,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,131,621,1046,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1046,784,490,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,98,784,1242,1013,719,490,359,326,326,326,425,588,1013,1308,1111,1275,1308,1308,1308,1308,1308,1308,1308,1308,1275,1046,784,588,425,326,326,392,588,1046,653,0,0,0},
{0,0,490,1242,784,98,0,0,0,0,0,0,0,392,980,1176,425,0,65,359,686,980,1275,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,654,0,0,0,0},
{0,490,1308,1013,0,0,0,0,0,0,32,490,1111,1275,654,32,0,0,0,0,0,0,32,262,588,883,1242,1308,1308,1308,1308,1308,1308,1308,1242,458,0,0,0,0,0},
{0,1176,1308,1242,229,0,65,196,490,850,1209,1275,817,163,0,0,0,0,0,0,0,0,0,0,0,0,0,196,392,556,752,948,1275,1176,261,0,0,0,0,0,0},
{0,1242,1308,1308,1308,1308,1308,1308,1308,1275,817,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,817,1013,98,0,0,0,0,0,0,0},
{0,392,1176,1308,1308,1308,1242,883,458,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,1046,784,0,0,0,0,0,0,0,0,0},
{0,0,0,131,131,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,326,1176,555,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,523,1177,327,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,784,1046,131,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1013,817,65,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,261,1144,621,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,490,1177,359,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,719,1079,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,948,882,65,0,0,0,0,0,0,0,0,0,0,131,327,490,621,653,65,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,1111,621,0,0,0,0,0,0,65,392,621,882,1079,1275,1308,1308,1308,1308,1046,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,1144,327,0,0,65,294,556,882,1111,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,523,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,653,1079,392,555,784,1046,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1242,65,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,915,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1144,915,719,523,327,294,654,1308,784,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,196,1111,1308,1308,1308,1308,1308,1308,1308,1209,948,719,490,261,65,0,0,0,0,0,0,65,1308,261,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,327,1242,1308,1308,1308,1275,1046,752,458,163,0,0,0,0,0,0,0,0,0,0,0,0,359,1079,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,556,1275,1308,1275,850,359,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,719,555,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,817,1308,1079,555,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,65,0,0,0,0,0},
{0,0,0,0,0,0,0,0,65,1013,1209,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,98,1111,883,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,196,1144,588,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0},
{0,0,0,0,0,65,1111,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,719,915,1176,1177,0,0,0},
{0,0,0,0,0,850,980,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,719,1209,1308,1308,1308,1308,686,0,0,0},
{0,0,0,0,556,1308,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,327,915,1308,1308,1308,1308,1308,1308,1308,131,0,0,0},
{0,0,0,294,1275,1242,0,0,0,0,0,0,0,0,0,0,0,0,654,458,0,0,0,0,0,32,490,1079,1308,1308,1308,1308,1275,948,653,1275,883,0,0,0,0},
{0,0,0,1013,1308,883,0,0,0,0,0,0,0,0,0,0,0,0,1176,131,0,0,0,98,621,1177,1308,1308,1308,1308,1111,588,98,0,0,1177,294,0,0,0,0},
{0,0,196,1308,1308,1013,0,0,0,0,0,0,0,0,0,0,0,392,1176,0,0,262,784,1275,1308,1308,1308,1308,948,359,0,0,0,0,229,1013,0,0,0,0,0},
{0,0,752,1308,1308,1242,392,196,261,0,0,0,0,0,0,0,0,948,1308,882,1111,1308,1308,1308,1308,1275,784,196,0,0,0,0,0,0,65,163,0,0,0,0,0},
{0,0,1046,1308,1308,1308,1308,1209,621,0,0,0,0,0,0,0,131,1308,1308,1308,1308,1308,1308,1177,621,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1242,1308,1111,686,294,0,0,0,0,0,0,0,0,0,686,1308,1308,1308,1275,948,425,0,0,0,0,0,0,0,0,0,261,686,915,1079,817,294,0,0,0},
{0,65,556,163,0,0,0,0,0,0,0,0,0,0,0,32,1177,1275,948,555,98,0,0,0,0,0,0,0,0,0,458,1046,1308,1308,1308,1308,1308,1046,0,0,0},
{0,0,0,0,0,0,0,0,0,392,1177,1013,0,0,0,32,131,0,0,0,0,0,0,0,0,0,0,0,261,1013,1308,1308,1308,1308,1308,1308,1308,1275,0,0,0},
{0,0,0,0,0,0,0,0,0,1013,1308,1144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,654,1275,1275,883,556,392,327,621,1242,1308,1046,0,0,0},
{0,0,0,0,0,0,0,0,0,556,1013,327,0,0,0,0,0,0,0,0,0,0,0,0,0,98,948,1242,588,98,0,0,0,0,0,654,1308,490,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1111,850,98,0,0,0,0,0,0,0,784,1144,32,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1111,588,0,0,0,0,0,0,0,0,32,1176,392,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1046,425,0,0,0,0,0,0,0,0,0,784,817,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,1013,490,0,0,0,0,0,0,0,0,0,458,1046,32,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,719,817,0,0,0,0,0,0,0,0,0,425,1176,131,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,326,1046,32,0,0,0,0,0,0,0,0,556,1177,196,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1144,327,0,0,0,0,0,0,0,65,850,1177,196,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,719,915,0,0,0,0,0,0,0,327,1176,1079,163,0,0,0,0,229,653,32,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1242,163,0,0,0,0,0,229,883,1308,817,65,0,0,326,784,1176,1308,1013,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,621,1013,0,0,0,0,327,883,1308,1177,490,0,131,653,1144,1308,1308,1308,1308,490,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,1177,490,0,98,719,1176,1308,1176,621,65,425,980,1308,1308,1308,1308,1308,1308,1275,65,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,1308,98,0,0,65,261,65,131,653,1177,1308,1308,1308,1308,1209,784,556,1177,882,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,784,1176,0,0,0,32,425,948,1308,1308,1308,1308,1275,850,392,0,0,0,1046,229,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1111,1013,0,261,752,1242,1308,1308,1308,1308,1046,555,98,0,0,0,0,229,850,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1308,1111,1046,1308,1308,1308,1308,1242,784,261,0,0,0,0,0,0,0,817,163,0,0,0,0,0},
{0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,261,882,1308,1308,1308,1308,1308,1013,490,65,0,0,0,0,0,0,0,0,0,32,0,0,326,0,0,0},
{0,0,0,0,0,1046,196,0,0,0,0,0,65,555,1046,1308,1308,1308,1308,1242,752,196,0,0,0,0,0,0,0,0,0,0,0,0,65,523,1079,1177,0,0,0},
{0,0,0,0,261,1308,0,0,0,0,359,850,1275,1308,1308,1308,1308,1308,1177,32,0,0,0,0,0,0,0,0,0,0,0,0,163,719,1242,1308,1308,1079,0,0,0},
{0,0,0,0,784,1308,653,425,719,1176,1308,1308,1308,1308,1177,686,261,1176,1308,65,0,0,0,0,0,0,0,0,0,0,392,915,1308,1308,1308,1308,1308,980,0,0,0},
{0,0,0,65,1242,1308,1308,1308,1308,1308,1308,1308,948,425,0,0,0,131,654,163,0,0,0,0,0,0,0,65,556,1111,1308,1308,1308,1308,1111,980,1308,686,0,0,0},
{0,0,0,556,1308,1308,1308,1308,1308,1177,686,131,0,0,0,0,0,0,0,0,0,0,0,0,0,196,784,1242,1308,1308,1308,1308,1046,425,0,653,1308,294,0,0,0},
{0,0,0,1144,1308,1308,1275,948,425,0,0,0,0,0,0,0,0,0,0,0,0,0,32,458,1013,1308,1308,1308,1308,1308,980,392,0,0,0,817,1209,0,0,0,0},
{0,0,490,1242,948,556,98,0,0,0,0,0,0,0,0,0,0,0,0,0,163,719,1209,1308,1308,1308,1308,1308,1046,326,0,0,0,0,0,1013,784,0,0,0,0},
{0,0,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,948,1308,1308,1308,1308,1308,1308,1275,719,32,0,0,0,0,0,32,1242,163,0,0,0,0},
{0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,131,653,1176,1308,1308,1308,1308,1275,1242,1308,1144,326,0,0,0,0,0,0,0,425,883,0,0,0,0,0},
{0,0,0,0,0,1079,131,0,0,0,0,0,32,425,948,1308,1308,1308,1308,1308,1144,621,654,1308,817,65,0,0,0,0,0,0,0,0,1013,229,0,0,0,0,0},
{0,0,0,0,327,1242,0,0,0,0,294,784,1242,1308,1308,1308,1308,1308,948,392,0,425,1275,425,0,0,0,0,0,0,0,0,0,425,850,0,0,0,0,0,0},
{0,0,0,0,883,1242,196,359,752,1176,1308,1308,1308,1308,1308,1177,686,131,0,0,359,1242,392,0,0,0,0,0,0,0,0,0,131,1111,98,0,0,0,0,0,0},
{0,0,0,163,1308,1308,1308,1308,1308,1308,1308,1308,1275,915,392,0,0,0,0,98,1176,326,0,0,0,0,0,0,0,0,0,65,1013,425,0,0,0,0,0,0,0},
{0,0,0,719,1308,1308,1308,1308,1308,1308,1079,588,98,0,0,0,0,0,0,915,458,0,0,0,0,0,0,0,0,0,65,1013,882,0,0,0,0,0,0,0,0},
{0,0,65,1242,1308,1308,1308,1176,719,229,0,0,0,0,0,0,0,0,490,817,0,0,0,0,0,0,0,0,0,131,1111,1046,65,0,0,0,0,0,0,0,0},
{0,0,555,1275,1013,654,294,0,0,0,0,0,0,0,0,0,0,32,1144,131,0,0,0,0,0,0,0,0,556,1242,1111,98,0,0,0,0,0,0,0,0,0},
{0,0,131,65,0,0,0,0,0,0,0,0,0,0,0,0,0,523,1046,0,0,0,0,0,0,0,294,1079,1308,1209,196,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1111,915,0,0,0,0,0,131,817,1308,1308,1209,294,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,1308,1275,294,0,131,425,915,1275,1308,1308,1046,131,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,458,1308,1308,1308,1308,1308,1308,1308,1308,1308,850,65,0,0,0,0,0,32,131,294,65,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,621,1308,1308,1308,1308,1308,1308,1308,1242,556,0,0,0,0,0,392,817,1242,1308,1308,1308,719,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,294,1308,1308,1308,1308,1308,1275,752,65,0,0,0,0,359,1046,1308,1308,1308,1308,1308,1308,1275,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,654,1111,1176,883,621,163,0,0,0,0,65,817,1308,1308,1242,1079,948,1144,1308,1308,1046,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,1144,1308,915,392,32,0,0,0,621,1308,719,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,1177,1046,262,0,0,0,0,0,0,326,1275,196,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,294,1209,654,0,0,0,0,0,0,0,0,719,653,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,294,1209,458,0,0,0,0,0,0,0,0,261,1046,32,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,1242,425,0,0,0,0,0,0,0,0,98,1111,261,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1046,555,0,0,0,0,0,0,0,0,163,1111,425,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,719,621,0,0,0,0,0,0,0,0,196,1144,621,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,360,948,0,0,0,0,0,0,0,0,359,1176,752,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1111,261,0,0,0,0,0,0,0,621,1308,719,0,0,327,686,1013,1275,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,654,719,0,0,0,0,0,0,294,915,1308,751,196,654,1112,1308,1308,1308,751,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1242,98,0,0,0,0,164,817,1308,1308,1046,1046,1308,1308,1308,1308,1308,1308,196,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,654,948,0,0,0,262,719,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1046,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1209,523,424,915,1242,1308,1308,1308,915,196,1308,1308,1308,1112,653,163,33,1307,490,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,1308,130,719,1275,1308,1242,850,359,0,457,1308,915,359,0,0,0,327,1078,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,882,1210,0,0,0,130,0,0,0,0,654,262,0,0,0,0,0,1046,360,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1274,1111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,490,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,1308,980,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,490,1308,850,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,294,752,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,686,1308,947,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,588,1078,1308,1111,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,752,1308,1079,0,0,0,0,0,0,0,0,0,0,0,0,425,915,1308,1308,1308,1308,621,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,849,1308,1242,392,751,0,0,0,0,0,0,0,327,784,1242,1308,1308,1308,1308,1308,915,131,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,686,817,360,1111,425,0,0,0,0,294,719,1111,1308,1308,1308,1308,1274,849,425,65,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,457,1308,131,98,425,785,1177,1308,1308,1308,1308,1308,915,425,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1079,1308,1308,1308,1308,1308,1308,1308,1308,1308,687,196,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,752,1308,1308,1308,1308,1308,1308,1308,1308,817,163,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,360,1308,1308,1308,1308,1144,915,1274,1013,327,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1308,1111,915,588,228,164,1079,523,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,1307,359,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,261,1307,261,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1111,424,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,980,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,719,1308,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,1308,1274,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,850,1308,1308,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1079,1308,1079,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,555,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,326,948,719,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,65,883,1308,1275,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,131,1046,1308,1275,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,1046,1308,1275,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,719,1308,1308,490,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,229,1308,1308,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,883,1308,1046,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,229,1308,1308,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,654,1308,1176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1013,1308,621,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,65,1275,1308,392,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,131,1308,1308,326,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,131,1308,1308,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,131,1308,1308,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1275,1308,392,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1046,1308,621,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,555,0,0,0,0,0},
{0,0,0,653,1308,1111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,1111,1308,65,0,0,0,0},
{0,0,0,32,1177,1308,621,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,490,1275,1308,654,0,0,0,0,0},
{0,0,0,0,490,1308,1275,326,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,882,1308,1275,556,0,0,0,0,0,0},
{0,0,0,0,0,556,1308,1275,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,1209,1308,1275,425,0,0,0,0,0,0,0},
{0,0,0,0,0,0,556,1308,1308,850,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,948,1308,1308,1176,294,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,556,1275,1308,1275,784,261,0,0,0,0,0,0,0,0,0,0,0,0,163,752,1275,1308,1275,686,65,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,196,980,1308,1308,1308,1079,621,229,0,0,0,0,0,0,65,425,915,1308,1308,1308,948,196,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,425,1111,1308,1308,1308,1308,1275,1013,980,980,980,1111,1308,1308,1308,1209,752,261,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,196,621,1013,1275,1308,1308,1308,1308,1308,1242,1013,784,392,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,131,229,294,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,65,948,458,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,686,1242,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,163,1275,817,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,719,1308,327,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1046,1209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,261,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,65,1308,817,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,262,653,1046,1308,1308,392,0,0},
{0,0,0,0,0,0,0,0,0,0,0,392,1308,458,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,425,817,1209,1308,1308,1308,1111,425,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,784,1308,98,0,0,0,0,0,0,0,0,0,0,0,229,556,817,1111,1308,1308,1308,1308,1111,654,229,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,1111,1046,0,0,0,0,0,0,0,0,0,0,0,817,1308,1308,1308,1308,1308,1176,686,229,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,98,1308,817,0,0,0,0,0,0,0,0,0,0,0,458,1308,1308,1308,980,294,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,196,1308,621,0,0,0,0,0,0,0,0,0,0,0,0,326,1144,1308,1275,555,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,326,1308,425,0,0,0,0,0,0,0,0,0,0,0,0,0,65,817,1308,1308,817,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,326,1308,261,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,1209,1308,1013,98,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,490,1308,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,1046,1308,1111,196,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,490,1308,262,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,817,1308,1242,326,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,621,1308,326,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,556,1308,1209,98,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,621,1308,392,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,686,1308,817,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,490,1308,490,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,948,1308,326,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,326,1308,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,1308,817,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,163,1308,1144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,883,1209,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,32,1308,1308,163,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,1308,262,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,1013,1308,523,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,229,1308,621,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,556,1308,1013,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,1308,752,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,131,1308,1308,326,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,1308,817,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1013,1308,980,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,359,1308,817,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,392,1308,1308,326,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,588,1308,653,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,817,1308,1176,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1111,1308,327,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,98,1209,1308,980,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,490,1308,1209,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,1275,1308,784,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1111,1308,653,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,425,1275,1308,1013,131,0,0,0,0,0,0,0,0,0,0,0,0,0,882,1308,1177,65,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,294,1242,1308,1209,392,0,0,0,0,0,0,0,0,0,0,0,882,1308,1177,196,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,1144,1308,1308,1046,490,32,0,0,0,0,0,0,327,948,1308,1177,196,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,654,1275,1308,1308,1209,784,556,490,490,653,1144,1308,1308,980,196,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,719,1177,1308,1308,1308,1308,1308,1308,1308,1046,326,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,327,621,784,948,752,490,229,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,228,981,523,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,327,1275,850,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,1078,1177,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,719,1308,523,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,33,1308,1013,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,457,1308,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,850,1210,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,458,1046,1275,1308,490,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,1242,752,0,0,0,0,0,0,0,0,0,0,0,0,0,0,458,1308,1308,1307,1308,1013,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,294,1308,523,0,0,0,0,0,0,0,0,0,0,0,0,0,32,1176,1308,719,32,1308,1078,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,457,1308,360,0,0,0,0,0,0,0,0,0,0,0,0,0,719,1308,1111,0,229,1308,1013,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,588,1308,392,0,0,0,0,0,0,0,0,0,0,0,0,0,1177,1308,458,0,458,1308,883,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,719,1308,327,0,0,0,0,0,0,0,0,0,0,0,0,196,1308,1308,33,0,719,1308,719,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,882,1308,457,0,0,0,0,0,0,0,0,0,0,0,0,490,1308,1209,0,0,981,1308,490,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,752,1308,556,0,0,0,0,0,0,0,0,0,0,0,0,458,1308,1046,0,0,1242,1308,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,621,1308,686,0,0,0,0,0,0,0,0,0,0,0,0,392,1308,1176,0,425,1308,1176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,458,1308,948,0,0,0,0,0,0,0,0,0,0,0,0,294,1308,1308,0,915,1308,653,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,327,1308,1177,0,0,0,0,0,0,0,0,0,0,0,0,65,1308,1308,915,1308,1242,65,0,0,0,0,0,0,0,0,0,0,0,0,948,0,0},
{0,0,0,0,65,1308,1308,130,0,0,0,0,0,0,0,0,0,0,0,0,1013,1308,1308,1308,556,0,0,0,0,0,0,0,0,0,0,0,0,686,1111,0,0},
{0,0,0,0,0,915,1308,490,0,0,0,0,0,0,0,0,0,0,0,0,654,1308,1308,850,0,0,0,0,0,0,0,0,0,0,0,0,457,1308,882,0,0},
{0,0,0,0,0,523,1308,1046,0,0,0,0,0,0,0,0,0,0,0,0,653,1308,1308,719,0,0,0,0,0,0,0,0,0,0,0,262,1308,1308,229,0,0},
{0,0,0,0,0,98,1308,1308,327,0,0,0,0,0,0,0,0,0,0,490,1308,1308,1308,1308,556,0,0,0,0,0,0,0,0,0,196,1144,1308,654,0,0,0},
{0,0,0,0,0,0,785,1308,1144,131,0,0,0,0,0,0,0,0,425,1308,1308,457,752,1308,1308,752,33,0,0,0,0,0,0,327,1144,1308,719,0,0,0,0},
{0,0,0,0,0,0,32,1112,1308,1013,294,0,0,0,0,0,0,621,1308,1275,360,0,0,457,1274,1308,1274,719,327,65,163,490,915,1308,1308,654,0,0,0,0,0},
{0,0,0,0,0,0,0,262,1046,1308,1308,948,719,654,621,915,1209,1308,1112,262,0,0,0,0,196,751,1307,1308,1308,1308,1308,1308,1308,1013,360,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,752,1242,1308,1308,1308,1308,1308,980,425,0,0,0,0,0,0,0,0,98,654,1013,1177,1079,785,457,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,392,653,588,523,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,97,196,359,196,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,261,392,490,556,588,621,686,719,752,784,817,915,981,1078,1176,1308,1308,1308,1308,621,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,196,523,882,1210,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1275,817,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,882,1308,1308,1308,1308,1307,1079,882,752,621,523,425,425,425,425,425,425,425,425,425,327,196,66,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,1144,1308,1308,621,262,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,294,1209,1308,948,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,164,1013,1308,948,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,785,1308,1144,327,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,588,1308,1308,556,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,1209,1308,784,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,164,1013,1308,1144,392,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,785,1308,1308,752,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,588,1308,1308,1079,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,359,1176,1308,1308,588,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,883,1308,1308,850,65,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,621,1308,1308,1111,262,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,392,1209,1308,1308,523,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,163,980,1308,1308,654,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,785,1308,1308,752,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,621,1308,1308,882,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,523,1308,1308,882,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,589,1308,1308,850,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,229,392,588,654,719,752,784,686,588,490,327,131,981,1308,1308,817,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,425,654,850,1013,1177,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,1308,556,0,0,0},
{0,0,0,0,0,0,0,0,0,0,65,457,817,1111,1308,1308,1308,1308,1308,1307,1177,1078,948,817,784,817,849,882,883,948,1111,1274,1308,1308,1308,1308,1308,1308,294,0,0},
{0,0,0,0,0,0,0,98,523,947,1308,1308,1308,1308,1079,850,621,392,131,0,0,0,0,0,0,0,0,0,0,0,0,0,98,261,458,850,1242,1308,850,0,0},
{0,0,0,0,0,425,882,1308,1308,1308,1111,752,392,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,196,588,0,0},
{0,0,0,556,1144,1308,1308,1144,588,196,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,490,1177,1308,1308,1078,523,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{621,1308,1308,1079,425,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1308,1308,687,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1274,294,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

void disp_centered_text(String text, int h) {
  int16_t x1;
  int16_t y1;
  uint16_t width;
  uint16_t height;

  gfx -> getTextBounds(text, 0, 0, & x1, & y1, & width, & height);
  gfx -> setCursor((320 - width) / 2, h);
  gfx -> print(text);
}

void disp_button_designation() {
  gfx -> setTextSize(1);
  gfx -> setTextColor(0x07e0);
  gfx -> setCursor(0, 232);
  gfx -> print("A button, 'Enter' - continue ");
  gfx -> setTextColor(five_six_five_red_color);
  gfx -> print("B button, 'Esc' - cancel");
}

void disp_button_designation_for_del() {
  gfx -> setTextSize(1);
  gfx -> setTextColor(five_six_five_red_color);
  gfx -> setCursor(0, 232);
  gfx -> print("A button, 'Enter' - continue ");
  gfx -> setTextColor(0x07e0);
  gfx -> print("B button, 'Esc' - cancel");
}

void call_main_menu() {
  gfx -> fillScreen(0x0000);
  for (int i = 0; i < 320; i++) {
    for (int j = 0; j < 40; j++) {
      gfx -> drawPixel(i, j + 10, handwritten_midbar[i][j]);
    }
  }
  curr_key = 0;
  main_menu(curr_key);
}

void main_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 60;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("Logins", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Credit Cards", sdown + 30);
    disp_centered_text("Notes", sdown + 50);
    disp_centered_text("Phone Numbers", sdown + 70);
    disp_centered_text("Encryption Algorithms", sdown + 90);
    disp_centered_text("Hash Functions", sdown + 110);
    disp_centered_text("Factory Reset", sdown + 130);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Logins", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Credit Cards", sdown + 30);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Notes", sdown + 50);
    disp_centered_text("Phone Numbers", sdown + 70);
    disp_centered_text("Encryption Algorithms", sdown + 90);
    disp_centered_text("Hash Functions", sdown + 110);
    disp_centered_text("Factory Reset", sdown + 130);
  }
  if (curr_pos == 2) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Logins", sdown + 10);
    disp_centered_text("Credit Cards", sdown + 30);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Notes", sdown + 50);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Phone Numbers", sdown + 70);
    disp_centered_text("Encryption Algorithms", sdown + 90);
    disp_centered_text("Hash Functions", sdown + 110);
    disp_centered_text("Factory Reset", sdown + 130);
  }
  if (curr_pos == 3) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Logins", sdown + 10);
    disp_centered_text("Credit Cards", sdown + 30);
    disp_centered_text("Notes", sdown + 50);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Phone Numbers", sdown + 70);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Encryption Algorithms", sdown + 90);
    disp_centered_text("Hash Functions", sdown + 110);
    disp_centered_text("Factory Reset", sdown + 130);
  }
  if (curr_pos == 4) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Logins", sdown + 10);
    disp_centered_text("Credit Cards", sdown + 30);
    disp_centered_text("Notes", sdown + 50);
    disp_centered_text("Phone Numbers", sdown + 70);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Encryption Algorithms", sdown + 90);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Hash Functions", sdown + 110);
    disp_centered_text("Factory Reset", sdown + 130);
  }
  if (curr_pos == 5) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Logins", sdown + 10);
    disp_centered_text("Credit Cards", sdown + 30);
    disp_centered_text("Notes", sdown + 50);
    disp_centered_text("Phone Numbers", sdown + 70);
    disp_centered_text("Encryption Algorithms", sdown + 90);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Hash Functions", sdown + 110);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Factory Reset", sdown + 130);
  }
  if (curr_pos == 6) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Logins", sdown + 10);
    disp_centered_text("Credit Cards", sdown + 30);
    disp_centered_text("Notes", sdown + 50);
    disp_centered_text("Phone Numbers", sdown + 70);
    disp_centered_text("Encryption Algorithms", sdown + 90);
    disp_centered_text("Hash Functions", sdown + 110);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Factory Reset", sdown + 130);
  }
}

void input_source_for_data_in_flash_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 60;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("Encoder + Keyboard", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Serial Terminal", sdown + 30);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Encoder + Keyboard", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Serial Terminal", sdown + 30);
  }
}

void input_source_for_data_in_flash(byte record_type) {
  gfx -> fillScreen(0x0000);
  gfx -> setTextSize(2);
  gfx -> setTextColor(current_inact_clr);
  disp_centered_text("Choose Input Source", 10);
  curr_key = 0;
  input_source_for_data_in_flash_menu(curr_key);
  disp_button_designation();
  bool cont_to_next = false;
  while (cont_to_next == false) {
    enc0.tick();
    if (enc0.left())
      curr_key--;
    if (enc0.right())
      curr_key++;

    if (curr_key < 0)
      curr_key = 1;

    if (curr_key > 1)
      curr_key = 0;

    if (enc0.turn()) {
      input_source_for_data_in_flash_menu(curr_key);
    }

    a_button.tick();
    if (a_button.press()) {
      if (curr_key == 0) {
        if (record_type == 0)
          Serial.println("Add Login from Encoder + Keyboard");
        if (record_type == 1)
          Serial.println("Add Credit Card from Encoder + Keyboard");
        if (record_type == 2)
          Serial.println("Add Note from Encoder + Keyboard");
        if (record_type == 3)
          Serial.println("Add Phone Number from Encoder + Keyboard");
        cont_to_next = true;
      }

      if (curr_key == 1) {
        if (record_type == 0)
          Serial.println("Add Login from Serial Terminal");
        if (record_type == 1)
          Serial.println("Add Credit Card from Serial Terminal");
        if (record_type == 2)
          Serial.println("Add Note from Serial Terminal");
        if (record_type == 3)
          Serial.println("Add Phone Number from Serial Terminal");
        cont_to_next = true;
      }
    }

    b_button.tick();
    if (b_button.press()) {
      cont_to_next = true;
    }

    delayMicroseconds(400);
    if (keyboard.available()) {
      c = keyboard.read();
      if (c > 0 && ((c & 0xFF) != 6)) {
        if (c >> 8 == 129 && (c & PS2_BREAK)) {

          if (c == 33047)
            curr_key--;

          if (c == 33048)
            curr_key++;

          if (curr_key < 0)
            curr_key = 1;

          if (curr_key > 1)
            curr_key = 0;

          if ((c & 0xFF) == 30) {
            if (curr_key == 0) {
              if (record_type == 0)
                Serial.println("Add Login from Encoder + Keyboard");
              if (record_type == 1)
                Serial.println("Add Credit Card from Encoder + Keyboard");
              if (record_type == 2)
                Serial.println("Add Note from Encoder + Keyboard");
              if (record_type == 3)
                Serial.println("Add Phone Number from Encoder + Keyboard");
              cont_to_next = true;
            }

            if (curr_key == 1) {
              if (record_type == 0)
                Serial.println("Add Login from Serial Terminal");
              if (record_type == 1)
                Serial.println("Add Credit Card from Serial Terminal");
              if (record_type == 2)
                Serial.println("Add Note from Serial Terminal");
              if (record_type == 3)
                Serial.println("Add Phone Number from Serial Terminal");
              cont_to_next = true;
            }
          }
          if ((c & 0xFF) == 27) {
            cont_to_next = true;
          }
          input_source_for_data_in_flash_menu(curr_key);
        }
      }
    }
  }
  call_main_menu();
}

void action_for_data_in_flash_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 60;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("Add", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Edit", sdown + 30);
    disp_centered_text("Delete", sdown + 50);
    disp_centered_text("View", sdown + 70);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Add", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Edit", sdown + 30);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Delete", sdown + 50);
    disp_centered_text("View", sdown + 70);
  }
  if (curr_pos == 2) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Add", sdown + 10);
    disp_centered_text("Edit", sdown + 30);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Delete", sdown + 50);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("View", sdown + 70);
  }
  if (curr_pos == 3) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Add", sdown + 10);
    disp_centered_text("Edit", sdown + 30);
    disp_centered_text("Delete", sdown + 50);
    gfx -> setTextColor(0xffff);
    disp_centered_text("View", sdown + 70);
  }
}

void action_for_data_in_flash(String menu_title, byte record_type) {
  gfx -> fillScreen(0x0000);
  gfx -> setTextSize(2);
  gfx -> setTextColor(current_inact_clr);
  disp_centered_text(menu_title, 10);
  curr_key = 0;
  action_for_data_in_flash_menu(curr_key);
  disp_button_designation();
  bool cont_to_next = false;
  while (cont_to_next == false) {
    enc0.tick();
    if (enc0.left())
      curr_key--;
    if (enc0.right())
      curr_key++;

    if (curr_key < 0)
      curr_key = 3;

    if (curr_key > 3)
      curr_key = 0;

    if (enc0.turn()) {
      action_for_data_in_flash_menu(curr_key);
    }

    a_button.tick();
    if (a_button.press()) {
      if (curr_key == 0) {
        if (record_type == 0)
          input_source_for_data_in_flash(record_type);
        if (record_type == 1)
          input_source_for_data_in_flash(record_type);
        if (record_type == 2)
          input_source_for_data_in_flash(record_type);
        if (record_type == 3)
          input_source_for_data_in_flash(record_type);
        cont_to_next = true;
      }

      if (curr_key == 1) {
        if (record_type == 0)
          Serial.println("Edit Login");
        if (record_type == 1)
          Serial.println("Edit Credit Card");
        if (record_type == 2)
          Serial.println("Edit Note");
        if (record_type == 3)
          Serial.println("Edit Phone Number");
        cont_to_next = true;
      }

      if (curr_key == 2) {
        if (record_type == 0)
          Serial.println("Delete Login");
        if (record_type == 1)
          Serial.println("Delete Credit Card");
        if (record_type == 2)
          Serial.println("Delete Note");
        if (record_type == 3)
          Serial.println("Delete Phone Number");
        cont_to_next = true;
      }

      if (curr_key == 3) {
        if (record_type == 0)
          Serial.println("View Login");
        if (record_type == 1)
          Serial.println("View Credit Card");
        if (record_type == 2)
          Serial.println("View Note");
        if (record_type == 3)
          Serial.println("View Phone Number");
        cont_to_next = true;
      }
    }

    b_button.tick();
    if (b_button.press()) {
      cont_to_next = true;
    }

    delayMicroseconds(400);
    if (keyboard.available()) {
      c = keyboard.read();
      if (c > 0 && ((c & 0xFF) != 6)) {
        if (c >> 8 == 129 && (c & PS2_BREAK)) {

          if (c == 33047)
            curr_key--;

          if (c == 33048)
            curr_key++;

          if (curr_key < 0)
            curr_key = 3;

          if (curr_key > 3)
            curr_key = 0;

          if ((c & 0xFF) == 30) {
            if (curr_key == 0) {
              if (record_type == 0)
                input_source_for_data_in_flash(record_type);
              if (record_type == 1)
                input_source_for_data_in_flash(record_type);
              if (record_type == 2)
                input_source_for_data_in_flash(record_type);
              if (record_type == 3)
                input_source_for_data_in_flash(record_type);
              cont_to_next = true;
            }

            if (curr_key == 1) {
              if (record_type == 0)
                Serial.println("Edit Login");
              if (record_type == 1)
                Serial.println("Edit Credit Card");
              if (record_type == 2)
                Serial.println("Edit Note");
              if (record_type == 3)
                Serial.println("Edit Phone Number");
              cont_to_next = true;
            }

            if (curr_key == 2) {
              if (record_type == 0)
                Serial.println("Delete Login");
              if (record_type == 1)
                Serial.println("Delete Credit Card");
              if (record_type == 2)
                Serial.println("Delete Note");
              if (record_type == 3)
                Serial.println("Delete Phone Number");
              cont_to_next = true;
            }

            if (curr_key == 3) {
              if (record_type == 0)
                Serial.println("View Login");
              if (record_type == 1)
                Serial.println("View Credit Card");
              if (record_type == 2)
                Serial.println("View Note");
              if (record_type == 3)
                Serial.println("View Phone Number");
              cont_to_next = true;
            }
          }
          if ((c & 0xFF) == 27) {
            cont_to_next = true;
          }
          action_for_data_in_flash_menu(curr_key);
        }
      }
    }
  }
  call_main_menu();
}

void input_source_for_encr_algs_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 60;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("Encoder + Keyboard", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Serial Terminal", sdown + 30);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Encoder + Keyboard", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Serial Terminal", sdown + 30);
  }
}

void input_source_for_encr_algs(byte record_type) {
  gfx -> fillScreen(0x0000);
  gfx -> setTextSize(2);
  gfx -> setTextColor(current_inact_clr);
  disp_centered_text("Choose Input Source", 10);
  curr_key = 0;
  input_source_for_encr_algs_menu(curr_key);
  disp_button_designation();
  bool cont_to_next = false;
  while (cont_to_next == false) {
    enc0.tick();
    if (enc0.left())
      curr_key--;
    if (enc0.right())
      curr_key++;

    if (curr_key < 0)
      curr_key = 1;

    if (curr_key > 1)
      curr_key = 0;

    if (enc0.turn()) {
      input_source_for_encr_algs_menu(curr_key);
    }

    a_button.tick();
    if (a_button.press()) {
      if (curr_key == 0) {
        if (record_type == 0)
          Serial.println("Encrypt with 3DES+AES+Blfish+Serp (Encoder + Keyboard)");
        if (record_type == 1)
          Serial.println("Encrypt with Blowfish+AES+Serp+AES (Encoder + Keyboard)");
        if (record_type == 2)
          Serial.println("Encrypt with AES+Serpent+AES (Encoder + Keyboard)");
        if (record_type == 3)
          Serial.println("Encrypt with Blowfish+Serpent (Encoder + Keyboard)");
        if (record_type == 4)
          Serial.println("Encrypt with AES+Serpent (Encoder + Keyboard)");
        if (record_type == 5)
          Serial.println("Encrypt with Serpent (Encoder + Keyboard)");
        if (record_type == 6)
          Serial.println("Encrypt with Triple DES (Encoder + Keyboard)");
        cont_to_next = true;
      }

      if (curr_key == 1) {
        if (record_type == 0)
          Serial.println("Encrypt with 3DES+AES+Blfish+Serp (Serial Terminal)");
        if (record_type == 1)
          Serial.println("Encrypt with Blowfish+AES+Serp+AES (Serial Terminal)");
        if (record_type == 2)
          Serial.println("Encrypt with AES+Serpent+AES (Serial Terminal)");
        if (record_type == 3)
          Serial.println("Encrypt with Blowfish+Serpent (Serial Terminal)");
        if (record_type == 4)
          Serial.println("Encrypt with AES+Serpent (Serial Terminal)");
        if (record_type == 5)
          Serial.println("Encrypt with Serpent (Serial Terminal)");
        if (record_type == 6)
          Serial.println("Encrypt with Triple DES (Serial Terminal)");
        cont_to_next = true;
      }
    }

    b_button.tick();
    if (b_button.press()) {
      cont_to_next = true;
    }

    delayMicroseconds(400);
    if (keyboard.available()) {
      c = keyboard.read();
      if (c > 0 && ((c & 0xFF) != 6)) {
        if (c >> 8 == 129 && (c & PS2_BREAK)) {

          if (c == 33047)
            curr_key--;

          if (c == 33048)
            curr_key++;

          if (curr_key < 0)
            curr_key = 1;

          if (curr_key > 1)
            curr_key = 0;

          if ((c & 0xFF) == 30) {
            if (curr_key == 0) {
              if (record_type == 0)
                Serial.println("Encrypt with 3DES+AES+Blfish+Serp (Encoder + Keyboard)");
              if (record_type == 1)
                Serial.println("Encrypt with Blowfish+AES+Serp+AES (Encoder + Keyboard)");
              if (record_type == 2)
                Serial.println("Encrypt with AES+Serpent+AES (Encoder + Keyboard)");
              if (record_type == 3)
                Serial.println("Encrypt with Blowfish+Serpent (Encoder + Keyboard)");
              if (record_type == 4)
                Serial.println("Encrypt with AES+Serpent (Encoder + Keyboard)");
              if (record_type == 5)
                Serial.println("Encrypt with Serpent (Encoder + Keyboard)");
              if (record_type == 6)
                Serial.println("Encrypt with Triple DES (Encoder + Keyboard)");
              cont_to_next = true;
            }

            if (curr_key == 1) {
              if (record_type == 0)
                Serial.println("Encrypt with 3DES+AES+Blfish+Serp (Serial Terminal)");
              if (record_type == 1)
                Serial.println("Encrypt with Blowfish+AES+Serp+AES (Serial Terminal)");
              if (record_type == 2)
                Serial.println("Encrypt with AES+Serpent+AES (Serial Terminal)");
              if (record_type == 3)
                Serial.println("Encrypt with Blowfish+Serpent (Serial Terminal)");
              if (record_type == 4)
                Serial.println("Encrypt with AES+Serpent (Serial Terminal)");
              if (record_type == 5)
                Serial.println("Encrypt with Serpent (Serial Terminal)");
              if (record_type == 6)
                Serial.println("Encrypt with Triple DES (Serial Terminal)");
              cont_to_next = true;
            }
          }
          if ((c & 0xFF) == 27) {
            cont_to_next = true;
          }
          input_source_for_encr_algs_menu(curr_key);
        }
      }
    }
  }
  call_main_menu();
}

void what_to_do_with_encr_alg_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 60;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("Encrypt String", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Decrypt String", sdown + 30);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Encrypt String", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Decrypt String", sdown + 30);
  }
}

void what_to_do_with_encr_alg(String menu_title, byte record_type) {
  gfx -> fillScreen(0x0000);
  gfx -> setTextSize(2);
  gfx -> setTextColor(current_inact_clr);
  disp_centered_text(menu_title, 10);
  curr_key = 0;
  what_to_do_with_encr_alg_menu(curr_key);
  disp_button_designation();
  bool cont_to_next = false;
  while (cont_to_next == false) {
    enc0.tick();
    if (enc0.left())
      curr_key--;
    if (enc0.right())
      curr_key++;

    if (curr_key < 0)
      curr_key = 1;

    if (curr_key > 1)
      curr_key = 0;

    if (enc0.turn()) {
      what_to_do_with_encr_alg_menu(curr_key);
    }

    a_button.tick();
    if (a_button.press()) {
      if (curr_key == 0) {
        input_source_for_encr_algs(record_type);
        cont_to_next = true;
      }

      if (curr_key == 1) {
        where_to_print_plaintext(record_type);
        cont_to_next = true;
      }
    }

    b_button.tick();
    if (b_button.press()) {
      cont_to_next = true;
    }

    delayMicroseconds(400);
    if (keyboard.available()) {
      c = keyboard.read();
      if (c > 0 && ((c & 0xFF) != 6)) {
        if (c >> 8 == 129 && (c & PS2_BREAK)) {

          if (c == 33047)
            curr_key--;

          if (c == 33048)
            curr_key++;

          if (curr_key < 0)
            curr_key = 1;

          if (curr_key > 1)
            curr_key = 0;

          if ((c & 0xFF) == 30) {
            if (curr_key == 0) {
              input_source_for_encr_algs(record_type);
              cont_to_next = true;
            }

            if (curr_key == 1) {
              where_to_print_plaintext(record_type);
              cont_to_next = true;
            }
          }
          if ((c & 0xFF) == 27) {
            cont_to_next = true;
          }
          what_to_do_with_encr_alg_menu(curr_key);
        }
      }
    }
  }
  call_main_menu();
}

void where_to_print_plaintext_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 60;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("Display", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Serial Terminal", sdown + 30);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Display", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Serial Terminal", sdown + 30);
  }
}

void where_to_print_plaintext(byte record_type) {
  gfx -> fillScreen(0x0000);
  gfx -> setTextSize(2);
  gfx -> setTextColor(current_inact_clr);
  disp_centered_text("Where to print plaintext?", 10);
  curr_key = 0;
  where_to_print_plaintext_menu(curr_key);
  disp_button_designation();
  bool cont_to_next = false;
  while (cont_to_next == false) {
    enc0.tick();
    if (enc0.left())
      curr_key--;
    if (enc0.right())
      curr_key++;

    if (curr_key < 0)
      curr_key = 1;

    if (curr_key > 1)
      curr_key = 0;

    if (enc0.turn()) {
      where_to_print_plaintext_menu(curr_key);
    }

    a_button.tick();
    if (a_button.press()) {
      if (curr_key == 0) {
        if (record_type == 0)
          Serial.println("Decrypt with 3DES+AES+Blfish+Serp (Display)");
        if (record_type == 1)
          Serial.println("Decrypt with Blowfish+AES+Serp+AES (Display)");
        if (record_type == 2)
          Serial.println("Decrypt with AES+Serpent+AES (Display)");
        if (record_type == 3)
          Serial.println("Decrypt with Blowfish+Serpent (Display)");
        if (record_type == 4)
          Serial.println("Decrypt with AES+Serpent (Display)");
        if (record_type == 5)
          Serial.println("Decrypt with Serpent (Display)");
        if (record_type == 6)
          Serial.println("Decrypt with Triple DES (Display)");
        cont_to_next = true;
      }

      if (curr_key == 1) {
        if (record_type == 0)
          Serial.println("Decrypt with 3DES+AES+Blfish+Serp (Serial Terminal)");
        if (record_type == 1)
          Serial.println("Decrypt with Blowfish+AES+Serp+AES (Serial Terminal)");
        if (record_type == 2)
          Serial.println("Decrypt with AES+Serpent+AES (Serial Terminal)");
        if (record_type == 3)
          Serial.println("Decrypt with Blowfish+Serpent (Serial Terminal)");
        if (record_type == 4)
          Serial.println("Decrypt with AES+Serpent (Serial Terminal)");
        if (record_type == 5)
          Serial.println("Decrypt with Serpent (Serial Terminal)");
        if (record_type == 6)
          Serial.println("Decrypt with Triple DES (Serial Terminal)");
        cont_to_next = true;
      }
    }

    b_button.tick();
    if (b_button.press()) {
      cont_to_next = true;
    }

    delayMicroseconds(400);
    if (keyboard.available()) {
      c = keyboard.read();
      if (c > 0 && ((c & 0xFF) != 6)) {
        if (c >> 8 == 129 && (c & PS2_BREAK)) {

          if (c == 33047)
            curr_key--;

          if (c == 33048)
            curr_key++;

          if (curr_key < 0)
            curr_key = 1;

          if (curr_key > 1)
            curr_key = 0;

          if ((c & 0xFF) == 30) {
            if (curr_key == 0) {
              if (record_type == 0)
                Serial.println("Decrypt with 3DES+AES+Blfish+Serp (Display)");
              if (record_type == 1)
                Serial.println("Decrypt with Blowfish+AES+Serp+AES (Display)");
              if (record_type == 2)
                Serial.println("Decrypt with AES+Serpent+AES (Display)");
              if (record_type == 3)
                Serial.println("Decrypt with Blowfish+Serpent (Display)");
              if (record_type == 4)
                Serial.println("Decrypt with AES+Serpent (Display)");
              if (record_type == 5)
                Serial.println("Decrypt with Serpent (Display)");
              if (record_type == 6)
                Serial.println("Decrypt with Triple DES (Display)");
              cont_to_next = true;
            }

            if (curr_key == 1) {
              if (record_type == 0)
                Serial.println("Decrypt with 3DES+AES+Blfish+Serp (Serial Terminal)");
              if (record_type == 1)
                Serial.println("Decrypt with Blowfish+AES+Serp+AES (Serial Terminal)");
              if (record_type == 2)
                Serial.println("Decrypt with AES+Serpent+AES (Serial Terminal)");
              if (record_type == 3)
                Serial.println("Decrypt with Blowfish+Serpent (Serial Terminal)");
              if (record_type == 4)
                Serial.println("Decrypt with AES+Serpent (Serial Terminal)");
              if (record_type == 5)
                Serial.println("Decrypt with Serpent (Serial Terminal)");
              if (record_type == 6)
                Serial.println("Decrypt with Triple DES (Serial Terminal)");
              cont_to_next = true;
            }
          }
          if ((c & 0xFF) == 27) {
            cont_to_next = true;
          }
          where_to_print_plaintext_menu(curr_key);
        }
      }
    }
  }
  call_main_menu();
}

void encryption_algorithms_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 50;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("3DES+AES+Blfish+Serp", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Blowfish+AES+Serp+AES", sdown + 30);
    disp_centered_text("AES+Serpent+AES", sdown + 50);
    disp_centered_text("Blowfish+Serpent", sdown + 70);
    disp_centered_text("AES+Serpent", sdown + 90);
    disp_centered_text("Serpent", sdown + 110);
    disp_centered_text("Triple DES", sdown + 130);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("3DES+AES+Blfish+Serp", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Blowfish+AES+Serp+AES", sdown + 30);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("AES+Serpent+AES", sdown + 50);
    disp_centered_text("Blowfish+Serpent", sdown + 70);
    disp_centered_text("AES+Serpent", sdown + 90);
    disp_centered_text("Serpent", sdown + 110);
    disp_centered_text("Triple DES", sdown + 130);
  }
  if (curr_pos == 2) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("3DES+AES+Blfish+Serp", sdown + 10);
    disp_centered_text("Blowfish+AES+Serp+AES", sdown + 30);
    gfx -> setTextColor(0xffff);
    disp_centered_text("AES+Serpent+AES", sdown + 50);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Blowfish+Serpent", sdown + 70);
    disp_centered_text("AES+Serpent", sdown + 90);
    disp_centered_text("Serpent", sdown + 110);
    disp_centered_text("Triple DES", sdown + 130);
  }
  if (curr_pos == 3) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("3DES+AES+Blfish+Serp", sdown + 10);
    disp_centered_text("Blowfish+AES+Serp+AES", sdown + 30);
    disp_centered_text("AES+Serpent+AES", sdown + 50);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Blowfish+Serpent", sdown + 70);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("AES+Serpent", sdown + 90);
    disp_centered_text("Serpent", sdown + 110);
    disp_centered_text("Triple DES", sdown + 130);
  }
  if (curr_pos == 4) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("3DES+AES+Blfish+Serp", sdown + 10);
    disp_centered_text("Blowfish+AES+Serp+AES", sdown + 30);
    disp_centered_text("AES+Serpent+AES", sdown + 50);
    disp_centered_text("Blowfish+Serpent", sdown + 70);
    gfx -> setTextColor(0xffff);
    disp_centered_text("AES+Serpent", sdown + 90);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Serpent", sdown + 110);
    disp_centered_text("Triple DES", sdown + 130);
  }
  if (curr_pos == 5) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("3DES+AES+Blfish+Serp", sdown + 10);
    disp_centered_text("Blowfish+AES+Serp+AES", sdown + 30);
    disp_centered_text("AES+Serpent+AES", sdown + 50);
    disp_centered_text("Blowfish+Serpent", sdown + 70);
    disp_centered_text("AES+Serpent", sdown + 90);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Serpent", sdown + 110);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("Triple DES", sdown + 130);
  }
  if (curr_pos == 6) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("3DES+AES+Blfish+Serp", sdown + 10);
    disp_centered_text("Blowfish+AES+Serp+AES", sdown + 30);
    disp_centered_text("AES+Serpent+AES", sdown + 50);
    disp_centered_text("Blowfish+Serpent", sdown + 70);
    disp_centered_text("AES+Serpent", sdown + 90);
    disp_centered_text("Serpent", sdown + 110);
    gfx -> setTextColor(0xffff);
    disp_centered_text("Triple DES", sdown + 130);
  }
}

void encryption_algorithms() {
  gfx -> fillScreen(0x0000);
  gfx -> setTextSize(2);
  gfx -> setTextColor(current_inact_clr);
  disp_centered_text("Encryption Algorithms", 10);
  curr_key = 0;
  encryption_algorithms_menu(curr_key);
  disp_button_designation();
  bool cont_to_next = false;
  while (cont_to_next == false) {
    enc0.tick();
    if (enc0.left())
      curr_key--;
    if (enc0.right())
      curr_key++;

    if (curr_key < 0)
      curr_key = 6;

    if (curr_key > 6)
      curr_key = 0;

    if (enc0.turn()) {
      encryption_algorithms_menu(curr_key);
    }

    a_button.tick();
    if (a_button.press()) {
      if (curr_key == 0) {
        what_to_do_with_encr_alg("3DES+AES+Blfish+Serp", curr_key);
        cont_to_next = true;
      }

      if (curr_key == 1) {
        what_to_do_with_encr_alg("Blowfish+AES+Serp+AES", curr_key);
        cont_to_next = true;
      }

      if (curr_key == 2) {
        what_to_do_with_encr_alg("AES+Serpent+AES", curr_key);
        cont_to_next = true;
      }

      if (curr_key == 3) {
        what_to_do_with_encr_alg("Blowfish+Serpent", curr_key);
        cont_to_next = true;
      }

      if (curr_key == 4) {
        what_to_do_with_encr_alg("AES+Serpent", curr_key);
        cont_to_next = true;
      }

      if (curr_key == 5) {
        what_to_do_with_encr_alg("Serpent", curr_key);
        cont_to_next = true;
      }

      if (curr_key == 6) {
        what_to_do_with_encr_alg("Triple DES", curr_key);
        cont_to_next = true;
      }
    }

    b_button.tick();
    if (b_button.press()) {
      cont_to_next = true;
    }

    delayMicroseconds(400);
    if (keyboard.available()) {
      c = keyboard.read();
      if (c > 0 && ((c & 0xFF) != 6)) {
        if (c >> 8 == 129 && (c & PS2_BREAK)) {

          if (c == 33047)
            curr_key--;

          if (c == 33048)
            curr_key++;

          if (curr_key < 0)
            curr_key = 6;

          if (curr_key > 6)
            curr_key = 0;

          if ((c & 0xFF) == 30) {
            if (curr_key == 0) {
              what_to_do_with_encr_alg("3DES+AES+Blfish+Serp", curr_key);
              cont_to_next = true;
            }

            if (curr_key == 1) {
              what_to_do_with_encr_alg("Blowfish+AES+Serp+AES", curr_key);
              cont_to_next = true;
            }

            if (curr_key == 2) {
              what_to_do_with_encr_alg("AES+Serpent+AES", curr_key);
              cont_to_next = true;
            }

            if (curr_key == 3) {
              what_to_do_with_encr_alg("Blowfish+Serpent", curr_key);
              cont_to_next = true;
            }

            if (curr_key == 4) {
              what_to_do_with_encr_alg("AES+Serpent", curr_key);
              cont_to_next = true;
            }

            if (curr_key == 5) {
              what_to_do_with_encr_alg("Serpent", curr_key);
              cont_to_next = true;
            }

            if (curr_key == 6) {
              what_to_do_with_encr_alg("Triple DES", curr_key);
              cont_to_next = true;
            }
          }
          if ((c & 0xFF) == 27) {
            cont_to_next = true;
          }
          encryption_algorithms_menu(curr_key);
        }
      }
    }
  }
  call_main_menu();
}

void hash_functions_menu(int curr_pos) {
  gfx -> setTextSize(2);
  byte sdown = 60;
  if (curr_pos == 0) {
    gfx -> setTextColor(0xffff);
    disp_centered_text("SHA-256", sdown + 10);
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("SHA-512", sdown + 30);
  }
  if (curr_pos == 1) {
    gfx -> setTextColor(current_inact_clr);
    disp_centered_text("SHA-256", sdown + 10);
    gfx -> setTextColor(0xffff);
    disp_centered_text("SHA-512", sdown + 30);
  }
}

void hash_functions() {
  gfx -> fillScreen(0x0000);
  gfx -> setTextSize(2);
  gfx -> setTextColor(current_inact_clr);
  disp_centered_text("Hash Functions", 10);
  curr_key = 0;
  hash_functions_menu(curr_key);
  disp_button_designation();
  bool cont_to_next = false;
  while (cont_to_next == false) {
    enc0.tick();
    if (enc0.left())
      curr_key--;
    if (enc0.right())
      curr_key++;

    if (curr_key < 0)
      curr_key = 1;

    if (curr_key > 1)
      curr_key = 0;

    if (enc0.turn()) {
      hash_functions_menu(curr_key);
    }

    a_button.tick();
    if (a_button.press()) {
      if (curr_key == 0) {
        Serial.println("Hash with SHA-256");
        cont_to_next = true;
      }

      if (curr_key == 1) {
        Serial.println("Hash with SHA-512");
        cont_to_next = true;
      }
    }

    b_button.tick();
    if (b_button.press()) {
      cont_to_next = true;
    }

    delayMicroseconds(400);
    if (keyboard.available()) {
      c = keyboard.read();
      if (c > 0 && ((c & 0xFF) != 6)) {
        if (c >> 8 == 129 && (c & PS2_BREAK)) {

          if (c == 33047)
            curr_key--;

          if (c == 33048)
            curr_key++;

          if (curr_key < 0)
            curr_key = 1;

          if (curr_key > 1)
            curr_key = 0;

          if ((c & 0xFF) == 30) {
            if (curr_key == 0) {
              Serial.println("Hash with SHA-256");
              cont_to_next = true;
            }

            if (curr_key == 1) {
              Serial.println("Hash with SHA-512");
              cont_to_next = true;
            }
          }
          if ((c & 0xFF) == 27) {
            cont_to_next = true;
          }
          hash_functions_menu(curr_key);
        }
      }
    }
  }
  call_main_menu();
}

void Factory_Reset() {
  gfx -> fillScreen(0x0000);
  gfx -> setTextColor(five_six_five_red_color);
  disp_centered_text("Factory Reset", 10);
  delay(500);
  disp_centered_text("Attention!!!", 50);
  gfx -> setTextColor(0xffff);
  delay(500);
  disp_centered_text("All your data", 90);
  delay(500);
  disp_centered_text("will be lost!", 110);
  delay(500);
  gfx -> setTextColor(0x1557);
  disp_centered_text("Are you sure you want", 150);
  disp_centered_text("to continue?", 170);
  gfx -> setTextSize(1);
  delay(5000);
  disp_button_designation_for_del();
  delay(5000);
  clear_variables();
  call_main_menu();
  return;
}

void clear_variables() {

}

void setup() {
  gfx -> begin();
  gfx -> fillScreen(BLACK);
  gfx -> setRotation(1);
  keyboard.begin(DATAPIN, IRQPIN);
  Serial.begin(115200);
  Serial.println("Menu");
  call_main_menu();
}

void loop() {
  enc0.tick();
  if (enc0.left())
    curr_key--;
  if (enc0.right())
    curr_key++;

  if (curr_key < 0)
    curr_key = 6;

  if (curr_key > 6)
    curr_key = 0;

  if (enc0.turn()) {
    main_menu(curr_key);
  }
  delayMicroseconds(400);

  a_button.tick();
  if (a_button.press()) {
    if (curr_key == 0)
      action_for_data_in_flash("Logins Menu", curr_key);

    if (curr_key == 1)
      action_for_data_in_flash("Credit Cards Menu", curr_key);

    if (curr_key == 2)
      action_for_data_in_flash("Notes Menu", curr_key);

    if (curr_key == 3)
      action_for_data_in_flash("Phone Numbers Menu", curr_key);

    if (curr_key == 4)
      encryption_algorithms();

    if (curr_key == 5)
      hash_functions();

    if (curr_key == 6)
      Factory_Reset();
  }

  delayMicroseconds(400);
  if (keyboard.available()) {
    c = keyboard.read();
    if (c > 0 && ((c & 0xFF) != 6)) {
      if (c >> 8 == 129 && (c & PS2_BREAK)) {

        if (c == 33047)
          curr_key--;

        if (c == 33048)
          curr_key++;

        if (curr_key < 0)
          curr_key = 6;

        if (curr_key > 6)
          curr_key = 0;

        if ((c & 0xFF) == 30) {
          if (curr_key == 0)
            action_for_data_in_flash("Logins Menu", curr_key);

          if (curr_key == 1)
            action_for_data_in_flash("Credit Cards Menu", curr_key);

          if (curr_key == 2)
            action_for_data_in_flash("Notes Menu", curr_key);

          if (curr_key == 3)
            action_for_data_in_flash("Phone Numbers Menu", curr_key);

          if (curr_key == 4)
            encryption_algorithms();

          if (curr_key == 5)
            hash_functions();

          if (curr_key == 6)
            Factory_Reset();
        }
        main_menu(curr_key);
      }
    }
  }
  delayMicroseconds(400);
}
