/*
Midbar
Distributed under the MIT License
© Copyright Maxim Bortnikov 2023
For more information please visit
https://sourceforge.net/projects/midbar/
https://osdn.net/projects/midbar/
https://github.com/Northstrix/Midbar
Required libraries:
https://github.com/zhouyangchao/AES
https://github.com/peterferrie/serpent
https://github.com/ddokkaebi/Blowfish
https://github.com/Northstrix/DES_and_3DES_Library_for_MCUs
https://github.com/ulwanski/sha512
https://github.com/Bodmer/TFT_eSPI
https://github.com/intrbiz/arduino-crypto
https://github.com/GyverLibs/EncButton
https://github.com/techpaul/PS2KeyAdvanced
https://github.com/techpaul/PS2KeyMap
https://github.com/adafruit/Adafruit-GFX-Library
https://github.com/adafruit/Adafruit_BusIO
https://github.com/adafruit/Adafruit-ST7735-Library
https://github.com/Chris--A/Keypad
*/
// !!! Before uploading this sketch -
// Switch the partition scheme to the
// "Huge APP (3MB No OTA/1MB SPIFFS)" !!!
#include <TFT_eSPI.h> // Hardware-specific library
#include <SPI.h>

TFT_eSPI tft = TFT_eSPI();       // Invoke custom library
TFT_eSprite mvng_bc = TFT_eSprite(&tft);

const uint16_t Beirut PROGMEM [320][241] = {
{1140,1108,1108,1108,1076,1108,1140,1108,1076,1076,1076,1076,1108,1108,1108,1108,1075,1075,1075,1075,1108,1107,1075,1075,1075,1075,1075,1043,1075,1075,1043,1075,1075,1075,1075,1043,1042,1042,1042,1075,1075,1075,1075,1107,1074,1074,1074,1074,13427,36115,27696,25616,21488,21520,21553,19505,17490,15475,25454,39625,35854,40210,46451,38000,38032,42225,46353,48498,50611,50611,50579,50579,48530,46451,40113,42226,33807,19212,42290,52690,48497,46384,44336,44272,40144,33806,27434,31693,46451,29745,27501,38000,40178,46451,44273,27532,29613,25420,23373,27534,25356,29581,29516,29516,27435,21162,19016,23209,40080,23275,29516,44339,42193,54871,57049,54903,42192,35918,35854,29580,25387,31628,35821,33741,33708,37966,39982,35886,14921,16969,14824,12775,14888,8582,21194,23274,27467,27435,27468,25388,27468,33839,35919,35789,33740,33772,40144,44338,52692,40177,29744,40178,40145,31661,29645,25420,14920,14921,14985,17033,35852,46253,35786,29514,25353,29546,35786,29481,25354,25386,27466,31626,31658,37867,29513,29513,23273,27465,27465,27433,27465,25417,27497,33802,48430,40076,44204,50445,50380,48300,42059,35818,40011,37964,37932,37899,31626,31691,42124,48463,52722,54869,54836,52723,48430,42124,42157,40177,31791,40276,29840,27759,27759,23566,23534,23501,23501,23469,23469,29743,50709,54902,48530,48563,54870,52723,40144,33937,36147,27792,25711,23566,23534,21485,21485,23533,21485,23533,23533,23533,255},
{1141,1108,1108,1108,1108,1140,1140,1108,1076,1108,1076,1076,1108,1108,1108,1108,1108,1076,1075,1076,1108,1107,1075,1075,1075,1075,1075,1043,1043,1075,1075,1075,1075,1075,1075,1075,1042,1043,1042,1075,1075,1075,1075,1075,1074,1074,1074,3123,25876,46517,29744,29744,31792,31792,31792,31792,31760,29712,29646,33644,33774,33839,42193,40047,40046,40047,40014,42192,42225,35919,37999,40047,40079,48564,31792,27631,29711,33936,44272,46254,44108,48367,50513,48399,48399,48399,44206,46450,42291,25551,23275,38032,46418,52692,44241,44208,48466,44305,25452,21292,21259,25421,23340,27533,23307,29614,27533,27468,33774,25420,25420,40112,44306,56984,57049,52692,46352,33740,27435,27467,29612,27467,35853,35820,33707,33741,35853,27500,14920,16968,10663,12775,14888,16936,23306,19080,21129,27435,23275,31759,27501,35919,33774,31659,29481,23240,38031,35885,35853,50612,44371,38098,38032,33741,38032,29613,21226,12840,14953,21226,44238,42060,35787,33772,23273,25353,29482,29514,27434,23241,25386,27466,23273,25321,23241,21193,23273,23305,31658,35819,33771,31724,29642,35883,40011,37931,50413,50412,48300,50413,37899,35786,40012,42125,44205,44205,31626,35883,52689,54836,54837,52756,50577,52690,44302,31658,35918,44469,42356,36050,27759,29904,23598,23533,23501,23469,25582,25517,25517,48629,54903,52757,46449,50643,54869,48562,33936,38163,36179,29905,25679,23566,23533,21485,21485,21453,21453,21453,21453,21485,255},
{1141,1108,1140,1108,1108,1140,1140,1108,1076,1108,1076,1108,1108,1108,1108,1108,1108,1076,1075,1108,1140,1108,1075,1075,1075,1075,1075,1043,1043,1075,1107,1107,1075,1075,1075,1075,1042,1075,1042,1075,1075,1075,1075,1075,1075,1075,1074,7251,36246,42389,33872,31824,31824,31824,31824,33872,33872,33872,31792,33872,33872,31791,33839,33839,33839,35887,35886,37966,37966,35853,35821,33708,35886,46517,44404,42290,40178,50676,48563,42159,44174,46385,52757,48237,48433,35755,40013,35919,29711,35985,31693,42193,48531,46321,27403,29516,48401,52724,27566,19146,19212,17034,19179,19115,21292,23372,25485,27533,27533,21259,29614,29614,29516,35855,37968,35854,46386,42127,29515,29547,35886,35919,44272,37934,33708,25354,31692,27499,23209,21162,14888,17001,17000,25322,25387,21225,17000,23242,23275,31727,35920,33774,31693,35820,39882,29513,40111,35852,21160,40079,50644,40211,35984,35886,37999,31693,27500,21194,12840,29579,46285,35851,33707,29612,21161,23241,23241,31627,35820,25385,25386,25386,25353,27433,21160,19080,21193,19112,23305,23241,25385,27498,31723,29545,33802,42124,50413,50348,46220,42124,31658,33738,37931,42125,46285,44205,35819,46383,52722,52756,52724,52723,44270,46351,52723,46416,40110,44436,38163,25549,25614,29872,23566,21421,23469,36016,40177,27564,40177,54935,52822,52822,50676,50611,54869,42289,36049,36114,29872,27792,23566,23566,23566,23534,21485,21485,21453,21453,21453,21453,255},
{1141,1108,1108,1108,1108,1141,1140,1108,1076,1076,1108,1108,1140,1108,1108,1108,1108,1076,1076,1108,1108,1108,1075,1075,1043,1107,1075,1043,1075,1107,1107,1075,1075,1075,1075,1075,1042,1075,1042,1075,1107,1075,1107,1075,1075,1075,3155,7250,42486,36115,33873,33872,33872,33873,33905,33905,33872,33904,33872,33872,33872,33839,33871,33839,33839,33871,33839,35887,35886,35854,35886,33773,42226,48631,46517,42291,40178,50612,46385,42224,42224,42192,46352,46319,42191,35820,35886,36016,35985,42160,35854,35854,48499,40015,21130,25355,44208,52659,27500,23307,21292,17002,21227,19114,21292,17099,23405,23372,23340,21324,23372,27566,27501,25388,25387,25388,27468,27500,27467,27467,33708,40014,42094,39948,37868,33707,31757,29547,21032,19049,16969,14856,19048,19049,21162,23338,17032,19049,27468,29613,27468,31694,31661,31627,21128,35754,48465,35885,19112,23241,42193,46517,36083,38098,35821,33773,33806,25355,19113,42093,40012,31691,29644,31790,31660,23274,23241,29546,31659,37997,35852,31627,29547,27466,23273,19048,21128,19016,23241,21160,25386,25385,29610,25417,33738,46285,48300,48267,42059,35818,31691,31658,35819,46318,42125,42092,46382,46350,48464,52691,52690,54803,50577,50609,52756,44270,35851,42291,31824,23501,25646,23566,21421,25581,40176,44336,38030,48563,52789,52757,54870,54903,52789,48530,52723,46516,44502,31953,25711,25743,25678,23566,23566,23534,23533,21485,21453,21453,21453,21453,255},
{1141,1108,1108,1108,1141,1173,1140,1108,1076,1076,1108,1108,1140,1140,1108,1108,1108,1108,1108,1108,1108,1108,1075,1075,1075,1107,1075,1075,1075,1107,1075,1075,1075,1075,1075,1075,1042,1075,1043,1075,1075,1107,1107,1075,1075,1075,1107,11379,46582,40308,46452,40178,36017,36017,35985,35985,33905,33905,33872,33872,33872,35952,35952,35919,35919,35951,35919,35919,33838,35886,35887,35918,38097,50711,52758,40113,29581,48466,48498,46451,42257,37999,37966,35885,35821,35821,40177,50710,42226,37935,33741,25387,42225,44273,33741,29548,31628,52692,31726,17066,17066,21195,21195,21195,21195,19114,21195,23275,21195,21260,19179,23405,25550,19147,21227,23308,23372,25453,23340,23339,27468,27500,27468,25322,29515,31595,35821,25354,23176,21097,14856,10663,10663,16968,23209,21193,21160,21160,25355,37935,29581,29613,33741,42193,19081,37867,48466,35918,21193,19080,25354,50645,44404,35985,31693,35853,35854,23274,31660,46286,29579,33870,35919,35885,35853,23241,23273,25386,27466,31660,27434,31627,29611,27499,25386,21128,23208,19080,21128,25353,29579,25385,25417,27530,37932,42060,44139,44139,35850,35851,33739,31691,33738,46318,46318,44237,50544,46416,48497,52690,54804,54804,52723,52755,50610,37932,33739,33871,29775,25581,25646,25679,23501,44369,46416,48562,50676,52757,50676,50709,50709,52822,52789,50643,48596,44469,46583,29840,25711,25711,25711,23630,23598,23566,23566,23533,21485,21453,21453,21453,255},
{1141,1140,1108,1108,1141,1173,1140,1108,1108,1108,1108,1108,1140,1140,1108,1108,1108,1108,1108,1108,1108,1108,1075,1075,1075,1107,1075,1043,1075,1075,1075,1075,1075,1075,1075,1075,1043,1042,1075,1075,1075,1139,1107,1075,1075,3155,7251,32020,48598,46517,59096,46484,46483,44403,44371,48564,44403,42290,40178,38065,35985,35984,35952,35952,35919,35952,35951,35919,35887,35887,35886,35886,36017,54936,50645,27469,19114,46418,57016,57049,56984,56983,48563,44305,40079,35853,42095,33807,27567,25388,29549,29581,50644,56852,58900,46354,29580,52660,35952,17099,15018,23372,21291,23372,23372,21227,21227,19114,19114,21195,19082,21195,21227,21227,21227,17034,21259,19179,25486,21260,19147,21259,23340,21195,23308,23275,25355,25388,23275,21162,16969,14888,12776,12776,19081,21161,19080,21193,25322,33708,31661,29581,29580,25321,16968,21096,27467,40079,21225,17032,14920,33773,50645,42291,38065,40112,35854,31628,42093,35787,31692,29645,31725,33773,25354,21128,23241,27434,25354,21161,19048,21161,23241,29547,29612,33837,27434,23241,21160,21160,25321,29578,25449,29643,37964,35818,42059,42091,35851,33771,35851,33738,42125,46286,48399,42124,46383,50610,52723,54803,54804,54803,54804,52756,52723,44270,31626,33839,29808,25614,23566,23469,40176,50643,50643,50643,48530,52756,52789,52757,50709,52822,52756,44369,48663,44502,42421,27759,27791,27824,27824,27792,25679,23598,23566,23566,21485,21485,21453,21453,255},
{1173,1141,1108,1108,1173,1173,1173,1108,1108,1108,1108,1108,1140,1140,1108,1108,1108,1108,1108,1108,1108,1108,1075,1075,1075,1075,1075,1075,1107,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1107,1139,1107,1107,1075,3155,13459,44469,46550,50710,56984,44338,46484,44403,46483,52757,48597,52757,50644,48564,50644,44370,46451,44371,42258,42258,40145,38064,37999,37967,35919,33807,35952,52726,44306,44404,33871,46451,59129,59130,59129,54903,48531,46385,42160,35822,33579,23373,19180,17002,19082,25387,54805,54740,56787,52725,27597,42192,35952,19179,12873,19212,17066,23340,23340,21259,23340,21292,21292,23372,17034,19147,14985,19082,19114,21195,19114,21162,21195,21227,19114,19211,21292,19146,19114,19146,19082,21195,21194,19082,19049,14888,10663,12776,17001,21161,19049,27531,23339,23241,31759,29679,35853,29547,25321,29482,25354,40144,19144,17000,14920,21129,46419,44305,38033,38098,35821,37933,42093,31627,37998,42159,44304,44239,40045,29547,23241,23241,23241,23241,21129,23241,23274,21129,21161,40111,38063,25353,23273,27466,25385,33738,31658,29611,37899,35786,42027,33706,44304,46449,42157,33738,48464,46318,44173,40044,46383,50610,52723,54836,52723,52755,54836,54804,50609,42125,31626,33936,29808,23533,23468,35983,52756,54870,52691,48464,48530,52789,52790,52822,54902,54869,48464,44402,50776,52857,46615,34066,29905,29905,27824,27792,25679,23598,23598,23566,21518,21485,21453,21453,255},
{1173,1141,1109,1108,1173,1173,1173,1108,1108,1108,1108,1108,1140,1140,1140,1108,1108,1108,1140,1108,1108,1108,1108,1075,1075,1107,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1107,3187,1107,1107,1107,1107,19635,42356,44404,56984,54838,42225,44338,44306,46451,48564,48564,52757,46483,50677,52757,48564,48531,46451,48564,48596,48564,50677,46451,48531,46418,40177,44371,46484,44371,61210,59129,57048,59096,59097,59097,54871,48498,44273,40047,44209,44177,25486,23341,19147,16970,29580,56853,54707,52626,50774,31856,33773,35854,23340,23340,23308,19147,19147,19147,17034,21259,21292,21260,19179,19179,17099,14953,14986,15018,23470,19244,12776,17001,17034,19082,21194,21227,21162,21162,21195,17001,19114,19114,17066,17001,12743,10695,10695,12775,21162,23210,33774,33872,23272,35919,35920,44272,44239,31627,33675,31594,42257,21257,17032,19080,14855,25354,39982,40047,40113,35919,42094,35755,40079,35821,48465,48530,46385,44238,46319,19048,19048,19048,19081,23273,29579,31692,25321,25353,31627,38031,29612,23241,27498,33706,37931,33771,27466,35787,35786,42125,42158,46417,50610,42092,37900,48464,46318,42093,37899,48496,50576,54771,52755,52755,52723,54803,52690,50544,35852,23339,23436,23501,23501,42289,52723,52690,52690,50511,50544,50611,52789,54869,54902,52756,44304,35884,44403,52889,52890,50841,40373,34098,29905,25711,25711,23631,23598,23598,23598,21518,21485,21453,21453,255},
{1173,1173,1141,1108,1173,1173,1173,1108,1108,1108,1108,1108,1140,1172,1108,1108,1108,1108,1140,1108,1108,1108,1076,1075,1107,1107,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1107,1107,1107,1107,1107,3155,21650,46484,46484,56951,54903,54871,52790,50677,48597,48564,46451,46419,46418,46418,48499,48499,46451,46418,48532,46483,46484,48597,46451,48531,48564,48564,52790,57017,57016,59130,59130,59130,59129,57049,50678,52725,50579,35789,27338,33644,37870,35855,23340,19115,21162,33741,54740,52594,48368,38194,36049,37934,40079,27565,27533,27565,23307,27533,23308,27501,23307,25420,23308,19114,21259,21227,17001,14986,14953,25583,23535,12776,17034,14986,14921,19179,21259,23372,21227,21194,19081,19082,19082,21195,19082,12743,10695,8582,10662,21161,23242,27468,25322,21224,27499,29581,31595,39980,29514,33675,27434,44338,27499,19112,19112,17000,14887,29514,42127,42258,35952,37900,42125,42128,23274,46451,38064,35918,42126,35787,39947,33707,25321,19048,27401,29546,29579,31692,31692,25386,21225,40176,29579,31659,33706,37899,33739,31691,33739,33706,44239,42127,33739,48464,42158,37900,52592,46350,40044,37899,48463,52689,52722,54804,54804,54770,52690,52657,40110,25452,21323,21356,21388,38095,52690,52690,50609,52756,52789,54837,52789,54837,54870,52756,48562,42190,44303,46484,55002,52922,48696,38260,29937,25711,25711,25679,23598,23598,23598,23598,23566,21486,21485,21485,255},
{1173,1173,1109,1108,1205,1173,1173,1140,1108,1108,1108,1140,1140,1173,1140,1108,1108,1140,1140,1108,1108,1108,1108,1075,1107,1107,1075,1075,1075,1075,1075,1075,1107,1107,1075,1075,1075,1075,1075,1075,1107,1107,1107,1107,1107,7251,38229,46484,50677,54871,54870,54871,54871,54871,56951,56984,56984,56951,54903,52790,52758,50645,50612,48531,46418,46386,46418,46418,46418,50579,46451,50644,54903,57049,59130,59129,59129,59129,59129,54904,42324,40178,40112,35887,31662,33709,27435,37901,31628,21162,25322,25323,37967,44240,37869,36049,42290,42128,50579,48531,46418,42225,38032,35919,29646,31759,25420,31726,29613,27501,27468,27500,25388,23275,21194,25485,25550,12808,19114,17098,14921,21292,23405,27663,23470,19114,17066,14953,14921,21227,19114,12743,14855,14887,12743,21161,25322,27435,23208,25385,31660,29548,27434,23273,23241,29482,23305,40177,31757,21192,21160,21161,19048,23209,37933,42225,42192,35787,48433,29547,31693,44371,19340,21323,27499,31529,44010,44010,46188,42027,42027,35819,33772,35918,33805,19112,21225,42225,42257,42225,35918,33739,37965,40078,25353,29579,33707,31594,33706,48497,44239,31594,48431,48431,46286,44205,50543,52689,54836,54836,52690,52657,50544,44205,27532,21259,21291,19275,27596,52658,52657,50544,52691,52822,52823,54903,54903,54902,54837,52788,54804,50609,44303,48662,52890,52889,40341,27824,27824,25711,25679,23598,23598,23598,23598,23598,23566,21518,21486,21486,255},
{1173,1141,1109,1109,1205,1173,1173,1140,1108,1108,1108,1140,1172,1173,1140,1108,1108,1140,1140,1140,1108,1108,1108,1075,1107,1108,1075,1075,1107,1075,1075,1075,1107,1107,1075,1075,1075,1043,1075,1075,1107,1139,1107,1107,1107,13459,40244,46484,56983,59064,54838,54806,54838,52758,52790,54838,54871,54871,54871,56951,56951,56951,56984,56984,56951,54903,54870,52757,52725,50612,48499,46418,54870,59130,59130,59130,59130,59130,59097,46517,54969,57017,44372,29647,33808,35855,33741,37967,33676,23210,23209,21129,21162,42161,40015,37934,42128,27403,50579,52790,54838,54871,54773,54772,52692,50579,48499,44306,40112,37967,33774,33806,31694,23307,27501,27501,27501,25387,25355,25387,21194,23307,23404,27663,29744,19146,19179,17034,14921,21292,21260,12743,12743,14855,14855,19048,27403,27370,23240,27433,29580,27468,27434,19080,19080,21128,19144,37999,35951,21225,21192,23306,25387,19048,29514,40014,44239,37868,42126,31595,50644,38162,13002,29677,23307,31496,46025,46090,48235,50282,48170,35819,29611,31724,33707,25385,27466,27434,31660,46450,38030,37998,44239,40046,29546,33772,31626,29514,40013,46417,48497,44206,46351,46285,46252,46318,52656,54770,54836,52689,50544,48398,37834,29515,21162,21226,19243,17162,37998,54737,50576,48431,52756,50643,52822,54870,54902,54804,52755,54836,52722,48496,42191,52857,50776,48696,38260,25678,25679,25679,23598,23598,23598,23598,23598,23598,23566,21518,21486,21486,255},
{1173,1141,1109,1141,1205,1173,1173,1108,1108,1108,1108,1140,1173,1173,1140,1140,1140,1140,1140,1140,1140,1108,1108,1076,1108,1108,1075,1107,1107,1075,1075,1075,1107,1107,1107,1107,1075,1075,1075,1075,1107,1107,1107,1107,1107,13427,44469,50711,38131,38131,42292,46484,48597,50678,52758,54838,54870,54870,54838,54838,54838,54838,54870,54870,54871,56951,54903,56951,56951,56983,56951,54871,54903,59064,59130,61178,61210,61210,54870,52823,56984,59097,33872,10696,10728,12809,12809,16969,25355,23242,35821,27403,25290,35821,50546,50547,50579,44240,48466,50580,52693,54806,54773,54773,54772,54773,54773,54773,54773,54772,52692,50547,48466,44272,40080,35918,35886,31661,25355,27501,27500,23307,27500,27533,27500,23307,21227,19114,17034,21259,23437,12808,8550,8582,14823,16968,27402,23209,21160,31626,29580,27435,23305,19080,19080,21160,21225,37965,42225,21225,21192,19048,23306,21161,19048,33773,44272,35820,31562,33708,50676,48661,34033,38032,23274,39882,48170,48267,50283,46058,44075,37965,29579,29578,29514,25321,23273,23305,29546,37933,42159,37933,29579,25386,35820,33739,31659,31691,46352,50578,46351,48432,46318,46221,42027,44205,52624,54803,54770,50511,48398,37899,29513,25354,16968,19146,19178,21290,46416,56850,50511,48399,52724,52724,54837,54869,54836,52723,54836,54803,54803,48496,37997,44404,46583,46583,31953,23566,23598,23598,23598,23598,23566,23566,23566,23566,21518,21486,21518,21518,255},
{1173,1141,1109,1141,1205,1173,1173,1140,1140,1108,1140,1140,1173,1172,1108,1140,1140,1140,1140,1140,1140,1108,1108,1108,1108,1108,1107,1107,1107,1075,1075,1107,1107,1107,1075,1107,1075,1075,1075,1107,1107,1107,1107,1107,1107,7251,48663,54903,46550,42389,40276,38163,34034,34002,33970,33970,36018,40179,48566,50678,52790,54871,56918,54870,54838,54838,54870,54838,54838,54838,54838,54870,54838,54838,54838,50579,48466,50579,50710,57049,57017,56984,46484,31726,23372,19179,14986,14921,17067,17001,42128,27403,29483,39981,54740,52659,56853,50612,35984,40177,42193,44241,50547,50547,52692,54740,54773,54772,54773,54772,54740,54740,54740,54772,54772,54772,52691,50579,46418,42224,40079,33773,33806,31693,29581,27468,25387,23275,27436,25388,27500,17001,10695,8582,10663,16936,21161,23208,25352,29578,27500,27467,21193,19080,23273,25385,23305,33772,46386,25386,21225,19048,17032,21193,19048,23273,40112,37999,21129,40014,50677,50612,54838,44338,33773,44076,41865,43977,41865,39883,44238,42158,27498,23337,27466,29514,23273,27434,27434,31659,33707,40046,33772,37998,35820,35852,31659,40045,44271,44238,44206,42093,37867,41995,44107,44237,52624,54770,52624,48366,44237,46351,44270,27467,17001,17065,19178,40175,52722,50543,48366,46318,52625,52690,54836,54869,54837,54869,54836,54803,52657,44270,31659,33870,40243,42389,27760,23565,23566,23566,23566,23566,21518,21518,21518,23566,21518,21486,21518,21518,255},
{1173,1141,1109,1173,1205,1173,1173,1141,1141,1108,1140,1173,1173,1173,1140,1140,1140,1140,1140,1140,1140,1108,1108,1107,1108,1108,1108,1107,1107,1075,1075,1075,1075,1107,1075,1075,1075,1075,1075,1107,1107,3155,1107,1107,1107,3155,27925,40374,48663,50743,52823,52823,54871,52823,50678,46484,42323,29744,25649,23504,33970,33938,29711,46419,48532,48467,48500,54806,52757,54805,54805,54837,54773,52725,48500,54837,54804,50610,52823,57050,57017,54937,52791,52758,52823,48662,46517,40243,40178,36017,40113,33740,35788,44207,52692,46321,50449,48500,44502,44437,46550,27533,33807,31629,38000,37934,42192,46354,46353,52627,50546,52659,54739,54740,54740,54772,54772,54740,54772,54772,54772,54739,52659,50546,46385,44240,37999,33741,31693,29613,29548,25355,23210,19049,16969,12775,25289,31529,29448,33675,25388,25387,21193,16967,23241,25353,33772,29514,48532,31692,25418,21193,17032,19113,21225,21128,37934,42192,29514,40014,50677,50612,50611,50645,50579,33578,31400,33512,33512,37900,37900,35820,33707,27434,29579,25386,25321,23208,27401,29546,31659,33740,44239,50578,44239,35820,29514,39980,48465,42126,44238,44205,37834,46187,50478,52624,52657,54737,48463,48431,50544,44205,29482,19081,19081,17065,33837,54835,52690,46318,50511,50511,52657,52690,54804,52788,54837,54836,52723,52690,44303,29578,27466,27499,38130,40341,25614,23533,23565,23565,23566,21518,21518,21518,21518,21518,21518,21486,21518,21518,255},
{1141,1141,1141,1173,1205,1173,1173,1141,1141,1108,1140,1173,1173,1173,1140,1140,1140,1140,1172,1172,1108,1108,1108,1108,1108,1108,1108,1108,1075,1075,1107,1107,1108,1108,1107,1075,1075,1075,1075,1107,1107,3155,1107,1107,1107,5203,7251,7251,15475,17588,21716,25876,34133,36214,40374,46485,48630,46517,40309,34003,40277,27632,6633,14954,31759,40113,31628,42225,46353,52691,46321,42128,44306,35887,35919,56950,56950,56950,52758,50678,48533,44437,38098,35888,38001,42194,46452,50678,50711,52758,48499,48498,44239,50579,58999,48466,37934,44338,46484,42259,42291,25387,33904,21194,33904,23339,38195,46615,31758,33773,37999,46386,35854,42160,46353,48433,52627,52627,54739,54740,54740,54739,54707,54707,54739,54739,54739,52659,52626,48466,46320,40047,33773,29548,23274,27337,25224,31562,35689,33739,23308,25387,21193,17000,25321,35885,35788,29546,50645,37966,37964,33804,17032,19080,21193,21193,31660,40047,40046,42159,50677,50644,50612,52790,44274,23144,21032,21096,23209,33675,29546,33674,35787,27434,33837,27434,25289,27369,27401,27434,35852,37965,33772,50578,42126,37933,37998,35852,46385,27466,33739,42093,39947,46252,50511,52624,52657,52657,50511,46318,40012,31594,19048,21194,17065,23339,50609,54737,54804,52690,52657,50543,52657,54803,54804,52723,54803,54803,50642,46383,37964,33804,35949,33771,40178,31921,23501,23533,23565,23565,21518,21517,21517,21518,21517,21518,21518,21486,21518,21486,255},
{1141,1141,1141,1173,1205,1205,1173,1140,1140,1108,1140,1140,1173,1172,1140,1140,1140,1140,1173,1172,1108,1108,1108,1108,1108,1108,1108,1108,1075,1075,1107,1107,1107,1107,1107,1075,1075,1075,1075,1107,1107,1107,1107,1107,1107,7283,7251,9331,11412,11379,15508,15508,17556,17556,19603,23634,19603,27762,42324,44405,31760,19180,10890,27566,40113,52725,54738,50546,54739,50546,39949,29646,33905,37935,40112,52725,56885,56951,54870,54936,52791,46550,46583,40244,35985,31759,29645,27533,33806,44274,54739,58964,56851,54772,50481,50546,46353,50612,52692,50579,48499,44273,44306,35854,38000,27500,44469,50743,27500,31759,31661,40145,29841,31791,29645,38130,40178,38064,37967,44208,44208,48401,50514,52626,54707,54707,54739,54739,54707,54707,54674,54674,52594,52561,44076,31464,27337,29481,35754,35853,25420,27467,19080,17032,29514,40046,25256,33707,50677,46385,37932,37932,25386,21192,25418,25419,29548,35886,40111,37966,50645,50677,50677,50677,37902,35821,21161,23306,25321,27369,39980,35820,35755,31627,33772,23273,23208,27369,27369,25353,29546,33739,29611,33707,33707,50578,46353,42159,44240,35852,33739,46253,48300,48333,50512,50511,52624,50577,42125,35852,31627,23176,19049,19178,17033,40176,56916,56916,52723,52691,54771,52689,54803,54836,54770,54803,54803,50642,48529,48562,46481,50676,48496,35884,31791,27694,23501,21485,21485,21485,21485,21485,21485,21485,21518,21518,21518,21518,21486,21486,255},
{1173,1141,1141,1205,1238,1205,1173,1141,1141,1140,1173,1173,1173,1172,1108,1140,1140,1140,1173,1172,1108,1108,1108,1108,1108,1108,1108,1108,1076,1075,1108,1108,1107,1107,1107,1075,1075,1075,1075,1107,1107,1107,1107,1107,1107,7283,5203,11380,11379,13428,15508,17556,17588,19604,25714,23601,25747,25519,35921,38066,35887,25420,29679,29581,31629,48433,50546,50545,52659,29548,23242,27566,31825,54839,56918,54805,54805,54838,52691,56852,50612,52889,54937,54970,54970,54969,52856,46550,37967,44240,56851,56818,56851,48498,48466,44240,31660,50612,52758,52790,54805,44306,52725,48499,52692,48531,50612,48531,40112,42225,31661,38032,38162,29613,31791,42454,42389,42388,29710,33903,25420,31758,33806,37966,42159,42127,44207,48401,50481,52594,52594,52594,52593,50415,46058,35657,27369,27336,37900,23437,27500,27467,17000,19145,35819,25288,19080,37998,52725,50611,42159,33706,35819,37997,35918,31660,27467,33774,42192,42192,48531,50677,44306,29645,35789,46320,42158,40045,19047,35787,46220,39980,25289,27402,29546,23208,29416,29416,23208,25353,35819,31594,27498,25418,29514,42159,35820,42159,42159,37933,37867,48366,46253,48365,50544,48431,46318,44205,37900,29547,25353,16968,19114,17033,27499,54835,56883,52723,50610,52691,54803,54803,54836,54803,54803,54868,54836,54869,54902,54869,56983,54869,46415,31724,31856,25614,23501,21485,21485,21485,21485,21485,21485,21485,21485,21485,21486,21486,21485,21518,255},
{1173,1141,1141,1205,1237,1205,1173,1141,1141,1141,1173,1173,1173,1173,1140,1140,1140,1140,1173,1172,1108,1108,1108,1108,1140,1108,1108,1108,1075,1075,1108,1108,1107,1107,1107,1075,1107,1075,1075,1107,1107,1107,1107,1107,5235,9332,5203,11380,11379,13460,15508,17556,17556,19636,31922,27697,35953,31661,40112,50645,42226,40113,37968,29646,29549,52594,52594,54706,52659,31661,23275,33971,29712,46419,54805,52757,54838,52725,50612,50579,46451,54969,48630,44371,46452,48565,50678,44405,31693,50545,56851,54706,48400,48531,52725,50547,46386,52660,50612,52757,50612,40145,48467,42258,46386,46419,54838,52725,48466,52724,54773,50579,50546,46385,46385,44370,44370,44371,29678,33903,27598,31758,33871,31628,40144,44436,31791,31790,36016,37966,37934,42062,50448,46091,46123,35690,31497,35689,35951,23534,27501,25354,19048,21225,39947,25321,25385,46417,50612,48564,48531,33805,33739,52691,42192,33773,33708,33709,44338,46418,48532,50677,31694,27565,50676,48465,50611,42191,25353,48333,39948,27434,16935,19048,25321,27368,27336,25256,19015,23241,33707,25321,31627,29547,29514,35820,46384,42126,46352,52658,44206,44140,44140,44140,46286,42092,40012,37932,31595,25386,19048,14855,17001,17033,44304,54770,52658,50578,52691,52690,52690,54803,54836,54869,56949,56950,56982,56982,56983,56983,57015,54869,37997,29678,29808,23533,23533,21485,21485,21485,21485,21485,21485,21485,21485,21485,21485,21486,21485,21518,255},
{1173,1141,1141,1205,1237,1205,1173,1141,1141,1141,1173,1173,1173,1173,1140,1108,1140,1140,1173,1140,1108,1108,1108,1108,1140,1108,1108,1108,1075,1076,1108,1108,1107,1107,1107,1107,1107,1075,1075,1107,1140,1107,1107,3155,9332,7251,9331,11380,9331,11379,15508,17588,21586,19278,27567,19343,38164,42324,44372,46452,40113,35855,35887,33774,33807,37935,27403,33774,44273,37968,31759,40244,31760,42193,56918,54837,54805,52692,44272,35822,29549,35888,46452,50710,48630,48597,48565,40178,48498,58964,54739,48367,48367,48531,50711,44273,46353,46353,48434,48466,48434,50579,50579,50612,44273,50612,50644,52692,38031,48564,50645,42225,50612,54838,54805,52757,48466,50578,48433,48433,44305,40047,40112,29547,42225,46516,31791,36049,44501,33839,31726,40145,46287,39785,48236,35690,31464,41962,29775,31726,27468,27402,17000,21225,39947,31593,35755,50578,48531,50645,50612,50677,44305,52692,46418,46451,31692,29547,40145,46451,48596,48532,25388,33806,48466,40046,50611,48465,39947,35819,25419,23274,16935,19015,21096,25256,23176,19015,19015,21128,27434,33740,35820,33707,25321,35820,52691,35853,35788,42093,48333,46252,48333,42060,42126,40012,35819,31594,25321,19048,14823,14856,14888,33772,54770,52625,50544,52690,52657,52690,54803,54836,56918,56982,56950,56983,56983,57015,57015,56983,59063,50610,27466,29743,27727,23533,23533,23533,21485,21485,21485,21485,21485,21485,21453,21485,21485,21485,21485,21486,255},
{1173,1173,1173,1237,1237,1205,1173,1141,1141,1141,1173,1173,1205,1173,1140,1108,1140,1140,1173,1140,1108,1108,1108,1108,1140,1108,1108,1108,1075,1076,1108,1108,1107,1107,1107,1107,1107,1075,1075,1107,1108,1107,3155,3155,7283,5203,11412,11412,9299,11379,15508,19636,27697,14987,10859,10859,33938,46485,48565,35985,42193,42194,42161,40080,46451,42260,38098,38098,40146,42227,35953,38033,31727,48499,56918,54837,56885,48434,40015,33741,33806,27468,29516,42127,46418,52758,48500,46419,50579,58965,54707,46253,48301,44305,48598,44241,42192,42192,42160,42192,40047,35854,40112,56885,56786,52593,44208,48402,50546,48466,50579,44305,52692,52725,52725,52758,37999,50644,46483,48466,50611,54772,52691,52659,50546,48465,44240,42224,44305,33806,37999,44273,48237,37704,44076,39882,37801,46188,37999,27501,27468,25354,19112,21193,35754,35722,35788,50611,48466,48564,50645,50677,50644,48532,48596,48564,46451,35919,35919,44371,48531,40145,23307,33741,27402,35886,50611,48465,48432,44304,46385,42126,23176,21096,16935,19016,21096,19016,21096,23208,29514,42093,35787,29481,29514,31627,42126,35852,35787,46188,39914,42027,39980,44174,44206,42125,29514,23209,16936,14823,14791,14824,21161,48464,52658,50544,50543,52689,52658,54803,54836,54869,56982,59030,56950,56982,56982,56950,56950,54869,52690,31659,23404,29807,25613,23533,23533,23533,21485,21485,21485,21485,21485,19405,19405,19405,19405,19405,21485,21485,255},
{1173,1173,1173,1238,1237,1205,1173,1141,1141,1141,1205,1173,1205,1173,1140,1140,1140,1140,1173,1140,1108,1108,1108,1140,1172,1108,1108,1108,1076,1076,1108,1108,1108,1075,1107,1107,1107,1075,1075,1108,1108,1107,1107,5235,9332,9331,13427,13395,11347,13460,17588,27828,31727,31792,31923,25649,19310,27600,44404,52791,50678,35855,42225,44306,46517,42292,40179,42227,35952,42259,44372,44339,46387,48434,48434,48466,48434,35789,42160,44271,48498,48499,44305,54739,54805,42226,31660,44273,52659,58998,56818,56819,50545,42193,42225,33774,27500,29613,31661,33806,31694,31660,37966,56786,54607,44141,33707,33740,35756,35788,37869,40047,46354,48466,50546,52659,46385,52692,52724,42192,52692,52725,52724,52757,46418,50611,46385,52691,52659,50545,48433,46287,43978,39752,39915,42028,46122,46188,35821,25388,27468,27434,21160,21193,37835,27369,35885,52724,46385,48564,50677,46450,46320,50579,50645,48531,46451,44370,35886,46418,46418,29580,35952,27694,31660,27402,48466,46385,42160,44273,40047,46320,25321,16967,16968,16936,23240,19080,23208,27434,31627,37868,35787,29514,37901,37900,33739,37900,44173,37770,29481,31562,25289,29482,35819,37868,27401,19016,16936,14791,12743,19048,44238,50610,50512,52656,54737,52690,54804,54836,56917,56982,59063,59031,56950,56950,56950,56950,56950,54869,44271,23306,27662,25646,23533,23533,23533,21485,21485,21485,21485,21453,21453,19404,19405,19405,19405,19437,19405,19437,255},
{1173,1141,1173,5334,3286,1205,1173,1173,1141,1173,1205,1173,1205,1173,1140,1140,1140,1140,1173,1140,1108,1108,1108,1108,5269,1108,1108,1108,1108,1108,1108,1108,1108,1108,1107,1107,1075,1075,1075,1107,1108,1108,3155,7316,9332,9364,11054,8812,6796,11054,13135,23569,35888,44437,48599,48631,31826,19213,27599,52758,54838,46418,50611,50710,40146,50678,50678,50645,48564,46484,46452,46419,42226,42193,40047,40047,40046,40144,44273,44272,50546,48498,46418,52692,52758,48630,52757,52725,54805,56918,56852,52593,48531,50644,50612,42192,35886,33774,29580,33806,23307,23275,33708,50447,52494,42093,40014,42094,33740,27467,21097,29547,33773,37933,42062,31563,35724,39917,42094,46288,50481,52594,52626,52659,44240,52659,50579,50644,52692,50610,50513,48237,41768,35592,33706,46057,46056,35723,29548,29581,29548,27434,19080,21193,27434,23209,42192,52725,46418,48499,50644,44207,39817,35788,38032,50644,50677,42225,40112,46419,46451,33871,40145,36081,31596,19016,44305,42193,35854,35853,35853,44305,27467,19080,21128,19048,21160,14887,19048,25289,27433,29514,29449,31627,33739,37900,37900,35787,39915,33609,33674,29514,23208,23176,31594,31594,33707,27434,16935,12711,19016,42190,50610,50578,52657,54737,54803,56884,56885,56949,59031,59063,59063,56983,56983,56983,56950,56950,52723,42158,31725,25549,29807,23533,21485,21485,21485,21485,21485,21453,21453,19405,19405,19372,19373,19405,19405,19405,19405,19405,255},
{1173,1173,1173,5334,5334,1205,1173,1173,1141,1173,1205,1205,1205,1173,1140,1140,1140,1140,1173,1140,1108,1140,1108,1140,9397,1108,1140,1108,1108,1108,1108,1108,1108,1108,1075,1107,1107,1075,1107,1107,1107,3156,5236,11412,7284,9299,13070,13005,4618,6698,2440,6634,8747,10859,12939,15020,12907,12907,17100,50710,46419,46418,56885,54838,40178,50645,46419,46452,50613,48532,50613,52726,50613,52725,50645,50645,48563,52758,48532,46386,50644,50612,46386,44338,48597,52856,57017,48564,46451,48532,46386,52724,58998,56919,46484,44338,40112,38031,40079,40047,33741,31628,25355,35853,35788,40014,40014,31660,29515,29613,19049,29515,31595,40014,39980,27369,21064,21096,23144,23176,23177,27370,31531,35756,37902,44143,48368,48433,50513,50480,50448,46058,37575,29416,27400,46024,48400,31726,29580,29581,29580,27466,19144,21160,27434,29547,48596,52758,44338,46418,52725,44141,31529,6890,2795,25550,46419,48499,42192,44338,46418,48531,36049,21615,29483,27435,29581,25388,27565,40079,46418,52724,35885,23241,25321,25321,25321,23176,23208,25353,25289,25321,27401,29482,39948,48432,48368,35787,27304,31497,33642,29482,21128,18983,29449,35787,29514,33707,29514,25353,42125,50512,50511,52559,54738,54770,56884,56916,58997,59030,56983,59063,59063,57015,56983,56950,54836,50609,37932,29612,31856,25581,23500,21452,21485,21485,21485,21453,21453,21453,21420,19373,19372,19372,19372,19372,19405,19372,19405,19405,255},
{1173,1173,1173,5366,5366,1205,1173,1173,1173,1173,1237,1205,1205,1173,1140,1140,1140,1140,1140,1140,1108,1140,1108,3188,9365,1108,1140,1108,1108,1108,1108,1108,1108,1108,1108,1107,1107,1075,1107,1108,3156,3155,9364,11412,9364,9071,10826,17133,6698,10892,4585,10859,13005,12972,10891,10859,10826,8778,10859,40211,44306,48434,50644,46452,52759,52758,50645,48565,48565,48564,46452,48565,50645,48532,48500,48597,50678,56950,52790,46419,44306,50644,50611,44371,50710,57050,59098,56984,54871,52758,50677,44306,35822,35920,50678,44403,40144,31693,29548,27435,35853,33708,29482,27402,23242,37933,35788,27435,33839,25354,19050,35919,37933,46385,52626,46319,29450,33675,40078,33772,27402,25289,23176,21064,16904,14823,23209,39981,46353,54739,52560,43913,31431,23272,29448,46122,52824,31727,29581,29581,29548,25354,19112,19080,27466,35853,52823,52823,44305,44305,50611,37835,17097,2794,714,747,13099,35984,44338,42257,44338,44305,27565,17422,29710,35886,27468,33838,25452,50645,54903,54739,48432,25354,21128,25321,27401,27402,21128,25353,27401,23208,27434,27434,31594,42061,33707,42093,33642,31529,31561,23208,16935,19047,25321,27401,25321,31594,33707,37900,48464,50512,52559,54672,54737,54803,56917,59030,59030,59063,56983,56983,59064,57015,56917,52722,46351,33739,31758,33969,27662,23500,21453,21453,21485,21485,21453,19372,19372,21421,21420,19340,19340,19372,19372,19373,19372,17324,17324,17324,255},
{1173,1173,1173,5366,5366,1205,1173,1173,1173,1205,3285,1205,1205,1173,1141,1140,1140,1140,1173,1140,1108,1140,1140,3188,5236,1108,1140,1108,1108,1108,1108,1108,1108,1108,1108,1108,1108,1075,1107,3188,3156,7284,13460,7284,9332,19408,17165,8811,4553,2505,2504,4553,6634,8714,10827,10859,12940,15020,17101,15020,14987,17067,44404,56985,59098,59097,57049,57049,57017,57017,54936,54904,54871,50710,50644,40145,46484,54838,46452,48597,46484,44306,44273,46451,50677,50645,59097,59097,59097,57017,56984,31662,10728,31759,52757,42257,38064,29548,27467,35919,42127,31627,37999,29613,33707,44239,31595,29516,44404,44239,29515,33741,44239,52659,54772,52626,35821,46352,61111,58965,54770,50642,48563,44271,33707,21096,21096,35821,42192,46352,46156,41832,29480,23304,33576,48137,48368,37934,29581,27501,29548,23305,19112,21160,23208,38031,54936,54872,48498,48400,46386,25418,17194,8874,2730,811,812,2925,19373,42225,46451,44338,40145,33936,31758,29612,38097,40144,37933,46419,52659,52658,37933,21128,19048,19016,23241,25289,21128,25289,27433,25321,25321,23240,33772,46319,42061,50415,35754,31561,33609,29449,23208,25288,31594,21128,23241,27401,33674,33706,44206,54738,54738,52657,54803,56917,59030,59063,59063,57015,56983,56983,56983,56917,50576,46318,33739,35984,31888,27694,25614,23501,21453,21452,21485,21485,21452,19340,19308,21388,21388,19308,19340,19372,19372,19405,17324,17324,17324,17324,255},
{1173,1173,1173,5366,3318,1237,1205,1173,1173,1205,1205,1205,1205,1173,1141,1140,1173,1173,1173,1140,1108,1140,1140,1140,1140,1108,1140,1108,1108,1108,1108,1108,1108,1108,1108,1108,1108,1075,5236,7284,7284,13492,11412,7284,13330,17197,19278,31858,17132,17100,15019,12971,15020,8811,6698,6665,4585,6633,8713,8713,8746,10826,50678,61178,59098,59098,59098,59130,59130,59130,59130,59130,59130,59130,54903,48564,50710,48565,46419,38032,42160,40080,44273,46418,48499,46452,59065,59065,59097,59097,59064,40145,10760,31758,46386,46516,42258,31726,25355,40112,37934,35853,38097,27631,31758,42094,33708,27403,29581,37901,39981,33806,33708,33709,50579,48531,50545,54804,59064,58965,58965,59031,59064,56884,44272,33642,33675,33675,40047,37966,27304,29416,25352,25320,35657,46057,46221,33741,27501,27501,29548,19113,17032,21160,25321,44338,54936,52791,50578,48399,33838,27530,35917,14985,2762,747,876,811,747,10987,42225,42225,42225,35984,27532,44272,46385,42159,33707,40014,37803,33708,27370,19016,19016,21128,21128,27402,33642,27368,25288,29481,29513,29481,44239,42126,48367,48334,39980,27369,25288,31594,31530,29449,27369,23208,29514,33738,37899,48431,52657,52624,52625,54803,56949,58998,59031,56982,59063,59064,56983,56983,54869,52690,40012,33740,40211,33969,23501,23501,23501,21453,21453,21453,21485,21453,19372,23501,33902,27564,19243,19308,19372,19372,19372,17324,17324,17324,17324,17292,255},
{1173,1173,1205,5366,1270,1237,1205,1173,1173,1205,1237,1205,1205,1173,1141,1141,3221,1173,1172,1140,1108,1140,1140,1140,1140,1140,3188,1108,1108,1108,1108,1108,1108,1076,1108,1108,1108,1075,13492,13460,13460,15541,9332,7284,13395,21456,27665,38099,27631,33905,33905,31825,33905,29712,27631,23406,21326,19180,17100,15020,8713,8713,42259,56984,54904,50710,52791,54904,54872,57017,57017,57017,59130,59098,59098,59130,52725,46451,37999,44338,44306,42225,37967,40080,31693,31759,50612,54805,54805,42128,42193,46419,40145,37967,27435,42226,38000,29515,21162,33773,37934,40079,35854,31693,35821,42061,37901,31660,25355,19049,37934,44239,29482,31595,48465,48465,44207,56983,59032,58965,58965,59063,56951,54804,52724,40079,37933,37900,37901,33643,23144,16967,25320,27368,39816,48137,37868,25388,25420,25420,29548,17032,17032,23241,29546,50645,54904,52790,50512,46319,46352,33772,44337,33838,13034,13132,25711,27791,13229,11084,33806,31660,35886,33774,35853,48466,33708,29481,25288,27401,27401,27369,21096,19016,19048,21128,23208,27369,33674,29449,25256,27369,29481,39981,44207,40045,50512,50414,44107,31561,25288,31562,29449,23176,25256,29514,40012,44173,40013,42126,44237,52657,54738,56949,59030,56950,56950,57015,57016,56983,56983,56918,52757,48530,33773,36017,29743,25549,23501,21452,21452,21453,21453,21453,21485,23533,36080,48562,48529,25419,19243,19340,19372,19372,17324,17324,17324,17324,17324,17292,255},
{1173,1173,1205,5366,1238,1237,1205,1173,1173,1205,1205,1205,1205,1173,1141,5269,5269,1141,1141,1140,1108,1140,1140,1140,1108,3188,1140,1108,1108,1108,1108,1108,1108,1108,1108,1108,1108,3156,15541,15540,15541,15541,7284,7284,7284,19441,38131,17164,19180,17133,21293,23374,25487,27567,29712,37967,35854,33774,33807,29646,23373,21292,29646,57016,54903,54903,54903,54903,54871,52823,54871,52758,54871,52758,54903,52758,50613,44305,35951,37999,37967,40047,40080,35887,40080,35984,52724,52757,52692,31661,25355,27468,27468,25355,17033,19049,19081,21161,33708,37966,40014,44240,31596,31660,35821,33708,35821,37934,29515,16969,31661,48465,23241,31562,37934,46288,40111,59097,58998,58998,58998,59096,56918,54772,52724,50644,52725,42127,31594,29514,25321,16968,25288,29416,33511,46057,35820,27468,29581,27533,29548,17000,19112,25353,33740,50612,50644,54806,48432,40079,35851,29546,50645,54903,48629,44436,46386,50611,40209,33871,27467,31693,35919,29613,40047,40046,23208,31627,25354,19080,29514,25288,21128,23208,19048,21128,25353,31594,31594,35754,27401,23176,29546,31595,35788,48464,48334,39882,37834,39980,31594,27369,27368,29481,33674,27369,35755,42125,35786,35818,52625,56851,56884,59030,56982,54869,56983,57016,57015,57015,56983,50610,44435,33904,27565,27630,23468,21420,21420,21420,21453,21485,21485,21453,21453,38128,54869,50675,38063,21356,21388,19340,19372,17324,17324,17324,17324,17324,17324,17292,255},
{1173,1173,1237,5366,3318,1238,1205,1173,1173,1205,1205,1205,1205,1173,1141,7349,5269,1141,1141,1141,1108,1140,1140,1140,1108,1140,1140,1108,1108,1108,1140,1108,1108,1108,1108,1108,1108,3188,15541,15541,15541,13492,5236,7284,9299,9071,44437,38099,29744,19244,19245,29777,27632,25519,25518,40014,33577,29515,31563,29483,31531,31596,33709,54871,56951,54871,56951,56951,54871,54871,54903,56951,56952,54871,52725,44273,42193,40112,44273,38000,40080,40080,38032,40112,35887,38065,56983,54902,44240,33741,21194,27468,29548,25387,21194,14888,19113,23274,42127,44239,35789,35821,33740,40112,40113,31693,31596,27435,21097,16968,29547,44239,29482,40013,42160,42160,46450,59031,58998,58998,58998,59031,56885,52692,54805,40113,50611,33708,25385,31626,29482,19016,25257,27368,43944,46188,33741,29581,31726,29581,27532,17064,14952,25321,40014,46450,46352,50480,46385,40144,27530,44369,52790,54838,54870,52823,50611,46483,46483,35919,23275,29580,35918,35919,37933,29545,25321,27435,21194,21128,29514,33641,29449,16935,23208,25353,27466,31594,31562,33707,29481,25288,33707,31594,31626,48399,44173,29481,37867,35755,37899,35754,39947,35754,37834,31561,37867,44173,42060,52656,56851,56883,58998,56950,56949,56982,56983,56983,56983,56950,50578,46418,40276,29710,25517,25581,23500,21420,21420,21452,21453,21485,21485,21453,19404,33967,52723,40144,36147,25679,19372,19372,19372,17324,17324,17324,17324,17324,17292,17292,255},
{1173,1173,3286,7414,9494,1237,1205,1173,1173,1205,1205,1205,1205,1173,1141,3221,3221,1173,1141,1173,1108,1141,1141,3189,1140,1140,1140,1140,1108,1108,1140,1108,1108,1108,3156,1108,1108,5236,15541,15541,15541,13460,5236,5236,9267,15312,36084,27632,27632,27599,27599,40212,36018,35986,42258,46288,37803,31563,31563,23242,19017,21097,23178,29451,37903,50678,52726,50581,50613,52758,54903,56919,56919,50612,37967,29548,29548,44305,44338,29548,29548,25387,29548,40113,29613,35887,54805,50579,31661,29581,27500,31661,33740,33740,23306,19081,23307,29547,40013,46385,33806,27435,31693,46484,44306,42258,40178,38032,31727,25388,33741,37901,27369,37933,42192,42225,52725,44240,50514,56820,56885,58998,56918,52725,50611,37999,46353,29578,29578,23240,23209,23209,31659,27401,44009,46253,29581,29581,33839,27533,27500,17064,14952,21160,44305,50578,46352,42193,35887,33805,33804,59064,50710,50611,54903,52758,48563,48597,44338,31661,21162,35886,42225,44338,37932,31690,33838,29546,29481,25289,29449,41995,31529,29481,29449,31561,27433,25321,21128,31594,35787,25288,27433,31593,44206,50447,39947,31561,42060,42061,42027,37867,35754,37770,37834,48300,50478,42059,52558,56850,56884,58998,56950,56917,56918,56918,56950,56950,54837,54869,48496,42257,38195,27694,23468,23501,21452,21452,21452,21452,21453,21485,21453,23566,23566,36015,44303,38162,36180,21485,19372,19372,17292,17324,17324,17324,17324,17292,17292,17292,255},
{1173,1173,3286,7414,7414,1237,1205,1173,1173,1205,1205,1205,1205,1173,1141,1173,1173,1173,1141,3221,1140,1141,1140,7317,3188,1140,1140,1140,1108,1140,1140,1140,1108,1108,1108,1108,1108,9364,15541,15541,15541,9364,5236,7284,7284,11412,13459,13362,17523,21619,23666,27730,33905,27632,40178,46386,33577,31530,29450,25323,16969,16937,14857,14857,19017,35952,42096,46386,46321,48467,46452,42258,52660,50547,42193,33774,35821,48433,52725,35886,40079,29581,25355,35918,38032,31693,40079,44272,33806,44304,48597,42192,35821,35788,35788,35820,33708,37901,46319,44240,42258,33839,29613,50612,44306,40112,38032,38000,38032,37999,31693,27435,27402,29483,33676,37902,42095,27402,37933,33675,35755,31531,46354,54806,50644,46418,44207,27433,25450,19080,16935,19015,25417,29448,43944,42061,29549,27533,33839,27500,27499,19112,14984,19112,44338,46352,46384,48564,40144,29579,38030,57017,42161,46353,52724,48432,48531,50678,42258,33774,31499,39982,48531,48498,42158,42092,44304,48497,42093,39882,39980,35853,25289,37802,35721,31594,31594,27433,21128,23208,27401,27368,29513,40013,46286,46319,33642,37867,29481,29449,33674,40013,31561,35689,39882,44075,44140,48398,56850,58964,58998,56949,56917,56917,54837,54804,50577,54836,54869,54804,46383,40210,34001,25549,23468,21420,21452,21452,21453,21453,21452,19404,21485,27792,34034,33903,40243,40341,25679,21485,19372,19372,19372,19372,17324,17324,17324,17292,17292,17292,255},
{1173,1173,5366,7414,7414,1237,1205,1173,1173,3253,1205,1205,1173,1173,1173,3221,1173,3221,1141,3221,1140,1141,1140,5269,1140,3188,3188,1140,1140,1140,1140,1140,1108,1108,3188,1108,1108,9364,13492,15541,13492,7316,5236,7284,7284,9364,11412,13492,17620,17620,17588,31988,50645,33840,42225,44306,37801,33642,31562,29482,29417,29450,29450,29418,27369,42226,54839,56919,52693,52693,44339,42290,50579,50643,52724,52724,46417,46418,46354,42159,48498,37999,29580,44240,50547,46484,50710,48466,48466,48498,50612,40047,29548,29516,27467,27435,27435,35853,42159,42127,40210,44469,40144,46418,52758,40112,44274,44338,44306,44305,42192,40046,37933,35788,31595,21097,23177,27370,48465,46385,48465,27434,48531,52757,52692,52626,33739,25417,25450,19144,16935,16968,23305,29416,41864,37868,27501,35887,38000,27500,27500,19112,14919,21192,44273,44272,44305,44241,50545,25353,37934,44339,25355,33709,44273,33741,42225,48564,27630,19212,18984,40079,50611,46352,42093,44172,39948,50512,50413,46187,52560,44240,27401,35722,35722,25320,23208,23273,19047,25321,29514,27433,40045,39981,44272,35820,33706,33707,25353,27433,27433,40011,50445,35721,29449,29448,48398,56850,52559,56850,56917,56916,56917,54837,54837,52724,52691,56918,56918,52657,40045,35984,27662,23500,21420,21452,21452,21453,21485,21453,21485,25678,31953,38260,42421,42389,40276,31954,21486,21453,19372,19372,19372,17324,17324,17324,17324,17324,15244,15244,255},
{1205,1173,5366,5366,7414,1238,1205,1205,1205,5333,3253,1205,3221,3221,3221,5269,5269,5269,1141,3221,1140,1141,1140,5269,1140,5269,3188,1140,1108,3188,1140,1140,1108,1108,3188,1140,3156,9364,11444,11444,7284,7316,7316,7284,7284,9364,11412,13492,17588,17588,17588,36181,52758,48532,46387,48497,58765,48366,50446,48366,46219,46220,42027,39915,37835,31595,46418,54806,56919,52661,44306,50677,52757,52823,52791,52790,52757,50611,40014,31628,31661,33741,40112,50480,48205,54904,57017,48597,40144,50579,52660,33741,23242,23275,23242,21162,21162,29515,44240,40047,37999,42291,37966,50612,48532,31693,29613,33774,35919,35886,37999,42192,44273,44240,44240,33773,25322,35886,52659,52691,54740,50579,52725,50644,42192,40046,27529,27562,27530,21257,17032,19080,21192,31496,41962,35853,27500,40177,35920,27501,27500,17000,14887,21192,44338,44272,44338,35919,37933,31758,29547,38031,38097,29613,29580,16968,33839,44306,19276,19243,29546,44239,50579,48465,42092,48399,50512,50479,48300,46187,39883,35690,35689,37834,27401,25320,19047,23273,23240,29481,25288,27465,35819,31659,52724,42158,35819,31626,29513,44173,33674,37834,52427,37866,29481,39947,56850,52592,50511,56917,52723,54804,56982,54869,56917,56950,54836,54837,54837,52624,40044,31758,25549,23501,21420,21420,21452,21452,21453,21485,29872,40373,40341,48696,46583,42389,44535,27792,21453,19372,19372,19372,19372,17324,17292,17292,17324,17324,17292,15244,255},
{1205,1205,3286,7414,5366,1238,1205,1205,1173,7381,5301,1237,3221,3221,5269,5269,7317,5301,1141,5269,1140,1141,3189,5269,1140,5269,3188,1140,1108,3188,3188,1140,1140,1140,1140,1140,5236,5268,5268,5236,5268,5236,7316,7284,5236,9364,11412,15540,17589,17588,17588,36214,52791,50612,42226,48367,56654,54639,56719,52526,54541,56686,56686,56718,54638,44173,50544,35853,29581,29581,44371,56984,56951,52790,50677,50645,52758,48498,44273,29580,27467,35821,46353,54773,50579,57049,54904,54904,44241,42226,35854,23243,16969,19049,16969,16937,16937,29580,42192,27435,29515,33806,46451,50677,46419,44338,42258,40145,42225,38031,33838,33806,35919,31693,31628,29548,33741,50677,52659,52692,52724,52692,52725,50644,50611,35820,29610,27530,23337,21289,19144,19112,23240,33543,41996,31693,29613,46484,33807,27468,27500,17032,14919,21225,44338,44272,46351,50611,48431,42224,31595,44273,54805,52758,42356,27565,40145,44436,21324,29677,40079,44272,50579,50546,52592,50512,39948,33609,31464,33576,25223,23111,39882,37866,29546,25353,21128,29481,29481,25288,25353,29546,33706,35820,40046,37932,40013,40044,33738,50479,46220,33640,31625,31657,42091,56883,56916,54737,56916,58998,54803,59031,56983,56950,56982,56950,54837,54804,54803,48431,40110,29743,23468,23500,21420,21420,21452,21452,21485,27791,34099,34066,40341,46551,46583,46583,40373,25679,19405,19372,19372,19372,19372,17324,17292,17324,17324,17324,17292,15244,255},
{1205,1205,5366,9462,5366,1206,1205,1173,3253,7381,5333,5333,7349,7317,5269,5269,7349,5301,1173,5269,1141,1141,3189,3221,1140,1140,1140,1140,1140,1140,1140,1140,1108,1140,3188,3188,5268,3188,3220,3220,3220,5268,5268,5236,5236,9364,11412,15540,17621,17621,17588,36214,54871,40210,42258,50413,52526,48334,52592,42062,33643,33675,37803,37803,48301,52526,48334,31660,31693,37967,48630,54871,54838,54773,46418,44305,42160,40047,46418,46385,46353,40047,46451,48597,54871,52724,52790,50580,35821,35952,25420,25453,23340,23308,21227,19082,19049,25355,42192,29515,29483,29548,48532,54871,35951,33806,35919,35854,40048,42193,42192,42225,46386,44305,40080,27500,25355,50612,52626,52692,52692,52725,48531,44240,31628,29547,25353,23305,23401,21289,19144,19112,29448,37736,39948,29548,31726,42193,31694,27468,27500,21192,16999,19080,44240,48432,44270,42190,46351,27466,31626,35853,48498,54903,54904,48531,44403,40275,29645,29515,31628,46320,50578,50578,48334,37803,39914,46187,44074,48267,48267,46220,50380,41995,27465,21160,21096,23208,23208,21160,25385,27433,23208,23273,27498,29513,35786,48398,50511,52525,54539,50444,37898,44204,58964,56916,54770,56884,58998,56949,56982,59063,54869,56950,56950,54837,56917,54836,50610,48563,42356,27630,21355,21388,21420,19372,21452,21452,27792,36179,34099,27760,42421,52890,52922,50809,29841,21518,19437,19404,19372,19372,19372,17324,17292,17292,17324,17324,15244,15244,255},
{1205,3253,7414,9462,5366,1205,1205,1205,3253,7349,7381,7349,7349,7317,7317,3221,7349,5301,1173,5269,3189,1141,3221,3189,1141,1140,1140,1140,1140,3188,1140,1140,1140,1108,3188,5236,7316,3188,3220,3220,1172,3220,3188,5268,5236,7316,11412,15540,17620,17621,17588,25844,38164,36050,44305,60845,54671,54672,52624,48333,44173,39980,37868,35756,40078,46319,37835,25322,40047,44306,50645,56983,50612,48499,46386,44273,40014,46386,44273,42127,40047,37934,46386,44338,48467,48466,48532,46354,33773,48565,31792,38065,33872,31758,29614,25420,23307,31726,42160,33740,29515,31596,46419,54871,44371,44338,42225,38032,33839,33838,31725,31725,33806,35886,33773,35854,38065,50579,52692,52692,52692,52724,42126,39948,27368,25386,21160,21192,25481,27562,25385,25353,27271,35624,39948,29581,33839,33773,29581,21162,27500,23273,23272,21192,46418,50578,48431,44238,46286,37932,40012,33739,33771,50677,50710,46419,42192,48662,40014,46254,40046,40013,48465,46320,39882,48267,52427,46186,39979,35786,39980,39979,35753,29481,27401,21095,21128,23240,25386,23241,21160,27433,40079,44272,37900,37932,42093,44172,52525,44074,48332,56784,54769,56916,58964,56851,54803,56917,56917,56949,56983,56950,56950,56950,54869,54837,56949,54836,50611,48663,29743,21291,21355,19340,19372,19372,19372,21485,34098,34098,34066,31953,46615,55003,52922,40373,23599,19405,19405,19404,19372,19404,17324,17292,17292,17292,17324,17324,15244,15244,255},
{1173,5302,7414,9462,5366,1205,1205,1205,3253,7381,9430,9397,9365,9397,9365,7317,9397,7349,1173,5269,5269,3221,3221,3189,1140,1140,1140,1140,1140,3188,3188,1140,1140,1108,3188,5236,5268,3188,5268,3220,5268,3220,3188,5236,5268,7316,13492,15540,17621,17621,17588,19668,15410,13036,31725,54573,54638,56719,54639,56621,58733,56718,56718,54638,42159,42258,38033,31759,50677,46451,50612,48466,37935,33872,33807,31629,35919,40081,42258,38000,35886,44240,40080,37903,31694,31694,31661,35854,33774,50710,48564,50677,54871,52758,50645,46484,42258,42193,42160,27500,25387,25420,29646,46484,40080,44339,46353,42095,40047,42160,44273,44273,42225,40144,35886,33773,50710,52724,52725,52692,52692,46353,39980,35689,31529,23241,19016,25321,21225,21224,27433,25224,29319,37769,39982,27533,37999,35821,29581,23243,27501,27433,21128,23273,46417,50577,50577,46253,35754,44172,40012,40046,40077,54871,50710,46418,46418,48532,46352,44141,35787,42126,35820,39914,48267,52394,42058,40110,42257,33773,35951,40112,33837,25353,23208,23240,25256,21095,21128,25320,23208,40046,37966,33771,42157,52526,39979,39946,37834,42124,52656,58996,58997,56883,56851,56851,54803,54804,56917,59030,56983,56950,56950,54869,54869,54836,54836,54738,48497,42323,29808,19275,19307,19339,19372,19372,19372,29872,36212,38260,34066,38195,50809,50809,38228,25712,21518,19437,19405,19404,17324,17324,17324,17324,17324,17324,17324,15244,15244,15244,255},
{1173,7382,9462,11510,5366,1205,3254,1205,5301,9430,9430,9397,9365,11445,7317,5269,11445,9397,3221,5269,5269,5269,5269,3221,3188,3188,3188,1140,1140,1140,3220,1140,1140,1140,3188,5268,3188,1140,5268,5268,5268,3220,3188,5268,7316,9364,13492,15573,17621,17620,17588,17490,19375,19277,19213,21260,31726,31726,40014,37868,42028,46221,50348,48432,33938,40211,40178,42291,52791,50547,46418,40112,33774,29548,29548,25355,23242,21162,25356,16936,31693,48531,46451,40112,29581,25388,27436,46451,50677,52758,44306,54904,54936,54904,52758,46451,44306,48499,38032,27468,23339,19244,27663,44403,42192,48498,48465,37834,35690,29417,27337,29450,29483,29483,25322,25322,46386,52691,52725,52692,50579,40046,37899,27368,25288,23273,25321,31530,19015,21160,27401,27336,33544,37835,37967,29581,37935,33708,33774,25388,27468,25321,16999,19079,44272,50578,50545,46252,37867,46187,40046,46319,44205,48499,52790,46385,46386,33773,37836,39915,31627,31562,37899,46187,41993,37866,46417,48531,44305,42225,40080,33806,40080,42257,23273,27336,29416,18983,23176,27433,29546,52757,27498,42158,50479,44140,33770,40011,48365,56817,61044,58997,56850,56850,58997,58998,56950,56884,56949,56982,56950,56983,56950,56950,54869,54869,54803,52689,46450,31758,25614,19275,19307,19339,17291,19339,19372,31985,36212,29905,25679,48696,50776,48728,31986,23599,19437,19405,19404,19372,17324,17324,17324,17324,17324,17324,15244,15244,15244,15244,255},
{1205,9430,9462,9462,5366,1206,3253,3253,5301,11478,9429,9397,9397,9397,7317,5269,11477,9397,7317,7317,7317,5269,5269,5269,3188,5269,5268,3188,1140,3188,3220,3188,1140,1140,5268,7316,1140,3220,7316,3220,3220,3220,1140,5268,7316,9364,15540,17621,17621,17620,17588,17523,36116,29744,25486,23373,23406,21325,42259,31726,25388,27436,25323,40212,38065,42226,40178,35953,42227,44241,48532,38000,35887,40014,40112,35952,44371,40177,35984,31694,37999,33806,37935,35854,37966,42226,35952,48532,46386,54904,54903,54904,56952,56984,54871,52758,52725,50644,40113,27500,25388,21162,14888,38000,46352,48433,46353,44206,42028,37900,35723,31594,23176,23176,23176,31694,48466,52724,52692,52692,42159,39980,31561,37834,29481,21096,27369,33642,25321,25289,27466,27369,39850,42093,35887,31694,37901,37901,33774,25388,27468,21193,14919,16999,42192,44304,46318,42060,37868,40046,33740,42060,42158,44304,50611,21129,33708,44239,31594,37836,35821,33706,50412,37897,31658,46450,44338,37967,31693,29613,31661,35886,37999,37999,44337,25255,25223,21160,23273,23272,31692,46353,37900,48399,39979,29545,35818,54704,58897,58963,58996,56883,54737,56883,59030,59030,58965,56884,56917,59031,56918,54870,56982,56950,56950,56950,54803,50576,40144,27597,19307,19307,17259,17259,17291,17291,17324,25679,29905,27792,27728,46615,46648,38292,25711,21485,19437,19405,19404,19404,17324,17324,17324,17324,17324,15276,15244,15244,15244,15244,255},
{1205,9430,9462,11510,9462,3286,3253,3253,5301,11478,9429,9397,9397,9397,9365,9365,13525,7349,3221,7349,7317,5269,7317,5269,5269,9365,9365,3188,3188,1140,3188,3188,1140,3188,7316,7316,1140,5268,7348,3220,3220,3220,1140,3220,7316,9364,13492,17621,17621,17588,17556,21619,46518,48629,38098,23341,23308,25453,44338,38000,25388,25356,29613,44372,52626,46286,46320,40145,35952,40079,35854,37999,44338,35757,31662,27630,50645,48564,50678,44306,44273,37934,37934,35853,44305,46451,44403,44403,50677,57017,57017,56984,54904,54871,52790,50645,48499,44338,46418,35854,27468,21194,23340,33806,35886,29547,46320,52724,52691,50578,48498,48564,40013,37835,42094,42160,52692,52660,52692,46385,39947,37834,33641,35786,33673,33674,31562,27401,25289,27466,31594,39915,44075,42159,33774,33807,35821,33773,33774,25420,27468,23274,14887,16999,40078,42191,44271,40046,31594,37965,35853,44173,48432,50578,48531,21194,31627,46255,27369,29482,29482,42059,37865,33804,46451,42193,31694,29581,29581,31661,31661,29613,35886,35886,46418,31627,19015,29513,35786,25384,25385,33675,35787,44173,35819,37931,48365,58898,58930,58931,58931,56851,56818,56851,56916,54737,52592,56884,56917,56918,54837,56982,56950,56950,56950,54837,52723,48530,42323,38163,21420,19307,17259,17291,17291,17291,17291,21485,19405,21453,27695,34034,29905,25711,21518,19437,19405,19405,19404,19404,17324,17324,17324,17324,17324,17324,15276,15244,15244,15244,255},
{1205,11510,9462,11510,9462,3286,3253,5301,7349,11478,7381,9429,11445,11445,9365,9397,15574,7349,5269,5269,3221,7317,7317,7317,7317,7317,9365,3220,3221,3220,3220,3188,1140,1140,7316,5268,1140,7349,7316,3220,1172,3220,1140,3220,9364,11444,13525,17621,17621,17588,17523,27860,50678,50678,19180,4585,17100,14922,21195,25356,21228,27501,33806,40113,46386,46354,42127,42192,44436,44337,37966,35854,35920,27371,35920,38163,42257,38032,46419,52725,52758,40080,40014,44272,54805,46450,46417,46418,52790,59065,54904,54871,56984,54871,56951,56918,44339,44371,44338,38032,33807,27467,38032,46418,48465,31693,42192,56918,56950,59031,56983,59063,56917,50479,48465,37966,50579,52660,50547,35820,35754,37866,35721,35754,39979,44172,29481,21096,25256,31562,35820,48301,46253,42225,29613,35887,27434,23273,31661,25388,27501,23274,14887,14951,35918,42159,35820,39982,35754,42158,46318,46220,52625,48465,38000,21194,39981,33740,25321,25353,37866,35785,31658,46418,40113,29581,27501,29613,29613,31694,31726,31694,31693,35854,42193,37998,23240,33674,35753,31626,27400,31593,33706,37900,33673,52591,56784,58865,58930,58898,56818,46285,50511,56949,54803,44204,52657,56950,54836,54837,52756,56950,56917,56917,56949,54804,50675,50776,46583,42422,23566,19340,17291,17291,17291,17291,17291,19437,17292,17130,23437,25679,21453,21485,19437,19405,19405,17356,17356,19372,17324,17324,17324,17324,17324,17324,17324,15244,15244,15244,255},
{3253,13558,13558,13558,11510,5334,7350,7350,9398,13558,9430,9429,11445,11445,11445,9397,11477,9397,7349,5269,5269,7317,7349,5269,5269,5269,7317,7317,5269,5269,5269,3220,3188,3220,7316,1172,1172,5300,5268,5268,5268,1172,1140,3188,7316,13492,15573,17621,17621,17556,17458,40309,54904,44372,6633,6633,15052,12874,14889,12809,12841,17002,25453,25291,19115,21228,25453,27566,44241,44305,44305,44208,33774,31726,50743,54969,52823,46549,48597,50644,57049,50678,37934,46417,54871,48563,48562,48531,52791,46354,52725,50644,50547,52692,48499,56918,48564,50644,40145,35887,33806,35918,40079,48465,40145,33708,40080,50546,50546,50546,54739,54771,54771,52560,40046,40079,50579,52659,40014,31626,29513,37866,35884,23240,35786,37834,29481,27369,33642,44108,54705,50446,46286,42225,31661,33774,19080,21193,19146,19114,25420,23306,14855,12839,31724,37965,44337,40079,33674,48399,48333,42059,52658,42225,21129,39980,42060,31627,21192,31593,42058,29577,44337,42161,29581,29581,27501,27501,27468,25420,27501,31694,33806,33774,40079,42159,29449,29513,31625,29513,33738,31690,27465,33673,46219,56719,58865,58898,56817,56785,54703,42091,50479,56949,52592,50511,56917,59030,56918,56950,52756,54837,54836,54836,54837,52690,52789,50809,48728,42389,29905,21485,17324,17291,17291,15243,17324,21485,17195,17033,19275,19372,19404,19405,19404,17356,17324,17356,17356,17324,17324,17324,17324,17324,17324,17324,17324,15244,15244,15244,255},
{5301,13558,13558,13590,11510,7382,5301,7349,9398,13526,7382,9397,11445,9397,9365,11445,9397,9397,7317,11445,11445,9365,9397,7317,3221,5269,7317,7316,5269,7317,7317,3220,5268,9365,7316,3220,3220,7349,5268,5268,7316,3220,1140,3220,9364,13492,15573,17621,17588,17556,19506,42324,38099,31760,23438,27664,29712,27534,23373,21228,17034,10728,21228,21098,12873,12841,10793,10728,23275,33775,25419,17065,21292,50743,54904,54904,54936,57016,56984,52790,57017,56951,50513,50578,52790,54869,56950,56950,56950,46450,52757,46386,46353,46418,40047,52724,56951,52724,42258,37934,44207,54772,48466,42095,35919,29548,44240,50545,50578,42159,50513,46320,44207,42094,46353,42192,48498,48401,35786,35786,33706,31626,33706,37899,33706,35753,29416,33642,39947,50478,52625,48333,46352,42193,31662,27500,12839,19112,23404,23275,25388,23339,14887,12839,29644,37966,33772,42192,35820,42126,44075,46252,54772,44338,23241,44108,31594,23273,27465,40043,31657,42224,44274,29581,27501,27501,29581,40111,42192,35886,23274,27468,33806,33806,37967,44273,29449,27401,35786,31658,40011,27465,23337,37833,54638,56784,58865,58897,56751,46252,48397,42091,52592,56883,52591,56949,59030,59030,56950,59031,56950,56950,56982,56950,54803,52690,54904,52889,46583,46615,31985,21517,17356,15243,15243,15243,17291,19437,17130,17098,17227,17259,17292,19372,17324,17324,17324,17324,17324,17324,17324,17324,17324,17324,17324,17324,17324,15244,15244,15244,255},
{5301,13558,13558,15638,11510,7382,5302,7350,9430,13558,9430,11445,11445,9397,9397,11445,11477,9397,7317,13493,11445,9397,9397,7317,3221,5269,7349,3220,3220,7317,7317,3220,5269,5268,5268,3220,5268,7349,7316,7316,7316,5268,3220,5268,11444,13492,17621,17621,17588,17491,25682,44405,31728,25454,25487,36018,38099,35985,33872,33807,33807,29646,29452,18985,14921,12841,10793,19082,12906,8680,10825,15018,17067,42292,52824,54937,59097,59129,57017,50612,52791,54838,48499,44273,52758,52724,52691,52691,52659,52659,50578,42127,40046,52725,48499,52822,54871,44306,40145,37901,44240,59031,54772,33707,33773,25387,48433,52658,54771,56884,42062,23177,27402,42127,29580,33741,44272,33707,33706,39947,40012,40013,42060,44173,25320,33673,31496,35689,48301,48334,48334,46188,46352,37967,31694,21226,14887,17000,31726,27534,23308,25419,14951,12839,29547,37901,38031,46418,40079,35885,42191,52658,50512,40046,31627,31562,21128,25352,37866,31657,37997,46386,31661,27501,27500,33806,46352,42127,35822,31660,35886,27500,31661,35854,37967,44305,27401,29513,33706,27400,35818,29545,31593,48365,56751,58865,58898,58897,54704,48430,37898,42059,54738,56883,56850,56917,56950,56917,59030,59030,56982,56950,56982,56950,54803,52657,50742,36082,36115,38228,21517,19404,17323,15243,15243,15243,15243,19437,17195,15114,15179,17259,17292,17324,17324,15244,15244,17324,17324,17324,17324,17324,17324,17324,17324,17324,17324,15276,15244,15244,255},
{7350,11510,13558,17686,11510,7382,5301,7349,9429,13558,11478,11445,11445,9365,9365,11445,11477,9397,5269,7317,5269,9397,9397,7317,3221,5269,5269,3220,5269,9365,5269,3220,5269,5268,5268,3220,7317,5301,5268,7316,5268,5268,5268,7316,11444,13492,19669,17621,17588,17459,27730,46485,33873,23406,21326,25518,31792,35920,33840,33807,31727,29614,23211,14856,14954,10728,21195,31694,25550,25518,27598,27566,36050,31792,27566,27534,33840,40113,44307,40080,37934,44241,40080,48531,54870,56950,56983,54902,54903,50612,48466,48498,46385,52725,52692,56918,56918,46418,33839,44207,48401,52659,48466,46352,46385,50644,54772,37934,50579,54772,29612,8582,10695,37934,37934,27434,33706,31593,37866,35818,39947,52527,48398,42093,27465,31593,31561,33609,39882,44141,48366,42060,44240,33774,31726,17064,14919,16968,33806,38131,23307,25452,17032,12839,25353,29547,38031,46352,37998,46418,48532,52659,48301,44075,39980,23241,21160,35818,35785,31723,46386,31662,25388,25388,35886,44304,33774,29548,29580,31661,33806,33838,27468,35854,37966,44305,29513,31561,31593,35721,35818,31657,42059,50479,52559,56785,58865,58897,52591,42091,39978,48365,56884,56884,58997,54803,50511,56917,59030,56950,56950,56982,56982,56950,54803,48463,46451,29711,27727,21453,17291,15211,15243,15243,15243,15211,15211,15211,15147,15147,15179,15211,17291,17324,15276,15243,15243,15244,15244,15276,15276,17324,17324,17324,17324,17324,17324,17324,15244,15244,255},
{7382,11510,13558,17686,13558,7382,7349,7349,11478,15606,11478,11445,11445,9397,9365,11477,11477,7349,5301,7349,5269,7349,9397,9397,3221,5269,5269,3220,7317,7317,5269,5268,5269,5268,5268,5268,7349,5268,5268,5268,5268,3220,5268,7316,11412,15541,19701,19669,17588,15378,36116,46485,35985,29680,29712,35985,42324,44404,38098,31759,29614,25421,19115,19180,17067,10793,19147,44339,52791,52823,38000,29614,44437,38099,29712,27500,37967,33773,40145,37999,29483,29613,25387,50644,56950,56983,56984,56983,56983,50677,40047,46321,48434,46354,52725,50644,54838,40145,29614,50383,50579,56885,54838,54773,52790,54871,52658,42158,44239,46385,40079,27498,10695,31693,40079,33771,35786,37866,39979,31594,33674,44140,48399,42125,31626,31593,29448,39980,41995,42027,48301,44141,40079,31661,27499,14952,14887,14919,29645,33775,23307,27533,17032,12839,23305,25354,35983,48399,37965,40112,44306,48366,46253,42060,31594,21128,27497,33738,29578,46418,35887,27501,27501,37999,42160,31661,27500,27500,29613,31693,33774,35919,27500,33774,37998,44305,35754,35818,37898,39914,31625,35850,37899,39946,46187,54605,48300,54671,54704,52656,48364,52657,58965,56884,56917,56917,52723,56949,59030,59031,56983,56950,56950,56917,52690,44270,33870,23468,15146,17259,17291,15178,15210,15211,15211,13163,15211,15179,13131,15179,15211,15211,15243,15244,15243,15211,15211,15243,15244,15244,15244,15276,15276,17324,17324,17324,17324,17324,15244,15244,255},
{11478,13558,15638,17686,11510,9430,9430,11478,11478,13526,11478,13494,11445,11445,9397,13526,11477,7349,5301,9397,5269,7349,11445,7349,5269,7317,7317,3221,7317,7317,7317,5269,7317,3220,7317,7316,9397,5268,5268,7316,5268,3220,5268,7316,11444,15573,19701,19669,19604,17393,31792,52791,48630,40178,35984,42291,56952,59031,42194,27566,25420,25486,17034,19148,19180,12841,19147,48566,50710,50646,42226,40080,44436,40243,36017,31726,42159,38032,42324,42225,31693,46451,48563,54838,56950,56951,56984,57016,52790,46517,31662,27469,21195,29646,44306,52692,52724,48466,38032,54772,52692,54739,54773,50579,52758,54838,50447,54640,54640,54705,54705,37932,12807,17034,31628,37899,33641,40012,31626,29514,31561,50446,52624,39980,25352,33673,33609,37867,39915,33609,44074,44206,37935,29581,19113,14887,14887,14855,27533,27469,23275,27501,19145,12839,23338,31660,44272,46352,46352,50546,44272,48301,42093,33706,21128,33706,29577,25385,44272,38000,27501,27501,35919,44305,29581,27468,25420,27501,31694,31726,33774,35887,29580,33773,37966,44272,33673,35786,44139,37801,31593,40076,39978,50412,48266,52524,52557,54671,48365,44140,48397,56949,56884,56917,59030,58997,59031,59031,56983,56983,56950,56917,54837,50609,44270,44403,27695,17194,15146,15178,15211,13130,13162,13163,13163,13131,13131,13131,13131,13163,15211,15211,15243,15243,15243,13163,13163,13163,13163,13195,15244,15244,15244,15244,15276,15276,15276,15276,15276,15244,255},
{13558,13558,15638,19766,11510,9430,9430,11478,11478,13558,11478,13525,13493,11445,9397,11477,13525,7349,3253,7349,5269,7349,11445,9397,7317,7317,5269,3221,5269,7317,7317,7317,7349,5268,7317,7317,11445,7316,5268,7316,7316,7316,7348,9396,13492,17621,19669,19669,19572,27763,38099,46517,50710,56984,48629,46485,46355,42161,31727,33904,27598,25454,19147,21260,21228,19179,23308,40179,50743,48565,46483,50676,52822,54870,48532,40113,33774,27566,48598,40080,38130,46451,50546,54870,56950,56951,56984,56983,48564,48597,31629,27436,25388,33905,44404,44339,54805,50481,46321,50547,54805,52691,52659,46418,48532,54772,48432,54738,54771,52593,50512,16967,19080,27434,27434,29578,33674,31626,37899,39979,39979,54639,52559,37867,27465,31593,29481,37899,33641,31464,41929,46254,35822,25419,16999,14887,14887,14887,21226,19114,25356,27501,25386,17000,25418,35886,31627,48432,50578,50546,46286,44173,27465,23305,29513,35754,25384,38062,40145,21227,25388,33774,46353,31661,17002,23275,25356,31694,35919,33839,31726,33774,33773,33774,42159,44304,35753,35753,39914,29480,31625,50544,56784,48267,46219,46220,50380,54638,42059,29512,50478,56884,56949,54803,58998,59030,59030,56950,56885,56917,56917,54836,54803,48431,44402,44469,34066,17259,15178,15178,13130,13130,13162,13162,13163,13131,13131,13163,13163,13163,13163,13163,13163,13195,13163,13163,13163,13163,13163,13163,13163,13195,15244,15244,15244,15244,15244,15276,15276,15244,255},
{13558,13558,17686,19767,13558,9430,9430,11478,13526,13558,13526,15574,15574,13493,9397,11477,11478,9397,7349,9397,7349,9397,11477,9397,7349,7317,5269,5269,7349,7349,9365,7317,7317,5269,7317,7316,11445,7348,5268,7316,7348,7316,9364,11444,15541,19669,21749,19669,21619,31857,23471,15052,21326,29680,33873,44339,40146,33904,29679,40211,38131,25486,23308,27533,31662,31629,31661,40048,50548,44339,38000,44305,56950,48499,31693,33969,38065,27501,29646,44372,46517,54903,52692,54870,56917,56951,56951,54838,40113,40146,21130,21162,21163,29646,48564,46451,46386,46385,48401,52659,48401,48434,52627,54741,48498,52626,54739,56852,58998,56852,52625,29513,37899,37867,25417,33804,29546,25352,46318,48365,50446,48333,48366,37867,33706,33673,27400,37931,35754,39817,41994,40014,33741,23305,16967,14887,12807,14887,21226,21260,23308,27501,25419,14919,21193,40144,37998,50513,52691,48367,46254,39948,25353,29545,33706,17031,33804,46418,25453,19180,27500,44272,33742,23275,14856,23275,27435,27401,27466,38032,31791,33840,33806,33773,44272,46352,35721,33641,33641,29481,29577,44205,56719,54605,42059,39881,50444,54638,46284,35785,46187,50413,54738,56916,56884,56982,56917,54836,54836,56950,56917,52723,50609,48463,48662,38163,29840,19404,15178,15178,13130,13130,13130,13130,13131,13130,13130,13131,13131,13163,13163,13163,13163,13163,13163,13163,13163,13163,13163,13163,13163,13163,13163,13195,15244,15244,15244,15276,15276,15276,255},
{13558,13558,15638,19766,15606,11478,11478,11478,13526,13558,13526,15574,15574,13494,9397,11477,13526,11445,9397,9397,7349,9397,11477,7349,5269,7349,5301,7349,7349,7349,7317,7317,7317,9365,9365,9397,11477,9397,7316,7348,7349,7316,9364,11445,19669,27730,23569,27762,34068,38196,33970,25584,23471,17165,6665,6632,14986,29679,29680,40211,38131,29711,27566,27534,27533,27469,31661,40014,42128,35920,35887,46386,56951,46386,38000,33904,46418,35919,33807,48597,48630,54838,54773,52757,46419,44306,38065,33839,29679,29582,19115,19115,12808,23340,44307,42226,42226,46353,54772,59030,48368,46287,44174,44142,44110,42061,44174,46288,52790,42095,37868,27529,37931,33738,33771,31691,27434,42092,52559,52526,48333,33674,42060,29545,31626,35754,31593,31593,37802,44042,39915,25355,29613,25385,17000,14887,12807,12807,25420,29582,25356,27501,25387,14919,17032,46386,46385,50579,50513,46287,48400,27401,25353,37866,19112,23370,46418,33774,23340,25387,42192,35854,25388,23242,27434,35787,23208,25288,21160,33806,35986,33872,33805,33773,44337,46351,37801,35754,37866,35786,37866,50445,56718,54606,37834,50444,56750,56751,46285,35786,37866,37801,44108,52624,54770,56950,56950,54836,54804,56950,56917,52723,52656,46351,42356,27727,19339,19404,15210,13130,13130,13130,13130,11082,11082,11082,13130,13130,13131,13163,13163,13163,11115,13163,13163,13163,13131,13163,13163,13163,13163,13163,13163,13163,15211,15244,15244,15244,15244,15244,255},
{13558,13558,15638,17686,13558,11478,11478,11478,13558,13558,13526,13526,13526,13526,9397,11478,13526,11477,7349,9397,7349,9397,11477,9397,7349,7349,5236,7317,9397,7349,7349,7317,7317,9365,9365,9397,11445,9397,7316,9397,9396,7316,9396,11445,30038,31890,15150,25486,40244,44406,44437,44405,42325,40244,36018,29744,27631,29744,29744,33905,38099,35952,38032,40080,37967,27469,21163,25387,33807,35919,31726,31661,40081,48532,44273,40047,48465,40112,42291,48498,52823,52757,50645,46354,27534,25388,33872,33905,31824,29646,27566,27566,25453,23470,19180,19115,19148,25421,27501,29581,40048,42160,42160,37934,46320,46321,44207,42127,35919,17000,19176,31787,33771,33803,31690,33803,27466,50511,54639,54606,37899,25352,31593,23272,29546,31561,29513,35851,42092,44075,35820,19147,31693,23369,23305,16967,14919,12807,25387,29614,25356,27469,25387,14919,12807,37999,50612,44305,46287,46287,35852,25353,35818,29545,19144,42257,35919,27501,27501,40112,37967,29581,29548,31562,37834,37801,21063,25320,33837,35951,38000,38064,31725,35886,48499,46286,31560,33673,39913,37833,42026,56718,58798,48332,46219,56750,56718,44172,33673,27400,27400,33641,35754,54803,56917,56950,56917,54869,54836,56917,54837,52689,50543,46482,44502,25614,15178,17259,15178,13130,13130,13130,11082,11082,11082,11082,11082,11082,11083,11115,11115,11115,11115,13163,13163,13163,13163,13163,13131,13131,13131,13163,13131,13163,13163,13195,15243,15211,15211,15211,255},
{15606,13590,15638,19766,15638,11478,11478,11478,13558,13558,13526,13526,13526,11477,9397,11478,11478,11478,7349,7349,9397,9397,11445,9397,7349,7349,5268,7349,9397,9397,7349,5301,7317,9397,9365,11445,11445,9397,7316,9397,9396,7316,11444,15541,34101,38131,23536,19277,19311,17166,21326,23406,29680,33873,31728,31760,33873,38099,27567,17067,21228,35855,33709,35855,37968,25421,19082,25355,31564,44272,50579,25356,23308,48597,52757,50643,50578,40178,40081,35789,54838,59063,50613,31630,23373,19147,23308,33840,29712,27566,31727,21292,29647,25453,21260,14954,14922,17067,17034,10728,12809,19148,17066,14920,23242,25323,29548,35887,23306,21161,25418,31723,25417,29611,29610,27562,33707,52526,54606,46220,35786,37899,35786,25417,33738,35721,29480,33674,42027,46219,44206,31693,31693,23401,23401,21256,14919,14887,25387,29614,25388,25420,25387,14920,12807,21161,42160,40113,42159,33675,25321,33738,29545,19111,38063,40112,27501,27501,37999,40080,29581,35820,39947,35689,35721,31496,14822,21128,31594,33773,29581,37966,33741,37967,50611,42060,31626,35721,41961,41994,54606,56751,54638,48333,50445,54606,42027,25288,33706,31626,31625,42157,48463,56950,56983,56949,56917,56918,56918,56950,54836,52689,48529,48663,40276,17259,17258,15178,13130,13130,13130,11082,11082,11082,11082,11082,11082,11082,11082,11083,11115,11115,11115,11115,11083,11083,11115,11083,11083,11115,13163,13131,13163,13163,13163,13163,13131,13131,13163,13163,255},
{17686,15638,15638,19766,15638,11478,11478,11478,13558,13558,13526,13526,13526,11477,11477,11478,13526,11478,7349,7349,7349,9397,13525,9397,7349,9397,7349,9397,9397,9397,7349,7349,9397,11445,9397,11477,11445,9397,7348,9397,9397,7316,11445,17556,23601,36116,44470,42389,36148,31988,29875,23504,17197,6601,4520,6601,6568,27599,23374,12874,17099,31760,19018,21130,21163,14922,12776,29419,33547,48466,48499,29744,25453,46452,59097,59064,59064,42226,27468,29515,54870,54871,38033,23308,21228,21260,31759,33905,29679,33872,31792,23405,29647,19180,19212,19212,14921,17002,19114,14954,12809,14921,23340,33773,21194,14920,19113,23307,25355,21225,31658,27498,25386,27498,29610,25417,42124,54606,54574,40011,35754,44204,42124,23337,31658,37866,33673,27368,39882,48267,48334,35822,31725,25482,23369,19208,17064,12839,23306,29614,25420,21163,27500,19080,12775,12807,27500,38098,27500,16999,31626,31657,25417,33837,42258,27501,27501,33806,42160,29581,29580,35787,39881,31594,27466,29513,25321,19048,21192,31628,25290,33806,31660,40111,50578,35851,33673,35689,41994,46187,52494,44108,33576,39915,35754,31528,31561,31593,33705,46350,54803,56916,56883,56950,56983,56917,56950,56950,56917,56950,54836,52689,48595,48696,34066,17259,15178,15178,13130,13130,13130,11082,11082,11082,11082,11082,11082,11082,11115,11082,11083,11115,11083,11115,11115,11115,11115,11083,11083,11115,11083,11083,13163,13163,13131,11083,11083,13131,13131,13131,255},
{17686,17686,17686,19766,15638,11478,11478,11478,13558,13558,13526,13526,13526,11477,11478,11478,13558,11478,9397,9397,9429,11477,11477,7349,7349,7349,9397,9397,9397,9397,9397,9397,9397,11445,9397,13525,9397,9397,9397,9397,9397,9396,13493,23732,31922,44470,44405,42324,42358,40310,36117,29777,31857,15052,15084,12939,8713,31825,23341,12874,23438,42259,33773,27500,21260,17067,23113,35627,37902,40015,40145,40178,33807,27501,27469,27469,35823,33840,23243,29548,52725,46452,38066,23340,14954,19244,27598,36017,29679,33872,25453,33872,25421,23341,23373,23406,21260,14857,17002,17067,12873,12841,27534,33807,25420,12904,12872,14920,19113,17032,19145,23338,31691,25482,27594,27530,42059,54606,52494,35786,35819,42124,35818,23305,23337,40012,37802,31528,39881,50315,46222,35854,29612,21256,23401,19176,17096,12839,21226,29614,23308,12808,27468,19081,12807,12807,19081,25420,17000,27433,31625,19079,33707,44305,29582,27469,31694,42192,29581,27500,35788,35722,29481,50676,44272,31593,35787,19079,21192,25322,27435,40079,29580,44305,46416,35785,37801,31561,33674,31529,31561,23175,29416,29416,39946,50477,54704,50543,48430,56917,59030,56949,56950,56983,56983,56983,56982,56950,56950,54870,52755,48496,46549,44502,25646,17259,15178,15178,13130,13130,13130,11115,11082,11082,11082,11082,11082,11082,9067,9034,11083,9035,11083,11083,11083,11115,11083,11083,11083,11083,11083,11115,11115,11083,11051,11050,11050,11050,11050,13098,255},
{17686,17686,17686,19767,15638,11478,11478,11478,13558,15606,13526,13526,13526,13525,11477,11478,11478,11478,11477,11477,11477,13525,11477,7349,7349,7349,9397,9397,11445,9397,9397,9397,11445,11445,9397,13525,9397,9397,9397,9397,9397,9396,13493,27892,44502,50744,38131,33937,40244,40244,29745,46550,59097,33970,38130,40211,10794,33905,29614,14986,25486,48532,50480,46320,29647,25356,33450,31467,33774,37902,46419,46286,39979,37867,29482,25289,21161,23308,25290,27467,48597,38131,40244,29614,17067,21260,27566,29679,31792,27599,27566,35985,25486,25550,29679,23341,27567,12776,10696,17002,12840,17001,31662,29646,29614,19113,19177,17064,19177,21258,17161,25483,27498,23369,27594,29642,35851,54639,44172,29513,33706,39979,27498,23337,19144,35852,35722,27368,35722,44043,40013,33774,19113,19144,23401,19176,17064,12871,19113,25388,12808,21260,27501,29645,21193,19081,12775,16935,27465,31658,23304,19144,40144,31694,25388,27468,37966,31661,25356,29580,44107,35689,37933,50579,35852,29513,35819,25353,29579,35854,31693,35918,31660,48531,40110,39945,37801,29480,31625,25288,29416,33641,42092,48365,58831,58832,54737,52592,58997,59030,56950,56950,56982,56950,59031,56950,56950,56950,54869,52757,50609,44304,46582,27759,19372,17259,15210,15210,13162,13130,13162,11114,11082,11082,11082,11082,11082,11082,9034,9034,9035,9034,9035,9035,11083,11083,11083,11083,11083,11083,11083,11083,11083,11083,11050,11050,11050,11018,11018,11050,255},
{17686,17686,17686,21815,15638,11510,11478,9430,13590,15606,11478,13526,13526,13526,11478,11478,13558,11478,13526,11477,11477,13526,11477,9397,7349,7349,9397,11477,11477,9397,11445,11445,11445,11445,11445,13525,9397,9397,9397,9397,11445,9396,13493,27860,44469,52824,46550,48598,46550,40277,38164,40277,46486,40244,40276,38196,21390,29712,27566,19212,23373,33774,35789,33709,21260,27339,31304,27338,31791,31694,29679,39949,37835,48365,44172,37900,31693,29613,27468,27533,40146,40244,36050,27566,19115,19114,27533,25485,29646,31792,25453,35953,23373,29744,33905,25453,23406,14954,10760,14986,14954,17001,31661,29614,29647,29678,27565,23306,27596,29644,19209,21322,21321,23401,23369,21225,40012,52559,35819,21160,31691,37932,23305,21257,25385,37932,31529,27336,31464,31529,37934,29581,14951,19176,21321,19176,17064,12871,19113,27533,19114,27501,29581,40112,37966,27499,19048,21160,23304,19176,19144,35919,33775,27469,27533,31693,33742,23308,23275,37868,46154,39881,46353,48531,40078,31659,29578,27465,44304,35886,37967,33773,33806,50644,37931,42026,29448,35753,37866,37963,42059,50510,54671,56783,60977,58897,52656,52657,56916,59063,59031,59031,56950,56917,56950,56982,56983,56917,54869,54804,48495,38096,27694,17259,19371,17291,15210,15210,13162,13162,11115,11082,11082,11082,11082,9034,9035,9035,9034,9034,9034,9034,9035,9034,9034,9035,9035,9034,11083,11083,11083,11083,11083,11050,11050,11050,11050,8970,8970,8970,255},
{19767,17686,17686,19767,15638,11510,11478,9430,15638,13558,11478,13526,13526,13526,11478,11478,11478,11477,11477,9397,11477,13526,9397,9397,9397,9397,11477,11477,11445,7349,11445,11445,11445,11445,15573,13525,9397,11445,11444,11445,11445,11444,19668,36181,46517,38131,33937,38131,34002,36116,40277,40245,40244,40244,40244,40244,40244,40244,40212,38163,36018,27631,25453,21163,23405,31597,31564,29613,31791,25453,33739,46252,42027,46252,44140,33806,35854,23340,19115,21228,33938,42324,40244,29744,19180,23405,33872,27534,29646,25453,29646,35920,27566,29711,33905,33873,27599,21228,10728,10761,17002,23307,31694,29582,27534,25486,25486,29711,40211,35952,38097,38096,35950,23370,17064,21192,33674,39947,29578,15016,19209,25385,19144,21192,29578,40012,25224,23079,27271,33641,35821,27468,16967,19112,21257,21225,17032,14919,19048,23308,23275,27501,29582,29581,23241,21128,17000,14887,14919,14983,35951,31727,23243,27501,37967,29613,25388,23243,29547,41994,37736,37802,50545,44272,37965,33738,27497,29578,46418,31693,40079,29548,40112,48563,39978,41993,37865,33705,35754,54705,54672,54704,56817,58930,58897,56850,58997,56916,56915,59030,59030,56917,56917,56951,56983,59063,59064,56950,54837,52722,46416,31920,19339,19339,17291,15210,15210,13162,13162,13162,11114,11082,11115,11082,11114,11083,9067,9035,9034,9034,9034,9034,9034,9034,9034,9034,9034,9034,9034,9034,11082,11083,11083,9002,9002,9002,9002,8970,8970,8970,255},
{17719,17686,17686,17718,15638,13558,11478,11510,15638,13558,11478,13526,13526,11478,11478,11478,9430,11477,13526,9397,11477,13526,9397,9397,9429,9397,11477,11445,11477,9397,11445,11445,11445,11445,15573,11477,9397,15573,15541,15540,17588,17588,21684,36181,50744,48663,44404,42356,36051,34003,40277,40245,40277,40277,40244,40244,40244,40244,40212,40212,38132,40179,29614,31759,42324,31694,38000,40113,37999,40080,50478,46090,42028,40079,33773,35887,35854,19147,25420,25421,36083,42291,42292,27664,25519,23438,38131,35887,38032,38065,25518,23373,29711,31727,25420,31727,27566,23340,19180,10696,14921,23307,25420,27501,27501,27534,25453,25421,25486,21260,25454,35953,42259,40146,33903,31725,33773,33707,19176,25514,19241,21289,21289,23337,33771,42093,25224,29319,37672,37802,33773,25387,19112,21224,21192,21257,17032,14951,14920,21227,21195,27469,27534,31726,17033,12839,12807,12807,10726,31757,38033,23275,23275,33774,37967,23275,23308,27435,41995,44041,35656,37867,52691,40143,29578,31658,25417,37997,40113,31661,35886,25420,44338,46383,44106,42025,42025,31592,25288,39915,54606,56784,58897,58930,58930,58963,59029,54672,56818,56949,56884,54836,56950,56950,54869,56983,56950,54870,54836,50576,40176,27727,17259,17291,17259,15211,15210,13162,13162,13162,13130,11114,11114,9067,9067,9067,9035,9035,11083,9035,9034,9035,9034,9034,9035,9034,9034,9034,9034,9034,9034,9034,9002,9002,9002,8970,9002,8970,8970,9002,255},
{19767,17686,17718,17718,15638,13558,11478,11510,15638,13558,13526,15574,13526,13526,13558,9430,9430,11478,11477,11477,11477,11477,9397,9397,13526,11445,11445,11445,11445,9397,11477,11445,11445,13525,15573,9397,9397,13525,11445,11445,11445,13493,15541,34166,50711,44405,42324,44437,36018,38164,42325,38164,42357,40212,40212,40212,42292,40244,40212,38164,38164,46485,21195,38065,46452,40145,33807,37968,37967,40015,48398,46155,44173,46353,35918,35854,40047,33806,37934,27533,38131,42291,27599,36083,27566,21293,38131,35789,44240,42323,42388,44436,46549,40178,38097,40145,35985,27533,19179,21292,19082,25322,23275,21228,19115,27533,31726,27533,25421,25388,21228,21228,21195,29550,36051,40211,46452,44371,40210,40176,38030,37964,37964,35884,44238,44206,39914,44009,46024,44173,31694,25354,21192,21192,21224,21288,12871,14951,14887,27533,25421,25388,29582,29646,25452,12775,12807,12774,23339,38065,21228,21195,27468,35886,27468,23242,27370,35754,46154,46089,39816,39948,50611,44271,33770,31658,25417,44369,31726,29646,23275,27532,46451,44204,44138,44138,42025,37898,37899,42092,42026,46187,50444,54638,56816,58963,58930,54704,54705,56884,56917,56950,56950,54837,54836,56917,56950,54869,54771,46382,36049,23501,17323,15243,15211,15211,13162,13162,13162,11082,11082,11082,11083,9067,9067,9067,9035,11083,11082,11082,9067,9067,9035,9035,9034,9034,9034,9002,9002,9034,9034,9034,9002,9002,8970,8970,8970,8970,9002,11051,255},
{19767,17686,19766,17718,15638,13558,11478,11510,15638,15606,11478,15606,13526,13526,11510,9430,11478,11478,11477,11477,11477,11477,9397,11477,13525,9397,11445,11477,11445,11477,13525,11445,11445,11477,13525,11445,11445,13525,11445,9397,11445,11445,13493,19701,29973,25780,36116,46518,38131,40309,46551,44470,42389,40276,40244,38163,42292,35953,38098,36018,35986,50678,25421,44404,46452,48564,46451,40015,37967,37901,52690,58832,44140,44206,46320,40178,46353,48432,44240,29646,44469,46452,38065,38131,21228,21325,38131,33840,40145,31824,44372,56985,54936,57017,57017,54936,54936,54903,48662,48662,29614,23177,23275,25485,17099,19115,23275,23275,27501,31727,31694,27501,25388,25420,27534,27566,27501,29549,33807,40146,40145,44239,42093,37866,46253,48333,52428,52362,52493,44273,35887,25354,21225,23273,21192,21256,14919,14919,14887,31726,21260,19114,29582,27501,29646,17033,12774,21258,31759,23341,21227,23307,33740,33707,25290,21097,25256,41961,48233,48201,41961,44075,50544,37997,40076,33803,29675,44338,27533,36017,21162,38032,50643,44138,42025,44138,46251,39946,39979,52559,50446,44139,44106,50379,56816,52591,46252,54672,56916,54803,54836,52723,52723,56950,54869,54837,56950,56950,52690,44271,38195,19404,19436,15243,15211,15210,13162,13162,11082,11082,11082,11082,11082,9035,9067,9035,9035,11083,11082,11082,9067,9067,9067,9067,9035,9034,9034,6954,6954,6954,9002,9002,9002,9002,9002,8970,8970,8970,9002,9034,255},
{19767,17718,19767,17718,15638,11510,11478,13558,15638,15606,13526,13558,13526,13526,11510,9462,11478,11478,11477,11478,11477,11477,11477,11477,11477,11445,11477,11477,11445,11445,15606,13525,13493,13525,13525,11477,13525,13525,11477,9397,11445,11444,13493,17621,21749,19539,29842,46551,38163,50776,50743,52823,52791,50711,48597,50710,50711,44404,44469,44437,38131,44437,29581,42258,48564,52758,52791,48499,48466,44371,44371,48399,35788,31595,38032,52790,48433,46254,42127,40177,46517,46484,56984,44372,17067,21260,35985,35985,44338,31824,19147,25388,33807,33873,38033,42259,46420,48597,50678,56984,25420,27402,19179,31694,19179,35953,31759,16937,16970,19082,23275,27501,31694,31727,29614,27501,27566,25453,25388,25388,25388,27436,29548,33708,42127,44206,44239,46384,52757,38032,40145,25354,23337,23337,19080,17031,17032,16999,14887,31726,29679,25421,27469,27534,27469,27566,27565,31726,23308,23307,23308,27468,35819,37802,31497,18951,21063,35721,44106,44074,37833,40011,35915,35883,48397,37996,42224,35952,29613,35953,21161,48532,48432,44138,44106,37800,52526,42189,25287,42027,48333,46219,56784,56783,56751,50477,50477,50510,56917,56917,50577,50610,56983,56982,56950,56950,57015,56917,50543,40111,40276,23598,17323,17323,15243,13162,13130,13130,11082,11082,11082,11082,11114,9067,9067,9034,9067,11083,11082,11115,9067,9067,9067,9067,9035,6986,9034,9034,9034,6954,6954,9002,6954,6954,6922,6922,6922,6922,9002,9002,255},
{19767,17718,19767,17718,13590,11510,11510,13558,17686,15638,13558,13558,13526,13526,13558,11510,11510,11478,11477,11477,13526,13525,13525,13525,11477,9397,11477,11477,11477,13525,15606,13525,13525,13525,13525,11477,13525,13525,13493,11445,11445,11445,15573,19701,21749,19539,29907,44438,33873,50711,50743,50710,48662,48630,48597,48630,50710,44372,46517,46517,38131,44437,54871,54903,50645,54904,48500,46386,46419,46419,44273,50612,48498,46320,50677,54772,35756,23210,40048,44371,44371,46517,52791,38065,35985,31726,31693,29580,29548,25355,19114,25355,27468,21227,27500,25388,25356,19114,17066,29647,19050,33773,23307,19049,12743,21194,35854,29580,29678,23373,17099,17002,19082,25356,29581,29614,29646,31726,29614,29581,27469,25388,25388,25356,25355,25355,35887,54903,40080,44404,42226,23273,23337,23337,19112,21224,21192,16999,16967,31726,31727,29646,23308,27533,25356,25388,25389,21195,21227,25388,27436,29547,42027,46154,44041,27304,21096,23337,33738,37866,33738,29610,29642,35883,50446,33739,46418,33807,35887,27500,29613,50677,37932,42058,46219,35785,35754,52559,42091,54671,54671,44139,52525,58897,58865,56882,54736,54770,54836,54803,56917,56983,59063,56983,56950,56983,56950,54770,42123,42322,36147,23598,15210,15243,15210,13162,13162,13130,11082,11082,11082,9034,9034,9066,9034,9067,9067,11114,11082,11115,9067,9067,9067,9067,9035,6986,9034,9034,9002,6954,6954,6954,6954,6922,6922,6922,6890,6922,8970,8970,255},
{17719,17719,19767,17718,13590,11510,11510,15638,17686,15606,15606,13558,13558,15606,13558,11510,11510,11478,11478,13526,13526,13525,13526,13526,11477,11477,11477,11477,11477,11477,15606,17654,13525,17653,13525,11477,11445,13525,11445,11445,11445,13493,15573,19701,21749,19474,25649,44438,36050,52824,54905,54936,54936,54936,52856,44436,42324,46550,48566,46517,44404,52791,50645,50612,52693,52726,46385,42160,44337,42193,40112,40112,35887,35854,40080,44240,29548,23210,42225,42324,50711,54937,48630,33775,29581,27468,29613,25388,23275,23242,23275,23242,21097,21130,21129,21097,21130,17001,17001,19115,21194,27435,21161,21161,21193,23241,21161,21193,35919,44371,42291,36050,29712,17067,23340,29646,29614,31662,29549,29581,33807,33775,29646,27501,27468,25388,25388,29549,33839,54936,40145,25353,25353,21192,19144,21257,19048,17032,14887,29613,33839,31726,23340,25388,25388,21195,14921,17002,21195,29580,25355,31595,42027,48234,44041,37736,29449,25385,35850,35818,35819,33803,35947,42156,48365,37965,42193,29614,40112,29580,42225,48531,37866,42058,46316,33738,25352,35754,44205,48365,52624,54704,48396,54671,56752,58931,54704,56851,56884,52690,50544,52625,59031,56983,56950,56950,54836,50511,40044,50808,31985,21484,15210,15211,13162,13130,13162,13130,11114,11114,9066,9034,9066,9034,9035,9067,9034,11082,11083,11115,9067,9067,9067,9067,9067,9067,6987,6986,6986,6986,6954,9002,6954,6922,6922,6922,6922,6890,6922,6890,255},
{19767,17718,19767,17719,13590,13558,13558,15638,15638,15638,15606,13558,13526,15606,15606,13558,13558,11510,13526,13558,13526,13526,15606,15574,13525,11477,11477,11477,11477,13525,15573,13525,13525,17654,13525,11477,11477,11445,13525,11445,11445,13493,15573,19701,21717,21619,23470,48630,46549,46550,46549,46550,48597,48630,50678,52856,52856,48565,46419,46418,42193,48532,48565,40113,37967,37968,46321,46353,50482,48465,50546,48433,46320,44240,40079,23372,21292,35887,44305,40211,42259,54904,56952,44371,33807,25421,25421,21227,23275,21163,19114,19114,16969,14889,21227,17001,14888,16969,12776,19114,27435,25355,19049,25354,27434,25354,29579,25386,29547,27467,31628,37967,44339,42324,44372,29582,38033,40113,27598,21227,27436,27468,31629,31694,33774,31726,29581,31727,50710,54936,40145,25354,25418,19144,23305,23273,16935,19080,14919,27467,35920,31694,27533,23307,25421,23308,21227,23276,23307,27500,23275,25322,37801,46121,44041,37736,33641,31626,27465,29513,35819,35915,37995,50478,42092,44304,33806,31694,38000,29581,48564,44270,42026,42026,50412,40011,33706,31561,50478,40012,44172,52559,50446,50413,54703,52558,46252,52624,56884,54803,50609,50544,52690,54869,56950,52756,50609,42157,42258,50776,25678,21484,15243,15210,13162,13130,13130,13130,11114,11115,9066,9067,9066,9034,9067,9034,9034,9067,9067,9067,9067,9067,9067,9099,9067,9067,7019,6987,6987,6986,9002,9002,6954,6954,6922,6922,6922,6889,6890,4842,255},
{19767,17718,19767,17718,13590,13558,13558,15639,15638,15606,15606,15606,15606,15606,15606,13558,13558,13558,13558,13558,13526,13526,17654,15606,13526,13525,13525,11477,11477,13525,13525,13493,15573,17654,13525,11477,11477,11445,13525,11445,11445,11445,15573,19701,23797,21619,23471,42130,56985,50711,44404,46485,50710,48630,48598,50710,50646,42226,44371,50676,46451,37999,50547,29614,31662,29614,27501,27501,25388,23275,35953,50677,46419,40047,50579,44339,42193,46419,46484,42324,44469,54871,54871,44339,38033,29614,27566,29646,29646,27534,27533,25420,27533,25388,27501,25420,21227,19114,19082,14889,21129,19081,16968,27434,33740,33772,35885,31692,23273,25386,25354,29514,25354,25354,33806,29613,44306,40047,48630,33839,19082,17001,19082,19082,21162,21162,23275,29549,35855,48565,42225,23306,21225,25451,21225,19112,16968,14952,12871,23242,33839,27533,25420,19114,23308,23308,23308,21227,21162,23243,21129,16936,29480,44041,46154,42060,29513,29578,27433,29545,33771,35915,40076,46317,37964,44338,29581,37999,33806,33839,50676,46253,42059,39978,39978,42059,31626,25352,37899,35786,46318,48333,44172,42058,52525,54737,50510,52624,52689,50576,54802,52723,54804,54772,52691,52723,54803,44336,42257,40276,19339,17259,15211,13162,13130,11082,11082,11082,11082,11114,9067,9066,9067,9067,9034,9034,9067,9067,9067,9067,9067,9067,9067,9067,9067,9067,9035,6987,9035,9034,9034,9034,6954,9002,6922,6922,6922,4873,4842,2793,255},
{19767,17719,19767,17719,15638,13558,13558,17686,15638,15606,15606,15606,15574,15606,15638,15638,13558,13558,13558,13558,15606,13526,17654,15606,13526,13526,13525,11477,11477,13525,13525,13525,15573,17654,13525,11477,13525,11445,11477,13525,11445,13493,15573,21749,21749,19571,23439,41936,35856,25518,27469,46192,44339,54871,52758,50677,48598,40113,40145,44338,46420,44306,46387,27566,33774,33741,31694,29581,27468,25356,25388,48565,42292,31759,44306,48532,54806,44306,48631,44339,52823,50645,46419,46452,27534,36050,31759,35953,35952,33839,31759,29646,35887,31727,29614,29614,29613,25421,25421,16969,21194,17032,19080,29546,33771,37965,33804,35884,35852,37932,33740,33740,35852,27466,29613,33807,37998,35852,27434,29580,29548,27500,23307,19114,16969,14889,16969,16969,19082,33709,44273,29579,23306,27499,17096,21289,21225,14919,14952,14920,33807,33807,23341,16969,23340,23308,21227,14954,21195,25289,23176,19015,23208,33673,39947,37964,29545,29578,33772,25417,33770,35947,44237,48398,44271,38000,29613,38032,29549,44338,48498,44172,42059,39979,37931,44139,40011,29545,37932,33673,52591,54671,56784,52590,54671,48365,42091,54769,54802,48398,46318,54836,52724,50610,54869,56917,46350,44403,46483,40373,15178,15178,13162,13162,13130,13130,11082,11082,11082,11082,9034,9066,9067,9034,9034,9034,9067,9067,9067,9067,9067,9067,9067,9067,9067,9067,9035,9035,9034,9035,9035,9034,6986,6954,6954,6922,6922,4874,4842,2793,255},
{19767,17719,19767,15670,15638,15638,13558,17686,17686,15606,15606,15606,15606,15606,15606,17686,13558,15606,15606,15606,15606,13526,19734,15606,13525,13526,13526,13525,11477,13525,13525,13525,15573,15606,13525,13525,13525,11445,11445,11477,13493,13493,17621,21749,21684,19571,33938,35727,12874,10858,16937,47979,39983,56918,58966,56918,54870,52791,44371,48597,44371,38001,42291,44437,50677,48532,46419,42194,38000,35887,27501,40146,38066,38130,48564,56918,56918,44372,48631,46517,52791,50645,46387,48532,37968,40146,35953,38000,38033,38033,38033,38033,40145,40113,38000,38000,33839,29614,27534,10695,23307,19081,23370,27466,33739,33837,33804,31724,35884,33771,37997,35852,37932,27499,29581,33806,35820,48433,40077,29546,23241,25353,29547,31628,29515,27435,21227,16969,35887,31629,42127,42159,27498,17064,19144,29643,27532,14920,19080,14887,27500,33872,25421,25356,25421,23308,21227,17002,25322,33673,29416,21095,19080,29577,35851,37964,31658,31691,42223,27498,31722,40108,48430,50511,46417,31694,33807,33774,29548,50677,44238,44139,40011,39979,44172,44172,35818,39979,37932,33706,54704,56752,54638,56751,52590,46285,52624,52591,48430,35818,44238,54837,56950,56982,59063,50609,40011,46450,52823,48728,23565,13130,13130,13130,11082,11082,11050,11082,11082,9034,9034,9067,9067,9035,9034,9034,9035,9034,7019,7019,9067,9067,9067,9067,9067,9067,9035,9035,9034,11083,9035,9034,9034,6954,6986,6954,4906,4874,4842,2793,255},
{19767,19767,19799,17719,15670,15638,13558,17686,17686,15606,15606,15606,15606,15606,17654,17686,15606,17654,15606,15606,15606,15606,19734,15606,13526,15574,13526,13526,13525,15606,13525,13525,15605,15606,13525,15573,15573,11477,11445,11445,13493,13493,17653,21781,19506,21554,31826,35727,6633,4585,14856,45867,29452,40178,50612,54774,54806,52758,46354,38065,46451,46289,52824,61276,61243,61243,59163,59163,59162,50613,35920,46517,38098,42258,52757,56951,52725,36050,46583,52791,54937,50710,46419,42259,31759,29613,27534,27501,29646,31791,29646,29614,31727,31727,31726,35952,33775,29614,25421,10695,17001,17032,29578,25385,31659,29611,31723,37997,29611,29546,35884,37933,33771,27531,27566,29645,29546,35819,37900,31626,29546,33706,29611,25418,29546,27466,29417,29450,33741,33708,40014,44175,23338,19112,23338,29675,38064,21225,19112,17000,21194,35919,27566,25388,25389,25388,23275,19049,18983,37770,23373,10793,25386,40077,42158,42190,37964,31691,44239,35885,37963,44269,54671,48464,42193,29613,35919,21162,33806,50643,44205,44171,42091,37899,39979,42059,42059,48398,48398,54737,56818,52558,52558,54671,54704,52591,54803,54802,44270,39979,48431,50577,52658,52691,54836,50577,40044,42223,46419,50776,23534,13066,13098,11082,11082,11050,11082,11082,9066,9034,9034,9067,9034,9034,9034,9034,6986,6986,7019,7019,7019,7019,9067,9067,9067,9067,9067,9067,9035,9067,9035,9035,9034,9034,9034,9035,4906,4874,2826,2793,255},
{19767,19767,19767,17718,19767,17686,15606,17686,17686,15606,17654,15606,15606,15606,15638,17686,13558,15606,15606,15606,17654,15606,19734,15606,13525,15606,13526,13525,13557,15606,13525,13525,15606,15605,13525,13525,15573,11477,11445,11477,11445,15573,19701,23830,19538,23570,35922,37807,10891,17230,23340,39821,23276,21293,29647,33806,38033,46484,40145,27533,31629,33774,48565,50743,57017,54937,54937,57017,52727,33806,40145,54937,40243,38000,52661,54774,52694,33873,46550,52758,52758,46420,42258,44372,44339,44339,44339,42259,40178,40210,35952,31727,33806,31694,29646,25485,25388,23308,19115,8583,14921,21225,21225,25418,27530,25418,27530,33771,33804,37932,35852,37933,29547,29612,31857,35918,31659,31626,40012,39980,42093,40045,42191,23305,23273,25353,23175,31497,27337,29450,35789,40112,29580,25386,27498,31723,50611,35918,25483,21257,21192,40046,33839,25388,17034,19115,17001,12743,16969,44045,44209,2701,29580,46384,48464,46352,46385,44337,37932,42191,35915,48398,54672,48465,33807,33774,35952,16968,44338,48465,46252,44139,39979,40044,35818,44140,46252,42091,48431,52592,54704,48365,54671,54704,52591,50543,54770,54803,54836,31626,35851,42190,40077,44205,48496,44237,42124,37996,37964,37967,23468,11017,11049,11050,11050,11050,11050,9034,9034,9034,9067,9034,9034,6986,6986,6986,7019,6987,7019,7019,7019,9067,9067,9067,9035,9067,9067,9035,9035,9035,9035,9035,9035,9035,9035,6954,4906,2858,2826,2826,255},
{19767,19767,19799,19799,19767,19767,15638,17686,17686,15606,17686,17654,15606,15606,15638,15638,13558,15606,15606,15606,19734,17654,19734,15606,15606,15606,13526,13525,15574,13525,13525,13525,15605,15605,13525,13557,13525,11477,11477,13525,11445,15573,19701,23829,23797,21586,31696,35823,23568,42357,40244,38132,36051,33906,29614,35984,44405,42291,29777,31825,40145,44306,44339,48629,50710,50710,48629,48565,35919,33774,38064,52824,52791,42226,46321,37935,38000,38065,44436,50645,46419,35855,31726,29646,27501,27435,38032,40179,29549,31694,35887,40113,31694,27533,27468,21195,21195,14921,10695,8583,12807,29643,25450,25417,27563,21322,27562,31723,29675,35884,40012,40013,31659,33806,29614,31660,33706,35819,44239,37900,31626,33804,37997,29578,29513,25385,27400,29384,27337,25257,31595,44339,33872,27532,25449,42190,52560,52658,46418,29611,37932,44239,35887,25388,19082,19082,14921,21292,19081,39950,58705,11347,17262,40046,44304,42158,48531,50644,33771,35851,44237,48365,50479,44305,29581,38032,31726,25387,50677,44206,44140,44140,46285,46318,39979,44140,48398,37866,48399,31593,44204,56817,56817,54704,54672,54704,54770,54803,54771,52690,37931,37932,42158,37932,40044,44270,52690,46383,40143,38161,19307,11017,11050,9002,11050,9002,9002,9034,9034,9034,9034,9034,9067,7019,6986,6986,7019,7019,7019,7019,7019,7019,9067,9035,9035,9035,9035,9035,9067,9067,9035,9035,9035,9035,6987,4906,4906,2858,2826,2826,255},
{19799,19799,19799,21847,17719,17718,15638,17686,17686,15606,17654,15606,15606,15606,15638,15606,13558,15606,15606,15606,21814,17654,19734,15606,17654,15606,13526,13526,15573,13525,13526,13525,15606,15605,13557,13525,13525,13525,13525,13525,13493,17621,21749,23765,21619,17328,25357,44308,42292,33873,40244,40212,38131,36051,40244,46485,38131,46517,33937,29647,40145,40178,46484,52660,52693,44274,44275,46452,46353,44240,44273,54839,56984,54806,52692,48532,50743,57017,54936,48565,42258,38000,42193,42225,40080,37999,40112,40080,31661,29613,29580,31694,12872,27663,17066,10696,8583,6502,6534,8583,23274,33837,27563,25418,35949,27595,23402,27562,29642,31691,37900,37965,29611,38065,29645,27498,42092,44173,39981,31594,29514,31658,29578,40044,35852,27498,25320,27272,27337,23209,31563,42128,40276,31824,42257,42126,46254,37900,33739,37965,44238,42126,31727,27468,23274,16969,21325,33938,19082,29549,46387,9429,21164,27402,38031,31627,44272,44338,27498,40044,48397,42091,46352,37968,29613,42193,29581,40145,50644,42093,44139,39979,48366,37932,33706,37932,39980,46350,56884,42092,50446,56817,56785,56818,54738,52689,54836,52690,52691,48431,48463,46416,48562,44303,50577,52756,50576,40011,40144,48728,19340,11017,11050,11050,9002,9034,9002,9034,9034,9034,9034,7019,7019,6986,7019,7019,7019,7019,7019,7019,7019,7019,7019,6987,6987,6987,6987,9067,9067,9035,9034,9034,9035,6987,6987,6987,4906,4906,4874,2826,255},
{21847,19799,19799,21847,17719,17719,15638,17718,17686,17654,17654,15606,15606,15606,15638,15606,13558,15606,17686,15606,19734,19702,19734,15606,17654,15574,13525,13526,15605,15574,15574,15574,15606,15605,13525,13525,13525,13525,13525,13493,13525,17621,21781,21684,21652,15183,21196,29615,33744,27599,35953,33841,33873,33905,48631,52824,40244,59097,50710,42258,48531,48565,50645,44240,40015,35821,35886,38032,48466,40047,33774,35887,37935,33710,29516,33840,50711,56985,52791,46452,44306,40113,42225,44339,38032,38000,40112,35887,35886,35886,35854,35821,21227,48564,48597,29581,25388,19114,10695,10663,27467,40077,31724,23402,31756,29643,31756,31723,35819,35786,35819,33771,31659,46550,38064,29578,40012,42125,35787,29481,33706,31690,31690,33771,40045,29578,25385,27272,29417,23144,27402,33708,42226,42259,42258,31693,33741,25452,27499,42093,46253,37999,29647,21195,12808,19245,27664,31793,19049,16936,23276,19408,27210,23080,21225,19112,23273,29546,31658,42156,48430,44204,46385,31694,35887,38000,27500,48532,46385,44205,44140,44205,39980,35787,37900,35787,42125,50544,56883,48430,50478,56752,56784,52624,52624,56884,56917,54804,52724,50544,48430,54771,56983,56982,58998,56883,50510,42123,46483,40341,17259,11017,11050,11050,9034,9034,6954,9034,6986,6986,6986,7019,7019,6987,7019,7019,7019,7019,7019,7019,7019,7019,7019,7019,4939,6987,6987,6987,6987,6986,6986,9035,6987,6987,6986,6954,4906,4906,4906,4874,255},
{21847,21847,19799,19799,15670,19767,15638,19734,17686,17686,17686,15606,15606,15606,17686,15638,13558,17686,17686,15606,17654,19734,17654,15606,17654,17654,15573,15606,15606,15573,13525,15605,15606,15605,15605,15573,15573,13525,13525,13493,13525,17621,21782,21716,19539,15215,14954,12842,25357,27567,25519,25519,21326,29711,50678,46550,48598,50646,50646,48565,44404,48564,48500,46386,37934,35821,37967,40145,44274,52757,52692,39982,31595,27371,21162,27566,54904,54904,50710,48532,46353,42192,46418,42225,35854,37967,44338,35919,27468,27436,27436,27468,29548,48532,44307,29548,29580,23275,16937,10727,27498,40045,33772,29676,33836,33836,35915,27529,31690,35819,29578,29610,29644,38033,35950,29578,31594,35787,42158,33706,33771,29578,33803,35851,37964,27498,25353,27272,31530,23111,25257,25322,33709,33774,31727,42291,29580,21193,27532,37933,27370,27501,23406,14889,12841,21326,19115,25388,23275,25322,23145,23178,31728,27241,21193,25385,21160,31659,35883,33770,44237,35917,42193,29581,40080,31694,29613,48564,40012,42093,39981,27337,27401,42060,42125,42092,54770,56851,52624,42124,46285,54671,50478,54738,50544,54770,54803,54803,54803,54737,54770,54869,56983,58998,52657,33674,23208,31725,46484,36147,15179,11050,11050,9034,9034,9002,6954,6986,6986,4938,4939,6986,7019,7019,7019,7019,7019,7019,7019,7019,7019,7019,7019,7019,4939,4939,6986,6986,6986,6986,9035,9035,6986,6986,6986,6954,6954,4906,4906,4906,255},
{21847,21847,19767,19799,15670,19767,17686,19767,19734,17686,19734,15606,15606,15606,17686,15638,15606,17686,17686,17654,17654,21814,17654,15606,15606,17654,17654,17654,15606,15573,15574,15573,15606,15606,15605,15573,15573,13525,13525,13525,15573,17653,21782,17393,8876,17296,14987,8713,23438,21326,19278,19213,23341,42259,40146,52791,52791,50710,48598,44372,35953,42259,52726,50612,46418,44305,46386,44306,46418,56886,56753,39948,31563,27370,25355,36018,33873,31824,40178,42227,44273,50579,46385,46321,46320,46320,37934,21194,16969,14889,12808,12776,21227,38000,29549,29581,27468,23275,12776,12873,21257,37965,35917,35916,38029,33836,31691,27562,37932,27498,27530,29610,33806,38065,33804,33771,27498,31723,42125,35851,29578,27466,31690,37963,31659,23337,21257,23111,29417,23176,23177,16969,31596,46485,31857,38066,48597,19048,27500,31660,14856,17001,19114,14921,14954,14921,19114,21195,23308,31597,33580,25291,29549,27403,23306,14951,21160,31658,37964,33835,29642,42224,31726,31726,37967,27468,35920,46417,37867,33675,29482,16968,19048,37867,31626,35819,52625,48399,54704,54737,54737,40012,46253,52592,46253,58996,58963,58997,56916,54770,54771,54837,56885,48464,46351,40143,31691,33739,38032,25550,17291,11082,11050,9034,9034,9034,6986,6986,6986,6986,6987,6987,7019,7019,7019,7019,7019,7019,7019,7051,7019,7019,7051,7019,4939,4938,4938,6986,6986,6986,6986,6987,6986,6986,6987,4906,4906,4906,4906,4874,255},
{21847,21847,19767,19799,17719,19767,17686,19767,17686,17686,19734,17654,15606,15638,17686,15638,15606,17686,17686,17686,17654,19734,15606,13558,15606,15606,15606,15606,15605,15573,15573,15605,15606,15605,15573,15573,15573,15573,13525,13525,13525,19701,21749,8843,4650,10924,8778,29646,27533,23341,21293,19180,25388,35920,37936,44340,44372,42226,38066,33873,29517,42194,56951,50644,44371,48500,46418,44241,40047,33806,40014,33644,33676,29515,25355,36050,27599,29744,38066,33905,31760,31759,29679,27501,29581,31662,25356,21195,12808,10695,10696,8583,16969,48565,46484,31662,29581,19081,8615,14954,19145,29547,37965,31723,40142,31755,25450,31690,48464,33772,27466,25418,35952,44371,29642,31691,31691,29674,37932,33706,31626,29546,35851,37931,33706,25417,23370,19048,27305,25257,21064,23210,29515,42161,44437,36017,44339,35951,27467,19081,10695,8582,10663,14857,19148,17034,21163,21163,23275,25356,27436,21130,21097,16969,27436,21259,19081,29578,38028,27529,31724,38000,23307,38032,35887,27468,40145,35788,23208,29449,18983,16936,19081,25386,21128,29514,40012,42124,52526,48399,44173,33706,42092,39979,48430,58963,58930,58931,58964,56916,54870,54804,54803,54803,58964,56850,42124,31627,31759,17194,13130,11082,11082,9034,9034,6986,6954,6986,6986,6986,6986,7019,6987,7019,7019,7019,7019,7051,7051,7051,7019,7051,7019,7019,7019,6987,4939,4938,4906,4906,6954,6986,4906,6954,6954,4906,4906,4906,4906,4906,255},
{21847,21847,19799,19799,17719,19767,17686,19767,17686,17686,17686,17654,15606,17686,19734,15606,13558,17686,17686,19734,17686,19734,15606,15606,15606,15606,17686,17654,15574,15574,15605,15605,17654,17653,15573,15573,15573,15573,15573,13525,13525,19701,21749,6795,2634,15182,17165,38065,33742,31662,33710,31662,29549,25388,25355,33807,42193,37968,31694,31694,41868,37903,40211,44306,44339,46353,46354,44274,35919,19147,12842,19050,31597,42095,35790,31792,25486,35985,25453,19147,29712,25486,23374,23373,25454,19180,23243,23308,23307,19081,16969,10695,23275,44372,46452,31661,31629,19017,8615,17067,19244,23405,29581,21225,31691,37996,33739,33706,50545,35852,27465,23338,31759,29677,23337,31658,29546,31691,33739,29514,31627,29546,33771,39979,37867,33771,23369,21193,27369,25289,23144,27402,29515,33741,37935,29549,21162,33742,21129,10695,8582,8550,6502,12776,17001,19050,19082,19082,19082,23307,23340,25356,23210,12841,25421,31858,10728,25387,37963,23304,42192,19114,25388,42225,29581,29614,44273,25192,18983,25256,18983,14823,16936,21162,21162,23274,25386,29547,31594,33706,35786,42091,33706,50510,58930,56784,58931,56818,56883,59063,56983,56917,58998,58997,56851,46284,40110,33871,25549,15146,13130,11082,11082,9034,9034,6986,6954,4938,4938,4939,4938,6986,7019,7019,7019,7019,7051,7019,7019,7051,7051,7019,7019,7019,7019,4939,4938,4938,2890,4906,4906,4906,4906,4906,4906,4906,4906,4906,4906,4874,255},
{23895,23895,21847,19799,17719,19767,17719,19766,17686,17686,17686,17654,15638,17686,19734,15638,13558,17686,17686,19734,19734,17686,15606,15606,15606,15606,17654,17686,15573,15573,13557,15606,15606,17654,15605,15605,15573,15573,13525,13525,15573,19701,23829,11021,8940,13069,6698,48532,35888,12841,14922,19082,21163,25356,38000,40080,42193,40080,35855,42128,50253,44177,21292,29581,35854,33774,40113,36018,35985,23276,23373,21228,21130,23210,21195,33872,42258,40112,31758,29646,29614,21292,21228,25453,25453,23308,27338,25323,35886,33773,33741,12808,21227,31694,23243,21129,23178,19017,17034,12906,19180,12939,21326,29712,27598,31659,27401,31594,42094,35787,31690,31725,27533,27531,29578,42125,42125,33771,31659,29514,33707,25353,29610,31691,31626,31658,19177,21225,27402,29450,25257,29483,27403,29548,27468,19082,19049,21162,25388,10662,8614,10695,10695,14888,14856,12743,10695,16969,21162,21195,27468,33872,25453,21195,25388,21260,19278,29612,31657,21289,42225,23242,31694,38000,25388,35920,31564,25160,23209,16903,16935,16935,23208,21128,16903,16935,19049,16968,23241,33738,50445,52525,46284,56784,50510,56784,54671,56817,56949,56983,56982,56916,56917,56917,52624,35851,44404,44470,27759,15178,13130,11082,11082,9034,9034,6986,4938,4938,4938,4938,4939,4939,4971,4971,4971,4971,4971,7019,7051,7051,7051,7019,7019,7019,4971,4939,4938,4938,4938,4906,4938,4938,2890,4938,4906,4906,4874,4874,4906,4906,255},
{23895,23895,21847,19799,17719,19767,19767,19767,17686,17686,17686,17654,17686,19734,19766,15638,13558,19734,17686,19734,19734,17686,15606,15606,17686,15606,17654,19734,15605,15606,13557,17654,15606,17654,15573,15605,15605,15573,13525,13525,13525,21782,23862,21651,8876,6731,12938,33807,29680,21260,21260,19115,17002,21260,46452,42194,40081,42161,42128,35822,44046,35888,21227,25356,29581,29613,46485,42259,38000,23275,27566,25453,19082,19082,19115,48532,50645,44370,42225,42257,37999,35918,35854,40113,38001,35855,46353,42192,44273,42160,42160,31660,23210,16969,16937,10695,8550,12776,17002,17035,21227,17067,17035,19148,23406,27599,31758,27467,27401,29546,29578,33806,31661,44206,31658,40045,50545,42060,35851,37965,33707,23337,31691,35819,29546,25385,19112,23337,23176,29450,29450,27369,29515,25322,27436,21162,23275,21129,19081,12808,12775,19147,12808,10695,8582,8582,8582,16937,23275,12808,27468,33839,35953,23242,25356,25388,29647,25322,25417,35950,40080,29581,38032,31661,25387,38032,27434,31660,35951,31724,23208,16935,35819,39946,25287,14854,14854,16903,16935,35754,52525,48300,52526,58865,54671,52591,52591,56882,56949,56950,58997,56917,56884,58964,40012,35919,38163,29840,17291,13098,13130,11082,11082,9034,9034,6986,4906,4938,4938,4938,4938,4971,4971,2923,2923,2923,4971,4971,4971,5003,4971,4971,4971,4971,4971,4971,4939,4938,2858,2858,4906,4906,4906,4906,4906,4874,4874,4874,4874,4874,255},
{23895,23927,23895,21847,17719,17719,19767,19767,17686,17686,17686,17686,17686,21814,19766,15638,15606,19766,19734,19766,21814,17654,15606,15606,17686,15606,15606,17654,15605,15606,13557,17686,17654,17654,15605,17653,15605,15605,15605,15573,17653,23830,25877,21651,15280,4618,15019,25519,40179,42128,42160,42128,40047,40015,40178,31791,33840,35887,35855,29581,27436,42095,44207,42128,54871,50645,40080,42194,33872,21227,23340,27501,21195,23308,17002,37838,44241,46452,46451,48500,48531,46419,37999,52627,38000,33839,38033,37999,40047,35855,33806,35854,35854,35887,35854,29646,25388,19017,21227,17035,17002,19115,21227,17034,12874,14954,35953,31792,33871,29612,27466,29646,33806,42126,27465,40077,52593,48366,44238,42093,27434,27498,27498,33706,35819,35819,27433,27433,19048,25257,31562,27337,29450,21129,23275,21162,42193,44272,37999,33806,29613,23275,27467,17001,14920,17001,14856,21032,21065,19081,29613,33806,27533,27566,29712,27469,18985,23177,23305,44272,31694,31694,40113,25354,29514,31628,33870,40242,44500,33740,31594,18983,33674,31528,25255,14887,19015,23175,21096,19015,25288,33673,46252,46220,42059,50477,52558,56817,58996,58996,58996,58965,58964,52625,29545,27532,19275,17324,15210,13130,13130,11082,9002,9034,9034,6986,4938,4938,2858,4938,4939,4971,2923,2923,2923,2923,2923,4971,4971,5003,4971,4971,4971,5003,4971,4971,2890,2890,2890,2890,2858,4906,4906,4906,4906,2858,2826,4874,2826,2826,255},
{23895,23927,23895,21847,17718,17719,17719,19767,17686,17686,17686,15606,17686,19767,19766,15638,15606,21814,17686,17686,21814,15606,15606,15606,17686,15606,15606,17654,17654,15606,15606,17686,17654,17654,15605,15605,15605,15605,15573,15605,19733,30038,31891,31858,21391,2505,15019,33839,33806,31628,31628,31628,31628,31628,35920,48597,56951,54870,54838,52757,44371,37934,31531,21097,33807,44371,42193,42225,35888,21227,25421,29614,19147,21228,16970,19017,14825,17067,25421,25323,25356,21195,37934,52594,40113,38000,29646,27566,27501,25388,25356,25388,25421,25453,25421,27533,27501,19082,27469,23307,23340,19147,17002,21163,21260,19115,21195,23406,25486,35985,46516,29614,33837,35884,27498,42125,52592,52658,50545,39915,31594,27466,29546,35851,33738,33739,33706,27433,23273,16935,25256,27401,27369,29515,23210,23242,37935,44240,44272,48433,42192,44272,42126,42159,40046,33806,31595,31337,23178,25355,31467,33677,29646,38033,27665,21227,16936,19049,31627,42192,29581,38000,33806,16967,25322,29548,48629,48629,48662,50610,37932,25288,25321,18982,21095,19047,16935,25288,25288,19048,16935,33673,33673,25320,48332,56751,54703,58898,58930,58930,56850,58931,52624,37964,29578,27597,17194,17291,13130,13130,11082,9002,9002,6954,6986,2890,2890,2890,2858,2858,2891,2923,2923,2923,2923,2923,2923,2923,4971,4971,5003,5003,4971,4971,4971,2923,2890,2890,2858,2858,4906,4906,4906,4938,4906,2858,2826,2826,4874,4874,255},
{23927,23927,23895,21847,17719,17719,17719,19767,17686,17686,19734,17686,17686,19734,21815,17686,17686,21814,19734,19734,21814,15606,15606,15606,17686,15606,15606,17654,17654,15606,15606,17654,17654,17654,15605,15605,15605,15605,15573,17653,21782,33971,23342,19245,17133,15053,19277,52724,56918,54837,54804,52724,48531,46418,46418,52823,59031,59032,59064,58999,46321,42161,25421,29613,31694,38065,54870,54838,29679,17066,40145,42225,46484,42259,40145,38000,31758,33807,33807,31693,29549,21259,38064,54871,38000,42225,31662,29581,27501,27501,25420,27501,25421,23405,23340,27533,23341,14889,23275,21161,14855,23275,27566,19147,17002,21195,27533,25421,21195,29581,38033,29581,31725,31787,29578,40012,52526,54673,52560,41995,31626,25385,27465,33738,27465,27498,29612,29645,21226,17033,23274,27434,23177,25257,29515,27435,35821,33709,44272,40046,46385,44240,42159,46320,44207,42127,37869,31401,27403,21129,27241,37934,31694,31726,25420,23307,19081,19016,40046,33806,29581,44338,38065,33676,21194,27468,44370,50710,50709,56884,35885,21128,31561,31528,21127,25288,27432,40011,39979,29546,29546,35786,29513,39978,42026,48332,54638,56751,56783,54671,56817,52592,33771,27531,35951,21420,15146,15211,13130,11082,9034,9002,9002,6954,4938,2890,2890,2890,2858,2890,842,842,843,875,875,2923,2923,4971,4971,4971,4971,4971,4971,4971,2923,2923,2890,2890,2858,2858,2858,4938,4938,4938,2858,2858,2858,2826,2826,2826,255},
{23927,23927,23895,21847,19799,19767,19767,21815,17718,19766,17686,17654,17686,19766,21815,17686,17686,21814,19734,23862,21814,15606,15606,17686,19734,17654,17686,17686,17654,15606,17654,15606,17686,17686,17653,15605,17653,15605,15605,17653,25812,31728,29680,21326,23406,23341,23373,33807,37968,40081,42194,44338,46386,50612,52692,52693,50612,48434,42193,44273,39982,38033,38065,50579,44338,42258,44274,40145,12971,19179,35920,46386,56919,54838,54838,58998,56918,54739,54739,52659,46353,31661,44404,48597,42161,42259,35920,33774,29581,29548,27501,25453,25421,23373,23276,27533,23308,8615,8679,21193,21193,19113,16936,19082,25420,23340,23275,29581,31694,25388,25388,27469,25451,33836,31755,40045,48332,52559,50415,35625,29417,29449,31626,31658,29611,29612,29679,27566,29678,23340,25420,21227,19081,31660,31628,37902,42159,27434,33741,35820,42061,39981,42061,44174,42093,44207,33675,33546,27338,19049,25322,37934,31661,19114,23275,31661,21194,23210,42192,29581,31726,46517,29548,48206,33904,19049,38000,42323,50578,54673,42224,25321,27401,29481,31593,42092,50478,52558,50445,39979,40045,35852,25288,39914,42059,42026,48332,48332,48365,50511,46319,29546,31725,35985,27662,13098,13130,13130,11050,9002,9002,6954,9002,6954,4938,2890,2890,2890,2890,2890,842,842,843,843,875,875,2923,4971,4971,4971,5003,2923,2923,2923,2923,875,842,842,810,2858,2890,4938,4938,4938,2858,2858,2858,2858,778,778,255},
{23927,23895,23895,21847,21847,19767,21815,19767,19734,19734,17686,17686,17686,21815,21815,17686,15638,21814,21814,25943,21814,15606,15606,17686,19734,17654,17686,17686,15606,17654,17686,15606,19734,17654,15605,15605,17653,15605,17653,19733,27828,27599,29647,19213,21261,23309,19148,19083,17035,17035,19083,17035,17002,19115,19115,17035,17035,17034,25453,42161,42095,40146,40211,54805,48467,40113,42193,44372,13036,27599,48564,50612,42225,35854,42193,50580,52627,44207,46287,46287,40015,33742,42291,35984,33807,31662,31727,33839,27500,31661,27468,25323,21259,25356,23243,23308,19083,17099,15018,14920,19145,23306,21193,19081,19049,25355,33807,31726,29549,25356,25388,27435,31692,37997,31755,44173,42027,50479,48301,37737,37770,39882,37834,31691,29645,29614,23373,19114,27500,25452,25420,25420,23307,46222,48237,46255,42225,23274,27467,27370,37868,25322,37901,29482,44207,42159,40014,31595,31304,25193,29515,33741,27500,19147,21194,29614,23373,31661,35887,27501,38032,42323,27272,48303,50546,29548,27468,40210,46319,52658,44338,31595,48431,42158,35754,37835,37866,46285,42092,37899,37932,33739,23208,33673,39913,39946,39979,37899,40012,29514,16968,23307,31856,19275,13065,13098,11082,11050,11050,9002,6953,6953,6954,4906,4906,2890,842,842,2890,2890,842,842,2891,875,875,875,2923,2923,2923,2955,2955,2923,2923,2923,2923,875,875,842,2890,2858,4938,4939,4906,4938,2890,2858,810,810,810,810,255},
{25975,23927,21847,21847,21847,19767,19767,19767,19767,19734,19734,19734,19734,21815,23863,17686,17686,21815,23862,25943,21814,15606,17654,17686,17686,17654,17686,17686,17654,17686,17686,15606,19734,17654,15605,15605,17653,15605,17653,21749,38228,33872,25454,19213,21294,23342,21293,21261,21228,21228,21228,19115,17035,14987,14922,12842,10794,8681,27599,54805,44208,38033,40178,48466,33741,40145,52725,46387,13003,27631,52758,52758,33807,21260,25452,29581,42127,35919,35886,35821,31726,35887,44372,35921,31694,25388,25421,31695,21195,25388,14888,14920,25419,23241,19081,12808,12776,25420,21194,14887,19145,23338,23338,23305,23305,23305,25353,27500,35886,31694,27501,29580,40111,37997,31723,39948,31497,50479,50349,46155,48235,50348,44075,42224,50710,48662,38032,23339,31758,42193,35918,33806,31661,35788,37836,46255,44306,23242,27468,29482,37867,29514,37933,25354,42191,40177,37933,31661,31563,23144,27435,25454,29581,31727,21195,31694,38131,21324,23340,31661,42259,31759,33512,46320,54772,37836,31660,35919,44206,50546,48596,29515,46319,35820,33739,23175,37866,39979,33674,35819,35819,29546,21095,33641,29480,29481,33674,35819,35820,16935,14856,17033,15050,10985,8969,8969,11050,8969,8970,9002,6954,6953,4905,4906,2890,2858,810,2890,2890,842,810,842,842,843,875,875,2923,2923,2923,2923,875,875,2923,2923,2923,875,875,842,2890,4938,4939,4939,2858,4938,2858,2858,2858,2858,810,778,255},
{25975,23927,21847,21847,21847,19767,19767,19767,19767,19766,19734,19735,19734,21815,23895,17686,17686,19766,23862,25943,19734,15606,17686,17686,17686,17686,17686,17686,17654,19734,17686,17654,19734,17686,17654,17654,17653,17653,17653,23829,50743,52791,40244,31793,25551,25519,25552,17197,17100,14955,12874,12842,12842,12874,12874,12874,10761,27566,46484,58900,46288,38065,42259,48466,42160,46385,48466,33775,10923,29809,59097,56951,29614,21260,33807,40080,44240,33773,33773,35920,35952,33839,44371,33807,27566,19115,19147,23308,19082,23308,12841,17034,23274,31659,31659,21193,21194,31694,17001,17032,14920,21258,23338,23305,21225,35884,44237,33803,29578,37999,33839,33805,48531,44336,31659,44106,37801,52559,50381,48202,48235,46155,44238,50677,46452,50678,44339,27565,35951,44305,44273,42224,44304,44239,48433,42029,46418,25355,27500,31595,39883,31627,37933,27402,42159,42225,42192,33871,33872,21096,35886,25486,29548,31727,27534,31661,38033,13132,25453,35919,33839,29481,37771,40046,54805,52560,56851,42126,42028,52659,52757,27466,46286,35852,37900,16903,31594,27368,31562,35819,33739,25289,19047,35786,31593,23208,27401,27434,19048,12775,10727,8711,10921,10985,8970,8969,8969,8969,8969,6921,6921,4873,4873,2858,2858,810,810,842,842,842,842,842,842,843,875,875,2891,875,875,875,875,875,875,2923,875,875,843,842,842,842,4939,4938,2890,2890,4938,2858,2890,810,810,810,255},
{25975,23927,21847,21847,21847,19767,21815,21815,19767,19766,19734,19734,19767,21815,23895,17686,17686,19766,23862,23895,19734,15606,17686,17686,17686,17686,17686,17686,17686,17686,17686,17686,19734,17686,15606,17654,17653,17653,17685,19733,38229,52758,61210,61210,59130,59130,57049,52824,33840,21293,21261,19148,15019,12907,8681,4520,4520,33839,50645,54739,52691,50710,44405,48564,46418,42161,42192,35920,8810,31889,59097,56918,42224,35951,35952,35919,42127,37967,35854,48597,46452,38001,38033,31759,25486,19245,21292,19212,21260,19179,12809,10728,12807,23306,31660,25387,17033,21227,12840,17032,17032,19177,25451,27531,21225,44238,48398,46317,37932,29613,31726,46385,52725,42225,31626,46217,39882,37802,48301,48203,48202,46155,52725,54904,40179,48630,42226,29645,35951,35918,44273,44272,50545,54739,50481,35690,46451,29515,29548,29547,35787,31627,37933,27434,42126,40177,42192,27532,33872,19017,37967,25452,29548,31693,33774,33806,19276,17228,29613,35887,37739,56624,39980,33642,50481,58998,59096,35853,37900,50578,54870,42289,44206,35819,40012,23208,27434,33740,23208,27401,27401,19047,25320,31593,35786,21095,19015,14855,10662,8614,8646,8743,10921,8937,6889,6921,8969,8969,8969,6921,6921,4873,4906,4906,2858,2858,2890,842,842,842,810,842,842,843,843,875,875,875,875,875,875,875,843,875,875,875,875,842,842,842,2890,4938,2890,2858,2858,2858,2890,810,810,810,255},
{25975,23927,23895,21847,21847,21847,21847,21815,21815,19767,19734,19734,19767,21815,23895,19734,17686,19766,25943,23862,17654,15638,15638,17686,17686,17686,17686,17686,17654,17686,17686,17686,17686,17686,15605,17654,17653,17653,17653,19733,34101,54904,61210,61210,59130,59130,59130,56985,35985,19181,19213,19180,19148,17035,12906,12874,12874,40112,46288,46320,35920,44404,42357,46485,50677,48532,42128,42226,17131,33969,59064,56918,56917,56950,56983,58998,54771,52691,50611,48466,42259,33872,33807,25421,25453,21292,25421,19147,21292,23340,19147,10696,14888,21193,33773,21193,19146,12840,12839,17032,19113,21290,31725,31757,31725,44239,46286,48398,42092,27501,33807,50612,52790,38031,35949,35819,44173,33641,44075,48202,50348,48301,50677,52725,44371,46517,40145,27532,38064,42257,42192,44240,52659,54772,48367,37835,46451,33676,29580,31627,37835,46286,48399,44206,48399,46384,44272,37966,33904,19114,29581,17001,31629,33741,35886,38097,17260,27533,33807,37934,48140,56820,48334,39883,48367,59097,59064,44272,44239,50513,54871,48597,33707,35820,35754,33674,19048,21096,21128,19015,19048,16935,21128,25320,29513,27433,12710,10662,6502,6534,6599,8711,8840,8937,6889,6921,6921,6921,6921,6921,4906,4873,4906,2858,2890,810,810,842,2891,842,810,842,842,875,843,875,875,875,875,875,875,875,875,875,875,875,875,842,843,842,842,2923,2890,2890,810,810,810,810,810,810,255},
{25975,23927,21879,21847,21847,21847,21815,21815,21815,19767,19734,19767,19766,23895,23895,19766,19766,21814,25943,23863,17686,17686,17686,17686,17686,19734,19734,17686,17686,17686,17686,17686,17686,17686,17654,19734,17654,17653,19734,21782,34134,56951,42259,44405,56952,59065,61177,50678,35953,21229,21261,21260,17035,25519,40277,23373,25388,44305,52626,38000,19245,33938,44437,44405,44405,48532,40080,29679,10987,38130,52725,56950,56917,56983,56984,56918,58932,56917,56918,54772,46484,44339,44338,35952,33872,31759,29678,23373,25453,21195,23341,8615,14920,23305,27499,19145,21226,14986,14952,17032,19113,23370,31725,31725,42193,46353,42093,46318,44173,23372,40113,52758,50677,40110,48432,48399,46221,37737,44140,52558,52494,50381,48564,48465,52757,44404,35919,33773,48464,48432,44239,44239,48498,48399,44173,37803,46451,29515,29580,35821,39915,44206,48432,37901,48400,37933,46352,33741,35985,23308,21194,17066,29613,33741,35887,33774,27598,27533,38000,39852,54576,54739,44141,33675,50513,59097,59031,40078,44304,54772,56984,50710,29547,42158,25321,44206,21095,31561,42124,25385,12742,19048,27369,27369,33674,33738,19080,6469,6502,6534,6598,6631,8840,8937,6889,6921,6921,6921,6921,6921,4906,4874,4906,2858,2890,810,810,842,842,810,810,842,875,843,875,875,875,875,875,875,875,875,875,875,875,875,875,842,842,842,842,842,842,842,842,810,810,810,810,810,255},
{28023,23927,21847,21847,21847,23895,21847,21815,21815,19766,19734,19767,19766,23895,21815,19766,19766,21814,25943,23863,17686,17686,17686,17686,17686,19734,19734,17686,17686,19734,17686,15606,17686,19734,19734,19734,19702,17653,19733,23862,30006,36084,21358,31825,37935,42128,42194,40179,48565,35920,31759,31694,23308,38066,50711,27534,27501,38098,48467,40114,23438,44470,46550,46518,44437,42259,38001,33872,21487,27663,31726,37967,44209,42161,46354,48499,50547,52660,54772,54740,48533,48533,46452,46419,44339,44306,44306,40113,40080,33839,12841,10761,17001,29644,27531,19113,21227,14921,14984,17064,14920,23371,33870,27531,40144,42225,42159,48399,44206,23340,35920,52790,48564,46384,52559,50447,29416,39816,48300,52558,54606,52592,46418,50512,44305,42291,40112,40047,58932,58867,56753,54705,52658,46254,42061,31562,48499,31660,35854,37901,44108,44141,44239,46352,48399,48432,48432,42159,35984,21195,31661,17034,29548,31693,33807,33775,29614,31694,37999,46060,54740,44273,42061,37835,46353,59064,58965,46319,50448,52692,57017,52823,39981,48464,35819,48431,31561,48333,50478,46318,21160,19015,25321,31626,33739,35819,31658,14887,6502,6534,6566,6631,8808,8937,6921,6921,6921,6921,6921,4873,4906,2825,2825,2858,842,810,810,842,810,810,842,842,843,875,875,875,875,875,875,875,875,875,875,875,875,875,875,842,842,842,842,842,842,842,842,810,810,810,810,810,255},
{28023,21879,21847,21847,21847,23895,21847,21815,21847,21815,19734,19767,19766,23895,23863,19766,19766,23862,27991,23863,17686,17686,17686,17686,17686,19734,19734,17686,17686,19734,17686,15638,17686,17686,19734,19734,17654,17653,19734,23862,27925,15118,6666,29777,44338,44305,44307,48630,52758,50645,50645,50645,46420,40049,52824,31792,23373,35953,31728,23406,19148,44405,46550,46518,44405,42292,40179,38001,39918,23276,23308,23243,19050,14857,12809,14922,19115,19180,25356,29581,40146,40145,46419,48532,46451,46419,44339,42226,42193,31726,4422,6567,14952,31725,21258,14920,17065,10727,14920,17064,12872,23338,31660,31725,37999,42225,42225,44206,33773,19212,38032,52758,48565,48433,52559,48399,25191,39817,46155,50380,52526,54640,54706,54673,44273,42193,31726,42160,54706,56852,56819,54673,54673,48367,44174,39916,48564,27468,33773,35853,44108,33707,40046,33741,44239,42094,48432,33773,35984,21195,23275,17001,27468,31694,33807,33807,27533,33839,35692,54543,56918,48597,50578,40013,46287,59064,44239,52626,46190,52757,57017,50677,37933,48366,44205,50478,42027,48365,48398,50511,42092,29481,27369,31594,31593,39979,39979,33738,14887,4454,6566,6599,6728,8905,6889,6889,6889,6921,6921,4873,4873,2825,2857,810,842,842,810,842,842,842,842,842,842,842,842,843,875,875,875,875,875,875,875,875,843,843,843,842,842,842,842,842,842,842,842,810,810,810,810,810,255},
{28055,23927,21847,21879,21847,23895,23895,21815,21815,21815,19767,19767,19766,23895,23895,21815,21815,23895,28023,23862,17686,17686,17686,17686,17686,19734,19734,17686,19734,19734,17686,17686,17686,19734,19734,19734,19734,17653,19734,25910,30038,19538,13134,42325,59097,50678,35985,52791,48467,46419,48499,48500,46387,42292,52792,42291,38066,33938,29680,21326,21325,44470,48631,44437,44373,40211,38098,40048,43883,14921,19082,21130,21228,14922,17067,17067,17099,17100,17067,10794,19149,17099,12841,16969,19082,23340,25420,27500,31694,27469,6535,8680,8647,17001,21226,14920,21292,17066,14952,15016,12839,19145,31725,29645,33806,35951,35886,31627,21162,14986,33839,50579,40113,44207,52559,46319,25159,33545,33577,41995,48300,44141,48432,52625,50546,37966,16968,44239,56819,58900,56819,52560,54673,50479,44206,31562,50611,31660,40112,31660,44173,37933,44207,31627,46319,33805,48432,27533,35985,16969,27468,19082,23275,31758,35887,31726,29581,40178,44045,56852,44306,44338,56950,50449,58933,54805,48432,52562,46190,56984,57017,54771,54738,48366,50479,52525,56785,54705,50478,54704,44205,33706,29514,37932,40044,40012,35786,35819,31626,10694,6567,6599,6696,8905,8937,6889,6921,6921,6921,4873,4873,4906,2858,810,842,810,842,810,842,842,875,842,842,842,842,842,875,875,875,875,875,875,875,875,875,875,842,842,842,842,842,842,842,810,810,810,810,810,810,810,255},
{28023,21847,21847,23927,21847,23895,23895,21815,21847,21815,19767,19767,19766,21815,23895,21814,21815,25943,28023,21814,17686,17686,17686,17686,17686,19734,19734,17686,19734,17686,17686,19734,19734,19734,21782,21782,19734,19734,21782,27990,30070,30071,34101,42325,44404,40211,42291,54904,48500,48501,46419,46420,44339,46420,48663,38131,40147,38098,35986,19213,36051,54969,48566,44340,38066,33905,31792,33775,35693,27599,19114,21227,29582,14922,14986,14954,10728,10793,10793,12874,17035,17100,12939,12874,12906,21293,25421,19147,12776,10695,10728,12841,10728,12776,14888,10727,23340,17033,12904,14952,12839,17000,29677,31725,33839,35919,27531,10694,6502,10728,27533,42160,33740,42093,52560,37868,25127,27240,27369,39980,41995,37867,44240,52724,48399,46319,48498,50546,52561,54641,54609,52560,50578,50479,46254,39980,50611,27402,37999,33708,48333,37900,42093,33675,46254,46385,50480,33805,35919,25354,31628,17001,23307,33807,33807,29581,33839,50646,54609,52692,35820,46353,56918,50481,63191,42158,52593,48368,54772,54936,56951,54837,54804,44238,50544,54737,58964,48365,54671,56817,46285,46286,46384,42060,46253,35818,31593,27432,33738,29578,10727,10792,17131,15147,8905,8937,8969,6921,6921,4873,4873,4906,2858,2890,842,842,842,810,842,874,875,875,843,842,842,875,875,875,843,875,843,875,875,875,875,875,875,843,842,842,842,842,810,810,810,810,810,810,810,778,255},
{28023,23927,23927,23927,23895,25943,23895,21847,21815,21815,19767,21815,19767,19766,23895,21814,23863,25943,28023,21814,17686,19734,19734,19734,17686,19734,19734,19734,21814,17686,17686,17686,19734,19734,21814,19734,19734,19734,21814,27990,30006,40342,35986,29712,33905,44404,44340,52726,42161,40081,35920,35888,31694,29517,44405,50743,42357,50678,40146,17132,38066,48566,44372,46452,44404,44404,42292,35985,35953,29712,17002,19115,23308,19147,19115,12808,6567,2407,8681,14954,14987,17068,17100,17067,14987,19180,25454,19180,10760,6502,8583,8615,8647,14921,17034,17034,29777,14921,10791,14984,12904,12872,21258,31692,40112,35854,29645,12840,8582,8582,25388,29646,14954,35853,50578,33676,25159,33610,25289,35755,39915,37835,44142,48498,27500,37965,52725,46418,35854,35854,29515,33675,48466,50479,42028,48400,48531,31563,42193,42093,50479,29547,42094,27434,44206,33773,46384,35788,40014,27403,25290,14889,25420,31758,29614,27468,35952,46321,54707,44207,46352,54805,48401,58965,50546,46254,56820,56951,57017,56984,52658,54804,48432,50544,56818,56850,56818,56817,58964,52592,50478,48366,42091,48431,44270,50545,54770,52657,50577,52722,35916,12775,14855,23372,15179,8937,8969,9002,6954,6954,4906,4906,2890,2890,842,842,842,842,842,874,874,875,842,842,842,875,875,875,875,875,875,875,875,875,875,843,875,843,842,842,842,842,810,810,810,810,810,810,810,778,255},
{25975,21879,23927,23927,23895,25975,23895,23895,21847,21815,21815,21815,19766,21814,25943,21815,23895,25943,28023,21814,19734,19734,19734,17686,19734,19734,19734,19734,21814,17686,17686,17686,19734,21814,21814,19734,19734,19734,23862,30070,34101,33970,40179,33905,44372,50678,35920,37968,37968,38065,40081,42194,35920,33807,33808,46485,46518,48565,42292,27599,48695,50743,48598,46550,46518,46517,36018,36018,42226,35985,23372,23275,17034,17066,14954,8648,4487,6633,8746,10761,6600,12907,14987,15019,12874,17067,21261,21260,12873,4454,4422,6535,8648,12809,17067,19180,25584,17034,14920,14920,14952,14920,17000,25451,27435,19049,14888,12840,6502,6502,25420,38032,12970,23373,42160,31530,29384,35723,27369,37803,39915,35755,39915,44239,29580,37967,52693,42160,33773,35821,29515,33741,48465,52559,29482,46320,46418,33675,46385,44173,54672,46417,50545,42159,50512,46319,50479,37998,40079,16936,16969,14921,29613,33839,29614,31694,42225,40080,40014,42126,61111,48433,44142,58932,33675,42159,50579,56984,54936,54837,54804,54738,46350,56785,58964,58931,59029,59030,56884,52624,44172,46285,58964,61078,59030,58964,58931,58930,59029,59029,58996,33804,19015,27532,17195,11017,11050,11082,9002,9034,6986,4938,2890,2858,842,842,842,842,875,2890,2923,2923,874,874,875,2923,875,875,875,875,875,875,875,875,875,875,843,843,842,842,842,842,842,810,810,810,778,778,778,778,255},
{26007,21879,23927,23927,25943,28023,25943,23895,21815,21815,21815,19767,19767,21815,25943,21815,25943,27991,28023,21814,19734,19734,19734,17686,19734,19734,19734,19734,19734,17686,17686,17686,19734,21814,21814,19734,19734,21782,25910,30038,42455,31824,44405,44372,46452,54806,37968,29614,31791,42226,35920,42292,44307,35921,27502,42291,52824,54904,46517,35986,52824,54936,48598,48630,46550,44405,33840,29647,35888,35887,40080,40048,23308,21195,17002,8713,6567,8681,12939,8745,4487,8648,8713,10793,8680,10761,17034,21195,19082,10728,6600,10728,10761,14922,14987,17099,14955,10793,10922,14921,12807,12807,23275,31726,19049,16968,16936,16968,4454,8615,31694,48367,33675,15020,31662,25225,29417,33578,27369,33642,37834,37867,39947,46287,46319,46385,50645,37999,33741,31660,27370,33708,50513,52526,39915,50513,40112,29515,44305,35819,54705,48400,52625,50512,50512,52625,50512,56918,38065,14921,17002,25420,31726,33774,29581,40112,50382,44338,46451,50545,42061,37868,44109,42125,27402,42160,48532,57016,56951,56753,56819,48399,56784,58930,58964,59029,58997,58931,52592,46252,48398,58932,58997,56916,56818,56784,58832,58865,58930,56850,56850,44205,23241,31759,15114,13098,13130,13130,11082,11082,6986,4938,4938,4938,2890,2922,842,842,875,2923,2923,2923,2922,2955,2923,2923,875,875,875,875,875,875,875,875,875,875,843,843,843,842,842,842,842,810,810,810,778,778,778,778,255},
{25975,21879,23927,23927,25975,25975,25975,23895,21815,23895,21815,21815,19767,21815,25943,23863,25943,30071,27991,21814,19767,19734,19734,19734,19734,19734,19734,19734,19734,17686,17686,17686,21814,21814,21814,19734,19734,21782,25942,32118,40309,42292,48533,50678,52758,44275,35888,40081,40113,40114,40146,42129,35790,33808,27502,35920,46354,46452,46322,50580,50612,57017,52823,48598,48663,48468,33807,21195,25389,17035,17002,23308,25486,21260,19179,21293,14954,12873,6567,6567,4455,4519,10793,14922,12873,6567,6535,12808,19147,12842,10729,14954,12874,14987,14954,12874,10793,10793,12939,19180,17001,12840,19146,35952,25387,14888,10695,16969,12873,14921,31726,37803,25323,17067,31694,23112,35755,35756,27337,29449,35754,39948,42093,50512,44239,44273,50579,37999,35821,31596,27435,37901,50512,41996,31562,50578,37934,37966,42192,44173,56850,54771,54738,54738,50545,52658,46352,54838,33937,36116,25551,33773,33806,31694,29613,37999,39884,48368,56951,50644,39981,46255,37803,46286,39948,50448,46451,56984,52691,56884,48431,52624,58865,58997,58964,58931,54705,46252,48365,54639,56850,54672,56818,58964,56850,58897,56783,54703,54769,56883,50576,29513,23306,27662,13098,13098,13130,11082,11082,11082,9034,6986,4938,2922,2890,2890,2890,874,875,2923,2923,2923,2923,2955,2923,2923,875,875,875,875,875,875,875,875,875,875,843,843,843,842,842,842,842,810,810,810,778,778,778,778,255},
{28055,21879,23927,23927,25975,25975,25975,23895,21847,23895,21815,21815,21815,21847,25943,23863,25943,30071,25943,21814,19766,19734,19734,19734,19734,19734,19766,19734,19734,19734,17686,17686,21814,21814,21814,19734,19734,21782,25942,38327,40277,29745,31760,50678,54839,42259,29615,33872,35920,35921,33840,35920,29646,42226,37968,29613,33774,44274,37741,31661,35854,48564,54804,52724,54870,48532,33840,17034,16970,17002,14922,25420,44404,46516,42323,42290,38097,38031,33805,25485,25485,25485,19146,14953,17034,12841,8615,17001,27566,19180,10728,8648,10793,12809,10793,14954,19180,17100,17099,17100,10760,12776,16969,21194,23307,17033,10759,17002,14954,21195,31727,29516,23308,17034,31694,23079,37868,37933,27304,25256,33675,39980,44174,48400,40046,42159,40047,29483,29515,27402,25290,44240,52593,39980,44173,48498,33708,42192,37966,48399,50578,50579,46320,52659,48432,56851,52626,52758,36018,40276,25551,29613,33806,29581,33839,31726,39917,52431,54838,57016,52658,48433,37900,46286,42159,52496,50677,54804,56819,52625,50544,58865,56818,56818,58932,50479,48365,48365,46285,46220,39946,50511,52624,52559,56817,58996,58964,58930,58997,61110,52689,27433,33871,23533,13098,13130,11082,11082,11082,9034,9034,6986,4970,2922,2922,2890,2923,875,2923,2923,2923,2923,2955,2955,2923,875,2923,907,875,875,875,875,875,875,875,843,843,843,875,843,842,842,842,842,810,778,778,778,778,778,255},
{26007,21879,23927,23927,25975,25975,28023,23895,23895,23895,21815,21815,21847,21815,25943,23895,28023,30071,25943,21815,19734,19734,21782,19734,19734,21814,21814,19734,19734,19734,17686,19734,21814,21814,21814,19734,19734,23862,27990,36279,36084,34036,8810,19147,44112,41967,33872,31760,29647,31727,25421,27534,23341,35888,38001,25388,27501,40081,35855,31661,31694,52692,56851,35821,42193,46485,52725,46483,44338,40113,31758,29646,38097,50710,48597,48597,48596,48564,48498,48432,44304,37934,42258,44372,38064,35952,33741,25387,21227,27566,25485,25518,23340,10728,8680,14954,17035,12906,14986,17067,8648,6535,8615,14888,16969,23340,16968,12776,14954,23340,27501,17035,23308,35951,33709,20999,35755,33708,27304,29417,33674,37868,37966,19048,16935,44240,44273,25322,25322,23145,21129,48466,56786,48334,46254,52626,42029,48498,42094,56785,48530,52724,37901,52659,35820,54805,46320,50678,38163,34003,36083,31726,31694,29613,37999,29711,41931,50350,44240,56950,61078,56917,52626,54706,48563,56918,54902,50479,54738,46318,54672,52559,48366,35754,37835,39914,40011,46351,48398,48333,44172,58931,58963,54770,54670,58963,56883,56850,58964,56883,42125,25451,29678,17292,13162,13130,11082,11082,11082,9034,9034,6986,4970,4970,2890,2922,2923,874,875,875,907,875,2955,2955,2955,2923,2923,2955,907,875,907,875,875,875,875,875,875,875,875,843,842,842,842,842,810,810,810,810,810,778,255},
{28055,23927,23927,23927,23895,25975,25975,23895,23895,23895,21815,21815,21847,21814,25943,23894,28023,30071,25943,21814,19734,19734,21814,19734,21814,23862,21814,19734,19766,19734,19734,19734,21814,21814,23862,21782,19734,25910,28022,38295,36084,31825,19342,27729,31825,37968,46485,27599,33937,52759,37968,35822,29581,46386,44372,31728,33840,33840,35888,40048,40080,58866,52627,31824,31727,42291,48466,44208,44240,50710,31695,44404,44404,50710,50677,50677,48596,48564,46483,48530,40014,23144,23308,38131,50644,40145,37966,27499,21227,29678,31791,29679,23340,19115,17099,12841,8680,8647,12906,14987,12906,12874,8648,6502,12808,19082,10695,6534,8615,21195,23275,17100,33904,46418,29516,25191,33740,31627,29449,35755,44272,40079,40079,31693,25387,42192,42160,27467,21129,16936,14791,39981,58833,39948,46255,50513,44109,46418,37867,56851,46385,56983,46353,54772,48497,54739,50611,44372,38131,34035,31727,29613,29581,31693,44371,44437,48106,54511,46385,61111,63225,61144,61045,54902,56983,56983,52756,48398,50446,44140,39915,31529,29481,31561,35722,37867,35818,46253,52592,52592,58899,58964,59030,58964,58898,56850,58931,56883,58964,48366,31692,29710,19275,15243,13162,11082,11082,11082,9034,9066,9066,7018,4970,4970,2890,2922,874,874,875,875,875,907,2955,2955,2923,2955,2955,2955,2955,2955,2955,875,875,875,875,875,875,875,875,875,842,842,842,842,842,810,810,810,810,778,255},
{28055,23927,23927,23927,23895,25975,25975,23895,23895,23895,21815,21815,21847,21814,25943,23862,28023,30071,23895,21814,19766,19734,21814,21814,21814,21814,21814,19734,19734,19734,19734,21814,23862,23862,23862,21782,19734,25910,30038,40342,27697,8810,38196,44438,42325,40244,46486,42292,38033,48467,46289,44208,40015,31661,35986,33841,38065,31791,23308,35985,38098,46353,46353,46386,44371,48500,56950,52723,50579,46517,38163,48598,50678,52758,54838,52790,52789,52757,50709,50709,40112,21227,14953,35986,35921,33839,35885,40046,40079,46451,46516,42323,38064,25388,14986,12841,8680,12809,17067,14987,10826,10793,14986,12873,8680,8647,10728,6534,12808,23308,23340,27664,38065,44338,27370,31529,37934,31660,27337,35788,54773,50612,31725,29613,29515,31628,29451,31596,29548,21194,12808,29514,56688,48367,52626,52658,44239,46417,44206,54770,48466,50645,46451,44305,50578,44271,52757,40178,42389,19245,21195,29646,29581,35854,42258,40048,54249,52364,42029,50546,52724,54804,52658,56820,58965,61045,61045,61010,58799,39914,33642,31594,33641,35786,40044,35851,33738,35818,37899,42124,46252,52624,56884,54770,58964,58996,58964,58964,56883,42124,33839,29776,15146,15243,13163,11082,11114,9034,9034,9034,6986,4970,4970,4938,4971,2922,2922,875,875,875,2923,2923,2923,2955,2955,2955,5003,2955,2955,2955,2955,907,875,875,875,875,875,875,875,875,843,842,842,842,842,810,810,810,810,778,255},
{28055,23927,23927,23927,25943,28023,25943,23895,23895,23895,21815,21815,21847,21847,25943,23862,28023,27991,23895,23862,19766,19734,21814,21814,21814,21814,21814,21782,19734,19734,19734,21814,23862,23862,23862,21782,21782,27990,27925,38229,21423,29809,46518,42325,42325,42293,38098,33774,37968,50580,35789,40015,44175,35822,31792,40146,46419,44307,29614,42259,46485,42292,48630,44370,44239,48466,52626,52627,40015,31760,46550,52824,52791,31726,35920,38000,38032,40113,42193,46386,35887,31760,35952,46354,42193,42193,42192,44272,42224,52790,50677,48532,46418,33839,25453,8647,2374,6535,17002,23340,6567,12874,17035,14954,14954,12874,12970,4421,21227,31727,21227,25551,33904,42193,25257,33675,33740,29482,23176,33708,44240,48499,35886,35919,19049,25355,12743,21129,14823,14888,10695,31628,35756,44208,54771,56852,54804,56918,58997,56786,58931,54738,56850,50511,56785,48497,52758,36050,38196,21358,27533,29613,31694,35887,31661,44011,58441,50480,44174,50514,48432,48465,35885,48367,39914,48464,58931,56687,42060,40012,44173,29513,27368,37898,46318,52624,37997,21191,29545,44139,54737,48398,50511,50478,56883,58997,58964,58964,54737,42125,33871,21356,15243,15243,13163,9034,9034,9034,9034,9034,6986,4970,4970,4970,4971,2923,2923,2955,875,875,875,2923,2923,2955,2955,2955,2955,2955,2955,907,875,907,907,875,875,875,875,875,875,875,843,843,842,842,842,842,810,810,810,810,255},
{28055,23927,23927,23927,25975,32151,25943,25943,23895,25943,23895,21815,23895,23863,25943,23863,27991,25943,25943,23862,19766,19734,21814,19766,21814,21814,21814,21782,21782,21782,21814,21814,23862,23862,23862,21814,21814,28022,27925,31955,29744,44437,44437,50678,48599,46518,48565,50548,37935,50777,42194,42160,48401,44272,46386,44404,35921,35920,40113,48565,40178,42259,35920,40145,46319,35723,33644,31694,27534,25421,46485,46485,52790,40144,33773,31725,29644,29580,25387,25387,21194,17001,21129,46353,40113,35887,35887,31693,29646,38032,40145,33806,27468,25420,21260,6535,4487,4486,14986,33905,19212,14954,14954,15019,12874,14922,14954,10728,12841,21195,21195,29581,40080,40113,23080,29449,29514,21032,27370,37868,35854,46353,27403,42160,44338,40047,29580,27467,25355,21129,14824,21162,25355,31660,54772,50578,58998,50644,58998,50578,61078,56884,58964,58964,56851,61111,46485,42324,38164,27566,33774,29581,35919,33774,31660,56426,58572,46385,52724,48433,50479,56817,54770,58931,58831,54673,42028,27369,19047,27433,25352,21159,25287,27367,42092,50414,37898,44204,50510,50445,54672,50478,54737,58997,59030,59063,54771,46319,44370,33870,25582,15114,13163,13163,11114,9034,9034,9034,9066,7018,4970,4970,4970,4971,4971,2923,2923,2923,875,875,875,875,875,2955,2955,2955,2955,2955,2955,907,907,907,875,875,2955,875,875,875,875,875,843,842,843,842,842,842,810,810,810,810,255},
{28055,23927,23927,25975,25975,32151,25975,23895,23895,25975,23895,21815,23895,23895,25943,23895,25943,25943,25943,23862,19766,21814,23895,21814,23862,23862,21814,21782,21814,21782,21814,21814,23862,23862,23862,23862,23830,27958,36279,44470,36018,46518,50678,52725,50646,48500,42129,42161,35855,46485,56853,52529,48401,48401,52627,46518,31792,31727,38066,50679,35985,40178,33904,33905,33872,35756,33643,38098,38065,29711,44404,44371,52757,48499,40046,42159,42191,42159,42159,42126,40046,35885,31595,31694,40178,36018,35952,42323,40178,38065,35952,33872,29711,29679,29614,23373,21260,19179,21260,27599,23308,17067,12841,12809,14922,12841,12841,14954,17034,10728,14888,23307,33774,33774,21064,25257,21064,12678,29580,46384,42127,42191,35918,50578,56951,52627,50514,35821,40014,37934,31596,25322,23241,31627,52627,52692,56950,54837,54805,54805,54771,58998,56851,58997,56852,59097,40211,44405,38163,35919,29613,31693,37999,31661,39916,60554,52495,50644,58998,52691,52559,58932,58932,44239,27400,19047,19048,19080,23272,31561,35786,42059,40011,44205,42092,39946,42059,48366,50479,48365,46219,50445,52559,56818,58931,56883,46318,35755,38097,31888,19437,13130,13163,11114,9034,9034,9034,6986,7018,7018,4970,4970,4970,4971,4971,2955,2923,875,875,875,875,907,907,2955,2955,2955,2955,2955,2955,2955,907,907,907,2955,2955,2955,875,875,875,875,843,843,843,842,842,842,810,810,842,810,255},
{28055,23927,25975,25975,25975,30103,25975,23895,23895,25975,23895,21815,23895,23895,25943,23895,25943,25943,25943,23862,19734,23862,23895,21814,23862,23862,21814,21814,21814,21814,21814,21814,23862,25942,25942,19539,17296,17328,27730,50711,42292,48598,50645,52758,46453,35954,29647,40113,42226,52659,56722,48368,42128,42160,42128,42194,29646,38098,40178,29614,27534,33840,38131,44405,35952,41997,33546,31596,35919,29613,31694,44306,42258,35951,40046,40046,40078,40078,40078,40078,40046,37933,33708,35952,35952,25421,33839,37968,42259,38065,40081,40113,40146,40146,40146,38098,35953,35986,33905,27599,19115,14987,14921,17002,17034,8647,10728,14889,14922,14954,8615,14889,21195,21195,29614,29515,25289,21064,35821,48465,48499,48466,52691,50579,44273,46320,46288,42127,44239,44207,46255,42094,35788,29515,29482,48368,48368,52626,48466,56852,52593,58965,54705,58965,58899,56984,25551,31824,44372,33806,27533,33806,35854,31629,46058,58539,48433,56950,56852,54903,52691,52592,46253,31561,23240,23305,31659,40077,44238,33608,46155,52557,58864,58864,52591,52625,58997,58997,61111,54672,48332,50511,52657,52623,54638,52559,37899,29546,27433,21356,21582,13195,11114,9066,6986,6986,6986,9066,7018,7018,7018,4970,4970,5003,5003,4971,2923,875,875,875,875,875,907,2955,907,907,2955,2955,2955,2955,907,907,907,2955,2955,2955,2955,875,875,843,843,843,843,842,842,842,842,842,810,810,255},
{28055,25975,25975,25975,25975,30071,25975,25943,23895,25943,23895,21815,23895,23895,25975,25943,25943,25943,25943,21814,19766,23895,23894,23894,21814,23862,23862,21814,21814,21814,23862,21814,23894,25942,25910,36149,31923,27794,23633,46550,46485,46420,52726,52823,42292,35986,38099,44405,54838,54673,54639,50479,48401,48499,38032,31759,44404,48564,40146,17099,23470,31857,40179,35953,38033,27436,23177,21064,23341,25453,29580,40210,52855,54903,42193,46418,40079,33773,33773,35821,35853,33773,31693,38000,33806,19082,35919,33839,38000,40080,35919,35886,33774,29613,27468,29614,29614,29614,31695,27501,21227,19115,21228,19115,14889,6534,10728,12841,12841,14954,17002,14954,6534,12776,21260,27533,31661,33709,46320,42192,46419,46451,50579,40047,37967,40047,37967,44239,44305,46385,48367,48399,46254,41996,33642,29417,25192,27304,25224,29418,31497,39916,39949,44240,52757,46485,36115,36017,40080,29613,29581,37967,29613,33708,58474,54477,48531,59031,56951,56984,56917,52559,48365,52591,48431,46384,50577,52657,52591,46318,50510,56751,50413,52657,52657,59029,59062,59063,59031,52690,56884,59063,56850,52558,50478,37899,35885,31725,21323,15146,19437,13195,9034,9034,9066,7018,9066,9066,9066,9066,7019,4970,4971,5003,5003,2923,907,875,875,875,875,907,907,907,907,907,2955,2955,2955,2955,2955,2955,907,2955,2955,2955,2955,2923,875,843,843,843,842,843,842,842,842,842,810,810,255},
{28055,25975,25975,25975,25975,30071,28023,25975,23895,25943,23895,21847,21847,21815,28023,27991,25943,25943,25943,21814,21814,21814,23895,23895,21814,23862,21814,23862,21814,23862,21814,21782,25942,25942,23862,38359,50776,48664,46616,31826,31793,54838,54871,52758,44404,33938,40180,46517,42160,50610,54737,50544,42192,46484,31824,19179,40146,52726,33872,21227,29679,38099,40211,38162,42324,42128,31530,31563,36017,31890,27566,35985,44339,42258,25453,29646,25420,21227,19212,21227,21227,21195,21195,35887,35887,33740,29548,38032,44305,54805,54805,54804,54772,42193,23308,25421,31726,33806,33741,33742,31661,29581,23308,23308,17002,17067,10728,10728,14987,14954,14922,17034,10728,8615,12808,23340,29679,38000,52595,54837,50545,48431,40112,37967,33708,40146,38032,54771,54805,56984,52658,52593,52625,50479,48334,42061,37835,33641,31496,27304,25224,29417,37770,29450,50644,40211,44437,33839,35887,27533,31726,35887,31628,46091,56427,42062,50612,56885,56984,56984,56851,48333,54671,46285,44140,52591,58898,52591,54639,60978,56752,54703,54770,59030,52658,58965,59062,59063,59064,59064,59063,56884,54737,54704,44237,25385,21290,17129,15179,13130,13162,13195,9034,9034,9066,7018,9066,9066,9067,7019,7019,7019,5003,5003,5003,2955,907,907,907,907,875,907,907,907,907,2955,2955,2955,907,907,907,907,907,907,2955,2955,2955,2923,875,875,875,843,843,842,842,842,842,842,842,842,255},
{28055,25975,25975,25975,28023,30071,25975,25943,23895,25943,23895,23895,23895,23895,28023,28023,27991,25943,25943,23895,21814,23862,25943,23862,21814,23862,21814,23862,23862,23862,23862,23862,25910,25910,25910,28022,38294,48566,50679,27697,27632,42292,46388,48501,35921,38165,40212,40179,33840,44306,56885,56884,46418,44371,23373,6632,35985,46485,40113,29581,25421,44405,50775,54904,54937,50579,46287,37999,50710,52758,33937,29743,27631,25518,21357,12938,12938,15083,19342,10761,17261,15084,15051,19277,31726,46189,31661,33806,48466,52724,52724,52692,52691,42193,40178,25420,21163,31661,35887,35822,33741,35822,33742,31726,29614,23341,14921,10728,17002,17066,14922,12841,14921,14921,14954,29680,40243,44339,42062,42159,46319,48399,37935,42127,37901,42159,46385,54738,56918,56951,46320,52659,50513,48399,44271,48466,50480,44141,50479,50513,48399,40013,27402,29515,42226,36051,38098,31694,29613,29613,35887,31661,35755,56426,46157,33708,50578,56885,56984,56885,46286,37834,42027,39882,35688,52493,52525,50412,54671,58865,56817,58930,61078,59029,58996,58964,58998,59063,61144,59096,59063,59063,56851,48398,23272,19145,19307,15178,13163,13195,13195,13195,11115,9066,9067,7018,9067,9067,9067,9067,9099,7051,5003,5003,5003,907,907,907,907,907,907,875,875,875,907,2955,907,907,907,907,907,907,907,875,2923,2955,2923,2923,875,875,875,875,875,843,843,843,842,842,842,842,255},
{28055,25975,25975,25975,28023,30071,28023,25943,23895,28023,23895,23895,23895,25943,28023,28023,25943,25943,25975,23863,23863,25943,23895,23862,23862,23862,23862,23862,23862,23862,23862,23862,25942,25910,25910,23862,36149,42226,36018,36084,19343,27632,44372,33872,31793,48631,46388,42161,40146,38001,37936,31694,33742,46517,33937,19244,33873,44405,44339,38064,40210,42324,50679,46452,48532,56851,60946,50611,46452,46484,54904,50710,50710,48630,48597,46516,44436,42356,42323,38098,38162,33969,33904,27696,33806,46254,39948,48466,54805,52724,52724,52691,52659,29581,44372,44372,23373,33807,46386,42160,35854,35854,35886,35887,35854,33807,23373,17001,27500,21195,19115,12841,17099,14889,14921,19147,37967,37967,40079,37966,44207,44174,27467,33675,33675,37901,42126,54738,54870,54805,44272,56885,48432,50512,50546,42224,50546,31628,54673,54772,46450,31759,31662,23210,31727,38098,40178,27500,29581,31694,35887,29548,44011,60554,41996,33708,52592,56885,56983,54672,33737,27432,25287,42059,48365,39881,35720,52525,60977,58930,58963,61044,58997,56819,54705,56884,52722,59030,61144,59096,59063,54770,46285,29513,21323,19307,17291,13130,13162,11114,11114,13195,11115,9067,9067,9067,9067,9067,9067,9067,9099,7051,7051,5003,2987,2987,939,939,907,907,907,875,875,875,907,907,907,907,907,907,907,907,907,875,875,875,2923,2923,875,875,875,875,875,875,875,843,843,842,842,842,255},
{28055,25975,25975,25975,30103,30071,28023,25975,25943,25943,23895,23895,23895,25943,28023,28023,25943,25943,25943,21814,23895,23895,23894,23862,23862,23862,23862,23862,23862,27958,25845,25877,25910,27958,27958,25910,29973,38164,27697,34036,21326,27631,40049,33840,31793,27535,44307,46419,46387,46355,44274,27501,31694,35953,31727,23341,33970,42292,40048,46484,48532,44372,50711,46516,46483,58899,58866,52690,40178,44372,48597,46452,44371,44371,44371,44371,46452,46452,46452,46452,46452,46484,46484,46452,44338,44239,44141,50611,54772,52724,52724,52692,50546,27565,38033,42259,35920,46484,44273,39950,27468,23372,27501,27533,25356,27468,25421,21162,25355,29581,25421,21260,23373,19212,14922,14889,23210,35854,48531,52659,40046,37933,42192,42094,33773,46353,48465,52724,54871,50578,44272,54739,46319,44174,52691,40111,48401,40046,52658,54738,35985,33839,31661,27501,31693,35887,40178,31726,29581,33839,33774,33709,52266,58441,48236,40014,50644,54870,56819,42060,37931,48398,46284,50445,42027,39914,46219,58864,61010,61044,58899,58899,50511,54672,56917,59063,56916,58965,61144,59096,48431,33739,29546,23403,19339,17291,15243,13162,11114,11082,11114,11147,11114,9067,9099,9067,9067,9067,9067,9099,9099,7051,5003,5035,2987,2955,2987,939,907,907,875,875,875,875,875,907,907,875,875,907,907,907,907,875,875,875,875,2923,2923,2923,2923,875,875,875,843,843,843,843,843,842,255},
{26007,25975,25975,28023,30103,30071,28023,28023,23895,23895,23895,23895,23895,25943,28023,28023,25943,25943,25943,23895,23863,23895,23862,23862,23862,23894,23862,23862,23862,36214,40244,33906,33939,33939,33971,33971,33939,27697,38131,34003,31825,29777,27665,33906,27632,27600,42259,48565,46452,46419,44275,33873,35920,27532,12873,17132,36083,42259,37968,46485,50710,48597,54904,54871,54904,54837,52660,48531,48531,44338,56984,50710,46484,44404,44404,44371,44371,44371,44339,42258,42258,42258,42226,40145,40113,38000,37901,48466,50611,50611,50611,50611,44371,44437,42357,38130,44306,50677,23371,29580,44175,31694,35952,33871,29646,25420,23340,23308,17034,19082,23308,27566,14953,12808,12809,12809,12841,23307,52725,54805,40014,37966,42193,44141,46287,42127,58965,59096,52725,46320,54771,52593,48366,44141,48465,48498,37966,52560,48498,52724,38098,42161,27468,38032,52626,35886,40113,31693,29613,35919,31628,44240,56459,60586,52397,44141,52725,56885,46253,37834,54737,48366,52559,46252,46187,50412,58864,58963,58964,56753,52559,50479,52623,58931,59031,59030,56949,56949,59030,54770,37963,29677,27694,25646,17291,15243,13195,11114,11114,11082,11082,11115,9066,9067,9099,9099,7019,7051,7019,7051,9099,7051,5035,2987,2955,907,939,940,939,907,875,875,875,907,907,907,907,907,875,907,907,907,907,875,907,875,875,875,2955,2923,2923,875,875,875,875,843,843,843,875,842,255},
{26007,25975,25975,28023,30103,30103,30103,28023,25943,25943,23895,23895,23895,25943,28023,28023,25943,25943,25943,23895,23862,23895,21815,23863,23862,23894,23862,23862,27990,48663,52759,48533,48500,46387,46355,46356,44274,44372,40309,38197,36051,33971,36084,36084,34003,33938,46485,54871,52791,52726,40114,27567,31726,31660,23340,29679,44470,44242,38033,48597,52823,46517,48629,40113,42226,46386,38032,35920,50644,48597,48533,38032,40145,38033,38033,38033,38033,40113,40145,40145,40145,42226,40177,40145,40113,38032,37967,40047,44305,44305,44240,42193,40211,50743,48631,40211,50644,54903,42323,25516,46515,52758,46484,44273,46386,40145,37967,35919,35887,29613,17034,10695,10728,12841,17034,12841,12809,21195,48500,52725,42192,35887,31628,31661,44305,52658,59030,56951,52691,37835,56852,52593,52657,52657,48465,52658,40013,54705,50479,44305,33839,40016,29614,48531,48400,27468,27533,29581,33774,33774,33773,46320,50252,58506,54477,50513,56885,54705,42058,52592,48399,42059,44172,50478,54637,56751,58930,58996,56851,50479,39947,48365,54738,50544,54836,54771,59030,59063,58997,40044,31626,33935,21517,17323,15243,15243,13163,11114,11114,9034,11114,9066,9067,9067,7019,7051,7019,7019,7051,7051,7051,7083,7083,5036,2955,907,940,940,940,907,907,907,907,907,907,907,907,907,907,907,907,907,907,875,875,875,875,875,2923,2923,875,875,875,875,875,843,843,842,842,842,255},
{25975,25975,26007,28055,30103,30071,30071,28023,25975,25943,23895,23895,23895,25943,30071,28023,25943,25943,25943,23895,25943,23895,21815,23862,23862,23894,23862,23862,27990,52824,52726,50613,48565,50613,50678,52726,52726,50646,44470,40277,36019,33906,36018,36018,29647,29647,46484,52758,48565,44307,42259,33905,31693,17066,29679,38001,44470,42097,40179,46484,52758,44307,38066,25486,21260,19179,21260,42291,59064,52758,38032,37999,33806,35919,33839,31758,33806,33806,33807,33806,33774,33806,33806,33774,31694,33807,42291,44339,46385,46386,46353,42192,40145,48630,48630,52823,57049,52824,38065,25452,54869,52692,44306,31759,33774,35920,37999,37999,38032,40080,38065,29614,14953,12841,19114,17066,10695,14954,27403,48432,50611,44306,31693,33839,48466,56753,54838,52757,54706,54672,54706,50511,50479,52690,54803,42159,50513,56918,54771,35952,42096,33774,35985,52724,37999,40179,31694,27533,33839,25387,44305,44207,41963,54379,42094,56917,58932,48366,46317,50446,52558,48397,48332,54606,52525,56784,58899,50479,44075,46252,44172,54705,54738,52723,59128,56950,56917,56949,56950,46383,33804,31921,19404,15275,15275,13195,13195,11114,9066,9066,9066,9034,7018,7019,7019,7019,7051,7051,7051,7051,7051,7083,5036,2987,2987,907,940,940,939,939,907,907,907,907,875,875,907,907,907,907,907,875,907,875,875,875,875,875,875,875,875,875,875,843,843,843,843,842,842,842,255},
{25975,25975,26007,30103,30103,30071,28023,28023,28023,25943,23895,23895,23895,25943,30103,28023,25943,25943,25943,23862,25943,23863,23863,23862,23862,23894,23862,23862,27990,50711,50613,50548,50581,48532,50580,50580,48500,46486,54905,38164,48664,36051,36051,38131,31727,25421,33775,35888,33840,38098,42324,42356,35919,10825,33905,33840,44437,37871,44437,48629,48597,35920,33904,29679,23341,19179,23438,42259,50645,52725,54838,54870,54903,54838,52757,50644,48531,46419,44338,42225,40112,38032,37999,35918,33774,37999,48630,50677,44305,46386,46353,44273,40080,46452,48598,50678,52758,50711,50710,40145,54837,40113,33808,44371,44370,46418,46418,46353,44273,37966,37966,37999,35919,21292,17034,23340,12840,8582,14889,33741,40046,42160,40079,44272,48302,56786,50611,50546,48431,58964,52592,50446,50512,48498,52659,42126,54608,50545,44370,33904,43851,31564,48629,50578,38065,35888,31726,31693,27632,21260,52692,50578,39883,42028,42127,52658,42060,46285,50478,50380,46220,44107,41994,52558,58864,58930,54704,42059,52657,54704,56883,54738,56950,59064,59031,59063,59063,56983,56918,42125,33902,27791,17356,15275,15275,15243,13195,9066,9066,9066,9066,6986,7018,4971,7019,7019,7051,5003,4971,7019,7051,2955,907,2987,2987,939,908,940,939,907,907,907,907,907,907,875,875,875,907,907,907,875,875,875,875,875,875,875,875,875,875,875,843,875,875,875,843,843,842,842,255},
{25975,25975,26007,30103,30071,28023,28023,28023,28023,25943,23895,23895,23895,23895,30103,27991,25943,25943,25943,23894,23895,23862,23863,23862,23894,23894,25942,25943,25910,48696,54839,52758,52791,52758,54806,52759,50678,46550,52857,42325,48599,27632,23569,31793,35920,27566,27534,27534,31792,35953,33905,31857,33808,23373,33840,35953,40082,33710,44469,48630,44371,50645,40211,40146,40145,38000,35953,38098,44404,40048,46419,56983,59064,59064,59064,61144,61144,61144,61144,61144,61144,59064,48499,48498,50579,44273,44371,46451,46418,46418,46386,44305,40047,44339,38000,42193,46484,54904,57017,52823,54870,44404,31825,33807,46353,56853,54805,44240,40013,37901,35788,35788,33708,29581,23340,21162,21130,17034,14921,12808,14824,18985,31628,46319,52560,52593,50578,42159,54706,54673,48334,50446,50545,54804,52757,50513,48334,50545,35984,37837,29127,21162,48564,48466,46518,31759,44437,35887,23504,33840,59031,48465,44304,42224,50545,39947,39979,44140,37834,37801,48268,44139,50446,54670,56817,58931,58964,54769,58964,61143,59063,59063,59063,59031,59063,59063,59064,59030,50545,40110,31920,21517,19469,15275,13195,13195,11147,9067,9066,9034,7018,7019,4970,2923,2923,4971,7019,4971,4971,7019,2955,907,907,907,939,939,939,939,940,940,939,939,907,907,907,907,875,907,907,907,875,875,875,875,875,875,875,875,875,875,875,843,842,875,875,843,842,842,842,842,255},
{25975,25975,28055,30103,30071,28023,28023,28023,28023,25943,23895,23895,23895,25943,32151,27991,25943,25943,25943,25943,23895,23862,23895,23894,23895,25943,25943,25943,25942,36279,40407,42455,44535,46583,46615,48664,48663,42292,50678,46551,38197,25585,27794,35985,40178,46517,46485,44371,38132,44404,27567,25518,35953,23372,40178,33841,31695,33808,40178,40113,48564,46451,48663,42291,38065,42258,38131,42291,52758,38033,27501,42128,46386,48532,46386,46386,50547,48435,44274,46387,48499,50580,31727,48531,37967,25419,33741,44273,46353,46353,46353,46320,40047,44372,33774,48466,48630,59097,59130,61210,52758,52759,52791,44305,50513,54805,59064,54904,42225,31627,31595,31628,29515,25354,23274,25322,21194,19180,23308,23210,19049,19049,27435,35821,46287,46288,48368,52625,52560,46287,44272,50545,52657,54836,50578,40013,48465,33806,37967,41966,25160,31563,39982,50579,44372,40178,44371,35886,27533,46484,56951,54772,42257,50545,48302,40013,37834,37801,29448,35721,52558,58930,61076,61077,61110,61077,61077,58996,59063,58998,54771,54836,59031,59096,59095,58998,56884,48398,37865,33837,25711,19501,17388,15275,13195,13195,11147,9067,9066,9066,7018,7018,4971,2923,2923,4971,4971,4971,2923,2923,2955,907,907,907,907,940,940,940,940,940,940,940,940,907,907,907,907,907,875,875,875,907,875,875,875,875,875,875,875,875,875,875,842,874,875,842,842,842,842,842,255},
{25975,25975,28055,30103,28023,28023,28023,25975,28023,25943,25943,23895,23895,23895,32151,27991,25943,25943,25943,23895,23895,23862,23895,25943,25943,25943,25943,25942,25943,23862,23862,25910,25942,25910,32086,36018,36051,44243,50417,52759,38164,33971,31858,36084,44470,54904,52823,50710,42324,38034,25454,19180,29647,29646,38033,27534,33840,35921,33808,33807,48565,50742,57017,54970,52889,46518,27567,35953,37968,38001,23340,35821,42193,46419,44273,42127,40014,37869,31628,29515,27403,25355,27631,38033,42225,40080,37999,48466,48498,48466,48466,46385,40080,42259,31694,52659,50645,52725,59065,56984,52725,52759,52823,52691,56852,54805,59097,56985,57016,44239,39948,37900,35788,35755,31627,25354,23339,23307,19114,19050,25323,23210,21162,19114,19147,19050,21130,21097,19049,23275,27435,27402,33675,37836,33643,42094,35853,38031,42062,33676,46091,54349,43949,33742,25420,33807,35887,33774,35919,52823,52724,50545,42126,44108,35788,42159,41995,50445,44106,54638,61011,61078,61077,61078,61077,61078,56884,56884,56916,44172,52625,59063,59063,59063,59031,54835,54705,52656,35850,23403,17356,17453,15340,13227,13195,11147,11147,9067,9067,9066,7018,7019,2923,2891,2923,2923,4971,2923,2923,907,907,907,907,907,940,940,940,940,940,940,940,940,940,907,908,907,907,907,907,907,907,875,875,875,875,875,875,875,875,875,875,875,842,842,842,842,842,842,842,842,255},
{25975,28023,28055,30103,28023,28023,28023,25975,28023,25943,25975,25943,23895,25943,32151,25943,25943,25943,25943,25943,25943,23862,25943,25943,25943,25942,25943,25943,25942,25942,25942,25942,25942,25942,34166,50677,50710,48240,48142,54870,48532,35856,44404,46485,48630,50678,50678,48664,46485,42227,29680,21293,17132,33873,25388,21194,23243,23211,21195,21162,38098,50711,52824,54969,42325,35986,25486,14954,27598,35984,44305,35853,35887,46387,44273,42160,42127,35854,37902,35821,31628,27468,23341,35919,44273,38000,35887,35790,35659,33741,35822,33774,35919,38098,31758,52692,46484,52790,48531,52758,50645,48598,54904,50611,56819,54772,54839,48500,59097,59064,39948,37868,35755,37868,37836,31594,31660,31628,19082,19082,21098,23112,19049,19082,14954,16905,19050,12776,12776,12776,14889,25421,16969,19049,27370,37869,35854,31595,29547,33675,39850,48109,50352,23340,27533,29613,35919,29581,44371,52790,42160,50578,39948,27368,29481,35786,44140,56752,56817,58963,61078,61077,56785,48333,52559,52591,48398,46252,46285,48464,59063,57015,56950,59030,59030,59030,56883,46350,25450,21452,15275,17453,17420,13227,13195,11147,11115,9067,9067,7019,4970,4971,2923,2891,2923,2891,2923,2923,2923,875,907,907,907,939,940,940,940,940,940,940,940,907,939,940,939,907,907,907,907,907,907,907,875,875,875,875,875,875,875,875,875,875,842,842,842,842,842,842,842,842,255},
{28055,28023,28023,30103,28023,28023,30103,25975,28023,27991,25975,25943,25943,28023,32151,27991,25943,25943,25943,25943,25943,23862,25943,25942,23894,25942,25942,25943,25943,25942,25910,23862,25942,25942,25942,30038,36246,44079,50352,54805,40146,31792,44371,46517,48630,50678,46518,44405,40146,38131,33906,25422,27632,31793,27468,21162,23242,21130,19082,21066,29614,44437,42356,42259,36018,33938,33905,36050,46484,48532,52693,40079,40112,42160,37967,37935,35887,25420,31693,27500,25420,23405,19147,38000,42193,33742,33807,37936,29321,27436,21163,19082,29679,35986,29581,50612,48631,52824,54871,56984,50645,46484,50645,52659,52659,40079,31661,37966,56984,61145,35788,37901,29515,31628,31563,25322,31693,29548,16936,19049,21032,20967,21129,16969,16969,16969,17034,14954,14889,12776,12776,14921,21195,25518,21162,25257,37901,27466,42126,44239,35787,42094,42225,27501,29613,31661,33741,31661,52758,46386,44305,48399,33674,35754,39947,33673,44205,52559,54672,48366,48430,52591,44139,46285,54737,50511,42059,44171,50544,56885,59064,59063,59063,59063,61143,58997,46383,27628,19339,17356,15275,17421,17485,13227,11147,11147,11115,9099,7019,7018,4971,2923,2891,843,843,843,843,875,875,875,875,875,907,940,940,940,940,940,940,940,907,907,939,940,940,940,939,907,907,907,907,907,875,875,875,875,875,875,875,875,842,842,842,842,842,842,842,810,810,842,255},
{28023,28055,28055,30103,28023,28023,30103,25943,28023,28023,25975,25943,25943,28023,30071,25943,25943,25943,28023,25943,23895,23895,25943,25942,23894,23862,25943,25910,23830,23862,23862,25942,25942,27990,25942,27925,36052,40212,40146,38066,36019,27631,33808,48598,52725,52791,52889,46549,38065,36051,44405,44373,29648,21326,23340,23340,23308,19147,17067,17035,17067,12906,21260,21260,44438,42357,44405,46550,44437,54870,56984,52725,54773,52757,52692,50579,48498,46386,42160,35822,31759,21293,25453,29581,25388,25356,29647,37871,25161,23275,23243,23243,31727,35953,31693,48564,50645,54904,56984,50613,38032,52725,48465,50513,52790,35952,33773,37934,54871,54838,44141,42028,40014,40112,35887,27435,27468,27435,23242,21162,19049,19016,21130,25388,19114,14856,16969,14953,14921,12776,14889,12809,12776,19082,17002,17034,31596,33740,46320,50545,48498,44338,40112,27533,29613,35887,31693,25387,44273,54837,59030,42093,40012,33673,44238,42092,48398,50511,46252,44172,44204,50510,52689,56851,56819,54770,42091,40011,50479,52690,59064,59063,59096,61143,54771,37998,27694,23533,19404,15275,15275,15372,15372,11147,11115,11147,9099,9067,7019,7019,4971,2890,843,843,843,843,843,875,875,875,875,907,908,940,940,940,940,940,940,940,907,907,907,939,940,940,939,907,907,907,907,907,875,907,875,875,875,875,875,875,875,875,875,874,842,842,842,810,810,810,255},
{28055,28055,28055,30103,28023,30071,30103,28023,28023,25975,25975,25943,23895,28023,30071,25943,25943,25943,28023,27991,25943,25943,27991,25943,25942,23862,27991,29973,23699,25780,25780,25812,25812,25812,25812,31989,33971,40245,40147,33873,21326,19311,23374,27567,44437,46452,50744,46518,38228,44470,44470,46485,19278,13004,12972,27697,31891,17165,15019,21293,12906,10794,14954,17132,27632,31761,33872,48598,44404,61177,52693,44240,48531,40145,44273,46353,42225,42192,37901,31694,29614,12874,23340,23340,21195,21227,27436,29289,23113,21195,21130,23275,21228,21260,31629,37903,35822,50645,59097,44339,35952,52691,48432,39981,46484,48531,42126,42159,56918,58964,50414,48431,44305,44371,50678,42258,29515,29548,27467,25355,25387,25323,23242,23242,23275,14856,14823,14888,16936,14856,14857,12776,12776,12776,12808,19115,33872,33840,23210,42094,48498,40145,35855,29581,31694,35854,27533,25517,44305,52659,54706,42060,37802,31561,37867,37834,46253,52592,44139,44139,48333,52591,56883,52624,54770,56884,48464,50610,56950,59096,59129,61177,59063,48530,23402,17259,19372,19404,15275,13195,13227,13227,11211,11147,11114,11115,9067,9099,7019,4971,2923,2890,843,843,843,843,843,843,875,875,875,875,908,940,940,940,940,940,940,940,907,907,907,940,940,940,939,907,907,907,907,907,907,907,875,875,875,875,875,875,875,842,842,842,842,842,842,842,810,810,255},
{28055,28055,28055,30103,30071,30103,30103,28023,28023,25975,28023,25943,23895,30071,30071,25943,27991,28023,27991,28023,25943,25943,25943,25943,25943,23862,30038,46583,44503,42423,42390,40310,38262,38229,36149,33971,42356,44437,46518,38131,19278,21391,25519,35953,29680,21326,46583,29713,44470,46453,44405,40277,23439,15052,15117,17197,17165,15085,21293,27534,14954,17100,21325,23405,19180,19213,19179,44405,52791,59065,52693,44240,42290,44404,37999,46549,31824,25388,29581,23308,21325,23406,29614,21227,21195,21195,25226,27273,25226,19017,19017,19017,16969,16969,17002,10696,6567,38065,59064,35952,40177,59031,58998,46320,40047,48433,48367,52625,59031,44174,37900,38032,44371,40113,46451,48532,44241,29548,25355,25322,25323,23275,21162,21162,19081,19017,16937,19114,12743,14824,16969,14889,17034,14889,12776,14889,27468,31694,19049,25323,46484,40277,31726,29581,33806,31694,23340,44370,44271,46286,52527,39914,35689,50413,42027,46220,46253,48300,44204,39979,39946,48333,52559,52591,54705,54803,48431,59063,59097,59096,59096,56951,33806,21388,13065,17291,15243,15275,13195,13195,11147,11147,11179,11147,9034,9067,9067,7019,5003,2923,843,843,843,843,843,843,843,843,875,875,875,875,908,940,940,940,940,940,940,940,939,907,907,908,907,940,939,939,907,907,907,907,907,907,875,875,875,875,875,875,875,842,875,875,843,842,842,842,810,842,255},
{28023,28055,28055,30104,30071,30103,30103,28023,28023,28023,28023,25975,25943,30071,28023,25943,28023,28023,25943,28023,25943,25943,25943,25943,23895,23862,23602,46518,50744,50744,50744,50744,50776,50712,42358,31858,44437,44405,42357,36019,29712,27664,25552,31793,19245,21390,40309,29745,31793,36019,31793,29713,29777,21390,19278,19245,17133,17165,31694,25356,10761,14954,19212,17100,17100,17100,19180,46550,54904,56984,52692,44240,48597,48598,44273,50743,33872,31726,29614,27565,17099,19147,27501,14954,12841,12776,16969,17002,16937,16937,19017,21130,25193,18952,16905,14889,17099,42390,42259,29450,44208,54805,52757,46385,40046,40014,46352,52659,59031,37868,35853,23437,33970,42291,35919,42161,48531,46418,44239,42159,37965,35821,31692,29547,27435,25322,23242,23275,16969,10631,19082,21228,14921,17066,14922,12808,21195,27468,27500,27565,44307,40113,31694,29581,35887,27501,23307,46450,46287,46253,50413,42027,33577,35689,27304,35689,39882,39882,44140,44107,46252,48333,50478,56851,59030,56949,54803,59063,59064,59030,56851,46286,23273,19340,15178,15178,15243,13195,13195,11147,11147,11147,11147,9067,9066,9067,7019,4971,2955,875,843,843,843,843,843,843,843,843,875,875,875,875,908,940,940,940,940,940,940,939,940,907,907,907,907,907,907,939,939,939,907,907,907,907,907,907,875,875,875,875,874,842,875,875,874,874,842,842,842,810,255},
{28023,28055,28055,30103,30071,30103,30103,28023,28023,28023,28023,27991,25943,30071,28023,25943,27991,25943,25975,28023,27991,25943,25943,25943,23895,25942,34036,48631,46550,44470,46518,46519,46551,42357,4684,10957,36019,27665,34003,46518,36115,25551,21358,27664,25519,36083,44438,27664,29648,31695,35985,42291,36051,36019,31890,31890,33938,38099,31727,27534,12874,17099,27664,25583,27632,25551,23406,40211,52758,54871,52692,54772,52790,52692,52659,46483,46418,42193,17100,19245,15019,25420,23275,19083,17002,12809,10728,10728,10696,12809,17067,29581,42062,16969,12744,14792,12873,38196,36018,31628,33708,50677,46517,54870,54837,44370,42291,38065,31792,29711,29711,27599,29712,27631,33904,31758,46419,50579,52626,54673,54673,54673,54640,52592,52592,50511,42061,27435,19082,12776,10728,14921,17002,14888,14888,12808,14889,23307,31629,33806,35887,33742,29613,31694,31694,27435,29515,42127,29481,39915,39915,41963,33609,37834,35722,41995,42026,41995,44107,48300,46252,52559,54704,56851,56852,52625,54771,58998,58998,54770,40045,21095,23436,17324,13162,13162,13163,13163,13163,11147,11115,11147,9066,9066,9066,9067,7019,4971,2955,875,843,875,875,843,843,843,843,843,843,843,843,875,908,908,940,940,940,940,939,939,940,939,939,907,907,907,907,939,939,907,939,939,939,907,907,875,875,875,875,875,875,875,875,875,874,874,842,842,842,810,255},
{28055,28055,30103,30071,28023,30103,30103,28023,28023,28023,28023,28023,28023,30071,27991,27991,28023,25943,28023,28023,28023,25943,25943,25943,25943,27990,42390,50711,42357,40212,40212,38164,38196,36084,8844,6829,13070,8908,19375,38197,38197,38197,36051,36083,46517,46518,46551,36083,35986,42097,42292,38163,27696,27632,25551,23471,21390,29712,31759,35920,21260,21292,25551,25518,25519,21293,19212,38098,40146,40210,44305,42161,44240,48369,48400,50512,48433,38000,29712,27632,21358,40112,33774,25355,23275,19115,17001,16969,14889,12841,14954,25388,33774,29581,17001,14986,14922,19180,44471,46583,44404,46485,46549,54838,52757,50677,48630,42324,31824,25486,25551,27599,25519,27599,25550,27599,27566,29646,29646,29646,31662,29613,29613,31660,33741,33740,27402,19114,21195,19147,19114,14889,19114,19082,21130,14856,14921,27468,31661,37967,31693,25388,27533,31694,25420,27337,31628,27435,25354,35755,16935,23176,33674,42060,31562,33609,44107,46187,50445,50413,54639,50445,54672,48398,39946,48366,56850,56851,52657,48464,46351,19113,19211,17356,15211,13195,13162,13162,11114,11147,11114,9067,9066,9066,9066,7019,5003,2955,875,875,875,875,875,875,843,843,843,843,843,843,843,875,908,908,940,940,940,940,907,940,940,940,940,907,907,907,907,907,939,940,907,939,939,939,907,907,875,875,875,875,875,874,875,875,874,842,842,842,810,810,255},
{28055,28055,30103,28023,28023,32151,32151,28023,28023,28023,28023,28023,28023,32151,28023,27991,28023,27991,28023,28023,28023,25943,23894,25943,25942,30070,48631,46551,40212,36084,36116,38196,42292,38132,17198,15247,17328,13167,27729,36083,34035,38197,42357,40212,36018,48631,46551,44438,42390,46518,44372,33970,42357,36083,36083,36083,38131,25551,23373,40081,29646,35985,52856,50776,44404,29679,31792,35985,31727,35952,38000,23373,35818,41931,44041,46186,25388,25422,23374,23406,19212,42225,42160,33774,17001,19082,17002,16970,17002,17002,17034,16970,14889,14889,6567,19212,27631,14986,25487,48663,57049,46517,48630,48531,50611,52725,56951,50710,44404,33937,27663,27599,27599,25518,27599,25551,27599,25550,25551,25518,25518,23438,23405,23373,21292,21260,21227,21195,19115,19147,21259,19147,14888,12776,21162,25355,21161,40014,44273,33774,19146,25421,29646,27566,23209,27369,46385,40047,33740,40013,31562,33707,39948,46253,33642,39915,44140,50479,46286,52592,46253,48366,46286,44172,44139,50446,46286,44173,42092,40045,42125,31659,10856,15243,15243,13195,13162,11114,11082,11114,9067,9067,9066,9066,7018,7019,2955,875,875,875,875,875,875,875,875,843,843,843,843,843,875,907,908,907,908,940,940,907,939,940,939,940,940,939,907,907,907,907,939,940,939,939,907,939,939,939,907,875,875,907,875,875,843,843,875,842,842,842,810,810,255},
{28055,28055,30103,28023,30071,32151,32151,25975,28023,28023,28023,28023,28023,32151,28023,28023,30071,28023,28023,28023,28023,23894,23894,25943,25942,27990,42455,54905,44470,42357,40277,40276,40244,38164,36083,25616,19375,13102,34003,42390,40309,46550,54904,44405,34003,46551,46550,44437,40342,50776,48564,33938,31825,31825,36050,31825,29745,12972,19212,35952,27468,38001,46485,46485,44306,44339,35985,46452,46419,33775,44405,46518,48431,48202,52459,46318,29614,25421,21227,17002,17001,44274,46387,42226,19114,19082,17034,14921,14889,16969,17067,14954,14857,8616,4487,8648,23373,25453,12906,31792,54904,48597,50677,42257,42290,50645,54870,50710,46484,46451,40243,31857,23405,29712,27599,27631,27599,27599,27599,27566,25518,25486,25485,25486,25453,23373,23340,23340,21260,19179,19179,23340,21227,14921,10728,17001,25388,37902,48499,35855,25420,27533,33872,27631,21096,35755,50545,35853,37900,37900,29449,37802,37835,37868,25256,39980,46253,52625,56819,50447,44172,46253,54738,50511,50478,50511,37866,37899,42092,33771,37964,21160,12937,17356,15243,13195,11114,11082,9034,9034,6986,9066,7018,6986,4938,4970,2923,875,875,875,875,875,875,843,843,843,843,843,843,843,875,875,907,907,940,940,908,907,939,940,940,940,940,940,940,939,907,907,939,939,939,939,939,907,907,939,907,907,875,875,874,874,842,874,875,874,842,842,842,842,255},
{30104,30103,30103,28023,30071,32151,30103,25975,28023,30071,28023,30071,28023,32151,28023,28023,28023,30071,28023,27991,28023,25943,25942,25943,25942,25942,40375,54905,54937,56985,54937,54937,54937,54937,54905,52856,46582,31923,42390,46583,44503,46583,50646,38066,40309,48566,46486,46518,40212,50711,52758,46452,42291,40178,42226,33840,25486,21325,21358,38099,23276,21228,31759,38032,42193,40178,38099,42258,44372,35920,42260,46518,46158,54410,54572,40079,38065,29613,25388,23275,35887,48433,37999,40178,23243,21195,21195,21195,21195,21163,21195,21163,19114,12841,4454,6567,14922,31792,21292,17099,40179,44404,52790,52724,48531,50645,46418,46517,40178,50710,50743,44436,31824,44437,33937,38163,36017,33905,33937,33937,29711,29776,29743,27598,27598,27566,25453,25453,23373,23340,21260,21195,25388,25485,23307,14953,23307,35919,44273,37967,29614,29613,33839,21195,16903,23242,44271,29514,33642,33707,25289,27369,16903,14823,19015,23176,31529,33641,37835,37834,37867,46318,46285,48333,54672,50478,50510,46350,42157,37932,21128,8582,15082,19437,15275,13195,11114,11082,9034,9002,6954,6986,7018,4938,4938,4938,2922,2923,875,875,875,875,875,843,843,811,843,843,843,843,875,875,907,907,940,940,908,940,939,940,940,940,940,940,940,940,907,907,939,939,940,939,939,939,939,939,907,907,875,875,874,874,874,874,874,874,874,842,842,842,255},
{30104,30103,30103,30071,30103,30103,30103,25975,28023,30071,28023,30071,30071,32151,28023,28023,28023,27991,25943,28023,28023,23895,25943,25943,25943,25943,32119,34199,34199,36246,38294,38262,40375,40407,44471,46487,44503,40310,46583,46550,44470,44470,42358,44437,46517,44469,44404,50613,44437,42292,54871,52758,52758,50678,48565,40146,33872,38099,23471,29712,38066,23438,15019,19180,27501,35952,48663,50678,40212,46386,46419,50646,44142,54573,52525,31694,40113,33741,29580,29548,38032,52626,48465,35887,21130,19114,19115,21163,21195,21163,21163,21163,19115,12809,4455,8648,8680,23373,31792,15019,31759,48597,54837,56917,42192,48598,46485,40145,33872,52856,46550,31791,25518,38098,29711,36017,36018,35985,38098,40211,38098,38163,40243,38131,40243,40243,38098,38131,38098,33904,35985,33904,25420,46485,29646,38065,21162,46451,44305,37967,29613,33774,31694,19081,23242,35886,42159,21161,35755,44206,29514,29579,25353,25321,35819,35786,42059,48430,35819,37866,48398,52624,42092,37866,42059,54737,52591,54737,48496,44270,48530,25386,27598,29905,17291,15243,13163,9066,9002,9002,9034,6986,7018,6986,4938,2890,2890,875,875,875,875,875,875,875,843,843,843,843,843,843,843,875,907,908,940,940,940,940,940,940,940,940,940,940,939,907,907,907,939,939,939,939,907,907,907,907,907,907,907,907,907,874,874,874,874,874,874,842,842,842,255},
{30104,30103,30104,30071,30103,32151,30103,25975,28023,30071,28023,30071,32151,32151,28023,28023,28023,28023,25943,28023,28023,23895,25943,25943,25943,25943,25943,25943,25943,25942,36214,25650,19441,19442,31956,27730,23569,36116,48664,44503,44502,46550,38164,38098,48597,48630,50646,48566,50711,35953,38033,46452,42291,44339,44339,35953,31824,40179,31825,19213,21293,23374,17067,27599,38164,36083,40211,42324,40146,35920,40113,40178,35952,33806,31726,21260,29646,29646,25388,25388,29516,39949,35854,31661,25322,23242,23178,23210,23275,21130,19049,19049,16969,10696,8615,12841,23405,10728,29647,29679,17067,35920,46419,48564,40211,44404,40211,29679,44470,48565,44436,33905,15019,36083,23438,33937,31824,27598,25550,29711,27566,25518,27631,25518,27598,29679,27598,29679,33872,31792,33872,38065,33839,46517,27598,38065,25420,46419,46386,35886,29613,35887,27501,16936,33773,48465,31628,23176,33610,44174,46319,33771,33707,44173,48367,50446,44140,37835,31561,39914,48398,46253,44140,48431,54770,58964,52591,54770,54803,52690,54803,35819,29612,38195,19339,15243,13195,9034,9002,9034,9034,6986,7018,4906,4906,4938,2923,875,875,875,875,875,875,875,843,843,843,843,843,843,843,875,907,908,908,940,940,940,940,940,940,940,940,939,940,940,907,907,907,907,939,939,907,907,907,939,939,907,907,907,907,907,874,874,874,874,874,842,842,842,255},
{30103,30103,30103,30071,30103,32151,30103,25975,28023,28023,28023,30103,34231,32151,28023,28023,28023,28023,25943,30071,28023,25943,25943,25943,25943,25943,25943,25943,25943,27991,40278,27665,17360,11022,36051,31890,36116,33939,40277,40309,36116,33938,36051,35953,33872,40113,42129,40081,46550,46453,29680,40211,29647,33807,31727,29614,31760,38132,29744,23406,19147,14954,8681,31825,52889,42357,31857,31792,27631,27696,31824,29712,27631,27631,25486,25486,25486,25453,23373,25485,25453,23405,23470,25453,25420,25420,25388,27468,27468,27500,27468,29516,27468,10728,8615,14889,23341,6535,14954,35953,23373,14954,38097,40145,48663,48631,42357,44469,50776,27501,44436,36018,29712,42389,33937,40211,38098,33872,36017,38130,36018,33905,35985,27631,31824,33937,27598,29711,31792,27598,27598,29711,25453,42292,31791,31759,27435,35887,42160,33774,31693,33839,23308,14824,31660,40014,27435,21064,33642,31562,37867,37900,31626,31561,33642,31529,29416,35689,42060,42092,50512,42059,48333,56817,58931,48431,48431,54804,56949,59063,46385,21095,31725,40276,19275,15211,13195,11115,9034,9066,6986,6986,6986,4906,4906,4938,2923,875,875,875,875,875,875,875,843,843,843,843,843,843,843,875,908,908,940,908,940,940,940,940,939,940,940,940,940,940,940,939,907,907,907,939,907,907,907,939,939,907,907,907,907,907,907,874,874,874,874,874,842,842,255},
{30103,30104,32151,30071,30103,32151,30103,28023,28023,28023,28023,32151,34232,32151,28023,30071,30071,28023,25943,28023,25975,25943,25943,25943,25943,25943,25943,25943,25943,25942,40278,40212,23472,23569,38228,36051,29843,19441,38229,40277,38196,31792,29680,40179,42226,42193,42160,38097,46550,38066,35953,29712,38131,38033,38033,31694,35953,46518,42259,29646,27566,25518,25551,42389,57017,40277,38132,29745,29745,31825,29745,29712,29712,29777,31825,29744,29712,27664,27631,29679,29679,25583,27663,25518,23406,21325,19212,17132,17132,17132,14986,19212,15019,10793,6535,8648,10729,8680,6567,27599,38066,23373,38097,40178,50743,52856,48630,54970,48630,33937,46517,21324,12938,36018,25550,29712,33905,29679,29711,35985,29711,29711,35985,31791,33872,40178,33872,35984,40146,33872,38065,42291,35920,38098,36017,25453,25355,37999,42192,31693,31726,29613,21162,12743,25387,27434,25257,18983,35723,29482,37835,46253,40012,35787,29417,31529,44140,44107,41995,50478,42027,48333,54705,50413,46253,42059,54803,59063,56983,56917,37900,19080,25387,33872,25582,15211,13227,11114,9067,9066,6986,6954,6954,4906,4938,4938,2923,875,875,875,875,843,875,875,843,843,843,843,843,843,875,908,908,907,908,908,940,940,940,940,940,940,940,940,940,940,940,939,907,907,939,939,907,907,907,939,939,907,907,907,907,907,875,874,874,874,874,874,842,842,255},
{30103,32184,32152,30071,32151,32151,30103,28023,28023,28023,28023,32151,34232,32151,30071,30071,28023,28023,25943,30071,25975,25943,25943,25943,23895,25943,25943,25943,25975,25942,36279,38262,29746,32021,50744,50743,38261,36148,46583,44470,40309,38098,25486,44437,50644,50612,50612,46517,40244,33840,33743,31825,50744,44372,38066,25389,25486,38066,40114,27599,23308,29679,31760,50743,57049,44470,40277,31825,25518,27566,25583,25486,25518,27599,29711,29712,36018,33938,31793,27632,31825,31858,33938,33906,33906,31857,29680,29712,25551,25583,25551,25519,23439,21325,15052,8681,6600,8712,6599,29712,35985,33872,35919,38032,48631,50743,48630,54970,50743,42324,48663,36017,35985,36050,38098,33937,38131,38066,33872,36018,33937,29711,33937,31824,27599,33905,29679,27598,33872,29678,27566,35953,33840,33937,40145,19114,23307,29646,33872,29613,33774,27500,14856,12743,29613,33839,16936,16936,33642,27369,33642,42027,39882,35722,35754,42027,52461,41962,37834,52559,52559,52624,52592,39914,39947,56916,54902,52723,56917,56851,37866,27467,31791,38130,27695,15243,15275,11115,9067,9099,6986,6954,6954,4906,4938,4938,2923,875,875,875,843,843,875,875,875,875,875,843,843,843,875,908,908,908,908,907,940,940,940,940,940,940,940,940,940,940,940,940,939,939,939,907,939,907,939,907,907,907,907,907,907,907,875,874,874,874,874,874,842,842,255},
{30103,32183,32151,30071,32151,32151,30103,28023,30071,28023,30071,32151,34200,32151,32151,30103,28023,28023,25975,30103,28023,25943,25943,25943,25943,25943,25975,25943,25943,25942,23894,27958,33938,19473,27859,38229,36181,46583,52856,46615,44470,46484,46517,48597,48564,50612,48467,48533,40179,38000,31662,40179,52759,50678,35985,27566,21261,40147,42194,38066,25421,27534,27533,52856,57017,38099,40277,38132,27631,25486,25518,25518,25518,25518,23437,23405,31825,33938,31824,21293,23340,23406,23405,25486,33938,31858,23470,19212,17132,17132,19180,19212,17132,17100,23438,15052,8648,10761,8680,33905,35952,23276,19081,35984,59195,42324,44437,57017,50744,38130,50743,25518,23405,29744,31825,25486,31824,31824,25518,31792,33905,29647,31824,33937,31760,35985,36018,33904,36017,36018,33904,33905,40243,31727,42258,21162,23307,36018,33872,29613,25420,17002,12775,19049,38098,31695,14791,19016,25257,18984,25321,27369,25224,37802,52558,48268,46187,41994,46253,54705,56784,54704,52559,44172,54770,59030,56917,56884,56883,56850,33739,31758,48663,38228,19404,15307,13227,11147,9034,9067,6986,6954,6954,4938,4938,4938,2923,875,875,875,875,875,843,875,875,875,875,843,843,843,875,876,908,908,908,908,940,940,940,940,940,940,940,940,940,940,940,940,940,939,907,907,907,907,907,907,939,907,907,907,907,875,874,874,874,874,874,874,842,842,255},
{30104,32184,32151,30103,32151,32151,30103,28023,30103,28023,30071,32151,34200,32151,34200,32151,30071,28023,28023,30103,28023,25943,23895,23895,25943,25943,25975,25943,27991,25942,23894,25877,29810,21619,32086,17327,21521,46583,48631,44503,42293,42291,56984,57049,57016,50677,44274,40211,48597,54805,35953,33873,35888,42226,36017,29712,31760,38066,44372,44372,33840,31792,31792,54937,50743,38130,46550,42357,33971,31890,31890,31890,33970,31858,31857,31857,29744,33970,33971,33906,29712,31857,31825,27631,31857,31825,29777,19212,17132,17132,15019,14986,15052,12939,17100,21391,12874,8648,10793,35984,33807,16969,27468,42290,59163,48598,52824,54969,48631,40211,44437,21293,40276,38131,42357,38130,38163,40211,36050,36050,38131,33905,33937,38098,29711,31824,33904,27566,29711,31792,27598,29679,42324,27631,31791,14888,12808,25420,35951,44240,44272,33805,25386,27434,25355,12840,12743,12743,14823,14855,23241,29450,25289,29449,44141,44139,50413,50511,56818,52591,50445,52526,52558,54704,58964,56916,56883,58964,58931,48398,31725,46583,44534,23533,15243,15275,13227,11147,6986,9034,6986,6954,6954,6986,4906,4938,2923,875,875,875,875,875,875,875,875,875,875,843,811,843,843,875,876,908,908,908,940,940,940,940,940,940,940,940,940,940,940,972,940,939,907,907,907,907,907,907,907,907,907,875,907,875,874,874,874,874,874,874,842,842,255},
{30135,32184,32151,30103,32151,32151,30103,28023,30103,28023,30071,30103,30071,32151,34199,30071,30071,30071,30103,28023,25975,25943,23895,23895,25943,25975,25975,28023,28023,25975,25943,25943,30070,30070,27990,30038,23601,38261,46584,23504,25519,40244,50776,46517,48467,38033,31727,40211,50645,54805,46485,38033,33710,37999,38065,35920,38066,29647,42291,40179,31792,31792,35986,54904,54904,54937,52824,40277,29809,21357,23438,23438,23470,25584,25583,25519,25551,27631,29680,31760,31792,31793,33905,31825,33905,33905,31825,31857,29712,29744,27664,25519,25583,23470,21358,27632,19213,8648,14986,33839,27501,14889,33774,48597,57083,52857,50776,52856,46518,36083,40276,21325,42389,33937,44437,40211,36018,40211,40243,36018,40276,42292,36050,42324,42291,36050,42324,40243,38130,42291,40211,35985,46550,27663,42389,25420,14888,42160,52659,52561,52625,50578,35853,25321,19049,10727,12807,10727,12775,16968,23209,23240,35755,48365,50446,44140,46252,56818,56851,56817,56785,54704,58898,58931,56851,56884,54770,44205,46286,44205,33839,50776,36179,17324,15275,15275,13195,11147,7019,6986,6954,6954,6922,6954,4906,4938,4939,875,875,843,875,875,875,875,875,843,843,843,843,843,843,875,876,875,908,940,940,940,940,940,940,940,940,940,940,940,972,940,940,939,907,907,907,907,907,907,907,907,907,907,907,907,907,907,875,874,874,874,842,842,255},
{32184,32184,32152,30103,30103,32151,30103,28023,30103,28023,28023,30071,28023,34199,34199,30071,30071,30103,30103,28023,25975,25943,23895,23895,25943,23700,21619,21587,23700,23732,23700,25812,25812,25877,23797,27925,27697,48663,42390,17165,23471,44438,48663,44437,40080,33873,21261,29647,50645,54805,52692,52661,44176,40112,35790,33774,29647,38163,40211,33873,29679,27566,33872,48598,54969,48631,46517,48663,46583,33970,34035,33970,31857,34067,31922,27664,25551,27728,23438,23470,25583,17164,21357,23503,21324,19245,19245,19244,21293,21325,21325,21293,23373,23406,23406,23406,17100,8616,19147,31759,25420,14953,23307,52823,52889,50809,50777,52856,40211,38131,44469,27566,38163,29712,38099,36018,36018,38098,40179,36050,38163,42292,38099,40211,42292,38098,40243,42292,38098,40211,42324,27599,42356,29712,54937,27500,25322,42225,42126,52691,48498,50578,33772,23209,23242,19049,25321,21161,31627,29546,29481,35819,35754,44108,44108,33641,39947,50446,50446,52625,44140,48333,56818,56884,54771,56884,54803,54770,54704,39979,35983,48663,32018,17356,17323,15275,11147,11147,9067,6986,6954,6954,6922,6954,4906,4938,4938,875,875,843,875,875,875,875,875,843,843,811,843,843,876,875,875,875,908,908,908,940,940,940,940,940,940,940,940,940,940,940,940,940,939,907,907,907,907,907,907,907,907,907,907,907,907,907,875,874,874,842,842,874,255},
{32184,34232,32152,30103,30103,32151,30071,28023,30103,30071,28023,30103,28023,34231,32151,28023,30071,30103,28023,28023,25943,25943,25943,23895,30006,25552,19246,17166,17198,17166,17166,15085,15086,15086,15053,29778,38164,42422,38229,17197,19310,36019,44438,38196,33937,40276,29680,31760,38065,38033,40081,46322,50547,31694,19050,16937,27566,42324,38099,35953,35986,35953,35953,44372,54904,48631,44469,54937,54937,29745,31889,36017,36017,48728,48696,46615,52856,52889,52856,50776,50776,48663,46583,46615,44437,42357,40244,36050,33970,33937,29776,25551,21325,19212,19245,17164,17165,10826,21260,31759,29679,29679,19147,38066,52824,46550,52889,52856,38163,42356,40243,21358,38131,27631,33937,31824,29679,31792,31824,27598,29711,31824,25518,29711,33904,29647,31792,33905,31759,33872,36018,33904,42356,31857,48630,29515,31628,25452,42159,54804,52725,48531,31692,23209,19049,12775,21129,21096,35820,31626,33674,31594,33641,33674,31561,29481,46286,46285,46285,29481,25256,46253,56850,56851,58997,58964,58932,56818,52591,35819,42356,42421,32050,27856,17356,13195,11147,9066,9067,6986,6954,6922,6922,6954,4906,4938,4938,875,843,875,875,875,875,875,843,843,811,778,811,843,875,875,875,876,908,908,908,940,940,940,940,940,940,940,940,940,940,940,940,940,939,907,907,907,907,907,907,907,907,875,907,907,907,875,874,874,874,874,842,842,255},
{32184,34232,32151,30103,32151,32152,30103,28023,32151,30071,28023,30071,30071,34232,32151,28023,30071,30103,28023,28023,25943,25975,25975,23895,27860,46517,44405,44340,44372,42260,40179,38066,38066,35954,33873,33808,38066,42357,29745,27664,38163,36083,38164,48631,46551,42325,25486,31890,33906,17132,21261,27437,33808,25421,23307,21195,25486,42260,48598,46452,31759,27534,27566,40179,40211,50678,52856,54937,52889,48663,46583,46582,46582,48663,48663,48663,52856,52856,52888,54936,54936,54937,54937,54904,54936,54936,54937,54936,54904,54904,52824,52791,42356,38098,35985,33873,29744,29712,29679,29647,29647,23340,14954,36018,46550,38098,57049,54969,31825,44470,25486,17067,36018,29711,31825,36018,33905,33873,36050,33937,33905,38130,36018,33905,38130,33905,33905,36018,31824,31792,33905,33904,38098,36018,46483,29548,35822,21291,42159,54805,54804,46418,33708,27467,14920,10727,19016,23209,42093,31626,31594,27368,25256,21095,29449,40012,48398,48366,42060,25288,27400,37834,46350,50544,54705,54738,54770,54705,37900,38097,46647,46615,42486,38324,17388,11114,11114,9034,6986,4906,4874,6922,6922,4906,4906,4906,2890,843,843,875,843,875,875,875,843,843,811,811,811,843,875,875,875,876,876,908,908,908,940,940,940,940,940,940,940,940,940,940,940,940,940,907,907,907,907,907,907,907,907,907,907,907,875,874,874,874,874,874,842,842,255},
{32184,32184,32152,32151,32151,32152,30071,30071,32151,30103,28023,30071,30071,34232,32151,28023,30071,30103,28023,28023,25943,25975,25943,23895,31988,48566,42292,44340,44340,44340,44372,44372,46453,46453,48435,37969,33938,36019,27632,35952,35888,31793,38164,50744,40212,42292,29712,27696,27665,15117,15085,15052,12972,19180,38065,42291,35953,35985,48564,52726,52790,50645,48597,42259,38098,48631,54937,54937,52889,52856,52856,52857,52889,52856,52856,52856,52856,52856,52856,52856,52856,52856,52856,52856,52824,52824,52824,52823,50743,50743,50710,48597,38130,35986,33905,33872,31792,31760,29679,27566,27534,19147,10761,42324,40178,42259,57050,50776,36050,46550,33937,31857,38163,33969,31857,36050,33937,29711,33937,29744,27599,33905,31792,29647,33872,29679,25518,31824,31759,27599,31824,38131,35985,40178,27500,25355,37935,23372,42160,50546,50414,48498,33740,31693,19081,14855,19081,19016,35852,27401,29481,27368,29449,25256,33674,42092,42092,39947,50478,46252,46252,42091,50544,50512,46286,39980,37900,27369,21259,46615,46583,40340,38324,23695,13227,11115,9034,6954,6954,4874,4873,4874,4874,4906,4906,4906,2890,843,843,843,843,875,875,843,843,843,811,843,843,843,875,875,876,908,908,908,908,908,908,940,940,940,940,940,940,940,940,940,940,940,940,939,907,907,907,907,907,907,907,907,907,907,907,874,874,874,874,874,842,842,255},
{32183,32184,32152,32151,32151,32151,30071,30071,32151,30103,30071,30071,30071,36280,32151,28023,30071,30103,28023,28023,25943,25975,25975,25943,42455,50678,48565,48565,48565,48533,46453,46452,44372,44372,44176,37905,19246,33971,38164,46452,42129,46518,40147,38131,48631,50711,38131,27631,29809,36051,33970,33938,29777,27632,44403,46452,48564,46451,44305,50710,59064,59064,48500,38066,42357,42292,48631,54970,52857,52824,52856,52857,52857,52857,52856,52856,52857,52856,52856,52856,52856,54936,54904,52856,52856,52856,52824,52823,50743,50743,50710,42291,33905,31760,29679,27599,27566,25518,25453,25421,27533,23372,17034,48631,31727,42291,57049,52856,29744,50743,25518,33938,38098,44437,35985,40244,40211,38131,40211,42324,38130,38131,40244,38130,38131,40211,36017,38098,38130,33905,35985,44404,29679,42259,21194,21162,25356,27565,42160,52658,52526,50579,33772,35853,19049,21129,27402,31595,40045,37933,42093,37900,33674,33609,39914,50478,50576,52624,52558,50477,48332,48365,48398,46317,40012,29514,21128,23208,21227,46583,40341,38260,31985,17420,11114,9002,6986,6954,2825,2793,2826,2826,2826,2858,4906,4906,842,843,875,843,843,843,843,843,843,843,810,843,843,843,875,875,876,876,908,908,908,875,907,940,940,940,940,940,940,940,940,940,940,940,940,940,939,907,907,907,907,907,907,907,907,907,907,907,874,874,874,874,842,842,255},
{32183,32184,32152,32152,32151,32151,30071,30071,32151,30103,28023,30071,32151,34232,30103,28023,30103,32151,28023,28023,25975,25975,25975,25943,40342,44339,42259,44308,46420,42259,42259,44307,44307,44275,46257,37871,21294,19278,15020,25518,42291,46583,42390,36084,40180,36052,36019,33840,38132,38099,38099,36051,33938,36018,54870,48564,48564,48532,46418,52757,52692,48499,33774,40146,44405,40211,46550,54970,52856,52856,52856,52856,52857,52856,52856,52856,52856,52856,52856,54904,54936,54936,54904,54904,54904,52856,52824,52823,52823,50711,48597,38130,31727,27501,25388,23340,21260,21228,19147,19147,23275,33838,31758,50776,29613,46549,54969,46518,33937,46550,25519,38164,36050,44437,38131,40244,40244,38163,38163,42357,38163,38098,42356,38131,36050,42356,40211,38066,42324,38131,31792,44437,27598,40178,27468,38064,25453,33839,40079,52626,54772,48498,35820,31692,14920,19081,21161,25354,37932,44173,39980,44238,42092,44140,42091,50446,56818,54704,52559,46220,39914,42027,42060,37835,42125,42125,42093,42125,23273,42389,48760,29808,17162,15211,13131,9002,6954,4906,2793,2793,2793,2793,2793,2826,2826,2858,842,843,875,875,843,843,843,843,843,811,811,875,843,843,875,875,875,875,908,908,876,875,908,940,940,940,940,940,972,940,940,940,940,940,972,940,940,907,907,907,907,907,907,907,907,907,875,907,875,874,874,874,842,842,255},
{32184,32184,32152,32152,32151,32151,30071,30071,32151,30103,28023,28023,32151,34231,30071,28023,30103,30103,28023,28023,25943,28023,25943,25943,42455,54806,50646,50614,50613,50646,48565,48533,48501,46420,50319,44047,23374,19278,23471,31955,50744,48631,38164,38164,36051,42357,44405,35953,42292,38131,36018,36051,33970,44241,42095,50678,50710,50677,48564,46419,40080,33807,42161,35920,27533,31792,48631,54970,52856,52856,52856,52856,54936,52856,52856,54904,54904,54904,54904,54936,54936,54904,54904,54904,54904,52823,52823,52823,52791,50677,44436,33839,33840,21227,21227,23308,23308,19147,19114,19147,19115,19114,42258,46550,29712,50743,50743,46518,36050,46550,19277,38130,29711,38130,29711,31824,33937,33905,31824,36018,33905,31792,38098,36018,33904,38130,38130,36018,40211,40211,33872,44437,29679,38065,35886,46384,38065,33839,40046,50579,50611,42127,42094,35852,21193,25322,33773,35821,29449,44141,46285,48366,46220,48366,52591,46252,46220,50478,50446,37834,35754,33642,31594,40012,40012,35819,37900,23241,17033,42357,48760,27663,12937,12969,11018,9002,6986,4906,2793,2793,2793,2793,2793,2794,2794,2858,810,842,843,875,843,843,811,843,843,843,843,843,875,875,875,875,875,876,908,908,908,908,908,940,940,940,940,940,940,940,940,940,940,940,940,940,940,939,907,907,907,875,907,875,875,875,875,875,875,874,874,874,874,874,255},
{32184,32184,32152,32184,34200,32152,30071,30071,32151,30103,28023,28023,34231,34199,30071,28023,32151,30103,30071,28023,25975,28023,25975,25943,32151,36247,36246,38294,40375,40342,40374,42422,42422,44405,46062,35694,25390,23504,38132,40244,54937,54937,48566,35954,33906,44339,50613,40112,25454,21326,21358,19277,21358,37903,44241,50710,40113,35920,29646,23308,21260,27534,25453,50678,50677,46484,52857,54970,54937,54937,54937,54937,54937,54937,54937,54937,54937,54936,54936,54936,54936,54936,54904,54904,54904,52823,52823,52823,50742,46484,40145,31726,31791,27534,23340,23340,35919,33807,33807,31694,31694,21260,27500,48564,48631,52888,50743,40244,42357,42324,29712,42356,31856,40275,36050,33937,38131,38131,31856,38130,36017,31824,36050,36017,31792,35985,33937,27599,33904,33904,29679,42292,31824,31759,31660,44305,38000,35952,46418,54838,27468,21129,44240,44239,21193,16968,19048,27435,23209,31529,33674,39947,39947,46220,54672,44139,42059,44140,37834,29481,25288,25288,33674,42124,44205,35786,31594,14855,12808,31824,50841,29841,10857,12937,10953,8970,6954,4906,4841,2793,2793,2793,2793,2793,2826,810,842,842,875,875,843,843,811,843,843,843,843,843,843,875,875,875,875,876,908,908,908,908,908,940,940,940,940,940,940,940,940,940,939,939,940,940,940,940,907,907,907,875,875,875,875,875,875,875,874,874,874,874,874,874,255},
{32184,32184,32152,32152,34232,32151,30071,30071,32151,30103,28023,28023,34232,32151,30103,30103,34231,30103,30103,28023,25975,28023,25975,23927,23895,23894,23894,25943,25943,23862,25910,25942,28023,27860,23341,31532,25390,25617,44372,42292,46518,48630,44372,44372,42325,50711,46485,35919,29712,23536,27697,27632,27599,35790,52726,44371,38032,31726,23373,19147,29712,35986,25454,52758,44307,33905,36018,44340,42195,38066,40179,42259,44340,44340,46453,46517,48565,50678,48631,50711,52792,52824,54905,54904,54904,54904,54904,54904,50743,50645,37967,33872,29614,27566,23275,23243,21162,25388,23307,23243,23275,21162,19114,37998,40146,50679,50711,38131,44469,33969,15051,38163,31856,38163,36050,31792,33969,36050,29679,33937,38098,29711,33904,36018,31759,33904,38098,31759,33904,38098,33905,38098,38066,29581,33741,44305,29613,38032,48531,54805,35886,27467,42159,35853,23241,23242,21161,23242,23241,27369,31529,46220,46220,33641,37834,44140,35754,42027,37867,33642,27401,33674,44172,44204,44140,39947,44173,31659,14822,23274,46583,21421,10889,13001,10986,8905,8970,6954,4874,4841,2761,2793,2793,2793,778,810,810,842,875,843,843,811,811,811,843,843,843,875,843,875,875,875,908,908,908,908,908,908,908,908,940,940,940,908,940,940,940,940,940,940,940,940,940,940,939,907,907,875,875,875,875,875,875,874,874,874,874,874,874,874,255},
{32183,32184,32184,32151,34232,32151,30071,30071,32151,30103,28023,30071,34232,30071,32151,30103,34231,30103,30103,28023,28023,32151,25975,25943,25943,23895,25975,25975,28023,25942,25943,25943,28023,31956,27600,35693,33711,36051,50645,48630,50743,57050,46485,33873,44405,40146,33905,38164,40211,27729,21391,15084,12971,19180,50646,52823,48597,46484,42259,33904,27599,36019,25518,52824,27598,23438,27631,27566,33742,27533,27501,25388,23308,23308,23275,21227,14953,14954,10794,10826,14987,25519,42358,31728,31792,37969,31630,29615,31759,46451,33774,25453,17034,21195,19082,25355,33839,33774,33806,33774,33806,31759,29678,33807,27533,29581,27468,27533,33839,33774,29614,35984,42225,40112,46451,44305,44305,44337,42225,42258,44371,40210,42226,42323,38130,40178,42291,42258,38098,42259,40178,33905,40211,31694,33773,38065,29646,38032,48498,50644,37999,29548,44239,29580,14856,25322,25322,31660,27434,33706,29449,33641,33641,29481,35721,35754,21063,25256,27401,42060,44172,48365,48332,52526,44172,46286,48398,46319,27368,27467,42357,23469,19340,19405,13066,10986,8938,6922,4842,4841,2761,2761,2793,778,778,810,810,810,843,875,843,811,843,843,843,843,875,875,875,875,875,875,908,908,908,908,875,908,908,908,908,908,940,908,908,940,940,940,940,940,940,940,940,940,939,907,907,907,875,875,907,907,875,874,874,874,874,874,874,874,255},
{34232,34232,32184,32151,34232,32151,30071,32119,32151,30103,28023,30103,34232,30071,32151,28023,32151,30103,28055,28023,32151,34231,28023,25943,25975,23895,19604,19604,19636,19604,21717,23765,25813,29778,40146,39983,42162,52791,52726,52791,48598,54872,50613,44243,44145,27567,35921,50613,48467,40048,17132,2602,2570,2569,17197,25584,29712,31825,46452,42227,27566,27599,25453,38065,42324,38131,40211,36018,33872,38163,31759,33840,27533,29711,25486,21292,12905,8745,6600,4552,6665,25585,27567,19148,27632,33809,23244,31694,33774,42193,31726,25485,17099,17002,17001,33807,48630,27533,33806,35886,35886,35919,33839,31726,31693,31726,29613,31661,29549,25387,25420,27598,44370,37900,48465,40046,44238,46286,44174,42158,44206,44205,44174,44206,44206,44205,44206,44175,54739,44175,50547,48271,44305,21194,25419,42324,29614,31726,50579,50644,42258,48498,46417,25387,14888,25354,29515,33740,29449,44140,37867,29449,25256,23208,31561,25256,23176,29481,35786,39979,35753,44107,46219,52558,50478,52559,54704,52624,31626,27467,31659,31823,36180,21486,10986,10986,10985,6890,6890,4809,2761,2793,2826,778,2826,2826,778,810,843,843,843,843,843,843,843,875,875,875,843,875,875,875,876,908,908,876,908,908,908,908,908,908,908,940,908,940,940,940,940,940,940,939,940,939,939,907,907,907,907,907,907,907,875,875,907,875,874,874,874,874,255},
{34232,34232,32184,34200,34232,32151,30071,32151,32151,30103,28023,30103,32151,30071,30103,28023,30103,30103,28055,30103,34231,32151,28023,25943,25943,25943,8943,556,588,588,588,588,2668,19311,25552,29712,29745,48565,50678,54839,52791,52759,42194,39951,29582,40277,40146,50613,50613,35920,19245,4715,2602,2602,4650,10924,10924,19278,33970,29680,25454,25519,33905,33937,42291,38098,40179,40178,35953,40179,38098,38065,35984,31759,21227,10760,10825,8713,4520,6633,15020,29713,17067,17099,21228,31792,36051,29679,29679,29679,29647,29647,27599,25453,29679,35919,50710,29646,35919,37999,35886,35919,38000,35919,29613,31726,31726,29613,31694,27500,29580,25420,44338,31660,46484,29647,35985,38098,33807,33905,38098,33839,35952,40178,35920,37967,44338,50611,54545,43754,45964,56170,33643,25387,23274,37967,29581,29613,48531,50612,29614,40014,46385,31692,19049,23241,21129,31628,21128,27336,35754,29481,25288,19048,23176,23176,29449,35754,48332,54638,42026,46219,44172,50446,46220,42027,48333,52591,29481,29480,42025,35917,33937,21389,10986,10953,10986,8970,6890,4809,4809,4809,2794,2794,2826,2794,2826,810,843,875,843,843,843,875,875,875,875,875,875,908,908,908,908,908,908,908,908,908,908,908,908,908,940,940,940,940,940,940,940,908,907,939,940,939,939,907,907,907,907,907,907,907,875,875,875,874,874,874,874,874,255},
{34232,34232,34232,34200,34232,32151,30071,30103,32151,30103,28023,30103,32151,32151,28023,28023,30071,30103,30103,32151,32151,30071,30103,25943,25943,25943,13136,588,620,588,4749,15150,23569,27697,36051,38098,33905,44404,52823,54871,52791,52758,44306,35855,31695,40244,33839,48499,42258,42324,40179,31858,10956,6795,8810,27599,42193,35920,27599,27567,21260,23406,36050,42292,42259,40146,38066,40179,38066,38130,38098,40113,40113,35985,31792,23373,10760,8680,6600,10794,17197,23374,17100,17067,19083,29712,42389,40244,29744,31825,29744,27664,27664,27599,38098,46451,48565,33872,33773,33741,29612,31693,33773,31661,27500,31693,31693,27468,31693,27468,27467,31792,46451,37868,46484,35920,38065,40211,35952,38033,40211,35953,35952,42258,38033,33840,42291,52758,54351,52108,37838,31400,25257,23241,25388,27500,29613,33807,50612,52790,21227,37901,48531,29580,16968,27434,27467,29580,16935,21096,29449,35754,35722,29449,29481,31593,33641,48333,54638,52493,50445,52525,50446,44173,27336,33673,42026,48365,29513,33673,44271,35884,29711,25614,13034,10953,8938,8970,6889,4841,4809,2793,746,2793,2826,2794,2826,810,843,875,843,843,875,875,875,875,875,875,908,908,908,908,908,908,908,908,908,940,940,940,908,940,940,940,940,940,940,908,940,908,907,907,939,940,939,907,907,907,907,907,907,907,875,875,875,874,874,874,874,874,255},
{34232,34232,34232,34199,34232,32151,30071,32151,32151,30103,28023,30071,32151,32151,25975,28023,28023,30103,30103,32183,28023,28023,30103,28023,25975,23830,8910,10925,8812,8779,19376,25520,27632,38229,38131,40146,44275,48566,50679,50679,48533,48598,50678,42390,40245,31890,31759,48466,44241,31760,42324,40243,15246,17326,27696,40048,50352,42031,21163,14954,21196,21195,19115,21195,23308,23373,21195,27534,27533,27533,23308,25388,29614,31695,29679,31759,21228,19180,17067,17067,19212,19115,12907,12907,17035,23406,29777,17067,21260,21260,21325,21325,19212,29680,44404,48597,52824,44371,35886,31693,33773,35854,33773,29580,31661,31693,29580,27467,27500,29548,29580,33937,46418,35820,46452,31792,33872,40178,33872,33872,40178,38065,33839,40146,38065,33839,44372,52790,52367,45803,39886,33611,27305,37935,42356,27500,29613,35919,50644,54903,25355,37901,44370,21291,21193,25386,27435,27467,23209,31593,33674,33642,29449,29481,31561,33641,39914,48333,54672,46253,42027,44107,50478,46285,39946,42027,48365,54672,35754,18983,27500,38031,29580,36018,17098,10986,8970,8970,6889,4841,4809,777,2794,2794,2826,2826,2826,810,843,875,875,843,875,843,875,875,875,875,908,875,908,908,908,908,908,908,908,908,940,940,908,940,940,940,940,940,908,908,908,908,940,940,939,940,940,940,939,907,907,907,875,907,875,875,875,874,874,874,874,874,255},
{34232,34232,34232,34199,34199,32151,30071,32151,32151,30071,28023,30071,30103,32151,25975,28023,30103,30103,32151,32183,25975,28023,28023,28023,28023,21717,8845,23212,21100,23212,31728,21293,25421,23406,19148,21227,29647,31793,27632,25584,21358,25519,48566,42325,33906,27632,31694,46288,33742,27599,42357,36051,13198,15278,44535,50515,54577,31629,27436,14922,17035,17034,19083,21163,19083,17002,21195,19083,19082,21195,12809,19082,19114,17034,17034,19115,19082,17034,17034,19115,19115,12776,10728,10761,23406,25551,27664,19245,21260,19147,15019,17067,10793,14954,44372,46420,52824,52822,50644,42257,46450,48532,46484,44339,38032,33806,29580,33806,29581,27500,21194,38163,46418,31660,44372,38033,35952,40211,38097,35952,40179,40178,33872,40146,40178,35919,44404,54871,50415,39950,44242,33742,25225,48565,46551,27501,31694,38032,50644,54936,27468,35788,44337,29677,29514,27499,29515,29515,23208,27368,35787,42092,33706,33738,25288,33674,46285,46285,42060,39979,48398,48366,56817,54671,48333,48397,56785,52624,35787,27368,35950,46615,42388,33839,21226,13099,8970,8937,8938,4841,2794,2826,2826,2826,2826,2826,2858,810,843,875,843,843,843,843,875,875,875,908,908,908,875,908,908,908,908,908,908,908,940,908,908,908,940,940,940,940,908,908,908,940,940,940,939,940,940,940,939,907,907,907,907,907,875,875,875,874,874,874,874,874,255},
{34232,34232,34232,34200,32151,32151,30103,30103,32152,30071,28023,30071,30103,30103,25975,28023,28055,30103,32183,32151,28023,28023,28023,28023,28023,27958,17134,23213,23212,23244,38099,46452,48468,44306,44273,42063,35921,29745,23471,23439,25616,31923,29679,41966,38099,33906,38000,48400,31596,23341,25584,23535,15149,8907,31922,54675,54512,48434,44241,25421,14889,19147,19114,23340,25421,27534,19082,21163,23308,25421,21228,21228,19114,21195,19115,12809,19082,19050,16937,16969,17002,14889,12776,14986,42357,29777,42389,40244,23307,33970,27631,27533,27533,25485,42291,42291,54936,59096,50645,46451,52692,52790,54871,48532,35919,33806,35887,38065,29548,27468,27468,33937,44305,31693,40211,33937,31791,38066,36018,31791,35985,38066,31791,35952,40178,33839,42324,54871,46287,27403,23210,29452,29419,48467,35953,31694,25420,33806,48531,52790,27501,31595,48432,50577,31627,29547,27402,31595,23240,23208,37867,52559,46253,42059,42092,40012,46285,50446,42026,50413,50445,54639,56752,54638,52590,54671,54704,52591,44172,35720,40078,48696,44535,38260,25647,11050,10986,10986,8937,4841,2793,2858,2826,4842,2826,2826,2858,842,843,843,843,843,843,875,875,875,876,875,908,875,908,908,908,908,908,940,908,908,908,908,908,908,908,908,908,940,908,907,908,940,940,940,908,939,940,940,939,939,907,907,907,875,875,875,875,875,875,874,874,874,255},
{34232,34232,34232,34232,32151,32151,30071,32151,32152,30103,30071,32151,32151,30103,25975,30103,28023,32151,34232,28023,28023,30103,28023,30103,28023,36279,36051,25487,23310,17133,36019,33873,27599,27566,25453,25421,40179,33906,21261,23406,44502,46518,31727,48044,48565,38164,40178,29646,23373,23341,35856,44405,35855,29582,33937,52595,46093,50481,35854,31727,8616,12874,19114,21228,23340,33905,19115,17034,17034,27599,27599,21195,19115,23340,29711,27566,25453,29647,16969,17002,17034,23438,14889,21293,44470,27697,48663,38066,25420,50776,35985,29645,33806,42258,50678,44405,54773,54870,46386,46353,46353,42192,42128,37934,31693,29548,29581,29548,23242,21129,23275,38130,48563,40145,44338,42259,33872,40114,40179,33905,36018,42259,38032,35985,40211,35984,44404,56918,42093,21130,21130,33645,29322,35627,31694,31694,25388,33742,46418,50677,29614,33773,50545,50545,31659,23241,23209,27370,27401,35754,46219,46154,39849,44073,46219,31529,37834,46154,46153,48267,44106,56751,56751,54573,46252,52526,54671,46252,42092,31593,44371,48696,48696,44567,25841,11115,11018,8905,8937,4842,2826,2858,2826,4810,2794,778,778,843,843,843,843,843,875,875,875,875,875,908,908,876,908,908,908,908,908,908,908,908,908,908,908,908,908,908,908,908,908,908,908,908,940,940,940,939,940,940,939,939,939,907,907,875,875,875,875,875,874,874,874,874,255},
{34232,34232,34232,34232,32151,32151,30071,32151,32152,30103,30103,34232,30103,30103,28023,30103,28023,32184,32183,28023,28023,30103,28023,30103,28023,36312,46648,34036,27535,10956,23407,21391,13102,13069,15053,19180,40113,31760,17133,27632,48599,48566,37969,33581,33905,29647,29647,14988,12940,17035,27340,25584,23438,21293,33872,46387,39983,46223,40047,37935,25388,25420,23275,23308,23340,27533,23308,21195,19082,23308,25518,19115,17034,14889,25550,17034,14922,27566,21162,19082,14857,25551,23308,23405,31890,29777,50776,40179,35985,48696,38065,35952,35951,48598,48597,50677,56984,54838,42225,46386,48499,42160,33741,33741,33773,29613,27435,27435,25323,21162,25387,35952,42192,33871,42226,42258,31792,31857,38098,33872,33872,38098,33872,33839,38098,35953,44404,54870,46189,35855,29549,35756,29354,33611,29581,29581,25388,31693,48466,56951,27533,42127,57016,46319,33675,23209,19016,19016,21063,33641,46154,39913,39881,44075,37801,33641,39914,52493,52493,48332,48332,52558,50445,48332,44172,42059,44140,35754,46285,25321,40179,42323,42389,29873,21550,11082,8970,8905,8937,4874,2826,2858,4842,4842,2826,2826,2858,843,843,843,843,843,875,875,875,875,908,876,908,908,908,908,908,908,908,908,940,908,908,908,908,908,908,908,908,908,908,908,908,907,908,940,908,939,940,940,939,939,939,907,907,875,875,875,907,907,874,874,874,874,255},
{34232,34232,34232,34232,32151,32152,30071,32151,32184,30103,30071,32183,32151,30103,28023,28055,28023,34232,32183,28023,30103,30103,28023,28055,30071,30071,28023,34068,44209,35889,27664,27697,27632,27599,38001,37969,27664,27566,23374,25422,46452,42259,27599,17197,15085,10859,10924,6731,4682,4618,6666,4618,4585,12971,27533,48468,35889,39982,50547,44208,37902,42095,40015,40048,37999,40047,42128,42128,42128,44208,40112,40015,40015,33742,35886,37935,23275,31693,35822,35789,31628,31694,29581,33774,29745,29777,50711,42259,44404,48631,48597,46517,46452,54937,52823,42258,46484,42225,35885,35886,37934,33772,29547,29515,29547,27467,25322,25322,23242,25322,38032,48563,50611,52659,35953,40211,33904,35985,42259,38065,35952,40211,38066,35920,40178,40146,46517,52758,41965,42194,31727,29516,25258,31531,31694,29646,33806,33806,44272,54904,29614,44240,42193,46318,35820,27434,25256,27401,29481,37899,46286,46286,50447,50479,44205,46285,48366,50446,48365,50444,54637,50477,46252,39914,44172,44205,44206,33674,44173,29514,35985,48663,31856,15114,13033,13163,8970,8937,6889,4906,2858,2858,4842,2794,2826,2826,811,843,811,843,843,875,875,875,875,875,908,908,908,908,908,908,940,940,940,908,940,908,908,908,908,908,908,908,908,908,908,907,907,907,908,908,907,907,939,939,939,939,939,907,907,907,907,875,875,907,874,874,874,874,255},
{34232,34232,34232,34232,32151,32152,30071,32151,32151,30103,28023,32151,34199,30103,28023,28023,28023,34232,32183,30071,30103,30103,28023,30103,30071,30071,28023,40342,46355,11086,23601,29809,38001,38098,35953,33872,35920,33774,29613,31693,29517,23374,14988,6730,2602,2634,489,456,2569,2569,521,457,457,424,25452,46354,42227,48434,33742,25323,27436,27469,29549,29516,29549,31597,29516,35822,33677,31596,35854,35790,35789,35822,35822,37902,31596,33709,37902,35821,39982,37934,37870,25323,27631,44470,50743,44371,42323,40211,40179,44372,46451,50710,56984,42257,50742,48597,42192,42192,42224,44305,48564,44370,37999,37998,42257,33741,31661,31660,40145,52691,46418,50611,33872,40179,33873,33840,40178,35985,31760,38066,38066,31759,35985,38098,46485,48631,38032,27468,27599,21161,23242,33708,33807,31694,33806,33806,42160,52757,44338,50546,42258,46319,37901,33642,31595,31562,35786,37867,39980,48399,52592,50544,48399,42060,48365,50413,46154,50412,52524,44139,33641,35722,42059,50478,48398,42125,42093,31626,38065,42389,23534,12937,10792,13066,8938,8970,6922,4906,2858,2858,2794,2826,2826,778,843,811,811,843,875,908,908,875,875,908,908,908,908,940,908,940,940,940,940,940,940,908,908,908,875,908,908,908,908,908,908,907,907,907,907,908,908,907,907,907,939,907,907,939,939,907,907,907,907,907,874,874,874,874,255},
{34232,34232,34232,34232,32151,32151,30071,30103,32151,30103,30071,32151,34232,30103,30103,28055,28055,34232,32183,30071,30103,30103,28023,30103,32151,30071,28023,46550,48435,11183,21553,23568,33872,38130,34003,25551,31825,25616,23471,31760,27405,17068,10859,4650,521,521,489,457,489,2569,489,489,489,457,23405,44273,42129,52562,31629,23308,21162,21162,19114,23243,21162,21130,19082,21162,19082,19050,21130,21130,21130,21130,21130,21130,16937,21098,23210,21130,21162,21162,21162,19082,38065,48631,50744,50743,52824,50744,48663,48631,48565,52757,56951,46385,50708,50676,48531,46417,50612,46451,50710,52791,44371,46452,48597,44338,46451,44305,40210,48563,25453,42291,33872,40179,38065,33872,38098,38098,35952,38066,40179,35952,38065,40211,44437,48598,42357,29613,21292,21193,17065,33774,31694,29646,31726,37967,46385,54837,52725,54805,52626,50479,35853,35755,35788,33707,37900,27401,25256,37801,41994,37834,33641,35689,41929,44074,46219,50380,46187,37834,37834,42060,39979,44140,52558,42092,42127,27401,31627,42356,21486,12872,10824,10921,8938,8970,6922,2858,2858,2858,2826,2858,2826,2826,843,811,811,843,875,908,908,908,908,908,908,908,940,908,940,940,908,940,940,908,940,908,908,908,876,875,875,875,908,875,875,907,875,875,875,908,908,907,907,907,907,907,907,907,907,907,907,907,907,907,874,874,874,874,255},
{34232,34232,34232,34232,32151,32152,30071,30103,32151,30071,30071,32183,34232,30103,30103,28055,28055,34232,32151,30103,30103,30103,28023,30103,34231,30071,28023,40244,48436,31890,33938,33905,42194,42195,33938,27665,27697,23504,23471,21261,17035,15052,17165,8844,2602,554,522,489,521,521,521,2570,521,457,12971,48565,48434,48369,46321,40080,37967,40048,35887,35854,31661,35854,33774,37902,33774,33741,33774,27468,29548,25355,29548,29484,16937,25355,25323,27403,21162,23210,21130,27403,44273,40113,50481,42192,33838,33871,31759,33839,50645,52757,57016,52789,46450,48531,50644,38032,40113,46387,42226,31760,31792,29647,29647,29647,29647,29679,40080,44338,25486,46517,31759,36018,36018,31759,35985,36018,31791,33872,38098,33872,33840,40211,44372,38065,35985,31694,37967,27500,23275,29613,29582,29646,27501,40145,48498,44305,42192,50513,50479,52559,27434,27336,23143,33609,31562,25256,31463,37704,37736,29416,23175,27303,33576,37801,35753,37834,25255,29481,42027,46252,44140,44140,44205,33674,25288,18983,27434,38097,23599,15017,10856,10953,8905,6890,6922,4906,2858,2858,2858,2859,2826,2826,811,811,811,875,875,940,940,940,940,908,940,940,940,908,940,940,940,940,908,940,940,908,908,908,908,876,875,875,908,908,875,875,843,875,875,907,907,908,908,908,907,907,907,907,907,907,907,907,907,907,874,874,874,874,255},
{34232,34232,34232,34232,32151,32152,30071,30103,32151,30103,30103,34231,32151,30103,30103,28055,28023,34231,32183,30103,30103,32151,30071,32151,34231,32151,30103,31988,36116,34003,36051,38099,36051,27697,31793,29745,27599,25520,27600,23374,25390,19115,21294,17165,6731,4682,4650,4650,2570,554,554,521,2602,2570,2569,10891,35920,46289,44209,42128,40048,42128,40080,40047,44273,44208,44241,46289,44241,46353,46321,44176,46289,42095,44240,44240,27467,44207,44207,46288,42095,40015,42063,31629,33806,39917,52333,35820,23370,15017,10824,15017,27532,54838,48564,52758,50612,38032,38032,40145,42193,54838,52758,38065,35984,38032,35919,33806,33806,33774,37934,44273,33872,44437,33807,38066,40179,33872,38033,42259,35953,33905,40178,38065,35920,42292,44437,46484,42324,27533,33774,29613,29613,29582,29614,31791,29646,46484,50677,35919,31661,39981,48333,48432,33708,35787,25256,31529,29481,35721,31496,33608,35721,25256,27368,27336,35754,35754,31529,27304,33673,42027,44140,41995,46253,42060,39979,37834,37899,35754,40078,44468,25712,12969,12937,10921,8776,8905,6922,4906,4906,2826,2858,811,779,811,811,811,843,876,908,940,940,940,908,940,940,940,940,940,940,940,940,940,940,940,940,908,908,908,908,875,875,875,876,876,843,811,811,843,875,875,907,908,908,907,875,875,875,907,907,907,907,907,907,907,907,907,874,874,255},
{34232,36280,34232,34232,32151,32152,32151,30103,32151,30103,30103,34232,32151,32151,28023,28055,30103,34232,32151,32119,32151,32151,28023,30071,34231,34231,32086,27925,25617,21391,25617,27697,29810,25585,31793,23407,21358,17165,21326,31760,40114,23276,17067,23373,23438,21325,17099,21293,15052,10923,10859,10859,10891,8811,6730,4650,23373,40048,29517,31629,33709,31596,29548,29613,33710,35822,35757,33709,33709,33709,33677,31596,29484,25323,35789,27468,19081,35789,35821,37870,37934,37902,35822,35789,29517,48206,48172,29546,19210,12905,12872,14985,23340,35920,33773,44338,42161,33709,33708,40047,40112,54838,50612,40080,38000,40112,40080,37999,40080,42160,40112,46386,31628,42291,35985,35985,42259,35921,33905,40179,35984,33840,38098,35985,31759,42291,42324,36017,38098,23275,29581,27533,27501,25420,27469,33839,31824,48532,50743,33872,27500,31660,42093,37933,33707,40013,40046,48398,44205,29480,35755,46254,35787,31594,37835,35786,33674,25288,25288,31561,39947,39947,39947,37867,37834,35787,35754,46252,54671,44173,50677,42454,27825,10824,8647,10760,10727,6793,6922,4874,4874,2826,2858,2859,811,811,811,811,843,908,940,940,972,940,940,940,940,940,940,940,940,940,940,940,940,940,940,908,908,908,908,875,875,875,875,875,811,778,778,811,843,907,907,907,907,907,907,875,875,875,907,907,875,907,907,907,907,907,874,874,255},
{34232,36280,34232,34232,32151,32152,32151,30103,32151,30103,32151,34232,34232,32151,30103,30103,30103,34232,32183,32151,32151,32151,29941,19441,27926,34232,34069,25585,21456,33873,29810,27730,29778,27567,25584,29778,25584,21358,23407,27469,35758,35888,21293,31760,27567,27566,29647,27599,27567,23373,23406,21325,19277,23438,23438,21390,17164,31792,40114,42227,25453,35887,35854,37967,38065,35952,31694,40113,48565,46353,40047,42160,42095,35853,46320,35821,27435,35789,35789,35757,33677,31628,29483,37935,39950,52366,41996,27466,19177,10824,10792,17033,37935,23275,19082,21129,19017,16904,25290,50579,52692,31662,37902,25388,21260,19115,19114,19179,23340,23307,29646,42160,37933,42192,54903,33840,38099,35953,33872,38099,35985,33840,38098,38098,31760,42324,42291,35985,23373,27468,25420,25388,25420,25421,27501,31726,23437,29548,50677,33774,23242,27435,46319,52658,48464,37868,48367,56785,52559,46285,50446,48334,39947,33641,23208,16935,25288,29449,27368,33674,35754,39979,37867,35754,31529,31594,35787,42060,37834,31626,40144,36147,19308,15050,12905,8712,8679,6793,6890,4874,4874,4874,2826,2859,843,811,811,843,875,908,940,940,940,940,940,940,940,941,940,940,940,940,940,940,940,940,940,940,908,908,908,876,875,875,875,843,779,778,746,778,843,875,908,907,907,907,907,907,907,907,907,907,875,907,907,907,907,875,874,874,255},
{34232,36280,34232,32152,32151,32152,32151,32151,32151,30103,32151,34232,32151,30103,30103,30103,30103,34232,34231,32151,32151,34199,42390,38197,19409,32119,40277,44405,40276,38066,40212,40277,38197,31794,35986,42260,25455,25454,29647,35888,35856,35985,25454,25486,23406,25454,25486,25454,21358,19310,27599,29679,27599,23438,23503,25584,17197,27632,38098,40178,29646,40113,31726,33741,33905,31858,25551,50645,56984,52725,46385,56787,58932,58933,58900,56819,29580,14920,12808,23243,27501,38065,25420,29613,41965,48173,25386,23338,14985,10792,14952,25419,46386,42192,35886,33709,29548,27435,31661,50579,54707,44273,40015,23308,21260,19115,14954,19180,21292,19179,25453,23308,37967,48465,46418,35951,40146,38065,35952,40178,38098,33872,36017,40178,35920,42324,38163,38066,25486,27500,29613,25388,25388,27501,27501,29646,19179,25322,48499,42159,33708,25289,40013,46351,48367,42093,44141,39980,44141,44173,35787,31562,33641,37834,39980,35787,31594,33674,27434,27434,21128,25288,31562,27369,27401,29514,31594,42125,27433,21160,33871,40341,21357,23470,19114,6728,6793,4777,4809,4842,4842,4874,4874,4842,843,843,843,875,908,940,940,940,940,940,940,940,940,972,940,973,973,940,940,940,940,940,940,940,940,908,908,876,876,843,843,811,778,746,746,746,811,875,907,908,908,907,907,907,907,907,907,907,907,907,907,907,907,875,874,875,255},
{34232,34232,34232,34200,32151,32151,32151,34232,32151,32151,32151,32183,32151,28023,30103,30103,32151,34231,34231,32151,32151,38327,48631,48631,33971,23700,40310,38034,38229,36051,42324,42358,42390,34036,42259,36051,21326,31727,35854,39982,33741,37967,33806,29581,27532,29581,31693,25388,17164,19212,19179,21260,19212,19309,19244,25421,23341,31857,46485,42226,40178,44307,38000,37967,33774,42357,35986,46354,52660,48499,50578,48368,48302,48335,48303,46255,29612,14952,6534,19082,27533,31791,21259,27501,46157,33675,19145,21258,17033,25420,39950,37934,38032,44306,44305,42159,40047,37966,35853,37934,54870,42194,31628,21260,23340,21227,17034,23405,27566,23340,27534,19147,25387,42192,35788,46319,33741,48466,48433,46352,48465,48433,46320,44305,46385,48466,40145,42258,29613,21193,29646,19147,21195,29581,27469,29614,31726,27501,31694,50644,46451,44437,42291,38032,21096,21096,29514,23208,25289,25289,21128,21064,31562,37867,33674,25289,27369,18983,21096,16903,25289,29481,27369,19015,25321,25289,27401,31594,23241,21128,36049,36212,29906,23502,12873,6728,4745,4777,4809,4842,4842,4842,4842,4842,843,876,875,876,940,940,940,940,940,940,940,940,973,973,940,973,973,940,940,973,940,940,940,940,908,908,908,876,843,811,779,746,746,746,714,746,778,875,908,907,908,907,907,907,875,907,907,907,907,907,907,907,907,907,875,875,255},
{34231,34232,34232,34231,32151,32152,32151,34232,32151,32152,32151,34232,32184,28023,30103,30103,32151,34231,34231,34199,32151,40407,46518,40277,44470,21522,32086,31794,29778,42325,44470,44470,44470,44470,40212,40277,35986,31793,38032,40145,40113,38065,42193,38064,35951,40112,40047,40015,40080,31694,29646,27630,25549,27598,29613,31661,33807,29777,33938,33872,27567,25453,40080,46386,29549,27502,29614,31661,46386,48498,46287,48303,46288,48368,42095,25355,19114,12905,6599,12873,33807,27534,27599,25420,37836,17033,17097,15017,19211,35854,40112,42225,33839,35919,48531,46418,46353,44272,42159,40079,46353,44240,35789,19179,21260,19147,14954,21260,21292,19147,23373,17034,17034,29679,23307,31661,35887,40080,42193,40112,42192,48466,46417,44305,46450,44337,38032,35952,23275,35886,27468,16969,21195,25388,25388,31694,33839,31792,40210,38000,40211,52856,52857,46517,21129,19016,14823,18984,23209,23209,18984,14823,14790,14790,14790,14823,8550,10662,16903,27434,29514,29481,21128,14823,14823,14790,16936,16935,16903,14920,36179,34196,23664,15082,8938,4841,4777,2729,4777,4810,2794,2794,2794,2827,843,875,875,876,908,908,940,908,940,940,972,973,940,973,973,973,940,940,940,940,940,940,940,940,908,908,876,876,843,778,746,714,714,714,714,714,746,843,875,907,907,907,907,907,875,907,907,907,907,907,907,907,907,907,907,875,255},
{34232,34232,34232,34232,32151,34200,32151,34200,32151,32151,32151,34232,32151,28023,30103,30103,32151,34199,34199,32151,32151,40407,44438,29810,48631,29778,23635,21425,13102,44502,52824,50776,52856,52824,31956,38197,40211,44404,48532,46517,48598,46517,44405,44404,44404,46452,42291,40179,31890,17327,25584,21422,13101,15149,13068,15181,23470,34003,50776,40179,31825,40244,52660,44307,31760,23340,19146,35919,48466,46320,46288,46255,44175,37869,19081,4519,2406,10760,14921,21292,31662,17002,19179,23242,23242,17065,10824,8744,15082,46483,56951,50711,35985,44273,50416,50578,54804,52724,50579,48433,44174,44142,37869,33708,31660,29548,27402,31660,29580,27468,23275,21195,23307,23340,14889,14954,17002,14889,12841,12808,14888,42193,48466,44240,46352,42159,37966,25355,29581,31694,23308,25356,23308,25420,25420,31694,27500,38130,37999,37869,35854,42193,42259,46517,23242,23209,19048,14823,14823,16903,16936,16903,14855,12710,14823,12710,12742,19015,23209,27434,25321,21096,14823,10630,10630,14791,19048,23241,14855,17066,25517,27792,15244,9002,6986,4874,2761,2761,2729,2761,2762,2794,2826,811,908,908,908,908,908,940,908,908,940,940,973,972,973,973,972,973,972,972,940,940,973,973,940,940,908,908,876,876,811,746,714,714,714,714,714,714,746,843,875,875,907,907,907,907,875,907,907,907,907,907,875,907,875,875,907,874,255},
{34232,34232,34232,34232,34199,34200,32151,32151,32151,32151,32151,34231,32151,28023,30103,30103,32151,32151,34199,34199,32151,40407,52791,42325,42357,40277,25585,13102,15215,44437,50743,46518,46550,48631,29875,33938,35986,40146,35953,33905,33905,33873,31792,33873,31792,27599,25486,23374,17132,19213,31858,19277,17229,19277,19245,21358,25519,42324,52824,46452,46484,44404,50614,37968,44437,35919,23340,46321,48466,35789,39950,35756,33676,29516,6567,4519,2406,10793,29614,29614,35888,23275,12872,21194,19145,15017,12937,15017,12904,19242,31757,40179,44372,58771,50384,58966,56885,52627,54771,52659,46320,46288,39949,37868,42126,35755,37803,39981,35658,33643,33708,29482,37868,31627,23242,16969,12776,25421,17002,10695,14888,42193,46385,44207,44239,40079,42192,23275,21195,25420,25420,25388,23275,33807,31694,31661,35984,38098,27305,25257,33806,48531,33807,44372,23274,19049,10694,10662,14855,14855,19048,14855,12743,12775,12711,14823,23209,23209,18983,23241,25321,27402,19048,14855,14823,19016,23241,21129,17065,19146,14985,17259,13228,11147,6954,4873,2826,2793,2729,2729,714,2794,2826,811,876,908,908,908,940,940,908,908,940,973,973,973,973,973,972,973,973,973,972,940,973,941,940,940,908,908,876,843,779,714,714,714,714,714,714,714,746,811,843,875,907,907,907,907,875,907,907,907,907,907,875,875,875,875,875,874,255},
{34232,34232,34232,34232,34200,34200,32151,32151,32151,32151,32151,34231,30103,28023,30103,30103,32151,32151,34199,34199,34199,34199,44503,48566,38132,33971,23471,8909,25682,36019,50744,50743,50744,44438,31825,23470,21390,29710,25453,23341,23341,21293,19213,17132,12971,12939,12939,12907,12874,15020,29777,23406,23373,21325,21293,19213,38065,46353,44437,50709,42259,40179,50679,42258,46452,42193,35887,42063,37869,21129,19017,19017,14889,12841,4519,4487,4455,12906,25453,19146,27534,23340,17065,23274,21258,19178,21226,19114,10728,12904,15049,36018,52725,61014,52693,52691,54805,52659,54772,52659,44274,42258,35919,40079,44306,35854,37934,44273,35822,35854,44273,35820,25322,33805,37934,29580,16969,21130,19082,12776,14888,42225,40047,42159,46352,46385,40112,33806,27501,25421,27469,23275,23275,33806,31694,25355,35985,42356,25225,21097,33774,50678,23275,19049,23274,21194,14856,12743,16936,16935,21128,19016,16903,14823,10662,16935,21096,23209,25289,25321,27369,29514,12742,19049,19017,21129,25322,21161,17065,19210,15114,15276,13260,9131,6954,4938,2858,745,681,681,714,2794,2794,811,876,908,940,940,973,940,908,940,940,973,940,973,973,973,973,973,972,973,973,972,973,940,940,940,940,908,876,811,746,714,714,714,714,714,714,714,714,779,843,875,875,875,875,907,907,907,907,907,907,875,875,875,907,875,875,875,255},
{34232,34232,34232,34232,34199,34199,32152,32151,32151,32152,32151,32184,30103,30103,30103,32151,32151,32119,34199,34199,34199,32151,34199,29875,15183,13167,19441,29778,29810,36052,48598,46551,48663,40244,46517,46550,48630,50678,48565,48533,46453,40179,27632,17230,17165,17132,19180,21228,19115,27632,40277,29647,29614,29582,27534,25453,31727,35888,46550,52758,40211,50711,46583,48630,50645,50579,35855,23243,25323,16969,10728,8615,4454,4455,2374,10793,14955,12874,25454,21293,23341,23372,23371,23371,23370,19146,12840,8647,10695,17065,17097,33740,54706,54805,48499,54772,54772,52692,59031,56951,42194,44339,38033,40112,44274,40080,40080,42194,40081,35919,40080,38032,23210,27533,35918,27467,14824,17001,14855,12743,19081,44338,44272,46385,44272,44207,37966,37967,27501,27501,25388,23275,25356,27501,25453,17001,40112,44273,35756,37901,44339,48565,21195,10695,23307,21195,16968,12678,19016,19016,16935,14791,14823,19016,16903,21129,23209,21128,16935,21128,27369,27369,14823,16936,19049,21161,23241,17000,14952,14985,12969,15276,13195,9067,4970,2923,842,746,713,681,714,746,778,811,875,908,940,973,973,941,908,940,972,972,973,973,973,973,973,940,940,973,973,973,940,940,940,940,908,908,843,779,746,714,714,714,714,682,682,714,714,778,811,843,843,875,875,907,907,907,907,907,907,875,875,875,907,907,875,907,255},
{34232,34232,34232,34199,34199,34199,32152,32151,28023,25910,25910,27991,25943,25943,23862,25943,28023,27990,30071,32119,30071,32151,34199,25715,11087,23634,25715,34004,36052,33971,31858,27730,36051,31922,48630,52824,54904,54871,52791,54903,42291,27534,27567,25518,25454,23373,21260,23341,23373,50744,52791,50646,48532,46452,46420,40146,29647,35985,48630,48500,33807,44438,46518,44372,44306,42193,46321,40015,37934,35854,27468,19082,16969,10760,6567,31792,21260,14987,21293,19180,21293,33840,25581,21322,23370,21194,10728,6599,8647,17065,29710,38032,44206,54806,46386,54772,50514,46321,48466,46419,38065,44339,38033,38032,42226,40081,38000,42193,40113,37967,38000,40080,21129,29580,37999,25387,14856,14952,14888,10630,23242,46419,44240,44272,44272,35853,42159,31694,25388,23308,23275,19082,21195,25388,23340,23242,39982,37967,52790,59130,52759,48565,23405,12841,19179,19049,16904,12743,21064,23209,16936,14823,19016,23241,16968,14855,21128,25321,25321,27402,27401,25321,19016,16936,19049,21161,23209,14920,14920,14952,12904,13195,11050,9034,7019,2890,2858,778,746,713,714,746,778,843,908,908,940,1005,1005,940,908,973,972,972,973,973,1005,1005,972,972,973,973,973,972,940,940,940,940,940,908,843,746,714,714,714,714,682,681,681,681,714,746,811,843,843,875,875,907,907,907,907,907,907,907,907,907,907,907,875,907,255},
{34232,34232,34232,34232,34199,36182,34167,25846,9137,4976,7024,9105,9105,9137,4814,6992,9170,9137,11218,11250,9072,9104,21554,38229,33971,31923,34004,38196,40212,38164,31858,23536,40310,42390,50809,52857,52856,52856,52824,52823,31760,25453,29582,29582,27501,27502,27469,23341,25486,54937,52824,52758,50678,48598,48597,38098,29679,38099,48598,44273,46224,42357,44372,40211,54871,48499,46288,48531,46386,40112,37999,27501,21194,21162,23340,42259,17034,10728,10794,8681,14986,27599,25517,15049,19210,19113,14889,12808,12808,21161,46484,54839,40047,44175,46320,44175,50481,52594,46287,46451,44273,46419,42160,42160,44273,42160,40080,40112,42192,40047,37934,40080,21162,27532,40014,25323,12776,12808,21162,14855,27435,44306,48433,44272,37966,37966,37999,29613,12809,8615,23242,25355,19114,27533,27534,25388,37902,33807,50743,61244,57083,54970,25453,12873,17034,19017,19048,19048,25289,27401,19016,16936,21128,23209,23241,25321,25353,27402,25321,19048,27369,21128,12710,16936,19049,21129,21129,16968,12872,10759,10856,13195,11082,9002,7019,4809,2826,842,746,746,746,778,843,908,908,940,972,1005,1005,973,940,972,972,973,973,973,973,973,972,972,973,973,973,973,940,940,940,940,940,908,811,746,714,714,714,682,681,681,681,681,681,714,778,811,843,875,875,875,875,875,875,907,907,908,907,907,875,875,875,875,255},
{34232,34232,34232,34232,34167,34166,34167,15346,9105,9105,9105,9105,9105,9105,6992,4944,7057,7056,7024,7024,6991,17458,23635,34003,38131,36051,40244,48598,34035,38164,25584,29843,42325,38164,38132,38164,40212,40212,40245,44405,31760,25486,27534,25454,27501,25421,25388,23309,21228,27599,52823,52725,52726,46452,40146,27599,23373,23406,46517,50579,46354,50744,44404,38098,44339,46386,44306,50547,44273,44306,42225,42192,35886,33806,23307,19146,14953,8647,6567,10696,10761,27632,23437,12936,19146,17001,14889,14889,14921,33741,52758,52791,38000,31563,44207,27370,29483,31628,35821,50611,54805,50513,50479,50512,50513,42061,44207,40047,42029,46287,50513,50414,29547,31693,40112,21194,12776,10728,21163,14823,29581,46418,44272,42160,31628,35886,35887,31726,23275,12808,10695,21129,29614,33806,29712,21162,33709,33839,52856,61244,61244,57083,21228,10760,23340,21161,19016,21096,23209,18983,16903,19016,21096,21096,27434,27434,27434,27401,27402,29514,27369,16903,10663,14856,19017,19017,21097,23274,10759,8647,10856,11082,13195,9067,7019,6857,2826,843,810,778,778,843,875,940,908,940,973,1005,973,973,973,973,972,973,973,973,973,973,973,973,973,973,973,973,940,940,940,940,908,876,811,714,682,682,714,682,681,681,681,681,681,714,778,811,843,875,875,875,875,875,875,875,875,907,907,907,875,875,875,875,255},
{36280,34232,34232,34232,34199,34232,32118,19572,13265,13298,15346,15346,15346,15346,11153,11185,11250,11218,11218,13298,11152,13200,19474,21489,21424,29746,40180,44405,44502,44438,33939,36084,48630,42323,33840,25454,23341,19181,17100,27502,33905,31727,31727,29647,29582,29582,27501,25421,23340,23373,38066,40179,35986,31695,25389,23308,21228,23373,29777,40179,44404,48533,48532,50711,44371,48565,52791,54805,50580,46418,48564,50579,46354,33840,17099,12905,19146,14985,10760,12808,19148,23406,12938,12904,16969,16969,14921,10728,15018,40113,52660,46452,42193,31596,33643,29450,29450,29548,29548,48564,54871,42126,46319,46286,44173,37835,33675,29514,31627,31563,31628,37901,37900,33773,42192,21162,21097,21162,16969,14823,31693,44338,46419,44338,40113,33839,33807,29581,29547,33710,27436,23241,31627,35853,29679,27469,31596,33872,57050,61211,61244,57083,21260,10728,29580,23242,21129,21129,16903,19016,19048,14855,16935,23208,33707,37932,31627,31627,33740,29482,27401,23208,14823,14856,16936,16936,16936,14888,10727,8679,8744,11050,11179,11147,6987,6890,4874,875,810,810,778,811,908,940,940,972,1005,1005,973,973,1005,973,972,973,973,973,973,973,1005,973,973,973,973,972,972,940,940,908,908,876,779,714,682,682,714,682,681,681,681,681,681,681,746,811,843,843,875,875,907,907,875,875,875,907,907,907,875,875,875,875,255},
{36280,34232,36280,34232,34199,34232,36214,29973,27860,32053,34101,36149,34037,34069,27795,21587,23733,21652,21652,23699,19474,17393,27698,10893,4651,19311,31825,40179,38131,38099,29712,33938,40179,38033,27534,21228,17068,14987,21228,31695,33873,27599,29679,29647,29614,29582,27534,27501,25421,23341,23438,33905,23406,23308,35985,40146,38099,35986,33938,38098,46485,48630,38131,50646,48564,50645,54871,52725,52758,52790,50547,48466,42226,27567,25486,14922,14985,17065,10760,17001,29582,19213,15051,10760,14921,14921,12840,8680,14953,42291,52692,48565,44274,29580,33644,31563,29450,29483,31596,44306,56952,46320,48432,48431,48399,42061,37868,33707,29482,33675,35788,25322,33741,37901,40015,19049,29385,23145,12775,14856,33806,44274,44338,42226,35920,31727,27501,31596,44305,27567,25453,25354,27434,31661,29745,25453,33676,33872,57050,61244,61244,59163,25421,12841,35822,33806,21162,21129,19047,40013,37900,23241,19048,16935,29514,37933,31659,33707,35852,27402,25289,27434,23208,23241,21161,14855,16936,10695,6534,6567,6534,12969,11050,11051,9002,6890,4842,2891,810,2826,778,811,940,940,973,1005,1005,1005,1005,1005,1005,973,972,973,972,973,973,973,1005,1005,1005,973,973,973,940,940,940,908,876,843,746,714,682,682,682,682,681,681,681,681,681,682,714,778,843,843,875,875,907,907,907,875,875,875,875,907,875,875,875,842,255},
{36312,36280,34232,34199,34134,34102,40310,29713,23407,23472,23471,25520,21359,21391,21359,23439,25584,23504,23536,25584,23439,27567,27632,8910,4717,17264,42292,44307,44242,42194,31760,38132,25519,17165,17165,25519,25486,27567,29680,48565,33905,27599,31727,29647,29614,29646,29614,27501,25421,23373,38131,40244,40212,44371,50678,42259,42324,40178,33905,31825,33873,33840,29679,46517,33840,33807,38033,33839,38033,38000,31694,23340,27534,25421,17066,8680,6599,10824,6567,12841,31694,19213,15116,12872,12808,14921,14888,10728,17033,46419,56886,54904,48499,31661,33644,33643,27369,29450,31628,40048,56984,48465,50480,50512,50512,46253,39948,37868,39981,42126,44206,31595,23210,23275,23274,23274,25225,14823,25322,23274,31661,35855,35887,38000,33807,27533,23242,48465,46484,27632,29613,23274,23241,29515,33906,31694,33643,33840,54937,59131,59163,59195,33807,12840,35854,35887,23242,25354,31594,37932,35787,29514,21128,19048,27401,27434,29547,23241,21161,19016,21128,25321,23241,25289,27466,21096,23241,21161,14888,6501,8550,12905,15147,12969,8906,6825,6922,4906,2858,2794,2794,875,940,1004,3085,5165,1037,1037,1005,1005,973,973,972,972,972,973,973,1005,1005,973,973,973,973,972,940,941,940,908,876,811,746,714,682,682,682,682,682,682,649,682,681,681,714,778,843,843,875,875,875,875,907,875,875,875,875,875,875,875,875,875,255},
{36312,34232,34232,34200,32119,34231,38327,36149,36150,34102,34102,32054,32086,29940,27827,38229,38164,40244,40212,36019,25585,36116,29778,2603,491,17231,42194,40179,44209,37969,19213,23471,27696,21390,19278,36018,38099,38067,35986,40146,31792,29647,29614,29581,29581,29581,27501,27469,25388,23308,31792,33841,31792,50711,50678,50678,48597,44372,29712,23373,23373,42258,35952,50711,31760,25421,31694,27534,31759,33775,31694,21260,19147,10761,14985,14985,10792,12873,6567,6600,29646,25454,15051,12840,14888,17001,10728,8647,17066,46451,54773,52823,48532,42257,40080,40014,35821,35853,37966,38000,56951,50611,48399,50545,50512,48367,37867,35755,50447,48367,42061,35788,25387,14954,8615,12776,12808,17034,29613,25355,27436,39692,33612,31727,31727,19114,42159,52725,23308,23406,35887,37967,33741,37967,27566,33807,31563,31759,52856,61243,61243,61276,38001,19049,33709,35887,21226,21129,37867,35819,31594,31594,37900,29514,25321,19016,14855,16935,12710,12743,19048,27401,29514,27434,27402,23241,27434,31659,23274,8550,8582,23469,29841,17066,15115,10986,4939,2891,2891,4874,2891,940,972,5133,9294,11342,1037,1037,973,1005,1005,973,973,973,972,1005,973,973,1005,973,973,973,973,972,940,940,940,908,843,779,714,714,682,682,682,682,682,681,649,681,649,681,714,778,811,843,875,907,875,907,875,907,907,875,875,875,875,875,875,875,255},
{36312,34232,34232,34232,32151,34232,34232,34232,34232,32151,32184,34232,32183,32151,34231,36279,36247,46583,42292,15346,2928,25813,27763,4716,620,12973,42227,40277,35953,31760,19246,38196,46550,38197,36083,38098,40178,40178,40114,44339,38065,38099,42324,44339,44339,42259,42226,40146,40113,38033,27567,29745,27664,42324,50711,46484,42291,42323,40210,27566,21293,35985,50613,48630,33873,27566,29646,29582,29647,38099,27599,25551,19244,15018,19178,17066,17066,10727,4487,4487,31727,25421,14986,10760,14920,14921,8647,10728,12840,25420,48565,52791,50644,61144,61144,61144,61111,61078,61078,58998,54838,54805,48367,50545,46287,42093,42093,31595,46286,46287,29482,33740,31660,19147,10728,12808,14888,14921,25454,23242,27436,39757,31629,29614,23340,31725,58998,27533,17034,27501,37967,44078,40113,42225,29647,27468,33677,31727,50743,61276,61244,61276,35953,12808,31661,33774,27468,25321,48398,46253,31594,31659,44206,42125,33739,19080,16968,14888,21161,21193,23241,21096,27433,29514,33675,35852,33739,35788,25354,10662,10694,25517,40341,27696,15180,9003,2923,2923,4939,4907,2988,3020,5101,7213,11374,11342,972,1005,1005,1005,972,972,1005,1005,973,973,973,1005,1005,973,973,973,973,940,940,908,908,908,843,746,714,714,714,682,682,682,682,649,649,649,649,681,682,746,811,843,843,875,875,907,908,908,907,875,875,875,875,875,875,875,255},
{36312,34232,36280,34232,34232,34232,34232,36280,34231,34231,34200,34232,32151,32183,34231,34199,38359,46486,44340,15346,7089,27860,33938,23472,11022,15052,33775,44340,35920,33873,25519,44470,44470,31987,34035,52757,52692,44273,40015,46387,42259,42324,48630,50678,50645,50612,48532,46387,42194,40081,31760,33906,31825,40211,52823,54903,52823,50678,46420,31760,25518,36051,42292,48566,38099,33905,35921,31760,31792,38131,33873,33840,23405,19212,12905,6567,10792,4454,2406,4487,19114,19115,19147,8712,10792,8679,6567,10728,14921,17033,44339,54904,58965,58965,61013,61045,58932,58964,58964,58932,52725,56919,46352,52691,35821,23177,37966,52724,46319,48433,44239,44239,37934,25388,21260,21227,16937,12808,19114,21162,29581,27501,33774,33742,27500,54804,48532,17002,29581,38000,35887,35822,35822,40113,29680,17002,29548,33807,48630,61276,61244,61276,38098,21227,37967,33774,25419,27369,37834,48334,54672,54673,44173,37900,25321,14855,14855,14823,27467,42126,40013,44173,56785,56785,54705,56851,56818,54737,52657,31594,25288,19275,36212,25647,12970,9003,5003,2923,4907,4939,2988,5068,7181,9229,15438,5133,940,973,1005,1005,972,972,972,1005,1005,972,973,1005,973,972,973,973,940,940,940,908,908,908,811,746,714,714,714,682,649,682,682,649,649,649,649,649,682,714,811,843,843,875,875,907,908,908,907,875,875,875,875,875,875,875,255},
{36280,36280,34232,34232,34232,34232,34232,36280,34232,34232,34232,34232,32151,34231,34231,34199,42455,42260,40179,23667,17458,36148,42292,38099,15183,25519,33742,46453,46386,44307,33807,38132,44470,38196,38163,56918,50612,40112,31792,29679,48565,54871,56952,56951,59031,56951,56918,44306,35888,31727,27600,40212,48597,52791,52790,52791,52791,50710,48597,38033,27631,38164,46550,48630,44437,44404,44372,42291,44339,44372,42259,42226,38098,29679,14953,6631,8712,4422,4455,2406,12808,25518,14986,12904,10791,10759,10727,10695,12873,19114,50645,59064,56885,54739,54773,46319,48400,50480,54706,52593,50612,56951,52691,54804,48465,42126,48465,50644,46353,48433,46320,46320,35821,31661,42193,29614,21293,17067,10728,21227,23340,23308,31694,27468,46385,54805,33774,31694,42160,35953,35953,33774,33742,38000,33938,17067,27435,33840,38000,57017,59195,61308,35920,14856,37999,33774,27467,33675,37866,46220,41995,27401,18983,25321,25385,25353,31659,29547,19048,21096,31594,31562,39948,46221,50446,46253,37867,39980,50447,37867,19112,19307,29905,34002,13002,9067,5036,5003,4971,7052,9164,7116,7116,13357,11309,1005,972,1005,1005,1005,973,972,972,1005,1005,973,973,973,973,973,973,973,940,940,940,940,908,908,811,746,714,714,714,682,649,649,682,649,649,649,649,649,682,714,779,843,843,843,875,907,908,940,907,875,875,875,875,907,875,875,255},
{36280,36312,34232,34232,34232,36280,34232,34232,34200,34232,34199,34232,32151,34231,34199,36247,44438,35954,35987,23602,13233,34035,44405,31858,17263,29777,27469,38132,46453,44470,36019,29778,40211,33938,29744,31760,50678,54838,36018,27599,48565,52758,52726,50677,46419,46386,44274,42259,38066,40146,29712,31792,42259,40146,31727,25454,31825,46517,46452,37903,21293,27696,36017,50743,59097,59097,59065,59097,59097,57017,57049,57017,57016,57016,52725,17098,6631,4487,4487,6567,14953,29712,19180,14984,10759,6599,10760,12808,10728,12905,50678,59065,54838,54837,52659,50612,52757,54837,39982,35755,46320,56952,56885,56884,52691,52691,52658,50677,48499,46320,44272,44272,40047,29581,42193,21261,27600,19180,14954,25388,21163,23308,27501,37934,56885,31759,35887,44274,38000,33938,40180,35855,33807,35855,33807,23340,31595,35920,35855,42160,59130,61276,38065,16968,31628,33839,31628,35787,39947,42059,39915,33674,46319,52657,46351,42125,48497,50512,50545,44238,33675,37868,42126,42093,50446,50511,48398,50478,54672,37932,17098,19275,23501,34002,13164,9132,5101,5068,5068,7148,9197,9196,13293,19533,3053,973,972,972,1005,1005,1005,972,972,972,973,972,973,973,973,973,973,972,940,940,940,908,908,876,779,714,714,714,714,682,649,649,649,649,649,649,649,649,649,714,778,811,843,875,875,908,940,940,908,907,875,875,875,875,875,875,255},
{36280,36312,34232,34232,34232,36280,34232,34232,34232,34231,34231,34231,32183,34231,34199,40407,46453,44308,42260,17426,9040,31988,36116,19312,17264,31857,29615,34003,48565,31858,29778,25520,21391,31727,25454,17100,40244,57017,27567,19181,33873,48532,48532,48565,48532,46419,31694,36018,40179,44339,48630,44404,31760,21228,12907,8713,21293,44404,46452,38001,40211,33905,42324,54838,56951,56951,56919,54871,56952,54871,54903,54903,54870,50612,38000,19178,8744,6567,6567,8647,12841,23439,15019,15016,10759,8679,8711,6599,8680,10793,50776,59097,54838,56820,52560,50513,56918,46385,29547,35723,35788,54870,58998,56885,50578,48465,52659,54805,52757,46352,46353,44272,40079,29613,27501,21194,29679,19180,19147,19115,17002,21195,29516,50644,48531,25421,33807,23243,23307,35920,38000,35919,33807,37934,38000,29679,27370,33807,33873,40113,54904,44339,37967,27435,46353,35886,35788,44206,50413,52559,54705,54705,54705,46318,35819,31594,37867,42093,39980,50479,37835,46254,46319,48464,50512,52592,54704,54737,50479,31726,19243,17194,19308,23566,15309,9132,5133,5133,5101,5101,11277,13293,21549,13325,972,973,940,940,972,1005,973,972,940,972,972,972,972,973,973,973,973,972,940,940,940,940,908,876,779,714,714,714,682,649,649,649,649,649,649,649,649,649,649,682,746,2859,844,844,843,908,973,972,940,908,875,875,875,875,875,875,255},
{36280,36312,34232,34232,34232,36312,34232,34232,34231,34231,34231,34231,32183,34231,34199,44503,46420,46420,46420,17361,9007,31923,33971,23504,13102,23504,29648,25617,40179,19246,23472,25520,23472,29648,25584,23439,27631,31825,21390,17068,12939,15020,23341,31727,33873,33807,29550,38066,52824,46485,50645,50711,31826,17100,15052,25551,38196,44404,40113,35952,42291,42323,44371,50645,50613,48564,52790,54871,52790,54904,52791,52791,52790,44209,25387,17098,10824,8647,6535,8648,10761,15052,12937,17161,12904,10792,10824,6599,6599,6599,40211,57017,54838,50480,50447,44239,50578,42159,37967,35723,37868,54805,54772,54805,59096,57015,61177,56984,54903,54838,52758,52757,50612,29581,12743,27501,29744,17067,19082,10728,17034,21195,48433,50579,23275,40080,31758,14889,19114,37968,37968,33775,19114,37868,42324,33970,25355,31694,33904,35985,33742,37902,44240,44241,48466,31693,31627,44206,46220,54606,54607,54673,56818,52624,48399,48367,29513,33674,44140,46286,33674,44206,42158,42093,46286,37867,37867,50479,48432,33936,21420,17324,17388,15308,13228,9035,5101,3085,3053,5068,9196,21517,19469,2988,973,973,940,940,940,973,973,972,940,972,940,972,972,972,973,973,973,972,940,940,940,940,908,843,746,714,682,682,682,649,649,649,649,649,649,649,649,649,649,649,4843,6955,7020,4939,2891,2988,972,940,940,908,907,875,875,875,875,875,255},
{34232,36312,34232,34232,34232,36312,34232,34232,34232,32151,34232,36280,34199,34231,36279,46518,46420,42260,33906,17393,7024,36116,38132,31923,31890,42325,46518,33906,23374,25487,27665,25520,25520,25551,42358,46551,42358,38164,23406,12971,10891,10859,10859,31760,36051,33872,31694,33807,46485,44405,50645,50678,33938,17165,21358,34036,40277,40277,31857,33906,36083,48598,48466,44306,42225,40112,44306,46387,31792,27566,33807,35920,27468,39919,29549,8744,10824,6567,8648,6567,4519,10824,12936,15080,15016,12872,12872,8711,19179,17001,17066,21227,27436,21129,23209,35788,50546,42192,40111,44174,35690,41930,39849,50546,56951,56918,52691,56951,59097,59129,59097,61177,52693,25387,33773,29613,29679,17035,19147,14954,12874,19082,37934,48531,31759,44305,44305,38032,33806,35920,38000,25453,14921,33707,38164,27534,27467,31694,31791,33774,21064,40015,44273,33774,33806,31693,25256,31529,33609,39947,39980,48334,52592,48399,50511,50446,46318,48399,39947,46351,44238,50512,48399,39980,42060,48398,39948,46318,40013,31921,19340,17324,17421,15341,15309,8970,3085,1037,5101,5068,11244,27758,9164,972,973,972,973,940,940,973,940,940,940,940,940,972,972,972,972,973,972,972,972,940,940,940,908,843,746,714,682,682,681,649,649,649,617,617,649,649,649,649,649,649,11116,23665,19536,6923,4907,5069,3021,940,908,908,907,875,875,875,875,842,255},
{34232,36280,34232,34232,34232,36312,34232,34232,34232,32151,34231,36279,34231,36279,38359,44405,48533,42260,33873,19409,4912,31956,40309,31923,34003,44470,46485,40082,21294,33808,29712,29713,25552,36082,44438,31956,31891,33938,19181,10826,6666,4618,13004,29744,44438,59065,38033,31694,33807,35888,35887,48565,42357,23536,21521,21685,25649,25617,17230,17230,17263,29744,38097,33872,33840,27566,21292,19180,12939,14955,19114,33871,19113,21195,14921,8712,8744,6567,10794,6567,6664,12904,17065,15016,17097,14952,12904,14985,40112,25387,23275,23275,12808,12808,14856,40014,35854,19081,40079,46254,37802,39882,39849,37770,31529,27337,37868,54839,59097,59097,59032,56984,48465,42159,31628,31628,17034,14921,19115,12972,19310,29613,31661,54870,48532,44305,44306,44306,40080,33839,29614,19179,25354,35821,35920,23340,27403,31661,33807,31661,23242,42160,37998,48430,42093,33642,21096,23143,27337,19016,14887,27401,35819,48399,48432,46253,44172,46286,42060,52592,52592,37803,42061,35755,39979,50511,42125,29513,27565,23502,15114,17324,15308,15341,15277,11115,3117,3085,5101,5069,15373,23597,2988,973,972,940,972,940,940,940,940,940,940,940,940,972,972,972,972,973,972,973,972,972,940,908,876,811,2762,2762,682,682,649,649,649,617,617,617,617,617,617,617,649,8971,21487,25518,38196,23633,13262,13391,5101,940,940,908,907,875,875,875,875,875,255},
{34232,36312,34232,34232,34232,36312,34232,34232,34232,34232,34231,36279,36280,36279,40407,46453,44372,44340,40179,19409,2896,15280,34036,46518,46518,38132,35986,31728,27599,33841,27632,29713,27665,42293,31924,11022,13037,44404,33873,29647,25552,25552,29745,29745,44437,56984,46451,46451,48499,46387,44338,40211,27664,27729,25682,23862,25617,15117,4682,2602,2569,2602,4617,4617,4585,2504,2537,15052,17165,15018,17066,19146,14953,15018,12808,25290,6664,6599,4519,8712,8711,12808,23306,19177,17129,12840,14985,17065,44305,29548,21195,21227,14920,12808,19081,46385,21194,19081,27435,39981,35722,39882,39882,37770,33609,29450,35788,56951,61177,59065,56951,33774,35853,29547,23241,29581,16969,17034,17034,17034,36050,46385,50578,54838,46386,44241,44306,46386,40112,29679,17132,14954,33709,46418,40113,23406,21161,29581,33807,27403,14759,31661,42158,52556,29449,14822,23111,23143,21064,14855,14823,14920,31627,44239,21128,23240,37867,42060,46285,48366,42092,44205,48399,44173,50478,50479,44173,27434,38131,21389,21485,25711,21486,19405,13067,9100,3118,3085,3053,5069,19501,11180,940,940,940,908,940,940,940,940,940,940,972,940,972,972,972,973,972,1005,973,973,972,972,940,908,876,811,2762,714,682,650,649,649,617,617,617,617,617,617,617,617,8874,19276,23371,19080,27534,52955,32116,9133,2956,908,908,907,907,875,875,875,875,875,255},
{34232,36280,34232,34232,34232,36312,34232,34200,34232,34232,34231,36280,36279,36279,40342,44373,42259,46420,40147,23569,19571,23667,25715,36084,44405,31858,31793,29712,25519,29810,21358,6731,19311,46486,19344,15183,17198,29615,40146,42259,44372,42259,44372,42292,52790,50612,50612,52724,52725,50514,46353,33840,23373,25519,25584,34035,29778,17198,6828,2634,2569,2602,521,489,2505,2504,2504,12939,17131,14921,21227,12841,10793,17033,29385,33578,6631,4551,4519,10824,8711,14921,27499,23338,17097,10792,6566,23371,48466,33774,21194,21226,17033,14920,44370,50580,23274,14920,23242,37933,39915,37834,39882,37802,35690,31562,31628,50678,52791,50645,48499,27500,25420,17033,21194,23275,14857,16969,14921,23275,33873,46353,46353,35854,40080,44305,46386,46386,38032,31857,15019,27468,23308,35984,40112,19147,27435,29580,31727,21194,14791,23242,40012,44171,23176,16870,23111,25159,23111,21063,23176,16935,23241,33740,25354,21128,27401,25321,29513,31561,39979,44173,52592,39980,42060,35787,31594,21227,23502,21389,25647,27760,25615,21422,10986,7084,3085,1005,972,7148,15373,907,908,908,3020,908,940,940,940,940,908,940,972,940,940,973,972,972,972,973,1005,973,973,940,908,908,876,778,2762,682,649,649,649,617,617,617,617,617,617,617,617,8874,15018,19146,23274,23273,17001,46518,44632,15375,7084,5069,908,907,907,875,875,843,843,875,255},
{34232,36312,34232,34232,34232,36312,34232,34199,34232,34232,34231,36312,36280,36279,42422,40180,38067,48501,31793,29843,34069,27795,23635,19506,38164,38164,40212,33938,29745,38197,29842,17198,25551,42358,19376,19376,19246,21261,33873,33873,46452,42258,50613,44405,57017,54805,52757,56918,54805,50645,44405,40179,38033,31857,31890,38163,38229,23503,13166,4747,2569,2537,457,424,456,456,2537,15019,14953,14921,23373,12841,19146,14985,39786,43946,10792,4551,6567,10792,12936,21226,27467,23370,15049,8711,6567,21259,48499,40047,29548,25386,14952,14920,31693,21194,12840,14953,23242,35853,42028,37802,41962,39850,35690,29482,21097,16969,27501,23274,25321,35886,33839,33839,33774,29515,25322,25322,25322,27435,31694,44306,46386,31661,37999,46386,44306,44306,31760,27664,25420,29614,17100,35919,40112,19114,27468,31596,31759,27436,14823,23242,37964,40011,21096,21063,23143,21063,18951,18951,21031,23176,19016,16903,18983,23176,21096,16903,18983,29449,31529,35722,39947,33642,31594,21128,10662,10760,21422,17163,27696,25615,23372,21389,9003,5036,972,940,940,13325,9164,908,843,843,908,908,940,940,940,940,940,908,940,972,972,940,972,972,972,972,973,973,973,940,940,908,875,746,2762,2730,649,649,617,617,617,617,617,584,585,617,4681,17066,17033,17000,21161,23273,19178,19179,44535,21649,13326,9230,908,875,875,875,875,842,843,875,255},
{36280,36280,36280,34232,34232,38360,34232,34232,36280,34232,34231,38360,36312,38359,46551,40212,38131,46453,40245,31891,17329,21554,34069,19506,36116,50645,46486,40211,38196,38197,40342,46486,44405,36149,27698,19376,25552,29615,21326,25519,42226,35953,46452,42259,54904,52725,52757,54806,50645,33905,48663,36018,44338,35888,31825,40276,34132,23665,13101,13004,13004,12939,10858,8778,8745,6698,15085,19211,17065,23438,33873,14921,17065,17032,50187,56363,25289,6632,6599,6600,12937,25452,23306,17097,17097,17129,8679,29580,48466,44272,44239,42125,21193,17066,12807,12808,14953,17098,21259,37999,44174,37835,44108,41995,33642,21161,23242,21161,29581,23307,21194,33838,25387,35887,37967,35820,35788,35788,33707,33707,35854,42192,46418,42193,40080,44306,44306,40178,27599,23341,31695,23439,23439,35920,40145,27533,31759,25387,31759,25388,16937,19082,33739,37931,19016,16903,23144,16936,8582,12710,14790,14790,14790,18983,18951,16903,16871,16935,16903,21063,25224,25224,31529,31594,21063,29514,21161,12872,23502,17196,23405,31922,21325,17261,6987,2988,875,875,2988,11244,2956,2956,843,778,875,908,940,940,940,940,940,2988,2988,972,3021,2988,940,972,972,972,1005,973,972,940,940,908,843,746,2730,2697,649,617,617,617,617,617,617,584,585,4713,14953,19048,19048,19015,19048,19048,23371,12938,38131,29971,17520,2956,875,875,875,875,875,842,842,842,255},
{36280,36280,34232,34232,34232,36312,34231,34232,36280,34232,34199,38360,38328,40407,48631,38100,33971,42292,36084,36051,19409,13200,29908,29908,40277,48533,42260,44373,44438,50744,48663,42260,29713,40277,29811,19375,27697,33905,25519,29680,44307,35953,15117,17262,33840,44306,52692,52692,50678,38164,46583,42325,44306,35920,31727,44340,46517,46517,33938,36083,31890,29712,27600,27632,25584,17165,15020,21291,21389,27697,17099,8647,6599,17065,52234,56395,37739,8712,4551,4454,12873,25453,14920,17161,17129,19209,17065,42160,40079,48433,48432,25386,40145,29677,19178,44436,44371,46516,50644,52758,50677,50677,50677,50644,50644,48532,48564,50644,48564,48564,46484,48532,50612,48564,48531,48498,48498,48498,46418,46385,40112,40079,46386,48532,40112,44273,46386,36018,19180,23308,21260,23438,25453,33839,31694,27534,31791,19114,29646,23275,19082,14954,25321,25289,14855,10662,10662,10662,10630,10630,12710,12710,14823,16903,14823,12710,16903,16903,14791,16838,18951,18950,23143,27337,16870,25321,12775,12905,21422,19308,25583,19276,12938,13035,4907,875,810,2891,5004,5004,908,875,811,779,875,940,908,940,940,940,940,908,908,2988,2988,2988,940,972,972,973,1005,972,940,940,908,908,843,714,681,2697,2665,617,617,617,585,585,584,2632,4616,10792,21193,23241,19048,19047,16968,16968,29678,25582,33905,32052,9101,875,875,875,907,907,875,842,842,842,255},
{36312,36280,34232,34232,34232,36312,34232,34232,34232,34232,34231,38360,38360,42455,50711,38132,31890,40213,34004,40244,17328,13135,27763,40277,38197,38164,36051,38132,42358,52857,50711,46550,44437,46486,42422,29843,31988,42356,31792,21293,46452,46518,10924,8843,23374,42031,46419,44338,40211,42357,46550,48598,44340,25453,38098,44372,40179,38098,31792,36051,27665,23374,21293,21326,21293,15085,10858,21226,19310,23536,10792,6535,10728,19081,46026,52267,41965,17066,8712,6535,14986,29679,17033,14984,15049,19241,17097,40112,44240,46320,40079,40145,48564,40144,42258,48564,44338,48467,48369,52725,52790,52758,52790,52790,52790,52758,52758,52758,52757,52757,52725,52725,52725,52725,52693,50644,50644,50644,50644,50612,37999,33773,46386,48531,35887,42225,40048,40146,23373,25584,15019,27534,29614,29614,27404,19115,17001,25355,27533,29613,29548,27467,29481,25288,21128,16935,12775,10695,10663,10695,12742,12775,12775,14855,25321,25321,27433,23176,18983,18983,21096,27369,23208,18983,14855,12743,6469,10760,25616,25648,25518,14986,10825,8874,4874,4842,4842,4907,4971,2923,875,811,811,811,843,908,940,940,908,940,2988,940,908,940,2988,3021,2988,940,973,972,940,972,972,940,908,2924,811,714,649,2665,2665,2633,2633,2633,2632,4680,8776,12905,19145,19048,19048,23273,21128,19047,21160,19081,25419,31758,46518,42552,19633,11343,940,908,940,940,875,875,842,842,255},
{36280,36312,36280,34232,36280,36312,34232,34199,19636,34264,34231,38360,38327,44503,50646,38132,31858,38132,29811,42325,25714,25714,33971,29810,29811,29810,31858,29745,42325,50679,48631,44470,42325,35954,44438,36116,38164,44437,38164,17198,36017,40244,17198,21358,31727,33742,42292,48565,38098,48663,48597,35985,29745,25551,29647,21260,21293,25519,23406,33938,27632,25519,25519,25519,23438,21358,15019,21291,21455,23472,14985,8647,14857,14921,33513,39787,40016,12905,10760,6567,14954,31727,25387,19081,19210,25516,23371,29613,33741,38000,33839,38000,42225,33774,35886,35919,21162,40145,52660,52758,52790,52790,52758,52758,52758,52758,52758,52757,52725,50677,52725,50677,50677,50677,50645,50644,50644,50644,50611,50612,42193,31628,46418,42258,19082,29581,21130,31661,19147,23471,23406,27533,29614,31629,31467,21162,16969,25322,33806,31693,27467,31661,29546,37866,33641,29481,25321,12743,12743,12775,14855,19048,21160,29514,35787,33642,46220,42093,21128,21096,21096,23241,14790,12775,8582,6469,4422,12906,29841,42455,29777,8680,8906,6987,6890,6825,8938,6954,2858,811,843,811,843,843,843,875,908,940,908,908,908,2988,908,2988,5036,5036,940,940,973,972,972,972,972,940,908,2924,2859,2762,649,2665,6761,6760,6760,10856,21226,27499,31692,29546,21160,16967,14855,19016,16935,14822,19015,19113,19146,42292,55035,48761,38390,19762,1005,907,907,907,875,843,842,842,255},
{36312,36312,36280,34232,36312,38360,34232,34199,17556,34264,34231,36312,38327,46583,48566,31858,31858,44373,38132,44437,34036,48664,36051,13038,15118,13070,13037,25519,46420,23407,40245,29778,29777,42194,38098,36051,31857,31890,48598,21424,17165,29745,31890,31793,35855,31695,38131,50743,42291,50743,48565,33808,29712,31760,29647,15019,23471,23406,27632,38099,31760,25551,27599,29679,27599,27567,14986,21324,34133,27665,19212,4487,6567,8712,23177,37805,31791,8712,14921,10696,19147,33872,29579,27499,52822,50710,48597,46483,35952,35952,35920,29549,31661,21162,48564,50710,44371,44338,56983,54871,54870,54870,54870,54870,54870,54870,54838,54838,54838,54838,54838,54837,54805,52757,52757,52725,46386,50546,50546,50513,48333,39948,44305,40145,29581,19115,19050,19082,19180,23438,25453,27501,27501,27501,40113,19147,23243,23242,33839,21195,23307,33840,37967,50445,52558,42158,33674,27401,23241,23241,31561,31659,16999,25321,31627,35787,42060,42093,21128,16935,23209,21096,19015,21096,16935,10662,4421,12873,27664,40342,19342,8744,11051,7019,6890,6825,6890,4874,778,811,811,843,811,843,843,875,908,940,908,908,908,2988,2956,2988,2988,2988,2988,940,972,972,940,940,2988,5036,5003,4939,4874,6825,10921,14984,23273,29513,29513,31626,35819,40045,44270,42190,37965,23305,12742,14823,14822,12742,14855,31823,36083,48663,50809,40406,23794,7182,907,843,875,907,875,842,842,842,255},
{36312,36312,36280,34232,36312,38360,34232,34199,17556,34264,34231,36312,38327,46551,44405,38099,33906,46486,42325,44405,36117,48696,31826,10990,13070,13070,10990,29745,50613,31760,46550,40245,40179,38066,33906,29777,23504,27761,38099,23472,4585,10859,31825,31760,33775,31695,38066,38066,33873,52759,50678,40146,38066,40146,31792,27664,31955,38163,46517,52791,27632,23471,25551,25551,25519,23406,10760,19310,31956,31890,17164,4519,6599,12905,17001,37903,33905,12840,17034,8679,25518,31727,17065,46418,50612,50678,48564,42127,37934,27468,29581,27467,35886,27500,38064,42193,42193,42192,42193,42225,44272,42192,42192,44240,44240,42192,44240,42159,42159,42159,42127,42127,42127,42094,40046,37933,25321,46320,50545,42060,39783,42061,46353,46419,40112,21195,17034,19147,27566,27566,23275,27469,19147,17034,40113,21195,27501,25355,29613,17067,23275,37999,50644,52526,50381,52691,16968,21161,33772,23240,33674,42125,21193,27401,29514,31594,39947,39980,19048,16935,21096,29481,25321,21095,27369,25321,21096,25321,23307,31890,17099,8777,11051,6987,6858,6857,6890,4842,778,778,778,811,811,843,875,875,907,908,908,908,2956,2956,2988,2988,2988,2988,2988,2988,3020,3020,2988,9067,27628,25483,23370,25450,21257,23305,25288,27433,31626,31625,33706,37899,35851,40012,44238,44271,44304,35917,19048,10662,10629,10630,21259,38131,36116,42390,34132,21551,30036,2923,810,842,842,874,874,842,842,842,255},
{36312,36312,36280,34232,36312,36312,36280,34199,17524,34264,34199,36280,38327,46550,46420,42260,27698,46485,38163,46485,40310,50743,29713,13070,13070,15118,13070,19311,44373,50613,48598,46518,44372,38065,29745,23439,19148,33970,25617,23536,6698,15117,44470,40146,38033,33807,35953,38099,33938,52856,46485,35953,33905,33905,38099,44470,50744,48630,52758,44404,23438,21293,21293,21260,21260,17099,10793,8844,23504,33938,25583,6599,10792,10792,12841,14954,12841,8615,10792,10792,29743,31726,27598,61210,42128,48565,50743,50678,50710,50678,48597,48630,48629,48629,48597,48597,48597,48564,48564,48563,48563,48531,48531,48499,48498,48498,48498,46418,46418,46385,46385,46353,46353,44273,44272,42192,33740,44239,50546,44239,27337,35723,48400,50612,44403,29712,21293,27533,33839,23275,23275,25453,21226,21194,42194,31694,33905,21194,27500,27566,19082,35854,44305,37835,39916,52691,19113,23209,33772,21128,39980,46319,23209,27434,23209,25289,31594,35722,33642,16903,16935,29481,27369,25288,23176,10662,27368,39947,25354,25518,15083,8873,9003,6922,4842,6922,6922,4809,2794,778,778,778,811,811,843,875,875,908,908,875,2956,2956,2956,5004,2988,2988,2988,2988,5068,5003,17227,25451,29579,33772,31724,29546,31659,29578,21161,21193,33771,37931,33706,33706,35819,35884,40077,40078,42159,42191,25386,10662,8549,8549,19147,40244,25518,38131,36245,34132,27955,2956,810,810,810,842,874,874,842,874,255},
{36312,36312,36280,34232,36312,36312,36280,34199,17524,34232,34199,36280,40375,46518,44372,42293,29778,48566,42324,46485,38132,48566,23504,13070,13070,13070,13070,15118,36051,48533,48565,48565,50678,44307,29712,21326,19213,27600,27697,19343,19343,19278,23504,42324,40081,21260,40244,44437,31826,40276,33938,27632,23373,27567,33905,52824,42324,54872,46517,29712,29745,21325,25518,21293,19180,19212,10858,10924,33970,44470,29744,4551,8712,8648,8712,6599,6567,8647,10857,10856,23372,23339,36017,59097,42193,40178,48598,50710,50710,50710,50710,50678,50710,52758,52758,52758,52758,50710,52758,52758,52757,52757,52757,52757,52757,50677,52725,50677,50645,50644,50644,50644,50644,50611,50611,52659,40046,40013,50545,48433,27304,33610,46352,44305,50711,42128,19147,29580,33806,23341,19147,29744,17163,27501,21227,25453,36051,25388,33741,27533,19147,33806,56951,27468,33643,54738,31758,21193,33707,21096,46286,42126,19048,19048,19016,21128,37900,39947,39947,25321,21128,27369,27369,23176,33609,25288,37834,31594,23372,21421,19373,11018,9002,6922,4874,9035,4938,4842,2794,778,778,778,811,811,843,843,875,876,876,876,2956,2956,2924,2956,2988,2956,2988,5036,7019,8808,17032,21193,29644,37997,29579,31659,23306,12807,25353,23305,33706,40011,37899,35851,33706,35851,37932,37997,37965,42158,35884,16935,6469,6469,14856,29646,17000,40212,34132,42519,21778,940,810,810,810,810,842,842,842,874,255},
{36280,36312,36280,34232,36312,38360,36280,34231,23797,34232,34231,36312,42423,48566,42292,38196,38132,46518,42325,48566,35955,25520,17296,23569,27762,29777,25584,21456,40212,50613,48533,46485,50678,48532,48500,29680,21294,21326,44406,17231,19310,29745,23536,38131,25453,15019,40245,33873,29713,44438,44438,33873,27599,27600,31825,42357,40211,52823,38098,31825,29712,25454,23373,17067,14954,14954,6665,21391,36051,46550,21260,2439,6632,8712,10825,8680,8615,8648,10792,12873,21260,38033,46517,48532,40113,46518,52824,54904,54903,54904,54904,52823,54871,54871,54871,54903,54871,52823,54871,52822,52822,54870,52790,52790,52790,52758,52790,52758,52757,52757,52725,52724,52725,52692,52725,54805,48465,39981,50545,48465,27370,27336,46320,40112,50710,48304,16969,27500,23340,19147,23405,8906,10987,21292,25583,21194,23340,25388,29548,25421,19179,38065,59096,29581,25257,50545,38032,14920,31594,27401,50511,29547,12775,8614,12775,25353,35787,35787,35787,29514,25321,29449,29482,21063,37834,37802,23176,14856,21292,17195,15115,11018,9002,6954,6954,6987,4906,4809,2794,778,778,778,811,811,843,843,875,875,875,876,2956,2956,2923,4971,5004,2955,5004,7052,10888,12871,10726,21193,42256,31757,38031,37997,14919,19112,33772,19112,27465,40011,31593,35786,31625,31626,33738,33739,35885,40078,46351,31626,10629,6437,14888,23339,27533,36148,25712,36277,21810,5133,810,810,810,810,810,842,842,842,255},
{36280,36312,36280,34232,36312,38360,36312,34232,36312,36280,34231,38360,44503,46453,33939,29843,42325,42358,44406,46486,33874,29681,27731,19409,27730,38099,31826,38196,44372,50645,46420,38164,42259,46387,44306,25487,12907,15020,38099,25552,25552,44404,38131,29809,31858,33938,36083,29744,31728,38131,42293,40081,38065,25486,27566,31825,44469,52823,46517,31727,27566,21260,27567,27534,27534,25454,21293,29712,25486,29711,31824,8745,2439,6632,10825,8712,8615,10728,10760,14953,10792,35984,48565,50678,48630,50744,61177,61177,61145,59031,56983,59064,59064,59031,59063,59063,59031,59063,59063,59063,61111,59063,59063,59063,59063,59063,59063,59063,59031,59063,59031,59031,59031,56951,59031,56983,58998,37900,48400,46385,31563,23079,42126,40144,48597,44274,23340,27533,23275,31825,13067,551,8906,15019,29712,21195,17002,17034,25387,27501,38000,59031,44470,15282,36018,54903,40145,12840,29514,35819,46318,21193,8614,8614,16903,35819,33739,29514,35787,31562,31561,25256,29481,37835,31561,12743,12711,16936,21292,17130,13001,10986,8970,6954,6987,4938,4842,4777,746,778,746,746,778,811,843,811,875,875,875,875,875,908,2923,4971,4971,4971,5004,9067,17064,19144,12871,37998,44336,27499,40111,44303,21225,14919,17000,12807,23273,29546,27433,35818,46317,39979,33771,35884,37931,42158,48496,42190,33706,16902,25419,29678,33872,21519,10921,13196,9132,7214,875,810,778,810,810,810,810,810,255},
{36280,38360,36280,36280,36312,36280,21685,34232,36312,36280,34231,38360,44503,42260,31827,17296,38164,33971,31890,42325,29681,17134,36117,29778,29810,29745,25585,38197,46453,50678,40212,31858,48598,52758,37904,27567,19245,19245,29712,40309,36051,48597,54904,42292,42325,38099,38034,42292,29647,27502,31727,31760,31792,27599,27534,33873,50743,54904,52824,48532,44404,31825,46485,42325,42324,42292,40212,33873,27566,31760,40244,19212,2439,8712,10793,10825,10761,8712,10760,12841,17066,33904,44371,50645,48532,52791,59064,61210,61210,33741,48499,52757,54870,52724,52724,54837,50643,52724,54804,50643,54804,54804,50611,54804,52724,52659,54804,52691,52691,54804,52691,50611,54772,54739,56885,35789,54739,46287,31628,33741,21096,20999,39982,42159,46484,44404,27566,25420,23242,33905,6761,519,2697,8745,21293,27533,19114,19114,25387,29581,35887,56983,35952,23340,52725,56918,42258,12840,27434,23241,29514,21225,12775,12742,16935,29482,29514,19048,35787,25289,29481,31561,31594,23176,10662,10695,14823,16936,23405,15050,13001,8841,6825,6922,6987,6890,6793,4777,2762,746,714,746,778,811,843,843,843,875,875,875,875,2956,2923,4971,4971,7019,9099,17193,35884,25449,25417,50577,46384,33772,31659,31659,16999,10726,14855,17032,19080,23273,35851,42092,46285,37866,44204,40012,40077,42125,52689,54803,42091,25319,40210,25452,36050,13100,2632,4777,713,778,810,777,777,810,810,810,810,810,255},
{36312,36312,36280,36280,38360,36280,19604,34232,36312,36280,34231,38360,44471,40212,38132,17231,36084,34036,25617,25649,25618,23537,29810,31858,31923,31890,31858,42357,42292,46518,42324,33971,33971,27729,27729,23471,19245,23439,40113,35984,44339,52692,42325,33906,33938,33971,38131,46485,23373,21293,35985,46518,44405,44405,42357,44405,46517,46517,46517,44437,44437,48598,44405,42292,40147,40147,38098,19212,17132,31760,19244,10793,8680,8712,8680,8712,8777,10793,8680,12841,15018,35952,40211,50515,50482,52823,59097,63290,56984,44338,54870,50676,50644,54837,50644,52724,54837,50643,54804,54805,52691,54804,52724,50611,54804,52723,52658,54805,46451,46419,50612,46450,44337,48499,44370,25387,44305,44338,35951,35919,29548,23274,33806,40144,42225,40112,21162,21194,19114,27566,13035,519,584,8778,19179,25453,14954,25453,31628,29580,35953,52758,40146,29483,46353,50512,46417,10760,27434,19048,21160,27434,12807,14823,23176,25321,33740,23241,35787,31627,35819,35755,25289,16936,10630,12775,14856,19016,25485,19276,15017,8841,6793,6954,6954,6825,6793,4777,2761,2762,714,746,778,811,811,843,843,843,875,875,843,2923,4971,4971,7019,9035,21289,35851,27465,14951,19111,33770,38029,19111,27465,48465,46384,38030,25386,33805,27499,33739,44271,44172,52624,46284,52492,52623,50576,52722,52690,44237,37899,29579,31856,27533,34067,6826,2729,745,745,745,777,777,810,810,810,810,842,842,255},
{36312,36312,36280,36280,36312,36280,21684,34232,36312,36279,36280,38360,42423,38132,36019,15183,38229,44503,31988,31988,31956,29908,34003,36019,46453,40146,38066,36019,40179,40114,35986,27697,21424,15118,17230,23504,21261,21293,42159,44239,46419,46419,29778,31793,36051,31858,40244,44339,31727,27566,46485,50711,46518,46550,46550,46550,46550,46518,46518,46518,44437,48598,44405,42292,31726,27501,17066,8680,6600,4487,6600,6632,6632,6632,8712,4487,6600,4519,4519,10793,12841,23340,40145,42062,52627,59063,61210,61210,59097,61177,56983,59064,54870,56983,59031,54870,59031,56983,56918,59030,56950,56885,58998,56917,56885,58998,54837,52758,46485,36017,27565,42226,25452,21259,25485,21292,25420,27598,29906,29646,27500,19146,31856,42389,23274,23307,19081,21227,19082,21227,19276,519,584,12971,23341,25485,27566,23307,27402,27435,38066,35887,21162,29417,46352,50414,50578,14953,25354,23241,23241,27466,14887,16935,29482,19015,23241,29482,37932,40045,29546,25289,21128,16936,14856,14824,14856,19081,23340,19276,12905,8873,6825,6986,6922,6825,6793,6793,4777,2729,714,746,778,778,811,843,875,843,875,875,843,4971,4971,4971,9067,23338,44239,44270,33771,31658,29578,37965,44270,44238,54836,44271,40109,40110,44304,50577,50544,48464,54737,54671,54671,52590,54639,56851,56883,54804,50577,44237,19079,16968,25517,31889,17293,4842,2858,810,778,810,777,810,810,842,842,842,842,842,255},
{36312,38360,36280,36312,36280,36280,21684,36280,36280,36279,34231,38360,40342,40180,42260,23504,36117,34069,13264,11185,9136,11216,36084,48565,46452,38098,38034,38066,48565,40212,33938,38196,19279,10924,13005,25617,27567,23374,23341,21228,36051,42357,33971,33938,33938,29810,40244,56952,44339,27566,48630,52824,46517,44405,46453,44437,44404,44404,44404,44404,44404,46518,42325,42292,31726,29581,19179,6599,4487,4552,4519,2439,6697,6632,8680,6567,4519,4487,4487,8713,8648,25453,44273,40014,61177,61210,61243,61210,61178,61177,61177,61177,61177,59097,61177,61209,61209,61177,61177,61177,61177,61176,61177,61176,61176,61144,48598,33839,46517,40178,25420,42258,23372,21324,23372,19179,23340,27501,31954,27630,23339,19147,27630,42421,23339,23339,21162,23307,19114,19082,23437,519,584,8875,23308,35985,36017,27499,25353,23242,35920,31695,19017,27305,50513,56851,52756,19146,25354,31659,21128,23241,14919,29514,35755,21128,14823,35787,42125,42158,27402,23209,14855,14823,14856,14856,16936,19017,23340,21357,13002,8873,6857,6986,6954,6793,6761,6761,4745,2730,2762,778,778,811,843,843,843,811,843,875,2891,2891,4971,7019,19274,48432,42158,35884,33739,44270,42158,48530,31691,31690,50544,44205,54705,56850,58996,46383,48464,56817,54639,54671,52558,54704,56817,52657,52625,50544,46350,29514,14887,14920,8712,15115,15277,2825,842,777,777,810,810,810,842,842,842,842,842,842,255},
{36312,36312,36280,38360,36280,36280,23732,36312,36280,36280,34231,38360,42455,42293,48565,40212,36084,29843,15280,11152,11184,15280,27665,48533,48500,42259,42194,38033,40244,31988,40342,44470,17198,13005,13005,13037,12972,15052,15052,25487,27697,25552,40244,48598,31890,38066,38000,50711,40146,33840,52791,50711,46517,46452,46484,46484,46452,46452,44404,44404,48565,50711,38131,42324,31727,29581,23340,8647,8680,14954,6600,4519,8745,8680,6600,4487,4519,4487,4520,6632,8712,23340,46386,50611,63356,63356,63356,63291,61210,61210,61243,61242,63323,63291,63323,63323,63323,63290,61242,63290,63290,63290,63323,63290,63322,59129,44404,25420,44405,42291,17066,42258,23340,25485,21227,21324,25453,23275,29874,31856,21324,23437,23437,42389,27533,23339,19146,21227,17033,12808,25517,2600,552,8907,27533,37933,44370,29647,25453,23242,29581,23275,33546,33577,46287,50513,54804,23339,23273,33739,21160,27434,14855,19016,29481,23208,14855,27369,35820,44238,23241,19048,8550,8582,12775,14888,16936,16968,21227,21356,15115,10953,6890,6954,6825,6760,6728,6761,4745,4745,2762,746,778,811,843,843,811,811,843,843,4971,4939,4971,11115,29611,48529,35852,31691,29578,52658,48463,52723,46383,37964,48431,54704,50576,37964,42157,33738,50511,54703,54671,54671,52591,52559,50576,50544,48464,40045,25353,12807,12775,10792,8841,6825,6955,2858,842,777,777,810,810,842,842,842,842,842,842,842,255},
{36312,36312,36280,38360,36280,34231,21684,36312,36280,36280,36279,38360,40375,40245,44405,27795,36116,40147,31729,31729,29681,29648,36019,48533,48501,42259,42259,42390,42455,40343,42423,38131,13005,12972,12972,10892,8811,8844,8811,27632,23504,21423,46583,48598,40211,50677,42194,44405,46518,46452,54904,52824,57017,57050,57050,57050,57049,57049,57049,57049,52758,44405,38131,42324,42259,40179,40211,29646,23373,21357,8777,4519,4487,6535,6600,4519,4519,2407,8680,10760,6599,19179,35919,52823,54871,42258,46451,59097,54838,56983,54870,52724,42225,40177,40145,40177,40145,50579,56950,50612,42161,42225,42225,42225,40145,42258,50645,44371,42356,44404,25421,42290,27533,25517,19179,19179,21292,19211,29808,31889,23339,27598,25517,40373,33871,23307,25388,23307,17001,12808,25517,2600,584,15116,27500,31626,37934,27599,25453,21129,23242,21227,42096,31530,39949,48399,52691,25485,14887,35788,16967,14855,14887,12775,23209,21096,14887,14855,31626,44270,23241,14855,6469,6502,12775,16936,16936,16968,21227,25582,17260,10921,8938,6955,6793,6761,6761,6728,4713,4713,2762,2794,778,811,811,843,811,779,843,843,4971,2923,7019,27628,46384,48497,40077,35884,27433,40012,25385,44238,50544,33803,50576,54705,48496,33803,37931,44204,56784,56752,54639,48365,50446,50511,48464,44239,29579,16968,10727,8647,8679,8777,8841,4842,2761,2858,810,777,809,810,842,842,842,842,810,842,842,842,255},
{38360,36312,36312,38360,36312,32119,15475,36312,36280,36280,36280,38360,40375,33972,33939,4912,31923,46485,46420,46420,44340,42260,46486,54872,52792,54840,52792,50777,44536,36182,44503,44373,36084,17198,13037,10956,10924,8812,15085,27697,36051,27632,42325,42357,48630,46452,42259,40179,50678,50678,46517,44437,48598,50678,50678,50678,50678,50678,48630,50678,46452,38098,31759,33807,31694,29614,27501,12841,8680,14986,8712,6567,2374,4519,6632,4487,6567,4487,4487,12874,17132,27599,31694,35952,33871,19146,25452,50644,52757,52725,46353,37966,23307,21194,23339,23307,27402,44371,52496,41965,21065,23242,23242,23242,19081,23275,44404,46485,44437,44405,23372,40145,35952,33871,29646,31791,31758,29613,33937,38129,33806,38065,40243,42323,40178,31725,31693,25452,23307,14856,25453,6761,10987,19082,21129,27466,42225,35953,27533,23209,20968,25388,46451,39981,29449,46286,54837,27565,12807,35820,17000,17000,16967,25321,31594,21128,21160,21128,29514,37932,29546,16903,8582,6470,12743,16936,16936,16968,21162,25518,25647,10954,8873,6922,6793,6728,8777,6728,4713,4713,4810,2794,778,811,811,811,811,811,811,2891,2891,4939,11147,44336,48497,40077,40044,46383,35852,27368,29578,50544,46351,21257,29577,54770,52689,44237,44237,44172,52591,50478,50478,50479,48431,44238,33739,19081,8614,6534,6566,6631,8841,8873,4745,2794,4874,2858,778,842,842,842,842,842,842,842,842,842,842,842,255},
{38360,36312,36312,38360,36312,36280,34199,36312,36312,34232,36279,38360,38295,27731,36019,11185,29843,40212,35987,31793,29713,27632,29713,52726,52694,50581,48501,50744,50810,40342,48729,50777,40212,19311,15150,13037,10924,13037,27632,21326,23406,33938,31826,46517,50711,42291,48565,42258,42259,44404,52824,50711,50710,52823,54871,52791,52758,52791,52823,48597,44372,40179,35920,29646,29614,21195,10728,6600,10760,8680,6567,8681,2374,4519,4552,2407,2406,4487,4487,19213,17165,17100,25453,23338,23274,21226,35886,50612,54903,50579,44077,46386,33644,21162,21195,21162,44175,42357,48304,46061,27371,27403,29483,27435,25322,27435,42291,42324,44405,44437,27598,31759,40177,35952,33871,40177,37999,35919,40145,38032,38000,38064,31855,35919,35919,31725,37999,35951,33806,29613,23372,15083,8648,8582,14920,27532,42160,40080,29581,27467,25160,27500,42225,31596,29450,46254,56786,31725,12775,33707,23273,19112,12774,23208,16903,10662,14855,16935,21096,29514,23208,21128,14823,10630,10663,14856,14856,16936,19082,25518,23567,10954,8905,6922,8938,6696,8776,6728,6761,4713,4778,2794,778,779,811,2859,2827,2859,2859,2891,4939,4971,4939,25645,48496,54738,40045,33739,19144,27401,44205,50511,42189,27530,42157,50543,50544,58898,54704,44172,48398,50511,48431,46351,44238,25353,10662,10760,6599,6631,6631,6696,6761,6793,2664,6987,2858,810,842,842,842,842,842,842,875,875,875,842,874,842,255},
{38360,38360,38360,38360,36312,36280,38360,36280,36312,34232,36279,40408,38295,25650,38132,21555,33971,33907,15183,15216,17264,15183,15183,25617,42357,50678,48566,50776,50777,40277,44470,40245,23537,25552,23438,21358,19213,23406,33906,23439,25552,33906,36051,54969,50776,46452,46322,44339,44436,38099,42292,44404,40244,46485,48533,44372,40179,46485,48565,46420,44372,40179,40179,42324,40179,14986,6600,10793,8713,8713,6599,8713,2407,4519,4520,2439,2406,4487,6600,10793,4487,8648,19147,23370,25387,19113,42160,37966,57017,52725,37998,37966,25321,12840,8615,33742,52660,40146,39885,31433,48433,48400,46287,44239,42158,40013,44404,40211,44404,44437,29711,25452,46516,44371,44371,46484,44403,46451,46483,44371,46451,46451,44402,46451,46386,44338,44305,44305,44306,35919,23340,19147,6502,10759,19146,29645,42225,40079,29646,29548,29483,23275,35887,37934,31595,52559,56752,31725,14888,29514,21128,14887,12774,12775,8646,6533,10630,10662,10662,27401,23208,29482,25288,14823,8582,12776,14856,14856,16936,25453,21422,12970,13099,11083,15212,8712,8776,6696,6728,4681,4745,2794,779,811,779,2859,2826,2859,2891,2891,4939,4939,4939,6987,29740,52558,50511,42190,27433,52625,52624,54672,54704,54736,52591,50543,48431,56785,48398,46318,42125,40045,35852,35820,27466,14887,10727,8712,6729,4616,6696,6760,6728,6857,6890,7052,778,842,875,842,842,842,843,875,875,875,842,842,874,842,255},
{38360,38360,38360,38360,36280,34232,36312,36280,36312,34232,36280,38360,36215,29843,40180,27763,38229,33939,15183,15248,17264,17263,15183,23537,46648,54969,54937,46518,40212,38131,34003,27698,23503,50547,50547,50645,46387,38034,44437,42324,44339,42194,40211,50711,46485,44404,48565,40179,38098,38032,37968,29646,25421,27534,38033,31727,23373,17099,25485,44339,44404,35985,33905,38131,31825,21423,21423,19310,19310,23438,25519,27631,23535,27794,25519,23470,23438,23438,25518,23471,17099,14921,31693,17065,12840,19113,42225,27468,40178,54970,54838,39947,19241,12872,19114,40145,48499,40047,29483,31563,39948,35723,31530,29417,25257,25289,42291,35985,46485,44437,33905,21292,48564,46418,44338,46451,44338,44370,46418,44338,46418,46418,46386,46418,46353,46385,46385,44273,46386,42192,23307,23372,6502,19179,17034,25420,29549,42192,29581,29548,25322,21227,25388,33773,29514,56884,50479,35918,21129,35722,23240,12742,12775,14919,10694,10662,10630,12742,19016,29514,23241,16935,23176,25256,12775,10663,14856,14824,16936,21194,23470,17196,17325,17325,15147,8841,6728,6728,6793,6761,4745,2826,811,811,778,2859,2826,2826,2891,2891,4939,4971,4939,4971,21517,46383,60945,56784,54671,56818,56817,52559,54671,58898,56850,56851,50546,37933,25288,25320,25321,25289,21128,16935,12742,12775,8646,10857,6761,4648,6728,8906,6793,2664,4777,11180,810,842,843,842,874,874,875,875,875,875,875,842,875,842,255},
{38360,38360,38360,38360,36312,34232,38360,36312,36280,36280,36280,40440,34102,8975,38229,44503,40245,40179,42260,42260,42260,42228,42227,31793,36051,42325,34069,27763,36051,38197,36084,27730,33873,52659,52693,52758,46452,40147,48566,44372,48598,46452,44372,50711,46420,46419,50678,33905,35952,52757,46386,35854,35822,35821,35920,38033,15019,4552,35985,50678,48532,33938,27664,25551,21358,25551,25584,23471,25584,25519,27599,31824,34035,36213,29744,29647,29647,27566,29679,27761,23536,10728,31759,21291,15018,19146,46354,33709,50678,52791,48369,31625,19209,12872,14985,46484,50545,50512,50480,44206,39981,39948,35788,33708,33643,35821,38065,31759,44405,44437,40178,33871,46451,44338,42257,46418,44337,46386,44337,44305,46418,44337,44305,46385,44272,44305,46353,42224,44305,42193,23274,27533,8582,19147,10760,14953,25419,35919,19114,29581,21161,25388,27533,40112,37900,50480,48367,27435,29449,37835,19048,10694,12742,10694,10694,10662,16936,14790,21095,33609,25288,19048,12710,29449,33642,21096,14888,14823,14856,21194,25616,21422,19406,13035,8777,8906,6761,6825,4842,6761,6793,2827,2859,2859,778,2827,4874,2826,2859,2891,4939,4971,4971,4971,7052,15308,42255,50544,54704,58898,56850,56850,58964,54771,50512,44205,39947,35786,35786,44173,46318,42125,35819,14887,8582,10727,10824,8841,6793,4648,6728,8874,8906,6858,2729,6987,810,810,810,842,875,875,875,875,875,875,875,875,843,843,255},
{38360,38360,38360,36312,32151,36312,38360,36280,34232,32183,32151,34231,30038,11152,32053,38197,27762,40179,40147,40115,35987,35987,27600,21359,17134,23505,15313,2798,11087,34004,44437,46551,48631,40179,42291,44404,48630,54872,44340,42292,38066,46485,38033,38066,36018,33905,42226,31760,44371,54806,52726,42226,42226,44306,25421,25454,15019,10825,46550,50678,48499,36051,29744,25551,25518,29712,27696,23536,25583,27599,29712,33905,33970,34100,27664,29647,29679,25486,25421,27664,25617,14954,31726,25485,21292,27434,46320,44240,44306,48367,41963,35752,35720,31527,31463,37835,46353,50578,48466,33838,33773,33773,33740,33740,31692,42159,33872,25486,40244,44437,40211,19179,17098,23339,33903,38097,31726,35984,31791,29678,35952,31758,29678,35919,29645,35887,35919,31725,33838,31725,23242,29646,8582,21227,8647,19113,46385,27501,14954,25420,21128,27468,35887,35822,23112,29547,35886,14856,31594,42125,25321,12807,14887,14855,12774,10662,10662,12710,18951,27336,25256,21063,18983,23176,33674,35754,29514,25354,16936,21162,31889,29907,27793,21423,10857,8938,6890,4842,4810,6729,6793,2827,2859,2859,811,2794,4874,2826,2858,2858,2891,2923,4971,4971,7052,7051,17259,31789,27595,44238,50512,46317,52592,44204,44204,54671,56850,50478,50478,46285,46253,39979,23208,10694,10727,8744,8777,10922,8873,4648,4712,6761,6825,6890,2729,2729,746,778,810,843,875,875,875,875,875,875,875,875,875,875,255},
{38360,38360,38360,36280,27958,34264,36280,15541,7089,5009,5009,5009,4976,5009,9072,11185,4976,13232,19408,17296,11055,11055,11055,11054,15183,21521,15281,4846,2733,13103,40277,57050,54937,36050,33905,36051,44372,44372,31890,44437,44404,42324,42194,31662,27599,33970,38001,33808,31792,38066,38066,31695,31759,33873,21326,17133,25583,42291,48598,48500,52660,42324,36050,31824,31792,31857,33970,36115,25616,29712,31792,29711,29711,34100,29777,27599,27631,21292,14921,21325,19213,12873,29613,21259,19146,42127,37934,44306,40113,50579,27499,21225,19144,21224,19079,29547,35821,46418,44304,31757,31692,31692,27499,31692,29580,31758,27533,27598,42259,44437,40243,21324,19244,23405,33904,29646,27695,31824,33936,38228,31856,31823,25485,23372,21260,29646,29613,31660,31725,25387,14856,29678,12776,21195,17065,33805,35854,31726,35886,25386,27369,29548,25388,25323,27305,25387,42225,19081,31595,46351,25353,10694,14919,17000,14855,16935,16936,14823,16935,19015,23176,23208,23144,27368,25256,31529,31561,33707,31627,21097,31759,21389,29842,27729,10825,8905,6857,6793,4713,6728,6793,4875,843,811,811,2826,4874,4874,4874,2858,2859,2891,4971,4971,7052,9067,42191,46350,31690,31626,37866,44172,54704,46317,48366,56818,54737,48398,46285,44172,42059,29513,12742,10695,8680,8777,6728,8841,6761,4648,4680,4713,4713,4777,4777,649,681,746,778,810,843,875,907,907,875,875,875,875,875,875,255},
{38360,38360,38360,38360,32054,34231,32151,9332,751,718,750,815,718,751,2766,4911,9071,34068,42390,42357,40309,40277,27730,23537,42389,44470,15313,750,717,653,17296,31956,25617,40212,33938,31891,23471,33939,29842,40212,35953,33905,40178,23308,19180,23405,42357,40245,23471,23439,25519,27567,25486,31793,29680,25487,19212,52857,44404,50612,50612,42389,38131,33872,31792,33938,36050,40243,36017,33905,35985,35952,35985,40276,35985,31759,31824,29646,25387,29678,27565,19114,25388,23373,33807,48499,27533,40210,40145,50579,29677,23338,23371,15017,21259,52659,52626,42224,33870,21356,25452,19178,17098,19146,6664,21324,21195,25453,40178,44437,42356,17196,10890,15050,29646,19114,21455,25615,31889,36115,27598,27630,21292,17098,12873,21259,19114,23275,25420,17033,12775,27565,14921,14888,27500,29580,19081,37967,37999,31693,27402,27403,14921,21130,23112,23307,44338,19081,27402,42125,25353,10694,12807,12807,12807,16968,19015,29482,33739,35819,33674,27401,27368,31594,33642,27369,29449,31594,33706,21128,25420,19114,29777,27891,17326,10954,6825,6696,6664,6696,6793,4875,844,811,811,2827,4874,4874,4874,4906,4906,2891,2923,2923,5004,7019,23565,44238,35850,40045,37899,33673,46252,50478,39946,42059,52657,44204,39979,31626,29546,19048,10630,10727,10922,10954,4680,6793,4680,4648,4680,2632,4745,6858,4810,617,616,681,2794,810,843,875,907,907,875,875,875,875,875,875,255},
{36279,38360,38360,38392,36182,36215,30038,11413,783,750,783,848,783,783,2798,4879,19441,42324,38132,29875,29843,27795,31890,31858,48630,54937,19441,2766,717,2733,21392,23504,17198,38164,33971,27665,25552,36083,50711,33906,36018,42324,42292,31760,27502,31825,42390,38165,29777,27665,25551,25519,27599,42324,35953,31760,25518,48631,44405,48500,50612,42292,29711,29679,27632,29711,29613,31726,33807,33807,35887,35919,33839,35984,33839,33807,33807,29614,31694,29646,27565,21227,16969,25421,38098,44274,27534,42258,40145,44274,46418,31692,25452,21226,33839,50612,52658,46385,33870,31790,29677,29612,25451,27532,21226,27564,44338,38065,35985,42292,44405,25518,19276,21324,31759,21195,21455,23567,31921,34002,27631,27597,25517,21292,17066,21259,25452,23306,25420,19114,12775,25452,19114,10695,23340,17034,35887,29548,27468,29646,21194,25322,23307,25356,23113,21194,46419,25387,23241,37900,29514,14855,12807,14855,21096,17000,16967,29449,33674,35787,37900,33707,35754,33674,29481,27369,31562,31594,29514,21128,27500,25485,31890,32052,17293,15212,6793,6761,6632,6728,6793,4875,876,811,779,811,2859,2826,4874,4906,2826,2858,2923,2923,5003,4971,11147,42190,50479,56851,54705,54672,52558,50446,50511,46284,48398,46317,37899,33706,16935,10662,10662,8712,15116,8906,6761,6793,4648,4648,4648,2600,2632,2632,4745,584,616,2729,714,2826,843,875,907,907,907,875,875,875,875,875,255},
{38327,38360,38360,38392,32086,32054,30038,11412,2896,783,815,848,2863,6992,11120,13232,34036,46518,36116,38229,38229,40277,44470,44438,42389,48631,19474,4846,2798,15215,31729,31761,25519,17166,27697,34003,21391,38131,48533,42292,29712,29744,36018,31956,27730,31923,33938,46551,40277,31891,31858,31825,44371,42259,42357,40243,33937,38131,44437,33840,50644,42292,23503,21390,21390,25519,21358,23406,21390,23470,23503,27599,25551,29841,25584,25551,23471,19245,19278,17230,17132,6600,12776,25259,40145,42160,40147,38065,50677,46418,50612,23307,14920,19016,33839,46451,48400,50546,48433,44305,35853,31724,33740,35820,33772,35788,40046,38065,35985,40211,44437,23470,10955,13002,29711,19114,23535,23567,34002,34002,31889,27565,25517,17131,17034,19114,23372,19146,21226,19114,14856,23275,19147,8615,12841,10793,21193,19048,29548,29581,25355,27337,25388,27468,23112,21129,46451,27500,21129,31626,29481,14855,17000,23208,31529,19048,19080,21128,27369,25256,29449,33642,29513,27401,27368,33674,35787,31594,25289,16968,25420,33937,38229,23633,13035,17390,6922,6761,6664,6728,6793,4842,876,843,811,811,2858,2858,4906,4906,2826,2858,2923,5003,5003,4971,9099,29709,42092,46253,56720,56719,54639,56851,56916,52690,48464,52624,46318,25353,12742,10662,12873,10922,10954,6793,4680,6761,4648,4616,4616,2600,2568,552,552,552,584,649,2697,2794,843,875,907,875,907,875,875,875,875,875,255},
{38327,38360,38360,38392,32119,30038,34166,36279,21652,4911,783,783,7024,27860,29876,31989,31988,29908,27828,25747,25715,29843,31891,31826,31761,25585,36117,29843,13135,29811,38099,31793,33873,17230,33971,40147,27632,27632,27632,29712,29745,15085,8811,6731,6698,23536,40277,54937,40211,27664,23439,25487,33905,33840,36018,33905,29712,38163,52824,46550,52757,42324,25583,23406,23438,25551,23438,21358,21390,27632,25551,23406,25550,25519,25551,27631,25518,23470,19277,23405,23405,10761,12841,21227,35952,29679,44437,40113,52725,54805,40079,17033,14953,19081,35984,54871,61176,54804,52658,50579,46385,44305,46352,46352,44272,44304,46385,42291,38099,40244,40211,27630,17131,17131,29678,21195,21389,15116,31824,31856,36115,25485,27630,17066,19114,19114,17001,23274,23274,19146,14888,19082,25420,12776,12776,14921,19080,33773,29580,17034,23275,23208,21161,16968,21129,33774,46451,29613,19081,29547,27336,29449,37965,35852,35754,27401,27402,23273,21128,27401,27369,37835,33706,21063,29481,33642,37867,35819,27369,16936,23274,31824,36181,34133,23503,15244,8970,6729,6696,6761,6793,4842,843,843,843,843,810,2826,2826,4906,2826,2858,843,2923,2956,5003,4971,7019,25613,38062,44303,58931,58932,56950,56950,52691,48497,42158,27369,14822,12775,10694,12840,13035,8874,6793,4680,4648,2600,2568,2568,2568,2568,2600,552,552,584,617,617,681,810,875,875,875,907,907,875,875,907,875,255},
{38328,38360,38360,38392,34167,32119,38392,42521,25780,4943,848,848,17296,27795,29876,29940,31988,27763,17361,15281,17361,15281,15248,17264,15151,23601,46583,31891,13103,31923,40310,44438,35953,31825,42357,46485,31793,25584,27697,36149,23439,6666,4586,2537,2505,10859,33938,50678,42291,33938,31793,29745,27600,25454,27535,31858,35986,48598,57050,54672,54707,46484,40145,40145,38130,31857,29712,29712,31824,33905,33905,31792,33872,33905,35985,33872,35952,35985,33872,33840,29678,8680,21194,29646,31727,27533,44437,44306,44306,44306,19146,19178,14985,19145,33838,61111,61079,56852,61111,54805,50611,50579,52724,50612,46450,50676,48531,44371,35953,42324,38130,33905,25583,25551,33871,33838,33838,31725,35919,35919,35951,33838,35918,33838,33773,33805,33773,33806,33838,33806,23307,23275,23372,12807,14888,12807,10695,38033,29613,19114,21195,23241,23272,23273,23274,18984,40080,35887,23242,29515,25256,27369,16935,23241,37867,31561,25289,14823,23208,33674,44140,42059,42060,35787,37867,31529,37867,35787,25256,16871,21161,29711,29776,40406,27793,25712,11084,6696,6696,6793,6793,4810,2859,2891,843,843,811,2826,2794,2858,2858,810,843,875,2955,2923,5003,5004,4971,9099,13228,31919,50643,59031,54870,52724,50610,35819,10662,10630,12807,12775,12873,10987,8938,8938,4680,4648,4648,4648,2600,2568,2568,2600,552,552,584,585,585,2697,2826,843,843,875,875,875,907,875,875,875,255},
{38360,38360,38360,38392,36247,30038,38360,40408,36215,13330,15475,15475,27730,40277,34003,31891,36084,25650,19376,19377,17328,17328,19344,17263,17231,38229,48664,31956,21456,36084,42423,40310,29712,17165,21326,46550,44503,27860,34101,40342,21358,6698,4618,4618,17165,27665,19180,38066,59163,61244,52857,40277,36019,33873,27599,29777,40115,46387,54937,54805,52659,46419,35920,33807,31856,25649,19375,21391,23536,23536,25519,27599,27664,27696,29712,31824,25518,29809,29777,27566,19212,8679,19114,31726,52759,37967,42226,48498,42193,44339,17066,17001,14952,19274,23339,31596,40014,54739,52627,46353,46320,46320,46353,42159,44175,42094,37901,42193,38033,33839,25388,27533,27533,27500,25387,25355,25322,23274,23274,23242,21161,21161,21161,21161,21129,21129,21129,19049,19049,19017,19049,12808,10663,19112,23273,12807,6534,33807,37999,25388,21162,19016,23209,19113,17000,23079,42095,40113,23274,27467,29481,35819,35820,23209,33675,27368,35787,29482,29449,37866,33641,33609,37802,31561,31561,27401,31562,21095,25288,19048,21194,25452,29777,40342,29907,32051,15213,8647,6696,6793,6793,4810,2827,2859,811,843,2859,4842,4842,2858,2858,2858,811,875,2923,843,2923,5003,4971,7052,7084,9164,19469,44435,56885,52756,50578,31626,14855,10695,14920,15018,10890,8842,10987,8971,4680,6793,4713,4648,4681,4648,2568,2600,2568,4616,6729,4746,2632,6858,6922,2858,810,811,875,907,875,875,875,875,255},
{38360,38360,38360,38392,38328,27958,38360,40408,36247,23764,23829,21684,34036,54969,38131,31761,36019,40245,36117,38165,34004,34036,29843,25552,17198,42455,44503,38164,38131,42324,44470,44503,40244,31826,23406,27599,42390,34004,31923,36116,42292,12939,4586,6666,21326,31857,23373,27534,44372,40114,38034,42292,36019,25519,17100,19213,38034,31403,31792,52725,54805,50612,46386,46385,40112,27631,23503,27729,25681,29777,35952,25649,31890,33937,35985,31825,33840,35952,33872,33839,31694,12905,12808,35919,57017,38000,52757,44240,29581,17034,10792,17033,14953,15017,14953,27435,29515,44240,39981,37901,37869,35756,35756,35756,31563,29483,27402,38032,31726,19049,16969,16968,16936,16936,14856,14856,14856,14856,14823,14823,14823,14823,14823,14823,12743,12743,12743,12743,12743,12743,10631,2309,6502,19016,14888,10759,6502,31694,35919,21194,19114,21097,23177,17033,21161,29416,44142,42258,25420,27467,39948,33707,33739,35820,25321,29449,27401,29514,29513,33674,23175,25256,18983,16870,14822,14790,14790,16903,19015,19048,23274,27500,23372,38196,34100,44567,36115,12873,6696,6825,4713,4777,4874,2859,811,843,2826,4842,4842,2858,810,2859,811,875,875,875,2891,4971,4971,4971,7051,7052,13325,23663,38227,42289,37998,16967,10662,14888,23502,10922,6761,6761,6793,6793,6761,6826,4713,6729,6729,6696,4648,4583,6599,6566,10760,17261,8874,11020,17326,6922,2761,810,843,875,875,875,875,875,255},
{38360,38360,38360,38392,38360,29974,38360,38360,38360,38360,36247,36182,29843,52889,38035,29712,31890,40277,40244,38164,36051,38132,36051,29810,10925,6861,27730,46518,48598,48631,38066,42259,33971,19278,25487,23439,44471,34036,29908,27794,36051,12972,6666,31793,48598,46518,35952,23308,33840,21163,25486,29777,29680,19213,17067,19180,44340,21066,17131,52725,56853,50578,46352,46385,42160,35920,27566,38229,31954,31890,38000,23439,25648,29712,31759,25583,25486,31759,35920,33807,29614,10792,17001,52658,44305,48564,56918,29483,10728,6567,6567,10760,12840,10792,14953,46418,37967,27435,25323,19017,21162,16936,21129,27403,19082,12743,8582,23307,21194,25354,35821,48499,35886,31660,29548,29548,29515,27435,25322,25322,25322,25322,25290,16968,19081,21161,21162,27467,40113,29581,14856,10663,12808,12776,14921,17000,12775,27533,37967,29581,21162,19081,19016,19113,21193,25224,39915,44370,25388,27402,37933,21128,10629,19016,23208,25256,12710,14822,16902,23176,21096,18983,21096,14822,12710,14855,12710,18983,16935,19048,23274,23241,21259,36051,29842,46616,44567,15083,6696,6793,4745,4777,4842,2827,843,843,2826,4842,4842,2826,778,810,810,875,875,843,2923,4971,4971,4971,4971,4971,15373,21648,29938,29873,13002,12905,15018,25616,13068,6794,6793,6761,6793,4713,6761,4680,6729,8842,10857,8647,8615,8647,10695,8582,8614,8647,17196,23438,38196,34067,15277,746,810,843,875,875,875,875,255},
{38360,38360,38360,38392,38392,30006,38360,38360,38360,36280,42488,42423,29875,54937,38099,31825,33906,36051,36051,36051,33906,33874,29745,25617,19311,8845,17295,40309,48663,42325,33905,27600,17198,17133,17165,25552,42358,34003,31956,40309,27697,12972,17262,38164,52759,48500,31727,27566,42194,29549,19148,21325,27566,21228,17035,21260,35953,21163,10857,31791,52660,48499,42225,42323,40145,38065,27599,40276,34003,33970,48498,31825,29809,33969,44371,29776,42257,46419,46418,44306,40145,17065,25419,52659,38000,59031,48531,19080,12840,19146,25420,29712,29712,25551,29711,38065,35953,33840,31759,31759,31759,31791,33839,33839,35919,29678,29646,29646,29679,33839,35887,42258,33839,35952,35952,33806,35887,33774,33806,33806,38032,35951,33839,29613,31693,27500,33839,33806,29613,33806,35919,27532,25388,23275,17002,19081,19080,23339,40145,27468,17001,19080,21096,21193,19048,23209,27337,48563,31759,27402,35820,23273,16935,19048,19015,25353,33674,35787,21128,25256,25288,23176,23208,19015,14822,14855,14822,16903,21096,21161,23242,27467,29711,27728,38261,48696,46616,21422,8777,4713,4745,4745,4777,2826,843,843,2826,2794,2794,778,778,810,811,843,875,843,2891,2891,2923,4971,4971,4971,11213,15438,25809,29970,21551,13099,17293,13132,8874,8874,6761,6761,4713,6761,6761,8809,15050,17033,14888,12742,12743,8549,6469,12743,14855,10630,8549,16967,27498,23339,34067,2794,810,875,842,842,875,874,255},
{38360,38360,38360,38392,40440,32054,36280,38360,38360,38360,29941,38230,29875,52857,36051,31859,31858,33938,33938,35987,33906,33906,25553,4781,4814,4813,8974,23536,31891,33970,36084,15086,15053,19278,17231,31890,46551,46583,46583,42390,42324,44404,27730,29810,48597,40113,19147,31727,48499,31662,29614,33839,35952,35920,35887,31661,29614,23178,12873,27632,52726,56951,54870,54870,54870,54903,52823,52823,54871,54903,56951,54903,54935,56951,56983,54871,56950,56951,56951,56951,42257,12872,33773,50546,38032,56885,31693,38065,23307,42160,54805,44437,44404,27533,25453,27696,29809,34003,27631,25485,23437,27630,21357,23437,21292,25485,23373,19179,27598,19276,21292,19211,19179,25453,21259,23340,23339,21227,27533,17066,40178,35919,21259,25452,17034,21227,25420,29743,23340,14953,42257,29645,17034,19114,2309,12808,14920,19146,40146,23275,16969,25386,27305,21194,21160,25354,23176,52692,27501,23242,35788,31627,16968,19048,19080,27466,33739,40078,37932,37932,39979,27401,23176,25288,19047,14855,10662,10662,14822,25289,25354,29548,31823,23470,34035,44503,27566,25648,8874,4713,6793,6761,6825,2859,843,843,2859,2826,2794,778,810,810,2891,2923,2923,2891,2923,2891,4971,2891,4971,4971,7084,9164,17519,15406,13164,11084,13100,10987,8906,6761,6761,4680,6729,8841,8776,25386,27466,25320,21128,12742,14822,21096,29514,31659,23240,14822,8517,19047,23240,29581,29906,2794,810,810,842,842,842,842,255},
{38360,38360,38360,38360,40440,34134,36279,38360,38360,36279,27893,19539,25682,40309,31890,29777,29745,31826,33906,33906,33938,33971,23505,2733,13168,19409,27697,25520,27665,36019,27665,17231,17166,19278,19246,36051,50744,54970,52922,50809,52856,46550,34069,25650,33970,42259,33839,40080,42063,31629,31726,35952,35887,38032,33807,27501,25388,23178,12873,21390,50710,54772,61111,56885,54772,52691,52659,52659,52659,52659,52659,50579,50578,50546,48466,48465,48433,48433,48433,46287,23274,10791,42191,50513,25388,29580,31759,38066,31628,48432,42127,44372,46452,31759,17066,40373,34035,40374,31921,23340,27598,23405,19277,25615,19179,27598,17099,21325,23470,17099,25485,15018,19244,21292,21291,27566,23339,25452,27533,15018,33872,33806,23372,27598,21227,25452,21194,33904,27598,17001,37999,33806,19147,21259,12775,12808,14920,14953,42194,35887,23307,21162,21065,19049,23208,37934,23176,48466,31759,27467,31627,21128,14855,12710,12774,19048,29547,42158,42158,40077,44206,42093,35787,31626,25321,23208,19015,16967,14822,25288,27466,29612,29645,21292,19179,25486,38131,17293,6761,4745,6793,6761,6825,2826,843,843,843,2826,4842,2826,2858,778,843,2891,2891,2923,2923,2923,2891,2923,2923,2923,7051,4971,9132,9100,6890,8906,8938,11019,8874,6728,6728,6696,8776,8808,14985,23208,18982,23208,29481,37899,44206,44173,52624,50544,42158,31658,14854,14854,27468,46615,11083,745,777,810,842,842,810,842,255},
{38360,38360,38360,38360,40440,36215,34199,38360,38360,38360,30038,9105,33971,29810,36051,33938,33874,33906,31858,31858,27665,27697,21457,2733,13167,21456,31890,29778,33938,31825,23472,29745,38130,38131,36050,48598,27664,40310,36052,27697,33906,40244,40309,38229,38197,38099,31793,21228,39821,35724,27501,29614,29581,29581,17165,21326,12939,12939,10891,10891,10891,29647,54806,52626,48333,46221,44173,44141,46221,44141,42093,44108,42060,44141,42061,42028,39916,39980,37868,29482,12872,12872,50513,40047,19147,19113,35887,29646,37868,35755,31629,44404,46419,42193,27533,40276,34100,38293,34034,21357,27663,19276,23470,23469,29646,31791,17131,25518,23470,23405,27630,17099,23437,19179,29646,31758,23339,29645,27533,21292,29678,37966,27565,23404,21259,27533,19114,33903,29710,19146,35918,33838,19179,21259,12776,10696,17033,14920,38000,38000,33872,17034,12775,16968,23240,37966,25290,46386,40113,33806,37934,29515,14855,14823,31626,29514,35820,37933,42224,40110,42159,44239,42125,42125,35787,31627,27401,23208,23208,25256,27368,27467,21193,10695,10630,31792,31857,12970,8906,6858,6761,6761,6825,2826,811,843,843,778,4842,4842,2826,2826,811,2891,2891,2891,2891,2923,2891,4939,2923,2923,4971,4971,4971,4906,4809,6825,8841,13002,12969,19178,25418,25418,25386,29579,33739,39979,46285,44140,48365,54704,54705,54770,56850,56884,56915,50575,25288,12742,38033,30003,4809,745,777,810,810,810,842,842,255},
{38328,38360,38360,40408,40440,38327,32119,38360,38360,36312,27893,9137,29876,25746,27827,27795,27730,27762,27730,25650,19344,23569,31891,2668,9007,21489,40244,31890,33938,36018,29680,31728,40244,38163,38098,42226,21391,25649,27568,21326,19213,19213,27697,50776,46550,42325,33906,27470,37773,39820,40178,40145,40112,35952,29810,19181,392,2473,2505,4553,2473,25486,52659,54805,44273,42192,42192,42192,46450,42322,42290,42225,40046,42192,40112,40079,35822,33773,37999,25419,8711,21225,54706,29613,23372,33741,33676,23340,23275,29581,31759,46452,42258,44306,38097,38195,36213,38261,34067,17164,27631,15051,31954,31986,25485,29711,15083,23470,21357,25550,27695,15051,23437,17098,23372,27598,21227,27565,23372,21292,29678,44338,29645,21324,19179,23405,19147,35984,31823,19211,35951,40144,21259,19179,10663,6534,17001,17000,25386,31595,33872,19212,10695,17001,25355,27467,19016,46353,40145,33840,40047,37934,14887,10662,14823,29482,44237,40045,33772,40111,44239,44239,44237,44205,42093,35788,39981,25289,25256,27401,29449,25289,23242,19048,10694,40212,29712,12938,8938,6858,6761,6761,6858,2826,811,843,875,778,2794,4842,4842,2826,2859,843,2891,2891,4939,2891,4939,4939,4939,4971,2923,4971,4971,6954,10888,17065,17032,27466,37932,33739,25321,27433,40012,42059,44172,50446,54736,54704,52591,54704,54770,54770,56851,58997,56916,44269,19014,23241,34067,8938,4906,777,777,777,809,842,842,810,255},
{38360,38360,38360,40440,40440,38327,30006,38360,38360,32119,21587,7057,2896,5008,9104,7024,15313,19441,21521,21521,21521,21489,21489,13135,15215,23537,31891,23537,31890,42357,31857,21326,21326,17068,19181,17133,17263,25682,31858,31858,27665,17197,40277,50776,44470,42194,29647,21293,27436,39820,40145,40145,38032,40146,31825,21326,17165,19245,31760,27567,31825,33839,54706,52660,44371,42259,42291,44403,46582,46582,46582,44501,42290,46484,44403,44371,44339,42226,46452,38065,8711,33740,52626,31726,21194,33742,25290,27468,40079,46386,44306,44404,44371,46419,40210,40211,38293,38261,36180,19244,27663,17164,31889,29841,29678,27630,15083,25550,19244,25550,29808,14986,25517,15018,21292,27566,19147,29646,23339,23405,25517,44370,29678,21260,21260,23372,19114,35984,33904,19146,31758,42225,23372,19146,12775,6470,14954,17001,27499,37967,33872,19213,14888,16904,21260,25453,31660,37966,38064,31727,40047,40014,23241,12742,10694,19015,42125,46350,42125,33739,37932,42126,42125,42125,37900,33674,31626,37868,29449,33642,31561,31562,27467,19048,21194,40244,29776,23503,10922,6793,6825,6825,4810,2826,811,843,843,811,2794,4810,4842,2826,2858,2891,2891,2891,4939,4939,4939,11115,9067,13195,17323,15243,10985,8743,17000,23273,27434,37899,40012,44237,33706,31625,44204,50478,50478,50478,54769,54736,54704,54737,54738,54738,56851,58964,56883,31658,19014,33872,23631,6954,2857,777,777,777,810,842,842,810,255},
{38360,38360,38360,40408,40440,40408,29941,38360,38360,36312,27860,7057,9202,21587,25682,23601,23569,21521,21521,21521,21521,21489,23569,46551,46518,33906,17329,19344,10892,21423,36051,25616,27664,23373,25519,21326,19279,31922,48663,50743,42357,23471,33938,33873,29679,41869,27598,19180,25389,41836,27533,27533,25388,29712,25551,29745,27664,27631,38098,31792,38131,38065,56983,59097,52791,50710,52823,52823,50776,50743,50808,52856,52823,54903,52791,42324,44404,42259,44404,40244,25453,40211,42259,33839,35854,37934,29515,27468,37966,44274,44338,44404,46452,46451,40178,40243,38293,38260,38293,21324,27695,21422,29743,17196,29711,29743,17163,27631,21324,23469,25517,19179,27598,17098,25485,29678,25452,33870,29645,25485,25485,40112,31758,19146,25452,27533,19081,33871,31791,25420,31758,35918,27533,21227,21194,17002,14953,14888,27500,42226,31694,17066,17001,14856,21227,33905,42257,25582,38130,33807,31628,37934,31627,23241,21160,27369,42125,46318,48464,42158,35852,35852,40013,42093,35819,31562,29513,29514,27401,33674,29481,25289,25322,12775,21228,34035,34035,23437,14953,8938,4842,4842,4810,2826,811,811,843,843,2794,4842,4810,4874,2858,2891,2891,4939,4971,7019,15114,33805,35949,33739,33771,27433,12807,6501,12774,40045,44205,48398,48365,48397,44139,50445,52591,52559,48332,52623,54770,56850,56850,56818,56883,56851,56883,58964,52657,21127,33839,38293,6889,4938,810,809,777,777,809,809,810,810,255},
{38360,38360,38360,40440,40440,40440,32054,36312,38360,38360,40375,25812,23699,27600,31663,31728,29810,25649,21489,19408,19409,19376,17263,27600,36019,44340,34036,29745,21326,29712,35986,29777,31825,27599,25519,19246,15118,15085,36019,38131,38131,33905,35986,46484,50482,50059,27533,27533,33775,41868,38032,40080,38033,33938,31825,21261,8714,6698,8746,8779,8779,10827,38098,52758,50644,48499,52725,50644,50579,48563,50743,50743,52757,48466,33806,25551,33905,29647,31825,36051,27534,29679,31792,27566,37902,40014,33741,31661,37967,44306,44307,44372,44372,46419,35952,42291,40374,40341,40374,23469,29808,27695,31824,21357,29711,33839,21292,27663,23405,25582,23405,21259,27631,19211,27565,29645,25420,33871,29678,38162,36082,40112,35919,19146,27500,27532,19081,33871,33936,23372,29645,38031,27565,21259,21227,19082,17001,12742,23307,42258,27533,12776,19114,16936,21162,35887,42290,25582,35986,31661,40080,35886,44173,39979,37866,46285,48398,48398,50511,42157,37900,35819,33707,37900,42093,39980,37899,29513,23240,19015,25289,25321,19016,12775,10662,23438,27793,14985,10792,9003,6954,4874,4810,2826,2826,2858,843,843,2826,4842,4842,4874,4906,2891,2891,4939,4939,15017,23241,27433,23208,19047,25353,23241,21128,14887,12774,33674,50446,46285,48364,37898,46220,50477,54704,50478,52558,56883,56884,58996,58963,56883,56884,58931,58996,50577,27433,25419,27793,11051,9034,7019,842,777,777,777,777,777,809,810,255},
{38360,40408,40440,40440,40440,40440,34102,36279,38360,38360,42488,34166,25812,38066,42194,42194,42259,19440,34036,38165,40245,40245,29843,23569,29875,36019,33906,33873,35888,27632,27665,36019,40179,42259,31825,25519,19246,25454,31760,23439,38131,42291,33905,33906,46158,56331,37999,44339,35790,56461,46385,54706,46386,33873,31792,21261,4554,6666,6698,8747,8779,8779,19213,31727,38033,33840,33839,35985,29613,35920,36018,31760,29614,27501,21195,25486,25518,33872,33905,35953,31662,31727,33840,31760,37968,35854,35822,27468,38032,40112,44306,44371,44372,46419,38097,42323,44567,40275,36115,27598,31824,29776,33937,23534,31791,33871,25485,29743,23469,29711,27565,27565,29743,23405,29711,31791,29613,35919,31758,38130,31856,40145,38032,25485,29613,29645,23274,35951,36049,25485,29678,42225,29678,23372,21195,17002,19081,12775,19113,44339,33839,17034,21195,21096,23210,31694,35984,27630,29615,42226,40211,35885,31561,33641,44139,56784,60978,56817,39979,35786,33642,40013,37900,40012,42092,46285,35754,39979,39980,31594,25288,31562,33707,25354,12775,12873,15148,12937,10889,9035,6987,6987,4842,4842,4842,2826,2859,2891,2826,2794,4842,4874,4906,4939,4939,4939,9035,12839,14919,12774,8646,10758,16967,35820,37933,40044,29546,31594,39980,37866,31593,35753,48365,56817,58931,56785,58931,58964,58997,58964,58931,58964,58964,56916,40111,19047,29645,25744,6889,4841,2857,4970,842,777,745,777,745,777,809,809,255},
{38360,40440,40440,40440,40440,40472,34134,32086,38360,38360,38360,40440,40407,38262,32021,36181,38196,25779,40245,44438,52857,52824,46583,36084,34035,44535,38100,31728,40081,42260,33939,29745,31728,33840,35986,31793,25487,31793,33841,25519,29712,42292,44372,40179,50189,52268,38000,38033,44013,54510,48465,54771,46518,33938,29680,38131,29745,29777,33938,31825,36018,33905,38099,38099,35985,38164,38163,33873,35953,38066,40178,38033,42324,38131,38065,33840,23406,35921,29647,29647,29614,29614,29647,29646,35855,46353,42127,29548,44306,48532,44339,44339,42324,44371,42323,42291,29841,40210,44404,27598,31791,36049,36050,34034,27598,29678,23437,29776,19276,27663,25550,23405,29743,19244,25517,29710,23372,29646,21291,29679,23404,46548,38097,21259,35984,33903,19146,35985,40243,23405,27597,46516,33871,29645,17002,6470,19082,17001,19114,46419,40112,27533,21227,23209,23210,27500,27532,27630,31760,31661,40079,31627,21063,23143,31561,35754,35722,42060,37866,46285,44172,39947,44108,46252,50445,48398,42059,39979,46220,46220,46253,42059,39947,33707,19048,15017,12937,15082,13001,11050,9034,6987,4842,4842,4874,4842,4874,2858,2826,4842,4842,4874,4874,4939,4906,4939,7019,10986,8646,8646,12871,23240,16967,27401,50544,52624,48398,37899,46220,50379,46252,50478,54704,56851,58898,58931,58964,58997,58964,58931,58963,58964,56883,29579,14856,17033,19276,11115,4873,745,777,842,809,777,745,745,745,777,777,809,255},
{38360,40408,40440,40440,40440,40440,38327,25845,38360,38360,38360,36311,40407,29811,15248,29875,38100,21392,29777,29745,31858,40212,38196,29778,36116,44503,31924,33972,27633,33971,44340,33906,38066,35986,38067,40147,33841,33906,33873,33873,31760,31760,44404,48500,54284,48205,38065,35855,50188,50415,48433,48433,46452,40245,29777,38163,52791,52856,52889,46550,55002,48663,54970,52824,50711,52889,54904,50646,50678,52758,50710,50710,54969,52856,48597,44404,42357,29582,25453,27534,27534,25454,27566,31727,27501,44306,48433,46353,46419,42193,40048,38066,44373,44371,44437,40211,19243,40211,46517,27566,29711,38162,36050,36213,27566,25518,21390,29776,19276,29679,23437,23470,29711,19276,27598,27728,23405,27566,23373,29679,21292,46484,42259,19179,38130,40210,21227,31792,40243,29646,27533,46484,38000,29613,25421,8615,14856,14920,21194,46419,40112,29614,23308,23273,25321,29548,35951,31889,27534,31563,31693,29515,18983,25256,29481,46253,44140,39914,29481,29481,33674,31561,25288,35721,39914,33641,37834,37834,37834,35689,39914,41962,35754,25321,21161,15017,10727,12905,13131,11083,9035,6954,4874,4842,4874,6858,4842,2859,2826,4874,4874,4874,4874,4907,4939,4939,6922,6663,12839,10693,14951,23272,31592,33673,44172,33673,39881,48267,50379,50346,54671,56850,54770,54737,54737,56850,56883,56850,56851,56883,54770,50576,27498,8614,10727,8743,6760,9035,777,713,777,842,809,745,777,777,777,777,777,842,255},
{38360,40408,40440,40440,40408,40440,40440,25813,36280,38360,38360,36280,38327,25683,6959,21521,38197,36084,33971,33971,29810,29778,27730,27763,33971,38164,42390,38197,19344,23503,37839,35953,42292,44373,42291,46453,33905,31793,31793,29713,29712,27632,14987,25453,54479,44175,46483,46322,52301,46254,50512,46254,35920,33873,38099,52758,52791,54969,52791,54904,54937,52823,54904,54904,54904,52856,54937,54937,54904,52824,52823,54903,52791,52791,48630,46518,48696,38098,33938,31760,31792,33872,33840,35920,31727,33807,40080,48564,50644,46386,40080,44339,42324,42292,42324,42292,27663,40243,44437,38098,36018,38131,38065,36115,33905,31759,33905,38098,31824,38131,33937,35985,38032,33904,38098,36050,40178,40178,42324,42291,38098,46485,46452,38097,46452,44339,38065,42226,42290,40113,40178,44371,40145,38032,38032,31727,21162,12840,31726,50612,38000,27468,25356,25322,21129,27468,38000,38064,38033,23274,27403,27434,25288,29481,27401,35754,52558,50413,42059,25288,18983,14823,14822,29481,39979,29513,27368,35786,42092,31593,29416,39882,33642,23241,27434,19210,10759,10727,15179,11082,9002,6922,4842,4842,4842,6825,6858,2826,2826,4874,4874,4874,4906,4906,4907,6890,14951,19079,19111,19079,14919,16999,37897,54671,44172,44107,46219,44041,46121,52460,54737,54737,54737,46285,40011,44237,46317,48365,48398,46350,40044,25385,8582,8647,6696,6760,4809,2793,810,745,745,777,777,777,777,777,745,745,777,809,255},
{38360,40440,40440,40408,40408,40440,40472,32054,32086,40440,38360,36312,25845,6992,718,17393,38132,31859,31891,34003,36019,31859,21391,19311,21424,25584,27633,21423,15151,31760,39887,38099,42324,44372,42259,42324,33905,31793,31793,29680,31793,29680,23374,38098,56853,50612,48532,44143,56624,46254,50447,46254,31759,31792,46517,52791,52856,54904,52823,50710,50743,52823,52791,54936,56984,54936,56984,57017,57049,54936,50677,54904,54904,46549,23372,33872,46485,40244,38131,29680,35985,33873,31759,33840,31694,31727,33807,46419,52725,35854,37999,48499,52823,52791,50743,50710,48597,48598,50678,46517,50710,48597,50743,50710,44371,46516,40178,46484,42291,40178,44371,42323,46517,44436,48564,50644,48499,44306,40144,44305,46418,48498,35919,31726,46385,42192,35886,37999,35918,29580,40046,42159,27532,29580,16936,17001,27566,17067,29678,29646,27533,21195,23308,21162,23177,27468,33774,42225,33904,17033,23242,33707,14855,19015,29514,31594,37867,39979,25353,16935,14823,14823,27401,44172,50479,33674,29448,33641,27368,37866,37834,33641,25256,23209,31595,29644,14953,10792,13066,10986,8873,8841,6858,6890,6890,6858,6858,2826,2859,4874,4874,4874,4874,4874,6955,10824,19047,19111,21223,19143,10790,10726,35754,60979,56785,54606,52525,54606,52492,50477,50510,48462,44205,42157,42124,40011,40011,42124,37964,37931,27465,12775,6502,6566,6760,2664,648,680,810,777,745,777,777,745,777,745,745,777,777,777,255},
{38360,40440,40440,40440,34166,36311,40440,38327,25845,40440,38360,36279,19539,7024,750,6991,34036,36084,34004,33971,33971,29778,23472,17198,23504,17198,17198,15085,15118,37969,35823,42357,42324,40212,38131,42323,29712,29680,29647,29745,27567,27534,25422,33905,31825,35985,27502,43980,56623,50513,52560,46320,46453,35953,50711,44469,50744,50678,50710,50743,48598,48565,48598,54936,57049,50775,52823,54936,54936,52824,50710,54969,54969,40145,12904,14953,40211,40244,36018,31760,29744,31792,33872,35952,33774,33807,33807,33839,42193,35854,40080,59097,61211,56983,56983,52725,52758,50677,54838,50677,50644,48563,50775,46582,40080,40145,25484,35984,35984,25453,36016,38162,38130,40242,42159,44272,42159,37966,37998,40046,42192,37998,31726,33773,37901,37966,33805,29644,35886,35853,33805,27500,19114,17001,6469,14921,27632,17035,25486,21260,17034,21227,23340,23275,25257,27436,33839,40145,33838,31660,25289,27402,12742,10662,12742,27401,33674,29482,12742,10695,14855,19047,27401,48366,42028,25288,35754,37834,37866,37801,29415,27303,23208,33740,29546,31724,14920,10792,15146,10953,10824,10824,6858,6922,6890,6858,6858,4874,2859,2826,4874,4874,4874,4874,13066,19112,21191,21191,21159,17063,12871,17031,48366,52558,52492,50413,48267,46187,46186,42026,37898,40011,37931,42125,44237,40012,35851,31691,27466,19080,8614,4421,4454,4518,4647,616,648,713,809,777,745,777,777,777,777,745,777,745,777,777,255},
{38360,40408,40440,40440,36215,38360,40440,40440,25812,36280,38360,36279,27925,11152,783,4911,9007,13135,13135,13103,19376,27632,25552,19343,31923,27632,10957,13070,23537,38066,25487,29712,29713,29680,31792,48532,40113,38066,38098,38131,38066,35953,35920,33873,19180,25519,29648,41933,46320,44305,48400,46386,40178,38033,50646,46550,50710,44371,48597,46550,46485,44371,44372,46517,48565,44404,46419,38065,36018,36018,40145,42258,35985,31693,23371,14985,36018,42324,40244,40276,27599,31760,38065,38065,37935,37967,33839,27599,29646,35919,56985,61210,59097,56983,52822,54903,54903,52757,46483,44370,42225,40177,40210,40177,38097,36017,31823,33871,33839,31758,29710,31758,29678,35951,35918,33806,35918,37999,35919,35886,29613,29645,33806,33805,31693,29580,27500,29548,29580,25419,19114,14888,12775,12775,23274,33774,23340,19114,33840,27566,21227,23340,25421,21227,21129,25355,31694,44306,44273,44174,39915,25321,10727,12775,19048,27401,37899,35819,23241,19048,14887,21096,25256,48333,44173,35754,44172,42059,39914,35689,33608,33641,37933,31660,29547,27434,19145,15017,15147,8711,10760,10921,8938,6922,6922,6890,4874,4874,2891,2891,4906,4874,4906,9002,19176,21224,23303,23304,21191,17063,12871,19047,37867,46253,48365,37866,27368,29416,42026,44139,40010,37930,40011,37931,31658,27433,23241,21160,10695,4421,4421,2406,2438,2470,2567,584,648,745,809,745,745,777,745,745,745,777,777,745,745,777,255},
{38360,40408,40440,40440,38295,38360,40440,42520,29973,32086,38360,34199,9137,783,11087,17231,15151,15151,15118,15183,23472,33808,31826,27763,38196,36051,15150,13102,21456,50711,40147,42162,42194,42194,42292,52758,50580,48532,48532,46485,42292,42292,42291,42292,27600,23406,25487,33808,33840,42226,44209,33905,42325,46485,46550,48631,46550,44437,44405,44405,44405,42357,42325,42324,42324,42324,42291,38098,38131,36018,25418,27531,21226,19210,14984,12905,27664,25518,33904,44405,36018,40244,42324,27631,21227,21228,29679,25421,23340,44404,52824,50678,48597,46419,42193,46419,42259,37935,38000,35984,40177,33839,31758,33839,29646,27533,25420,25420,25387,29645,23274,23275,21162,17001,19147,21259,19049,19049,21195,23275,25421,12808,8615,23307,19081,12743,12775,12775,10695,12743,12743,14823,16968,25387,27468,19114,14921,21195,29614,25421,21260,23340,25388,21228,16968,25323,29613,40112,48564,52725,44239,29546,19145,19048,23209,29482,39979,44172,44205,33706,21128,23208,27368,48398,44140,41995,39915,35754,35754,37834,33608,33609,44239,35853,23241,19048,21226,15017,14920,12776,12938,10922,8874,6922,6890,6922,4907,4907,4939,2923,2858,4874,4906,15113,27464,19079,14919,19079,19079,12838,10790,16999,44173,48366,50511,31561,33641,35689,48397,44171,35785,33705,31625,25353,16935,12775,10695,8582,4421,4421,2406,2406,2438,2438,487,583,616,713,842,777,745,745,745,745,745,777,777,745,745,745,255},
{38360,40408,40440,40440,38295,38360,40440,42488,38295,25813,38360,36280,17426,13297,25585,10957,13038,13038,13006,17231,35986,37968,35953,36019,42356,48598,31858,21424,23504,48630,44243,42324,50678,46517,42292,52824,54904,52791,54904,46517,44437,48663,48663,44437,27632,21293,19180,23439,31857,50678,44306,29647,44470,48664,48631,48631,48631,48631,48631,48631,48631,48631,46551,46551,46550,46550,46518,46518,44437,42292,23403,25548,21259,17097,14985,17099,19147,17097,46484,50678,44437,46551,44437,25486,8615,17035,25486,19180,14857,12809,14922,12873,17002,23340,33773,27402,21129,39852,46354,42357,44405,29581,21227,23307,23275,23275,19081,19081,16969,21194,16969,14889,14888,8615,14921,21162,14824,14856,10728,14889,25486,12808,10662,14791,12743,12743,10727,12775,21160,23209,27468,31693,23308,19114,12809,14889,17002,19147,27501,25421,21227,19114,23276,23308,23242,31628,31694,40080,48564,42225,44306,29514,25482,25450,19015,27369,39947,44172,42092,31593,39979,40044,29481,44205,37834,37802,37866,39947,42027,37802,29416,29449,29514,35821,33740,14822,19080,19113,25453,21260,17098,14986,6793,6890,6922,4875,4939,4939,4939,4972,4906,4874,6922,21289,29544,21224,14919,14919,21192,17031,10822,16999,50478,46252,48365,37899,46253,42092,44172,31625,18982,14789,12677,10629,8614,6534,6534,6502,4454,4454,2405,2405,2406,390,454,551,616,680,777,777,745,745,745,745,745,777,777,777,777,777,255},
{38328,40408,40440,40440,38295,40407,40440,40440,40440,25780,27861,29941,13330,15475,31956,25552,29745,31825,31826,29745,40211,46354,35920,38131,42357,31858,15150,13070,27665,44405,42227,35954,27600,25519,27535,35889,44340,48598,38099,31793,50711,50710,48597,33970,29745,29680,27599,31760,29712,25454,29711,27599,42357,48663,48631,48631,48631,48631,48631,48631,48631,48631,48631,46551,46551,46550,46550,46518,46518,44405,23436,23403,17033,12936,19211,23437,12904,33904,52791,40179,42324,44404,44274,44240,37934,31628,31628,25355,23275,21195,21227,21228,21260,33839,48531,40015,35854,42063,54806,44437,46452,31726,21227,23307,21227,21227,16969,17001,14889,17034,17001,14888,14856,10695,14888,19147,14823,19017,10695,8582,23340,17067,14855,19015,19016,14855,12775,14855,35853,50612,40080,25387,10728,12841,14889,14921,14954,19082,23276,17034,19113,19081,17034,21195,25355,25387,29581,25420,50612,48564,46484,31660,29578,27530,19015,29449,37867,42092,42060,39947,44204,44173,39979,42092,37899,33674,37834,37867,39947,37802,33609,31561,35787,33707,29515,16903,18983,21259,25485,21194,21161,12840,8873,8938,6923,4875,4907,4971,4939,4972,4939,4906,9002,23336,23272,19144,10758,10758,12871,12806,10758,23207,42026,46187,48332,54639,56785,50478,52591,46252,39946,37866,33674,29513,23272,14855,6534,6502,4454,4454,2405,2405,2406,358,422,519,616,680,713,745,745,745,745,745,777,777,777,777,777,809,255},
{38360,40408,40408,40440,38295,40408,40440,40440,36215,25780,21587,23635,21554,21554,33939,35987,33906,31858,31858,23440,19278,25487,17165,19311,27697,29778,15150,17263,29777,38131,38099,21359,17198,27698,29713,31728,31793,33971,33971,33938,44437,38098,33970,12972,27697,33906,25486,31825,23374,33872,44339,40178,42357,48664,48663,48631,46583,46551,46551,46551,44470,44470,44438,44438,42357,42325,40276,40244,38163,38099,23371,17065,8679,21194,29646,17162,14953,44404,48566,38066,38131,42291,48596,50645,38000,46386,42193,42225,40113,38000,38033,33840,31727,40113,48531,44306,29451,47977,52628,50677,46452,31727,21259,25453,27565,31759,23275,23275,21162,21227,19114,17001,17001,10695,12808,17099,19049,21194,12808,8615,23340,23308,16936,18983,16935,14855,23306,44338,50579,42192,25388,14921,14921,14889,14921,16969,14921,14921,17066,14921,23338,23307,12841,21195,23275,27467,27533,14921,40113,50612,46451,33773,23241,21192,14919,21128,31562,39980,44172,44173,37899,42092,44140,42092,42092,40012,39947,35754,33641,31561,29448,23176,31594,33739,27402,16935,14822,19015,16968,10760,21258,15050,8970,8971,9003,6955,6987,4939,4939,5004,4971,4906,11050,21256,23272,21224,12871,8646,10694,10758,10758,23207,50413,52525,52525,52558,54671,52591,56784,54671,52590,50445,44204,44172,50478,48398,35819,19079,10694,4453,2373,2373,2373,357,390,487,616,680,713,713,745,745,777,777,777,777,777,777,809,810,255},
{38360,40408,40408,40440,38295,40408,40440,38327,34070,25716,21587,23668,23667,21554,23602,25650,25683,23570,23602,21424,17199,21392,21424,19279,21456,31923,27698,27730,29778,31858,40212,34003,25520,29713,29777,33906,40211,31793,40277,48663,40244,29745,27729,17165,15085,23471,25551,25552,29777,36050,42258,40146,46550,52824,52824,33906,23471,23471,23471,23471,21391,21358,21326,21326,21325,19245,19213,19212,17132,19180,21323,21290,25419,35855,27566,17098,6599,36018,42324,38131,33873,38065,48597,50678,31629,44338,31727,40146,35920,33840,33873,29647,25421,35952,50611,46418,35724,54185,54674,48630,42259,27534,19114,25453,29678,40211,27501,21162,16936,21259,17034,14888,14888,12776,12743,21194,14856,25355,14856,10760,16969,19049,19081,12775,19081,40112,46386,37999,25355,25356,23308,17002,14953,17001,14952,16968,25388,14889,14888,19114,27468,27501,23340,19147,23275,31530,33741,23275,33774,52725,50645,35853,21193,23369,14919,27434,29514,37867,40012,42125,31593,44172,46253,48431,44205,46253,39979,37867,35722,33642,31562,23208,23208,31562,29482,25321,21128,23176,21128,17032,19243,13131,11051,8971,9003,6987,6987,7019,4971,4972,4971,4939,10953,14983,25384,19144,14951,12871,10726,10694,10758,25352,50543,46317,50477,52590,50445,50445,50478,44171,52591,52591,42092,39979,52624,54737,56817,50543,37964,23273,8646,2373,2373,325,357,454,2664,713,680,680,713,745,777,777,777,777,777,809,810,809,255},
{38360,40408,40408,40440,38295,38360,36247,38295,34102,29909,27829,25780,25748,25715,25715,25715,25683,25683,25650,34004,29810,38262,40310,38230,40310,36117,36084,40277,42357,27665,33971,40179,27665,36116,46518,48598,46518,46453,50679,46518,40276,38164,38164,17263,23504,46518,38131,27665,31890,44437,40211,40210,42324,54805,52758,36051,29745,29777,29777,31825,31857,33938,33938,33905,33938,36050,38099,38099,36018,27631,19179,33904,48564,33872,21325,21259,17099,29712,38131,40179,29581,25420,38130,48565,35823,31694,23373,27534,27501,23308,27469,25356,23210,35952,46484,54838,50481,54347,46092,38066,44405,25453,25453,27566,29679,36050,38033,23242,17001,25485,23307,16936,16936,12776,10663,19114,16936,25355,14856,8648,16969,23210,19114,12808,25355,29580,17002,19082,21195,25388,23340,17002,12840,16936,17001,17001,23340,21162,21194,21162,16969,17001,23308,14954,21194,27401,31628,33806,42225,52725,50678,40080,25354,23369,19144,25321,44205,44206,42125,46318,50511,46285,46286,46285,46286,37899,37899,39947,37867,33674,31529,25256,27368,33609,37835,25321,31562,27369,27499,29513,17194,13163,8841,8938,9067,6987,6987,6987,6987,4971,4971,9034,12903,12903,17096,15015,17031,17032,14919,16967,10661,33739,42157,44205,46318,48430,44172,48364,48397,44172,52559,50511,44171,50478,54737,54737,54770,54802,50544,37964,29546,21128,8582,4389,2341,4486,10954,8971,713,680,713,745,777,777,777,777,777,777,809,809,255},
{38327,40408,40440,40440,38295,40408,38295,40407,40375,31989,29909,29941,29908,29876,31956,31956,31924,31924,34004,29843,34069,38294,40310,38262,31891,38197,46518,44405,38132,25585,17165,19246,29810,25519,35921,42195,31858,38131,40276,36083,36084,38163,40309,21359,15150,44470,42292,33873,31760,48598,31824,19310,31791,44273,54871,52792,50711,50711,52824,52791,52824,54904,54904,52824,52823,52824,52824,52856,42357,23406,21260,42258,31662,21259,10792,27663,31760,25421,38098,44404,29613,10791,17131,40211,42064,25323,14954,19148,21195,16969,21163,21130,23178,21228,29614,50645,48400,54446,45994,33840,35986,29647,29614,29678,31791,40178,42226,31661,29548,33741,33741,29548,31628,27435,21129,29613,29515,23275,8582,6535,14889,23242,19050,23308,27534,25389,21195,25388,23308,25420,23340,14889,12775,16968,19050,19114,19082,21227,19114,19114,10695,8615,17034,17067,19114,27467,33740,29646,38000,52758,52725,42258,27499,25385,31690,29481,42028,46318,39980,44205,48431,44206,46286,46286,44205,42092,42060,44172,37834,35689,31529,27336,27368,33641,42027,35852,31529,31562,27564,21258,17259,13066,10760,8906,9067,9068,6987,6987,4939,4939,7052,15146,10790,12903,12871,12935,12871,12871,23240,27498,8646,27465,42092,48366,48366,50543,48397,46316,46252,44204,48430,48366,48365,54704,54770,54738,54770,52656,48463,50576,46383,33771,21127,12774,8517,8582,19212,13067,4842,745,745,777,777,777,809,809,777,777,810,810,255},
{38327,40408,40440,40408,38295,40408,40408,40440,40440,40375,38327,42455,36149,34101,31891,29811,31924,31956,34004,25617,21489,27762,42423,40342,29746,21456,40245,46518,40245,31891,25617,23472,31858,19181,17165,27600,31793,29745,27632,27632,52856,57082,57050,27535,21261,44469,36051,31793,27599,46518,38066,8778,6697,29678,56984,54905,52824,52824,54905,54904,52824,52824,54937,52856,52824,50678,50711,46485,17229,10857,14953,35953,25454,17066,21291,33905,35953,27566,38131,50678,23274,10824,6599,25550,37935,33807,29646,33775,31727,33807,33807,31597,21130,21196,23340,50677,54805,58736,54543,46452,40178,52790,54870,56951,56984,54838,54805,54805,52691,52691,50579,50546,46353,44240,44304,35853,35854,19082,8550,8648,12841,14889,17001,27501,17164,23308,27469,25388,19082,25388,23275,16969,21162,25388,27501,27469,25452,21290,21194,25518,6502,6470,14921,19180,27567,31661,35756,29679,33807,52725,52758,44371,31692,27465,33738,21128,25256,39980,42060,39980,46351,46286,46253,48464,46319,42092,39947,44140,39914,33609,33609,27368,25289,27401,31529,25256,27336,35755,23371,21323,17259,10921,10954,11018,9003,9035,9068,7019,4907,4939,9100,19274,12903,19242,14984,15015,15016,12903,12838,14951,10726,33739,35786,44204,52591,52624,52559,50478,46252,48397,48430,46285,52624,54737,54705,54737,56851,56850,54770,54770,56883,50608,33738,25320,16902,19047,19112,14985,13131,777,777,777,777,777,777,809,777,810,810,810,255},
{36279,40408,40408,40408,40375,42488,40440,40440,40440,40440,40440,40440,40343,36117,31956,19409,21521,25682,36116,34004,38229,38132,38002,38099,23439,34004,38196,36083,33939,36051,23472,19278,17230,15021,12940,25584,21294,19213,15020,19245,40244,38131,38131,29614,35953,42325,31760,25454,21293,25518,21325,4552,4616,25518,38098,40244,48598,50776,50711,48597,46486,42325,42357,42357,40211,33840,35952,31727,12971,15083,31758,31727,31759,31726,48631,50744,50744,48598,48630,54871,25387,10824,4519,15051,33905,44338,44338,44273,42225,40113,38033,27468,25389,21196,21227,52791,56689,58736,56918,52759,40113,42258,44273,40112,35919,37933,37901,35853,33740,31627,31627,31628,31628,31661,40112,35853,37967,33774,21162,17002,8648,8648,17002,23308,15213,19147,27469,31760,33906,23307,31629,29581,25388,19082,23405,23436,25547,44337,31725,25518,8680,6502,12841,17132,42325,38033,33610,31694,35919,48499,52693,46452,33772,29545,31658,19047,19048,35755,37932,40012,44238,46318,42093,48431,44270,42060,37867,39979,39914,35721,31528,25256,23176,25289,27401,25224,31562,33740,21193,19275,19372,15179,13196,11051,8970,9003,9035,9068,7019,4971,6889,17096,17128,25482,21225,12839,14984,12903,10790,10791,12806,44173,48366,48397,48365,48398,46220,46284,46219,44204,44204,44172,50576,50511,54672,54770,56850,56851,56884,56884,54771,52624,50511,44270,29545,29512,29512,21194,19373,2826,810,809,777,777,809,809,777,809,810,810,255},
{36279,40408,38328,34199,23765,23830,30071,38360,40408,40408,40408,40408,38327,36149,36117,27763,27763,27763,36084,42358,40278,40277,38164,44340,31761,34003,36084,19343,25649,31890,13005,15117,15053,13005,13005,27664,29680,19246,12972,12972,27632,21229,19246,31792,48565,36019,27535,27502,19212,23373,21260,21293,21293,19180,17067,27566,35920,33905,33872,33872,42292,40179,42292,36018,33905,35919,35886,31694,19244,19244,27599,25486,44371,50678,50744,48663,48663,48631,46517,33839,21227,17130,6599,12873,27501,27500,27533,33807,29614,31694,31727,25453,27567,21228,21228,48238,50448,54903,56984,54903,35985,31726,31693,27435,37999,42257,44305,44305,40112,33773,35886,40112,42159,42192,42061,27402,21129,25323,21162,14889,10696,10695,16969,23275,23275,19049,23275,31727,35952,33774,29581,14921,8582,25387,29676,25514,48530,54772,33805,25485,10728,4422,10696,8615,29712,40178,31530,27500,35919,46418,50644,48564,37966,25418,33738,19015,16903,33706,35819,37867,37932,35819,33642,44141,42125,39980,37866,39915,39947,39914,35721,27336,25256,25289,29482,27337,31561,31562,21194,19210,19404,15179,13163,11051,8970,8971,9003,9100,7084,11051,8614,12806,17128,21353,12806,6469,8646,10758,12839,10758,16967,42059,48333,42092,37866,44204,42027,46252,44139,44172,44237,44237,50511,52591,54769,54770,54737,56851,56883,56851,52690,52657,56883,50543,27400,21127,29515,27598,17325,2825,777,810,842,810,810,810,777,777,809,809,255},
{36279,40408,38327,19605,914,914,13492,25910,36279,40408,40408,40408,40408,40407,38229,38197,25747,15280,23667,19376,29843,40310,31988,25584,27730,23504,15085,8844,31890,42325,13005,13005,13005,15086,17199,23406,12972,10860,8779,12972,33970,31727,31825,27534,44340,42293,25389,29484,29646,33807,31694,33840,31727,29614,31694,31694,31694,25421,19212,31857,40146,44372,44404,42291,42226,42160,42160,40048,17098,25583,19213,21259,48565,52824,52792,48631,48663,44405,23340,12808,10793,17098,8711,6599,14921,19082,16969,27501,23373,25454,25454,21195,19083,17035,19180,19049,44404,52791,50677,46516,42324,40145,35952,38064,40177,37999,37999,31725,19081,23241,33709,25354,31627,21096,16839,14791,12743,16936,21130,14856,12776,14856,19050,29549,29613,21194,27500,33742,35887,40112,27468,23307,29613,46352,37998,46384,58965,52691,27499,19113,12775,6502,12808,17002,17001,25356,31563,27468,25420,38032,48499,50677,38031,23305,37898,25320,19015,35787,48398,44205,37899,40012,44205,42060,39980,33609,33641,37834,37834,33641,31496,25288,29481,25321,29514,29482,27336,31562,23242,17033,21453,15178,13163,11051,11018,8970,8971,9035,13261,19145,10662,10694,19176,17096,8581,8614,12807,12839,12839,10726,19080,25354,31594,42125,37899,42092,39979,50445,52558,48365,46285,44204,50478,52624,56850,56851,54704,54737,52689,50577,52624,50544,52689,37898,23239,21128,35953,31986,11148,745,777,810,842,842,842,810,809,810,809,809,255},
{36279,38360,36215,17492,947,9235,29876,9171,25910,40408,40408,40408,40408,40407,46584,44503,29908,27796,27893,21521,21392,27730,31988,25682,23569,29810,27697,29648,29712,33971,13037,13037,13005,17230,27730,33939,17133,15052,15020,23439,40146,40146,44404,40146,42390,42293,40147,35725,27501,31694,29613,31694,29614,27533,29581,29581,25421,17067,17034,29680,31760,35921,33938,44372,44371,44306,42258,31727,25454,21292,12905,17130,42291,50678,52824,48631,50712,42292,19146,10760,10727,19146,12904,8711,14953,21227,19114,27534,27534,19180,21293,23308,19115,19115,23308,19082,25420,25485,31759,27566,25453,23405,25517,27565,27533,31694,29679,27598,29679,35984,38065,35952,40177,38065,35953,38033,38065,38097,40178,40146,40178,40178,40210,42259,40178,42291,40178,40178,40178,35952,40145,38032,35887,35853,46319,50545,58964,40111,12935,19113,14888,8583,17002,19114,17001,21195,31563,29548,17067,33774,44338,46452,42193,23305,33802,29642,21192,33706,46285,46253,42060,42092,46285,39979,35787,33674,31529,31529,33609,35754,35721,35721,35722,31594,25288,27337,25256,27336,31661,25485,29808,15178,15211,11083,11051,11018,8938,9003,23598,31724,12774,10661,31625,14951,10726,12807,14919,14887,21192,14951,14887,14919,35787,52625,50576,52592,52624,52591,50510,48364,46317,44204,54704,56850,56884,56851,54737,54737,56851,56884,54771,46350,46350,31625,23272,27467,40276,27857,15341,2890,809,810,842,842,842,810,842,842,842,842,255},
{36279,36279,27894,9203,979,11315,34005,11186,13493,38360,40408,40408,40408,40407,40407,31956,21555,19441,17361,17329,13135,21457,40310,23537,21521,34004,25617,31825,40147,40245,17198,13005,15118,23569,31923,29810,21358,23439,23439,25552,38131,33906,46551,44406,42423,44438,48532,39885,25388,29614,25388,27468,27533,27533,27533,29581,27501,27468,31694,31662,29582,37936,29712,25551,38033,29614,31695,29614,23341,19212,12904,17131,48630,52791,54904,48631,46518,44437,40210,31694,23241,21226,8711,6631,14953,23275,19082,17034,29647,23373,40179,44437,44405,44373,42325,42325,40212,40244,40244,40211,40244,38099,40212,38099,38130,40211,33905,38130,33904,31825,35985,29679,33937,27598,29711,31856,23373,31792,25453,25485,29711,21227,29679,23340,23308,29646,19114,27565,25452,19147,29678,21227,27468,23144,46287,46384,52756,42256,12935,23371,17033,6469,10728,16969,17002,21195,25387,29515,27468,31661,44273,46419,44338,27434,21256,25514,23337,31658,52527,48365,48365,42092,42157,39980,35755,33706,35787,31529,31561,35722,33641,35722,33641,35788,25256,23176,25224,25223,29515,33872,27662,17227,17291,11083,9002,11018,8938,9003,27726,37997,14886,19047,25384,17031,16999,14919,16999,21225,21159,39914,39979,35787,50512,50544,56851,52624,50478,56850,56883,54704,50477,54704,58964,56916,56884,56817,56818,56851,54804,56851,58964,56883,50576,33738,21193,29678,29905,19535,13357,2955,842,810,842,842,842,842,842,842,842,842,255},
{36279,32119,17557,23733,13396,9268,27893,13234,5107,34231,40408,40408,40408,40408,40408,27828,19475,13201,11120,23569,25650,33971,44438,40277,23569,38197,25617,34004,42357,40309,27600,25455,23439,31858,33971,23472,21326,23439,33874,27600,40211,50711,50712,42357,42390,40310,42260,39950,23308,29646,27468,29548,31662,27501,29581,29549,29549,27468,31694,33710,33742,39984,27567,29679,33775,27533,19147,17034,14922,17132,10825,40179,57017,52824,54904,46386,42193,40112,54805,46386,29516,17001,6599,4487,12841,17002,17002,17067,29614,46452,61210,50711,52791,48663,21325,33970,29679,29744,21357,23373,27663,17099,29744,17131,25518,27598,19179,31792,19179,27598,25486,23340,29711,21292,27631,23470,21325,29711,25485,29679,25518,29678,33872,29678,33904,33871,31791,38065,33871,38097,38065,35952,42225,37999,44207,33903,42289,48497,12935,23404,21260,4389,17001,19082,10695,19114,27467,27434,31726,31726,46419,38032,46418,33641,25385,21224,19080,23208,44173,48398,44205,31626,31562,42093,42092,35819,37867,35754,33674,31594,27368,33609,35722,35787,27369,23144,23176,25223,29548,29646,27565,21452,17324,13163,9035,8970,10986,9003,21453,48497,17064,23240,19112,19112,21159,31658,40045,17031,31593,56720,58931,58931,56784,58963,58964,56817,58899,58997,56785,54638,56752,58964,56883,59030,58965,56916,48464,27466,19015,33739,38063,38128,25483,21225,33969,31986,21615,15373,7116,875,874,842,842,842,842,842,842,810,842,842,255},
{38327,34199,21621,9236,5140,9268,23765,17460,15476,38360,40408,40408,40408,40408,42488,32021,29909,21554,21554,44503,46518,40245,31825,33938,25617,34004,31989,36182,40342,40342,42325,42325,35954,21261,27730,38131,42226,37936,38034,44340,50645,46550,50744,50776,46584,36116,48370,37675,21228,33839,31726,27533,27566,25421,27469,25388,23308,21195,21227,21227,21195,33743,33873,38000,33807,19082,8713,12906,12809,8712,23405,52824,54905,54904,50612,44272,42160,50580,50580,33741,25387,12840,6599,4487,10760,12808,14889,21260,40178,50612,37935,48532,48599,46551,33905,36050,34002,36083,31857,36050,33937,33938,36050,31824,36050,29776,33937,29776,23502,27664,27630,29743,25550,27630,27631,17196,23502,19276,25485,25550,19244,25518,23405,23372,27566,21259,23372,25453,21259,27565,25420,23307,31726,17033,40013,36016,40242,50610,15016,21291,21259,6502,16969,21195,10696,19082,29548,29482,29548,27566,44306,40113,48531,42060,25385,17032,12774,10630,19015,37899,35787,23208,19015,44173,48431,46350,48398,39979,35754,37867,33641,31496,33609,37835,31627,21096,23144,25223,35887,31759,27466,25548,17324,15211,11147,9003,11051,11083,15276,38096,14951,27400,27497,27498,40012,42093,44238,21224,27433,46286,58997,58931,56850,58931,56817,56817,58964,56851,54639,56818,58996,58964,58965,56917,54803,54803,50577,21127,16902,29645,10953,8970,13163,25711,29905,25776,19599,5003,874,842,874,842,842,874,874,842,810,842,842,810,255},
{36247,27958,25717,5075,3092,15444,23798,19540,21684,38360,40408,40408,40408,40408,42488,36182,38294,27860,23699,44438,44275,35954,27665,19344,23569,34036,27730,36084,34036,36084,36116,34036,31826,21261,25682,36018,35953,29647,29614,42260,38099,36019,38066,46453,50679,40244,48337,35692,21260,25356,25388,21196,19082,23308,19147,21195,21260,21228,19115,21195,23243,27502,42259,38032,31760,10728,12939,14986,10760,10825,46517,54904,54937,54871,42128,40047,31661,38032,21195,21162,21227,8679,6567,4454,12776,14921,12809,17067,38065,40048,25290,46354,46550,46551,38131,29809,25616,29777,23470,29776,21357,25551,21357,17164,21390,17164,23470,21389,19309,17164,14954,23373,17066,17066,23405,15083,23470,15019,14986,23373,15051,19212,19179,19114,23373,14953,19179,27599,17098,23405,17066,19179,21259,14888,33740,38096,38162,52691,17129,14952,17033,14921,17001,21161,17001,21162,27468,29514,27434,35887,42225,48564,52725,50545,23401,17064,12742,21128,33642,39979,46285,48365,42060,48398,46318,44173,50478,48365,39947,37867,44140,37834,29448,33674,35820,23176,25224,27304,35887,33839,27467,25484,19372,15211,11115,9003,11083,11115,11180,15244,27465,39979,29512,35818,44205,23304,31593,44205,29578,46286,56850,56818,54771,56884,58932,58964,58964,56817,56817,56818,52656,52657,56884,56884,54803,56982,54868,42189,29513,31823,8905,6922,11147,17454,15341,11245,5003,874,874,842,842,842,842,874,842,810,842,810,842,842,255},
{36247,27991,17493,7155,5140,13428,21685,19540,2961,28023,38360,38360,40408,40408,42456,32021,23699,23700,25812,38197,36019,25552,27730,34101,29908,42358,36084,48696,46616,42390,34004,29810,27729,27664,40309,46452,33905,31826,33938,33906,31858,38131,50613,50678,48533,40147,40082,21292,33839,38065,35953,31760,29646,29646,31694,29646,31727,29582,27534,25421,23340,23308,21227,6567,6567,12873,15019,14954,8713,33905,54905,52824,57017,44273,42160,44338,31661,29646,21260,27501,29646,17098,21292,25421,29581,21195,14954,17002,33774,50645,46321,44273,44437,38196,23503,15083,23535,19309,12938,21389,12938,19309,15083,15084,17197,14986,21390,17132,21390,17164,14986,23405,15018,19180,23405,17132,23438,15018,19179,23373,19179,19244,17098,19147,21292,14921,21260,23373,19179,23405,17034,21260,19082,33806,40014,40144,36081,54771,21289,14952,19113,17033,21259,21193,25290,23178,25420,33642,33740,31726,42192,50612,50612,42158,27593,27497,12871,29481,48366,46286,46286,42060,37835,42027,35722,31594,27369,39915,50445,42027,42027,46220,41995,33641,37868,27402,25223,31497,35822,29613,25354,25419,19339,17259,13131,11051,11051,11115,11180,11180,19306,14951,16967,37899,23304,19112,35851,54705,56851,56884,56851,54772,56884,54705,50511,48398,54672,52559,56884,54738,54672,50477,54770,56982,56983,56983,50577,35818,35853,27728,6857,9034,7083,4970,2890,2922,842,842,874,842,842,842,842,842,842,842,842,842,842,842,255},
{36247,30039,23637,9301,5172,13396,27958,34102,2897,27990,40408,40408,40408,42488,36182,25747,32021,32021,46649,46518,40179,31923,36150,38262,38230,42358,42390,48729,40342,34036,15118,8844,15117,40244,40212,40179,29680,23439,19311,17230,17198,44373,48598,42259,46388,46388,35986,27632,31857,38131,36018,14889,10696,10696,10696,8648,8648,8616,8648,10696,10696,10696,8680,4519,4487,8713,29809,31890,27599,52792,52792,56984,48532,40080,37999,46452,44371,35952,27599,31726,38033,33807,29614,33840,35952,31727,23308,25420,33839,57017,54805,44305,38195,23631,17293,12970,27728,19309,15051,21390,12938,21422,13003,17196,19244,15018,23470,15051,25551,17132,14986,23438,14986,19244,19244,19244,23503,15018,19244,21292,21324,21325,17098,23340,23372,19146,25453,21259,23372,25517,23339,27565,23275,40112,44207,42224,34001,54772,23402,15016,25485,17034,14953,25386,27436,21098,27468,35723,35756,31792,40113,52758,52724,31723,37963,40011,17096,27465,42092,33674,35721,31561,27336,33673,29449,18983,16903,25224,44107,37866,35754,33641,35721,42027,44172,35787,27304,31497,40048,33840,25386,25419,19275,19339,13098,11051,11051,11115,11116,11148,17356,17129,17031,29481,29545,40045,48398,54672,52625,50512,54704,46285,42027,46285,39913,44074,50445,52591,54738,58932,58964,56950,56983,59063,59063,56950,52723,31658,44436,17325,6889,7051,5035,842,842,842,842,810,810,842,842,842,842,842,842,842,842,842,842,810,255},
{34199,30006,23604,9268,5140,13331,25878,29909,7025,32151,40408,40408,40408,40408,38262,29908,34101,34101,46584,44567,50710,44437,34069,19441,21489,27763,42391,42455,40342,33939,15053,13004,15117,36083,38066,31826,25584,21359,15117,17198,23406,50711,50679,40179,46355,42195,40179,33906,40342,40212,33906,38033,38065,38065,40081,40081,38033,38033,33840,29647,23308,19148,8713,4519,6632,10793,33938,29744,48598,52824,54904,52790,37999,33806,42094,44339,48598,52758,35888,40114,33872,38066,33873,31792,33905,27566,29646,31791,31792,57017,54773,52692,44469,29873,21519,12938,27729,19309,17164,23438,15018,23503,15019,17197,15084,21357,27695,23438,27664,17164,23437,29711,25485,29711,29711,23437,23470,19244,29711,31824,25550,27630,33871,33872,33904,33871,33871,35951,33871,33903,33871,33871,29645,38032,44240,42191,33969,54772,27595,12936,27598,14986,17066,19114,17001,16969,27533,35756,33675,31792,40146,50612,44305,23305,35883,23336,14951,19047,18983,31561,37834,39915,35754,33642,31561,27336,37834,33641,33641,23175,27336,29416,35754,39947,39947,42092,27369,29384,38000,35953,27500,27499,23371,19372,13130,11051,11083,11116,11116,11116,9067,13163,19177,25320,31627,29546,29546,35819,33706,44206,46318,39980,39979,42027,48332,52591,54737,46318,52624,52623,54771,56950,56983,59031,59063,56982,48496,31626,44469,13131,6922,2922,907,842,842,842,810,810,842,842,842,842,842,875,842,842,842,842,810,842,255},
{36247,32119,23636,19637,11381,17428,19669,17460,6993,30038,40408,40408,40408,40407,40375,42422,50744,44471,36083,25877,36116,38197,27731,31989,34036,23505,15150,17230,29810,23407,13005,10924,10924,10892,6731,11021,27697,21294,15085,21358,21325,35985,46518,46453,40147,29745,31825,29809,42357,46518,38066,33840,31759,27534,31694,33775,27534,25388,17035,17100,10794,8712,8745,10826,6632,6632,31825,44437,54872,52792,56985,42193,37967,37966,44240,40210,46485,54839,35888,42292,35953,33905,29679,29712,31792,27566,29647,31759,29646,54904,52693,48499,46485,29873,23599,29711,31889,19309,31857,33937,33937,27696,12938,19277,14986,38130,36050,36082,31889,21357,36017,36017,35985,33937,36017,25518,25486,19244,29743,31792,27598,27598,27565,31759,29646,27598,29678,23372,27565,25485,23340,27597,19146,27501,29547,44239,29775,50611,31757,12839,27565,14953,31792,14954,19082,18953,29581,33708,33643,27501,38065,48531,35886,19112,29578,21288,14951,12807,16935,27369,21063,27336,44172,33674,33642,35754,33674,31529,31561,37834,39979,44139,39947,29481,31593,39980,31562,27271,37935,35985,31694,29579,27596,23566,15211,11050,11148,11148,11116,11115,9035,9003,13066,14919,14887,14887,14887,27433,33641,33674,25288,31626,40012,48365,54737,50511,52591,46317,48332,46284,46383,52690,56983,56982,56982,52723,33739,37998,40373,9034,4906,2923,875,842,842,842,842,842,842,842,843,843,842,874,842,842,842,842,842,842,255},
{38327,34135,23604,17589,5108,17428,21749,23733,6993,27958,40408,40408,40407,40375,38230,17361,23667,31923,38164,38164,33971,38197,34069,36182,36149,15150,15150,19311,29778,23439,10924,8909,8909,6764,8876,10989,25520,27567,17230,17165,25584,21326,29712,35953,36083,31890,25617,23537,31858,52824,48598,42259,42291,42292,44436,44404,40146,33808,21293,17100,8713,4519,8745,12907,2472,6600,29680,48598,54904,54904,48532,40080,37967,52593,35822,29679,38164,50645,35887,35952,35887,40081,29646,33807,38032,33840,23340,23308,31726,57017,50645,48531,48565,31986,23599,29776,31921,23437,29744,29776,27631,29744,10858,21390,17066,25486,29744,23470,29776,17164,23373,25550,21259,25550,21259,23438,23438,17099,21389,17099,23405,23405,17066,25485,21227,23405,25486,14986,23405,21259,21259,25485,19114,23307,19081,44240,40145,52691,46385,35853,23274,16968,29614,12808,16937,21065,29581,31660,37803,25388,33807,48499,40080,21127,23304,25481,27465,33674,25385,21127,37867,33674,39947,35787,27368,35786,27336,37867,35754,42027,39946,42027,39947,31561,27368,37867,31562,25223,33708,42260,33840,27467,31757,27759,17292,13131,11180,11148,11116,11115,9035,8970,8970,15081,17032,14919,21160,48399,42093,31561,27400,31561,37835,48300,56817,56850,56851,56883,54704,52592,52724,54869,56950,56950,56982,54803,33771,42258,27890,6986,4938,2923,907,874,842,842,842,842,874,843,843,843,843,843,842,842,842,842,875,875,255},
{34167,30039,21620,23765,13331,23636,25878,27926,6960,25845,40408,40408,40408,38327,42390,21522,31988,42358,27665,33938,25617,25585,25747,31988,36149,25585,15118,21391,38164,25519,6731,6731,4683,19343,36182,29778,23406,27599,23504,25552,15117,12972,31857,31825,25616,29679,21293,17165,29745,52791,38033,38001,48533,44405,44404,40179,33937,29647,19212,15052,6600,4552,6632,2471,10858,38099,40179,46518,54937,52759,40080,31694,25355,23274,25421,38066,40244,46451,31693,35919,33807,35887,29646,31726,33807,27566,23372,29646,29613,52791,52726,46386,40113,34067,23632,12970,29777,23438,21357,19309,17131,25583,13036,23535,19179,19212,23503,15051,27696,17131,21292,21357,19147,27566,17066,21357,21357,17164,23470,17066,23405,23372,19147,27566,19212,25485,25518,23340,27598,25453,29613,31758,29646,33806,35887,44239,54771,54771,52626,40013,17000,16935,27501,17034,14953,25388,25388,31628,37771,27468,25486,40015,42160,21160,23304,33770,39947,39979,31626,40012,54672,54671,44172,37899,29481,37834,31561,39947,37834,31561,39946,44107,44171,39947,33641,39980,29481,25223,29417,40179,38066,29547,31725,29775,21452,13163,11180,11180,11116,11083,9035,8938,8906,8905,10953,13001,19242,38030,54706,52690,35820,35787,50479,56817,56883,56884,58964,58997,58964,59096,59129,59097,59064,56917,56917,48595,33805,44469,19535,7019,2955,907,907,875,842,874,875,842,843,843,843,843,875,843,842,842,842,842,842,842,255},
{36247,27958,21685,27894,17395,23604,25878,27926,4912,25845,40440,40408,40407,40407,36149,36052,38197,36117,17264,15216,17328,15248,25715,46648,46616,40277,36051,36018,46485,38131,21326,19246,27665,40309,38262,36052,10892,6796,13037,21358,19245,17230,31890,38099,29778,33938,29745,23472,27665,40179,33841,31824,27631,29712,35953,37967,29581,23308,19115,14954,10761,8746,6632,2439,33906,50711,40211,46518,54904,40081,33806,14953,8648,6535,17067,40178,40178,48565,33807,42291,35985,31727,29744,33840,31727,25486,27534,33872,31727,50678,54871,50612,44371,38228,23664,12971,29776,23437,23471,21325,21292,27631,17196,27696,23340,25486,25615,25518,29776,23405,31792,27631,29679,33904,29712,27696,27696,25615,31857,36017,31824,31791,40178,38098,38098,40178,36050,38130,38098,38097,40145,38065,35952,38065,35919,42159,52658,56852,46417,33805,23307,21227,27501,29711,27533,29613,14921,25421,37803,29548,27631,35887,46419,31562,19047,21127,19047,27433,27401,29481,35787,42092,46318,37867,37867,42027,39946,33641,29449,29448,31528,31529,33641,35754,33673,42059,35754,25191,29384,40080,40211,31759,29613,29710,21452,17291,13260,11245,11115,9003,8970,8906,8905,8873,8873,8873,8873,10921,19275,23468,23435,29741,21387,21420,21420,21420,23532,29774,50643,59062,59062,59063,56950,50544,37964,31724,29613,29840,11115,7019,5003,907,907,842,842,842,842,843,843,843,843,843,875,843,843,843,843,842,842,842,255},
{38327,34070,17460,17524,17363,19508,27893,21653,4880,25845,36279,38327,40408,38327,36117,42325,40245,34069,19474,21555,25715,19474,9072,11119,13200,17328,27763,23602,25682,23537,27762,25520,29777,40277,36150,29811,8908,8812,19278,27534,15020,19277,33970,27600,29713,27665,21390,19343,19246,12907,17133,15020,4552,8713,35952,44176,37870,33709,27435,4455,8713,8746,2439,15084,40244,44438,35953,44404,46452,33775,23308,19147,14921,14921,25388,40145,44404,50677,33872,42161,37968,31759,29679,31728,31727,25486,27533,31759,29647,40179,48630,46484,38097,40308,25745,31889,36050,29744,38164,38163,40243,40211,36083,38163,36018,42324,40276,42356,38163,31857,40243,38130,38098,40178,36017,33937,29776,25550,33969,31759,31792,31759,29614,35985,27598,29679,31792,23340,31792,25485,25453,31791,21227,36017,23339,40078,35949,29709,21322,23404,29645,31791,33872,31694,29581,23340,17067,29745,35723,35821,36051,40145,44338,31595,27368,23208,16967,19015,19015,19016,16967,14855,16903,14822,21063,29416,25288,23176,25288,21095,23143,21063,21063,18983,18983,23175,31561,27336,29351,35854,42325,35985,27500,33839,27694,17291,15276,13325,11115,8938,8938,6857,6825,8873,8841,8841,8841,8841,8873,8906,8906,8970,11018,11019,13099,13131,11115,13195,17291,38129,50644,50610,48529,40077,31658,31692,29678,21518,9067,7051,2955,875,875,843,842,842,842,842,842,842,842,842,843,843,842,843,842,842,842,842,255},
{36247,36215,17460,3027,17396,25651,23733,15379,2897,11283,15411,19604,27958,29974,38262,31956,38197,38165,19409,17426,19474,17426,4911,11120,15378,6926,6894,6894,4846,6894,21554,29745,29713,23504,19344,19278,15085,17132,29679,29582,21261,19181,31825,19213,21359,23407,17133,21391,23504,14987,21326,21358,4584,4520,6665,10760,17002,31531,31661,6600,10794,8713,4520,15084,40277,44372,33840,44371,35886,29646,12809,14921,19081,21161,19049,35952,38099,48597,33872,42129,40048,33840,38098,36019,29712,25454,23406,23406,23406,27631,44372,48598,40178,46582,44470,36050,40276,36050,40212,38098,35985,40211,21390,36018,25486,33937,38098,27631,40211,25485,27664,27631,23340,33905,21227,29712,27631,19212,29744,21227,29647,29646,21227,33872,25453,29647,31792,21292,31792,27598,27566,33872,25453,33937,25452,37966,27564,31790,40145,31726,17001,12808,14921,17001,25421,21227,29614,35985,31595,31693,44502,40146,42193,33708,31496,33608,29416,21063,12775,14855,12774,8646,16935,27368,29513,35754,35786,29449,21095,21095,25256,29481,33674,31529,23176,21063,25256,31529,29351,35821,42325,40212,27468,31725,23468,19339,15276,13326,11180,8906,6857,6825,6793,8841,8809,8809,8841,8841,10889,10889,8906,8906,8938,11019,11051,11083,11083,13196,11115,15244,38195,29612,27532,27597,27532,25387,27760,11148,7019,2923,875,875,875,842,842,842,842,842,843,842,810,810,810,842,810,842,843,843,842,810,255},
{34135,23733,13364,979,11251,17363,23733,19572,2864,15444,13331,881,11347,29974,29909,19442,27762,40212,29844,21587,21587,23635,19409,8909,11152,11087,6927,6927,6927,9007,38196,42292,33873,27567,25487,23407,21327,21326,27599,27534,19278,13005,29745,19213,19278,23407,17165,21358,21358,15084,17165,17197,10858,6665,10826,15051,19213,23373,23373,19213,15020,17068,8746,17132,46518,46485,44437,31759,33773,27468,14889,12841,14921,17001,12840,27565,44437,46484,33872,38098,38163,40276,46485,46486,42324,44404,42292,42292,40212,40212,46452,48565,40178,50711,52824,23405,40276,42324,33905,27631,27566,36050,21390,36051,25518,31792,36017,27631,40243,27598,31825,31824,27598,36018,27598,33904,31824,25518,33937,29678,31792,31791,29646,35920,31726,31759,31759,27533,29646,27501,25420,25420,21194,19081,19081,38032,44371,31693,33807,23373,8550,8582,19082,29581,42291,38033,33807,35919,25353,25354,42291,42291,44338,40014,31528,25288,27336,19015,14855,10694,10694,14887,33706,42059,27368,31561,31561,23176,12774,16935,16935,23176,27368,35754,31561,31529,31529,23143,25223,35756,46518,40244,27467,29580,23338,19339,15276,13260,11212,8970,6857,6825,6825,8841,8809,8841,8841,8841,10889,8841,8873,8906,8906,8938,8938,9003,9003,11083,11115,11115,25744,44470,44437,40276,25517,27630,21551,11148,4971,875,875,875,875,843,842,842,843,843,843,842,842,810,842,842,810,810,843,842,810,810,255},
{38295,21588,7155,9268,15412,21523,25781,21621,6960,23765,15444,719,5042,25813,31989,46584,36052,36084,36150,27828,25748,23667,23602,8909,9007,9039,6894,8942,6894,8974,31923,44437,31825,27567,29582,29648,23439,21358,21326,35888,21326,15085,27665,17165,19343,23504,17262,15052,17230,13004,15052,17165,19310,17197,21358,19245,17165,17164,15052,19310,17165,15052,10858,17132,40244,40244,29679,23340,29484,16905,14857,12808,12840,12841,6567,23308,48597,50645,29613,25485,25486,23373,35920,40146,50710,46452,46517,38098,29679,27598,44339,44404,36017,50743,52857,35985,46518,42388,44437,42324,46484,46550,38131,46550,42291,50742,50678,48565,40178,29711,33871,29679,29614,29614,25420,25420,23307,21227,23275,21194,19114,19114,19049,16969,19049,12840,19081,21130,23275,23275,17001,12743,25355,8614,10727,29679,42291,33904,25453,25388,25355,37967,31694,25388,31727,31725,29515,35853,31594,31594,31661,29646,50645,42225,23175,14822,14854,14887,10758,10726,21160,25353,35754,42059,33674,35722,27401,19015,10694,10694,12774,14855,27368,37834,39947,37866,31497,27336,27304,31529,42226,44405,29580,27402,23273,21355,15276,13260,11245,9035,8970,6890,6825,8809,8809,8809,8809,8841,8841,8809,8873,8874,8906,8906,10954,8938,9003,9003,9035,9067,13196,32018,42486,42486,38293,23696,11180,9132,2923,875,843,843,875,875,843,842,843,843,843,842,842,842,843,842,842,843,810,842,810,810,255},
{34135,29780,15347,13364,13332,23636,21620,25781,6928,29909,15411,752,2961,19604,27795,36084,31891,40213,29811,23570,29843,21425,29746,29745,23602,21521,17328,17360,19408,23634,29842,34003,33905,29679,29680,31761,19310,21391,19213,23341,21326,13037,31825,19245,17229,17197,15149,10924,10924,12939,12939,15052,15084,15052,17164,15052,15052,17132,17100,17197,15116,15084,15052,12907,15019,10794,8713,10794,19278,15020,10793,8680,17001,12841,6567,17066,46484,44273,33740,17033,8648,8647,31694,31759,46484,38098,48565,40146,33872,29647,38066,46583,46550,50743,50711,52823,50710,48598,50678,46517,48598,44404,46452,42291,38098,36017,33839,27533,23340,23308,27501,19114,16969,12808,14921,12808,12776,12776,12743,10662,10695,12775,6534,6502,19082,8615,16968,25323,19082,17001,14889,14824,16969,8615,8583,12808,12808,10728,14889,14986,19115,27500,17001,14888,25453,25419,33740,31726,31661,39883,31693,31694,48531,44338,25353,12807,12807,12807,10726,10694,19047,21096,21063,39915,33674,35786,29481,25288,19048,12774,12774,14823,23176,21127,31529,33609,31529,35754,31529,29384,35722,44372,31726,23241,21160,19242,17324,13228,11212,11148,9068,9035,6857,8841,8809,8809,8809,8809,8809,8809,8841,8874,8874,8874,10922,8906,8938,8970,9003,9067,7019,11180,13260,13293,13261,9067,7052,5004,875,875,843,842,875,875,875,842,842,843,843,843,843,843,843,843,843,843,842,842,810,810,255},
{23798,17492,11219,2995,13331,21588,19507,21653,11024,36150,21620,752,913,19636,40310,44405,31858,25585,17199,23439,33842,27471,31826,21424,34068,25715,23602,36019,33906,31891,34036,40244,46452,38066,15085,19343,23504,21359,17101,17100,27632,23374,31890,23472,15084,17165,15117,12972,12972,15052,15084,19245,19245,17132,17165,17165,19245,19245,19245,17132,15052,17132,15085,8746,4487,2407,2407,2439,19277,23373,14986,10760,14921,21162,14953,15018,31727,25322,19114,12841,12841,14856,35887,44372,44404,40146,48500,29679,27566,27566,25486,33905,31792,31759,31759,27599,27599,27534,25453,23341,23341,19180,14922,16970,12841,10760,8647,12873,21227,19179,23307,14921,12776,10695,12744,10663,8582,10663,14823,12710,8550,6470,4389,10695,14888,17001,35887,25355,25354,33741,27436,25388,12841,10728,17002,29614,29679,14986,21325,17067,21293,8647,8582,14921,23340,25453,33839,29614,29581,37836,31660,31693,44306,46451,23241,14919,12839,10759,10726,12774,21160,21161,21095,35787,21096,21128,23208,27401,25288,19015,10662,12742,12742,16903,29416,37834,35721,37834,37867,27336,35690,42259,31661,27435,23274,21290,17324,15308,13228,11148,11148,11181,6922,6793,6761,8809,8809,8809,8809,8809,8841,8874,8874,8874,8873,8906,8906,8938,8970,9035,9067,7051,9132,9164,7052,7052,7052,5004,875,843,843,810,843,875,875,843,843,843,843,843,843,842,843,843,843,843,842,810,810,810,255},
{15542,3027,979,947,15380,27861,29942,25813,19410,32022,23798,2929,2961,29974,38197,42292,33939,25650,21489,23472,31858,29649,27730,19279,21391,10957,10957,44112,39790,35856,40211,46452,50645,44405,27664,33970,27633,23504,21294,19181,31891,17133,27762,25584,15085,15149,17198,17230,17198,17165,19310,19311,19310,15117,17133,17197,17165,15117,15084,15052,13004,12972,10826,4552,2439,2439,2439,2407,25386,29548,21162,12840,12841,23210,19146,17033,12840,8615,10728,8648,14856,14856,31727,48598,46485,38033,33839,33840,27566,27567,25486,23373,25454,25486,23373,21292,21260,19180,21292,21260,21260,19147,14954,17002,14921,19082,14921,12809,17002,10792,17002,12808,17001,17001,19082,21162,14986,23307,25356,21227,23340,23372,27533,27566,25485,29646,29646,29614,29646,35985,31726,27468,23372,17099,29646,42225,36050,12841,21325,14921,17099,4389,12776,21195,23340,23340,27534,27501,27533,33675,31596,25453,35822,48531,25386,19112,14919,10758,10726,10694,16935,25289,25288,33706,25288,21063,16903,18983,16935,16935,16935,16935,16903,29449,39915,39947,35754,35754,29481,25256,33577,37967,33774,29580,25354,23372,19404,15276,15276,13163,11148,11180,6955,6825,6793,6793,6793,8809,8809,8809,8841,8873,8874,8874,8874,8874,8906,6890,6922,6922,6922,6987,7052,9100,7019,7019,5003,2923,875,875,843,842,843,875,843,843,843,843,843,843,843,843,843,843,843,843,810,810,810,778,255},
{19606,11187,980,7091,21620,29974,34134,32022,19507,25813,21750,3092,17556,32021,34037,36020,29876,29909,29876,25683,31923,23440,23504,38067,27600,10957,4683,42032,39790,35727,33873,29679,40147,57017,42259,33906,19246,15117,23439,23471,29843,21423,36083,29810,13037,15117,15117,15117,15117,13037,15117,15117,15117,15117,17165,15085,15085,15052,15020,15052,15052,12939,12907,6633,2439,2439,2407,2407,19017,25355,19017,12841,14953,12840,8679,14920,12840,10728,10728,10760,16937,16937,17034,38130,50710,33808,19148,33807,31662,21195,21227,23308,21228,21227,21228,19147,17034,16970,21227,21260,21260,19147,17034,19147,29647,38065,40146,21227,27500,27630,25550,27631,35953,23372,25485,25485,21227,29613,21292,23404,27598,29678,33904,33969,21259,23372,16969,23340,21292,21195,25420,21097,19179,12874,29646,35984,31792,19180,23438,17099,17100,12776,23308,23340,17066,17067,14953,25388,29581,31628,35919,25584,29581,46451,31692,17032,12806,12775,10726,10726,16967,31594,33707,37899,39980,37867,31594,29514,29481,21128,25288,29481,33641,37834,37866,42027,39914,37866,27401,23143,27336,31628,40146,31693,25322,27597,17324,17356,15276,13163,11148,11181,6955,6825,6793,6793,6793,8809,8809,8809,8841,8841,8873,6858,6826,8874,6858,6890,6890,6858,6857,4842,6954,7019,7019,4971,2923,875,875,875,843,843,843,843,843,843,843,843,843,843,843,843,843,843,843,842,810,810,810,778,255},
{23701,21460,980,9171,19508,32054,27893,21652,17459,15411,23765,785,23765,32021,25715,36052,34004,25748,21587,21522,31923,31858,23536,17231,17198,4716,2635,39854,41838,31696,25552,21294,31761,36018,27599,29712,25519,19213,23407,25649,34068,29810,42324,31923,15117,17165,17165,17230,17198,17165,19278,19278,19278,19278,19278,19245,19246,19245,19245,19213,19213,17165,17133,8746,2439,2407,2407,2374,10794,21195,17034,12873,17098,12905,8680,10760,14921,10760,8648,14921,12808,12809,12873,17034,35985,44372,31727,25420,37935,19082,21163,23308,23308,19147,21260,21195,19114,17066,19147,19147,19115,17034,14921,23405,44437,42356,40146,16807,23210,25453,17131,25485,29711,14888,23308,23308,21194,27500,19146,25421,27565,33937,33904,31857,25486,27566,21292,27598,27598,31824,31759,23242,27533,21227,25388,35952,38098,14987,21326,10826,19213,10695,25485,31759,14921,17067,17034,21195,23307,33708,40178,33905,29613,44306,35886,33738,19112,14887,12774,12839,14919,16903,33706,35819,35852,44238,42126,40013,35819,25321,33642,35786,33673,31529,35689,39946,41994,37834,23176,21063,23176,23144,33807,33774,27467,27598,19372,15308,15308,13163,13163,11180,6955,6858,6793,6793,6793,6761,8809,8841,8873,8841,6793,6825,6858,6825,6858,6890,6858,4745,4777,4809,4842,4906,4907,2859,811,843,875,875,843,875,843,842,842,843,842,842,843,843,843,843,842,842,842,810,810,810,810,778,255},
{27862,21460,5172,9204,27764,29909,17394,29941,29909,19539,27894,752,9170,23667,25682,36084,29746,23505,21392,19344,25617,31826,31858,4748,588,588,523,37774,40017,27698,21424,21326,31760,33841,29745,33938,27600,21326,23407,27535,42422,31923,38163,38164,21391,19311,19311,19343,19311,19310,19311,21391,21359,21358,19311,21359,21359,21358,21326,21326,21358,21326,21326,17132,10826,8713,8713,4520,17034,23274,21130,14889,14953,14921,8680,10760,14921,12840,8680,12808,10728,10728,14921,10728,19114,44307,50678,42226,46354,25388,23340,23373,23341,21260,25388,25421,23276,19179,21260,21228,19147,17067,19147,23373,40243,36018,40179,21032,23210,29646,23470,27631,31824,25486,33937,33969,29678,33904,25583,31792,31824,34002,38098,36050,29678,31759,21260,31759,27533,29614,31759,23307,27501,23274,19081,35952,40179,17131,21358,17034,19245,10663,29614,35920,17034,21195,23340,19147,23308,27467,38032,33872,31726,44338,38032,35786,27433,23240,17032,14952,12839,12806,25288,37867,37867,44206,46351,44238,42092,39979,39947,33706,29481,37834,31561,33641,37834,29448,27369,19016,18984,21096,23176,31661,31694,29711,19405,15244,15308,13228,13131,11116,9035,6825,8809,8809,6793,6793,6793,6825,8874,6825,6793,6825,6858,6825,6858,6858,4777,2664,2697,2729,2761,2794,2826,2826,2859,843,843,843,843,843,843,843,842,843,843,842,843,843,843,842,842,842,842,810,842,810,810,778,255},
{29910,21491,15541,15412,23604,25716,17394,23700,27796,19572,27894,2929,11121,11120,25747,40212,44307,38002,35954,35922,33809,29615,25487,4749,588,555,491,33678,34003,34003,29713,29712,40146,42259,31858,33938,33938,27632,19343,25454,42325,34036,42356,46518,27697,23504,25584,25584,25616,25584,27697,27697,27697,29777,29745,29745,29777,27664,27664,27664,27632,27664,27664,29712,27599,23406,25518,21325,35920,29581,27533,23340,10760,10824,10760,10760,8680,10792,10760,10760,8647,10696,19017,10696,19115,50645,48565,37967,50612,27566,23405,25519,25486,25453,29582,31662,27534,19179,21260,21227,25389,19115,21195,23340,40211,23438,40179,21065,21194,29646,27598,25485,35952,21227,33905,29744,27500,33839,23372,31727,29613,38195,40211,38195,29646,29678,23340,33807,27533,33839,35920,25388,33806,31628,29515,33839,35985,17132,19245,12906,19245,8615,25453,33839,19113,14920,27468,29614,33906,27533,33643,31694,35952,44338,40145,25353,16999,14919,14984,19144,23337,23304,33674,48333,44140,44140,48431,48431,44205,37867,37834,33706,19015,37802,29481,29448,25256,27336,35721,29448,14790,18983,21096,23144,31727,25485,17260,13163,15308,13228,11051,11083,9035,6825,6761,6793,6793,6793,6825,6858,6858,6825,6793,6825,6826,4777,4809,4777,4713,4712,4712,4745,2729,681,2762,2794,2826,810,810,842,843,843,843,843,842,842,842,843,843,842,842,842,843,842,842,810,810,842,810,778,255},
{36183,29877,34199,27861,19508,27861,21587,17459,25748,9170,25846,9203,13266,15346,21554,38132,46453,38099,33906,38001,29550,23310,19214,2603,491,491,490,29550,36019,31923,27664,38099,40178,38098,44437,42324,31825,27600,23439,33744,36019,31923,33970,44470,44470,40244,42324,42324,42357,40211,42324,40211,40211,42357,42324,40179,42292,38098,35985,38098,38066,36018,33970,36018,35953,27631,31824,29647,35986,29679,31760,25486,14954,8712,12905,17034,17034,17034,14954,19147,21195,23275,25388,21260,29646,50580,50678,42095,46419,29647,25453,25518,25486,23373,27501,27469,23308,19147,23276,21195,23275,19114,21227,27599,42357,25518,38098,21097,23307,29646,27598,29679,33905,25420,31791,27533,31726,35952,27566,33872,29646,33969,35984,38162,31758,29678,25420,31759,27500,29645,31726,21194,31726,21161,23274,29646,33872,21260,19212,12938,21293,8647,25421,31758,23306,23273,33806,31759,40277,29646,31562,29580,35887,44306,40144,29513,23208,19079,23273,29513,35754,33673,44173,50512,52591,46220,46285,42092,37899,35754,29480,23176,16902,21095,16935,19015,19015,25288,37802,37769,29416,14823,19016,21063,31694,25486,15082,13098,15308,11148,11018,11019,9003,6825,6728,6760,6793,6825,6825,6858,4810,4842,4809,6825,6825,4777,4777,4777,4713,4680,4680,2697,649,681,681,2762,2794,810,810,810,843,843,843,842,842,810,810,810,842,810,842,842,843,842,810,810,810,810,810,778,255},
{38295,34134,36215,19475,17459,38295,27796,11251,25716,11250,30006,7090,9138,27861,25650,36052,42358,35954,33842,42195,17198,4716,2636,523,523,491,490,23342,38164,34036,29777,31890,27664,27632,31825,25487,25422,27567,33939,46322,33938,40244,33971,50711,48663,44437,42324,40276,33905,31760,33905,38098,40276,36050,40178,31825,25551,25518,19212,23405,19180,21292,15051,17099,17099,12906,21260,31760,35986,31760,29679,19147,12873,8680,29678,48565,46485,46485,46484,46485,46484,46452,46452,44371,44371,46518,46452,52692,52692,29647,27599,29679,29679,33840,31694,31694,31791,27534,27534,29614,25421,25420,29614,25486,23373,19212,33937,27468,27533,31694,25486,29679,31823,25420,33839,23372,27501,29646,21259,31791,27500,35985,36017,36082,29646,27566,23340,31791,25485,31791,31759,27501,31759,19082,25387,31726,40178,23406,19212,15019,19245,10728,16969,21227,23275,31629,35920,31759,29614,27501,25354,27467,31693,37934,44240,35721,29383,23207,23240,19015,23143,21063,25223,25288,27368,27336,25255,23143,23143,23175,23175,25256,27401,21096,10694,10694,12742,16935,23208,29416,33641,18983,16871,18983,25355,21292,12969,11018,13228,11148,11018,8906,8906,6761,6696,6696,6761,6761,6793,6825,4777,6826,6825,6825,4745,4745,2697,2697,2632,2632,2632,2664,617,649,649,681,2794,778,778,810,810,811,843,811,810,810,810,810,810,810,810,810,842,810,810,810,810,810,810,778,255},
{38295,38327,38295,23572,17460,34134,23636,17395,25748,9170,32054,2865,7057,34102,40245,40244,38132,31761,38099,42357,13038,620,588,555,555,523,523,4683,23536,44438,40244,35985,33840,21261,23406,23439,25357,25390,40147,50613,42324,42324,42390,52857,46615,44437,38163,34003,27664,27599,27599,38131,40308,38163,36018,27599,27599,21292,21325,25486,23373,21292,21293,17067,10826,10794,29647,33840,38098,33873,21260,10792,10760,10760,33838,54805,50678,48597,48565,46484,46452,44371,42291,42291,44404,44405,33775,52692,52725,29581,23373,33840,29712,35985,35952,40178,38131,31792,40178,38032,35952,38033,33872,29679,21227,25486,31857,35952,21162,27566,23437,31792,33872,27565,33904,27631,31791,31792,27599,35985,29711,36017,33969,33937,31824,27598,27598,29711,23340,31824,29679,25420,29613,14920,25354,27500,40178,21358,15019,17099,17165,12809,10728,12841,19115,27501,29582,33806,27306,27468,23306,25353,29580,33741,46320,37802,25223,21095,14887,12774,14855,19015,23144,31529,33641,39979,29513,23176,16935,29481,33674,25288,27400,21095,19015,10662,12774,14823,21128,14822,29384,23143,14790,18983,23177,23405,12905,10986,11115,11148,11018,8873,8841,6761,6696,6696,6728,6728,6761,6793,4777,6793,6793,6793,4713,2665,2665,2633,2600,2600,2632,2664,616,617,649,649,681,746,778,778,778,778,811,811,810,810,810,810,810,810,810,810,810,810,810,810,810,810,810,778,255},
{38327,38327,40375,25716,17427,29909,21523,11186,21587,21587,32087,4945,816,25715,40180,46550,42196,19279,19312,29810,13102,556,556,523,523,523,588,6796,17198,29810,29680,33873,33906,33873,29550,31794,29583,25422,33775,50580,38099,40276,50776,48598,48663,46550,42356,40244,40211,38131,38131,42324,40243,40243,40178,35985,35985,33872,33904,33840,23373,19245,17132,8713,6568,21261,31793,36051,38066,35985,19114,12873,10792,10760,33871,50611,44306,40146,40146,38065,38033,35952,33807,38065,48532,46387,33773,50547,48499,33807,31726,42324,44372,40178,46452,44404,42356,44404,42291,40144,46452,40178,35985,36018,35952,44306,38065,40210,19017,29614,25583,40243,40243,25518,35985,29744,31726,29646,25420,33872,31856,31758,31726,35984,33872,23340,27533,29678,21195,33872,27631,27468,31726,21194,27467,31758,31791,25519,17132,19244,21292,12841,12841,14987,17034,21260,25453,33774,29322,27436,31660,29482,27501,33774,48466,42027,31464,19015,12807,12807,12774,14855,14822,19015,27401,21128,21128,23176,21063,29449,35786,21095,23176,31561,27433,14822,10662,10662,23240,23241,21030,25256,14790,18983,21064,25486,12872,10953,11115,11148,9035,8873,6728,6761,6696,6696,6696,6696,6728,6793,4777,6793,6761,6761,4680,2600,2600,2600,2600,2600,2600,584,2632,616,617,649,649,714,746,778,778,778,810,810,810,810,810,810,810,810,810,810,810,810,810,810,778,778,778,778,255},
{38327,38327,40375,25749,15380,23668,21556,17427,23636,29909,34102,7025,752,9234,31956,44406,38067,10957,8909,10990,13135,6862,4716,4716,4716,4749,4781,21424,25520,25584,34003,38164,36051,36051,35889,38099,31793,21358,19245,27664,33905,52857,42292,38131,44437,42389,34003,29712,38098,35986,33937,40243,42323,42291,42323,40308,40243,33937,36050,25486,14987,10826,8745,6600,6568,17100,35986,36051,38098,40146,31759,19147,10760,6599,31726,50579,48498,42225,42258,42225,42192,42192,37999,35919,40145,37967,27435,40015,35789,42161,40113,50776,55003,38066,44404,42259,38065,42259,33905,35920,33872,44436,44437,38066,40178,46386,33904,40210,18984,27501,17164,40276,42389,23373,31792,23372,31791,29646,27598,33937,33970,33872,31759,33937,31824,25486,31792,29711,23373,31824,29743,25453,27566,19114,23340,38065,33872,25519,12873,17132,17132,12874,12679,19050,19180,19146,19113,29580,35725,31629,31628,23340,23340,35887,48498,40045,29545,19048,12742,10694,10694,10662,12742,16935,18951,23208,37899,27369,29449,29481,37867,23208,18983,21063,27336,16935,12774,12742,18983,23240,14790,27368,16903,18983,18983,27598,12905,10889,8970,9067,9067,8905,6760,6760,6696,6696,6696,6696,6728,6760,4745,6793,6793,4680,2600,2600,2600,2568,2600,552,552,552,552,584,616,617,649,681,714,746,746,778,778,778,778,810,778,778,778,810,810,810,810,810,810,778,778,778,778,778,255},
{38295,38327,38327,29909,21556,19540,23668,34134,34134,34102,44536,15444,914,17588,34102,42325,29746,8910,6797,8877,21424,19344,13103,13103,13103,13103,8909,29810,27600,31792,36018,44438,38131,44470,50613,48533,29615,21326,23374,25454,38066,46550,36020,36083,40276,38163,38196,29744,33938,31825,33938,31792,35985,44372,25454,23405,23373,17067,19147,10793,8680,8681,6600,8616,6568,19245,36019,35986,33905,42259,31727,19147,14953,8680,33872,52724,52692,50644,50644,50611,50579,46418,40112,37999,31661,27436,23276,40112,37935,37935,35822,44404,52922,33872,48598,46485,42290,52823,52824,52824,38033,44404,44405,42292,40113,50579,40178,40210,21162,25421,23503,38131,38195,31759,29744,23405,31792,25453,25518,29711,27663,31759,25453,36082,31823,19179,27566,25485,21227,31758,23340,25420,29516,21195,25388,42258,40145,29712,17099,21326,19212,14954,12776,17067,10761,10728,21226,31661,29581,33806,29580,27566,19212,21227,48467,38031,21289,12806,12742,8614,10694,10726,14855,31530,31594,21127,35721,37867,27401,29481,46285,29514,19015,25288,29481,19047,12742,16903,21096,18983,23176,33674,16935,18983,18983,29614,17131,8776,8906,6922,6955,6825,6760,6793,6728,6696,6696,6696,6696,6728,4745,4745,4745,4680,2600,2600,2600,520,520,520,552,552,552,584,584,584,616,649,713,714,714,746,778,778,778,778,778,778,778,810,810,810,810,810,778,778,778,778,778,778,255},
{38295,38327,36183,25781,19540,17427,23603,32054,36182,36182,27861,7057,9170,17524,29876,25585,15118,13038,10925,8909,29778,31859,15215,17296,19376,17296,13102,34003,31825,33873,36018,48565,44372,50678,46485,40146,33840,33938,33840,33808,29647,23373,21294,14955,14922,17003,29712,27599,25552,33873,33840,31662,35855,40178,21195,19147,23341,10728,10761,10728,8681,10729,10728,8680,6600,21358,33905,33905,31825,29647,19179,17034,12873,10760,31759,50644,52724,52724,50644,50611,48498,42225,37999,35886,35887,35952,31759,31726,29613,31693,35855,38163,40277,33840,42324,38098,31727,50742,52823,48597,46451,40178,44404,40211,31693,40080,40178,42291,19147,23372,19180,38098,42421,27630,29711,19147,31759,25452,25485,29711,31921,31791,23372,38195,33937,23340,29678,25453,23340,31726,25485,29581,29516,23340,21227,40146,33872,27599,10793,17165,14954,17099,12808,19180,10728,14987,17066,25453,27468,33806,29581,29548,23340,21227,40145,42290,27497,23175,18983,10694,10758,10758,10758,19015,21095,29481,44172,44172,31562,25288,35755,31626,16902,23176,31626,14854,14790,16903,14822,14790,29448,35754,21096,18983,18983,23242,21292,8743,8841,6825,8905,6793,6793,6793,6793,6728,6696,6696,6696,6728,4713,4745,4745,2632,2600,2568,2568,520,520,520,552,552,552,552,584,584,584,617,649,714,714,746,746,778,778,778,778,778,778,778,810,778,778,810,778,778,778,778,778,778,255},
{38295,38327,36215,23668,9203,15347,15314,25781,36182,34102,27829,7024,15378,15443,23635,29811,33810,27536,21424,25585,27601,23537,34004,42358,29810,23537,13037,36019,23407,21326,35985,44338,48499,44372,38098,38066,35888,27632,42324,37871,31500,19083,21261,14954,14922,14922,33873,38099,33906,33906,40114,35887,33904,42258,25388,21227,25389,17034,12841,12841,12842,12874,10729,6568,4487,17164,29680,38131,36018,21227,12873,10824,12905,10792,31726,48564,46450,46418,44337,42224,38031,35886,31693,27500,27533,29745,25486,25453,31726,42193,40178,33840,40211,44371,48565,44339,42225,44338,44338,38000,42291,44437,40179,40146,44339,38032,42258,42291,23340,25420,23437,36017,42356,29711,29711,31824,31824,25453,27630,27631,29776,31791,23307,31824,27631,19146,29646,21260,21227,27566,23340,27533,23340,19147,17002,35952,31759,27631,17067,21325,15018,14987,12743,21227,12873,19148,14921,21227,27468,33774,31661,29514,27402,27501,37999,46418,33673,27303,16902,12806,12839,10758,12806,16935,23143,31529,39979,44172,33642,25256,31562,46319,42093,19015,19015,14822,16870,16902,16902,12710,16902,33609,29481,21064,18983,21064,23372,8711,6792,6792,6793,6760,6728,6793,6793,6728,6696,6728,6728,4680,4713,4745,4713,2632,552,520,520,520,520,520,520,520,552,552,584,584,584,584,617,681,713,713,714,746,746,746,778,778,778,778,778,778,778,778,778,778,778,778,778,778,255},
{38295,38295,38327,29877,11219,15379,19475,23700,34102,34102,32022,15347,11185,17491,21490,29875,42164,31665,23505,29713,21359,13070,19214,29648,14988,8844,4683,27729,36051,36018,29648,17165,17133,38066,33872,33873,35986,29745,42293,33613,37676,19147,38099,25486,23406,25486,31825,40244,46518,33971,44372,40048,35985,33806,29581,25388,25420,23373,23341,14922,12874,12874,10761,4487,327,6633,23471,38099,33840,38033,21259,12904,10792,10760,31726,50644,44241,40047,37967,33774,31661,27500,23308,23275,23308,31825,25518,23405,31726,35919,38098,46452,52791,50743,46484,48565,46451,48597,48597,44372,38098,48598,35952,42226,44404,38098,40210,42291,23307,21227,17131,31791,44469,29679,25485,31824,29679,23340,27598,25518,31954,31857,23372,31889,31857,23373,29678,23373,25518,27598,25518,29646,23373,23372,21260,44371,38065,33840,14889,19277,12906,21293,12743,27501,31857,29745,12808,19114,27469,33806,31661,31628,27435,19147,33839,46417,37834,29383,23175,12839,12839,14919,12839,12806,18982,29416,42027,46285,39947,27368,37835,50544,50512,33706,19015,25288,25256,19015,31594,19015,16870,23143,16903,21128,19016,18983,19081,10792,8840,6792,4680,6728,6728,6761,6761,6761,6728,6728,6728,4712,4713,2697,2697,552,552,552,552,520,520,520,520,520,520,552,552,552,584,584,584,649,681,649,681,713,745,746,746,746,746,746,746,746,778,778,778,778,778,778,746,746,255},
{38295,38327,40375,34070,15347,9235,9170,21620,36182,34102,23668,17426,17394,15379,19410,31859,40148,21294,17263,25585,27634,21392,17198,27600,19214,12972,8844,13005,15117,17197,10892,8811,21261,25454,19148,12907,15020,31793,36019,27405,33548,21196,46452,31824,29679,29679,29711,46550,44372,29713,44371,40014,44306,52757,37967,33774,35855,29614,23341,17035,12841,12874,12874,6568,2407,4519,25486,29647,23340,17067,14985,12904,10760,8680,35952,52790,50612,50612,48499,44306,40113,35920,31759,33873,23275,25389,23373,25421,23308,27501,29679,38130,52856,50711,48630,52856,52823,33807,40178,38066,31759,35953,40210,48597,46484,38131,42324,40243,25420,23275,23373,29711,38196,29679,25452,31824,29711,23405,29678,23438,25550,27598,19115,31791,31954,19179,23372,17033,25420,25355,21162,27468,19049,23307,19147,46452,35952,29647,12776,21326,17034,23405,14888,27566,27566,21260,21227,25421,27469,33806,31693,31628,29515,21260,27468,48531,39947,31496,23143,12806,12871,14983,14951,10726,14790,33577,44107,46252,39947,31561,29448,48399,44205,50479,33674,35722,25320,14822,23143,29448,25223,25320,12742,21096,21064,18983,16968,12840,6728,4680,4583,6663,6728,4713,6793,4745,4712,4745,4745,4713,2697,2729,2697,552,520,520,552,520,520,520,520,520,520,520,552,552,552,584,584,584,617,617,649,681,713,713,713,746,746,745,746,746,746,745,746,778,746,778,746,746,255},
{38295,38295,38295,34102,19476,11283,13331,21620,36150,34102,27861,32021,25716,17394,19410,36019,38067,23375,23375,33842,36052,23472,6796,8877,15118,8877,8877,13038,13038,15053,13005,12940,14988,21326,23341,15052,19116,31662,35953,29549,25292,25454,42292,31727,27566,27566,29646,42324,35888,33938,46518,50645,52757,56919,59063,59063,59062,42225,14954,14890,14889,14954,17067,12906,6567,6633,19213,17067,12874,6568,6599,12872,10792,8712,31758,48531,48564,42226,40112,35919,31726,25420,23341,27566,31695,17034,23340,23307,21163,21195,21195,29678,46518,44469,44372,40211,38098,25388,27534,25421,33807,42324,31759,48433,46451,40211,42324,38033,16904,23209,27566,19309,34034,27631,16968,29678,31725,19114,25420,17066,19211,25485,16936,33806,34035,21195,25420,19114,27533,29548,29580,35919,27468,35887,29581,35952,31792,31726,29646,29679,17067,14986,12776,12808,12808,12841,21259,27533,23340,29613,31694,29580,25322,27533,21259,48531,40013,31560,18983,12807,12839,14952,17032,12839,16902,31561,35754,42027,35754,27368,23175,42061,39979,42126,48399,27368,21095,14790,21063,33641,31528,29514,16935,21096,19016,16903,16936,12872,6695,6760,4583,4551,4648,4680,4712,4745,4713,4745,4745,2697,2697,649,649,552,519,519,519,520,520,519,519,519,519,520,520,552,552,552,584,584,584,584,616,617,681,681,713,713,713,713,713,713,713,713,713,745,713,713,713,713,255},
{36247,38295,38263,32022,21588,15379,21620,25780,34102,34070,34069,40343,25748,23699,23538,29778,42293,21327,29583,38035,31858,13070,10990,15182,23504,21423,21391,25552,29745,33906,31825,33905,33873,27600,27535,23439,29647,38001,42356,35790,35790,38066,42292,38000,33742,27534,27534,27534,31533,33743,44372,46518,38131,38098,38131,42193,37902,27566,23340,25421,23341,21293,19212,19180,17035,8648,6535,4487,8648,4455,2406,6599,12905,10760,15018,42225,46419,35951,35919,33774,33839,42258,42258,44371,44339,38032,35919,29581,25355,23275,23243,23242,23275,23275,25323,25323,25355,23242,16969,16937,25388,25388,23275,33741,40146,40211,42324,38033,16774,25225,29646,19309,27663,31726,21129,35951,35983,29645,35919,31726,33904,38065,35887,42193,42290,42226,38032,35919,33774,40079,50545,42159,42126,42061,33675,27402,25289,31595,35821,25420,2309,4389,8583,10695,12808,12841,21195,23243,14889,17034,31694,29581,23306,21195,23404,48531,35918,33673,21095,14887,10759,14919,14886,12871,21127,35754,44140,44171,44140,33642,23176,29416,44140,39947,44173,29481,23175,25256,25320,27335,29448,25288,16936,19016,19016,16903,16936,14920,8775,4744,4583,4550,4615,4648,4680,4712,4745,4745,4745,2729,2729,649,617,520,487,487,519,519,487,487,519,519,519,519,520,552,552,552,552,584,552,584,584,584,617,649,681,681,681,681,649,649,649,681,713,713,713,713,713,713,255},
{36247,38295,36215,27797,21556,21620,17459,25780,36150,34102,34102,38262,19442,23667,17329,29713,34004,13102,19214,31761,34003,13102,6797,27665,44373,44405,44405,44405,44405,44405,44405,44373,42324,40212,40212,19181,29680,38034,38065,33775,38033,29680,38098,50612,50547,29614,27534,31727,31695,25324,23308,27534,23276,23341,27599,33807,37675,25421,27534,27534,27501,25453,25421,25388,23308,19114,17002,10728,12808,6535,2374,6503,14921,12873,8712,14986,21227,17034,21194,25388,38033,46484,46516,46517,46516,46484,44371,42225,40112,37999,37967,37999,37967,37966,35854,33773,40145,44307,33708,33708,29515,27370,23242,16969,27501,42324,42324,42259,35789,42128,38097,35952,38032,38065,38000,35887,29614,25485,27501,25388,19146,17001,12840,21195,46485,40146,19114,17001,14921,23307,48465,25321,23241,31627,35820,37900,27434,27402,25321,31595,29548,21162,16969,16969,19049,19082,19082,16937,14889,19180,31694,29613,25322,14889,21323,44338,42191,37801,25223,16967,17032,14983,12903,12871,16935,27336,42027,42092,42092,27401,25256,23175,29416,44107,37866,31561,18982,25255,31593,31528,35721,27336,16935,16968,21129,16903,16903,14920,8743,4712,4615,4518,4583,4648,4680,4712,4745,4777,4745,2729,681,681,649,520,487,487,487,487,487,487,519,519,487,487,519,520,552,552,552,552,552,584,584,584,584,584,617,617,617,616,616,616,584,649,649,649,649,681,681,713,255},
{36247,36247,38295,27797,19540,32021,17459,23700,36182,36150,34069,38230,21490,19442,17361,31858,31827,19312,19279,23408,21456,17296,11022,19311,42292,42292,42292,42292,42292,42292,42292,42292,42260,40211,42292,27600,38066,42194,31759,29712,31857,42260,40212,44372,46419,40113,35887,33742,31661,27468,27468,29548,31596,31629,31661,31661,35757,33709,33741,35821,35821,35789,35788,33708,33708,33708,31628,27468,25355,17034,4455,4455,8648,12840,12873,8680,10728,12775,23307,42259,42290,48597,48564,48564,40113,38065,33839,38032,35887,37999,37966,33741,33708,33774,37902,31628,42225,48565,42127,40047,35886,35821,31629,23275,25420,29679,25453,25388,23275,25387,16969,12808,14856,12743,16936,14824,12743,14823,12743,12776,10663,6502,8550,19082,46452,35985,19115,21227,23340,29613,42225,14823,12711,19016,48499,52724,35885,29546,40046,37966,37966,25322,31628,33741,35920,29613,27467,35886,40048,44273,31694,29581,23274,17001,19243,44370,40111,35785,29448,21127,21224,17064,12903,14951,18983,31529,33674,23143,29449,31562,29448,31594,21063,33673,33706,21095,21095,23143,29448,31561,27400,27336,14790,16936,23307,16936,14823,14888,8743,6760,4583,2470,4551,4615,6728,4712,4745,2729,2729,2729,713,681,649,552,487,455,487,487,487,487,487,487,487,487,487,520,520,552,552,552,552,552,584,584,584,552,552,584,584,584,584,584,584,584,616,616,616,616,648,649,255},
{36247,36215,36247,32054,19572,25781,19539,23668,36150,36150,31989,38198,17362,17362,21587,33971,39986,19312,23375,29648,31924,19376,15151,23471,44405,42324,44372,44405,44405,44405,44404,44404,44372,44405,40277,36084,38066,48468,38033,29744,27598,38000,38099,35920,44306,46353,44207,39981,39981,39981,40014,40014,42094,40014,40014,40014,40014,40014,35854,37934,35886,35854,33773,31661,31661,29581,27501,23340,12841,6568,4455,4487,4455,10760,12840,10728,8647,14856,27468,33840,33905,40177,40145,48401,33774,27533,25387,31694,31694,37967,35854,33676,33644,33742,35821,33644,52659,50546,37999,38032,29646,25420,14921,19081,19049,17001,10695,8615,12776,23210,21129,8550,27501,44339,38033,31595,35723,31530,29449,23209,23209,21096,23177,14921,40179,33873,23373,44437,29711,33904,42258,14855,14823,21129,33740,48497,27434,23241,37999,42225,42225,40112,31693,25387,12775,10630,31595,31594,44173,48531,33904,29581,27467,29515,29645,46418,40112,27432,27336,23208,17032,12903,12839,12871,23208,37866,29481,35722,35754,42093,27401,18983,21063,16903,19015,14822,23175,35721,29448,27368,31593,42060,18983,12711,21194,21129,16903,16968,10791,8808,4583,2470,4551,4583,4648,4680,4745,2729,713,713,713,681,649,552,487,455,487,487,487,487,487,487,487,487,487,487,520,520,520,552,552,552,552,552,584,552,552,552,552,552,552,584,552,584,584,584,584,584,584,584,255},
{34167,36215,38295,36214,31957,29941,21620,25748,36150,36182,36182,40310,25683,25748,27828,31891,42033,25488,23472,36052,36117,19311,19279,33906,48533,46485,46452,46452,46452,46452,46419,46451,46386,48565,44471,36117,31793,42260,46485,46485,44405,38034,33906,38001,42160,46386,44240,35886,33806,31726,31759,29679,29679,29679,29679,27599,25518,23438,25551,23438,23438,21358,21358,21358,19246,19245,15084,8713,4455,4455,4487,4519,4454,8648,12840,12840,12808,18984,37835,38033,38065,40178,42225,48401,35887,27533,27468,31726,33774,35919,31693,33709,33676,31661,33741,33709,52660,50579,33806,37999,31726,21227,16969,25322,25322,21162,21097,19049,23242,23242,23242,19016,35887,59130,57017,44173,46221,33610,33675,25289,23241,23208,23241,12808,33937,36018,27566,38130,33872,31823,38097,27500,33839,31726,35984,35952,35952,31791,33872,31759,31759,31759,33839,33806,33806,31661,37999,27433,33706,46451,36018,29580,27467,27435,27500,40047,44239,33608,21063,16967,12839,12839,10726,8646,12774,21096,18983,27368,29481,39948,25288,21031,21095,14790,14822,12710,18983,16935,12710,25288,29448,44172,42060,27433,21161,21194,16903,14888,10791,8808,4583,4518,4551,4551,4616,6760,4745,2729,713,713,713,681,649,552,487,487,487,487,487,487,487,487,487,487,487,487,487,520,520,520,520,520,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,584,584,584,255},
{34167,36247,38295,38295,36117,34037,17491,23667,42423,38229,36117,34004,19409,15248,21457,21425,25456,19247,17231,23537,31923,23472,19311,38099,38033,40114,35986,40146,48467,46418,46386,44306,42194,38164,44535,36084,33906,27566,23438,21293,27632,36018,31793,42193,44273,52791,44339,27664,23504,23504,21455,21423,23471,23504,23504,21391,21391,21359,21391,21358,21326,19278,19245,19245,17165,17133,12907,6600,4455,4455,4487,4519,4454,8680,12808,21064,23177,29417,44011,44273,40178,40145,42257,48369,33806,27565,29548,29613,31726,31758,31693,35789,35756,33742,35854,39982,52724,50677,48598,52790,52757,48498,46353,44240,35822,31629,33708,31628,29547,27435,27435,27435,33872,48630,46517,42192,40111,37999,35919,38033,33904,38065,38033,38098,36017,31792,33937,38130,35985,21259,27598,35984,35985,40178,44372,42291,44404,44404,44436,44404,44436,44404,44403,42258,44338,40145,35919,23240,29481,46353,42258,29613,29548,29515,17001,29547,48432,37801,21031,14855,10726,10726,10694,8614,10630,14790,16903,16870,18983,25256,33674,31561,21063,23175,23175,18951,14790,12710,10662,10629,16902,33641,39946,44205,33707,19049,14855,14823,10759,10824,4551,4519,4551,4551,4615,4712,4745,2729,713,746,746,713,713,584,487,487,487,487,487,487,455,455,2503,455,2503,455,487,487,519,519,519,520,520,552,552,552,520,520,519,552,552,520,552,520,520,520,552,584,552,552,255},
{34167,36215,38295,38295,29909,23668,17459,17427,23667,17231,10990,10990,10958,10958,10958,10990,10958,10958,10990,13070,31923,33971,17198,31793,27567,19214,29746,42292,29713,25551,23374,21326,19246,31858,29745,23504,27632,29680,25519,17133,15117,21391,31825,33807,36050,44502,27664,27665,25584,23472,21423,21359,19310,21358,21358,19278,19278,19245,19278,19278,19278,19245,19245,19245,17165,17165,17132,15019,6568,4487,8680,10760,8648,12874,14954,19082,31563,29483,33741,38033,44339,36016,42225,48367,35886,35854,35821,42127,35919,42257,42192,40079,44142,44143,42159,42192,48564,46419,44306,44339,52791,44371,38065,33872,31824,36018,36050,40211,38130,42324,38131,40212,33937,33970,27630,38131,36050,29744,25517,38131,40211,44437,42324,44469,42356,46517,40276,15051,10825,8712,19211,40243,33969,36017,33969,31824,29744,27630,25550,23405,21259,23372,17066,23339,25419,6502,14855,31626,42093,46352,42224,29581,31628,31627,19114,23275,44272,37834,33608,23208,10726,10727,17065,15017,8613,12710,18983,18951,16870,21095,19015,31561,21095,21063,37801,39978,23176,23208,14790,23143,23175,16870,18983,27368,29513,21096,14823,14856,12807,10791,4551,4551,4551,4551,4583,6728,4745,2729,681,713,745,745,713,616,519,487,455,487,455,455,455,2503,2503,4518,4486,4486,2438,455,487,487,487,519,519,519,552,552,520,519,519,520,552,520,519,487,519,519,552,552,552,552,255},
{34167,34166,36247,38295,29941,15411,15411,17459,9170,13103,8910,8910,8910,10958,10958,10990,10958,13006,10958,13006,13006,21424,31858,29746,29713,15085,15150,27665,21359,19214,15020,15053,15053,23440,21294,17165,27697,25584,38099,19278,15085,17101,15053,15085,34035,36116,23504,27697,27664,27632,27632,27632,25519,21358,21358,21325,21293,19245,19180,19180,19148,17067,14987,14987,14954,14987,21293,19212,21293,21325,21325,23406,23438,23438,23406,23405,21293,21260,21260,35984,46451,33871,46385,50415,40047,46320,48400,48433,42192,44370,44305,38031,40047,37967,33806,29613,38097,48630,37901,40047,50743,50744,46583,46615,44470,40244,40244,42325,42389,42389,44470,42389,44502,34002,44470,23502,8809,8809,10857,29776,38163,33970,33937,29744,29744,25518,25582,12938,8712,10825,19179,12873,19244,10792,19244,14953,19244,17066,21292,21259,21291,25453,21291,27533,27500,6470,12711,39981,48400,42159,37999,29580,29612,27467,25387,29548,44240,40079,35754,37835,12807,10726,10791,8679,10662,12710,21095,29449,21095,14822,12742,18951,14822,12678,29481,27433,10662,16903,10629,25223,27336,16903,10597,18982,31561,29481,14823,14823,12775,10791,6631,4551,4551,4551,4583,4647,4744,2729,681,2729,745,778,745,616,519,487,455,455,2503,2471,2470,4486,6534,10630,8549,8517,8550,4486,2471,455,487,487,487,519,519,520,520,519,519,519,519,487,455,487,487,487,552,552,552,552,255},
{34167,36215,36215,38295,29941,13331,13299,29909,17427,17264,17199,19280,21360,21359,23440,23440,25488,21327,21359,25553,19279,17198,17199,23440,21327,8812,6764,21391,27600,19214,10892,13005,12973,15150,19213,21359,19246,15085,33971,17133,19311,27632,27632,25584,34035,40276,40179,46452,46451,48532,48532,44371,33840,29679,27567,27534,23373,23309,21228,19148,19115,17035,17002,14954,14922,17099,21293,25486,25518,27567,27599,29647,29647,25518,35953,35985,38066,40146,40146,40178,44370,40145,35951,33806,27565,25420,19179,17098,14986,12873,12873,10793,8745,8712,8712,6632,15019,50711,48564,46419,50711,52792,50744,31922,42324,38195,34067,36083,31922,31922,27663,29776,21390,23502,19244,19277,6632,8777,10857,17163,12905,17132,17098,19212,19179,19211,21292,12938,8712,6696,21292,23340,27663,21292,29744,21324,31824,23405,31824,25518,27598,29711,23372,35952,33773,10630,16904,39948,48400,40014,31726,27500,29613,29548,29582,33839,46418,50644,33740,42027,21127,8646,10726,8614,10694,12742,21063,31561,31593,27368,16935,12742,14822,12710,10629,8549,10597,10597,10597,27336,27368,23176,12710,25223,35754,33706,16935,14823,10695,10759,6631,4551,4551,4551,4583,4615,4712,2697,2729,2761,745,778,745,648,519,487,455,422,2470,6631,21193,29547,33772,35852,29546,12742,8517,8582,4486,2471,455,487,487,487,519,519,487,487,487,519,519,2503,4519,2503,2503,487,520,552,552,552,255},
{34167,36215,36247,38295,34070,15411,17491,36150,19475,21522,29844,36117,31891,27698,29779,27633,40050,31761,31858,36051,17231,8909,13038,13070,8877,17199,25520,27665,25585,19279,17198,17166,15118,12973,21294,29713,23407,21358,36051,29778,23504,25552,25552,23471,21391,29679,40146,50776,52824,50743,48630,44372,35986,31792,27599,23341,21228,19147,19115,21163,21195,21195,21162,23243,23242,29647,23373,46452,48597,48565,50645,50645,44307,33839,44404,48598,48598,44437,46485,42259,38065,31726,23307,17034,8680,6664,4649,4649,6697,6697,6697,6729,8810,8842,10922,10955,12938,29646,50710,50776,29842,31889,46583,15051,29711,34002,8745,21357,12873,19309,12937,21389,15018,21389,19244,19310,6632,8777,10825,25550,23405,27631,23438,27631,27598,25550,27663,19245,4584,4584,29743,19179,38163,19179,38163,23372,40243,27598,38131,33904,38098,38130,38097,40178,40144,38032,31726,40013,50447,39981,31693,25355,29581,42324,40244,42324,46354,50644,35919,39915,48365,25353,10726,8646,6565,8614,14854,29481,33673,29480,33706,25321,12710,10662,10662,10629,10630,10662,8549,18950,29448,23143,12710,27303,33640,33674,19015,14791,12743,10727,8711,4583,4551,4551,4551,4583,4680,4745,2729,2761,745,778,778,616,487,2503,4583,8679,19113,33772,40046,40078,40078,42191,44239,33771,12710,10597,10662,4486,422,455,455,487,487,519,487,487,487,519,519,2503,4551,2503,2503,487,520,552,552,552,255},
{34167,36215,36247,38295,36182,19540,19539,29909,15346,23700,19507,34037,17361,19409,17361,23537,42131,31761,29746,31826,17231,13103,15183,13103,15118,33841,29713,21392,21425,19376,19343,23440,23537,19311,23439,29745,23439,25584,31825,29778,21359,21391,21391,23439,23439,29679,46353,42225,40113,40113,40112,40080,40048,38032,38032,40048,40048,37999,35854,38000,40080,38000,38000,38000,33807,42324,29680,50710,52791,50710,50677,38065,37967,42160,31727,25453,29711,23405,31727,42259,40179,40178,33872,13067,17229,21357,23470,23438,23438,21357,17164,13003,13003,15083,17196,19244,17034,25453,40178,48663,25584,27631,44470,17132,27598,36083,19244,29744,19277,31889,21324,33970,17132,36050,21292,36083,4552,6729,12938,33938,21325,33970,25486,33905,31760,33937,33938,31889,25518,27598,38130,38098,40243,38098,38162,36017,36050,33872,35984,31726,33871,27533,29710,25387,14953,6469,8615,35854,48334,33707,35886,25453,29548,42356,33970,40211,48532,52725,40080,42028,46221,37932,14919,10726,8646,10694,12742,31529,31561,27368,33641,21127,10630,10630,12710,12710,10630,10662,10662,10629,12677,31528,29416,27303,29448,37834,25288,12710,14823,10727,8711,6631,4583,4551,6599,6631,6696,4744,4777,2761,2793,2826,6889,8808,14951,21160,27401,31594,33707,35820,35852,35885,35885,37965,42158,42158,21128,8485,10629,6534,2406,422,455,455,455,487,487,487,487,487,519,487,2503,2503,2535,2535,552,552,552,552,255},
{34167,36215,36215,38295,31989,25748,19507,21587,17427,32021,19474,34069,21522,23602,23570,23504,40018,25553,23505,33971,19311,13038,15151,13006,17198,33906,33939,19344,13037,25552,25552,33939,29778,23472,23407,23406,25519,25519,29777,25520,19246,19246,19278,17198,17165,23406,50678,54904,48500,40146,38065,38033,38033,40081,40113,40145,40145,40113,38033,40113,42193,42193,42193,42193,42258,42358,36051,46452,31727,29711,33872,21195,42226,42225,31759,31759,29679,27534,33904,38065,35985,40211,27566,19277,23341,23308,25421,21227,21227,21195,19082,17067,14986,17034,17034,19082,21227,33840,42324,46550,38196,38164,40309,36083,36018,44437,17099,38164,15084,38196,21260,40276,23438,40276,29711,40276,25583,27663,33937,40244,36082,38195,36050,38131,33937,33969,31791,33904,29711,31791,25485,27565,25484,25485,27565,23372,27598,25420,31791,29580,33871,29645,33904,31693,12905,8647,8680,33773,31659,21160,31726,29646,27500,35854,33872,33775,42193,48498,44338,44205,48366,35819,21224,10726,10726,14855,10630,25256,33641,25256,33674,25256,18983,10630,10630,10662,8582,8581,8581,12709,12709,31528,39914,37833,33640,33673,21095,12710,14823,12775,8679,6663,6631,6599,6599,6631,6695,8808,12936,19177,23305,27433,29481,27368,27368,29449,27368,29449,31561,33674,33739,33772,33772,33740,37965,40078,25353,10597,8549,8549,2373,390,422,422,455,455,455,455,487,487,487,487,487,487,487,520,2568,2600,2600,552,255},
{34167,36215,36215,38295,32022,21620,27860,27829,15346,29941,23636,29909,27796,29844,27698,29681,40050,33906,31858,36019,21392,13070,15183,13070,8844,19279,33906,25585,21359,23407,21326,40245,35987,31793,27632,27567,25519,23471,36084,25552,15052,19278,21359,23439,21391,25519,33938,44405,48597,42226,42259,44339,44306,44306,44338,44339,44371,44371,46419,44338,44306,44338,44306,44306,44339,40245,33905,42258,38032,40145,42226,31694,40145,33839,31727,29646,31759,31695,40178,33872,35921,38033,31760,27566,19049,23275,23275,23209,23242,23241,23177,23241,25354,23241,29515,29482,25387,38033,57050,52856,44470,40244,42357,42390,42389,42389,36050,38196,36050,36115,36050,36050,33970,33969,27664,27663,27566,25680,21357,29711,21259,27663,19179,31791,23339,31791,25420,31792,29613,33904,27565,36017,29678,38098,33839,38098,31791,38129,33903,38097,33904,33871,33871,29645,14953,6599,6600,29612,27465,21192,25418,23241,27434,31595,31628,38098,40112,48498,48564,33739,37834,25320,33739,14919,10726,12774,12742,14822,31561,35787,27400,33674,35786,21128,12710,10630,10629,8581,8549,21030,29416,31528,33674,33641,39946,33673,21127,12710,14791,12743,10727,8711,6631,6598,6598,6599,8679,12775,14822,14855,14822,27368,33673,35754,33641,29481,27401,27401,27368,31594,33707,35819,33707,33739,35820,37965,31626,12709,8484,8549,4389,325,390,390,422,454,454,454,455,487,487,487,487,487,487,487,519,520,520,2568,255},
{32119,34167,36215,38295,29941,27861,23667,23700,13266,23668,23636,23636,25716,27796,21457,29746,35889,42195,31825,29778,36019,36019,27633,15118,10957,10925,25520,31891,29778,31826,31858,42325,31761,33873,35986,40114,25519,23439,27632,27665,19278,31858,31858,31890,33906,33938,31858,40244,50678,42259,44339,42258,42258,42225,42225,40178,40146,38065,38032,35920,35920,33839,31727,29646,31727,40245,40211,48565,35952,35985,38066,33904,33807,29678,38098,44404,44372,40146,42324,31792,40146,40178,31727,31660,31593,33674,33708,35755,31595,27402,29515,25387,25388,25355,25420,21194,38098,52823,54937,52857,52857,50744,25583,21422,21389,33969,23438,27598,23372,23437,21324,27566,23405,27630,23373,21324,29678,29743,31792,31824,35952,31856,35985,33936,38097,36017,36017,36017,35984,36017,29711,33904,27597,29743,29678,27565,29678,25452,31758,25420,29710,23306,29646,23306,14985,6567,6567,33773,46286,29546,29611,29580,29580,31563,31596,38131,42258,42160,42226,19144,29481,23143,29417,25320,8613,8613,10694,10662,18983,25288,29481,25288,33673,37834,27369,19015,19015,10630,8581,10629,21030,35688,33640,37834,37866,33673,21095,12678,12710,12743,10694,8711,6663,6598,8646,12774,21127,14855,12775,12774,12742,16935,21063,29481,35754,35786,31593,29513,27401,31561,31561,33674,33739,31626,31659,35820,33772,21095,14790,8517,6437,2341,357,390,390,422,422,422,422,455,487,487,487,487,487,487,487,487,519,520,255},
{32119,36215,36215,38295,27861,29941,17427,13331,13266,19539,27828,17395,25715,36085,21489,17361,33810,35987,31826,27698,23504,19279,25520,17198,17231,15118,27600,27730,27665,46551,44438,46421,35986,40179,40147,31793,19213,25486,33938,33970,23439,31858,29778,31858,29777,29778,31825,36051,46518,38066,25518,25486,25518,23373,23405,23373,23373,21292,19179,21227,23373,23340,21228,21195,25421,40277,40244,48565,33840,38065,40146,42259,35920,33839,29646,25485,25485,27533,27566,36017,42291,44372,35887,33839,21195,23308,25388,23243,21195,23275,23275,23308,21228,21195,23308,21195,29581,50678,54937,48663,50743,50744,17099,19309,15083,33969,36018,31791,38098,29743,38163,31824,40243,31856,36018,23437,38130,31824,33937,31824,31791,29743,25517,31791,25452,31824,23372,27631,23372,29679,23372,27598,23371,23437,27565,23372,29646,25420,31758,25388,29710,23307,29646,23307,14985,4486,4487,33741,52559,27497,33740,33871,27500,31563,31563,33839,40113,48498,42193,21224,33673,29448,31464,37801,14854,8614,8581,10662,10662,16902,25288,23176,29448,33641,29448,27368,25256,21128,12742,10630,16838,31496,35688,31528,33641,31561,14790,12710,12742,12743,10694,8711,8679,8646,35787,44107,52493,42060,16935,10662,10694,16935,10661,14790,25288,35754,33674,31561,31561,25320,29481,33674,33706,33706,31626,29546,33739,27433,21128,10597,6437,2341,325,357,390,390,390,422,422,422,455,455,487,487,455,455,487,487,487,487,255},
{32087,36215,36215,40375,32021,25780,25748,17459,13266,21522,29876,21522,27795,25650,13200,8974,17231,17263,17296,19344,25585,23440,27600,15118,13038,17263,23504,29778,27665,44470,40245,42292,33906,33906,31793,23439,25552,27632,38099,36051,23407,25552,21391,29745,31793,31825,33906,40212,46485,38033,23340,25421,25486,25453,27534,29613,29614,29613,31661,31694,33774,33806,35854,35854,40113,36051,44405,48565,33840,35953,33904,29678,31727,25453,31791,35985,35920,38000,35887,31759,35953,29647,25388,23340,21195,21162,17002,12776,19049,25322,21097,17001,14888,16969,23275,17001,27501,54936,54904,44405,48630,50744,17131,21390,17196,36050,34002,29743,31824,27663,27631,27630,25518,27630,23405,21325,21324,29711,21292,29711,21259,27663,19179,29711,21259,31824,21291,29711,23372,29711,25453,27631,25420,23405,27565,23372,29678,23307,31758,23307,29710,23339,31791,25452,23372,23340,25453,35853,52559,29545,33740,44339,27532,29483,27435,25453,37967,46419,48564,27531,35785,31593,29448,29416,23143,14887,10758,14855,10662,10629,14790,18951,31594,21127,16870,23143,27336,29448,16902,23175,25288,18982,23142,31528,33641,25288,14790,12710,12710,12743,12743,14920,12807,21095,39914,56685,44074,37801,44107,35787,21127,14854,12774,12710,19015,25288,35819,33674,29448,19015,16935,29513,33707,33707,33739,31659,25353,19047,16935,6437,6404,4356,260,325,357,358,390,390,390,422,422,455,455,455,455,455,455,455,487,487,255},
{32086,34167,36214,40375,32022,19572,29909,17395,11185,21490,31892,23570,17296,4781,2733,6829,8877,6829,6862,13071,29779,25520,23472,15118,10892,8844,21327,27698,23472,25617,17198,15085,15053,12973,12940,8779,10859,15085,27697,44373,44340,46453,48566,48598,50646,50678,52759,50678,40211,42226,40113,40113,40113,40145,42225,42225,42226,42226,42225,42225,44273,44305,44306,44306,42226,40212,44405,50646,25453,31824,31759,25421,35920,27566,25421,25452,25420,25420,23275,21195,21194,21162,21129,19049,19017,16936,16936,16936,19017,21097,14824,14824,16904,16969,21130,21130,31759,56984,54936,50776,52857,50744,17132,13036,15083,36082,21389,23437,23373,23437,23405,25485,23405,27598,23373,21357,21325,29711,23340,29743,21260,31791,19179,29711,19179,31824,21259,31791,23340,31759,23339,31792,27533,31791,31758,35984,31823,38065,33904,38097,33904,36017,31823,29743,27630,29678,25485,40046,52592,35885,29579,40179,31694,29547,27467,25485,35887,48499,48532,21225,29577,14951,25320,18950,33641,25384,12935,12871,10694,10662,14790,14758,16903,25256,33641,29448,23143,25255,29416,29480,31560,29480,29416,33640,31528,29480,19015,12678,12710,12742,12710,25321,37900,48399,50413,56686,44173,41962,39881,48365,44172,40012,12774,16935,12742,18983,33641,35786,35754,29513,14854,23208,33707,33739,33674,27401,19015,16902,10629,6404,6404,6404,2276,293,325,357,358,390,390,390,422,422,422,455,455,455,455,455,455,455,255},
{30038,34167,36214,40375,36150,11251,11251,19475,17395,17394,29908,23570,19344,11023,11022,13071,13038,13070,15119,19311,27665,23439,23472,21327,21327,23375,23407,27730,23472,23504,23407,23407,23439,25519,27600,27600,27632,27665,31858,50678,54872,50711,48630,52792,50678,44405,48598,50711,46550,48533,44371,44371,44339,44339,44371,44371,44371,44338,44306,44306,44306,44306,42257,42225,35888,42324,52759,52758,31759,29711,27599,27534,27598,27534,14921,14954,14922,14922,14921,12841,29614,42128,37966,35789,31596,27403,29548,29516,27436,27468,27469,29646,27533,27566,23373,19082,35920,54904,52856,50744,52824,50744,17132,10890,15083,36049,23470,25517,23438,25485,23437,25517,21357,27598,21325,23470,19244,29711,23372,29743,25485,33872,29646,33904,31791,36049,35985,38098,36017,36049,33904,33969,29743,27663,23469,21389,19276,17163,12938,12905,10792,8777,6631,6664,8744,8712,10759,23305,33707,40079,40079,40178,31694,29547,29482,31693,31726,44305,48466,23305,33737,19176,21224,23175,29416,42059,21224,25417,21192,8646,12742,12710,14790,16870,31561,37834,31529,23143,29416,29448,31528,27368,23143,29448,31528,29416,19015,12710,12678,12710,12678,39981,54705,56851,58931,58865,56753,46254,31430,39816,50413,54704,31626,14822,14855,14822,21095,25321,31561,35786,29481,16902,19015,21128,31594,31561,29449,25320,21095,14790,8517,6404,4324,228,293,325,357,358,390,390,390,422,422,455,455,455,423,422,423,455,255},
{30038,34135,36214,40343,38230,7155,9235,17459,9170,15282,25683,25618,23472,13103,13103,13071,13071,15151,19279,21326,21294,21294,21327,21326,21294,21326,31761,25650,25617,35986,35986,38034,38067,38067,38067,38099,36019,31793,31825,48436,40147,36051,36019,38099,42259,31760,35986,44437,44502,52791,38065,38000,38032,38032,38032,35920,33839,35919,33806,29614,27565,27533,27501,27500,29678,50744,50743,52759,23373,17067,19148,21228,23308,29679,14921,14954,14922,14954,14954,14921,33742,48499,40146,31759,31727,35920,35921,33775,31694,31727,33840,33872,29647,31792,27533,23275,33807,50678,52824,44405,48663,50711,15019,8842,10890,31856,27598,25518,27631,27566,31824,27663,33937,31824,38131,31857,38163,33969,38163,31856,34002,27695,29776,23502,23502,19276,17196,15051,12970,8744,10825,8744,6761,4551,6632,4551,6697,6664,6632,6632,6664,6696,6696,6664,8777,8744,10760,25385,33738,42126,46352,44240,31693,27467,23241,27468,35887,48499,50645,29677,39946,23369,17063,25320,23208,27400,25288,39914,46220,12838,12742,14822,12710,12710,18950,31593,39979,35786,31529,35721,31528,35721,33641,27367,29448,29481,23176,12710,10630,12678,14791,25289,40044,52526,54671,58865,58832,56752,44042,46121,35656,44106,48398,19047,14822,14822,12742,14822,10629,25255,33641,27368,21095,19015,29481,35786,33674,29514,21128,16902,12677,8517,8485,4356,2373,325,325,325,357,358,390,390,422,422,422,422,422,422,422,422,255},
{32086,34135,34166,38295,36214,11251,23700,15379,7090,17362,25683,27698,15151,17264,13135,15183,17231,19279,19279,17101,17133,19246,19214,19214,19246,23439,29713,25682,25617,35986,35954,35986,38067,38067,38067,36019,31793,27470,36018,46258,44372,44438,44438,36019,38066,29712,40212,42357,48663,46387,27533,29647,25453,29581,29613,23373,27534,27631,25421,23406,31824,31792,27534,25421,31792,48663,52792,54871,48565,48565,48598,50710,52790,38065,19114,23340,21260,23308,19147,29646,42193,46419,44372,40113,38033,40113,42226,42193,42226,42194,42259,42226,40081,37871,33742,37967,33806,42259,46517,38033,50711,48663,33938,33970,38196,36082,36115,31921,34002,29776,29776,23502,23470,19309,19309,17293,15083,13067,10857,10889,8777,8809,8744,6729,6729,8777,8777,8809,8777,6599,8777,8777,8777,6664,6697,6631,6729,8712,8680,6632,6729,6729,6599,6631,8744,8712,10727,37933,48431,40045,46352,33805,27468,27532,17034,25453,38033,46386,50612,29710,27464,15048,15080,14951,16967,19047,14887,25287,54541,35818,10726,14822,14790,14822,16838,27368,31561,37899,39979,35753,37834,31561,35754,31561,31528,31561,33642,23208,10630,12678,14790,14791,21160,42058,56719,58964,58832,56685,56653,48332,50381,48267,52493,33706,14822,14822,12710,14822,10662,14822,23207,16870,29481,25320,25256,31594,33674,33674,25288,16902,16902,12742,10597,8517,6599,358,325,325,325,357,358,390,390,390,422,422,422,422,390,390,255},
{32086,34134,34166,38295,34102,9203,21620,17459,13234,15249,15281,19409,17296,19376,21457,23537,25585,23440,23407,21294,21294,21327,23407,23407,25487,21359,27633,31923,23537,35954,35986,35986,38067,38067,38067,35987,31761,35856,38066,35920,44340,46518,44405,27599,25487,31793,48566,46486,50743,52759,31792,38131,40244,35920,31726,33905,40211,33937,33872,31824,40243,40146,40112,38000,44339,44405,52791,54871,38033,35920,31727,42226,50645,29646,17002,17034,14921,14921,14954,29711,37968,35887,46420,44339,42226,44339,44339,44307,46419,42194,35920,35953,33872,46354,29516,33807,31661,46420,50711,38098,44437,23535,17197,17229,15116,13067,8842,8907,8777,8809,6664,6697,6632,6697,6729,8842,8777,8842,8777,8809,8777,8809,8777,8809,8777,8809,8809,8777,8777,6600,8745,8745,6697,6599,6632,4519,4616,6632,6599,6599,8777,8809,10824,14986,19179,23372,27501,42094,40045,23240,40046,23307,25355,33774,25617,21260,25583,44338,52757,33870,17128,17128,15080,17096,21127,16935,14886,17031,33673,52493,25352,10661,12710,16902,14790,29448,27368,29449,37867,33673,33641,27368,29448,29448,33609,29448,27368,21128,12710,12678,12678,12710,12775,29480,52559,58996,58866,52491,52459,56685,50379,52459,54507,54573,25255,12709,12710,16935,14855,14822,18983,12710,16935,21128,19047,23208,27433,31562,25288,14822,14855,12709,10597,8517,6502,4454,2405,325,325,325,357,358,358,390,422,2471,422,2471,2470,2470,255},
{32086,32086,34166,38295,38262,9235,9235,21555,23603,13169,9040,4944,6992,15249,27731,29811,27666,31793,33841,29648,25455,25487,29680,31761,31793,33841,31826,25617,31825,35986,38066,38067,38067,38067,38067,35987,35922,27567,38066,38033,44340,40179,35986,33841,33808,42259,48533,44340,48565,52791,35985,38097,42323,44338,42225,42258,44338,42258,42226,42258,40112,38032,40145,40080,37999,44339,54904,54871,44307,44339,44371,46420,44372,29614,19147,25420,25388,27468,29613,33872,31661,31596,33806,35887,35887,33807,35855,38000,42193,33774,31661,27501,35888,48598,48533,38000,38000,42258,46484,33905,36018,8875,6697,8810,8842,8842,8809,8874,8809,8874,6729,6729,6696,8777,8777,10857,8745,8842,8745,8777,8745,8745,6696,6697,6664,6664,8744,6631,8744,6599,10824,12905,15083,17066,21292,23373,25518,29711,29743,33937,33937,33937,33937,35985,31791,27598,23438,35918,50512,40078,46353,27500,25355,31693,19408,21260,29485,42129,50612,35983,21289,17096,15015,23336,23207,16870,16902,12839,10758,35753,50412,12806,10662,19015,16902,25223,31529,23143,29449,31593,35786,31561,31561,29448,31528,27368,18982,14790,10630,10565,12645,12678,10630,14822,42059,61012,58832,50411,39945,50412,56587,56586,58635,56554,48266,14822,10662,10662,12710,10629,23175,19015,8549,8517,8549,10629,25288,27401,27369,23208,23176,21095,16903,8517,4356,4389,4486,325,293,325,357,357,358,2438,2470,2470,2438,2438,2438,4519,255},
{30006,32086,34134,38294,36182,13363,17492,21588,21522,13201,5009,913,13233,19409,31956,36052,25618,27698,27633,27633,29713,33906,38035,31761,40179,40147,33906,25617,33906,38066,38067,38067,38067,38067,38067,35986,33906,27600,42292,40179,42259,40147,40179,38033,33808,46420,50613,48565,50645,46452,40146,44404,38065,35919,35919,37967,35887,35951,35887,35919,35951,37999,37999,35886,37999,44306,56952,50645,33872,35952,33872,27566,23308,29678,42226,42193,42226,42225,42193,42291,40112,42095,46387,46419,35952,42259,44306,42193,44241,44305,42258,35985,50710,50678,54872,27501,42324,46518,46517,46452,35986,10955,6729,8810,8842,8842,8777,8810,6696,8777,6664,6729,6599,6696,6664,8809,8680,8777,8745,10858,12905,14986,17131,19244,23437,23470,29711,29744,33937,33937,36017,36050,36017,36017,33936,33872,31823,27630,31791,25485,29711,12905,21292,23339,17098,4486,4519,29613,52592,35885,35885,33806,25420,29580,27435,29580,35627,46289,48467,35984,23369,19208,12935,19111,25287,23143,16935,12903,12871,19047,52460,33705,10726,10662,23176,21063,33641,37866,29481,19015,31528,33673,31561,27368,27336,31528,23175,18983,8485,8485,10565,10597,10630,8549,29513,58930,58831,50378,35752,40010,52394,56554,56619,54441,54409,31463,10597,10629,18982,37867,35852,12774,10662,10630,10630,8549,16870,27368,27369,25288,27368,25288,23208,12710,6404,4389,4389,2341,293,325,325,325,325,2373,6501,8550,6501,6469,6469,6502,255},
{30006,32086,34134,38295,34102,13331,23700,21587,15313,17362,11250,13330,25682,27698,17393,34004,29778,29778,23537,19279,19312,21424,40212,40180,35986,44373,36019,31923,33906,38066,38067,38067,38067,38067,38035,35954,31761,27535,33873,29712,40114,40114,46485,48532,44306,50678,48566,44372,54839,44306,38032,40145,35984,42226,35919,33806,42226,40177,38032,40178,40210,35951,40145,42291,44436,42291,48597,40146,21293,19212,21260,17067,25388,31726,33840,29679,29679,29614,27534,27566,38000,50580,50678,44372,27566,42324,44339,40113,42193,44273,42258,40210,52791,50711,54904,38065,40211,44371,44372,40146,40243,8875,4584,6697,6696,8809,8712,8809,8745,12971,12938,15083,19212,21357,25550,27663,31824,31857,36050,36050,36050,36050,33969,33969,31824,33969,27630,31824,23404,29711,21291,27598,23339,27565,23371,25453,25484,23372,27597,21291,29678,12873,23340,23307,17130,6567,4519,27500,40013,19112,16999,21160,21194,25420,31595,29548,19114,46418,50579,38097,19176,17095,17096,16967,25287,27335,14854,10823,14983,12871,23271,44106,29545,14854,14854,21063,25255,35786,33673,27368,31561,35753,27368,31561,23175,29416,23111,29416,29481,18983,21064,25257,19015,10630,14822,54606,58831,46250,33639,27496,42025,56522,58635,56489,54376,48136,39783,39914,23207,31593,25353,10629,10630,12743,10629,8581,10629,10597,12710,12709,23208,27401,27401,25321,21128,12742,6469,4357,2308,2341,325,2373,10727,16935,23273,27434,23273,23241,19048,14822,255},
{30006,30006,32086,38263,29941,13331,25748,17427,13266,19474,25715,29908,31924,27698,13200,34004,38132,27666,23473,19344,25585,21392,25553,27632,38066,42227,40212,36052,33906,35986,38034,38034,38034,38034,35986,35954,33841,27535,23374,21261,27567,40146,46420,44339,44371,48598,46452,38000,59064,46386,44273,35952,33937,44469,29679,31759,44437,38097,38097,46517,40178,36016,44404,46582,46517,38098,48597,38066,21260,23340,21260,15019,31694,33774,33808,33872,35953,35920,33840,33840,33840,44306,42259,35953,35920,31727,31726,29614,29614,29581,19082,19114,42291,50743,50678,29646,38098,52791,52824,48598,46517,21390,23438,29712,31857,31889,31889,34002,34002,36050,34002,34002,33937,31889,29776,31856,29678,29711,23437,29678,23340,27662,21259,27598,19179,31791,21227,29743,19179,27630,21227,29678,23339,27566,23372,25485,25485,23404,29645,25420,29678,19114,25453,31693,17130,8680,6632,25420,37932,25417,25384,33772,19147,19147,27467,31661,27500,48499,52725,40209,25417,19176,27464,27367,21062,16966,12806,10790,10758,12903,10790,33673,37898,31593,12710,19015,16870,21063,33641,31593,33673,35721,25255,21062,29480,27368,14789,21063,29449,27433,29514,33675,33740,25321,18983,46186,58765,48363,29446,25351,44105,56554,56554,56489,54376,52329,52297,46089,35721,16869,12709,8549,8549,10662,10597,8549,8549,10629,16935,16935,21128,29546,29514,27401,23208,16935,6437,4357,2341,2309,2341,17000,25387,31660,31692,29612,29612,29612,27499,27499,255},
{30006,32054,34134,36215,27893,11283,17459,19507,17427,19507,25715,29876,23570,27731,19441,40245,46453,31794,27633,23504,27698,25553,19311,23439,29713,35986,29745,25617,33906,38034,38034,38034,38034,38034,35986,33874,31793,29680,25487,23406,27567,40179,40146,35953,44339,50646,50646,48532,54838,40145,40145,33839,44469,35985,33937,40243,38163,33871,33839,38098,33806,33774,38065,38065,38032,35822,46484,44372,38065,40144,25485,14987,31662,42193,31694,27566,27566,29646,31694,31727,31759,31759,33807,31727,27534,23373,23373,25421,27501,21194,19114,17001,27533,50711,46452,33872,38098,52791,54904,52857,54937,52856,31825,23535,23503,31888,27664,23437,27598,23372,23470,23372,25485,23372,23405,25517,25453,25517,21325,27598,23340,27662,21260,27630,21259,31759,21227,29743,21259,29711,23307,31791,27532,33872,29645,36017,33871,40145,35919,40177,35951,29678,27598,40112,21259,6567,6567,23307,42093,29610,25288,42257,25486,21227,27434,31661,23275,44306,50644,42225,23369,23336,29512,27335,23142,21095,14854,12871,10758,10790,12871,14886,44139,54639,27401,12774,14790,18951,23175,27368,33641,31561,35786,33673,25256,21031,18982,25255,25256,23143,33674,31594,29482,23241,23208,46122,56653,54572,44072,39847,54474,56522,56522,56488,52231,54409,48137,35624,29350,31495,25255,16870,14790,8549,10629,10662,12710,19015,25353,27401,31594,33739,29546,23241,16935,10630,8517,8549,8582,6469,16936,29612,29579,29547,31660,27499,25354,25354,25354,25354,255},
{30038,32054,32086,36214,32022,19572,15411,21620,19507,19507,21555,36117,27731,29811,23570,38197,42293,29714,31794,27633,29778,29778,27665,23440,25552,31858,25520,27632,35954,35986,33873,31793,31761,29712,29680,27600,27568,25519,27567,25519,33905,40146,40114,40114,44339,46453,46452,50644,44306,37967,35919,33807,38033,33774,33806,33774,33741,33741,37934,37870,33708,33708,35756,37869,37966,31595,44273,40179,35952,31726,25485,21260,31661,35887,33840,31760,29647,27566,29614,27566,25421,25453,27501,23340,23308,21228,23308,27501,27533,25420,19146,29613,29613,33807,46420,35920,44405,46485,54904,46583,50711,52857,21325,6729,12938,27663,27631,21324,27631,21292,23502,23372,25485,21324,23437,25485,25453,25517,23405,27598,27565,29711,29679,31759,33872,33904,35984,33937,38064,35984,31791,36017,38064,38097,33871,33937,35951,31758,38031,27533,36016,17034,25421,27467,23372,10662,8582,25322,42093,31691,23207,42291,33872,29581,27434,29548,14888,42193,52757,42258,27529,27496,29480,25287,27367,29447,18982,12871,12935,12870,15015,14951,19079,44172,52591,44237,25321,14790,18982,31528,31529,29481,29481,35722,27368,21063,23143,25223,18918,23143,31560,33609,29448,21063,21063,46154,56653,56686,50411,48265,56587,56554,56522,56521,41863,29414,48235,46220,29384,25190,27303,29448,29448,21095,12742,12742,12774,14822,14790,16870,23175,25288,25288,23208,27401,29514,29546,31659,33740,31659,33740,33804,33772,33772,33805,35885,33837,33773,33805,33772,255},
{32054,32054,32086,27893,34134,27861,17459,19539,15346,19507,23635,36150,29843,27763,27730,31923,48566,31826,25552,25552,33938,33939,33906,29713,29745,27665,27600,33874,31793,31793,31793,31761,31761,31761,31761,29712,29680,29680,33873,27632,44307,44339,44339,38099,33840,38000,44340,46419,44240,44208,33709,40015,33709,37869,37902,35821,37902,37901,40046,42095,40080,33805,37934,33774,33806,46354,44305,42160,37999,37966,35854,35821,33741,31661,33839,35888,35919,38000,38000,40048,40047,37967,35887,33741,27436,21162,23242,29581,14889,19081,25355,27500,19178,12905,23340,33774,29712,42323,54904,44438,44405,52857,23438,6729,13035,27663,27664,23372,29711,23405,29744,27566,33872,27598,36017,31823,38130,31824,40210,35984,40243,36049,36050,33904,33937,33936,29711,33937,27565,33904,21259,29646,27532,29711,25484,27566,31693,25453,33839,29613,33903,27533,29678,35952,33871,40112,38032,35853,44141,33739,23207,44338,31726,29581,27402,31660,21227,38032,52758,40209,25384,31657,33608,25255,27335,27335,16902,10758,15015,19143,19144,17031,17063,19079,46285,58930,50545,16902,25256,31561,27368,33673,29513,25255,29481,31561,31593,29449,27336,27336,27303,31528,25223,18950,18983,44073,52491,54638,54573,56620,56620,54539,56522,52393,50314,23174,31559,52527,52592,46221,35787,23143,23143,19015,12774,12774,16934,25320,35787,27465,16966,16902,18982,19014,16902,14822,21127,21160,27401,31561,31561,31594,31659,29578,27433,27466,21160,16935,21160,23208,255},
{30006,32054,30006,15476,23765,17459,23700,25716,21555,17427,19507,21587,27796,29779,27698,25618,38132,38132,38067,29713,27633,29778,31826,31826,23440,23472,25487,31760,33841,31793,31793,29713,29680,29680,23407,23374,21326,27632,35954,31760,48532,48467,46387,35986,35920,40080,46420,50646,44273,42226,42227,42291,40146,31694,29614,35985,33937,25486,27501,33872,33970,23405,25420,21260,27501,48499,35919,42193,40080,40014,37934,37933,37901,37901,40046,40014,39981,39948,37900,37836,35756,35755,33675,31563,31563,29451,21129,19049,14856,14921,21194,16969,23339,14921,17066,27533,19114,31726,54904,50744,50743,52856,23438,15083,17195,29743,40244,36017,40211,36017,38163,36017,36050,31824,36017,33904,31824,31791,27630,31823,23405,33936,19179,31823,21259,31856,21259,33872,25420,36017,27533,33904,33839,38130,35952,40210,40145,38130,40210,38097,42291,40178,38097,33839,42258,14888,14823,33610,42093,40013,29481,40145,29613,29613,31595,31660,33773,38032,50710,31757,21256,27464,31624,29415,27367,33608,27303,19046,15016,14951,23304,19112,19143,21223,29545,54704,56850,27433,16902,23208,18983,27401,25288,33642,35786,27401,25320,16902,18982,21095,18950,29448,25288,16870,16870,50380,54507,54606,54606,56654,56654,54573,54474,50313,50379,35753,29479,50347,52559,50446,52592,40012,23239,25320,14854,14918,29545,35786,44140,42027,33673,33673,37866,46220,35786,29512,18982,23175,27368,48334,37802,27368,21127,12742,10629,10694,12742,8549,6436,23110,255},
{30006,30006,27926,9300,17524,19540,25748,34005,31956,21588,19507,19474,27828,34004,29779,21457,25585,40212,44405,29778,33906,29778,25585,31858,25488,23439,27600,31728,31728,29615,25519,23374,21294,21326,21294,21294,21294,33873,42228,25422,33840,48532,48467,44372,40114,40145,42259,50645,33807,33905,36115,34002,27599,21260,21260,19180,25551,21260,21227,29679,29744,23340,25388,21228,27566,46451,42193,46354,44273,42160,42159,42127,42127,42159,42159,40014,40014,40014,37901,35821,35789,31628,29515,27435,27403,19017,12776,23209,19049,12808,14920,12808,21227,14889,12808,31661,29580,23372,54904,46583,42356,50776,25518,25518,21421,31855,31889,27630,29744,25485,29679,25485,27599,23404,27598,27565,27598,27598,29678,29711,31759,33904,33904,36016,38130,36050,40210,38130,33937,27663,36050,33937,40211,27631,40243,23405,40243,19211,40211,21227,42291,29646,31856,25387,33871,10630,12710,31562,42093,52593,50414,46418,31726,27500,27434,31660,33774,44305,38097,23337,21289,19208,23336,23271,19047,23239,27335,23239,14983,14983,19111,29545,29545,27432,23271,46252,58930,50511,33706,16903,10662,12742,12774,19015,31626,21095,12709,12709,10597,12677,14790,16870,21031,16870,18982,50380,56653,54540,54573,54606,56653,54572,54474,54442,44073,44106,39945,52460,52493,52592,54705,54705,48399,46351,42157,35754,46253,46188,48333,44108,48432,48366,48332,52592,46286,48398,46286,50479,29482,50479,42092,35786,37899,18982,12677,10629,14854,12709,16903,42094,255},
{25878,30006,19669,7219,23765,23668,23668,27828,17394,13266,19507,23603,31892,29778,29713,27601,29681,35987,31891,33971,42325,33906,29746,31794,33873,27600,27567,27633,23472,27632,31793,31793,31793,31793,31793,31761,29680,29745,42259,42194,46388,44307,38098,42226,42194,40146,44372,48565,31662,27599,25583,21357,21260,21260,21228,19147,19212,21227,23308,27533,23340,27501,27501,23340,33807,46419,50645,42193,35920,31758,38097,31726,33871,35984,33936,31661,31628,35788,33708,33676,33676,31595,31595,31595,31628,27435,19049,23210,25322,14888,14921,10760,8647,14921,19114,25387,25419,15018,50710,40244,29777,50744,23438,17164,19309,29743,29776,23372,31857,27565,36017,29711,38098,33904,40211,36050,38163,31856,33970,40243,33969,42324,29711,42324,25518,38163,23405,36050,6631,6664,21292,27631,29711,23437,31792,23372,31824,21291,29711,19179,29678,21227,17131,14953,25420,12710,12678,29417,44141,50512,48399,46353,37999,29580,29482,29548,33773,48499,35984,19176,17128,17096,14983,14951,12774,19047,16902,10790,17064,17064,19144,27400,37833,39978,27464,39913,56686,56752,56818,44205,23207,21127,19112,10694,8549,12710,12709,10629,12710,18950,14758,12645,16837,16805,18982,46252,54605,50346,52493,54574,54606,54540,54474,54474,48233,46186,39880,52460,50380,52493,56753,54672,52592,54738,50512,52527,44172,46317,44205,48333,44172,46220,46219,50478,48431,52624,52690,40077,31562,52560,48431,42026,52559,48366,39947,27336,27368,35689,44140,52725,255},
{25845,27926,13460,7252,19540,15379,17459,21587,21588,13266,17426,21555,25683,31924,29779,23505,27601,29746,21424,19344,33938,31793,29713,27666,35954,29680,31761,31793,17231,25552,33873,25519,23439,23407,23406,21326,19246,17165,31825,40179,38099,33905,23374,35856,41999,35791,33873,50645,35888,25454,19212,21260,27534,27534,27502,21260,23373,21260,25420,29581,25388,29613,29614,33905,38000,52725,48499,37934,35822,33741,33709,37901,40014,40046,42094,42094,42094,42126,42094,42094,37933,35821,35789,33708,29548,19049,12776,25355,23242,17001,16969,8647,8680,8680,12873,25387,17066,10793,38098,50743,46518,48663,38098,36050,42324,44436,40243,40243,36082,40243,33937,38195,29744,40243,23470,38163,21292,10858,8744,31889,19212,38131,21259,36082,21292,33937,21292,27631,6632,8777,15050,19244,21292,15018,21291,12873,23372,14920,25485,17034,27565,25387,25453,29645,35919,42192,44306,35853,39980,52593,48400,48531,40112,29613,25354,21129,29580,46419,35984,17064,14983,17064,21224,25352,21094,27367,25287,12903,15015,12903,21224,23336,23336,42026,35785,37800,52492,54670,56784,58865,56751,44238,19079,10694,10629,14790,12742,12710,12709,18950,23111,14790,14758,10597,18950,44172,54605,50314,52460,52526,54573,54573,54475,56555,44105,39880,50249,52395,50347,52492,54573,52559,48432,52690,50544,48464,42124,37963,52691,54804,50513,44206,44140,50380,48332,44171,42059,29543,46252,48430,44204,44203,52559,50512,44172,44139,46189,50414,48300,44172,255},
{25846,27926,11380,7252,23732,25748,21587,15379,15379,13266,17394,21522,23570,25683,23603,25683,27730,25520,21359,21359,29713,40179,40180,44438,48598,38035,38132,36019,19311,23439,31793,23439,23439,23439,23439,21359,21327,19278,17198,17133,23439,33905,29680,29680,37871,35791,29679,50645,35855,31792,29744,27566,29647,31759,42356,29614,31824,29614,33806,40015,37934,44175,44208,46418,48466,44339,52692,48466,44305,46386,48466,44273,46353,44305,35886,37967,35919,35887,29548,29580,27468,25355,25387,25355,25355,19049,12776,19114,19049,17001,19049,10728,8679,10760,10760,19147,10793,10793,31791,54937,50776,48598,57049,40276,31856,57049,27631,29777,27599,31824,23471,31857,25518,33905,23437,29744,17099,8777,8777,25550,17131,27630,17066,25550,14985,23437,17033,25485,6632,10857,17098,23372,29646,29646,33871,38065,38129,42290,42258,44371,44338,40145,42192,37999,31628,29515,27435,27435,23207,39980,46254,44305,40080,23306,19048,19049,35920,44305,31758,12871,12839,14951,21223,31592,29383,27303,19079,12839,12839,15015,17031,17128,19143,33705,50380,52525,56685,56718,58832,56784,58931,58930,23240,14854,14854,16902,14886,16935,21095,18951,21095,10597,10629,8517,16966,44171,56687,52427,52427,52493,54573,56654,54540,56555,39977,23335,39880,52395,48235,50380,52493,50380,48431,44302,50544,48464,52690,40077,44270,52658,50545,42157,42124,50445,50445,50380,48299,48332,50445,52559,50511,42092,48399,54672,40011,37866,56686,52527,52526,48398,255},
{25845,27926,11380,7251,21684,29909,25683,21587,15347,13266,21587,27731,25618,27666,27698,29876,33972,27601,21294,21327,27633,31761,27600,42357,44405,40147,40179,40180,21424,17231,19278,17198,17198,15118,15085,12973,10924,12940,12972,12940,21326,35921,29648,29648,31663,31695,31727,48565,44274,42226,42258,42226,38033,33807,35920,40015,48434,48532,42192,48400,50546,52594,50514,48401,50579,46420,54805,44306,35919,35919,40080,35887,37999,35919,33741,35854,35854,33741,31628,31628,29516,25355,25323,23242,21162,21162,14889,14889,16968,14920,19049,16969,12808,14921,10728,10761,10793,8712,12906,27631,38065,59098,59130,36082,25550,52856,27631,25550,25518,25550,21390,23437,19244,21389,15051,23404,15051,10857,12937,25517,19147,29679,25485,31824,33872,38130,42323,27630,10792,10857,19308,38129,44500,33871,31758,31694,31693,25355,19049,19049,25322,14855,31629,25354,25224,16838,10630,16935,19047,37834,52626,48465,33806,19080,19079,27402,40146,40079,33871,14951,14886,14918,25384,33640,31495,29383,23239,25255,21095,21192,17031,19176,21320,29641,40011,33737,52526,56719,58930,56784,54638,56783,39979,27368,19015,16902,16903,25289,14822,8517,8549,10597,16902,14822,19046,44139,56753,52460,52427,52492,54508,54574,54540,54507,50314,25383,25415,50347,48234,52428,50347,52428,46187,31593,46318,48431,48432,40044,52625,52625,48431,46350,46317,54705,44106,44073,48299,54607,54672,52592,50512,46286,46319,46318,39946,46285,46285,42060,52493,52493,255},
{23765,25846,11348,9300,17556,23668,31924,29876,17427,11218,19539,36117,42293,38035,31794,29778,23570,27600,23375,23440,33906,40147,38067,33939,25585,23472,33906,31793,17231,17133,15053,15020,14988,14988,14988,12907,12907,12907,14988,12875,25487,40179,25454,21261,21229,21261,21293,23406,31792,40113,44339,44339,35855,27436,27468,33742,46387,52693,44273,44208,44339,46386,44306,38000,46419,46387,44273,37967,33774,35854,35886,35854,35822,33774,35822,33773,35821,33773,31661,31628,31596,31596,31596,31629,31629,33774,31661,29581,33742,31694,31694,29614,27501,21227,17034,17002,14986,8712,8712,10793,27630,57049,54936,40211,31791,52856,17196,19244,21292,21357,21357,27566,27598,31824,31792,38065,15083,10890,15018,29743,44404,44404,42291,38065,35920,37934,42225,25453,14856,10695,25452,21194,17033,12776,16903,14856,19016,19016,16936,16936,23209,16904,35920,29614,25322,29515,21128,14823,23208,41995,52659,40112,31693,27500,27434,31628,35887,46353,40046,25319,25352,23272,23175,29480,31560,27335,25287,31463,31495,29512,25352,21192,19208,23369,33770,27432,42091,56718,52590,58832,58799,48332,54671,35786,14822,12710,10662,10629,8549,10662,10694,14854,31528,27335,29576,48299,56753,54606,54540,54541,52460,52493,52428,52395,50282,41993,23335,46154,48201,46154,52460,52428,50315,44074,50479,52625,54738,44206,50512,35883,31626,50545,54706,54705,50479,46187,46186,52591,54705,54705,48398,39979,42157,40044,40044,37898,48334,46188,50479,52494,255},
{23765,23797,11348,9300,19604,25780,17459,19507,15346,7090,15346,21555,34037,31891,31827,23473,17264,27633,23375,21327,31826,31793,27632,33906,27633,25520,27633,31794,19311,17101,15053,15020,15053,15053,17133,17133,15085,15085,17165,15085,19213,40179,31760,27535,23341,21261,21229,21229,21228,23341,38098,44339,33709,21163,31596,31727,44437,50645,40112,40145,40178,44273,42193,35920,48532,44371,46387,48499,48435,46386,46386,44306,40112,40048,37967,35854,31693,27468,40048,44241,46387,46419,44339,44339,44306,42193,42161,40113,35920,33807,31727,29614,27533,25388,19114,21227,14986,8680,8712,8713,12937,31824,50743,46582,52856,52888,36050,40243,44437,46549,48565,46485,48630,44469,40211,38195,21227,31759,40145,31791,27500,27468,21161,16903,16871,23111,20999,14791,16904,12743,16936,14823,8582,12743,14823,12743,10630,12743,18952,19016,18984,12775,23209,23242,23242,25354,25387,29482,41996,52626,46451,35919,40080,27468,27466,33773,33741,48433,42125,29447,27368,29480,25287,21127,23207,29415,33576,31528,29480,33705,29512,23272,21191,25417,35850,31593,27432,46187,31625,44139,48333,58897,58864,44172,14854,10662,10662,8581,10662,10662,19014,29415,27303,25352,31657,52493,56720,54639,54573,54573,52493,52493,52460,44138,41993,52362,42025,35817,31591,35688,41994,52428,52460,52460,50445,40043,48464,56852,52690,35819,25255,42092,50512,50512,54771,54738,48398,54705,54706,54737,52591,50446,37930,31625,42157,40044,44172,48267,52559,52494,255},
{21685,23733,11380,9267,25845,25780,13299,17459,19507,17427,19475,21555,29844,29811,23505,23473,23505,29713,25455,25455,27568,27601,29713,27665,25585,25520,25552,31858,23505,15118,23472,23504,21359,23439,23439,23439,23439,23439,25487,25487,25455,35953,44405,40179,27567,21228,21228,25421,21228,21261,40145,46322,40081,29614,35887,35920,46485,44274,42193,42291,42258,38032,40113,35888,35952,40179,44339,42225,35919,29613,25388,19147,21195,17002,17034,17034,17002,16969,42226,52725,44306,38033,33807,38000,33807,31727,31694,29614,27501,27468,27468,25421,27468,25356,21195,23307,25388,21227,19114,12840,10793,10760,23373,19179,25518,42389,29776,31791,44372,61243,52726,33872,40113,31791,37967,31726,31726,42258,48466,23177,23242,25290,23177,18983,18951,21031,20999,18919,21031,18983,18951,23177,21129,21129,12775,14823,8550,10630,12710,12710,14791,10630,14888,19082,21162,23242,19082,16969,35821,48433,52824,44372,37999,29581,29515,33773,38000,50579,40078,29447,27367,27400,25319,21159,16999,14822,19014,25255,23239,29512,31625,31625,37834,42026,46219,42058,25319,37801,31625,33673,39946,52559,56719,56784,27465,10662,12710,16934,12774,14822,25255,31495,25287,14983,29577,54574,54639,54606,54541,54573,52493,52493,52493,33704,27464,35784,52394,31688,21255,31560,39881,48267,52428,54574,56720,44203,44205,50512,54739,48530,46351,35851,35786,46285,48398,40044,35786,42092,44204,52592,52624,52625,50446,37866,33673,25384,25351,48299,50315,52427,255},
{19637,25845,11348,7219,23765,29941,17459,23668,23668,25716,25716,23635,31892,29811,33939,40115,38067,29649,23407,23407,23439,38100,40180,29746,27633,29713,27632,27665,27698,17199,25552,33874,31793,31825,33874,33906,35954,35986,38034,35954,33905,38033,35985,42324,40179,33840,29647,33872,29615,25454,42194,52660,40114,10729,27534,35920,46517,42064,31629,29614,33775,27501,29614,27534,25486,44372,50612,46321,35854,27468,31694,29548,35822,33709,35821,35821,35821,33708,44274,52823,40080,35920,37935,38000,35887,37968,37968,37968,37968,40048,40080,40080,40080,40080,38032,40080,40081,33807,35920,35952,35920,35953,35953,33840,29647,29646,25421,23340,35887,54871,52759,25420,35854,38033,44306,46418,48630,40177,48433,33675,31530,31497,29449,33610,31530,31562,33675,29482,33708,29482,31595,27435,29515,17000,14855,16936,10662,10662,12710,10630,21129,10695,12808,14889,16969,21130,21162,23308,46485,33839,52889,46451,35919,29581,25387,33741,37967,46353,40046,27400,27400,23240,19079,25320,27400,23207,12806,14919,16967,21159,29512,27464,25352,25384,29512,44106,44139,39881,48267,50445,52591,39945,52525,58832,37931,14790,18950,33738,19014,23175,31495,29415,21223,17063,35786,54606,54606,54606,54573,54541,52493,52493,52493,42026,29544,21255,39912,46218,19175,23335,37800,46121,52395,52460,54574,54606,52526,52527,52592,35819,25288,29513,19046,50479,50577,29543,31592,27399,29448,48301,48365,46285,48398,48397,46252,42156,35817,46154,52427,50379,255},
{21685,23797,9300,7219,9267,11283,19539,29876,29844,27796,29844,27698,25650,25682,38132,33874,35954,35922,31729,33809,33809,33874,42227,35954,29713,31793,27600,23472,27697,23504,21391,33873,33873,33873,33873,33873,33841,33841,33841,33840,31793,31793,29647,38034,38066,38033,42227,40146,38034,35921,40146,46419,38033,16970,25356,27468,33775,37871,29484,29549,33742,37968,42194,33808,21228,42324,46485,44240,42160,33742,42193,42160,42127,44207,44207,44174,42094,42126,44240,52791,42193,48533,46419,46387,46387,46386,44306,44306,44273,42193,40080,37968,35887,31694,27501,33872,40178,35952,38033,38000,35952,35952,33807,31726,31694,27501,25421,25421,23307,42192,50612,33840,38032,40113,44273,44240,46320,35821,40014,35820,40013,33708,35853,31659,33708,31628,31595,31660,27402,31595,23241,29483,21161,19048,19016,14823,16968,14823,12678,16937,21162,8615,8550,14824,16969,19016,19017,21162,29614,31759,29614,44273,35919,29581,31628,33773,35854,44272,42159,23175,19047,23272,19079,23207,27368,25287,16967,21127,21127,19079,21192,21224,21191,19111,23304,27464,29544,37833,48299,52493,54671,56686,56751,54638,39979,21094,21095,33673,21094,25223,25222,23175,19208,29544,44074,54573,54573,54573,54573,52460,52460,52493,50380,39945,23335,23368,25416,48234,35785,17127,25447,39912,50314,52428,52493,50380,54574,52559,48332,37865,33673,42093,14853,31625,40109,29608,29544,44205,35721,39914,42091,37866,44237,35818,50478,46317,48300,48268,50315,48234,255},
{21685,23797,9300,5107,3026,2994,5042,11218,13233,13234,17362,23570,19409,19442,27731,27666,29713,33906,35987,33939,36019,29681,35954,33874,27600,35986,31793,27600,29745,31890,21358,29712,31761,31760,29712,31760,31760,31792,31792,33840,31792,35986,42227,33808,29615,42194,44307,35953,38033,40146,35953,40113,44208,29452,35790,29581,31727,42031,37967,42161,46386,46386,50645,44339,42258,42292,48631,46386,38000,33839,44338,42192,42127,46319,46287,46287,40046,46288,52626,52791,44306,54838,42226,40113,38033,35920,33807,31726,29646,29581,31694,31662,31629,31662,29614,33872,31824,33872,33807,35887,31759,29614,29614,27501,23308,23308,21163,19082,21195,21194,42225,46484,42193,44338,44305,40047,48399,50513,27434,35853,27435,35821,31595,31628,29515,29547,35821,27402,33740,25289,33708,29515,27402,21129,19016,16968,16936,19049,12710,16936,19147,12776,14727,10598,10663,25290,23209,19049,23242,27468,35886,42225,33806,27500,29580,33741,37967,50612,38031,23239,23240,23240,21127,19047,21127,23239,23207,25287,25320,21192,19079,21159,21192,21127,23239,27496,25449,19175,27432,41994,35753,44172,50413,54573,54606,42091,27399,31560,16869,14821,12806,12774,19176,46219,52427,52460,52493,54573,54573,52493,50347,52461,48267,44041,29512,23303,29544,33672,48267,25416,19174,25415,39848,50315,50347,50347,52428,52493,50445,48332,44107,35785,27431,27463,25383,33736,29575,35850,35818,25351,31625,27431,33738,33737,35786,48300,48300,50413,50347,46154,255},
{21685,23797,13396,3026,946,914,914,9170,13298,11153,13201,13169,13201,15281,25651,27698,27633,25552,29811,29746,31859,27666,25553,27633,29615,31695,38034,35921,23439,31890,29777,31760,31760,31760,29680,31760,31793,33873,31792,29712,29680,29680,44372,40017,29615,42226,46419,42227,40147,38034,35920,44306,48499,35855,37903,29647,25453,37837,40080,50579,46321,40145,46452,46419,48532,44307,44371,54838,40113,35952,50644,48531,46385,52692,52725,52693,48498,50546,46418,50678,44306,52758,33807,29581,33775,27501,25453,23373,23341,31726,46354,42161,42194,42194,38033,35953,25518,25454,31694,27501,23275,27501,29581,27468,31662,31694,29581,29613,31661,31661,31694,40112,35887,33806,33806,40080,50513,52659,44240,27434,35853,31595,35821,35853,29547,37901,29515,33773,21161,33708,29482,29482,29547,23209,25322,18984,25290,21096,35788,27434,21161,21129,16839,10663,14823,23177,31595,27434,21130,14889,27468,42160,33774,23274,21129,31693,29580,50547,38031,25320,27400,21191,21127,21095,19015,23207,27400,29415,23207,19079,19079,19079,21191,21159,21159,25384,23336,21224,19079,31561,39946,29383,29351,37768,48299,52460,48299,41896,31398,23110,12774,10726,25352,50413,52493,52492,52460,52493,52460,52460,48267,50347,48234,46122,41929,44106,37833,21255,29512,46154,19142,17126,23335,41993,52395,50380,50347,50348,44171,50446,52493,48300,42091,35850,35817,31688,27527,25415,21158,19110,23239,27464,16966,29512,23206,44138,50380,50380,50347,46121,255},
{19605,25813,13396,5139,7187,7122,2994,17395,19474,13201,15281,17362,23602,23570,29843,25618,29746,23472,21425,23473,23472,27666,23472,29778,33873,35888,40081,31793,17230,21423,31890,29777,27697,27696,23471,25584,25583,25584,23438,10827,10859,14987,40179,42194,33776,33840,35888,31760,29680,31695,29679,38033,33840,31630,29484,33808,23341,21228,21228,23308,21195,19115,29679,42226,50612,44307,44339,48564,31759,42291,61145,59064,59031,59031,59031,56918,54838,50677,38066,50678,40145,44372,40146,40113,46518,27534,21228,21228,21227,25420,42160,44274,38033,35920,31727,35953,25486,21260,40081,40113,42193,42226,42226,42225,40113,37968,35920,33807,29581,29581,25420,25355,21194,21130,31661,46386,48400,50546,54739,37901,33740,33740,37933,31628,42126,31595,39981,33708,33708,33675,31562,40013,31594,39949,25321,35788,19016,31595,31627,31562,31562,23209,23242,16936,21129,25160,25095,35691,29548,14955,19049,40047,31693,27468,25322,25420,12937,46451,35951,19079,23272,21192,23272,25320,23207,21159,27400,27335,27400,21191,19111,21159,23240,21159,23207,23271,27400,27400,19047,31561,50413,27367,25255,27367,29512,23239,37833,50347,41960,29447,16966,17031,44107,52493,52493,52526,52527,52494,52526,52493,46187,50348,46154,48202,48201,54507,52460,42026,23303,39912,39977,19142,21255,23335,42025,50380,48300,48267,50380,50413,50380,52493,54607,52559,48365,40010,27495,27464,29544,23270,23271,29544,21158,31559,39881,46154,50347,50379,52525,48267,255},
{19605,23765,13428,3091,9267,9203,5042,19507,23668,15281,17362,31924,34004,27731,23570,27698,35987,23505,19344,21424,17231,25520,31859,31858,31825,46387,40146,29713,15086,10924,17198,15150,12972,10891,8778,8779,10827,15020,12939,10859,12972,15020,15020,36019,33905,29647,29647,33873,31760,37904,31695,29615,25389,29582,27469,25454,25454,21228,21228,19180,19148,17067,25454,35953,48564,44306,27599,38000,29712,40210,44370,40113,31726,31726,25452,21227,25420,42226,40211,48598,33840,31727,35887,35919,40146,31695,29581,31629,33742,37935,44175,46386,21228,17002,21195,38065,31792,19148,38065,35919,37967,31662,31661,33774,31629,27436,31694,29548,25355,31662,25388,29581,27500,25355,35919,48499,48400,48466,52626,52625,31627,42159,35820,44239,42094,40014,46352,35853,46320,39948,42061,44174,48432,37900,27402,39981,27467,21129,33675,31595,31594,31563,21129,29483,19016,23210,29482,29223,39657,21064,25323,40047,27499,21193,25321,25388,10922,46451,35853,19015,16935,21127,25320,25287,23207,16935,19111,23207,23239,19111,21191,19143,21159,25288,23207,21159,31528,39881,31495,27367,48398,42060,19014,16967,29546,21192,16999,23239,44139,42123,31625,35785,52492,54574,50446,52560,52593,52559,52527,52526,44139,46187,41994,41962,48202,54507,54508,54540,48299,41961,50314,44074,42058,37897,39913,50314,50315,48267,50380,50381,50348,52460,50412,52526,52493,52493,44171,39913,46154,42026,40011,39978,39945,48267,54574,50380,48234,50412,54672,50512,255},
{15476,23733,15508,1043,15411,13331,13298,21555,21555,19442,25683,34004,31891,23537,21457,23505,31794,27633,29811,21424,25585,25553,25617,33939,29745,27632,23471,25585,23472,17198,15086,15085,12940,10859,8746,8779,10891,17133,12972,8778,8810,8778,10827,29745,29744,38034,40082,29712,27567,29647,38001,31663,40114,33873,25454,27535,25487,25454,25486,21293,19180,19148,19115,21228,31727,38098,25486,29614,29614,27534,27534,27534,12841,17099,17034,21227,29582,23373,38099,40212,31760,40048,40080,39982,40014,42160,42160,44142,42128,54838,54772,44274,25421,21163,29614,42292,40113,38000,33872,33774,31661,29549,33742,29614,29516,27436,27533,25388,33742,35854,33774,25388,31693,29516,40079,44273,42126,42127,50546,52658,44207,50513,44240,52626,50513,52626,52658,52626,52625,52592,50447,42061,42159,39981,37868,25321,42126,21129,25354,31692,35788,29514,29482,25289,33676,16968,27435,33644,51943,48011,44273,42127,27500,25386,27402,29548,23437,48531,33706,27368,21127,21160,23207,25320,21095,14854,19047,23239,21127,14951,19111,17063,17030,19111,19111,21159,25319,33672,39880,35688,42059,52559,35786,23207,29448,29481,21159,14854,14886,29512,48300,52493,48299,50413,54673,52592,52560,52527,48366,48366,39947,37834,29480,19079,29480,44106,52459,52427,56620,54540,52394,52395,48267,44138,31656,31624,35688,44042,50380,52493,50446,52493,52428,50348,50347,50314,54540,52428,48234,48332,46318,46252,37897,46219,54639,52558,52493,54639,52558,50413,255}
};

const uint16_t Dallas PROGMEM [320][241] = {
{46649,46649,46617,46649,46649,46681,46649,46649,46649,46649,46649,46649,46649,46649,48697,46648,48697,48729,50809,52889,52857,52889,54937,54937,52889,52889,52857,50841,50809,50809,50809,50809,52857,52889,52857,50777,50809,50809,50777,50777,50777,50777,50777,48729,48696,48696,48697,48729,48729,48696,48729,48696,48696,48729,48729,48696,48696,48696,48664,48696,48696,48696,48696,46616,40343,36150,34037,31957,31956,31956,29843,29810,29810,29778,29778,29778,27665,29777,29777,27697,27632,25552,25552,21327,21326,40178,42258,19050,17002,16969,19082,21163,21195,21195,23276,23276,21195,25388,27436,29581,29548,29581,25356,27436,27468,21227,19115,23276,23276,19115,19115,16970,19115,19115,17002,19083,23308,23308,19115,19082,19115,17002,12809,12809,14954,12841,14922,17002,12841,19148,31694,50612,48498,50579,44271,42158,35885,23240,37966,27469,17002,37998,50578,21160,6501,4389,8582,19081,8582,14919,23337,19079,21225,14919,10694,8582,12775,14856,8517,27466,44304,37901,18984,23275,27468,27466,31689,42156,52723,54903,42224,23271,23238,40143,35886,19014,21159,19079,8580,12774,14854,14854,19048,21128,27435,19081,16969,21162,29581,31694,25356,23308,19115,23276,25389,27501,31662,35887,37967,42192,42225,44273,44273,42225,40112,37999,37967,33774,33806,35919,38000,33806,33807,33807,25421,23243,27501,25356,25356,21163,12808,10630,23275,27469,27469,27468,27501,27469,25388,25356,19049,21097,25356,27468,29484,27403,29549,27468,25388,23275,94},
{46649,46617,46649,46649,46648,46649,46649,46649,46681,46649,46649,46649,46649,46649,46649,46649,46681,48729,48761,54970,54970,54937,54937,52889,52889,52889,52890,50841,50809,50809,50809,52857,52857,52857,50777,50777,50777,50809,50777,48728,50809,50777,48729,48729,48696,48696,48697,48696,48696,48696,48696,48697,48729,48729,50777,48697,48696,48664,48697,48696,48696,48696,48697,46616,40342,36182,31957,31956,31956,31923,29811,29811,29810,29778,27697,27698,27697,27697,29777,29777,27632,27633,23472,21327,21326,42259,38033,17002,17002,14890,17002,19050,19082,21163,19082,19082,21195,21163,19082,21163,21163,23275,23243,19082,17002,14889,19115,23308,23276,17002,17002,14857,17035,17002,14921,17002,14889,14857,17035,14889,16970,16970,12777,12809,12809,10696,14954,14921,12809,21196,33807,50612,48531,50644,44305,42190,42190,40078,44207,27500,17002,37966,44239,31627,27467,19049,12775,6469,8615,21193,25386,10629,10629,14951,14886,8581,10662,16936,8517,27466,31659,29547,21096,23242,27468,27499,33738,40076,52724,54904,31725,16932,21126,46483,33772,25352,21159,14853,10725,10693,8580,10628,19015,19047,19047,19048,23242,21162,19082,21162,19082,21260,23341,27502,31727,29614,31694,35887,37967,40079,42192,42192,44273,42192,42193,42192,40112,35919,35887,35854,35887,33774,31694,29582,14889,16969,27501,29581,27502,23308,12776,8550,19017,21162,25388,27469,27469,25388,27469,25356,19081,23307,27468,27404,27436,25355,29549,27468,25355,25355,94},
{46649,46617,46617,46649,46616,46616,46649,46649,46681,46681,46649,46649,46617,46648,46616,46648,46649,48729,48729,52857,54937,54969,54969,54970,52889,52857,50809,50809,50809,50809,50809,52857,52889,52889,50809,50777,50777,50777,50777,48696,50777,50777,48729,48696,48696,48697,48729,48696,48696,48696,48729,48729,48729,48729,48697,48696,48729,48696,48729,48696,48696,48696,48696,46616,38262,36150,31957,31956,31924,31923,29810,29810,29810,29810,27730,27665,27697,27665,29745,29745,27665,27632,23407,23407,23374,40179,31695,16937,14921,14889,16970,17002,17002,19115,19050,19082,21163,21130,21163,23243,21163,23276,23243,16970,21195,19050,21163,23243,19050,16970,17002,14889,19083,17002,14889,17002,14922,17003,19083,14889,17002,16970,12809,12841,12809,10729,12841,10696,12809,19116,35920,48531,46418,48531,48498,44303,44303,46384,46352,29548,14889,31660,40014,31563,33806,21161,17000,6501,6437,14855,17000,10598,6405,10630,10694,6469,12808,14888,10662,16999,8516,10630,19016,23274,25388,27500,35885,40076,52757,54936,42224,21159,19046,52790,48498,42256,25383,23239,14917,10692,10692,12805,16967,10661,8580,14822,21095,21161,10629,6469,14889,19147,21228,25421,31727,33840,35952,38032,40080,38031,35919,35919,40112,40079,40047,40080,37999,37999,38000,38000,38000,33774,31662,25388,12744,14856,25388,27469,27469,25421,25356,23243,23275,21162,19050,23243,25356,25356,29581,27469,21162,27501,29581,25323,27404,27436,27501,27468,27436,23275,92},
{46617,46649,46649,46649,46649,46649,46681,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,48729,48729,50809,54970,55002,54937,52889,54938,52857,52857,50809,50777,50809,50777,52857,52889,52889,52857,50777,50777,50809,50777,50745,48697,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,48696,48697,48697,48729,48696,48697,48697,48696,48696,48696,46584,38230,36150,34037,31956,31956,31923,31923,29843,27698,27698,27698,27665,27697,27665,27665,27664,29745,29745,23439,38099,27501,21163,25389,19050,16970,14889,19082,21163,19082,21163,21163,21163,23243,23243,23243,23276,21195,21195,21195,21163,23243,19082,21195,21195,19082,19050,19083,17002,19083,17002,16970,17034,17002,17002,17035,16970,17002,17002,14889,14889,12809,10761,10761,8648,12809,19083,35920,50644,40014,35821,44272,44271,42191,44304,50611,29516,21196,33773,50611,31627,23273,12710,19048,8550,8583,6469,12808,8550,6405,8550,8582,8581,10694,16968,19047,16934,8549,10630,19016,25355,25355,25355,37998,42157,50677,54904,50611,40078,33739,52790,50611,42257,16965,16965,19077,19142,16997,14917,14886,14886,12806,16935,16902,10759,4453,10629,17001,12841,12841,23340,31727,31760,33807,35920,38032,33904,8874,15083,38032,40079,40080,37967,35887,35887,35919,37968,38000,33839,33807,31662,23308,23275,25388,23308,23308,25389,27469,25421,25421,27469,23308,21162,19050,21195,25388,25356,19049,21195,27469,23242,27403,27403,27468,27468,27436,23275,90},
{46649,46649,46681,46649,46649,46649,46649,46649,46649,46681,46649,46649,46649,46649,48697,46649,46649,46649,48729,50777,50777,52889,54970,54938,52889,52889,52857,52857,52857,52857,52857,52857,52857,52857,52857,50777,50809,50809,50777,50777,50777,48696,48696,48696,46584,48696,48696,48696,48696,48696,48729,48729,48729,48696,48696,48696,48697,48729,48696,48696,48696,48696,48696,46584,40311,36117,34037,31957,31956,31924,29811,29843,29810,27698,27697,27697,27697,29745,29745,31825,29745,29745,29712,38066,27437,19050,21163,19050,19050,16970,19083,21163,17002,21163,21195,21131,21163,21163,23243,23243,23243,23276,21195,21163,21163,21163,21163,21163,16970,16970,19050,14857,19051,19083,16937,19050,16970,16969,17034,14889,14889,14889,12777,12809,10729,8648,6535,8648,10761,19115,38000,48531,37934,40014,42159,40078,40078,44304,46385,29581,21196,33774,44239,33707,27434,12774,23274,14856,14920,10663,12776,10630,10662,14918,12806,10758,8549,16968,21160,16966,14886,12774,19016,25355,23275,23210,40111,40078,48596,54903,50578,50545,50643,54870,44337,29546,16997,14917,16965,19077,19109,19109,14885,10660,8580,16934,14854,10889,8874,19014,14823,10663,8615,23308,27566,25454,23341,23341,23341,21293,4746,8874,38064,40079,40047,37967,35854,33774,33806,33774,33806,33807,33775,31662,29614,31694,27501,25421,25388,25356,23275,23308,25388,25421,25421,25421,23308,17001,19049,23275,19049,19082,21194,12710,25323,27403,27468,27468,27436,25323,89},
{46649,46649,46649,46617,46648,46649,46649,46649,46681,46649,46649,46649,46649,46649,48697,48729,46649,48697,48697,48729,48729,52890,52857,52857,52889,52857,52889,50809,52890,52890,52890,52857,52889,52889,52857,52857,50809,50777,50777,50777,50777,48696,48696,48697,48696,48696,48696,48696,48697,48696,48696,48697,48729,48729,48696,48696,48729,48696,48696,48697,48664,48696,48696,46616,40310,36117,34037,31957,34037,31956,29843,29810,31923,29778,27697,27697,29778,27697,27632,42357,40244,35986,40179,42259,23243,19083,23276,19050,19050,14857,19083,19115,16970,19083,21163,21163,21163,23243,23276,23243,21195,23243,23243,23243,21163,17002,16970,17002,14889,16970,19083,16970,19083,19050,16969,19082,19050,19050,19083,16970,14890,14922,14889,14922,8616,6503,6503,8648,10729,19083,38032,48531,46418,50677,44272,40014,40078,44272,46353,29613,16970,27468,35788,35788,37901,19049,12775,10694,14919,10662,23274,16904,8582,14951,17031,10726,10694,16936,19079,19078,21191,14854,16968,27435,23274,19016,40047,42159,50645,54903,50578,48432,52757,52757,52823,46451,25416,21190,19142,19109,21190,19109,16997,14852,12772,21127,19015,14920,6533,12742,21195,14889,14921,23308,21260,21196,21196,19115,19115,19180,6762,4649,27533,37967,37967,35919,35854,33774,33774,33774,33774,31726,31662,27501,29582,29581,27501,29582,27534,27501,25356,23275,23275,23276,23308,25421,25421,23276,19082,19049,19049,19049,21162,14790,25322,27403,27469,27468,27436,25323,89},
{46649,46617,46649,46649,46649,46616,46649,46681,46649,46649,46649,46649,46648,46648,46649,46649,48697,48729,48697,48729,50777,52890,52889,52889,52889,52889,52889,52890,52890,52857,52857,52857,52857,52857,50809,50809,50777,50777,48729,48697,48729,48696,48696,48696,48664,48696,48696,48696,48696,48664,48664,48697,48729,48696,48697,48729,48729,48697,48696,48696,48696,48696,48696,46584,40310,36150,31956,31956,31956,31956,31891,27730,29843,29778,27697,27729,29778,27665,27632,31857,38098,38066,38001,35920,23276,21163,27470,21163,21163,19082,23276,21227,19082,21195,21195,21163,23276,23244,23276,23276,23243,23275,23276,21163,21163,19082,19050,19083,16970,19050,21163,19050,21163,21130,19050,21163,21130,19050,19082,16970,14922,14922,14889,14890,8648,6535,4422,6535,10696,19115,40145,48531,48499,52790,48466,40014,37965,42191,50645,33775,23308,33741,42094,40013,46385,23242,12743,16968,17031,10694,31661,16936,6437,8582,17033,17000,12807,14920,10661,25352,23239,14854,19016,27436,19049,16903,31660,35854,50710,54903,50578,48432,54870,50644,54936,54936,29546,21191,23271,27432,31690,25352,21158,25352,31626,33739,35821,37934,19049,14889,12841,12809,14889,17002,14922,14921,14922,14922,14922,17067,12971,12939,17034,23308,33806,38000,35887,33806,33806,33806,33774,31726,29614,27501,27469,27469,25388,27469,27469,27469,27502,25389,25356,23275,21195,23276,23308,23308,25421,21227,19049,19049,23275,27403,27403,27403,27468,27469,25388,23275,87},
{46649,46617,46649,46649,46649,46649,46649,46649,46681,48729,48697,46649,46649,46649,46649,48697,48697,46649,48697,48729,50809,52889,52889,52889,52889,52857,52889,52890,52857,52858,52857,52857,52857,50777,50777,50777,50777,50777,48696,48696,48696,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48697,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48664,46584,42423,38230,31957,31956,31956,31923,29811,27730,29778,29778,27730,29810,29778,29810,29778,27664,38131,35986,25389,19083,19083,21163,23308,21163,21163,16969,21195,21195,19082,23243,21195,23244,23243,23211,23244,23276,23243,23276,23275,19050,19083,16970,16970,16970,14857,17002,19082,16969,19050,19050,19050,21130,19018,16970,16970,16970,14889,14889,12809,12841,8615,6503,6502,6535,8648,21163,40113,48466,48531,46451,35853,35885,35918,44304,52823,33807,23276,33708,52658,46418,35855,23275,19081,19113,21225,21160,31660,25290,12679,10662,10662,12743,12808,16969,8517,23272,19079,12773,21128,27467,19016,16903,31692,31629,52790,52823,48465,48432,54903,50644,57049,50646,29515,14823,27434,42158,46416,44271,42158,44239,46352,44239,33741,27403,19082,17002,12809,10728,12809,14921,12841,14922,14922,14889,14889,17002,19050,14954,17067,17034,21227,33807,33807,31661,33807,35887,33839,33807,31694,29581,27501,27469,25388,23308,23308,25388,25421,25389,27469,27501,23276,21195,19115,21195,23308,23275,19082,19017,25388,29582,27436,27403,27468,27501,25388,23275,89},
{44569,44569,46617,46649,46649,46649,46649,46649,46649,48697,48697,46649,46649,48729,46649,46649,48697,48729,48729,48729,50809,52890,52889,52889,52889,52857,52857,52890,52889,50809,52857,50809,52857,50777,48696,50777,50777,50809,48729,48696,48696,48697,48696,48697,48697,48696,48696,48696,48664,48696,48696,48696,48696,48729,48697,48697,48696,48696,48697,48697,48696,48696,48696,46584,42423,36150,31957,31957,31956,31923,34004,29843,29778,29778,29778,27729,29778,29778,29777,27665,29777,31824,25389,21195,21163,25389,23276,21163,21163,21195,23243,21163,21163,21163,19050,23244,23276,23244,23276,23243,23276,25356,23276,19018,19082,16970,19083,19083,16970,19083,19082,19050,21131,21130,21131,21163,21163,21163,21163,19050,16970,14922,14890,14890,8583,6535,6535,8615,8648,19050,42226,46451,29579,21161,14855,25354,35886,42160,57050,35953,23308,33773,48465,44337,31695,23275,14921,17002,17033,25322,46451,40080,23210,19081,14855,6469,6469,16969,10598,25353,16966,16998,21161,25322,21129,23177,31660,29515,50677,52790,48464,48464,54903,50644,57049,44339,25289,12710,29482,44272,46385,42159,44240,44304,44304,42192,31629,21163,19082,14954,12809,10728,12809,14922,12809,14889,14922,14954,14921,16969,16969,14921,14921,17034,17002,17002,19082,16969,21194,23275,25388,25420,27501,27501,29582,29581,25420,23308,23308,23308,25388,23275,25388,25356,23340,25389,21195,19050,19115,21163,16936,19049,25388,27436,27403,27435,27468,27469,27468,25355,89},
{46617,46649,44569,46616,46649,46649,46649,46649,46681,46649,46649,46649,46648,46648,48697,46649,46616,48697,48729,48729,52890,52857,52889,52857,52857,52890,52890,52889,52857,52857,52857,50809,52857,52857,50777,50777,52857,50809,50777,48697,48697,48729,48696,48696,48696,48697,48696,48696,48696,48696,48697,48729,48697,48697,48696,48696,48696,48697,48696,48696,48696,48696,48696,46616,42423,36149,34037,31957,31956,31891,31891,29843,29810,29810,29778,29778,29778,29745,29777,27632,29745,33905,33840,31759,29581,35888,29581,21163,21163,23275,23243,23275,23275,23276,21195,23276,23276,25324,23276,23276,25324,25356,23276,21195,23243,19082,21163,21163,19050,21163,21163,21131,21163,21130,21163,21163,21130,21163,21163,19050,17002,16970,14922,14922,8583,8615,8583,8615,12809,23308,42226,42225,19080,19080,16968,21161,33774,37903,57050,38033,29581,33773,44272,46386,33775,19082,10728,12841,12841,19049,50645,44339,27500,19080,12742,6469,6437,14889,10630,29579,23239,21191,19048,29548,23210,25354,29548,35886,52822,50676,48432,48498,52822,52757,57017,35854,23177,14791,33676,42126,46353,40046,44240,44240,44272,42159,31629,23243,17002,14921,12809,12809,12841,17002,17002,14921,12841,14889,12841,16969,16936,14889,14921,16969,14921,17001,19082,14888,17001,14889,14889,16969,17001,21162,23308,25388,27469,25388,25421,25388,23308,23275,23308,23308,23275,25388,23276,21195,19083,19083,16969,19049,25356,23243,25323,27403,25388,27468,27468,25355,88},
{46649,46649,46617,46649,46649,46649,46649,46649,46649,46649,46649,46649,46616,46648,48697,46649,46649,48697,48697,48729,50809,52890,52857,52857,52889,52889,52889,52857,52857,52857,50809,50809,52857,52857,50777,50777,50809,50777,50777,48696,48696,48696,48697,48729,48729,48697,48696,48696,48696,48696,48697,48729,48697,48696,48696,48697,48729,48696,48696,48696,48696,48664,48696,46584,42391,36150,34037,31956,31924,31924,29811,29810,29810,29778,27698,27697,31890,29778,29777,27697,29745,27599,25388,31694,35920,33774,33742,19082,21131,21131,23243,21195,21163,21195,21163,21195,23276,23276,23276,23243,23243,23276,23243,23243,23243,21163,21163,21195,21131,21195,21195,21163,23244,23243,21195,21195,23243,21195,21195,21163,21163,19115,17002,14922,8583,6503,6503,8583,17002,29614,42258,44273,33772,33805,31692,33773,35854,37902,57082,38065,23243,31628,44239,46451,29614,16969,6469,6502,12808,27532,44306,48565,27499,16999,12774,12774,10662,23276,12743,29580,29545,23239,21128,31661,25322,12742,25321,35886,52822,50676,46351,50643,52790,52855,54870,29547,12742,16871,40046,40045,42159,40047,44272,44272,46353,44240,33774,25388,12808,12809,12809,10760,12809,14889,14889,16937,16936,14856,12744,12678,12678,10630,12743,10630,10597,12742,19081,16935,16968,16968,16937,16969,14889,14856,14889,17001,19082,21195,23308,25388,25388,25356,23308,21227,21195,21195,21163,21195,23341,19148,19082,19049,25388,19081,21130,25355,27436,27468,25388,25355,86},
{46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46648,46649,46649,48697,48697,46649,46649,48729,48729,48729,50841,52857,52857,54937,54937,54937,52889,52889,52857,50777,50809,50809,52857,48728,50809,52857,50777,48697,48696,48696,48696,48696,48696,48697,48697,48696,48696,48696,48696,48696,48697,48696,48697,48729,48729,48697,48696,48696,48697,48664,48664,48696,46584,42391,36150,34037,31957,31956,31956,31891,29811,29778,29778,27698,29746,31890,29745,29745,29745,29745,33905,40113,38033,33840,31662,35887,23275,23244,19050,27436,25388,19082,19050,14857,16969,17002,14889,16970,14889,14856,17002,14889,14889,16970,14889,14889,16970,14857,16969,14889,12744,16970,16937,14857,17002,12776,14889,14889,12808,14922,10728,8616,10696,8615,6535,6503,8583,12776,21195,44339,46418,50611,48498,40079,42160,37902,35821,57050,42259,31662,31563,42127,46419,27469,16970,8615,8615,16969,42225,44338,48597,29580,21160,14887,8613,12742,31726,12743,23242,29611,23272,23208,31661,19049,10597,23241,29580,52790,50644,40013,52757,50677,54903,50544,25352,8549,16903,42159,42159,37901,37934,44304,44304,42159,40080,23274,10695,2243,6437,10696,8582,12710,23241,33773,42126,44207,44239,37934,35821,27403,16936,12710,8485,4324,6436,8517,12775,16936,14855,12743,12743,14823,14823,12776,14889,14921,14921,19082,21195,25389,25389,25421,23276,19082,19115,19082,19082,19083,19148,19082,16969,23275,10662,14856,25323,25355,27468,25355,25388,82},
{46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,48697,48729,46649,48697,48729,48729,48729,48729,50809,52889,52889,52889,54937,52889,52890,52857,50809,50809,50809,50809,50777,50777,50777,50809,50777,48696,48696,48696,48696,48696,48696,48696,48696,48697,48697,48696,48696,48696,48696,48697,48696,48696,48697,48696,48664,48696,48696,48664,48664,46583,40342,38263,34037,34037,34036,31924,31891,29811,29778,29778,29778,29746,29778,27697,27665,29745,27632,31727,42194,31726,33808,29549,35855,25356,21163,19082,25324,23275,21130,19083,17002,19082,19083,17002,19083,17002,17002,19115,17002,16970,17002,16970,19050,19083,16970,19082,16970,14889,19083,19050,14889,17002,14857,14889,14922,12809,14889,12809,14922,14954,10729,6535,8616,10696,12809,19114,44338,48499,48531,46385,44305,42160,37902,37934,57050,42227,29549,33708,46352,48532,29582,17002,10728,12841,21163,42225,46419,48597,31661,21160,16999,10726,14854,16967,14855,16967,10629,25353,25321,31661,14855,6436,19016,25355,50678,48565,37966,52822,50644,54936,48531,21128,6436,21128,42158,44239,37869,33709,37966,29547,14854,10597,4355,4323,4291,2243,6372,21064,35821,40046,44271,44239,42159,44272,35853,37966,31628,27403,33741,31628,23242,19016,12678,10662,12775,14855,12775,12711,12743,10630,8549,10662,12776,14856,14824,16969,19082,21195,25389,23308,21195,19115,14922,14922,17002,17035,19082,16968,21227,14855,10662,23242,25355,27468,25388,27469,77},
{46649,46649,46649,46617,46648,46649,46649,46649,46681,46649,46649,46649,46649,46649,46648,48697,48729,48697,48729,48729,48729,48729,48729,50809,52889,52889,54937,52889,52857,52857,50809,50809,52858,52857,50777,48696,50777,50809,50777,48696,48696,48696,48697,48697,48697,48697,48729,48696,48697,48696,48696,48697,48729,48729,48696,48696,48697,48696,48697,48696,48696,48696,48696,44535,40342,40311,34037,34037,34036,34004,31923,29810,27730,27730,27698,27698,29778,29777,25552,27665,29745,33905,46485,38033,33872,31662,33742,16937,19050,16937,19050,16970,16937,16970,14889,16970,17002,14889,16970,16970,16970,19082,16969,14889,17002,14889,16970,19082,16969,16970,16970,16969,17002,16969,14889,16970,14889,14889,17002,14889,19083,17035,17034,17035,10729,8615,8583,10696,10696,19114,42258,48499,48499,31465,35821,40079,35789,37934,57049,42260,29614,31627,48466,54870,35920,14889,12809,12809,21195,40112,44338,44371,27467,21193,21160,16967,14918,19047,19080,16999,12741,25386,25289,29581,14920,8549,8516,27468,52791,57083,50548,52790,52725,54969,44338,16934,6436,31626,37965,46352,35821,19048,12774,8613,6468,4323,6436,6436,2243,10630,29580,37999,35854,27435,40080,35886,35854,40080,31629,29549,16936,19049,29548,29581,29548,29581,31629,23210,19081,16936,14791,12710,12710,10630,10597,8549,8517,14726,25031,14856,12808,17002,19147,21195,21227,21228,19083,17002,14921,17002,17001,16969,23308,21161,12710,23274,25356,27501,25388,25421,77},
{46649,46649,46649,46649,46649,46649,46649,46681,46681,46649,46649,46649,48697,48697,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,50809,52889,52889,52889,52857,52889,52889,50809,52857,50809,50777,48697,50777,52857,50777,48664,48696,48696,48697,48697,48729,48696,48696,48696,48697,48697,48729,48729,48697,48696,48696,48696,48696,48696,48696,48664,48696,48696,48696,46584,40343,38262,34037,34037,34037,31955,31891,29842,29778,27730,27698,27697,27730,29778,25552,27632,31858,33937,50711,42226,35920,33742,42225,25355,27437,21163,27437,21195,16969,17002,14857,16970,16970,12776,14889,14922,14857,17002,14889,14857,16970,14857,14889,14921,12776,16970,14890,12776,14889,12776,12776,14889,12776,12809,14889,10664,12809,12809,17002,14922,8648,8583,8583,19083,14889,21195,42225,46418,50579,42062,42191,44239,35757,39982,54969,46454,40179,40013,46352,52756,42160,14856,10696,6502,25355,48564,50678,42193,29581,27499,23240,21191,21191,21128,16935,21192,14886,16967,23241,29581,14855,14854,10693,29581,54904,59229,54806,52790,52758,54936,46353,18982,10596,35852,35852,27434,14822,8613,8613,8613,8581,6468,6436,4323,14856,33774,33774,31694,21162,16936,35887,33774,33742,35887,27468,25356,12711,21129,23242,23275,23275,25355,27469,16969,25323,31629,25323,19017,16936,14790,10630,8549,8582,10630,22916,16805,14888,12776,14889,21195,19115,19115,19083,19115,17002,14921,19050,14856,23275,25355,23242,25323,25355,27501,25420,23341,70},
{44569,46649,46617,46649,46649,46649,44568,46649,46649,46649,46649,46616,46649,48729,48729,48697,48697,46649,48697,48696,48729,48729,48729,48729,50777,52889,52889,52889,52857,52857,52857,52857,52889,50809,48729,50777,50777,50777,50777,48696,48696,48696,48697,48729,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,48696,48696,46584,42391,38230,34037,34069,34037,31923,31891,31891,29811,29810,29778,31858,31858,31858,27665,29745,31825,31824,42259,44404,38065,33742,37967,21162,19082,19050,21163,19082,17002,19083,17002,17002,19083,17002,17002,19083,19082,19083,19082,19050,21163,19050,19082,19082,19050,19083,19083,16970,17002,17002,16970,17034,14922,14889,14922,12809,14890,12841,17002,10728,8615,6535,6535,12776,10696,21228,44338,48498,50643,48466,35821,29418,31564,40080,50743,48533,33742,35788,48497,54837,42160,10663,6502,10663,29581,48597,48597,42193,31661,25354,27466,29578,21191,16935,14823,25354,25385,14853,23209,27500,19047,19078,10661,33775,52824,54936,48531,52790,52790,54904,40047,21096,16902,37932,27465,8579,8612,10725,10693,10725,8613,6500,4355,19113,35952,25355,29549,27501,21163,21130,35887,35854,35855,35887,25388,23243,21163,27501,23275,21195,19050,21163,31793,23309,19049,27436,21162,16937,23275,25323,23210,14856,8712,4682,14951,18916,14823,10662,12743,19082,19115,19115,19115,19115,19115,19082,17001,14856,23275,27469,25323,25323,25355,27468,25356,23341,67},
{46617,46649,46649,46617,46616,46649,46649,46649,46616,46649,46649,46649,48729,48697,48729,46649,48697,46648,48729,48697,48696,48729,48729,50809,50777,52857,52889,52890,52889,52857,52857,52857,52857,52857,48697,48729,50777,50777,50777,48697,48696,48696,48696,48729,48696,48697,48729,48696,48697,48729,48696,48697,48697,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,46616,42423,38230,34037,34037,34036,31923,29810,29778,29810,31891,29777,38131,42325,31858,27665,31858,31825,31792,23308,38033,35920,33741,35822,19049,19082,14857,19082,14857,14857,16970,14889,14857,17002,16969,16970,16970,14857,14889,14889,14857,16970,14889,14889,16970,14857,14889,14889,14857,16970,14921,14889,14922,14889,14889,14922,12777,17002,17002,17002,8648,6503,6535,6503,8583,8615,19082,46451,48498,50611,44207,29353,25225,29484,33806,46452,48468,29484,29484,42127,48498,35854,14856,10728,14889,38000,50710,50678,48564,37967,29548,23242,25354,23272,19080,14823,27466,33803,19047,25290,27468,21192,19046,10693,33807,52790,48432,50611,52757,52823,54871,35789,14822,27401,35851,27432,16965,12772,8644,10693,8612,8613,6468,21226,35920,29581,19082,25356,29581,33775,25356,27469,31694,33742,29581,17001,19115,21162,27436,23275,23275,16937,21163,31760,29614,21130,25356,17035,10696,16969,21163,23243,14888,10793,12905,17032,23209,21162,19082,21162,19082,19083,19115,19115,19083,17002,19083,19082,16936,23275,27436,23210,25323,25355,27468,25388,23308,81},
{46617,46649,46649,46616,46649,46681,46649,46649,46649,46649,46649,46649,48729,46649,46649,46649,48729,48697,48729,48729,48697,48729,48729,48729,48729,50809,52857,52889,52857,52857,52857,52889,52857,50809,48697,50777,50809,50809,50777,48697,48697,48696,48664,48729,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48664,46616,48696,48696,48696,44535,40343,38230,34005,34037,34036,31956,29810,29843,29811,29843,29810,29777,36051,29777,27632,27665,25552,31825,29680,35953,33742,33742,44273,25356,25356,21130,25356,14889,14857,17002,14889,14857,19050,14889,16937,17002,14857,14889,16970,14857,16970,14889,14889,17002,14857,14889,14921,12776,14889,14889,12776,14889,12808,12809,14889,10696,14922,19148,19083,10696,6503,6503,6535,6535,6535,19082,46419,48564,46451,44240,42095,42128,27402,40080,46517,48468,33613,29516,44239,48498,33742,16937,12808,14921,33839,50677,50710,50710,37967,29549,25323,21161,21192,19047,12743,27498,31723,21159,23241,29548,23272,19078,16966,27500,52758,48399,50644,52725,54904,50645,35853,19016,31659,37898,31624,29577,19046,10725,12774,14855,16968,21162,33807,27533,35986,25453,15083,23405,33807,27501,19082,29549,27501,19017,6437,12809,16969,23275,21195,19115,10663,17002,23307,27468,25356,25389,23276,14857,14889,14922,25454,21196,10663,14889,16969,17001,19082,21163,21196,21196,17035,17034,19115,19115,17035,17034,17002,16936,23275,19082,16904,23242,25355,27436,25356,23275,113},
{46649,46649,46649,46648,46616,46649,46616,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,48729,48729,48696,46648,48697,48729,48729,48729,48729,50809,52857,52857,52857,52857,52857,52857,50809,50777,48697,50777,50777,50777,50777,48697,48697,48664,48729,48697,48696,48696,48697,48696,48664,48696,48697,48729,48697,48697,48696,48696,48696,48664,48696,48696,48696,48696,44535,40343,38230,34037,34037,34036,31955,31923,29843,29843,29810,29810,29745,27697,29745,27632,29745,31826,29745,27600,38033,33742,33807,35887,16970,16970,16937,19050,17002,16970,19050,17002,17002,19083,16970,17002,19082,17002,19050,19083,17002,19083,16970,17002,19115,19083,17034,19115,16970,17002,17002,14922,17002,14921,14889,14922,12809,16970,19115,16970,14922,10696,6535,6502,6503,8615,19082,46419,50645,40145,42192,40112,38031,25321,46418,54936,50613,35758,33709,46352,48498,25323,8583,6502,12809,33839,48597,52823,44371,29548,25323,25356,19017,23242,16968,14823,27434,25385,19015,25322,29548,23239,19077,19078,29613,52790,46351,52789,52725,54936,46420,35853,21129,33740,40109,31624,29545,21159,12774,19081,27435,31662,31727,19082,21195,29582,29679,11019,13035,33807,40146,21130,25388,25388,16937,8518,12808,16969,21163,19082,17035,8615,10695,17001,21163,19082,17002,19082,19082,17002,17002,23374,21228,10663,10728,12809,14889,14889,14889,12809,17002,17035,19115,19147,19115,19115,17035,17002,16969,23275,12743,10630,21097,25356,25388,25323,23275,91},
{46649,46649,46649,46616,46616,46649,46616,46649,46649,46649,46649,46649,46648,46649,48697,46649,46616,48697,48729,48729,48729,48697,48697,48697,48729,48729,50809,52857,52857,52890,52857,52857,52857,50809,50777,48697,48729,48728,50777,50777,48697,48729,48729,48696,48696,48697,48696,48696,48729,48696,48664,48696,48696,48729,48696,48664,48696,48696,48664,48696,48696,48664,48664,44503,40343,36150,34037,34037,34037,31955,31923,29811,29843,29842,29810,29810,29778,27665,27665,31858,38164,35985,25421,38033,33775,31727,33775,19017,21163,14856,14889,14889,12776,14889,16970,14857,16970,12776,14857,16970,12744,14889,14922,12776,16970,14889,12776,14890,12809,14889,17002,12776,14857,14889,10696,14889,12809,12744,12809,10696,23341,23308,12809,12841,8583,6503,6535,6503,6535,19082,46419,48532,42291,29612,14887,17000,23241,44273,52855,54905,52791,44338,46351,50611,25356,8615,10728,12809,31726,48596,52823,40048,29516,27403,35855,29548,27436,16969,12743,27498,25353,16903,25322,29548,25385,19110,19079,33774,52757,44270,52790,52725,54936,42194,35822,19016,33772,40077,35851,27432,21127,10661,21162,31629,38033,19082,8518,21195,25388,25453,6859,13035,25388,29581,21195,21162,16969,16969,12808,14921,14889,21163,19082,14922,8583,6502,10728,12841,12809,10631,12776,14922,14889,14954,14954,12841,12776,12808,12809,12809,12809,12842,8615,10696,14922,14922,17035,17034,17002,17035,17034,19049,23275,16936,10597,19016,27436,25388,23275,25356,112},
{46649,46649,46649,46617,46649,46616,46616,46649,46681,46649,46649,48697,46649,48697,48697,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48729,48729,50809,52857,52857,52857,52857,52857,50777,48697,48697,48729,50777,48696,48697,48697,50777,50777,48696,48696,48696,48696,48696,48696,48729,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,44503,38230,36150,34037,34069,34069,31955,31923,29843,29811,29842,29810,29810,29810,29778,27665,29745,33938,40243,38066,42291,33774,29549,42160,33741,37934,27436,23275,19050,16969,21163,21163,16970,19083,19050,19050,21163,16969,19050,19082,14889,17002,16970,14889,19083,16937,16970,17002,14857,14889,16969,12776,14889,14889,12776,14890,12777,23308,21196,12809,12841,10696,6503,6503,6502,6535,19082,44339,38000,33774,23305,16967,16936,21096,42193,52855,57082,55002,40079,46319,40080,16905,12809,12809,14890,31694,50677,50710,50644,50579,52692,54804,35853,12742,21194,14823,23274,19047,19047,25290,29548,25352,16997,14886,33839,52724,46319,52822,52757,54936,35823,31628,14855,19047,23240,35917,27432,21159,10661,16968,35952,33807,19050,14824,25421,25356,21227,10954,15051,19115,14921,14921,12808,10695,10695,10663,10695,10663,12744,12744,10663,8583,10663,12809,12809,10696,4324,8583,12809,12809,12841,12841,12809,10728,12809,12841,14889,14922,14954,6502,8550,10728,12776,12809,12809,8550,10663,17002,19049,23275,23275,14823,21129,25355,25388,25356,23307,100},
{46649,46617,46617,46617,46616,46649,46681,46649,46649,46649,46649,48697,48697,46649,46649,46649,48697,48696,48729,48729,48729,48697,48729,48729,48729,48729,48729,50809,50809,50809,50809,52857,52857,50809,50777,50777,48729,48729,48729,48696,48696,50777,50777,48696,48696,48696,48697,48696,48696,48697,48696,48664,48697,48696,48696,48696,48697,48696,48696,46583,44470,44503,44503,42390,34036,31891,31923,31923,33971,31891,29810,29778,29778,29810,29778,27697,27697,27665,27664,29777,27664,29712,27632,38033,35823,33677,46352,44240,46320,42095,35854,25356,21196,23308,23308,23276,23308,25356,23308,25389,23308,23308,25356,23244,23276,23276,21196,23276,23244,23276,23276,23276,21195,21163,19115,19115,17035,14922,17002,19148,14889,12776,12809,14922,10729,6503,8583,12809,12744,25388,44338,31726,29547,27466,25355,19017,25355,38033,44436,48663,44405,35854,44240,35887,10663,12809,12776,12808,29581,50710,50677,42192,50643,52756,48530,27401,16902,31661,16904,17001,12774,21160,23242,27500,21191,16997,12774,38033,50643,46352,52790,52790,54936,27435,16967,10693,8580,8580,14854,27401,23207,12741,27468,35920,25388,23275,21195,23276,19082,21162,14823,14856,14888,12808,14888,19049,19048,16936,14855,14856,12776,10695,10663,8582,8583,10663,10696,10728,10728,6470,8615,10728,10728,10696,12777,8615,6470,10728,10728,12809,12809,14889,10696,10728,12809,12776,10696,10728,4292,6405,14856,21129,23243,25388,23210,25323,25355,25355,25388,23275,78},
{46617,46617,46617,46616,46616,46649,46649,46649,46649,46681,46649,46649,46649,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,50809,52857,52857,52889,50809,50809,50809,50777,48729,48696,48729,48729,48696,50777,50777,50777,50777,48696,48696,48729,48696,48696,48696,48697,48696,48696,48697,48696,48696,48696,48696,48696,38132,17003,17035,17035,12842,17068,21293,23341,23374,27567,25486,23406,25487,25454,23374,25454,25454,23373,23406,23341,23374,23406,23374,23309,42259,54871,44273,48433,42095,44272,42094,44273,35855,23211,21163,19115,17002,21163,19083,19082,21195,19082,21163,21195,17002,19115,19115,17002,19083,17002,16969,19083,16970,16970,17002,14889,14889,14857,10664,12809,19116,19148,21261,14889,14890,10696,6535,8583,10663,8615,21162,44306,31662,25386,27532,33840,27534,25453,27599,27534,27534,27567,29647,23275,16969,8582,10695,10728,6470,21194,50710,48597,50580,54837,54869,50643,37900,37900,42193,25290,19081,10661,16967,25354,27499,19078,19110,19048,33807,46417,48497,52790,52790,52790,23240,14853,12804,10692,6500,6435,19014,21126,23241,33871,27468,25388,25421,12743,16937,23308,21163,18951,12710,6469,6469,8581,10662,8548,12709,19015,19048,19016,16935,14824,12776,8614,8615,8583,8583,8583,8583,8615,10663,10696,10696,12776,8583,4357,10663,10696,10728,10696,10663,12809,14922,14922,14889,12809,12776,8550,8550,14856,21130,23243,27468,23242,23210,25355,25323,25356,21195,78},
{46617,46617,46649,46649,46616,46648,46649,46649,46649,46649,46649,48697,48697,48697,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48697,48697,48729,50809,52857,52857,52857,50809,50809,50777,50777,48729,48696,48697,48729,48729,50777,50777,50777,48729,48697,48696,48729,48729,48696,48696,48697,48697,48696,48696,48696,48696,48664,48664,44503,31826,14922,12874,10729,10729,19148,25487,23374,25454,27599,25454,25454,25487,25486,23374,25454,25454,23341,25454,23374,23341,25454,29647,27566,44339,50643,48465,50545,40046,44240,40014,42095,44241,33709,29581,23275,23211,23243,23243,19082,21195,19050,19050,21195,19082,19083,21195,17002,19083,19083,16970,19083,17002,16970,17002,14889,14889,12841,10696,12809,10728,21261,27567,14857,16970,10696,6502,6502,6502,8583,19082,46419,27404,29547,29645,36018,29680,27534,27535,25389,25454,25421,23374,12808,8583,6502,8615,8614,6469,21162,50742,50710,50677,52756,52724,54837,50578,25320,14854,16935,14854,10725,16935,27435,29547,21159,19078,35854,37968,46352,50611,52757,52823,48532,27401,16998,16997,12805,8612,6500,14821,21127,38000,27436,19017,27533,23308,10631,19082,17033,10629,14790,8516,4355,4355,6436,4323,2243,6468,14853,16902,19014,27302,21063,12743,10663,12776,12776,10695,8582,8518,6470,6470,8583,8583,10696,8550,6470,10663,10696,12776,4357,4292,8583,10696,10728,12841,12809,12809,12776,12809,16969,21129,21162,27468,21096,23242,25355,23275,25356,19082,75},
{46617,46617,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46649,46648,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48697,48696,48729,50809,52890,50809,50809,50809,50809,50809,50777,48696,48697,48696,48697,48697,48729,50777,50777,50777,48696,48696,48696,48729,48696,48697,48729,48696,48696,48664,48664,48664,46616,46583,33906,21228,14922,16938,14858,14890,19148,25519,25487,25454,23406,23373,23373,25486,23341,21261,23373,23341,21260,23341,23341,21260,23341,25454,25421,46419,48465,48465,50578,42127,46320,42159,44240,46353,42127,42127,40079,35821,40015,40048,29581,23243,21163,21130,23276,19082,19050,21195,19050,19082,21163,19050,19082,19050,16969,17002,14889,12809,12809,10696,10729,8616,12809,19115,19083,19115,17002,10663,6535,10696,10696,21163,46419,21065,25354,29646,33873,31728,35953,31695,25421,35986,27534,25422,19115,21195,14889,10696,10695,6469,19081,50678,50710,52790,54870,54837,54869,42190,19046,23273,16903,19079,19046,19015,27435,29580,23272,19045,46451,40114,44272,50644,52757,52855,48499,27401,19047,23304,16997,12772,6500,14853,29579,38000,16807,16969,27501,23340,17034,10694,6500,14885,16998,10660,8580,6500,4420,4323,4355,4355,4355,4323,6435,14789,18982,14822,16936,16936,12743,10663,12743,12775,10695,8582,8550,8582,8583,6470,6470,8615,8615,12809,4292,2211,6502,8615,8615,10663,10696,8615,10728,12808,16969,21097,21130,21162,12710,21161,27403,25355,25356,16969,72},
{46617,46617,46616,46649,46649,46649,46649,46649,46649,46649,46649,46649,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,50809,52889,52857,50809,50809,50809,50809,48729,48697,48729,48697,48697,48729,50777,50809,50809,50777,48697,48696,48696,48697,48697,48696,48697,48696,48696,48696,48696,48696,48664,48697,36019,21229,17003,21035,23083,16906,19180,25487,25486,23374,25454,23405,25454,25486,23406,23373,25454,23374,23341,25454,23373,23309,25454,25454,25421,42225,48465,50578,50611,42127,44272,44240,44240,46385,42127,42159,46385,42159,44240,46353,42128,40047,40015,35854,40048,37902,35822,37967,35822,35789,35887,33741,35822,35822,31661,33742,33774,27436,12777,12809,19083,17002,14889,17002,16970,14889,16969,12809,10696,12777,12776,23243,46451,31596,33773,33839,35986,25421,40146,29614,29647,38066,27501,27534,27502,23341,19147,19147,17002,12808,23275,48597,48597,52757,54869,54837,52691,33706,19047,25354,16903,23272,19111,19015,27403,31661,31658,19046,46451,40049,42160,52725,52790,54904,44273,23144,16903,27466,12773,14918,14885,12773,38032,33775,25227,25324,25388,25421,10726,8580,10725,14917,17029,19110,17029,10692,6467,8580,8580,4355,2243,4323,2211,4291,10629,14822,12741,14854,14822,16968,12743,10663,12743,12808,12776,12744,8582,8550,8550,8550,8550,6470,6469,6469,8615,10695,8647,8615,8583,8583,8615,10663,16937,16937,16937,19017,12678,16904,25323,25323,23307,19049,76},
{46649,46649,46616,46649,46649,46616,46649,46649,46649,46649,46649,46649,46649,48729,46649,46649,48729,48729,48729,48696,48729,48729,48697,48729,48697,48697,48729,50777,50809,50809,50777,50809,50777,50777,48696,48697,48696,48696,48696,48697,48696,50744,50777,50777,48696,48696,50777,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,35987,21229,16971,25163,25131,16905,19148,25487,25487,25454,25454,25454,23406,25486,25454,23341,25454,23373,23341,25454,25486,25421,25421,25421,25421,40145,42160,44305,52724,40046,44240,44240,42159,46353,42127,42160,44272,40046,42159,44273,46385,44240,44240,40014,46321,44240,42127,46353,42159,42127,44273,40047,42127,44272,40014,42160,31661,27436,19082,19082,16970,19050,19050,16970,14889,14889,14889,14857,12809,23341,10696,23243,46386,42160,44305,35886,33840,19115,38098,31759,23308,40179,25421,23341,17035,10760,8615,8615,8615,10728,21162,48597,48564,52789,52756,50610,42125,46384,31627,33774,16936,25387,19079,19048,25355,33773,29546,21127,50612,44307,48564,54870,52758,54903,42160,27337,14822,23273,6467,12741,21159,25386,38000,27468,27469,25389,25356,21162,8581,6500,10725,10724,10724,14885,14917,12836,12772,12805,10660,10693,6500,6436,4355,4323,6436,6436,10661,16869,18916,12742,12775,19049,14856,10630,10630,10663,12743,10695,10663,10663,8582,6470,6437,6437,6502,8583,8615,8615,8583,6502,6502,10663,16970,14857,12711,23242,16936,12710,19049,25355,23275,21130,72},
{44568,46616,46649,46649,46649,46649,46649,46649,46649,46649,48697,46649,46649,46649,46649,48729,48729,48729,48729,48697,48729,48729,48697,48729,48697,48729,48697,48729,50777,50777,50777,50777,50777,48697,48696,48696,48696,48696,48729,48729,48696,50777,50745,48729,48697,48697,48729,48696,48696,48697,48697,48696,48696,48664,48664,48696,48664,48697,33906,19148,14923,21035,25131,16906,19148,25519,23406,25487,25454,23405,23374,25487,23341,23341,25454,23341,21261,23341,23373,21260,23341,23341,21260,23308,23341,27468,50612,42094,44240,42159,40046,44272,42160,40047,44240,40046,42127,44305,40046,42160,44273,40046,44240,44240,42127,44272,44240,42127,44272,42160,40079,44240,42095,40047,25355,19082,19050,19050,14889,14857,16937,14921,14921,14889,14857,14889,12841,14955,8583,21163,48564,48499,46419,42226,19050,8550,25421,29647,17002,27534,17002,21261,12809,14954,6535,8615,8615,14922,19082,48629,48564,54870,56951,54837,40012,50577,46352,44339,16936,23274,21192,21096,27435,35854,29545,25320,52757,57017,52758,52790,52790,50677,42160,40080,27467,19046,12773,8580,16998,38032,29548,27469,27533,25389,23276,33872,23339,6500,6467,10692,10692,8612,12772,10724,12804,14885,10724,8612,8580,6500,6436,4355,12742,14823,16903,19048,16935,14856,14856,16969,23243,16969,14888,12775,10630,10631,10663,10663,10663,10663,8550,6469,6470,6470,6502,6502,8550,8583,8551,12776,21196,14889,12711,29549,21129,12710,14823,25355,23243,21162,69},
{44568,44569,46649,46616,46649,46616,46681,46649,46649,46648,46649,48697,46649,48697,46649,48697,48697,48729,48729,48729,48696,48697,48729,48729,48729,48729,48729,48729,48729,50777,50777,48729,48729,48696,48696,48696,48696,48696,48697,48697,48729,48697,48697,48696,48697,48696,48696,48696,48696,48696,48697,48696,48697,48696,48664,48664,46616,48696,33906,21228,14987,19051,23115,16873,19148,27600,25486,23406,25487,25486,25487,25486,25454,25454,25486,25486,23373,25454,23373,23373,25454,25486,23341,23341,25486,27501,50612,42127,44240,44272,44240,46353,44272,42095,44273,44207,42127,46353,42159,42159,46353,42127,44240,44272,42127,44240,44272,42094,44272,44240,40046,44240,44207,37935,25356,19082,17002,19018,16970,16970,19050,19050,16969,16970,16970,16937,17003,12842,8583,21163,48531,48531,50644,54872,29582,14889,19115,25454,19115,23341,17002,19148,10728,17034,10728,12809,8615,10695,19049,48629,52757,54902,54870,56983,56950,56917,48498,42193,16904,21194,19079,21096,27468,35886,37932,29578,52757,56984,52790,52790,52823,52758,42192,14854,6436,12805,16965,10724,27532,38000,19049,29581,27469,25356,31792,44404,19146,8645,10692,12837,14885,10724,14885,14949,14917,12837,10692,16966,16966,12740,12773,21128,29548,29516,23275,23307,19082,17034,17002,17001,25356,19114,17001,19082,23243,16936,12711,10630,6405,6437,6437,8550,8582,8550,8550,6469,8550,8550,8550,10696,17035,19083,14856,27468,25322,14790,19016,25323,23243,19050,39},
{46649,44568,46649,46649,46649,46649,46649,46649,46681,46681,46649,46649,48697,46649,46649,46649,48697,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,50777,50809,48729,48729,48697,48696,48696,48697,48729,48729,48729,50777,48729,48697,48696,48697,48696,48696,48696,48696,48664,48696,48696,48697,48696,48664,48696,48696,48697,33906,21228,12842,16938,23083,16906,19148,21261,25454,25454,23406,23373,25454,25454,25421,23341,25422,23374,21261,23373,23341,23309,23341,25486,23341,23341,25422,25421,42226,37999,38000,40080,40112,40112,40112,40080,42160,40112,40080,42192,40079,42128,42160,40047,42160,42192,40047,42160,42160,40079,44240,44272,42127,42160,40080,27435,23243,21163,21131,21163,21163,21163,21163,21163,19082,19083,19083,19082,19083,17002,16970,25356,48499,48531,50645,59228,46485,25421,23308,29680,27534,29647,23341,21261,19115,19116,10696,10696,6470,6470,16969,48565,50645,54870,54902,54902,52756,37966,42225,48531,19048,19114,19111,25353,27467,35853,40012,37965,48531,44273,50611,52790,54904,44338,19014,8548,2275,6403,12773,19047,40145,23308,16969,27501,25388,31695,42291,19015,10694,10726,14886,16997,16997,16997,14916,14884,14917,16933,21126,27433,27401,31595,33773,33774,31661,23275,16969,16969,14889,12809,12809,14889,19082,14921,14889,16937,23275,25355,21195,16937,10630,8550,4324,6437,8549,8550,10663,10663,10631,8517,6437,12775,21195,16970,14856,27468,23242,21129,25323,25322,23242,14889,17},
{46649,46649,46649,46649,46649,46649,46649,46649,46649,46648,46649,46648,48697,46649,46649,46649,48697,46649,48697,48729,48729,48729,48729,48729,48697,48729,48729,48729,50809,50777,50809,50777,48729,48696,48696,48696,48697,48696,48729,50777,48729,48729,48729,48696,48697,48697,48696,48697,48729,48697,48696,48696,48696,48696,48696,48664,48664,48697,35986,21228,14923,19019,23083,16938,19148,19180,25487,25486,27599,25453,25454,27567,25486,25421,25486,25454,23341,25454,23373,23309,23373,25454,23373,25454,23373,23341,23308,23341,21228,23308,25389,23308,25389,29614,25420,25388,29582,27468,25388,29581,23308,23308,25421,23308,23275,25421,25388,29548,31627,48498,42225,27435,23243,19050,23243,21162,21130,21130,19082,19050,19082,19050,19050,16970,16970,17002,21163,19050,10664,23276,48531,48498,52790,59196,35921,25389,25454,31760,27567,29679,25422,25422,21261,21228,10696,8551,6470,8582,16937,42193,46451,56950,56950,44272,16902,8549,10662,19081,14855,19081,19046,25353,27467,35853,37931,40078,46418,39980,50546,54871,50678,19046,14853,6436,4356,4356,4291,23274,42258,27501,25356,27469,27501,44437,29581,12709,10662,10662,10694,12806,14918,19079,19079,19079,25353,31627,33739,35852,35853,33773,31661,27468,25356,17001,12809,12809,12777,10728,12809,12809,14889,12776,12776,12776,19017,21130,16969,12776,10663,10663,10663,8582,8517,6437,8550,8550,8550,12743,8550,16968,27501,14856,16936,25323,16903,25323,25290,25323,23243,14857,15},
{46649,46617,44568,46616,46616,46649,46616,46649,46649,46649,48697,46648,46649,48697,48729,48729,48729,48697,48697,48696,48729,48729,48729,48729,48729,48697,48697,48729,50809,48729,48729,48729,48729,48697,48696,48696,48729,48696,48729,48729,48729,48729,48729,48696,48696,48697,48729,48729,48697,48697,48697,48696,48696,48696,48696,48664,48696,48729,33906,21228,14955,16938,23083,16938,21229,25519,25487,25454,25486,25486,25454,27599,25454,23373,27599,25422,23341,25486,25454,23341,25454,25454,25421,25486,23373,23308,23309,25454,23309,25389,29614,25389,27501,29614,27501,27501,29647,27501,25421,27534,23340,23308,23341,21228,21195,23308,23340,25388,27403,44370,42225,23275,19083,19050,21163,23275,23276,23275,25324,23243,23243,23243,23243,21131,21163,21163,19050,25357,23308,23308,48499,48498,50645,50711,25357,25422,25421,29680,29680,29680,25454,23374,21261,23341,14922,12809,4357,8583,14888,33741,46418,52691,48562,21160,6468,6469,4389,6469,10695,16936,16934,23241,29516,35886,31625,40079,44273,40045,50643,54871,40177,19078,14917,10661,6436,6436,6404,38000,37999,27501,27501,27501,38098,36017,25354,25420,14888,8549,8549,10662,12808,17001,21162,23274,27468,33709,33741,33741,31629,29516,29516,27436,23275,17002,14889,14889,12777,10728,10728,12809,16970,12744,10695,12776,16969,19082,16969,12776,10663,10663,10663,10663,12776,10662,10630,8582,6437,8517,10630,23242,29581,21195,21195,27469,23242,25323,23242,25323,23243,14889,13},
{46617,46617,46616,46649,46649,46616,46616,46649,46649,48697,48729,46649,46649,48729,48697,48729,48729,48697,46648,46648,48697,48697,48697,48697,48729,48696,48729,50777,48729,48729,48729,48729,50777,48697,48696,48696,48697,48729,48729,48729,48697,48729,48729,48696,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,35986,21228,14922,16938,23083,16938,21261,27632,25487,27567,25486,25421,25421,25454,23373,23341,25454,23341,21261,25454,23341,21228,23373,25421,21260,23373,23341,21228,23308,23308,21228,23308,27501,23308,27501,27534,23308,25388,27534,23308,25388,25421,23276,21195,23308,21195,19115,23373,23308,25388,25323,38032,35919,23243,19082,19115,23243,23276,23276,23275,23275,23275,23275,23243,21163,21163,21163,21163,19050,21195,14857,25355,46418,48466,48532,44372,29648,29647,27567,29647,29647,27567,23373,25454,21261,21261,12841,10761,4389,6502,14856,42225,52723,48464,33738,14885,10694,6469,6436,10631,12808,6469,6500,23241,27467,31628,35852,42192,37934,40014,50644,54871,35885,21190,19110,12806,4323,4323,19048,46418,33742,31694,29549,31695,36017,14855,21096,14855,10694,6469,6436,6469,12808,14921,21195,25388,27403,29581,31629,31629,27468,27436,29548,27468,25355,19082,14857,12809,12809,12776,10728,14889,17002,12776,10696,12776,14889,14889,14856,12744,8615,10663,8583,8550,10663,10695,12808,12743,8550,8550,12743,25387,25323,23275,23372,25420,27436,27371,23210,25322,23242,19050,21},
{44568,46617,46649,46616,46649,46649,46649,46649,46649,46649,46649,48697,48729,46649,46649,48697,48729,48729,48697,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48697,48696,48697,48729,48729,48729,48697,50777,48696,48696,48696,48696,48697,48697,48697,48697,48664,48696,48696,48664,48696,48664,48729,38099,21196,14955,18987,23050,16938,21229,29680,25487,27567,29647,25454,25486,27567,25486,25454,27567,25454,23373,27567,25454,23373,25486,25486,23341,25454,25454,23341,25453,29581,29581,29581,31662,29581,31662,31694,29582,29582,29614,29549,29581,29614,27501,19115,19115,17035,17002,21228,19115,25356,27403,42225,38033,21195,17034,19115,25389,23276,23243,23276,25324,23275,23275,23243,23243,21163,21163,21163,23276,19082,19082,27468,48531,48531,50612,46484,25421,29648,27567,29647,29647,27567,25454,25454,21228,17035,8583,6502,4389,6470,16969,42193,52724,52658,33803,16998,12806,6469,6437,10695,17001,10661,12806,21128,27467,31627,35820,44338,33741,35789,52789,52822,33772,21158,17030,8548,4355,10628,35951,42193,33774,31662,29646,40211,23307,8548,14855,10661,10694,6436,4388,6468,10727,14921,21194,27500,29580,31629,31629,31661,27468,27436,29581,27468,25324,17002,12809,12809,12808,12809,12776,14889,19050,14856,12744,14857,16969,14889,14889,10695,8583,8583,8583,8550,8550,8550,8582,10663,12743,14823,21162,25355,23275,21195,23340,16968,27404,25323,14823,23210,23210,21194,43},
{46649,46649,46616,46649,46649,46649,46681,46681,46649,46649,48729,46649,46648,48697,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48697,48697,48697,48697,48729,48697,48696,48696,48697,48729,48729,50777,48697,48697,50777,48697,48697,48696,48729,48696,48696,48664,48696,48696,48664,48696,48729,33906,21228,12874,16938,23083,16906,21261,27599,25487,25486,25454,23373,23373,25486,23373,23341,25454,23373,23341,23373,23341,23308,23373,23373,21261,23341,23341,21260,29646,33807,33741,31694,33774,33774,33742,33774,31694,33742,31694,31694,31694,31694,31662,14889,8615,10696,8648,8616,8616,21130,27403,44339,35952,21163,17035,19083,23308,23243,23243,23243,23243,23243,23243,21163,21163,21130,21163,21130,25356,21163,12776,23242,48531,50644,50613,44274,23276,29680,27567,27567,27567,27567,25422,25454,19116,19148,10728,10761,4389,4422,19049,40112,50610,52690,33771,16998,12806,6469,4356,8581,14951,14918,10661,21129,31628,37965,42125,54870,44243,50612,54838,54903,31691,19077,14917,6468,4356,19080,48499,37966,33807,29614,25452,19178,8516,6436,4323,4388,8581,4356,4388,6468,8581,12808,21194,27468,31629,33774,33774,33742,25355,25388,29581,27436,25356,17002,14889,14889,12809,12809,10728,14857,17002,12809,10696,14889,17002,14921,14857,10696,8550,8583,8550,6502,6470,8583,8550,8550,10630,16969,23242,25323,23275,21195,23243,25323,27402,23176,12710,14823,14824,14823,51},
{46649,46649,46616,46649,46649,46649,46649,48729,48697,46649,46649,46616,46649,48697,48729,48729,48697,48697,48729,46648,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48696,48729,50777,48729,48696,48696,48697,48729,48729,50777,50777,50777,48697,48697,48697,48696,48696,48696,48696,48664,48664,48696,48696,48696,48664,48664,31760,21228,14955,18986,23083,16906,21261,27632,25454,25486,25486,27566,25486,27567,27534,23373,25486,23406,23341,25454,25421,21292,23373,25453,23341,23373,21260,21260,31759,25388,23275,25355,25388,27436,25356,23308,23307,25356,25356,27468,25388,27468,25388,14889,10696,12809,12776,10728,8616,19049,25355,35952,25388,19082,19115,19082,23308,25356,25324,25356,25356,25323,25324,23276,23275,23243,23243,23243,21163,23244,19050,27436,48498,50645,57082,54904,40146,31792,19115,19115,19115,19115,17067,17035,14922,21261,14889,12841,6501,8614,14887,40144,52756,54804,42158,16966,8581,10662,6436,8549,19079,17030,8581,23242,31661,35917,40077,52725,56920,54871,52823,54903,33804,21190,16997,8580,4323,27467,48498,37934,33807,29613,14888,6436,6468,6468,4324,2243,6436,6436,6468,6468,8581,10694,23242,29548,29581,31693,33742,31694,23243,23275,29549,29549,25388,17002,14889,12809,12841,12776,10728,12808,17001,12776,12776,14889,19050,16969,12808,10695,8583,8583,8583,6502,6470,6470,6437,8550,8582,12743,19081,23243,21162,21130,16904,25323,29449,23143,21096,21097,19017,16936,56},
{46649,46616,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,48729,48729,48697,48697,48729,48697,48697,48729,48729,48729,48729,48696,48729,48729,48697,48729,48729,48696,48696,48697,48696,48729,48697,48729,48697,48729,48729,48697,48729,50777,48697,48697,48729,48696,48696,48696,48696,48696,48696,48664,48696,48696,48696,46616,48664,48664,31761,21164,12874,14858,16906,14858,21261,27632,27567,27535,27534,27566,27566,27567,25486,23341,25454,25454,23341,25454,25454,23341,23373,25486,23373,25454,23341,23308,29647,12808,12841,14857,14889,16969,12808,10696,10728,14857,16937,16970,14857,14857,12776,12809,12808,21162,21130,23275,10663,21162,23210,21162,21163,21163,19115,19083,23276,25356,25356,25356,25356,25356,25388,25356,23275,23275,23275,23276,21163,19082,12744,23275,48499,52758,59196,54936,40211,31824,17002,12777,12809,12777,10729,10696,10728,14890,12808,14919,10694,16966,21127,38031,54804,54869,42159,12773,8549,8549,10694,10694,16999,19078,12741,25322,31661,35885,40044,52725,48499,50611,54871,52823,31723,21158,14853,8613,8516,40112,42192,37935,33774,40178,35985,10693,8581,6468,4388,4323,4323,4356,6468,6500,8613,10694,21128,25322,29580,33774,33774,31661,21162,23275,29581,29581,23276,14889,12841,12809,10728,10728,10728,12809,17002,12776,10696,12776,19050,16937,12808,10695,8615,8583,8582,6470,6470,6502,6470,6437,6470,10695,16937,21195,21162,23243,18887,14693,16903,23177,23209,23177,21097,21162,64},
{46649,46649,46649,46649,46649,46649,46649,46649,48697,46649,46649,46649,48697,48729,48729,48697,48729,48729,48696,48696,48729,48729,48729,48729,48697,48729,48697,48697,50777,48729,48697,48729,50777,48729,48697,48729,48696,48697,50777,48697,48729,48729,48729,48729,48696,48696,48696,48696,48696,48696,48696,48696,48664,48697,48696,48664,48696,50777,35986,25389,14922,12874,10761,12875,21229,27600,27535,25486,27566,25486,25454,27534,25421,25454,25486,23374,23374,23341,23373,23341,23341,25422,23341,25454,23309,21228,29615,17002,14889,14889,12808,17002,14889,14889,17002,16969,14889,17002,14889,16970,16969,14889,17002,23275,23242,25356,10631,21162,21130,19050,21163,21195,21195,19082,23243,25324,25324,25323,25324,25324,25356,25324,23275,23275,23243,21195,21163,21195,16970,25356,48499,52791,57082,52790,38065,33905,27534,27534,25454,25422,21228,21228,17003,14889,19080,16966,12774,12774,21127,42160,56949,56982,33771,14854,12774,8581,8581,10662,16967,21191,19046,27434,31661,35884,40077,54935,35854,44272,54935,46483,25352,21158,14917,6500,16903,48530,37934,33742,35920,48663,40211,8580,14886,12773,6532,6532,4388,4323,6436,6500,8581,10693,19079,23208,23274,25388,27468,23274,14856,19082,27501,27501,23275,14921,12776,10696,10696,10696,10728,12809,14889,10663,8615,8582,10695,6437,4324,6469,6502,8550,8550,6470,6502,6502,6470,8518,8550,10630,12743,14856,19049,31727,16904,8484,12710,16871,16871,12710,19016,19081,58},
{46616,46616,46649,46616,46649,46649,46649,46681,48697,46649,46649,46649,48697,48729,48697,48697,48729,48697,48729,48697,48729,48729,48729,48729,48729,48696,48729,48697,48729,48729,48729,48729,50777,48729,50777,48729,50777,48697,48729,48697,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,48696,48664,48696,48696,48729,38099,27502,17003,12842,10730,12810,21261,29680,27535,27534,31760,27566,27566,29647,25453,31793,31825,31826,33874,31794,31793,31793,29713,31793,31761,29713,31793,31729,38034,25356,14857,14889,14889,16969,14921,16969,19115,16969,14889,17002,16970,16969,16969,16937,19082,23275,23242,25356,10663,23243,21130,16969,21195,21195,21196,19115,21163,21130,21130,21130,21131,21098,21130,21163,19082,19082,19050,16969,21163,21195,12744,23275,48531,50677,48597,46419,33839,31760,29647,29680,29680,29647,25454,25486,25389,25290,21159,19046,14918,19079,23272,29546,33773,35885,27466,14854,12806,8614,4356,6469,16967,21191,19078,25354,29580,35885,42190,54903,33708,46418,54870,46450,31691,21158,14917,8579,27467,46418,29483,25323,44371,50776,25420,12709,23207,21127,10693,8645,4420,4356,4355,6468,8581,10725,16998,19047,21161,19081,23241,19015,14823,21162,27468,27501,23276,12776,10728,12809,10696,8615,8615,6469,6469,6469,6436,4323,4291,2178,2146,4324,8550,8550,6470,6437,6470,6470,6437,6405,10631,10631,12776,16936,16969,16969,21162,21129,25290,23177,23177,23209,23242,19049,57},
{46616,46649,46649,46649,46649,46617,46649,46649,46649,46649,46648,46649,46649,48697,48697,48697,46648,48697,48729,48729,48729,48697,48697,50777,48729,48697,48729,48729,48696,48697,50777,50777,48729,48729,48697,48729,48729,48729,48696,48697,48729,48729,48696,48696,48697,48729,48696,48664,48729,48696,48664,48696,48696,48696,48696,48696,48696,48697,42292,33808,29550,27502,27503,25389,40114,46452,46420,44372,40114,33840,33808,33808,31695,33873,31793,31826,27568,31793,31826,29745,31793,31793,31826,31826,31761,27340,31630,21195,14890,14889,16970,17002,14889,17002,19082,16969,16969,19082,16969,19050,19050,16937,19050,23275,21162,23275,10663,23275,21130,19050,21163,23244,21196,21196,19083,25356,23243,23243,23243,23276,23243,23243,23243,21195,19115,17002,19115,19083,17002,27469,46418,37999,52823,48564,31727,29680,27567,27567,27566,27567,23341,23373,21130,31433,25320,19078,19079,21160,27498,19047,12678,19015,25321,21159,14886,8581,4324,6469,16935,16966,10628,27435,31661,35884,44304,52790,31595,48531,52823,54903,37998,21190,14885,12741,42192,42192,29516,31661,50743,46517,14855,19048,23240,21127,10693,10725,4420,4324,2275,4355,6500,12806,19047,16998,16967,19048,23240,16935,14888,19082,27501,29581,19082,12809,10728,10696,8583,8583,6469,4323,4356,6404,2211,2210,2211,2210,4291,6437,8550,6469,8518,6437,6470,6437,4324,2179,6437,10663,14824,16937,14856,12744,14889,16904,27435,25290,23177,23210,25290,16969,60},
{46649,46649,46649,46616,46649,46649,46649,46649,48729,46649,46648,46649,48697,48697,48729,48697,48697,48729,48729,48729,48761,48729,48697,48729,48729,48697,48729,48729,48696,48729,50777,50777,50777,48729,48696,48697,48697,48697,48729,50777,48729,48729,48697,50777,50809,50809,48696,48696,48729,48696,48696,48696,48696,48696,48697,48697,48696,48696,50776,52823,57050,57082,57050,57050,57018,57017,54969,54969,54969,54969,54969,54937,57018,40179,31761,31794,27567,29713,29745,31826,31794,27600,25487,29681,25390,23179,19018,12776,17002,12809,14889,12809,12776,14889,17002,16969,16969,19082,16937,17002,19082,16937,16969,16969,16937,19050,10663,23243,21130,19082,23276,29647,29647,27535,21195,21130,19050,19018,19050,19050,19018,19050,19050,19050,14921,17100,17101,17068,14857,27468,35854,35854,52823,46419,27500,27567,19115,17002,19115,17034,19115,17002,27273,35528,18983,12774,10630,12774,19048,12775,8517,10630,19048,23305,12805,8646,4356,6437,16967,12741,8516,29515,31661,33771,46417,48564,31595,52757,54871,54903,35854,21126,12804,16966,48498,40047,35854,44339,54969,38000,23210,23242,21096,14854,10693,10725,4388,2275,4356,6436,6500,12806,19079,19046,14821,18983,27401,25355,16969,19082,21195,21195,19115,12776,8550,6470,6501,6502,4356,4323,6436,4291,2211,2211,2210,2178,2178,6404,6469,8582,8517,6436,8549,8550,6404,4291,6404,10663,14856,14889,14856,14889,21228,12743,21097,25355,25290,23209,23210,16937,66},
{46649,46649,46649,46649,46649,46649,46617,46649,46649,46616,46649,48697,48729,48729,48729,48697,48697,48729,48696,48729,48729,48729,48729,48697,48697,48697,48729,48729,48729,48729,50777,50777,50777,48697,48729,48697,48697,48729,48729,48729,48697,48696,48696,48728,50777,50777,48729,48696,48696,48696,48696,48696,48696,48696,48697,48696,48696,48696,52824,50742,57082,57082,57050,57050,57082,57082,57083,57082,57082,57050,57082,57082,57082,42259,31793,31794,27568,29681,31794,31794,31826,23342,12843,17004,25454,23244,19083,12809,14921,12809,12809,10728,12776,12809,14889,14889,14889,17002,14889,14889,16969,12776,14857,14889,14889,16969,12776,29581,21130,19082,21195,29680,29680,27599,23275,25323,23275,23211,21163,16937,19017,19017,19018,19017,19050,23309,21228,19148,10664,21162,27434,50678,50645,48499,29614,27567,25389,19082,23308,19115,23308,19017,31368,39656,14790,8550,8550,12710,12807,8549,6469,8517,14854,16998,10725,8581,4388,8549,16935,14854,10629,27467,31628,35884,48563,46451,33675,54870,52823,52790,27434,16965,14852,31660,46418,40047,40080,52823,50743,31726,40113,42193,23273,12773,8613,8612,8581,6436,4388,8581,8613,14918,19079,19014,16935,21095,31660,23242,6437,6404,2210,6469,12743,8550,2243,2243,6436,4356,4323,6404,4323,4291,4291,2210,2210,2210,4291,4324,4324,8550,8517,6404,8549,6469,6469,6437,8550,10663,14856,14889,12776,21228,25486,14889,12775,19081,23242,25323,21097,12776,58},
{46616,46649,46649,46649,46649,46617,46649,46649,46616,46648,48729,46649,46649,48729,48697,48729,48729,48729,48697,48729,48729,48729,48729,48697,48697,48729,48729,48697,48729,48697,50777,50809,50777,48729,48729,48696,48729,48697,48729,48696,48696,48696,48696,48729,50777,50777,48729,48664,48696,48696,48696,48696,48697,48697,48697,48697,48696,48697,52856,50710,57050,55002,57050,57050,57050,57082,57050,57050,57050,57082,57050,57115,57082,42324,31793,31794,27600,29713,29745,29713,29713,25455,19181,23342,31760,21195,21195,14889,14921,12809,12809,12809,10728,12776,12809,12777,12809,14921,14889,14889,14889,12776,12809,12809,12776,12776,12744,33775,21162,19050,23275,33873,33938,31792,25420,27468,25356,21130,27436,23243,23243,23243,21163,16969,19050,23309,23276,19148,10664,16968,27467,57115,52791,50677,42259,27534,25421,23340,29614,23276,25421,21098,37641,39688,16871,10630,10630,10662,10662,8549,8550,16967,25353,21191,12773,4388,6436,8549,14855,19079,19112,33742,31661,37965,50643,48564,39981,54903,52855,50677,21160,16965,14885,42224,44272,40079,44339,55001,38065,4355,8548,14854,21127,12805,10693,6532,8581,6501,6500,8645,10725,19079,23240,23208,16967,25354,27500,6436,2211,2210,4323,4291,2243,2211,2210,2243,6436,4291,4291,6404,4356,4291,4291,2211,4291,4323,4323,2243,4291,4324,4356,6436,8517,6437,6437,6469,10662,12711,14856,14856,12776,14856,21228,16937,12743,14856,16937,21130,19050,14856,65},
{46616,46649,46649,46649,46616,46649,46649,46649,46616,46648,48729,46649,46649,48729,48729,48697,48729,48729,48729,48729,48729,48697,48697,48697,48729,48729,48729,48696,48729,48729,50809,50809,48697,48729,48697,48696,48729,50777,50777,48729,48697,50777,50777,48697,50777,50777,48696,48696,48697,48696,48696,48696,48696,48729,48696,48664,48696,48696,50808,52791,57050,57050,57050,57082,57050,57050,57050,57050,57050,57082,52824,50711,48631,35953,31793,31793,27600,29713,29713,27632,31794,31858,33907,31826,33905,21195,21227,14889,17002,12809,12809,10728,10696,10728,12777,12777,12776,14921,12808,12776,12809,10728,10728,10728,10696,10696,8616,19114,19082,19082,23308,35986,35986,33905,27469,23275,21162,19049,31661,33742,33742,31596,29483,25258,27371,29516,29484,27436,19016,25322,37966,59228,52823,50710,44340,25421,23341,21228,23341,21195,23276,21130,39721,39656,18919,12711,10630,14823,12774,12742,8549,12742,21159,25319,19078,10693,6436,8581,14855,21193,25419,38033,29580,35820,50709,54903,44239,54871,54903,50677,23271,17029,23272,48530,40047,40079,48630,54936,25419,8548,10661,12741,19078,12805,10693,10693,6500,4355,6500,8645,12805,21127,25321,25321,14854,14855,10629,2243,2210,4323,4356,2243,2243,2211,2211,4323,4355,4291,6404,6436,4356,4323,4291,2210,4291,6404,4323,4291,4291,4291,4291,2211,6404,6436,6437,6437,10630,16969,16937,14856,12743,10630,14824,16937,14856,12743,10663,12776,16969,14856,72},
{46649,46681,46649,46649,46649,46649,46649,46616,46649,48697,48729,46649,46649,46649,48697,48729,48729,48697,48697,48697,48729,48696,48729,48729,48729,48729,48729,48729,48729,48697,48729,50777,48729,50777,48729,48729,48729,50777,50777,50777,50777,50809,50777,48696,48728,48729,48729,48696,48696,48696,48696,48664,48664,48664,48664,48664,48696,48696,50776,50710,57050,57050,57050,57050,54970,57050,57050,57050,55002,57082,50678,38099,36018,29647,31826,31794,27600,29713,31794,31826,31793,25487,21261,17035,29647,23275,21195,14889,17002,12809,10728,10728,10696,10728,12776,12776,12809,16970,12776,12776,12809,10696,10696,10696,10664,8583,8583,14857,17002,19082,25388,35986,31792,31792,25356,23243,19082,19049,29549,31629,31597,35757,44110,46125,48204,48237,50351,52561,42062,37901,42192,54937,54936,54936,40114,27502,27567,27534,27534,25422,25390,25356,37641,31368,16839,12678,14790,21160,23240,21160,8581,12742,21127,37998,23271,14885,10693,14822,16935,21194,21226,33807,29580,27434,52758,52790,46352,54903,54904,48532,19046,19078,31691,48530,40014,42192,52888,52823,25355,10596,19047,16967,16934,12774,6500,10693,6468,4387,6500,10693,14854,21127,29514,23209,10662,4388,4356,4291,4291,4291,6404,2210,2243,4291,2210,6404,4323,4291,6436,6436,6436,4323,4323,2243,4323,6436,4291,2211,2211,4291,4291,4291,4291,4324,6404,6437,10630,19049,16969,14888,12775,8550,12743,14888,14856,14889,14889,10631,14856,14889,70},
{46649,46649,46649,48729,46649,46616,46649,46649,46649,48697,48697,46649,46649,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,50777,50777,50809,48729,50777,48729,48729,48729,48697,50777,50809,50777,50809,50777,50777,50777,48696,48729,48696,48696,48697,48696,48696,48696,48696,48696,48664,48696,48696,48696,50711,57050,57050,57050,57050,57082,57050,57050,57082,57082,57082,48598,42325,36018,31728,31761,29713,31761,31761,29616,23277,17002,12809,10697,12777,29582,23275,21163,12809,12841,12809,10728,10761,10728,10728,10728,12809,12809,16970,12776,12776,14889,12777,12809,10696,10664,16938,8583,14889,19050,19082,23341,33905,33873,31792,25389,25356,25356,23243,25324,29484,31565,31564,31532,31532,29419,31499,35660,37902,35758,33677,42257,48565,48564,57017,38000,29615,29679,29647,27534,25422,23341,27404,37641,33480,29319,29352,21063,23240,25385,21160,6468,14822,27433,44305,29580,8613,10725,21128,19016,21194,16968,33774,31628,35853,52790,50644,46385,56984,54904,44306,19014,19110,40143,44272,37966,46452,57082,33807,4226,18982,29513,23241,12773,8613,6532,8613,8581,6500,8613,12838,14886,19047,25321,23209,8581,4388,4291,4291,6404,4355,4323,2211,4291,2210,4355,6436,2243,2243,4291,6468,6468,4323,4356,4291,6404,4323,4291,4323,4291,4291,4291,4291,4291,2243,4291,6404,8549,16936,14888,14888,12776,10663,12776,14856,14856,21260,25422,10631,12776,14888,62},
{46616,46649,46649,46649,46649,46649,46649,46649,46616,46649,46649,48729,48729,48697,48697,48697,48697,48697,48697,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,50777,48729,48729,48696,48729,48729,48697,50777,52857,50777,50777,50777,50777,48696,48696,48696,48696,48696,48696,48664,48696,48696,48696,48696,48664,48696,48696,48664,48664,52889,54969,54937,52889,52889,54969,52889,54970,52857,52856,54969,59163,42129,40113,42291,44340,42259,42226,40113,38001,38000,38033,38000,38001,38001,19050,19115,10728,10728,10761,10729,10696,10696,10728,10728,12808,12777,12809,12776,12809,12809,10696,10696,10696,8615,29517,25356,21195,19082,21195,21196,21195,19115,19147,21228,21131,25324,27437,29485,27436,33710,33710,31630,31565,27372,29453,29517,25388,21162,33741,44305,54871,46418,57017,38097,27567,29647,27567,25454,21260,21228,27403,45895,45993,41963,27304,12678,16903,21127,16935,6436,14822,21127,42192,35919,10661,8613,12774,16936,21194,16935,31660,31692,40110,52789,42127,40047,54935,52823,37999,16966,23303,46450,42159,40079,52791,54969,16968,4291,12773,12773,21193,21160,10693,8613,8581,8645,8613,8613,14886,16966,21160,19015,23306,8581,4356,4323,2211,4323,6468,4356,2211,2211,2178,6436,6500,2243,4356,6468,8580,6435,4323,2243,4356,6436,4355,4323,4291,4291,2211,4291,2211,2211,2210,4291,4323,6372,10630,12807,14856,12743,12743,14824,16839,14791,19115,25421,12743,12776,12743,46},
{46616,46649,46649,46649,46649,46616,46649,48697,48697,48697,48729,48697,46649,46649,48697,48729,48697,48729,48729,48729,48729,48696,48729,48761,48697,48696,48697,48729,48729,48729,48729,50777,50809,50809,48696,48729,48697,48696,50777,50809,50777,50776,50777,50777,50777,48696,48697,48696,48696,48696,48664,48696,48696,48696,48696,48696,48664,48664,48696,48729,48696,48664,48664,44503,40277,38230,36117,36084,33971,38132,54970,59196,48499,52790,48564,50644,50612,48564,50645,48596,50644,50677,48564,50645,44306,21130,19115,12777,10729,10728,10729,10696,10728,10728,10728,12809,12809,12809,12809,12777,12809,10696,10696,10696,10663,31597,35888,27534,19082,21228,21228,21196,19115,17035,19083,29550,40016,40049,37936,29517,31630,33710,31630,31598,27437,25292,23276,12776,16969,33709,48532,48532,44306,57049,35985,25389,23308,23309,19115,17035,16970,21065,41637,45992,39981,12678,12711,16904,21095,19079,12741,16934,27400,38031,31725,12773,12837,10693,16936,21194,21128,31660,31692,40143,52757,37933,42128,54936,52790,29578,12740,29546,48530,42126,44273,57050,48598,10629,10693,12773,8548,8581,16967,10694,6469,4356,6468,8581,10693,14886,19080,16967,8548,10661,8549,4323,4291,2210,4323,4356,4356,4323,2211,2178,2243,6500,2243,4355,8548,6500,4355,4291,4291,6436,6468,4355,4323,4291,4259,4291,4291,4291,4291,2210,4259,4323,6372,4323,8549,12743,12743,12743,14823,14758,14856,10663,12743,12743,12776,12744,43},
{46616,46649,46649,46649,46649,46649,46649,46648,48697,48729,48729,48697,46648,48697,48697,48729,48729,48697,48697,48729,48729,48729,48761,48761,48729,48696,48697,48697,48729,48729,48729,50777,50777,48729,48697,48729,50777,50777,50777,50809,50809,50777,48728,48696,48696,48697,50777,48696,48696,48696,48664,48696,48696,48664,48697,48664,48696,48696,48696,48696,48664,48696,48729,44503,38197,36117,31957,31956,34004,38164,54969,59196,50579,52725,46451,48531,46451,46451,48564,46451,48531,48564,46419,48532,42194,21130,21163,10728,10728,10729,10728,10696,10696,10728,10729,14921,14889,12777,12776,12776,14889,12776,12776,10696,10663,31661,35888,31727,21162,23276,21228,21228,19115,17035,27502,42130,42161,40048,40016,40081,35823,37904,35823,31630,25356,19116,12842,10696,16937,33709,57017,54936,48532,48565,29581,27502,27502,23341,21228,19115,19083,18985,31270,46025,44239,14791,16904,19016,18983,21127,21160,21160,35851,44304,40143,27497,19110,12806,16936,19081,21128,31628,31659,44304,52724,37901,44273,54936,46515,25352,14820,33805,46385,40046,48532,57115,35887,4291,8548,14885,8612,8613,10693,10694,4388,4356,6468,8581,10661,12806,10661,2210,4291,8549,6501,4323,4291,4291,6468,4356,4323,4323,2210,2178,2211,8581,4355,6435,8613,8613,4355,2243,4356,6468,6468,6404,4291,4291,2210,4291,6372,6404,4323,4291,4291,4291,6372,4323,4323,6436,10630,12743,14888,14823,16937,10663,10663,10695,12744,12776,46},
{46649,46616,46649,46649,46649,46649,46649,46649,48697,46649,48729,48729,48697,48697,48729,48697,46648,48697,48697,48696,48697,48697,48729,48697,50777,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48697,48729,50777,50777,50777,50777,50777,50777,48729,50777,48696,48697,48729,48697,48697,48696,48664,48696,48696,48697,48696,48696,48696,48696,48696,48696,48696,48696,42423,36149,34037,34004,34004,36052,40244,54969,59196,59195,54904,48531,50644,48531,46451,48564,46483,46451,48564,46483,48500,46419,40080,35920,14889,10729,10729,10696,10696,10696,10696,10696,14889,14889,12841,12776,10696,14889,12776,12776,10696,10664,31661,35888,42193,25323,21163,21195,21195,19115,17035,27502,27502,27534,27502,27469,29614,29582,29550,27502,29550,25357,19116,17003,21163,21130,35854,59163,54904,48564,29581,25389,27567,27502,23309,21228,19115,19083,19017,22982,41931,40047,14791,19017,27468,21064,14758,14822,21095,40045,46385,46450,40111,21159,12806,14823,21193,27433,31660,29612,44337,52757,29483,46419,57016,52757,27465,14853,40144,44272,42127,52823,57082,21129,130,10596,16934,8548,10693,10693,8581,6468,4355,6468,8613,10693,10693,6436,4323,4323,8581,6501,6436,4356,4291,6436,4356,4356,4291,2211,2211,2210,6436,6436,4323,8548,8548,6468,4355,4323,6403,6404,4291,2211,4259,2210,4259,4291,4259,4291,4291,4324,4323,4291,6404,6404,6468,8549,10630,14888,14888,16936,12776,10663,10631,10696,10663,48},
{46649,46649,46649,46649,46648,46649,46649,48697,48697,46649,48697,48697,48729,48697,48697,48697,48697,48697,48729,48729,48729,48729,48697,48697,48697,48729,48729,48696,48729,48729,48729,50777,50777,48729,48729,48697,48729,50777,48728,50777,50809,48729,48664,48696,50777,50777,50777,48729,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48697,44503,38230,34037,31956,31956,34004,40245,40244,50744,57116,52823,46451,48563,48531,46451,48531,46451,46450,48532,46450,46419,48531,46451,48532,19050,10696,12776,10696,10696,10728,10728,10696,12809,12809,12776,10728,10728,12809,12776,10728,10664,10696,33742,35887,40112,23210,21163,21228,21196,19115,19115,19148,16970,12777,12777,12777,12809,14922,19148,17035,21196,19148,23341,27502,27502,25356,37967,57082,52823,48564,33775,25389,25421,25389,21228,19115,17002,17002,18985,18887,29418,46451,18984,14791,19017,18951,14758,16903,23241,29547,38031,42225,37966,21191,16967,12743,25417,29546,31692,27434,42224,46387,25258,48565,54936,52790,16936,12677,46386,42126,44273,54969,50711,8517,2211,18983,21063,4355,12774,16967,8580,6533,6500,8613,10725,12805,19080,8516,6371,6468,8613,4355,4323,4356,4356,6436,6436,4323,2210,4291,4291,2210,4323,6436,4323,6468,6468,6468,4355,4355,4355,4356,4291,2211,2211,4259,4291,4291,4259,2242,4323,4291,2242,4291,6468,6436,8581,10661,10661,14855,16968,14888,10663,12776,12743,8550,10663,46},
{46616,46616,46649,46649,46649,48697,48729,48697,46649,46648,46649,48697,48697,48729,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48697,48729,48697,48729,48729,48729,48729,48729,48697,48696,50777,50777,48729,48729,48729,50777,50777,48697,48697,48728,50777,50777,48728,48697,48697,48696,48696,48729,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,48696,44503,38230,34069,34005,34004,34004,38132,36051,50744,59196,54904,48499,48564,48564,46451,48564,48531,46450,48531,48531,46418,48531,46451,46420,17002,10696,12777,10728,10728,10728,10728,12841,12776,12776,12809,10728,10728,12809,10728,10696,10696,12744,35854,31661,25324,16969,21163,23308,23341,19083,19115,23309,21196,21196,21163,19083,21163,21163,23309,23309,23309,17002,17035,23341,23276,21130,35855,48598,48565,48532,33774,23309,23308,23276,21195,21196,21195,19050,16839,20935,27371,38032,18985,16904,29385,37639,31398,23143,23176,35853,37998,42257,31692,19111,21193,16968,23273,29546,33741,29547,44370,44306,27435,50678,54936,50710,12645,19016,46418,40046,48531,57082,38001,4259,4356,10629,8549,4323,14854,23273,6468,4387,8581,10726,10693,8581,10662,8516,4291,8581,8581,6404,4323,4323,4356,4323,6436,4356,2211,4291,4291,2211,4291,4355,6435,6500,6468,6468,4355,4355,6436,6468,4355,2210,2210,4259,4291,4291,2242,4323,4323,4323,2210,2242,4323,4291,6436,10661,12742,14790,23047,16936,10662,12743,12776,10663,8582,44},
{46649,46649,46649,46649,46648,46649,48697,46648,46649,46649,46649,46649,48697,48729,48697,48729,48729,48729,48697,48697,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48697,48729,48696,48697,48729,48697,48729,48729,48697,48696,48696,48696,48728,48728,48696,48664,48696,48696,48697,48696,48696,48697,48696,48696,48728,48696,48696,48696,48729,48696,48696,44503,38230,34069,31956,34004,34004,42325,38164,48598,57050,52823,48499,48563,48532,46418,48564,48532,46418,48531,48531,44370,48531,46451,42227,16970,10728,12809,10728,10696,10728,10696,12841,12809,10728,12777,10696,10696,10728,10696,10696,10728,12743,35854,29516,14857,17002,21228,23308,21228,19115,19115,33808,38001,35888,37969,38001,33808,33776,29550,29550,27502,17035,12842,12874,12777,12776,33741,54871,44370,46451,31694,23341,23341,25389,25421,27502,27534,25356,18887,18887,25323,38033,27272,25127,39752,58632,52361,33610,25257,40079,37998,42192,23273,16998,19047,16903,25353,29546,33741,31660,50644,42160,27403,52790,52823,31726,10596,31692,46353,40047,52758,57082,27467,10661,10661,8580,6436,4355,12774,16999,6436,4355,8581,10758,8581,4356,2243,4323,4324,8581,6468,6469,4356,4323,4356,4356,4356,4356,2243,4323,4324,2211,4291,6436,6468,6468,4323,6436,4355,6403,4323,6436,6468,8516,4291,2210,2211,4291,4323,4355,4323,4323,4290,4323,4355,4323,6468,10661,12742,12742,14725,14855,12710,12743,12775,12744,8550,38},
{46649,46649,46649,46649,46649,48697,48697,46649,46649,46649,48697,48697,48697,48697,48697,48729,48696,48729,48729,48697,48729,48696,48696,48729,48729,48729,48729,48729,48697,48729,48697,48697,48697,48696,48696,48729,48697,48696,48696,48696,48696,48696,48696,48696,48696,50777,48728,48696,48696,48697,48729,48697,48696,48729,48696,48696,50777,50777,48728,48696,48696,48696,48696,44503,38230,34069,34037,34004,36084,42325,38164,40211,54969,52791,46418,48531,48532,48499,46483,48531,46418,46451,48499,44338,46451,48531,35921,12777,10696,12809,10728,8648,10696,10696,12809,12809,10728,10696,10663,10696,10696,10696,10696,10696,12776,37934,29483,19017,17002,19115,21195,21196,19115,17035,23276,33775,31662,33743,35823,33775,31695,31663,27437,23244,14890,10729,12777,19050,14857,31596,52725,52757,52758,38000,25389,23308,23276,25421,27534,25453,27501,21065,18887,18952,37935,48269,46123,48203,46220,35756,31597,31597,40047,37966,40112,29579,21127,23241,16936,23272,27465,33773,29580,50677,44274,33676,52822,40112,10691,10691,40079,42159,42160,54937,52791,23273,17030,12805,10693,6500,6500,8548,10693,6468,4388,8613,10725,8581,4355,4291,4291,4356,8581,8549,8549,4356,6436,4324,4388,4388,4356,2243,4323,4324,4291,2211,4355,4355,8548,6403,6403,4323,4291,4290,6435,8581,8549,4323,2243,4291,4291,6404,4355,4322,2242,4323,4291,4291,4323,8549,10629,12742,14856,10629,10661,10629,12711,14824,14824,12711,40},
{46649,46681,46649,46649,46648,48697,46649,46649,46649,46649,46649,48729,48697,48697,48697,48729,48696,48729,48729,48697,48729,48729,48697,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48696,48697,48696,48696,48696,48697,48697,48696,48697,48696,50777,50809,50777,48696,48696,48696,48696,48696,48696,48696,48729,48696,48696,48696,48696,48728,50777,48696,48696,48696,44503,38230,34069,34037,34004,33972,36084,38197,40211,59195,52791,46418,48531,48564,48498,46451,48531,46450,46451,48532,46450,46483,48596,38033,14824,14857,12809,12744,10696,10663,10695,12809,12776,10696,10664,10663,10664,10663,10663,10663,10664,12743,40015,31596,21130,16970,21163,21228,21196,21196,17035,16970,27437,29517,31565,29517,29550,27502,23308,17002,14889,10729,12777,23211,29517,19018,33741,52757,48532,50677,42193,23275,19082,21163,25421,27502,27502,25389,14759,16807,16904,35789,48301,46220,46221,46452,54970,57083,52791,37933,35854,40112,40080,35886,33741,16935,21192,27401,35886,35854,54871,50645,35821,54903,46483,29577,21191,46418,40046,46386,57082,42226,14821,19110,12773,8580,8644,8580,8548,14919,10726,6500,10693,12806,12806,4323,4324,4356,4356,6468,6468,8549,6469,6468,4356,4323,6436,4355,4323,4356,4323,4291,4291,4323,4291,4355,6436,4355,4323,4323,4291,4355,4355,6468,4355,4291,4355,4323,4355,4323,4290,4290,4290,2210,2242,6436,6436,6436,8517,10662,10629,10694,8516,8549,12743,12743,12711,49},
{46649,46649,46649,46649,46649,46649,46649,46649,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48696,48696,48729,48697,48729,48729,48729,48729,48697,48729,48729,48729,48729,48697,48729,48729,48697,48696,48729,48729,48696,48696,50777,50777,48728,50777,50777,50777,48696,48697,48729,48696,48696,48696,48729,48729,48696,48696,48696,48728,48696,48696,48696,48696,44503,38230,34069,34037,34037,34004,34003,40245,38131,52856,52791,46451,48531,48564,48499,46451,48596,46418,42290,44371,42258,44338,44371,40177,35887,38001,33839,33807,35888,33807,33774,35887,31726,31694,33775,31694,31694,31726,31661,31661,33742,31661,42160,31596,19082,16969,19115,21195,21195,21196,19115,14922,17002,19018,23179,27437,25292,23211,23211,16938,14857,14858,23146,33645,29484,21097,46452,52758,50677,50677,33742,25356,23276,23308,25421,27502,27502,25421,19017,16904,23211,35691,50414,46253,44239,42357,55035,59163,46418,40046,35854,40080,40079,40079,33774,16935,16967,25353,35919,35854,48531,42192,35821,54935,52823,35885,25319,48498,40014,50677,54936,33806,16933,12837,8580,4420,6500,8645,8581,6500,8581,10661,8613,14919,14887,8581,4356,4356,4356,6501,6468,4356,6436,6436,4291,4291,6404,6436,6436,4356,4291,2211,4323,4355,4291,2210,4323,6404,4356,4355,6436,6436,4322,6468,4355,4323,4355,8516,4355,4323,4290,4323,4323,4291,4291,6436,4291,4259,4259,6404,8549,10694,6468,8549,10662,12743,12743,50},
{46649,46649,46649,46649,46649,48697,46649,46616,46649,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48729,48729,48697,48729,48729,48729,48729,48728,48729,48729,48729,50777,48697,48729,48697,50809,50809,50777,50777,50777,50777,48696,48728,50777,48696,48697,50777,48696,48697,48729,48696,48696,48696,48696,50777,48728,48696,48696,48696,48729,44503,40310,36149,34037,34037,34036,36084,38164,31890,38131,50710,46418,48531,48564,46451,46451,40145,27501,23341,23340,23308,23308,23340,23276,23340,25421,23340,23340,25389,25389,25388,27501,25388,25388,27501,25420,25421,27469,25421,25421,27469,33774,44305,29515,14889,17002,19114,19083,19115,19115,17035,14890,14922,14890,14857,16938,16937,18985,21066,23114,23114,23146,27339,29484,27436,23177,52791,54872,48564,44306,31694,27469,25389,25389,23341,27502,27502,25421,25421,25389,23308,39850,50414,48367,42061,40112,31726,33806,42224,40079,35886,40080,42225,37999,33774,16935,14886,29515,35853,35690,37933,35789,35854,54903,44338,21159,31691,46385,40046,52855,54936,35918,19110,14885,10693,6500,4355,6468,8581,6500,8613,10693,10693,14919,21193,10662,4323,4356,4323,6501,8549,6436,6404,4356,2243,2178,2211,6436,6436,4356,2211,2210,4355,4323,4323,4259,4324,2243,6404,4355,6468,6436,4355,4355,4355,4356,4323,8516,4355,4355,4323,4323,4323,4291,4355,6404,4323,4291,4291,6404,10630,10694,6436,8549,6468,8549,12710,48},
{46616,46649,46649,46649,46648,46649,46648,46648,46649,48697,48697,48729,48729,48697,48729,48729,48697,48696,48696,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48696,48729,50777,48696,50777,50809,50777,48696,48696,48696,50744,50777,48696,48697,48697,48696,48696,50777,48696,48696,48696,48696,48696,48728,48696,48696,48696,48696,48696,42455,38230,36149,34037,34004,34004,34004,36084,31890,38164,52758,46450,48531,48564,44339,33807,23276,19148,19148,19148,19116,19115,19115,19115,19115,19115,17035,17035,19115,17035,17003,17035,17034,19083,19115,19115,19083,17034,19083,17002,14922,27501,44305,23242,10696,19082,19082,19115,19115,19115,19115,17002,14922,14889,12776,12776,12744,10696,10663,12744,12712,12712,10631,12776,14856,19081,46485,46419,46451,48531,33774,23276,25356,21228,23309,27502,27502,25421,25421,23308,21162,41898,48333,46254,42028,29481,16902,10661,35853,37933,33773,37967,40079,40047,31661,16934,12773,29515,40047,48400,54804,37934,25289,50710,31724,14852,37998,44304,42224,54969,42291,8516,19078,16997,10692,6468,4355,4355,4388,12774,12806,12773,14887,10726,12775,6436,4356,4291,2210,6436,8581,6468,6436,4323,2211,4291,2210,6436,4355,4291,4291,4291,6436,4323,4291,4323,4355,2211,4323,6435,6436,8516,6436,4355,4323,4323,4355,6500,6435,4355,4355,4322,4323,4323,4355,4355,4323,4323,4291,6437,12711,14726,6436,6436,8548,8516,8516,45},
{46649,46649,46649,46649,46649,48697,48697,46649,46649,48697,48697,48729,48729,46649,46648,46648,48696,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,50777,48728,50777,50809,50777,50777,50777,50744,48696,48696,48696,48696,48696,48696,48697,48697,48697,48696,48728,50777,50777,48696,48728,48728,48696,48728,50777,48729,50777,50777,44535,38262,36182,34069,34036,34004,33971,34003,31891,40244,50709,46451,48531,42258,25421,21195,21228,19148,19115,19148,19115,17035,19115,19115,19115,19116,17035,17035,17035,17035,17035,17035,23341,25421,25389,25356,23276,23308,23308,23308,25388,27501,31694,25356,21227,23308,23308,23308,23308,25388,23308,25389,23308,23308,23276,23276,23308,23276,21195,19147,19115,19115,19050,19050,19082,23275,40114,40113,35952,40145,31694,27469,29549,19114,21228,27502,27502,25421,25389,23308,25323,44044,46254,42127,48498,48530,25320,16934,40013,40078,33773,40080,44241,35853,25353,16999,16966,31660,35853,48563,52724,33740,25289,50677,31723,21190,44337,44239,46451,57082,33839,6403,16965,19110,12805,6500,6436,4355,6468,25322,16999,12774,10694,4323,6468,6436,6404,4324,4291,4323,8581,8581,6468,4355,2211,2211,2243,6468,6436,4355,4323,4323,6403,4291,2211,4323,4323,2178,2210,6404,6403,4291,4291,6468,6468,6436,4355,6468,6467,4355,2242,2242,4323,4355,4355,6436,4323,4291,4258,10598,14791,10468,6372,6404,8516,6468,6403,40},
{46649,46649,46616,46649,48697,46649,48697,48697,46649,46649,48697,48729,48697,48729,48697,48697,48696,48729,48729,48697,48729,48729,48729,48729,48729,48697,48697,48729,48729,48729,48729,50777,50777,50809,50777,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,42358,33873,27534,29647,29647,29647,29647,29680,31728,29680,29680,29680,27567,27567,25487,25487,25487,25487,25487,25454,35920,52790,44370,33839,21227,19115,19115,19115,17035,17034,17035,17034,17035,17067,17035,17035,17003,17003,17035,14954,17003,14954,17002,29615,27469,21162,23243,14856,19082,19082,19082,21195,21162,21195,14856,21227,17001,19050,17001,17001,21195,14856,23308,14856,23308,21130,21195,25388,23243,25356,14856,23308,21195,29582,25355,29581,29581,29581,27501,25355,25388,31694,27500,44339,27501,19148,25454,25453,25421,23308,23276,27436,37804,29385,25224,27402,33708,23208,19047,42126,42191,33741,42160,42224,29579,19047,14886,12773,31660,33773,48531,48498,29547,25354,46483,25384,25384,46450,42127,50710,54936,25418,19077,12836,10724,10757,6500,6500,6468,8580,25353,19047,8581,4355,2243,6436,6468,6404,6404,6404,6436,6436,6468,6468,6436,4291,2210,2243,6468,6468,6468,4355,4323,4355,2210,4291,4323,4291,2210,4291,6436,6436,2242,4323,4323,4291,4323,4355,8549,10661,6467,4322,4322,4355,4322,4355,6436,4323,4291,2210,6371,4291,4291,6403,8549,8549,8484,6403,37},
{46649,46649,46649,46649,48697,46649,46649,48697,48697,48697,48697,48697,48697,48729,48729,48697,48697,48729,48729,48697,48729,48697,48729,48729,48697,48697,48729,48729,48729,48729,48729,48697,50777,52889,50777,52857,50777,50809,46551,40244,40212,38131,38099,36051,36051,36019,36019,38099,38099,38099,38132,33906,23341,23341,21196,21228,21228,21228,23277,25390,23341,23373,23342,23374,23342,23341,21261,21228,21229,21229,21196,21196,33775,46484,27501,19115,19148,17067,17035,17067,17035,17002,17035,17035,17035,17035,17002,17002,17002,17002,17002,17035,17002,14922,16970,31728,27469,23243,25356,21162,23275,23275,23243,23308,21195,23275,19114,23308,21195,21228,21195,21195,23308,23275,27501,21195,27469,25389,25356,27469,23275,27501,21195,25421,23340,27501,27501,27501,29549,29516,27469,25356,25388,29581,25388,42194,27469,19115,25454,27502,25421,23341,23308,21195,16872,18951,20999,20999,18951,14822,16902,42158,37998,33773,40112,44305,33805,23241,16999,16998,33740,33806,35854,44273,27403,23274,33836,21190,31691,40079,40046,52758,35950,21158,21189,16997,14949,12837,10692,8580,8580,10692,27466,16967,4355,4323,4323,6436,6468,4323,4324,4291,4356,6468,4355,6436,4323,4323,4323,4291,8548,6468,6468,6468,6436,6436,2210,2211,4323,2211,2178,2210,6436,6436,2242,2210,2210,2211,4291,4323,10662,10629,6403,8549,6435,6436,4356,6436,6469,6404,4291,4291,6371,6436,8549,6436,8549,6468,4323,6371,32},
{46649,46681,46649,46616,46648,46648,48697,46649,46649,48697,48697,48697,48697,48697,48729,48729,48729,48696,48729,48729,48697,48697,48729,48729,48697,48697,48729,48729,48729,48729,48696,48729,50809,52857,52857,52857,52889,40147,19115,21196,19116,21228,27632,27632,27632,27600,27600,27632,27632,27632,27600,27600,27632,29680,25454,25454,25454,25422,23342,23342,25422,23374,23374,23341,23341,23341,19180,21229,21229,21228,19148,19148,23308,23308,19148,21196,21196,19148,21196,21196,19115,19115,19083,17035,23276,25421,25420,25388,21195,21195,19083,17002,31727,42292,40179,44340,27468,21162,25323,19049,21163,23243,19049,23275,16969,21195,12776,21227,19050,19082,19082,16937,21195,14856,23340,16936,25388,21195,19050,25356,19050,25420,14856,23340,17001,25388,25388,25388,29549,27403,27468,19049,25388,23308,21130,44339,23243,19148,25422,27502,25453,23341,21228,19148,14889,12742,14757,18950,21095,16934,19047,40078,37998,35854,40079,44305,35886,27468,16999,19078,33740,33774,38033,42160,23209,25355,38063,23238,27433,25289,42192,54936,44370,21190,19077,14916,14917,14917,12804,8580,10660,14918,12805,4355,4355,4323,2243,8517,8549,4323,2243,2211,2211,6436,6468,8548,4323,2211,4323,2243,2243,6468,6500,6468,4355,4355,4291,2242,4355,2210,2210,2211,4324,4355,4323,2211,4291,4291,4291,4323,6436,4291,6404,12743,6469,12775,10695,8582,8550,8550,6469,6468,8516,6371,8484,6436,6468,4323,4291,4258,23},
{46649,46649,46649,48697,46649,46649,46648,46649,48697,48729,48729,46649,48697,48697,48697,46648,48729,48729,48697,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,52825,52857,52857,52889,44372,31663,27502,23309,25422,31793,31825,29745,29745,29745,29745,29745,29745,29712,27567,29680,29680,25454,23374,25454,25422,23342,25422,25422,23374,23341,23342,23342,23341,21229,21261,21261,21196,21228,21196,21196,19116,19116,21196,21196,21196,21196,21196,21196,19115,19115,21196,23276,29517,33710,31662,23276,25389,21228,17002,23276,31695,29582,40179,27501,25388,25356,21163,23275,25388,23307,25388,23275,25388,21195,25388,23275,23308,25388,23275,25388,21195,27501,23308,27501,25420,23308,27501,25389,27501,23307,25453,25356,27501,27501,29581,29581,27468,27501,23243,27469,25388,25356,35953,23276,19148,25421,27502,25453,23341,23308,19115,14921,8582,4356,8549,14887,14854,21128,40046,37966,35854,37999,44273,35886,31630,19112,19078,33708,35887,44339,42128,31660,27468,42256,21158,23208,29483,46451,57050,35885,16996,21222,19110,12804,8579,8612,8580,21128,21159,8579,4323,4356,4323,4323,4356,6436,4323,4323,4291,4323,6436,12773,10693,8548,4323,4323,4323,2243,4355,6500,6436,4355,4291,4323,6436,4355,2210,2211,2211,2210,4323,4323,4291,4323,4323,4291,6436,4356,4291,6436,8550,8518,14889,10662,10630,8582,8550,8549,8516,6436,6403,6371,4323,4323,4290,4258,4258,21},
{46681,46649,46649,48729,48729,46649,48729,48697,46649,48697,48697,48697,48697,48697,48697,48697,46648,48729,48729,48729,48729,48697,48729,48729,48729,48729,50809,48729,50809,48696,48729,48696,50777,52857,50777,52856,52857,46485,42161,42226,31727,23341,23373,23373,23341,23374,23341,23374,23374,27535,29680,23341,23374,23374,25455,25455,25454,25454,25454,25454,25422,25422,25422,23374,23342,23342,23309,23309,23309,21229,21196,21228,21196,21228,21196,21196,21196,21196,21196,21196,21196,19115,19115,19115,23276,29549,33742,31629,25356,25356,23276,19115,19050,21163,19050,38066,27533,23308,23276,16937,21163,25356,21162,25388,19050,23275,14889,21195,19049,19082,23275,19049,23308,14888,25388,14888,21227,19082,16969,25388,21130,27469,19049,23308,21130,25356,23243,27468,27468,19082,23308,21162,25388,29646,27469,23276,17002,17067,23341,27534,25421,25389,23308,19115,21228,12776,8583,10695,14887,6468,19048,37966,35886,35854,37967,42160,33774,35855,21192,23271,33772,40048,54871,54806,35820,23272,21191,19078,31628,33708,50677,57050,29580,19109,21222,19110,12772,6499,6435,6467,16934,19078,8612,6436,4355,4355,4356,4323,6468,6436,6404,4323,4291,4323,12806,12806,12774,8581,4387,4355,4323,4355,8548,4355,4323,4323,4356,4323,4323,4291,4291,2210,4291,4291,4323,4323,4323,4291,4291,6436,4323,4356,8517,6469,8550,14856,12743,8550,8517,8517,10662,8549,4323,6371,4291,4291,4290,4258,4258,4258,23},
{46649,48697,46649,46649,46616,46649,46649,48729,46649,46648,46648,48729,48697,46649,48697,48729,48697,48729,48729,48729,48729,48697,48729,50777,50777,48697,48696,48729,48696,48729,48729,48729,48697,48729,50777,50809,52857,46550,35920,29614,14922,17035,19083,19083,17035,17003,17003,17035,17003,19083,35920,35921,33840,33840,31663,31663,29614,29582,29614,31662,29582,29582,29614,29582,27502,27502,29582,27469,27437,27437,25356,25357,25356,23276,25324,25324,25324,25356,25356,25356,25356,23243,23276,23243,27436,29549,33710,31629,25355,27436,27436,23242,23243,25323,27403,40178,27500,23275,25356,19082,21195,25356,23243,27501,23275,23276,19082,23276,19082,21195,25389,23275,25421,21195,25421,21227,25388,23308,21227,27469,25356,27533,23308,25421,25388,27501,27501,29549,29582,27468,27501,27469,29581,29581,27501,21195,17035,19115,23341,27534,25421,25389,23276,21228,27534,23276,12808,14888,16967,14887,21129,35885,35886,33774,35854,42160,35822,27435,14886,19047,35821,40080,54870,48466,35787,23239,19110,23271,42159,40014,52823,54904,23240,19109,21190,17029,14917,14917,12772,10692,19111,19110,10692,6499,4387,6468,6468,4355,6436,6468,4356,4324,4323,2243,10660,10725,8580,6468,6468,6403,6436,6468,8548,4355,4355,6404,6404,6436,4323,4323,4291,2210,4291,4291,2210,4291,4323,4291,4323,8516,4323,4355,8517,8550,8582,14856,17001,4291,6372,6404,8516,6436,4323,4291,4291,4291,4291,4291,2210,4258,24},
{46649,46649,46649,46649,46649,46649,46649,46649,48729,48697,46649,48729,48697,48697,48729,48697,48729,46648,46648,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48697,48729,48697,48729,50777,50777,46550,35953,19115,12874,17035,17003,17003,17003,17003,14923,14923,14922,14890,37968,50645,48564,50613,44306,42226,42226,42226,42194,42194,40146,40146,42194,40113,40081,40081,40049,42161,37968,37903,37968,37968,37968,37967,35855,35822,35822,37935,35854,35790,35790,33741,33741,35789,35790,35790,35790,35789,33741,33741,35789,33709,35789,33708,35789,42258,29613,27469,25388,21162,21195,27501,23243,31694,27436,25356,19050,23275,21195,21163,23275,17001,25388,16969,25388,16969,21194,19082,16937,23308,16937,25389,16969,23275,21194,25356,29581,29548,29581,27436,29549,27436,29581,27501,25388,25356,19115,19116,23341,27534,25453,25389,23308,21228,25421,21228,14922,14888,16967,12774,21161,37966,35853,33773,37967,42192,35854,27435,12773,16902,35821,40112,52789,46384,33740,23239,14884,29578,48464,44272,54937,50677,23238,19077,21190,16965,14884,14884,16965,14885,21223,14917,8645,8612,8580,8613,8580,6500,4388,6501,4356,6436,6404,8548,12773,8612,6467,4355,6403,6404,6436,8581,6468,4355,4323,4356,4323,4323,4323,4291,4291,4291,4291,4291,2210,4291,4355,6436,8580,8516,4323,6436,12743,10630,10630,12711,12743,10598,10598,10597,6468,6403,6371,4323,4291,4290,4291,4291,4258,4258,19},
{46649,46649,46649,46649,48697,46649,46648,48697,48697,48729,48729,48729,48697,48697,48729,48729,48729,48696,48729,48729,48729,48729,48729,48729,48697,48729,48729,50809,48729,48729,48729,48729,48696,48696,48697,50777,50809,44470,25422,10762,14923,17035,17035,19083,19116,17035,17035,17035,17035,16970,37968,50677,48564,48531,44306,42259,42226,42226,42194,40145,42226,40178,40113,40113,40113,40081,40081,40145,38000,37968,40049,38000,37968,40048,37935,35854,37935,35854,37902,35822,35822,35821,35789,35789,33741,35757,35789,35789,33709,33709,33709,35789,37870,35789,33773,40145,25388,19082,23275,19082,23275,21195,21162,23275,21162,25388,19114,25388,23276,23308,25388,21195,27501,21195,27501,21227,25388,25388,21227,25453,21162,27501,23275,25420,27501,27469,31694,31661,29581,29516,29581,27501,29581,29581,27468,25421,21228,19148,25389,27502,27502,25389,25389,23276,23308,19082,14954,10695,14886,10694,16968,33772,35886,35854,37967,40080,35822,29515,14918,21127,35853,42192,52756,46320,31659,19110,14852,33739,46384,46385,57050,44370,19077,21189,23302,19109,14917,14884,14852,21158,23303,12772,6500,8613,6500,8612,6500,8580,6467,6500,8549,10661,12773,16999,14886,8580,4387,6436,4355,6403,6435,8580,6435,4323,4323,4323,4291,2243,4291,4291,4291,4291,6371,6404,4291,4291,6403,10661,12741,6468,4291,12742,21129,10598,8485,10630,10662,12711,10598,8485,8549,8517,6404,4323,4291,4291,4291,4258,4258,4258,19},
{46649,46649,46649,46649,46649,46648,48697,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48697,48729,48696,48729,48729,48729,48729,48729,48729,48728,48729,48729,48729,48729,48729,48729,48729,48729,50777,50809,40245,12874,10762,16970,21196,23244,23244,21196,21163,21164,21164,21164,21163,40016,50644,48532,48532,42226,40178,40146,42226,42226,42194,40146,42226,40113,40081,40081,38000,38000,40113,37968,35855,38000,38000,35855,37935,35854,35822,35854,35854,33709,33709,33709,35789,35789,35789,33676,33709,33709,33709,33709,33709,35789,35822,35789,46419,46484,42291,25388,16969,23276,19017,21195,19050,17002,21195,16969,23308,14889,21227,19049,21195,25388,19114,25421,14888,25420,19082,23308,23275,19049,23308,14824,25388,21130,25356,29614,27469,31662,31629,31662,23210,25323,27436,29581,29614,27468,23275,10663,14954,23341,27534,27502,27501,23308,23276,23308,21195,17002,12808,10694,8581,14888,29580,35886,35854,37967,40080,33773,29515,16966,25353,35821,44306,50643,44271,27432,16997,19077,40045,44206,48564,57050,31692,16965,19109,21221,21189,19109,19077,14852,23303,25415,16998,8580,6500,6500,8613,8580,8612,8580,8580,8580,16967,16999,19079,14886,12773,8612,6500,4419,4387,8580,10660,6468,4356,4323,2211,4291,2211,2178,2210,8484,12709,10661,6404,2210,2211,2211,8516,10660,6468,4291,19017,23210,16903,14823,12711,10630,10630,8517,8517,8517,8485,6436,6403,4291,2210,4291,2210,2178,4290,16},
{46649,46617,46616,46649,48697,46649,46649,46649,46649,48697,48697,48697,48697,48697,48729,48696,48697,48696,48729,48729,48729,48729,50777,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,52889,38099,16970,27502,35855,42193,42226,42259,42259,42227,42227,40146,40146,40146,46419,50612,50579,50612,44274,42226,42194,40146,42226,42194,42226,42226,38033,38033,40113,40081,38000,40113,37968,35887,37968,37968,35887,37968,37935,35790,37902,35822,35822,35822,35789,35789,35789,35789,35789,35789,35789,35822,35789,35854,35854,35854,35821,44370,46484,44371,27469,21130,23275,19082,23275,25389,21163,25421,21227,25388,21195,23275,19114,21195,25388,21194,25420,19082,25420,23275,25388,25420,23308,25421,19082,25388,23275,27469,27469,25356,29581,29581,29614,27501,27469,27468,27533,29614,27501,23308,12776,14954,23341,27534,27502,25454,25389,23308,23340,21228,17035,10727,12774,10694,10662,29548,37934,35886,35886,37967,33773,27434,16965,27433,35853,44338,50611,44238,29577,23303,25383,40078,37901,52791,52791,23240,16964,16965,21189,19109,19077,16997,19046,25415,27463,23271,12773,8612,8580,6468,6467,8580,6499,6500,8613,16967,14886,19079,14886,10693,10725,6500,4387,8580,14886,12773,8613,4388,4291,4291,2211,2210,2211,2210,6435,6403,4291,2210,2178,2210,2178,6435,10661,6404,6372,14856,25257,25257,19016,10630,12743,12775,4323,4291,4291,8549,6404,4323,4291,4291,4291,4291,2210,4291,16},
{48697,46648,46616,46649,46649,46649,46649,48697,46649,46649,48729,48697,48697,48697,48729,48696,48696,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48696,48729,48729,48729,48729,48728,50777,52857,42260,40114,42258,42225,46419,44371,44372,44404,44404,44404,42324,44404,44404,46484,48531,48466,48531,44274,42226,40146,40178,42226,42226,42226,42226,40113,40113,40146,40113,40146,40113,37968,37968,38000,37968,37935,38000,37935,35822,37903,35822,35822,35822,35822,35822,35822,35821,35822,35821,35789,35789,33741,35789,33741,33741,33741,42225,46484,40178,27501,23276,25356,21195,23308,25420,21195,25421,23308,25421,21195,23275,19115,19082,23308,21162,25388,16969,25388,21162,23276,25356,21162,25421,16969,23308,19082,25355,25388,23243,29581,27468,29549,27468,27501,25355,29581,31694,27533,23276,10631,14954,23373,27534,14889,12808,12776,12776,14921,12776,10696,4357,10662,12807,14887,33741,35854,37966,33773,35886,33773,27467,21159,29513,35821,44338,50611,44239,33739,19109,25352,31465,31596,54936,50678,23304,16997,19110,19109,21222,19109,12740,16934,25415,27496,23273,6403,6467,8581,4355,4355,6500,8580,10693,10693,14918,12806,19111,12805,6499,6500,4387,4355,8580,14853,12805,10693,6435,2243,2243,2210,2211,2211,4291,6436,4291,2210,2211,2211,2210,2210,6403,10693,6403,8549,16936,27371,23145,12710,6372,14823,14856,4324,2211,4323,6436,4323,4291,4291,4291,4290,4258,2210,4291,17},
{46649,46649,48697,46649,46649,46649,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48729,48729,48729,48697,48729,48696,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,50809,52857,46485,35952,40146,42193,46419,44404,42323,42324,42323,42356,42324,42324,42324,44371,48531,46353,46385,42193,42226,40113,40113,40145,42193,42193,42193,40080,40081,40080,40080,42226,40081,37935,37967,38000,37936,35855,37968,37935,35822,35822,35822,35790,35821,33709,33741,35789,33741,33741,33709,33709,33709,33676,31596,31628,33676,33708,38032,42291,40146,27469,21163,23275,19082,21130,27468,21130,23308,19082,23308,16969,21195,19082,19082,25356,19082,25421,17001,25356,23243,23307,27469,27501,27501,19082,25388,21195,27501,29581,31759,27468,27435,29581,29549,25388,27468,29549,29614,27501,23308,8550,14922,23341,27534,8615,6503,4422,8615,8583,6469,6502,6470,6469,8550,16936,33773,35822,40080,33773,35854,33741,23241,23207,31626,35821,44338,50578,42126,29513,21158,27465,46257,29419,52757,48564,23271,23270,21222,16997,21157,19110,8548,4323,12805,14886,10629,130,4355,8548,4355,4355,6468,6500,10661,8580,10725,10725,17031,12805,8612,4387,6435,4355,8580,14853,12837,10693,6436,4323,2243,2211,2210,2210,4291,6468,4291,2211,2210,4291,2211,2210,4323,10661,8516,8581,19017,21065,8484,4291,4259,12711,14856,6372,2178,2178,6404,4323,4291,4258,4291,4291,4291,4258,4258,17},
{48729,48697,48729,46649,46649,46649,48729,48697,48729,48697,48697,48729,48729,48697,46648,48696,48729,48729,48729,48729,48697,48696,48697,48729,48729,48729,48729,48729,48696,48729,48729,48729,48729,48729,48697,50777,52857,42226,33807,40179,40080,44338,44404,42324,42324,42324,42356,42324,42323,42323,44371,48466,46320,46320,42160,40081,33677,33741,33709,33709,33709,33677,33709,33709,33677,35789,33709,33709,33709,33709,33741,33709,33709,33709,33709,33709,33677,33709,33709,33709,33676,33708,33709,33709,33709,33709,33709,33676,33676,33676,33676,33676,33676,38032,40178,38065,29582,25388,25388,23276,23275,29614,25356,27469,23308,23308,21163,25389,21195,21163,23276,19082,25421,16969,23308,23275,25356,29581,29581,27501,19050,25388,19049,25388,31727,33872,25355,25355,29581,27501,25388,23275,27436,27501,23275,23276,10630,14922,23373,27534,10696,6535,6470,10728,6470,6470,8583,8550,4324,6437,19081,35886,33741,40112,33741,35886,31661,25322,23208,31659,35885,46450,46384,42126,29546,21190,33804,50645,37902,52691,35885,23238,21222,21222,21222,21189,12772,4291,2211,4356,4323,2243,4356,4323,6468,6436,4323,6468,8580,8580,8548,10693,10725,14918,12806,10693,6499,6467,6499,12773,14918,14918,8548,6468,8581,4323,2211,2178,4291,6436,4291,4291,2211,2178,2211,4259,4291,6435,8580,6436,10630,19017,12710,10598,10565,8517,10630,10598,6404,6404,6404,6404,6404,4291,4258,4291,4291,4258,4258,2178,19},
{46649,46648,48697,46649,46649,46649,48729,48729,48697,46648,48729,48729,48729,48697,46648,48697,48729,48729,48729,48729,48729,48729,50777,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48697,48729,48728,50809,42227,31727,40179,40113,44306,44404,42324,42323,42324,42324,42324,42356,44404,44371,48433,46320,48401,42160,40048,35757,35757,35789,35790,35790,35790,35790,35822,35822,35790,35822,35822,35789,33741,35789,35789,35789,35789,35790,35790,35789,33709,35789,35789,35789,33709,35757,35757,33709,35757,35757,33709,33676,33708,33708,33708,33676,38033,42259,40179,27469,14856,19082,14856,21130,19050,16969,21195,14856,21195,14856,21163,21162,19114,23308,17001,25421,17001,25388,25388,25355,27501,27468,27501,19114,23340,21195,23308,23308,23243,27501,29549,29581,29581,27501,29581,29581,27469,25388,23308,17002,17035,23341,27566,14889,10696,8615,10695,8583,8583,8647,8550,2244,6437,21162,37935,35854,40080,33773,35886,31661,23209,21128,35820,35854,44337,46385,42126,27498,21189,44303,42193,40014,52757,29515,21158,21190,23302,23302,16997,6467,4323,4324,4356,4323,6436,6469,4323,4323,6436,4355,4355,6467,12773,10693,12773,12805,17031,12805,12773,12805,10725,12773,14885,14885,16998,12741,6468,6436,2243,2211,2211,6404,4323,4291,2210,2211,2211,2178,2210,6403,10660,8580,8516,21194,23243,27469,14824,10565,8517,10630,10630,10598,8485,8485,8517,6404,4323,4258,4291,4290,4258,2210,4290,23},
{46616,46648,46649,46649,48697,48697,46649,48729,48729,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48729,48696,48697,48697,48729,48729,50777,46550,29581,35921,40080,44339,44404,42356,42356,44404,42356,42324,42324,42324,44372,48498,46352,46352,46386,46386,44241,44241,35822,31629,33677,31629,31629,33709,33677,33709,33709,33709,33677,33677,33677,33709,33709,33677,33677,33677,33677,31629,31628,31628,31628,31628,31629,33677,31596,33677,33677,33677,31629,33677,31628,31596,31629,38033,38065,38098,27501,17002,21228,19082,21195,21162,19082,23276,19050,23308,16969,23243,23275,21195,25421,21162,27501,21162,25389,27501,27468,27501,25388,29581,21162,25420,21162,23275,23308,21195,29581,29549,29549,29581,27501,27501,29549,27501,25388,23276,8583,19115,25453,27566,14954,10728,17001,19082,10695,8615,12808,8582,8517,8550,21130,37935,35854,37999,35822,37966,35854,27403,23209,40046,31660,42160,46384,31626,19078,23270,48464,48400,48464,52757,23208,19110,16965,19109,21189,14852,6436,2275,2275,4355,8549,4356,4356,2210,2210,6468,6403,4323,8548,14886,12773,14918,14886,19111,12773,12805,12805,12805,12837,14885,14885,16998,19111,12805,6435,4356,2211,4323,8549,4291,4291,2178,4291,4291,2178,4291,10629,10628,8548,14888,23274,25355,27436,14791,12710,12710,10630,10630,10630,10630,10630,8517,6437,6404,6371,4323,4291,4323,4355,6435,29},
{48697,46648,46649,48697,46649,46649,46649,48697,48697,48697,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,50777,48696,48696,48729,48729,48729,48729,48696,48729,50809,48729,48729,48697,48696,48696,48729,50777,46518,42161,35823,37935,42193,42258,42259,42291,42291,42291,42291,42291,40211,42259,48498,46321,46320,48466,50644,50612,50645,37903,31564,31596,31629,31629,31597,31597,31596,31564,31597,31564,31596,31564,31564,31596,31564,29516,31564,29516,29484,29484,27435,27435,29483,29516,29483,27403,29451,29484,27435,27403,29451,29483,27403,31596,38065,35920,35985,29582,23308,23275,25388,23275,27501,23307,25388,21162,23276,19082,23275,25356,19050,25388,16969,25421,21130,25356,25356,27468,27469,23275,25421,14889,23308,25388,27533,29614,21163,27533,29581,29581,29614,29614,29614,27501,27501,29549,23308,10728,14922,23341,29647,14921,6502,19114,19114,8615,14889,14920,14855,10662,8550,19048,42160,40079,37966,35822,35886,35886,25289,23241,40078,33675,37902,46384,35853,23240,23239,48497,46351,50578,48532,18982,21158,12772,19045,25319,25351,16933,10629,2243,4323,6469,4323,4356,2211,2243,8548,8548,4355,10661,12838,12773,14918,12805,16998,12805,12805,12805,12837,14885,12805,14885,16998,21190,19111,8548,6500,2243,4355,8548,4291,2210,2210,4291,4291,4291,4291,8516,10661,6468,8549,19017,12743,21162,16936,10597,10597,12710,12711,10598,8485,8517,10598,6437,6404,4323,4291,4323,4291,6435,6435,23},
{48729,48697,48697,48697,46649,48697,48697,48697,48697,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,50777,48729,48697,48697,48729,48729,48729,48729,48729,48696,48696,48729,48697,48729,48729,48729,48697,50776,48630,46452,46419,48532,46419,46419,46451,46419,46419,46419,46419,44338,44371,48498,44240,46320,48498,50612,50612,50612,37935,33676,35757,35789,35790,35790,35789,35790,35790,35790,35789,35789,35789,35789,35757,35789,35789,35789,33741,35789,35790,35789,35789,33709,33709,33709,33709,33709,33677,33677,33709,33709,33709,33708,35789,44307,27501,21195,23275,23307,23308,23307,25388,25388,25388,25388,25388,25356,23307,25421,27469,23275,27469,21195,27533,23275,25421,25388,25388,27501,25355,27501,19082,23340,29582,31727,27501,21194,29581,27501,29549,31694,31694,29581,29581,27533,27501,25388,10728,14890,23309,31727,23308,10663,6502,6502,6502,14889,12807,10661,10662,4356,12742,40079,42128,37934,37966,35854,37999,29548,23176,42126,35853,27402,27434,31660,21159,29545,50578,46319,52723,40113,14853,25415,23303,25351,31593,33737,29576,14853,6436,4323,6469,4323,4356,4323,2243,6436,8581,4355,6468,10661,12773,14886,14918,14918,14885,14885,14918,14885,14918,14853,14885,16998,21158,14886,6468,6468,4323,4291,6468,4323,4323,4323,4291,4323,4291,2211,4290,8548,6468,10597,23210,12710,25388,21129,16871,12743,12711,12711,12711,6404,6404,6436,6436,4323,4291,4291,2210,2210,4258,4290,30},
{48729,48729,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,48729,48697,48696,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48697,48696,48729,48728,50809,50809,50744,50744,50744,50744,50776,50776,50776,50776,52856,50776,52792,48499,46320,46320,44272,50580,50611,50611,40015,35789,37869,35822,35822,35822,35822,35790,35790,35822,35822,35822,37869,35789,35789,35821,35789,33709,33741,33709,33709,35789,33741,33709,33709,33709,35757,33709,33676,33676,33676,33676,31596,33644,37869,54871,23243,10663,17002,10728,16969,21195,19081,23242,21162,21162,14889,17001,12743,17001,23275,17001,25421,14888,25421,16937,21195,21195,19050,25388,21162,27469,14921,23308,21194,25388,29614,25388,31694,33840,29614,27468,23307,27468,31662,27469,27436,25388,14922,17035,23308,31695,23275,14856,10696,10728,10663,12807,17032,14887,12775,4356,10630,40079,42160,35854,40079,37934,40047,29547,27434,40078,40078,35853,33740,23272,19110,35852,50578,48399,54836,29581,6435,21190,23271,25351,35818,31689,31688,27496,12773,2275,6469,4388,4356,4291,2211,4323,6468,4291,4323,4355,10693,12805,14918,14918,16998,16998,14918,14917,14917,14885,14885,16966,19046,10660,6500,4355,4323,6436,4323,2211,4323,4291,2211,2243,2211,2211,2211,2210,6436,10629,23210,12710,19017,29516,21097,12710,8549,14856,14824,4291,4291,4323,6436,4323,4323,4291,4258,4259,2210,4258,21},
{48729,48697,48729,48729,48697,48697,46649,48697,48697,48697,48697,48697,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,50809,48729,48729,48729,48729,48729,48697,48697,48697,48729,48728,50777,50777,48697,48729,48696,48696,48729,50777,50777,50777,50745,50777,50744,48531,46320,44175,42095,46385,48465,48466,37902,33708,33709,35789,33677,19050,23243,23275,19050,25355,19082,23242,40014,40046,33741,27403,27402,25355,23210,19017,14889,16937,16937,16937,16937,16937,16969,16969,19017,29548,33709,31629,31628,31629,33709,44371,23275,8550,17002,10663,19082,16936,14888,16969,14856,21162,10695,17002,10663,17001,25388,23275,27501,21227,27533,21195,25388,25389,23308,25421,23275,27534,19114,25420,23307,25420,29614,27501,31727,33840,29614,23307,21162,27501,29581,27501,27468,27501,10696,12809,25422,31694,25388,16936,12775,12776,12776,12776,12807,12807,8549,2276,10598,37999,40047,35853,37966,35854,42160,27435,19015,37965,46418,48498,42126,33804,14852,37997,48465,46351,54837,21129,4355,14886,16998,27432,37931,33802,33801,25351,16934,19048,14822,6468,4323,4291,2243,6469,6436,2243,4291,6436,10725,12838,14918,16998,19079,19079,16998,16998,14917,14917,14885,16933,21158,16966,8580,4356,4323,8549,4323,2243,4323,4323,4291,4291,2243,2210,2178,4259,6404,6436,8550,8550,16936,29484,12677,6404,6405,16937,14824,4324,4291,2211,10630,4291,4259,4259,2178,4291,2210,4291,17},
{50777,48729,48729,48729,48697,48729,46649,48697,48729,48729,48697,48729,48697,48696,48729,48729,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48729,48729,48729,50777,50777,50777,50809,50777,48696,48729,48729,48729,48696,50777,50777,50777,48696,50777,50744,48499,46288,42095,42095,46352,48433,46353,37901,33708,35757,35789,31629,16970,21195,23275,14921,23275,16969,23274,40046,40110,31627,23209,25322,25322,21129,21162,12744,10664,10664,8615,8616,8615,8583,8583,8583,27468,33774,31693,31661,29613,31694,40178,25356,12808,19082,8550,16969,10663,12776,14856,10663,19082,8517,17002,10630,17001,21130,14888,25421,14824,25388,16969,21195,21195,19049,25453,14888,25389,12808,23275,27501,29614,27468,23242,27501,21195,23275,25388,19082,27501,27469,29581,27468,25421,10696,10664,23309,31695,29549,21129,19017,19049,21194,14856,14887,12775,4356,6437,12743,37967,40079,33741,35854,37934,40079,21160,12709,37965,48531,48497,44206,48563,21158,46384,46384,48464,52757,12678,4323,6436,10660,25384,37963,40076,35882,40077,35853,25321,29580,8516,4356,4323,2243,8549,6500,4323,4323,6468,12773,12773,14886,16966,16998,17030,16998,16998,17030,16998,16965,16965,23239,27432,16966,6468,4356,8581,6436,4323,4323,4323,4323,4323,4291,2211,2210,4291,4324,6404,19115,12743,19049,23177,8484,4291,4291,14824,12743,4324,4323,2211,10630,4324,2178,4259,4259,6404,6403,6403,26},
{50777,48729,48729,48729,48729,48729,48697,48729,48697,48729,46649,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48697,48729,48729,48729,48729,48696,48729,48729,48697,48729,48696,50777,48697,50777,50809,50777,50777,48728,48729,48697,48696,50777,48728,48696,48696,50777,48728,48729,50744,46419,44305,42128,42127,46353,48433,48433,48466,48499,50580,46386,31597,14922,21195,23307,14922,25420,17034,23275,42191,42223,33708,25322,25290,25322,23242,23209,23242,19017,14856,14888,12776,14856,14856,14856,12743,31629,33742,31694,31661,31694,33774,42291,25388,14856,21162,14888,21162,16969,17001,19082,14889,21162,14856,19082,14856,19082,25388,21227,29582,21227,27533,23275,25421,25421,23308,29614,21195,27533,21227,25421,27501,29582,27501,25356,29582,23275,25420,29614,23275,27501,27469,29614,27468,25420,12809,12809,21261,31695,29581,23209,19016,19049,23274,16936,16936,12775,6437,4357,10598,37999,40047,33741,37999,37966,40079,19079,14821,40013,46386,46352,44239,50644,27464,48497,46319,50577,48532,8452,4323,2243,10661,27464,37964,42190,37964,44271,27434,14790,25322,10662,4323,6468,4323,6436,6500,6468,8548,6468,6468,4355,12805,14886,16965,17030,14950,14917,19110,17030,16998,19078,25319,27431,21159,6467,4355,8581,6436,4388,4355,4355,4291,2243,4291,4291,4258,4323,4324,8517,21227,10630,19016,16904,21129,18984,14823,14856,8549,8517,6437,6436,6437,8517,8485,6404,4355,4323,4323,6435,26},
{48729,48729,48697,48696,48697,48729,48729,48729,46648,48697,48697,48729,48697,48729,48729,48696,48696,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48696,48729,48729,50777,48697,48696,48729,48729,50809,50809,50777,50809,50809,50809,48696,48728,48728,48696,50777,48728,50777,48728,50777,50777,50744,50776,50744,46386,46288,48401,46353,50546,50612,50644,48499,35823,16970,21195,23307,14921,23275,19082,25323,44271,44303,33740,25290,23242,25322,23210,23209,23242,23242,23210,23210,21162,21129,21162,23242,21129,29548,21162,21162,19114,21195,23243,42259,23308,8550,19082,14889,19082,16969,14889,19082,12808,19082,10695,17001,12743,16969,21195,14856,25421,12775,25388,16969,21194,21195,16969,25420,14824,25388,14888,21162,21195,21130,25420,23242,27501,16969,23275,29614,21194,29581,27501,29614,27500,27501,14922,17002,23309,29646,27468,23242,21130,21162,21195,16936,16936,10661,6437,4324,8517,35854,37966,33741,37967,37999,37998,21159,19015,37933,44305,46319,46320,50676,33771,50578,46351,52691,42193,18918,21063,21064,21095,23239,35883,46384,42190,44271,19015,8484,23242,21096,6404,6468,4323,4356,4323,10693,12806,6468,4355,8548,14885,16966,16998,17030,19110,17029,16997,17030,16997,21190,25351,27431,27431,23239,10660,8548,4356,4388,4355,4323,4291,4323,2242,4323,4291,4291,4324,6437,16969,25388,16871,29548,33741,25355,14855,12775,14824,8549,4291,4291,6436,10630,6404,4323,8517,4323,4291,4290,18},
{48729,48729,46648,48696,48729,48697,48697,48729,48729,48697,48729,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48696,48697,48729,48729,48697,48697,50777,50777,50777,50809,52857,50777,50777,50777,48696,48728,50777,50777,50777,50777,50777,50777,48696,50777,50809,50777,48499,44240,46320,46321,48498,48531,50579,48466,35855,17002,21228,23275,14921,23307,17002,25323,42192,37965,31628,23241,25322,23242,23242,23242,23242,25322,23274,23242,23242,23242,21162,23210,21129,25355,6470,6503,4423,6503,8583,40146,23307,8550,19082,8550,16969,12743,12776,16969,10663,19082,8550,17002,10663,12776,25388,21227,27534,23308,27534,23340,25453,27501,23340,29614,23275,27533,23275,25420,27469,25356,29646,29582,27501,21195,25388,25388,25355,31694,31694,29614,29549,29582,12809,10696,25454,29614,29614,29614,27534,27501,25389,25421,21194,14887,6469,4357,8550,33774,35854,35789,37934,40080,37933,25352,25322,35853,44337,44239,46385,46483,35851,48497,48432,54837,35821,33740,46353,46386,48531,40110,35883,46416,46383,42159,14790,4323,19016,18984,6468,8549,4356,4323,4356,8581,12773,10661,10661,10693,16998,21225,14886,12837,17030,17030,17029,19110,16997,23270,25351,25383,29576,29576,27432,19046,10661,4387,4387,4323,4291,4291,4291,4291,4291,4291,6404,8517,19082,23243,16871,33774,27468,16936,6436,10662,16937,10598,2211,2210,6404,10630,4291,4323,6404,4291,2210,2210,18},
{50777,48697,48696,46648,48729,48729,50777,48729,48729,48729,48697,48729,48729,48729,48729,48697,48729,48729,48729,48696,50809,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48696,48729,50777,50777,52857,52857,50776,50776,50777,48696,50777,48728,48696,50777,50777,50777,50777,50777,50777,50776,50777,50744,50743,50711,50678,48466,46320,48401,46320,37968,16970,21195,23308,17002,19114,17034,19082,27468,27402,27435,25290,25354,25322,25322,23242,25322,25322,23242,23242,21161,23242,21162,23210,21129,21162,6503,6535,6536,6535,10663,42259,27501,14889,21195,14889,19114,14856,16937,21195,16969,19082,12744,19050,12776,14889,21195,12775,25421,12775,25388,16969,19114,23307,16969,25421,14823,25388,19049,23275,27468,23242,29581,25356,27468,16969,21162,21194,21162,29614,29614,31694,29549,31727,14857,8583,21260,29646,29646,29614,29582,27501,27469,25421,23307,14887,4356,4356,8550,35854,35821,35854,35854,40079,37966,25352,33805,40046,44305,44238,48530,44369,37964,48465,48432,54837,21128,6404,6436,10596,27497,33801,35883,48464,46384,35853,8484,4324,10630,10597,6468,8581,6468,4356,4356,8581,12806,14886,12806,12773,14885,12806,8548,10692,16998,16998,17030,19110,19109,23302,25351,25350,29576,29576,27463,25383,16998,4387,6435,4323,2243,2211,2211,2211,2243,4324,8550,10630,8549,19049,21162,27468,12678,6404,4323,8517,14856,8517,2178,2211,6404,10630,2178,4291,2210,4291,2242,2210,24},
{50777,48729,48729,48696,48697,50809,50809,48729,48729,48697,48697,48729,48697,48729,48729,48729,48696,48697,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,50777,50809,50809,50809,50777,50777,50776,50777,50777,50777,48696,48696,50777,50777,50809,50777,50777,50777,50777,50777,48729,50809,50809,50777,48597,48532,48564,48500,38001,17002,21195,23308,19082,21195,19082,17002,19082,23242,29516,25290,25355,25355,25322,23242,25290,23242,23242,25322,23242,21130,23210,23242,21162,14857,6503,6535,8616,6535,14888,44371,27469,14856,21195,16969,21163,16969,16937,21162,16936,21162,14856,19049,14889,16969,25420,23275,29614,23308,29614,25388,27501,27533,23307,27534,23275,27533,25388,27501,29581,27501,29614,25388,27501,23307,25356,27501,27468,31694,31726,31694,31661,31694,17002,12841,19148,29646,31694,29646,29582,27502,27469,25421,19081,14854,6469,4357,8550,35854,35821,37999,35821,40112,33772,23239,33772,40079,44273,42126,50643,40142,42158,48432,48464,52724,25354,2211,2211,6468,25447,31720,35915,46351,46351,35821,6404,4323,16871,10597,6436,8614,8613,8548,4355,4355,12774,19079,16967,19079,12805,10693,8580,8612,19111,23272,19110,16997,19077,25383,27463,27463,27463,29576,27463,23271,8547,8548,6468,2243,2243,2243,2211,2178,2210,4324,8517,8550,10630,25323,29581,16936,10597,10598,10630,12711,12711,8517,6437,6404,8485,8517,6404,6372,4323,4324,6436,4355,21},
{50777,48729,48696,48696,48729,50842,50809,48697,48697,48729,48729,48729,48729,48729,48697,48697,48697,48697,48697,48697,48729,48729,48697,48729,48729,48696,48729,48729,48729,48697,48729,50777,48729,48729,48729,50777,50809,52857,50777,50809,50777,50809,50777,50776,50777,50777,50809,50777,50777,50744,50777,50809,50809,50777,50777,50809,50809,50777,50809,50777,50809,50744,35921,17002,21228,25388,19082,23308,17002,14922,19082,21194,27435,23242,25323,25323,25323,23210,23242,25290,23242,21161,23242,21129,21129,19049,17002,8616,6503,6503,8616,6503,23340,42291,25388,6470,21163,16969,19050,19082,14921,23307,21162,21162,16936,19050,12776,12809,23275,12743,25420,14856,23307,21162,23275,25388,14855,25420,14823,23307,19081,23275,25355,19049,29581,27436,29581,29581,33775,33742,31694,29613,31726,29614,29581,31727,19115,14921,21195,27534,31727,31695,29614,29582,25421,21228,14855,14886,8614,4356,8550,33774,33773,37967,35854,37967,33741,27466,35885,40046,44272,42158,52725,37965,44271,46319,48497,50612,12710,4323,2243,10628,29576,29608,35851,44238,42126,29547,6403,8516,29548,10597,4388,6501,12774,10661,4355,4356,10661,16967,16934,19079,21192,25354,23241,21160,29580,25353,21191,19077,19110,27496,27463,27496,27463,29544,27496,16965,4354,8548,4355,2243,2243,2211,2178,2178,4323,6404,8517,8550,12743,25355,29548,21162,14824,10597,8517,12710,12711,10630,8517,8485,8550,8517,8485,6372,6372,6404,6404,4323,26},
{50777,48697,48696,48729,48697,48729,50777,48697,48697,48729,48729,48729,48729,48729,48729,48729,48696,48697,48729,48729,48729,48729,48697,48697,48729,48729,48729,48729,50777,48696,48729,50777,48729,50777,50777,50777,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,52825,50777,50776,50777,50777,42292,17002,23276,25356,17002,23275,14954,12809,17034,21162,27435,23274,25322,25322,25322,23242,23242,23242,23210,21129,23210,21162,21162,12776,8615,8583,6535,6535,6535,6502,25420,44404,27501,8550,19050,10663,16969,14856,12776,17001,10630,19050,12711,16969,10663,12776,27468,23275,31694,25420,27533,27501,27533,27533,23307,29613,23308,27501,25388,27501,29582,27468,29646,33807,31727,33807,31727,33807,33807,31694,31726,31694,31694,31695,19083,10663,21260,29614,31694,29646,29614,27534,25453,19115,8581,16967,10694,6436,8550,35855,33773,35886,35887,29548,42259,35887,40013,40013,44272,42126,52790,40078,46352,42093,52659,37967,2210,4323,2243,10660,29608,31689,40076,46351,44240,29548,8516,10596,27402,8484,6436,4356,6468,8581,6468,6436,12774,14886,14886,14853,25354,33806,33774,33807,31628,23240,21190,19077,19110,27496,27463,27463,27463,27463,27463,23238,8579,8580,6435,2243,2243,2210,2178,2211,4323,6436,10630,8550,6436,21130,23210,21162,12743,10598,10662,10630,12711,10662,10630,10630,10598,8517,8517,6404,6437,6404,4291,4291,16},
{50777,48729,48729,48729,48729,48696,48696,48729,48729,48697,46648,48729,48729,48729,48729,48729,48697,48729,48729,48729,48697,48697,48696,48729,48729,48729,48729,48729,48729,48696,48697,48729,48729,50777,50809,50777,50777,50777,50776,50776,50744,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,48696,48728,50777,50777,50777,50777,50777,50777,50776,50777,50809,42325,17002,21227,25420,17002,21227,17002,12841,19050,21162,27435,25323,25355,25322,25355,23274,23242,23242,23242,21129,23242,25323,21162,14889,8616,8583,6503,8616,8616,6535,25421,42258,38000,31661,33742,23275,25388,23275,23275,25356,21162,25388,21162,23307,21162,21195,25356,14791,27501,16969,23275,19082,19049,23307,16936,25420,12775,23275,16969,19081,27468,21162,29581,27436,29581,31726,31726,33839,33807,29614,31726,31694,29613,29582,19083,8583,19115,29646,31727,29646,29614,27534,27501,21195,6469,12742,12807,10694,8517,33806,35854,31692,29580,27467,48565,33741,40046,40046,46385,44206,48530,35852,42094,37836,54804,29483,4291,2243,4291,14853,29607,33801,40108,46319,39982,33708,14822,14822,29548,8516,4356,4355,6468,6436,8548,10661,12805,14886,12805,16999,31726,27499,23306,27500,31693,25386,19110,19110,21190,27463,27495,27496,27431,27463,27463,27431,19077,10627,6467,2275,4291,2243,2210,4323,4355,6436,8550,6437,6404,29549,19017,21130,16904,8517,8517,10598,10630,10630,8550,6404,8549,8517,8485,4324,4323,4324,4323,4291,14},
{48729,48697,48729,48697,48696,48697,48697,48697,48697,48697,46648,48697,48729,48729,48729,48697,48697,48697,48729,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48696,50777,50777,50777,50809,50809,50777,50777,50744,50744,50744,50777,50809,50777,50777,50776,50777,48728,50777,50777,50809,50809,50777,50777,50809,50777,48696,50744,42292,17002,21227,23340,17002,23308,17034,14922,21163,21162,25355,21162,23242,23274,25355,27403,25322,25355,23275,21162,21162,21130,23275,14889,8616,8583,6535,6535,8615,6503,33807,50645,57049,59162,46419,27468,27469,27501,27469,29549,29581,27468,25388,25388,25420,25388,25388,25356,29581,25356,27501,25388,25388,29581,25388,29581,23308,25453,25388,25388,29614,29581,31694,33775,31726,31726,31726,33807,33807,29613,31726,31694,29581,31662,21195,14922,19115,29614,31694,29614,29582,27501,25421,23308,10695,10694,6436,6469,8549,31693,37934,31627,25322,21096,37967,29450,37933,40046,46385,44239,52756,42158,46418,44207,54804,19016,4323,4323,4323,21158,29608,31688,42189,42093,23176,33805,10661,10597,14854,8548,6436,4323,8548,8549,8581,12805,16966,16966,12773,27499,27467,16966,14918,16998,23273,29580,19078,21222,23270,27463,29576,27496,27463,27464,27431,27431,23238,16965,6467,4291,4291,2243,4291,4323,4355,8549,8517,8517,12710,38000,23243,23243,21130,16871,14823,12711,10598,12711,6437,6404,6404,10630,8517,6404,4324,4323,2243,2210,11},
{48697,48697,48696,48729,48696,48696,48729,48729,48696,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,48729,48729,48729,48729,48696,48729,50777,48729,48729,48696,48729,48729,50777,50777,50777,50777,50777,50776,50777,50777,50777,50744,50777,48728,50777,50777,50777,48696,48728,50777,50777,50809,50777,50777,50777,50776,50777,50711,50678,46387,21130,21228,23340,17002,21163,17002,16970,19115,19115,19082,19082,19082,25323,27435,25355,25355,25323,21162,21130,19049,19017,25388,14889,8616,8616,8583,6535,8583,6503,33807,54904,54936,54937,35920,16937,19114,23275,19049,27501,27501,21195,12776,16969,19082,16969,19114,14888,23308,14856,21195,17001,16969,25388,19081,25420,14856,19114,19049,21130,25388,29614,31694,31727,31759,31727,33871,33839,31726,31694,31694,29614,31661,33839,19050,12776,19147,29614,31727,31694,29582,27501,27501,21195,12775,14919,8581,8549,8549,27499,37966,35854,31693,27467,29514,27369,40045,42159,46384,44271,54870,46351,42159,44239,50644,12677,4323,2243,8516,23303,29608,31656,42157,35788,14790,12742,4355,4323,8516,10629,4356,4356,8549,8613,8612,14918,21192,21192,16966,29548,19079,19078,19078,16933,10692,16934,14885,21190,25383,27495,29608,27495,27431,25351,23270,25351,23238,14885,6468,4323,2243,2243,6436,4355,6404,17001,12743,10630,12743,21162,12743,16937,29484,21065,10597,6404,12743,14856,4324,4324,2211,12711,6404,2210,4291,4291,2243,2210,10},
{48696,48697,48697,48729,48697,46616,48696,50777,48729,48729,48696,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48696,48729,50777,48729,48729,48696,50777,50809,48728,50777,50776,50777,50809,50777,50777,50777,50777,50777,50809,50777,50777,50777,50777,48728,50777,50809,50809,50777,50777,50777,50777,50777,50776,50776,52857,48598,25356,23308,23308,19083,21195,21163,19082,21195,21163,21163,21163,23243,23242,23274,23243,23242,23243,23275,23210,21162,23243,25388,14889,10696,10696,8583,6535,8583,8583,25420,52823,52823,48662,35920,21195,25388,23275,23308,27469,25356,25421,19082,23308,23308,25356,25421,21227,25420,21227,25420,25388,25356,27469,25388,27533,23275,25388,25388,27469,29614,27501,29582,27533,29646,31727,33839,31694,29581,31694,31694,29614,31662,33839,16969,6469,21228,27501,31727,31694,29582,27534,27502,19115,8582,16967,16967,14887,6436,25387,40047,33773,31694,29580,35853,27369,42126,42192,44239,46352,52757,46383,46351,50545,46386,6371,2243,2243,10629,25415,27527,33770,46318,27369,6436,4323,4323,4323,6404,10662,4323,4323,10629,10661,12774,16966,19047,23240,23273,23273,19111,19111,16998,14852,10659,10659,14885,21159,25351,29576,29608,27463,25382,25350,23270,25318,23270,10692,4355,4323,4291,4291,6468,4356,8517,23341,16936,10598,6437,10630,12743,19016,29483,10597,4291,4291,14824,14889,6404,2275,2211,10630,6404,65,2178,2210,4291,2210,12},
{48696,48697,48696,50777,48729,48696,48664,48696,48729,48697,48697,48729,48729,48729,48729,48697,48729,48729,48729,48729,48696,48729,48729,48729,48729,48729,48729,48729,48697,48696,48729,48729,48696,48697,50777,48696,48696,50777,50777,50809,50777,50777,50777,50777,48728,50777,50809,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50744,50777,50809,50777,50809,48663,25388,23276,23276,19082,21195,21163,19082,19082,21131,21162,21130,19050,19082,19049,19049,19049,21130,21130,19050,21130,19050,21130,16937,14857,14857,8583,8583,8615,6535,25388,52856,48597,48598,35920,16872,23210,23210,23210,27469,27436,23243,12711,19049,21195,19050,21195,14889,23308,16936,21194,21130,19049,25356,19049,25420,14888,21195,21194,23243,29614,21129,27436,23242,27468,33807,31726,29581,31661,31694,33807,31694,29516,27468,17001,8583,19148,27501,31727,31694,29614,27501,25421,23308,10663,4388,6436,10630,10630,29516,40079,33741,27468,29548,37966,29450,40045,44304,42126,48498,52757,48432,46319,52658,40048,4259,4323,4291,12709,25415,29640,35915,46351,27434,6436,4355,4323,4323,4324,10629,4355,4355,8549,10661,14854,14885,21193,29580,25354,21192,21191,19078,12772,12772,12805,12804,23272,27466,27464,29575,31688,27495,25382,25383,25383,23238,12772,4355,2242,4291,4323,4323,6436,6404,8550,17001,10598,10598,2243,14889,14888,21097,18984,4291,2178,2178,10663,12776,6436,4291,2211,8549,8485,2178,2211,2178,4356,2210,14},
{48697,48696,48697,48729,48729,48696,48696,50777,48729,48697,48729,48729,48697,48729,48729,48729,48697,48697,48697,48729,48697,48697,48729,48729,48729,48729,50809,50777,48729,50777,50777,48696,48696,50777,50777,48729,48696,50777,50809,50777,50777,50777,50809,50777,50777,48728,50777,48728,48728,50777,50777,50777,50777,50777,50777,50777,50776,50777,50777,50777,50777,50809,46518,23243,23243,23243,19050,21163,19114,19050,19082,21163,21163,21131,21130,19050,19050,19050,19050,21130,19049,19017,19082,19050,19017,19017,29549,23276,6503,6535,8616,6535,21162,52855,46419,46387,50645,48500,48500,48532,48532,48500,48500,46419,46387,46354,46451,46419,33774,25421,27501,25421,25420,27469,27469,27501,27469,27533,25388,27469,27469,27501,29581,27468,29581,29581,29581,27533,27469,27501,29581,29614,31694,29614,29581,27436,23308,19147,21196,27501,31727,31726,29614,27533,27501,23340,14921,6469,6437,6404,27435,42160,40079,35822,27469,29549,37934,29450,40014,46385,44206,48498,54837,48432,46319,52724,29547,4291,4356,4291,19047,31722,31688,40108,33740,12709,6468,4356,4323,4323,4291,8548,8548,6436,6435,6500,8613,12806,23275,29548,27435,19079,21159,21159,16966,14885,12804,14885,23273,35919,31658,27495,29608,29608,27495,27463,25383,23238,10692,4355,2210,2210,2210,4291,4356,6437,6469,4356,6404,10630,8550,16969,12743,21097,16904,21097,18984,14823,12743,8550,6469,6404,6404,6469,10598,10630,8550,6469,6436,2210,17},
{48729,48697,48697,48697,50777,48697,48697,48729,50777,48729,48729,48729,48697,48729,48729,48697,48696,48697,48697,48729,48729,48697,48729,48729,48729,48729,48761,48729,48729,50777,48696,48729,48696,50809,50777,50777,50777,50809,50809,50776,50809,50777,50777,50777,50777,50777,50777,50777,50777,50809,50777,50777,50777,50777,50776,50776,50776,50777,50777,50776,50809,50809,48598,23275,23243,23244,19082,19082,19083,19050,21130,21130,21130,21098,19050,19050,19050,19049,19050,19050,19050,19017,19050,19050,19050,19050,25355,23243,6535,6535,6535,6535,21194,52791,48564,48597,57017,40080,50645,46451,46419,52823,44306,54903,40047,50644,40145,33806,27500,12743,17002,19082,17001,19050,17002,17001,19082,17002,17001,17001,19050,17002,17001,19050,19082,19115,19114,19082,21195,19082,19082,19082,19082,19082,19114,19114,16969,14889,19147,25421,33807,31726,29646,29582,25421,23341,17034,14887,10661,6436,19016,35756,35822,29516,31662,33742,35821,37967,46417,46418,31595,35886,48466,48432,46351,52757,19048,4323,4356,4291,23272,29641,31721,42157,14789,4355,6468,4356,4324,4291,4291,10629,10661,8548,10661,10661,8613,14887,25388,21129,25354,19079,21192,23272,23272,23272,16965,19078,21192,31660,31690,29575,29575,29608,29575,27495,27431,25351,14884,4387,2242,2210,2210,2243,6437,6437,4357,6405,4324,6405,6437,10663,23308,19016,29548,33741,25355,14855,10663,14856,6437,2211,2211,6469,12743,6437,8517,8516,4355,2210,18},
{50777,48696,48729,48729,48697,48697,48696,48697,48729,48729,48729,48729,48729,48697,48729,48697,48696,48697,48729,48697,48697,48729,48729,48729,48729,48696,48696,48729,48729,48729,48729,50777,50809,50809,50809,50777,50777,50777,50777,50776,50777,50809,50777,48696,48696,50777,50777,50777,50809,50777,50777,50809,50777,50777,50809,50776,50776,50777,50777,50776,50776,50809,46550,23243,23243,21163,19083,21163,19082,19050,19050,21130,21130,21130,19050,19050,19050,19050,19049,19050,19050,16937,19049,19050,19049,19050,25291,25323,6535,8616,8616,6535,21130,54904,40145,46516,54936,44306,52791,48564,48564,52823,48499,54903,40080,35887,19049,14889,16970,8615,8582,6502,6502,8582,8550,8582,8550,6469,6470,8550,14824,10663,6437,6470,10663,10631,6470,8583,6502,8517,10630,10630,10631,8550,8550,6470,10663,6437,19148,25389,33807,31694,29614,29582,27501,25421,17001,19080,16966,16999,18919,35594,29483,29484,23274,40112,37966,44273,46450,48531,27337,33740,48433,46352,46319,50644,14790,6436,6436,8516,21192,25415,35882,35852,10596,6468,4323,4323,6436,4323,2243,10629,6436,4323,10661,10693,10693,16967,21194,19048,23240,19079,23272,23272,23304,23271,21191,23304,23272,27466,31658,29576,31688,31688,29576,27495,27463,25351,16997,10692,8547,2242,2211,4323,6437,6437,6437,4357,8550,21097,18984,16969,23275,19016,31694,25387,14823,6437,10630,16937,8517,2178,2210,6404,12743,2146,2210,4323,2210,2242,22},
{50777,48697,48697,48697,48696,48729,48697,48697,48697,48697,48697,48729,48729,48697,48729,48729,48697,48697,48729,48697,48729,48729,48729,48729,48696,48697,50777,50809,50777,50777,50809,50809,52857,50777,50777,50777,50809,50777,50777,50809,50777,50777,50777,48696,50777,48728,50777,50777,50777,50777,50777,50809,50809,50777,50777,50777,50777,50777,50809,50809,50777,50809,46518,23243,23243,21163,19082,21130,19050,19050,21130,21163,21130,21130,19082,19082,19050,19050,19050,19050,19049,17001,17001,19050,19050,19050,25290,25323,8583,8583,8615,8583,19081,52855,46418,50677,54936,46354,52791,48532,50645,52758,48564,48564,19016,16969,10663,10663,12776,12808,10695,10663,10695,14888,16936,19081,16936,8582,8582,25388,44339,27500,10663,10695,25388,23340,10695,10663,8550,25355,27435,29516,31661,27468,14823,6405,12776,6437,17035,25389,33807,31726,29646,29614,27501,25421,12808,12807,10693,12806,25160,29256,33677,37902,35918,42223,37999,42192,44272,42159,42126,48498,50611,39981,48432,48499,25289,31628,31660,33741,29580,27497,40076,23208,6436,6468,4323,4356,4356,4291,2243,4356,4323,4323,10661,12773,10693,17000,14823,21128,19079,21159,23272,21223,19110,19110,21191,23304,23336,25353,33771,29543,29608,31688,29575,27463,27463,25350,23270,21190,12772,4355,2242,6436,6437,6405,6437,4357,12711,31596,19016,10565,23210,25323,27468,8484,4259,2211,8485,14856,8517,2178,2211,6372,12711,2146,4291,4355,4322,6435,28},
{50777,48697,46616,48697,48696,48697,48696,48697,48729,48729,48697,48729,48729,48729,48697,48729,48696,48729,48697,48729,48729,48729,48729,48729,48729,50777,52890,50777,52857,50809,50809,52857,50777,52857,50777,50809,50809,50809,52857,50777,50777,48728,50777,48728,50777,50777,50777,50777,50777,50777,50777,50777,50777,50809,50809,50777,50809,52889,52889,52889,52889,52922,48631,23243,23276,23276,21163,23244,21163,21130,21130,21163,21162,21163,21162,21130,19050,19050,21130,19082,19082,19082,19050,19082,16969,17002,23243,23242,8583,6535,8615,8583,21162,52823,46386,50677,54871,44241,52791,46386,50644,50677,50645,27436,16969,25356,8582,12743,14889,10630,10695,10694,10694,16968,21162,16968,10695,6501,8549,21161,44371,31693,14855,12743,12808,14889,12776,8583,8550,27468,29515,29548,33742,29548,16936,6437,16969,6405,21228,29581,33775,31726,31694,29614,27501,25421,19114,6469,4324,10630,33644,35659,31629,33773,37964,40109,35853,37933,48432,52692,46417,50643,50644,35756,50578,42160,21096,35886,35886,40144,46483,35883,42157,18983,4388,6468,6436,4356,4323,4291,4291,6404,4323,4291,8581,12774,12742,10629,8516,21193,19079,21192,21191,17030,16997,17029,19110,23303,25384,25352,33804,29576,29608,31688,31656,29543,27430,27430,25350,25318,21191,12773,6468,6437,6437,4357,6437,6404,21129,27435,6404,12743,29516,31694,16936,10630,10630,8517,10598,10662,8517,6437,6436,6404,8485,6404,6436,6435,6435,6435,37},
{50777,48696,48697,48664,48697,48664,48696,48696,48729,50777,48729,48729,48729,48729,48729,48729,48697,48697,48697,48729,48729,48729,48729,48729,48697,48729,50809,52857,52889,52857,52857,50777,50776,50777,52857,52857,50777,50777,50809,50777,50777,50777,48728,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,50777,44470,36051,33938,36019,38099,38131,38132,40147,23244,25388,25389,21163,25388,23243,23243,25388,25324,23276,23243,21162,23275,23275,21162,21162,21162,19082,19082,19082,19114,19082,19050,23210,21130,10696,8616,8616,8615,21130,54903,35854,48597,57050,59162,57082,57082,57082,57082,50645,25355,12743,25388,12776,17002,16969,14856,16937,14888,16936,21162,25355,27436,16936,12743,10662,23307,35887,25355,19049,12776,12743,12775,14889,10663,12743,29516,31628,33741,31693,27435,14823,12743,19050,10631,23276,40146,31694,31726,31726,29646,29582,27501,21226,10661,8517,8517,19015,35821,35855,33772,35914,40108,35788,37933,46320,52724,46319,48530,48564,39981,50578,35821,4323,4356,4291,14853,27495,33802,40077,10596,4355,6500,6468,4356,4323,2243,4291,4356,4323,4323,6468,10694,10662,8484,10565,23241,19079,21191,21159,19110,19110,17030,17030,21223,25417,25384,31659,31657,29608,33768,31656,29608,27463,29544,27495,21158,12740,6403,2242,4324,6437,6437,6437,12743,27468,21097,4324,10630,23210,27500,23275,14855,10598,6404,10630,10630,10630,8517,6404,8517,8517,8485,4324,4291,4291,4291,31},
{48729,48696,46616,48696,48697,48696,48696,48697,48729,48729,48729,48729,48697,48697,48729,48729,48729,48697,48696,48697,48697,48697,48729,48729,50777,52857,52857,52857,52857,52857,52857,50809,50809,52857,52857,52857,52857,50809,50777,52857,50777,50777,48696,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50777,50809,38099,21293,17068,19149,19148,19148,19116,29615,27469,31662,29582,23276,27501,25388,25356,27501,25388,25356,25356,25388,25356,25356,23275,23275,23275,21195,21195,21163,19114,21163,19082,21163,16937,12776,10696,8648,8616,19082,52791,35854,50742,52791,50579,54936,50612,54871,52726,46419,29581,19049,23275,25388,23243,25388,21195,25356,27501,29613,27501,25388,27501,25355,25388,25388,27501,29581,27501,27469,21195,25420,23308,23308,25388,29549,31694,31661,33774,31694,31662,25388,25356,25421,25388,29614,46452,31694,31727,31727,31694,29614,27533,19080,12805,14854,8549,19016,33709,44273,33804,35913,40109,35820,42126,46320,50611,48432,50611,44272,44206,52724,40079,4323,4324,4323,19078,29608,37963,31626,6468,4355,6500,8581,4355,4356,4356,4323,4323,6436,6404,8549,10693,12774,16968,14822,19112,19079,21191,21159,19143,19110,17030,17030,19110,23303,25384,31659,33770,31656,31720,31688,31688,29576,29576,19078,4355,2210,2210,2210,4356,6437,6437,8582,14888,12775,10662,8517,6372,21129,23242,21162,14823,10630,10630,10662,10630,10662,10630,10598,10598,8517,8517,8517,6404,6404,6404,43},
{48697,46616,46616,48664,46616,48697,48696,48664,50777,50777,48729,48729,48729,48729,48729,48729,48729,48729,48697,48696,48697,48729,48729,48729,50777,52889,52889,52857,50809,52857,52824,52824,50776,50776,52857,52889,50809,50777,50809,52857,50777,50777,48728,50777,50777,50777,50777,50777,50777,50777,50777,50809,50777,50809,48696,33938,21326,17101,19181,21229,19148,21229,31696,27437,27501,27469,23276,25388,23276,23243,25356,23276,23308,23275,23308,23275,25388,23308,21195,21195,21195,21163,21163,21163,19082,21163,19082,12776,14889,8615,8615,10696,21129,54871,50645,52790,57049,57049,57082,57050,57050,59130,50645,35886,38066,25356,23275,19049,23276,14856,21162,31726,33839,27500,23242,29582,21129,23275,21162,21162,25388,23275,27501,12743,23308,16969,16969,25388,31694,31661,33774,38000,33774,31694,27501,16904,25388,16969,31727,50677,37935,37935,35887,35854,33806,33742,27434,23208,19014,12741,25321,33675,40079,35916,33834,37932,35820,44305,46352,50578,48497,44273,35756,50480,52724,16870,4323,4323,4323,21158,29640,40076,29481,10661,4387,6500,8645,6436,6436,6468,6468,16968,12709,6404,6436,10693,12773,19080,14822,19080,19078,21191,21191,19078,17030,17030,17030,19142,23303,27497,29546,35884,29576,31688,31689,31656,31656,29576,12740,2242,2243,2210,4291,4324,6437,6437,8582,12841,8550,6469,8485,6404,29613,21162,19049,16904,10598,10598,10630,10598,10630,10598,8517,8517,10598,8517,6372,4324,6404,6372,21},
{48697,48697,46616,46616,46616,46616,46616,48696,50777,48697,48697,48729,48697,48729,48697,48697,48697,48696,48697,48697,48729,48729,48729,48729,48729,50809,52889,52857,52857,52889,52857,52857,52824,52824,52857,50776,50777,50809,50777,50777,50809,50777,50777,50777,52857,50777,50777,50777,50777,50777,50777,50809,50777,50809,40211,29680,23406,17133,19181,21229,21229,21229,29582,25356,23211,21163,21130,21163,21130,19050,21130,21130,21163,19082,21162,21130,19082,19082,19050,19050,17002,19050,19050,19050,17001,16969,12808,8615,8615,6535,8583,6503,19049,57016,59162,54903,48564,44306,54871,46419,52824,52823,42193,35919,50711,27436,25388,23276,25356,17002,21195,29614,27533,27501,25388,29614,27468,27533,25388,23275,29614,29613,29614,23308,27501,25420,23340,29581,29581,31662,35887,35919,35887,33774,29581,25421,27501,8517,25388,52824,54936,54903,54903,54903,54871,54871,54903,52790,46352,31627,46352,35820,42159,40076,25351,29481,39982,54871,46352,48530,46417,23177,35756,50544,48499,8452,4356,6469,6436,23303,29640,42189,42126,19047,8548,6436,8581,8549,6500,6501,6436,19081,16903,8516,4356,6468,10693,21160,16935,19079,19078,21191,21191,19110,19078,17030,17030,19111,21223,27529,29513,37964,33769,33769,31688,31656,31655,29576,19078,8548,4323,4323,4291,4324,6405,6437,6437,8550,12776,8550,4324,10630,38000,23242,21162,18984,14790,16904,14823,12710,10630,8485,8517,8485,8549,8517,6437,6436,6404,6372,20},
{48697,48697,46648,46616,48697,48696,48664,48697,48729,48696,48697,48729,48696,48729,48729,48729,48697,48696,48696,48697,48729,48697,48729,48729,48729,48729,50777,52857,52857,52857,52857,52856,52856,52856,52824,50776,50777,50809,50809,50777,50777,50777,50777,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50776,54969,40180,23406,17100,19181,21261,21229,21228,38034,46485,25388,21163,21130,21131,19082,19050,21130,21163,21130,19082,21130,19082,19050,19050,19050,17002,17001,17001,19050,17002,19082,16969,10728,8616,8583,8583,8615,8583,12776,25356,27435,48532,48531,46418,52790,44306,54904,50677,35821,40112,48566,25356,27469,21195,21227,12808,19114,27501,25355,27501,21162,29549,23275,25388,23275,21162,31694,25388,27501,19049,23275,19049,19017,27468,27436,29581,35887,35919,35919,33774,27500,21162,29581,10630,23243,50743,46484,35952,35919,35887,35887,35919,35919,37999,33773,10596,29482,37933,42159,38028,14820,31627,37869,50644,44272,48530,40047,31629,42094,50545,42193,4259,4324,8549,8516,27528,33769,42190,42126,25288,8549,6468,6468,6501,8549,4355,4323,8549,12710,8516,4355,4355,10693,16967,14855,16999,19111,23271,21191,19110,19110,17030,16998,12772,12772,16997,27432,35884,33802,33769,31721,31688,29607,19077,8515,4323,2243,4291,2243,2243,6437,6437,6437,4324,16969,10663,6437,8549,14855,10630,14823,29516,25290,16903,16936,16936,19050,8485,6436,8485,12743,8517,4291,6372,4324,8485,21},
{48697,48697,48664,48664,48664,48696,46616,48664,48697,48729,48729,48729,48729,48729,48729,48697,48696,48697,48697,48696,48696,48729,48729,48729,48696,48729,48729,50809,52857,52857,50744,52824,50776,52856,52824,52857,50777,50777,50809,50777,50777,50777,50777,50777,50777,50777,50777,50776,50777,50777,50777,50777,50809,50809,52857,36051,23374,17133,19213,21261,21229,21196,40179,52856,27469,21162,21131,21163,21130,21130,19082,21130,21130,19050,19050,19050,19050,16969,16969,16969,17002,19050,16969,16969,19050,17002,10696,8616,8616,8616,8583,8648,8616,8615,12711,46453,48499,46450,50678,42192,54871,46452,40080,50677,48565,25324,25388,21227,25388,21195,25388,25420,25356,27469,25388,29614,25388,27501,29614,29582,29646,29581,31694,27468,29581,27469,27469,31727,29613,31726,35887,35887,33807,31693,33807,31694,31726,29549,27501,44404,25355,16969,16936,16968,16936,16968,16969,21161,19047,10661,25321,35885,42224,33771,12708,33740,37836,44239,46353,46352,44305,35854,44174,52658,33742,2211,4291,6436,12709,27528,35882,44238,42126,35852,8580,6468,4323,4356,6436,4291,6404,8517,6468,8549,6468,6468,10725,19048,19016,16966,21191,23271,21191,19110,19078,19078,14885,10659,10659,12772,23271,35852,33802,33801,31688,33768,29576,6467,2243,2210,2210,4291,4323,2243,6437,4357,4356,10630,19082,16936,23242,16936,12743,12743,16936,33709,21064,8484,6404,14823,16936,21130,21162,21130,19082,8517,2178,2210,2178,6437,17},
{48696,48729,48729,48696,48696,48696,48696,48696,48697,48729,48697,48697,48729,48729,48729,48697,48696,48697,48729,48729,48697,48729,50809,48696,48729,50809,48729,48696,50809,52857,52824,52857,52857,52857,52856,50776,50777,50777,50777,50777,48728,50777,50777,50777,50777,50777,50777,50777,50809,50777,50777,50777,50809,50809,52889,36019,23407,17133,19181,21229,21229,21229,40147,52824,27468,21130,21130,21131,19082,21130,21130,21130,21130,21130,19050,19050,19082,19050,16969,16969,19050,17002,16969,19050,19050,19050,12776,8616,8616,8615,8615,8615,8616,8616,12744,50646,46386,48499,50645,44273,54903,44273,46419,54903,50677,25356,21195,14856,23275,16969,23275,23243,25355,25388,19049,29582,19049,23275,29614,29581,31694,25388,29581,21129,25388,21162,19017,27533,19049,29581,35887,38000,33774,29581,33774,25355,31726,25387,21130,37967,29548,27435,25322,27403,27370,25290,25290,27402,21128,16934,27434,35853,44336,27465,16901,35820,35755,44271,46384,50611,52756,48465,46286,52723,25290,2179,10597,12742,21128,29576,37963,42060,40078,25385,6468,6468,4323,4355,6468,4323,6468,6436,6468,8549,6468,8548,14854,27435,21128,16934,19078,21158,21191,19110,16998,16997,19110,16997,16997,19110,29576,33771,33770,31688,29576,29608,21158,6435,4323,2243,2211,4291,2211,2211,6404,6405,8517,14824,12743,23274,25322,12677,16937,14856,21162,29548,16904,10630,10597,21161,33774,33741,33741,33709,31661,16903,4291,2210,4259,8517,35},
{48696,50777,48729,48696,48664,48696,48664,48697,48697,48697,48697,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48697,50777,52857,52857,52856,52856,52856,52824,50776,50776,50777,50809,50777,48696,50777,50777,50777,50777,50809,50777,50777,52857,52857,52857,50841,48696,48696,48696,33938,25455,19148,19148,21228,21228,21228,35921,44405,25388,21163,21130,21130,19082,19082,21131,21130,21163,21163,21130,19082,21130,19082,19050,19082,19082,19050,19050,19114,19082,16969,12776,8616,8615,8615,8615,8615,8616,8616,12744,35855,44274,44306,44306,44306,44306,44306,48467,33741,25387,23275,31727,31727,31727,29679,31727,29646,31727,31727,29646,31727,29646,31727,31759,31727,31727,27501,29646,27468,29581,29581,25388,29614,27468,31694,35952,38000,33807,31726,35887,33774,35952,25356,21096,50677,56984,56951,56983,56951,56951,54903,56951,54837,29547,19015,27434,44306,29579,16901,18982,37901,33707,46319,46385,48530,46319,48432,46319,52724,16871,4291,8517,10597,21127,29609,40045,48204,29448,10660,8581,6500,4323,4356,6468,4388,6468,8517,8517,10629,6404,12742,23242,23210,21129,14886,19078,21158,21191,19111,17030,16998,19078,19078,21190,27464,31689,35851,35851,31656,27463,29576,19045,8580,4323,2243,2243,2243,2242,2243,6405,4357,8517,19049,12743,25323,8485,2178,14856,12776,25323,14823,4324,2211,4259,25355,37967,37935,35854,35854,35822,14823,6371,6371,4291,10630,45},
{48697,50809,48697,48696,48696,46616,46616,48697,48697,48697,48729,48697,48696,48729,48729,48696,48696,48729,48729,48729,48696,48729,48696,48729,48729,48729,48729,48729,50777,52857,52856,52857,52824,52856,52857,50777,50777,50777,50777,50777,50777,50809,50809,50809,50777,50809,52890,38099,31728,33841,33873,33873,27534,25389,25389,23276,23276,21228,21196,23276,23276,23276,23243,23243,21163,21163,21163,21163,21163,21163,21195,21163,21163,21163,21163,21163,21163,21163,21163,21163,21130,21163,21163,21163,21163,21130,19082,19050,19050,16970,19050,16970,16970,16969,19050,19017,19017,19049,19017,18985,16904,18984,40145,25322,21162,19050,14856,12776,14921,12808,16969,10631,10630,14856,8582,16969,10631,14888,10695,12776,29614,23210,27436,18984,27436,23210,14823,25388,18985,31662,38000,37967,33774,29516,33774,29548,38000,27436,33708,56984,57049,57017,57049,57049,57017,57017,57049,52823,40079,42225,37999,44338,33806,31725,35886,44305,42127,44271,46385,42126,40012,48400,48399,50611,10597,4324,4324,6404,21159,29609,31658,27304,14822,8548,6436,6501,4356,4291,4291,4324,2243,8517,21162,10597,4291,12742,29516,16903,23242,16966,23272,23271,21158,19111,16998,16998,19078,19110,21190,27464,31721,33738,37964,29544,25350,29608,29608,19077,8515,10660,8548,2242,4291,2211,4356,6405,8550,21162,12711,23242,10630,10565,10695,23308,23210,8550,6437,2178,8452,31629,37967,35886,35854,35821,33709,25322,23210,19016,12775,12743,34},
{48697,50777,48729,48696,48696,46616,46616,48697,48696,48729,48729,48729,48729,48697,48729,48729,48729,48697,48729,48697,48729,48729,48729,48729,48729,50777,50777,48729,50777,52857,52857,52824,52824,52856,50777,50777,52857,50776,50777,50777,50809,46583,33873,27534,27566,29615,27567,25389,21163,23243,21163,21195,23244,21196,21163,21196,21195,23243,21195,23244,23244,23243,23276,23244,21195,21195,21131,21195,19082,21163,19083,19082,19083,16970,19083,19050,17002,19083,19050,19082,19083,17002,19082,16969,19082,21163,19082,21163,19050,21130,21163,19082,21163,21130,21163,23243,25356,25324,23243,23211,23211,21097,35887,23242,19082,12808,14889,14889,10695,14921,19017,21195,19049,8582,10663,12776,19114,16969,16936,23243,48532,48532,46420,48500,46419,48468,46387,46419,46387,46387,48467,48499,46419,44273,44306,46387,46419,42193,46386,57082,57082,57050,57082,59163,57082,57082,57115,48564,37966,46385,37933,42225,16966,19111,21127,40046,37900,46287,48465,46384,42093,46319,48464,44306,6339,4324,4324,6436,25383,27527,14821,4259,4355,10694,6468,6468,4356,4291,4323,2243,2178,4291,14823,10597,4356,8517,25322,16936,21129,21127,23272,23271,21191,19111,16998,16998,16998,19110,21223,27464,33770,33770,37964,29576,25318,27463,33736,31656,21158,16965,8612,6468,4291,2243,4356,6405,6437,16936,16936,21129,31661,27500,19049,27436,16936,10630,12710,6404,18984,35886,37999,35886,35886,35821,27434,19015,14822,10629,10629,6404,20},
{48696,50777,48697,48696,48697,48664,46584,46616,48696,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,50777,48696,48729,50777,50809,50776,52856,52889,50776,52857,52857,50776,50777,50777,33938,14922,14890,19083,19083,19083,19083,21164,23276,23276,23244,23276,23276,21195,23244,23244,23244,21195,21195,23244,23244,23244,23244,21195,21163,21163,21163,21163,21163,21163,19082,19082,19083,16970,19082,19082,17002,19082,17002,19082,19050,16970,19082,19050,19082,19082,19050,19082,19050,19082,21130,19017,19082,19050,19050,21162,25323,25356,23243,23210,23243,21097,37967,25355,19082,16969,19050,21162,12808,19081,29581,33806,29646,14856,17001,21195,29613,31694,27468,33709,44274,44305,54936,44273,52757,48564,48467,54870,44273,56984,44274,52759,50612,48500,54903,44273,57017,59228,59163,57082,57050,57050,57050,57050,57050,57082,57082,46385,37965,37966,40046,33804,16965,16966,23208,42094,39948,46319,50578,44238,44238,46351,50610,37935,4259,6436,6436,10596,25384,25415,8548,6404,12775,10629,8549,8581,6436,2243,4324,2243,2211,4324,12742,10661,6436,6435,12742,14822,19047,19046,23272,23271,21191,19078,19078,17030,14917,19110,21223,27464,33802,33770,35884,31657,25351,23303,23271,14885,6467,2242,2242,4323,2210,2243,4356,6437,6437,25355,25323,25322,29580,12710,8517,27435,14791,16969,16936,6371,25354,42193,33773,37999,40112,29514,12676,6403,6403,6435,6403,4290,38},
{48696,48697,48697,48697,48697,48697,46616,46584,48696,48697,48697,48729,48729,48729,48697,48697,48697,48729,48729,48697,50809,48729,48729,48729,48729,48729,48697,48729,48729,50809,50777,50777,52825,52857,52857,52857,52857,52857,48663,25486,8616,8616,14922,21196,19115,19116,19115,21196,23276,23276,23276,23276,23276,21196,23244,21196,23276,21195,23244,23276,23244,21196,21195,21195,21163,21163,21163,21163,19083,19083,17002,19083,19115,16970,19082,19050,16970,19050,17002,19050,19050,16970,19082,19082,19082,21163,21130,21130,19050,21130,21130,19050,21130,19050,19050,21163,25323,23275,21130,23243,23210,21129,38032,25388,27599,21260,23340,31760,21227,29646,27501,21162,21195,19082,17002,14889,14857,17034,16969,23275,35854,48499,54936,46386,54871,48531,50677,52758,48466,56984,46353,54871,48499,50645,52758,46354,57016,50710,54936,57050,57050,57050,57050,57050,57082,57082,59163,44272,42159,40047,37966,23272,19079,16966,25289,40045,42126,46351,46418,29417,37933,46319,52691,33741,25257,31563,31563,29515,23240,12773,4323,8549,12808,8517,8549,8581,6436,2243,2243,2211,4291,6469,14822,10629,6436,6436,6436,10629,21128,21126,25352,23239,21158,19078,19110,17030,16997,21158,23271,27496,33802,33802,35884,35850,25319,10627,4322,4323,2243,2211,2243,2210,2210,2211,4324,6437,6469,16936,29516,31661,16936,98,12710,31661,19048,21195,10598,10629,33773,37967,18951,40080,40111,25321,8482,6402,4322,4290,4290,2210,12},
{48664,48696,48697,48697,48697,48664,46616,46616,46616,48696,48697,48697,48729,48729,48696,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50777,50777,50809,52857,52857,52857,50744,27534,14890,10729,8649,14922,21228,19148,19116,19083,21196,21195,23276,21195,21195,21195,21195,21195,23244,23276,21195,21195,21195,21196,21163,21163,21163,21131,21163,19082,19082,19082,17002,17002,17002,19083,16970,17002,19083,16970,19083,17002,17002,17002,16969,19082,16970,21163,21163,21195,19082,19050,19050,19082,16969,19050,19050,19050,21130,25356,25356,21130,25323,23243,23210,40178,23275,31760,21195,25421,33872,23308,33873,23308,16969,17002,19115,19115,10696,10663,10664,14889,21195,37967,48532,54903,46386,54904,46451,52758,50646,46418,54871,46321,54871,46354,50677,48564,48434,52725,29449,50644,57082,57082,57050,57082,57050,57050,57082,52790,29482,27435,40079,33804,16997,14885,12806,25321,42125,44238,46352,50579,31563,27370,42126,52724,25290,29547,40079,37967,42224,29611,8580,2243,16968,16969,6469,6469,8549,4356,4324,2243,2211,2211,6404,14822,12709,6468,6436,8549,12742,21160,19078,23271,23239,21191,19110,19078,17030,16998,19110,23303,29577,35882,33770,35916,35850,29544,16933,6435,4323,2243,4291,4291,2243,2243,2210,4324,6437,6437,23242,31629,31661,12710,6404,12678,18984,16968,19114,4259,16903,40112,33741,31595,42160,35886,19047,8547,8515,6467,6402,4290,4290,18},
{48697,48696,48696,48697,48697,46616,46616,46616,48696,48697,48729,48729,48729,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48696,48696,48729,50777,50777,50777,48729,48728,50809,50777,50809,50777,50777,50809,38034,21196,17003,10729,8649,14922,21196,21196,19115,19083,21196,23276,23276,23276,23276,23276,23276,23244,23276,23276,23244,23244,23244,23276,21196,21196,21163,19082,19050,17002,17002,17002,14889,16970,16970,14921,14889,14889,14889,14889,14889,14889,14889,14889,12808,14889,14857,14921,14889,14889,14889,16937,16937,16937,16969,14889,14857,14889,14857,16937,19017,19050,21130,19082,19050,40147,23275,31760,19114,27566,31792,23340,33905,21227,19082,19082,12808,12776,12776,12841,12776,19082,23275,40079,48533,52790,44273,54903,44241,52790,48467,48499,52725,44207,54871,42127,52790,46451,48499,50645,39981,54871,57115,59163,57082,57082,57082,57049,40144,31692,18983,23209,35821,33803,23271,19079,14821,29514,40045,46384,46384,52725,42225,16870,40013,50611,14790,10597,23177,6371,21094,21190,10692,12741,19081,16936,6469,6469,6469,8549,4356,4323,4324,2243,4291,19016,21096,8516,8517,10662,12774,19080,16998,25351,23239,21158,19078,19078,17030,19078,21191,25383,25416,21159,14789,23240,37963,35818,31657,19046,4355,2178,2210,2210,2210,2210,2210,4324,6437,6437,16969,29548,27436,10630,10598,8517,6372,8549,12711,6372,21161,42193,37967,42160,40079,35821,23240,16933,12740,10627,6467,6402,6435,28},
{48696,48696,48697,48697,48664,48697,48697,46616,48696,48729,48729,48729,48697,48697,48696,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50777,50777,48696,48729,50777,48728,48696,48696,46551,29615,21196,14923,10729,10729,14954,19148,19148,19083,19083,21196,23276,23276,23276,23276,23276,23243,23276,23244,23244,23276,23244,23276,23276,23276,23243,23244,21163,21163,19083,19115,19083,19083,17002,19082,19083,17002,19083,19050,17002,17002,16970,17002,17002,16969,19050,21130,21130,21163,19050,19082,17002,19050,17002,16969,16969,16969,19050,19050,23243,21163,19082,21130,21098,23243,40146,21162,25485,16969,23308,25420,21195,25453,17002,16969,17001,14921,12808,12808,17002,14889,21195,23274,40047,52693,50645,48466,54903,46321,54903,46386,52725,50677,46418,54838,44208,54871,46386,50677,48532,44273,57049,57082,57050,57082,57050,57083,48564,27433,27466,21128,37967,31660,35883,23271,21191,19014,31660,37933,48464,48497,54870,42225,29548,44238,48497,16903,6372,23275,16968,23239,19077,16965,29579,10630,10630,6469,6469,8549,8581,4323,4291,2243,2211,2211,12742,16871,6404,8485,10662,12774,19080,14885,25351,23239,21191,21159,19078,16998,14789,16934,16902,12709,8516,8484,12677,25320,23207,21127,16902,6403,4291,6404,6404,4291,4259,2211,4324,6437,6437,6404,25387,23275,8517,10598,8517,8485,8484,6404,8516,31693,42192,33740,40079,42160,31627,29514,29514,19046,14820,12740,10627,10659,48},
{48696,48664,48696,48696,48664,48697,48697,48696,48729,48697,48697,48729,48729,48697,48697,48729,48729,48729,48697,48729,48729,48729,48729,50809,48729,48729,50777,50777,48729,50777,50777,48697,50777,50777,48696,50777,46518,27534,21196,14922,10729,10729,14954,19116,19148,19116,17035,21196,23276,23276,23244,23276,23276,23244,23276,23276,23276,23276,23276,23276,23244,23244,23276,21195,21163,21195,19115,21163,21163,19083,19050,19082,19083,17002,19083,19050,16970,19083,16970,19050,19050,17002,21163,27404,27371,27404,25291,23211,19050,21130,19050,19018,21130,19050,21130,21163,25324,25324,21130,21162,21130,27403,40146,16969,25486,14921,19082,17034,17001,19114,14889,12776,12776,14922,10728,10696,10696,14889,23308,25322,48532,54904,52790,52758,57016,52693,57017,50645,54903,52791,52758,54903,48532,56985,50644,54904,27370,29449,59162,57082,57050,57082,57050,57082,46451,31627,25354,16935,31628,33772,35915,29575,29576,27432,44338,48498,48464,46384,52724,37933,35853,50545,42193,6339,4291,4324,6404,25319,16964,12708,29611,12710,10662,8517,8549,10694,8549,4323,2243,2243,2210,2211,10629,16936,6404,4324,8517,14822,21128,14885,25352,23271,21191,19110,19078,16967,10533,12678,8484,8484,8484,8484,8484,10630,8485,8485,8517,8517,10597,10598,8484,6372,6371,4291,4356,4357,4356,10630,33806,25388,12743,10630,8517,8485,8452,6404,12710,38032,42225,42225,42224,37966,29514,21095,25321,10628,8547,10660,8515,6402,27},
{48697,48696,48664,48696,48697,48697,48664,46616,48729,50809,48697,48697,48729,48697,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,50809,48729,48728,50777,48728,50777,50777,48696,50809,46518,29583,21163,14922,10729,8649,16970,21196,19115,19115,19115,21196,23276,23276,23244,23244,23276,23276,23276,23276,23276,23276,23244,23276,23276,23276,23276,21195,21196,21163,21163,21163,21163,19083,19082,19082,21163,17002,19050,19050,17002,19082,16970,19050,19050,16970,21130,27404,25356,25323,25324,23211,19050,19082,19050,19017,19082,19017,19050,23211,25323,25291,21130,21162,21130,27403,35952,17001,21195,14889,21195,16969,17001,19147,14856,14889,14856,17002,12776,19147,17034,14921,17034,29548,42193,52791,46451,48532,50678,44273,54871,42160,52790,46353,50611,50612,46385,54871,44208,54903,39982,44240,59162,57082,57082,57050,57050,57050,48499,25321,21128,27435,31628,33707,38027,35914,37994,29544,46451,50611,50545,48465,50611,46319,46384,50610,31661,4259,4324,4291,8484,27463,19077,19015,31660,33805,25355,6469,6437,6469,6436,4323,4323,4323,2210,4356,10630,8549,4323,4291,8517,14822,21128,16965,25351,23271,23239,21159,19111,12742,8484,12710,10630,8484,6404,6372,6372,10662,17002,14889,10695,10696,8550,8517,4291,2178,2146,2210,4356,6405,4324,19049,35919,25388,12743,10598,10597,8485,8485,8485,10565,14823,14823,16871,16967,12709,8515,6435,6435,6435,2242,4258,2210,2178,16},
{48697,48696,48696,48696,48696,48696,48696,48697,50777,48729,48697,48729,50777,48697,48729,48729,48729,48729,48729,48729,50809,48729,48729,48729,48729,50777,50777,50777,50777,50777,50809,50777,48728,50777,50777,50809,44438,27502,21164,12842,10729,8649,17002,21196,19148,19116,19083,23243,23243,23244,23244,23243,23243,23244,23244,23211,23211,23243,23243,23243,23243,23243,21163,23243,21163,21131,19050,21131,19050,19082,19050,19050,19050,16937,16970,16970,16937,17002,16937,16970,16970,16969,19050,21098,25323,25291,25291,23211,19018,19050,19018,19018,19050,19018,21098,23179,29517,27403,23210,19017,19050,21162,27469,21194,23340,16969,23308,17034,19147,19147,14889,17002,12808,14921,14857,19147,17034,14889,14888,31628,44305,54903,46386,52757,50580,48499,54838,44240,54903,46385,54838,48499,48531,52758,46353,54871,44272,52725,57082,57050,57082,57050,57082,57082,46418,23208,12774,33773,46385,46417,38027,35946,35914,31657,40078,50578,48465,48498,50579,46351,46351,52723,23210,2211,4291,10565,16902,29545,23239,29611,19016,21096,33774,8517,8517,8517,6436,4324,4356,4323,4355,6468,6436,6436,6404,6437,8549,14822,19048,16966,25383,25319,23271,21159,19111,6436,8452,12678,8517,6372,8485,8517,8517,10662,10695,10663,10630,8550,8517,8549,4324,4291,4291,4259,4291,6437,4356,10662,16968,16969,21130,27403,27403,23210,18984,14823,14791,12743,12711,12710,10628,8515,4322,6435,6435,4355,4323,4291,2210,2178,26},
{48696,48697,48697,48697,48697,48696,48696,48697,50777,50777,48729,48729,48729,48697,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,50809,50777,50777,50777,50777,50777,50777,50777,50777,50777,52857,44438,27502,19116,12842,8649,10696,16970,21163,19115,19083,21130,40048,42096,42161,40080,40048,40080,35855,35855,35887,35855,35854,35855,35855,35822,35854,35855,35855,35855,35822,33774,33742,31661,33741,31661,33742,31629,29548,31629,29549,29516,31596,29516,29548,29516,29516,29516,29483,33677,33709,31596,29516,29484,29516,29516,27436,27436,27403,29484,29484,31628,31596,29483,27371,25323,27403,23308,25453,27599,17001,27599,19115,25453,23373,12776,12776,12808,12776,12776,23308,17002,12776,16969,33709,48498,54936,46386,54871,50580,50645,52758,46385,54903,48466,54903,48499,50645,50677,48531,50612,23014,46420,57115,57050,57050,57082,57082,54937,46451,27466,16934,35788,46386,42223,44269,35915,31689,31658,42125,50578,48432,48530,50579,37901,44206,52756,16871,4291,8451,33774,29581,27467,23240,27498,27402,23176,35886,29547,29515,23242,6436,4324,4291,6436,8644,6499,6468,8580,6468,6436,8517,14854,21096,16965,27432,25351,23239,21159,16967,4323,8484,12677,10597,8484,10533,14824,14824,10598,14856,10597,10565,8484,8452,10597,4291,6404,6404,4259,2211,6405,6437,4356,8518,16969,27435,29483,18984,14758,12710,19049,19017,16936,16904,16903,10661,8547,6467,6435,6435,6467,4354,6435,4354,4354,39},
{48696,48696,48697,48697,48696,48697,48697,48696,48729,50777,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,48729,50777,50777,50777,48729,50777,50809,50777,52857,52857,44438,27502,19115,14890,14922,23276,33776,33808,33808,33775,31694,44338,46451,46451,44338,44338,38032,21130,23210,21162,23242,23243,23210,23243,23243,23243,25323,23243,25324,23243,23243,25323,25323,25355,25290,25355,27403,25323,27404,27403,25355,27436,27436,27468,27468,27436,29516,27436,27468,29516,27436,29548,29516,29548,31661,31596,31629,31629,31661,31629,31629,31629,31628,31629,33709,33773,25420,27566,27566,17002,29647,19114,31792,25453,12776,12808,12808,12841,12809,25421,14921,12809,14888,35886,48499,54903,46353,54871,48467,52726,50644,48466,54903,46354,54904,46353,52758,48531,48499,52758,40014,54871,57115,57082,57050,57082,57115,52823,44305,29514,35852,54870,44305,44238,46415,35883,27465,25321,44206,52724,46351,50611,50612,31531,42125,48531,10533,8517,23143,44306,29580,25386,27466,29547,33741,35886,40111,37965,37933,23241,6436,4291,2210,6436,10692,6499,6499,8613,6436,6436,8516,14854,23208,19078,25351,25351,23272,23271,14854,4356,8485,12677,12678,10532,10565,10565,8484,8485,10597,10565,10565,10565,8484,10565,8485,8485,8452,4291,4291,6404,6405,8517,21162,16904,29548,19049,4324,2178,4291,16936,18984,16937,16904,16904,10630,4290,6435,6435,6435,6467,8547,10724,8579,6435,33},
{48729,48696,48696,48697,48697,48697,48696,48696,48697,48697,48697,48697,48697,48729,48729,48697,48729,48729,48729,48696,48729,48729,48729,48729,48729,48729,50777,50777,50809,50809,50777,50777,50777,50777,50776,52889,44438,27470,19115,25389,33840,42226,44339,42258,44371,42259,40146,38065,38033,33840,29581,29582,27371,23210,23211,23179,23210,23178,23178,21130,21130,21131,21098,21098,21098,19050,19017,21098,21098,19017,18985,19017,19017,16905,18985,16937,16937,16937,16937,16937,16905,16904,18985,16904,18985,16905,16872,16904,16904,16937,16904,16872,16904,14824,14824,16872,16872,16872,14824,14792,14791,16904,25355,29581,25388,19082,27534,19082,31760,23308,19082,17002,19050,21195,16937,25389,14856,17002,27435,46386,48499,54871,44240,54903,46353,54871,48467,48531,52757,44273,54903,44207,54871,46353,50644,59163,59130,57049,57082,57082,57082,57114,59163,52790,40047,29514,44272,54838,35820,46350,37931,16933,10628,14725,44239,52724,46319,50644,44305,37902,46351,44305,6339,6372,25257,50677,29580,25419,27466,23242,10532,29515,37998,35820,33740,14854,4356,4323,2243,4323,8580,8580,6500,6468,6436,8581,6436,12774,25321,19078,27432,25352,23239,21192,10694,6437,10565,12677,14791,10598,8452,6372,6372,4259,6404,8517,6404,8485,6404,4259,6372,6404,6372,4291,6404,6437,6405,8582,16937,12710,31662,23307,6372,4323,6404,19016,21097,23177,23145,21096,18983,16838,14790,12677,10661,8548,8547,12741,14886,8548,32},
{50777,48729,48696,48696,48664,48697,48664,48696,48729,48729,48729,48729,48697,48697,50809,48697,48697,48697,48696,48729,48729,48729,48729,48729,48729,50777,50777,50777,50809,50777,50777,50777,50777,50777,50809,52889,42324,29550,31727,42258,44371,44339,44339,42258,44371,42258,40146,38065,35953,33840,29582,31662,44273,37934,42160,40047,37935,40048,37935,42128,39983,37934,40048,37902,40015,37934,37902,40048,35854,37935,35854,35854,37935,33742,37903,35854,35822,37935,35822,37902,35822,35789,37902,33741,35822,35822,33709,35822,33709,35790,35790,33676,33709,33644,33677,33677,33644,33677,31596,31596,31596,31564,33677,31564,29516,31629,31596,31596,29516,29483,29516,29483,29516,29515,29483,29483,29451,25258,35789,46386,44274,44306,46354,46419,46451,46451,46419,46419,50645,50677,50710,50677,46484,46451,48532,48565,50677,57049,57082,57082,57050,57082,57114,50677,50579,46385,52724,52725,39981,42156,21094,16966,10661,16902,48465,52756,46319,52757,44207,37901,50578,37968,4291,2211,31597,50710,29580,25387,29547,37966,33675,35853,40111,35885,21128,10629,6436,6436,4324,4291,4323,6435,8548,4355,8548,8581,4355,12741,23208,16933,27432,27432,25352,21160,6469,6437,10630,10597,17001,19179,6404,4291,4291,2211,8582,12841,4324,6502,6534,4291,4324,2178,2179,4291,4323,6437,4357,6469,19049,23177,31661,25420,8549,10597,21129,42192,44273,44240,44240,44240,44240,44272,42127,35821,23209,16936,14856,8517,4291,4291,32},
{50809,48729,48697,48697,48696,48696,48696,50777,48696,48729,48729,48729,48697,48729,48697,48696,48696,48729,48729,48729,48729,48729,48729,50777,50777,50809,50809,50777,52890,50777,50777,50777,50777,50777,50777,52857,42259,33808,35888,33840,33840,42259,42258,42258,44339,42226,38033,33807,33742,38001,35920,37935,48466,37934,44273,40079,40047,44241,39982,44240,42127,40047,44273,40015,44273,40047,40015,44273,37966,42160,40079,37934,42192,37935,42160,40079,37966,44273,40014,42160,44208,37934,44240,39982,42127,44208,37901,44240,37933,42127,44208,37934,44240,40014,42095,44208,37901,44208,39982,40047,44208,35821,42127,39982,40014,42160,37901,42127,40014,39982,42127,37869,42127,40014,39949,42127,37869,37967,35822,31596,25323,25290,23210,23210,25322,25290,23242,25354,35854,35854,38065,38098,27468,27403,27403,29548,31661,35822,50612,57016,48563,54903,57017,54936,54969,57082,57082,54904,44271,42156,19046,19046,10628,23176,50611,52691,46319,52724,48432,46351,50643,27467,2211,4291,40112,52823,29580,29580,31660,21064,33741,40079,27434,16934,8516,8516,8549,4323,4324,4324,2243,2210,2243,4291,12742,10661,6436,16935,25355,14854,25353,27466,25385,21225,8550,8518,10597,10565,14889,19179,6437,4324,4291,2211,6469,12808,4324,6534,8615,4292,4292,98,2211,4323,4291,6437,4389,8550,25355,33774,31694,21194,8516,10597,31660,44241,35853,44240,44272,44272,44272,37934,31660,27435,16968,12742,10630,4291,2178,2178,24},
{52857,50809,50777,50777,48697,48696,48697,48697,48697,48729,48729,48729,48697,48729,48697,48697,48697,48697,48696,48729,48729,48729,48729,48729,48729,50777,50777,50809,52857,50777,50777,50809,50777,50777,50776,50809,42227,33841,15281,13299,13168,25486,44339,42258,44339,40146,33807,27468,33807,40178,38033,40080,44306,38000,42193,40112,40080,44306,37966,44240,42127,40047,44273,40015,44241,42127,37934,42192,37934,42127,42127,37901,42192,37934,42127,40047,37933,44240,40014,42095,42160,37902,44208,39982,42095,42159,37901,44240,40014,40047,42192,37902,42160,37966,40047,44273,37901,42160,40014,37934,44208,37901,42127,40014,39949,44207,37869,42094,40013,37869,42159,37901,42095,42095,37901,44240,40048,44404,42259,33840,33873,33840,33840,33840,33840,31760,31727,31760,31727,25421,31727,40178,27469,25323,27403,29516,29548,27370,48564,54870,44272,54903,48597,44403,52856,52888,48630,33773,42190,44301,31690,21159,14854,27401,52691,50578,46320,52724,46351,46351,52691,25289,10629,10596,42225,52823,29581,27468,33773,21063,27370,40046,27433,21128,10629,12742,8549,6404,6436,4324,2243,2210,2211,4323,16903,14854,14888,27567,27567,25486,27567,27567,27567,25486,23374,19115,10630,10565,16969,19114,8517,6404,6404,4291,8550,12808,6404,8582,10663,6404,6404,2211,4291,4291,4324,6437,6437,6437,21129,37999,27468,14823,6404,14823,37999,44305,40047,44272,44272,44272,35821,21097,12743,10629,10662,6436,4291,2178,2178,2210,12},
{50809,50809,50809,50777,50777,50777,48729,48696,48729,48729,48697,48729,48729,48697,48729,48697,48729,48697,48729,48729,48729,48729,48729,48729,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,50777,52857,44372,34036,15575,11088,15477,29909,44306,42258,44339,40146,29581,25388,19050,14889,16969,16970,19082,21162,23243,21162,25323,46418,37934,44240,42127,40014,44240,39982,42160,42095,37902,44240,39982,42128,42127,37902,44240,40014,40047,42159,37901,42191,37934,40047,42160,37901,42160,40015,40015,42160,37901,44240,40015,40014,44208,35821,42127,40046,40014,44240,37868,42127,40046,37901,42159,37869,42095,42127,37901,44208,39982,40014,42095,37869,44208,37934,40014,42127,37901,44240,42258,44404,40178,33840,33873,33872,33872,33840,33840,33872,31792,31760,29647,27502,25388,35985,31694,35854,31660,35854,35886,37901,52789,44240,37901,54936,46516,48629,52856,42226,33840,29515,44270,46349,44269,25320,16934,33707,50610,48497,46352,48497,46384,46351,50643,23176,21161,14789,37999,54872,31629,33774,35886,37934,33708,44239,37933,23241,8549,8517,10629,6468,6436,4324,4291,2211,2211,2243,10597,10661,23307,27599,25519,27600,27567,25519,25519,25455,25455,14922,8549,12645,14791,8485,10565,10597,10565,6404,8517,8517,10565,10598,12646,8485,8485,8485,6436,4291,4324,6469,6405,6469,27468,31661,21096,16968,12710,25290,44305,29580,37966,44272,46320,33773,14822,6436,4323,6403,8516,4323,2210,2210,2210,2211,13},
{52857,50809,50777,50809,50809,50777,48697,50777,50809,48729,48729,48729,48697,48697,48697,48697,48729,48697,48729,48729,48729,48729,48729,50777,50777,48729,48729,50809,50809,50809,50809,50776,52857,52857,52857,52857,44405,38131,32021,23733,27862,40244,42227,42259,42259,35952,27533,25420,14889,10664,12744,14824,14857,16937,16937,16905,19017,42160,40015,42160,40015,40047,44273,37934,42160,42128,40015,44241,39982,42128,42160,37934,44241,39982,40047,42160,37901,44240,40014,40015,44240,37901,42160,42096,40014,44240,37901,44208,42095,39982,44208,39981,42127,42127,37901,44207,37901,40047,42127,37901,42160,37901,40014,42160,37901,42127,37934,40014,42159,37901,44208,39982,39949,44207,37869,44272,42258,35985,33840,33872,33872,33840,33872,33872,33840,33872,31759,35985,40179,38066,35953,33840,40146,37967,25257,25322,23241,31660,52822,37934,37933,57049,52758,52823,57050,54904,48565,33740,44302,46381,44301,27465,16966,35852,50610,46383,48465,44239,46318,48432,48499,16772,18917,18917,37999,52856,31661,35887,23177,18951,42160,37965,21096,8517,8550,14889,10694,8581,6469,4324,4292,2211,2211,4291,8517,10597,29647,25454,25487,25519,25519,25519,25487,25487,25487,12809,8485,12645,12743,8485,8484,6404,6372,4259,4324,8517,8517,8485,6404,4291,4292,6372,4324,4291,4323,6404,6437,6437,19049,21130,12710,12742,16903,31628,42192,25321,42192,46352,42159,16935,6403,4356,2243,4323,4291,2210,2210,2210,2211,2211,14},
{52857,52857,50809,50809,50809,50809,50777,50777,50809,48729,48729,48697,48697,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,50777,48729,50777,50809,52857,50809,50777,52857,52857,52857,52857,54970,35954,16905,19018,19018,19018,19017,19017,19017,19049,21163,23275,25356,25389,27437,27437,27469,27437,27437,27437,27437,27436,31597,33710,42162,35854,44273,46386,37870,42095,42095,39982,44241,39982,42095,42160,37901,44240,40014,40015,42160,37901,44208,40014,40014,44208,37869,42127,42095,40014,44272,37934,42127,42127,37902,44240,37934,40047,42128,37901,42160,39982,40015,42160,37869,42127,40014,39982,44240,37869,42095,42094,39981,42159,37901,42062,42127,37901,44239,37868,44272,42226,35952,33872,33840,33872,33872,33872,33873,33840,33840,29679,38033,42292,40211,38098,33840,42259,37967,31628,29516,25354,25321,48596,37966,37934,54968,54936,52790,50677,44338,50677,40079,44270,44269,44301,27432,16901,37965,48466,44239,50578,39949,39915,48464,50545,37704,43911,46187,46450,52823,33741,37999,42160,35853,42192,40046,27435,19017,10598,12711,10630,10694,6469,2243,2243,2211,2243,2211,4323,8517,27599,25454,25422,25487,25487,25487,25519,25455,25487,19148,10630,10565,10662,8582,6437,2276,2211,2211,4356,10728,8615,6437,2211,2211,2211,6404,4291,2211,2211,4356,6437,6437,8582,14889,6469,6437,16936,40047,44272,40079,46352,46352,37901,12709,8516,6436,4291,2210,2210,2210,4291,2211,2178,2178,14},
{52857,52857,52890,52857,50809,50777,50777,50777,50777,50777,48697,48729,48729,48729,48729,48729,48729,48729,50809,50809,48729,48729,48729,50777,48729,48729,50809,50809,50809,52857,52857,52857,52857,52857,52857,52857,46518,38001,38033,40114,40081,38033,38001,33807,33775,29549,23308,23308,38001,42226,42194,42194,42194,42193,42194,40113,40113,38033,31727,31630,31693,40015,46321,37902,42128,42128,39983,44241,40015,42095,42160,39982,44241,42095,42095,44208,40014,44241,42127,40047,44273,37934,42192,40112,37966,44273,37966,40112,42193,37934,42193,40015,40047,44241,37902,44240,40046,40047,44240,39982,44207,42094,39982,44240,37868,42095,40014,37934,42160,40014,40014,42160,37901,42127,37934,44273,42259,33840,33840,33872,33872,35953,33905,33873,33872,33872,31727,35953,42292,40211,40179,31759,25388,40113,40080,25322,23274,25321,44338,37966,25289,23209,27434,27434,19015,21096,40112,40046,42125,46349,44269,31689,21127,37901,50612,48498,50578,46126,44076,50578,44306,16837,23110,35722,42225,54904,35919,33806,23209,37999,44304,40078,18984,14824,14823,8485,8484,8581,6436,2211,2243,2243,4291,2211,4324,8549,27599,29647,25422,25486,25487,25487,25487,25487,25487,21294,10663,10565,12711,8582,4389,2276,4292,2211,4324,10696,8615,8583,2244,2179,2211,4356,4324,2211,2210,4356,4357,6437,6469,10631,6469,8549,23241,44272,46385,46352,46352,44272,29514,10661,6435,4323,4323,4323,4291,4291,6469,6404,4323,4323,26},
{52857,52857,52857,50809,50777,50777,50809,48696,48729,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48729,48729,50809,48729,48729,50777,50777,50809,52857,52857,52857,52857,52857,50777,52857,52857,52857,50744,44307,44307,46387,42226,44307,44306,42194,40114,33775,27469,23243,35855,44274,40113,40113,42193,40113,40145,40113,40145,27469,14824,12712,19081,40112,37967,27403,29484,29516,29483,29516,27403,27403,27403,25290,29516,29483,29451,31596,29484,29484,29484,27403,29516,27436,27436,27435,27371,29484,27371,27403,29516,29515,31596,27403,29451,29516,27370,29516,27403,27403,29516,27403,29516,29516,29483,35789,42127,40048,31694,21130,23210,23243,23210,23243,23210,23242,23242,42194,40114,33840,31760,27533,29614,29614,29646,29614,29614,29614,27502,25421,29614,27534,23308,19147,21195,40146,31661,16904,19016,21128,42257,40080,29515,14822,10629,23273,25353,25354,25322,35853,42157,48462,44269,29609,29514,48531,52790,52724,52756,48367,46221,50611,31595,16902,16902,12676,31661,54969,35887,33774,18950,31660,44304,33772,8517,4324,8517,8485,6436,8581,6436,2243,2243,2243,4324,4324,8517,10661,27567,27534,19115,25454,25487,25487,25487,25455,25455,21261,8582,10565,12743,10598,8485,6436,6404,4291,6437,10662,8582,8582,6404,4259,4324,6404,6404,4291,4291,4356,4356,4357,4389,6437,6469,10630,27500,44273,44273,44272,44272,44240,29514,8515,2274,4323,4355,4323,4356,6469,6502,12743,19114,21162,51},
{52890,52857,52857,52890,52857,52857,50809,48729,48729,48729,48729,48697,48697,48729,48729,48729,48729,48729,48729,48696,48729,48729,50777,50809,50777,50777,50777,52857,52857,52857,52857,52857,50809,50809,52857,52857,52857,48598,42258,44339,42226,44307,42226,42258,42226,33839,27501,23243,29549,38001,35855,37968,38000,31694,27501,27501,29581,23210,16905,14889,14856,25322,44306,35822,40047,40048,37902,42128,37902,40015,40047,35789,40048,40015,37902,42128,37902,40016,37935,35789,40015,35789,37870,37902,33709,37935,35789,33709,37934,33708,37870,33709,33676,35822,33644,33709,33709,29515,33709,31596,31629,33741,29515,35821,44176,35821,31628,25258,25290,25258,25225,25258,25225,25225,25257,44339,35920,27469,27501,25356,27501,25420,27501,25388,25388,25389,23308,23308,23308,21228,17002,17002,23276,42259,25388,19016,19080,21160,42225,40112,31628,14855,8549,12774,16967,27435,33774,35789,40044,48495,33771,10627,35886,56951,50610,48465,52757,50545,48399,52659,21096,6436,14854,12677,31694,54904,44339,35821,35852,44272,44271,35821,10598,4292,12678,12677,12645,10597,4323,4291,4291,2243,4323,6437,12742,14854,31825,25454,19114,21259,23373,25486,25486,25487,25487,23374,12776,10532,14790,10565,10532,10533,10565,10533,12710,10597,10565,10565,10532,8484,10597,8484,8484,6372,4291,4356,4389,4357,4356,10663,14856,6437,8517,10597,14758,16870,14758,14757,12740,8547,6468,4355,4355,6468,8550,6502,6470,8550,14888,16968,49},
{52890,50809,50777,52857,52857,52857,50809,48729,48697,48696,48729,48729,48697,48729,48697,48697,48729,48729,48729,48729,48729,48729,48729,50777,50777,50809,50777,50809,50809,50809,50777,50809,50809,50809,52857,52857,52889,52857,46453,42258,42226,44339,42258,44307,44339,38065,29581,21163,21131,23243,21195,23243,21163,16938,12777,12744,14856,33709,29516,29549,29516,31596,44305,37934,42095,42160,39982,44208,40047,40015,42160,37901,44208,42095,37902,42127,39950,42128,42159,37933,44208,39981,42094,44207,39982,44208,40015,40014,42192,37934,42127,42127,37934,44273,39982,40015,44208,39982,44208,40015,40014,44240,39949,44207,42095,37869,44208,39981,42062,42127,37869,44207,39981,39981,44207,48532,33839,16936,16937,19082,21162,21162,19114,23308,31792,29614,19082,21163,21163,19082,14921,14953,27469,44339,23274,21194,23273,23208,40145,40112,29515,14855,14855,21161,16935,29548,37966,52758,42157,40044,19014,14853,37966,52724,50578,48432,52789,48497,46351,50611,12710,4356,16935,14822,27469,52856,54936,21064,14757,42192,42126,31628,18951,29385,41963,35592,33544,10596,2243,2243,4323,2243,4323,4356,8516,19080,40244,29647,14855,12743,23372,19178,17034,25454,10695,8550,6437,8484,12710,10565,10532,10532,10565,10565,12710,10597,10565,10565,10565,10533,10597,8485,8484,6404,4291,4291,4389,4389,8517,16969,16969,8485,4324,14790,25321,21031,6339,4291,8547,8579,6499,4322,6437,8550,8550,8550,8550,8549,12743,14888,50},
{52890,50777,50809,52857,52857,52857,50809,48729,48729,48696,48729,48729,48729,48697,48697,48729,48729,48729,50809,48729,48729,48729,48729,50809,50777,50777,50777,50777,50777,50809,50809,50841,50809,50809,52857,52857,52857,52857,52857,46518,42226,44338,44306,42258,44339,42226,33839,27501,25421,27502,25389,27534,19082,14857,14857,14857,19017,46354,37934,42160,42127,40014,42160,39982,42095,42160,39982,44208,40014,40014,44240,37934,42127,40047,37934,42159,37934,40047,42127,37934,42160,37934,40014,42160,37902,42128,42128,37902,44240,37934,40047,42160,37902,44208,39982,40014,44208,37901,42127,40014,39981,44207,37901,42062,44207,37901,44207,40014,40014,42127,37901,42127,40014,37933,42159,52759,48598,31694,25388,27469,27533,25388,29614,33840,23243,21195,25356,25388,25388,23308,21195,19082,29582,42258,21161,25354,25386,25321,40080,40144,25353,14854,12742,25386,21128,33741,42159,52757,42190,31625,12773,14886,29481,48432,48465,48464,52789,48464,48463,46418,8484,6404,14854,14822,27436,52824,50677,37966,35788,42159,40013,29515,35853,46188,43977,41896,35624,8516,4356,2243,4323,4323,6500,8581,4323,23274,42325,27567,19114,21227,25486,23373,21260,21292,6469,130,4291,8485,12710,12645,10532,10565,10565,10532,12678,12646,10565,10565,10565,10565,10597,8517,6404,4323,2211,2243,6437,6405,8518,16937,19017,21097,31563,35755,27337,8484,4291,4291,6403,6435,8580,12806,17001,12743,10663,10630,8550,8582,16969,19050,45},
{52889,52857,50777,50809,52857,50809,50809,50777,50809,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50809,50777,50777,50809,50777,50777,50809,50809,52890,50809,50809,52889,52857,52857,52857,52857,52889,50711,46452,42226,42226,42258,40145,38000,33808,29550,29582,27469,31695,31629,27404,27404,27404,29451,46354,37934,42160,42127,37934,44240,39982,42095,42127,37934,42160,40014,40014,42192,37934,42160,40047,37934,42160,40015,40047,42160,37934,42192,40014,37934,42160,37934,42127,42128,37934,44240,39981,40014,42159,37901,42127,39982,39981,44207,37901,42127,40046,37869,44207,39982,40014,40047,35821,42127,40047,40014,44240,37902,40047,42127,37901,42160,44307,46485,33840,31759,33839,33872,31759,31727,38066,21130,23243,25421,25421,25421,25421,23308,21227,33807,40145,16936,19081,19049,23209,38032,40080,23208,14854,10693,16935,19016,31629,33741,48498,42190,21159,14853,14853,31626,48464,48464,48432,52789,48400,50544,42192,16902,27401,14854,10629,27435,52856,42226,19015,35886,42191,37900,29515,29548,35821,41930,43977,35591,8483,6436,4324,4323,4356,8581,8581,8484,29614,40212,29647,21227,27534,27567,25487,25487,25454,10759,6533,8549,10597,12710,10597,8485,10598,10630,8517,10630,12710,10598,8517,8517,8485,10598,6437,4356,4291,2211,2243,6437,6469,6437,8550,16969,25355,35788,31529,19016,6436,4291,6436,4355,4355,4355,12774,31693,29581,29548,27467,19049,8517,10598,10630,37},
{52890,52857,50777,50777,52890,52857,50809,50809,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,48729,50809,50777,50777,50777,50777,50777,50777,50809,50777,50809,50809,50809,50809,50809,52857,52857,52857,52889,52857,50777,52889,54937,50711,44372,44372,44372,44340,44307,37968,37968,35855,39983,48434,37934,42160,40014,40014,42160,37902,42159,40047,37902,42160,37966,40079,42160,37934,42192,37967,37966,44273,37934,42128,42160,37934,42160,40048,40079,44240,37902,42160,40046,37901,42159,39982,42094,42127,39981,42159,40014,40014,44207,37901,42127,42095,37901,42127,37902,40014,42127,37869,42127,40014,40079,50677,40047,40047,42095,37901,42159,40014,40014,44207,37901,42127,37967,40178,35953,33905,33905,35953,33873,31760,38066,21162,21162,25388,25388,25388,25388,23275,21195,35920,33807,14823,14888,19049,23242,35918,42224,31627,27401,23209,19016,23210,35822,31563,48498,44271,31658,19078,19046,33739,48432,48496,48497,52757,48399,50578,35822,14789,27434,10596,8516,25354,54969,46452,25289,31628,42158,33708,29548,27370,31595,46122,48136,31462,8516,6468,4356,4356,6436,6436,6436,14855,38066,36018,29712,21227,25486,27567,27567,27567,25454,17066,10792,14920,10597,12678,10630,6437,6469,6437,6404,10630,10695,8550,6404,6437,6404,10598,6437,4356,4291,2210,2210,6437,6470,6437,6405,12711,16936,21161,25322,8484,4323,4355,6499,6499,8547,6402,19048,31693,31661,31661,29548,19016,6437,10629,12742,41},
{52889,52857,50777,50809,52857,50809,50809,50809,50777,48729,50809,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,50777,48729,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,52857,52857,52857,52857,52857,52889,52889,52857,52857,52890,52856,50678,52758,50678,50645,48532,37934,40112,37934,37967,42193,37934,40080,40112,37967,42193,37967,40080,42193,37935,42193,40048,40047,44273,37967,42160,42192,37966,42160,42128,40079,44272,40014,42159,42127,37901,44208,40014,42095,44240,40014,44240,42127,40014,44240,40014,42127,44208,40014,44208,40015,40015,44240,37902,42127,40047,42127,52790,42095,42062,42159,37901,42127,40014,37933,44207,37933,40047,40113,46452,35953,33905,33905,33905,33873,31760,33840,25420,29581,29614,29614,29614,29614,29614,29549,42291,33774,23177,25258,25322,25290,35886,52823,57049,50644,29515,29580,35854,37967,37998,46418,40013,37932,31658,21159,33740,42158,48496,50611,52723,48367,52658,29515,8580,4356,4323,12773,23273,52757,52790,48497,44272,42126,35789,29548,35821,46188,44008,50216,35623,6436,6436,4323,4323,6436,6404,6404,14856,40211,38164,29712,21195,27534,27567,27567,27567,23405,14953,12840,12808,10597,12678,10630,6437,4356,4291,4324,12678,6469,2211,4291,4291,4291,8517,6404,2211,2243,2210,2210,4356,6437,6437,6405,6437,16969,16968,8548,4322,4323,8548,10692,8579,8580,8579,27499,31693,31661,25419,19048,8550,8550,14823,16968,51},
{52889,52857,52857,50809,50777,50777,50809,50809,48729,48729,48729,48729,48729,48729,48729,48697,48729,48729,48696,48697,50777,50777,50809,50777,50809,50777,50777,50809,50841,50809,50809,50809,52890,50809,50809,52857,52857,52857,52889,52857,52857,52857,52889,52857,50777,50776,52857,50809,50809,52889,52890,48663,42324,42324,38098,31695,42324,42324,42291,42324,35985,25388,27501,27469,27501,27501,25389,27501,27501,27469,27501,27468,27469,27501,27468,29549,25355,25387,29548,27435,29515,29548,27436,27468,27436,29516,29548,27436,29516,29516,27436,31597,29548,29581,31629,29516,31629,31628,29548,31629,29548,31661,31628,35821,46419,33741,33676,35789,33676,33740,33773,31628,40047,38032,33808,35920,44404,35921,33872,33840,33872,35921,33840,31727,31727,31727,29646,31727,31727,31694,31727,31694,44339,42192,40047,40047,42160,44272,42159,54936,50678,37966,31627,33773,38031,40079,46353,46385,37933,37932,35883,21094,42193,46353,48465,50611,50610,46318,50610,29482,12773,4356,4323,16966,14821,25190,46287,42191,37966,40078,31660,31629,31628,48300,46089,44009,35819,8580,8548,8548,8549,6469,4323,6436,23340,40244,40277,31793,21195,27534,27567,25453,23405,23405,10663,2178,4291,10565,12678,10630,8485,10598,10598,8517,10630,8550,6404,6372,6404,8485,10598,8485,4291,4323,2211,2211,6404,6437,6405,6404,12711,14823,14855,8548,6467,8516,6403,8580,8579,8612,8547,25386,33773,31661,16936,10662,8517,8582,10663,10630,48},
{52857,52857,50809,50809,50809,50809,50809,50809,50777,50809,48729,48729,48729,48729,48729,48729,48729,48729,48729,50777,50777,48729,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,52889,50809,52857,50809,50809,52857,52857,52889,52889,52857,50809,50809,50809,50809,50809,52857,52889,48631,40243,42324,38098,29647,42325,42324,42292,42357,31793,23341,23373,23341,23341,23341,21261,21228,21228,21196,21196,21196,19148,19148,19115,19115,10696,12776,16937,16969,19017,16969,16969,19017,14889,12776,12776,14857,12776,12744,12776,10663,12776,14824,12743,12743,12744,10663,12744,12711,10663,12743,10663,12776,12775,12743,16904,16936,16904,16937,14824,14758,35887,38131,31761,35921,46484,46517,46517,46485,46485,46485,46453,46453,44404,44404,44372,44372,44404,44372,44372,44371,35887,19016,23241,44273,33740,29547,40046,54935,40145,31726,27499,37999,46451,44272,46385,48499,44271,48463,44270,27400,48596,50546,48465,50611,50545,48464,50610,21095,14854,4356,4356,12806,14885,25222,39914,42192,40079,42192,31661,31661,37933,37803,20966,12677,14854,10693,8581,8581,8581,4356,4356,6436,31760,40244,40277,31825,21195,19179,23340,23373,21228,25487,12809,2146,4259,10565,12678,12742,10565,10565,10565,10597,10597,12711,10597,10597,10565,10565,10565,10598,8485,4323,2211,4291,6437,6437,6405,12743,12678,10532,10628,8580,10660,8516,4290,4355,4355,8580,8579,10628,27467,33774,16903,10630,10662,8582,10663,14856,44},
{52857,52889,50809,50809,50809,48696,50777,50809,50777,48729,48729,48729,48697,48729,50809,50809,48729,48729,48729,50777,50777,48729,50777,50809,50777,50809,50809,50777,50777,50809,50841,50809,50841,50809,50777,50809,50809,50809,52857,52889,52889,52857,52857,50809,50777,50777,50809,50809,52857,50809,52857,48663,40243,42324,36018,27534,42357,42324,40244,40244,40244,40211,38131,36019,36018,33906,31826,29713,29713,29680,27567,27600,25487,27567,25422,23341,10728,12809,16969,16969,19082,17001,19050,21162,16937,14857,14856,14889,12776,14856,14857,12776,14857,14857,12744,12776,12776,10695,12776,12744,12744,12776,10695,12776,10663,12743,16937,14856,16904,19017,14824,18952,42193,36019,29712,33840,50710,57082,57082,55002,57050,52856,54969,52823,50775,54937,55002,54970,54970,54970,54970,52856,29580,8517,10662,42257,29515,14821,40047,52790,33773,16935,10629,25322,40079,44239,46418,48498,44238,48497,44237,31561,48530,50545,48432,50610,48432,44206,27370,10597,8549,8581,10661,12741,19046,25255,39916,42160,44305,40014,31628,33709,35789,8452,4357,6469,6436,8581,6500,8581,6468,4323,4356,10695,33937,40244,42358,33906,17034,12840,23373,25454,14889,25454,19115,8582,10630,12646,12646,12710,8484,6404,6404,6404,10597,12743,10630,8517,8517,8517,8517,10630,8517,4291,2211,4323,6437,6437,14824,12646,10532,10596,10692,8580,8547,6467,6403,4323,4323,4322,6435,8515,8548,27499,27435,25355,19049,8517,6469,14856,36},
{52890,52889,50809,48696,50777,50777,50777,50777,50777,48729,48697,48697,48697,48729,48729,48729,48729,48729,48696,48729,50777,50777,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,52889,52857,50809,50809,52857,50809,50809,52857,52857,52857,52857,52857,52857,50809,50809,50809,50809,50777,50809,50744,48631,48663,46550,42357,48631,48631,46551,46583,48663,48631,44470,40309,36116,33972,33972,31923,31859,29778,29778,31825,33905,35920,33807,31727,12841,12776,16969,19050,19050,16969,16937,19049,14889,14856,12776,14889,12776,14856,14857,12776,14857,14857,12776,14857,12776,12776,14856,12776,12776,12776,12744,12776,12776,12743,14856,14856,14856,16937,12775,16936,44339,40179,35986,38065,50710,55002,54970,54937,54937,50743,52856,50711,50743,52856,54937,54969,54969,52824,44371,35952,19048,10630,8549,31757,23240,16901,42193,59162,54903,31628,14822,35886,48465,46254,48466,48531,42159,48464,42157,33641,48433,50545,48464,46385,27433,27337,12677,6437,8517,10662,8548,10693,14821,23143,35788,46419,48531,33708,33741,31628,35756,8484,10631,10630,6436,8549,8581,6468,6436,4324,4323,12775,33873,38164,36051,33906,21227,27534,27567,25487,27567,29648,27567,27600,21260,12678,12645,10597,4324,4324,4324,4291,10598,14888,12840,8582,6501,6437,8517,10695,8615,4291,4291,4323,4356,8582,19049,14758,10532,10564,12773,8547,6435,6467,8580,4323,4355,4323,4323,4355,6403,14822,31693,31661,21129,8550,8517,12743,40},
{52890,52890,52857,50777,50777,50777,50777,50777,48729,48729,48729,48697,48729,48729,48729,48729,48729,48729,48729,50809,50777,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,52889,50809,50809,50809,50777,50809,50809,52857,52857,52857,50776,52857,50809,50777,50809,52857,52857,50809,50809,52857,52889,52857,52857,52889,50809,50809,50809,50809,50809,50809,48696,44503,40310,36182,36149,36149,34036,23374,17035,21228,25355,25355,25355,23275,12776,12809,16969,19017,19017,16969,19050,21130,16937,14856,14889,14889,12776,14857,14857,12776,14857,12776,12776,14857,12776,12744,14856,12776,12744,12808,12744,10696,12776,10695,12776,14856,12776,14856,12776,16903,46452,57082,54969,48597,50743,55002,54970,54970,54970,50711,52856,48598,48630,54937,54969,54969,54969,52823,52856,42226,23209,12775,8549,25418,16967,19080,33773,42192,42192,33805,19015,27467,37966,48432,46385,52758,50579,46383,40077,31594,48497,50545,46351,40046,19014,27402,14758,8517,8549,12742,12773,8549,4291,16870,31530,48532,48532,33709,31661,42127,42061,14790,10630,10662,6469,4323,2275,6468,6436,4323,4291,14856,25388,38099,31792,33938,23276,21162,25421,29648,27599,29648,25487,19148,16904,14757,12645,10597,4324,4292,4323,4291,10565,12808,10727,8615,8582,6404,8517,10630,4389,2243,4291,4291,4356,12743,17001,19081,16871,10564,12741,10660,8547,6467,8548,8548,4355,4355,4355,4323,6435,6435,16967,19081,10630,8550,8582,8582,55},
{52890,52889,52889,50809,50777,50777,48697,50809,50777,48729,48729,48729,48729,48729,48729,48729,48729,48729,48729,50809,50777,50809,48729,50777,50809,50809,50841,50841,50809,50841,50809,50809,52890,52857,52857,50809,50777,50809,52857,50809,52889,52857,52857,52857,50809,50776,50809,50777,50777,50809,50809,50809,50809,52857,50809,50777,50809,50809,50809,50777,50777,50776,48696,44503,38262,36150,25487,21260,21261,12809,12809,16970,17002,19050,16970,14921,10696,14857,16969,19049,19082,21130,21162,23243,16969,14857,14856,14889,14824,14857,14889,12776,14857,12776,12776,14857,12776,12776,14857,12776,12776,12776,12744,12776,12744,12744,12776,12744,10663,12776,10695,14856,48597,59196,50710,44338,52823,54970,54970,54970,54937,50711,54937,52824,52824,54969,54937,52889,52889,54937,57083,42226,25322,10662,12743,35951,14886,12806,23241,16934,16967,21160,19047,25321,40046,44271,46418,50612,48497,44270,29513,31594,50577,48464,48432,46353,33739,29417,12678,10630,10630,10630,8581,4324,2211,16838,29385,37967,42226,33773,31628,35756,37868,23242,14823,8581,6436,2243,2243,8548,6468,4356,4356,14856,19050,38131,40212,33938,25388,16937,23308,29680,29680,29680,25422,10663,12645,14758,12645,12678,8452,6404,6404,6372,10565,12775,12743,10662,10630,10598,10597,10695,8582,4323,2210,2210,6404,16969,16969,19017,21097,23177,14822,10660,12772,10660,10628,10660,6435,4355,6467,12740,8515,4322,6468,14888,8550,8550,8550,8582,53},
{52890,52857,52857,50809,50777,48729,50777,50777,50777,48729,48729,48729,48729,50777,50809,48729,48729,48729,50777,48729,48729,48729,48729,50777,50809,50809,50809,50809,50809,50841,50809,50809,50809,52857,50809,52857,52857,50809,50809,52857,52857,52889,52889,52857,52857,52857,50809,50777,50776,50809,50777,50777,50777,50809,50809,50777,50809,50777,50777,50777,50777,50809,48696,42422,38229,36117,19115,14857,16970,12809,12809,16969,17002,19050,16969,14889,10728,16969,16969,19050,21130,23243,21130,25323,16969,12776,14856,14889,12776,14856,14889,12776,14857,14857,14857,14856,12776,12776,14856,12776,12776,14856,12743,12776,12776,10696,12744,10695,10696,12776,10696,16904,48598,57082,44339,42226,52856,54969,52889,54969,52856,50743,54969,54969,54969,54937,54937,52889,52888,52856,54970,40113,27467,12775,12775,25386,16999,14886,23240,16967,12806,19080,21160,25321,37998,42158,46450,48531,44304,44270,31594,33707,48465,46351,48465,50611,48464,35755,27305,14791,10630,8550,6437,4356,4291,21031,40015,31564,33709,31693,35854,48432,31530,14791,19017,14855,4356,4324,4323,12805,8580,8548,8550,17001,16969,36018,40277,38131,35953,38099,38099,38099,38099,38099,38132,38067,27437,16936,10565,12742,10597,10565,10565,10565,10565,12743,10630,10597,10597,10565,10565,8550,4323,2210,2210,2210,4323,12743,14856,16936,21129,25322,16902,10692,10692,10692,12772,12740,8547,10628,8547,10628,6435,6435,8549,10695,8550,8550,6502,8550,50},
{52890,52857,52857,50809,50777,48697,48697,50777,50777,48729,48729,48729,50809,48729,50809,48729,48729,48696,48729,48729,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52889,52857,52857,52889,50809,50809,52857,52857,52857,52889,52857,50777,52857,52889,52857,50809,50809,50809,50777,50776,50777,50809,50809,50809,50777,50777,50777,50777,50809,48696,42423,38230,36117,21196,14857,17002,14889,12809,17002,17002,17002,16970,14889,12776,19082,19049,19050,21162,19049,19049,23243,19050,14857,14856,14889,14856,14857,14889,14856,14889,14857,14824,14857,12776,14824,14856,12776,12776,14856,12744,12776,12776,10696,12776,10663,10663,12744,12743,16936,50711,57050,44338,40178,54937,55002,54969,54970,52856,50776,54970,54969,54969,54970,54969,54937,52889,52856,54969,44338,23241,8582,10695,8517,8549,16967,29579,16999,16968,14855,10661,25321,35918,40079,44305,48564,42160,44302,29514,35852,54804,50578,48498,50610,48432,33675,29450,21130,16969,16968,10662,6404,4323,27435,44273,35821,29547,33741,29482,42127,27403,16871,31628,27467,8549,6469,8549,12837,10692,8548,12743,17002,12743,29615,42325,48663,50809,52857,50809,50809,50809,50809,50809,50777,48663,23308,10597,12710,8549,8517,8517,8517,10565,12743,8549,8485,6404,6404,6436,10598,4291,2243,2211,2211,8517,6437,6404,6436,16903,16870,10596,10660,12805,10692,10627,10660,8547,8580,6435,4354,6435,6435,8582,8582,8550,8550,6469,6469,39},
{52890,52857,52889,50809,50777,48696,48697,48729,50777,48729,50777,48729,48729,48697,48729,48729,48729,48729,48729,50777,50809,48729,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,50809,52857,52857,50777,52857,52857,50809,52857,52857,52825,50809,52857,52857,52857,50777,50777,50809,50809,50777,50777,50809,50809,50776,50776,50777,50777,50777,48696,42390,38230,38197,21163,14857,16970,14889,14921,17002,19050,19082,17002,14889,10696,16937,19050,21162,21162,19049,21130,25323,19050,14889,14857,14889,14856,14857,14889,12776,14889,14857,12776,14856,12776,12776,14857,12743,12776,14856,12776,12776,12744,10663,12744,10663,10663,12776,10663,16936,46517,54937,40178,42259,57050,57050,57050,55002,54969,54969,54970,54970,55002,55002,54970,55002,54969,57050,50710,25354,14854,6469,6437,14823,21129,19015,25354,23274,31693,25419,23274,29547,46451,48532,46385,48564,35854,40045,21094,40014,50578,50545,48497,50577,44271,27370,25290,12743,8549,16999,10693,4324,4291,37968,50612,46386,42193,31661,44207,46254,27402,37967,46418,31629,10663,10695,10694,14886,12805,6468,19081,17034,6437,21195,40245,50777,46583,42325,50777,48663,42357,50776,50776,50809,42325,23275,12678,10598,4356,4324,2276,6502,10631,12711,6437,6404,4324,2178,6372,8549,4291,2243,2211,4291,10630,6405,12678,23209,21095,8547,6435,8548,12773,12773,8515,6467,6435,4323,2242,6435,10628,8517,6502,6502,6502,8550,6501,10663,42},
{52890,52857,52857,50809,50777,48696,48697,50777,50777,48729,50777,50809,48729,48729,48729,48729,48729,50777,50777,48729,50809,50777,50809,50777,50809,50809,50809,50809,50809,50841,52890,50809,50809,50777,52857,50777,50809,50809,50809,52857,52857,52889,52857,50777,52857,50776,50809,52857,50809,50809,50777,50777,50809,50777,50777,50777,50776,50776,50776,50777,50776,50776,48696,42423,38230,38197,21196,14857,16970,14889,14889,17002,16970,19082,19050,14889,10696,14857,16969,16969,14856,16969,16969,16937,19050,14889,14889,16970,14856,16937,14889,12776,14856,14824,21163,21195,17001,19114,23275,21195,21162,25421,23276,25388,25421,21195,23276,27533,25421,17002,14921,17001,29549,29614,35985,35986,35952,31727,33807,38033,44339,42258,42259,40145,40146,44339,40113,33839,33840,35920,29612,12709,12774,10662,6468,25387,29483,25290,23273,21128,21160,19081,19048,37966,46418,54904,48499,44338,31628,31658,19014,42158,50545,50545,48529,35852,27401,25322,25290,16904,12775,16967,10693,4324,8452,48532,48564,50645,44338,33741,35854,37934,23178,18984,33774,16936,8550,8550,6437,8549,8580,6468,23340,14889,8518,21195,42325,50777,48631,44405,50776,48631,44405,50744,48696,48696,33905,23275,12645,10630,4356,4324,4291,6437,8518,12711,6404,2211,2211,2211,4291,8517,4324,4291,2243,2211,6436,27435,33610,31530,21160,10660,8516,6435,6435,8548,4355,6435,6435,2243,2178,8515,25386,27468,21162,16968,12775,10630,12775,12776,56},
{54970,52889,52857,50809,50777,48696,48696,50777,50809,50777,50777,50777,48729,48729,48729,50809,48729,48729,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50777,50809,50809,52857,52857,50777,52889,52857,50809,50809,50809,50809,52857,50809,50809,52857,50777,50777,50777,50777,50809,50809,50777,50777,50809,50777,50809,46616,42390,38262,38197,21228,16937,17002,14922,17002,19083,17002,17002,19082,16970,10696,16969,16937,16937,16969,19050,16969,16969,19049,16969,16969,19050,16969,16969,16937,23243,25356,23243,25388,25421,19114,21162,23275,23308,23308,29614,23308,29615,29646,27501,25389,25485,21259,14953,17034,17002,25388,27501,35985,33872,25420,14889,16969,31661,35920,33807,33806,27468,27500,35887,25356,10663,8583,12775,19080,10662,10694,17000,8614,23274,25289,31596,19016,19080,17000,8582,14855,44305,46352,46386,44273,46418,37967,33772,18982,44239,48465,50545,35885,12708,21129,25323,25322,21129,19082,16968,8549,4323,16870,54903,48564,33709,33741,37967,35854,33741,25291,16937,23275,14856,8583,6469,6437,4324,4356,8549,23276,17002,8517,23340,44438,48696,44405,48663,50776,44437,48631,48696,50776,46551,23308,25421,14726,12678,10630,8485,8485,8517,8484,12711,8517,6404,6372,6371,6404,8517,6436,4323,4291,2211,4291,23209,31497,18950,16936,10629,6435,4387,4323,6435,4355,8548,6403,4291,2210,12709,33806,33806,33774,35919,31693,23274,16936,10630,53},
{52890,52857,52857,50809,50777,48696,48696,50777,50809,50777,50777,48729,48729,48729,48729,48729,48729,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,50809,52890,52890,50809,52857,52889,50809,50809,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,50777,50777,50777,50809,50777,50809,50777,50777,50776,50777,50776,50777,46616,42390,40310,38132,21163,14889,17002,14889,14921,17002,16969,19083,17002,14889,10696,16969,19017,16969,16969,19017,19017,19017,19049,19017,19049,19049,16937,16969,16936,35887,40146,33807,31694,21227,14921,19082,19114,23308,27501,33840,27501,27501,31727,29614,25389,23308,21227,14953,19147,17002,25389,27501,33872,31824,27501,17001,25388,35953,33807,33807,35887,29549,27501,35887,29614,12841,8583,14856,21192,14919,14855,12807,8549,27500,27402,35822,16872,12743,14856,8550,12743,37999,46385,48467,44273,48563,46450,33771,21095,48465,48464,48465,31659,19079,25322,25322,25290,21161,14888,10727,6437,4324,29547,54969,46418,33741,33741,40080,37934,31628,33742,21227,14921,17034,10663,4357,4357,10662,6468,14888,19115,16970,12743,27566,48663,48631,40147,48663,48696,40244,46583,50744,50776,38099,21162,25421,14758,12678,12678,10533,10533,10598,8484,8485,10565,10565,10565,10565,10565,6436,6436,4291,4291,2211,2178,4323,12709,10596,6435,6435,6435,8548,4355,4355,4354,6467,4291,2210,2210,4291,25354,33838,33741,31693,23241,21129,12775,6470,47},
{52890,52889,52857,52857,50777,48697,48696,50777,50809,50809,50809,50777,50809,50809,50809,48729,48729,48729,50777,50777,50809,50777,50777,50809,50809,50841,50809,50809,52890,50809,52890,50841,50809,52857,52857,52857,52889,50809,50809,50809,50809,50809,50777,50777,50809,52889,50809,50777,52857,50777,50777,50809,50777,50777,50777,50776,50777,50777,50777,50777,50776,50777,48696,40342,38230,40245,21228,14857,17002,14857,14921,17002,17002,19083,17002,14889,12776,16969,19050,19017,19017,19049,19017,16969,19049,16969,19049,19017,16937,19049,19016,38032,50711,48630,42324,17034,12840,19114,19049,23308,27501,33873,27534,27533,29646,29647,21196,27534,25421,17001,19114,17034,25388,25388,29647,31760,27468,29581,31662,29581,27469,35855,35887,31661,25356,33807,29582,12809,8615,14920,21192,16999,16967,19079,14821,42225,33677,40113,16904,10631,8550,6469,10630,35886,46385,37902,35821,50612,40080,25320,25288,48497,50545,46384,42192,31660,23242,23210,23210,23274,21130,17000,8581,6436,42225,52791,42192,37934,35822,42160,35822,31596,44339,23307,10728,12808,12776,19115,17034,12807,6436,23307,21162,12776,14921,31792,50777,46518,40211,50777,46550,40244,50744,50776,50777,31728,21195,33872,16872,12678,10630,8517,6437,6404,4324,2211,10630,10663,6404,6371,4323,4323,4356,4291,2243,2211,4323,8516,10660,8580,8547,8580,8547,6435,6435,6467,8580,6435,4291,4291,4291,2211,10597,31693,33806,23209,19049,19049,10630,8582,62},
{52890,52889,50809,50809,50777,48697,48729,50777,52857,52857,50809,50777,48729,50777,50777,50809,48729,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52857,52857,52857,52857,52857,50809,50809,52857,50809,50777,52889,52857,52857,52857,52857,50809,50777,50809,50809,52857,50777,50776,50777,50777,50776,50777,50777,50809,50776,50777,50777,46616,40342,40310,38165,21196,14857,16970,12809,14889,17002,17002,19050,19050,14889,14857,19050,19082,19082,19050,19050,19050,19050,19050,19049,19050,19050,19017,19050,19017,40178,52889,52889,48631,23340,17034,23275,21194,25421,29679,33872,31759,31727,29614,29647,27534,31727,27501,17001,19147,17034,27533,29614,33873,31792,31726,29581,31727,27501,29582,35887,35920,31694,29549,35887,31694,12841,10696,14888,21127,16966,14886,19079,21127,48532,31597,42259,19049,21130,14824,12743,14824,33774,44272,42161,42161,42225,16967,19047,29514,48497,48497,48464,46385,33708,23241,21097,25323,23242,23275,19048,8612,10660,44306,37935,42225,33676,40080,42193,29483,29548,48565,23308,12808,12840,14888,21228,21227,14887,8549,21195,19050,10663,21196,40179,50776,40211,42324,50776,42324,44437,50776,50776,50777,31695,25388,42292,18985,12646,8517,6437,4324,4356,4292,4292,12808,14986,2243,2211,4324,4356,6436,4355,4323,2210,6403,6435,10660,12772,10660,10692,10660,6467,10660,8579,8516,8517,8550,12743,12775,12743,8549,16936,33806,33741,23242,14823,8550,10695,68},
{52857,52857,50809,50809,50809,50777,50777,50809,52857,52889,52857,50777,48729,50777,50809,50777,48729,50777,50809,50777,50777,50777,50809,50809,50809,50809,50809,50809,50841,50841,50809,52857,52857,52890,50809,52857,50777,52857,52889,50809,50777,52857,52889,52889,52857,52857,52857,52857,50809,50809,50809,50809,50809,50777,50777,50809,50809,50777,50776,50776,50776,50777,46616,40342,40343,33939,17002,16970,16970,12776,14889,19082,16970,19050,23243,21130,31760,25454,25454,23341,25486,25454,25453,25454,23340,27566,29614,33808,33840,35920,33807,38033,40178,38066,35953,31727,27533,33807,31726,29647,31727,35953,35953,35920,31727,29646,33808,33872,33807,29614,29646,27501,29582,25421,25422,23373,25421,21195,21228,21260,23276,25388,25388,21227,23308,25388,23308,12841,10663,23208,25352,19078,16966,16966,23240,52758,31596,42194,16936,12743,10630,14888,14888,33774,40046,46387,48532,27466,10693,12774,31659,50578,50545,48464,50578,35821,23210,21097,27403,23210,21162,14855,10693,10660,35886,35821,46418,42160,52726,42226,31596,33773,44372,21163,12808,14921,12776,17002,16968,8581,14887,25388,14857,4357,25421,44438,48696,50744,48663,48695,50744,48695,50777,50776,42292,33840,27501,40212,18984,12645,8517,4292,4324,4356,4324,6404,8647,17035,4292,2211,2211,4291,6404,8549,4356,4291,4355,6468,12741,12740,12772,10627,8547,8612,8579,8548,8581,8582,8550,12775,16969,14888,14856,12743,19049,35887,21161,10630,10662,10663,65},
{52857,52857,52890,52857,50809,50809,50777,50809,50777,52857,52889,50809,50809,50809,50777,50809,50777,50809,50809,50809,50809,50777,50777,50809,50809,50841,50809,50809,50809,50841,50841,50841,52890,50842,52857,50809,52857,52890,52857,52857,52857,50777,52857,52889,52857,50809,50809,52857,50777,50809,50809,52857,50809,50777,50777,50809,52857,50777,50776,50776,50777,50809,48664,40310,42390,35953,19018,16970,17002,14889,19017,21130,16937,23210,35855,23210,35985,25454,23406,21260,25487,21293,23341,23373,23341,25454,31759,33839,42291,44372,46485,46550,42324,44372,33807,31727,31662,37968,33807,25421,29614,35887,33774,37968,35887,33807,35952,42259,38033,38033,40146,33807,25420,19115,19148,14922,14922,12874,14922,12874,14954,12841,10728,8616,14922,12809,12841,12808,10662,33739,27400,19111,23272,16998,27433,54903,31596,38001,12743,8550,10663,6469,8549,25355,27435,18984,14822,14853,12806,10661,33739,46319,48432,48464,50545,37901,29483,23242,27403,21129,21161,14887,10693,8548,33806,44305,50645,50645,52823,44306,31595,42193,44340,12744,4356,6437,6437,6405,10694,12774,19146,25421,16969,4389,25421,48663,44438,35985,48631,44437,38034,48663,40212,29712,36051,33873,29614,33873,18952,12646,12678,8485,10565,10598,8517,6404,12743,14888,8452,6339,6372,4291,6404,6469,6436,4323,4291,8548,12773,6435,10660,12772,12772,10692,8580,6501,8550,8550,8550,12775,16969,16969,14856,14824,12710,23274,27435,19049,10662,8550,50},
{52857,52857,52889,52857,52857,50777,50809,52857,52857,52857,52889,50809,50809,50809,48729,50809,48729,50777,50777,50809,50777,50809,50809,50809,50777,50809,50809,52889,50809,50841,50809,52890,50842,50809,52857,50809,52857,52857,52857,52889,52889,52857,50809,52857,52857,50809,50809,52857,50809,50809,50777,50777,50809,48696,48664,48664,48663,48663,48696,48696,48664,50744,46584,40310,42358,35921,16970,16969,17002,14889,14824,19082,16937,27469,40080,29549,31695,23341,19180,19180,19180,19180,19180,19180,19147,19115,29647,25420,40178,44404,44436,46517,44404,42259,31694,29581,29581,35887,29549,23275,31662,35855,33742,35887,35854,33806,35887,40113,35888,35920,33839,25420,23275,23373,19147,17035,14922,14954,12841,14922,14922,17002,12809,14922,12809,14922,10728,12808,8550,23240,29513,21127,19079,16966,29547,52823,25323,21130,10631,8582,12807,10694,8549,16903,16967,6468,6469,12742,19079,16934,40013,50480,50512,48464,48465,40046,37967,27435,25322,21161,19049,10629,10662,10629,31596,44241,48565,42193,42161,44339,33676,48500,38001,14825,4357,6470,6437,4291,6468,12806,25420,21227,8582,4389,27599,48663,44437,44437,48631,46550,44437,50744,19017,8551,38164,27501,29614,38099,21098,12645,14758,12613,10533,12613,10565,10565,12678,10565,12645,12645,10597,8517,10565,6404,6404,4291,2211,8516,14853,10628,10660,10692,10660,8515,14854,16968,12775,10598,8549,10630,14824,12776,19049,21096,25290,31693,37966,25387,8582,8550,34},
{52889,52889,52857,52889,52857,50777,50809,52857,52857,52857,52857,50809,50777,50777,50777,48729,50777,50777,50809,50809,50777,50809,50809,50809,50809,50809,50809,52889,52890,52890,50809,50809,50809,52889,52857,50809,52857,52890,50809,52857,52857,52857,52857,50809,50809,50809,52857,50777,50809,50777,50809,50776,52857,33841,23309,23341,23341,25421,25422,25389,25389,25422,23341,21261,23341,33840,21163,16937,16970,14889,14857,19050,16970,25356,33775,21130,16937,19180,19180,19148,19180,19148,19180,19180,19179,19115,25453,27533,40178,46485,46517,46517,42291,42291,31727,29582,31630,35887,31662,25324,29582,33807,33742,33774,35854,33774,35887,42226,35887,33807,29581,21162,23340,25421,10696,12808,12841,14921,14889,14921,12743,14889,21163,21227,14889,16969,12776,19082,8582,16935,31561,25288,19047,14886,35918,54871,21097,8550,10663,14823,19016,16903,14790,16903,16998,14886,12742,12774,16999,21127,44239,50512,50512,48464,48432,37901,23176,25322,25290,23210,21162,14856,8549,19048,42128,46419,48597,46386,37903,42258,31628,48532,46452,27404,18984,19017,18984,16904,14855,8517,8582,8550,4357,4324,29712,46551,33840,40179,46550,38066,40211,44437,25388,21195,38131,31727,35985,35985,23275,12645,14791,12613,10565,10565,10532,10565,14759,10597,10565,10565,10565,10565,8549,6404,6404,2243,2211,4323,10661,14853,14885,14884,12804,16933,35886,40112,38031,35886,29548,14791,10630,10662,19081,31628,33774,33806,31693,19049,6469,6469,36},
{52889,52889,52889,52889,52889,50777,50777,50777,52857,52889,52857,50809,50777,50809,50777,48729,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,52890,50841,52857,52889,52857,52857,52857,52889,52857,52857,50809,52857,52857,52857,50777,50777,50777,50777,50777,50777,50776,50809,50809,50777,52857,29680,17035,19116,19148,19148,19148,21196,21196,19116,19116,19148,19116,31694,25356,16937,16970,16969,14889,19050,16970,23244,29582,27501,27534,23309,21261,19180,19212,19180,19148,19180,19180,21260,27533,23307,40178,46485,44372,44404,40178,31726,29549,33743,31630,38000,33807,25323,25388,35952,33807,35887,35854,35887,37968,42193,35855,33807,31726,23307,25420,29647,29647,21227,29647,19082,16969,16969,14824,16969,21195,25388,21195,25421,14888,19082,10663,19048,37899,31594,19047,16935,35821,46418,21130,8550,10630,21162,29419,21032,18952,21096,21191,16998,14885,16998,14886,16934,46384,48433,44206,48465,44207,40014,25290,25322,25290,23242,19049,16969,10663,16968,42127,50645,40178,37934,40080,40080,35853,48532,42259,52791,52823,54904,52823,54871,42194,6404,4324,4356,4324,6437,27599,33905,33905,33905,31825,33873,33905,33905,33906,33873,36018,36018,33872,35985,21130,12645,14791,12613,12613,10565,8452,10565,14791,10565,10565,10565,10565,8485,8549,6404,6404,4323,2243,4291,6468,10661,14853,19078,14820,21159,38031,40112,40112,37999,31660,21129,14823,14888,16936,14823,12711,12711,14823,8582,8550,8550,40},
{54970,52889,52889,52889,52889,50809,50809,52857,52889,52889,52857,50809,50777,50777,50809,50777,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,50809,50841,52857,52857,52857,50777,52857,52889,52857,52857,52857,50809,50809,52857,52857,52857,52857,50809,50777,52857,50809,50809,50809,50809,50777,52890,29681,19116,19148,21228,21228,19148,21228,19148,19148,21196,21196,21196,29614,25323,16937,19050,14889,14889,19050,16969,21131,27534,23275,21195,21228,19180,19180,19212,19180,19148,19147,19147,19147,25453,25452,38033,40178,38033,42226,33839,35952,31695,29550,29549,35887,33774,23243,27469,35920,31694,33807,35855,37967,38000,42258,35887,33872,29678,21227,29614,38098,40179,38066,38131,35953,35985,33872,35953,33840,33840,35921,35953,35985,25388,23275,17001,14856,23273,27433,21159,21128,35756,44240,23242,8582,8550,25387,37902,23079,21032,18951,23240,19143,16998,14885,14853,21127,46353,50516,46321,50644,50611,40014,25322,25323,25290,23242,21163,17002,12808,8517,35886,46452,19017,29515,52758,37934,44274,42193,44339,54969,54937,54936,54969,48597,35952,6437,4292,4324,4324,4324,6469,6469,8518,8518,6437,8517,6469,8517,8550,10663,33938,33938,25388,23308,14791,12645,14823,12710,10533,10532,10565,10597,14856,14856,12645,10565,6339,6436,10629,6436,4323,2211,2243,2243,4323,6403,6403,14821,14820,23273,38064,40112,31693,25322,25322,23210,14856,16969,16969,14888,14856,14856,12775,8550,8550,8550,40},
{54970,52921,52889,54970,52889,52857,50809,52857,52857,52857,52889,50809,50809,48729,50809,50777,50809,50777,50777,50777,50809,50841,50809,50809,50809,50809,50809,50809,50809,52889,52857,52857,52889,54937,52857,52857,52857,52857,52857,52857,52857,52857,52889,52857,50777,50809,52857,52857,52857,50809,50809,50776,48696,29680,23342,25422,25422,25422,23374,25454,25454,23373,23373,23341,23374,23309,19050,16937,19050,16969,16937,21130,19050,21131,27502,25388,23276,19148,19180,19180,19180,19147,17099,17067,19147,19147,27566,25453,38066,44371,42258,44371,35920,33807,29614,27405,29582,31661,31694,23243,27501,29614,29614,29581,33774,35887,35887,42193,38000,35953,31727,23307,31759,38098,40211,40211,38130,38098,38130,38098,38098,38098,38098,38066,38065,38065,38066,21195,10663,16969,21194,19112,21191,25353,40015,42096,23243,10695,8582,12774,31563,25225,27338,25258,16904,16934,21191,25385,21192,29513,54838,54807,46353,37934,48465,40046,25290,25290,27403,25290,16936,10598,8550,10597,33774,40113,10532,33742,57082,42096,44274,46419,48597,54937,50710,52823,52823,25387,31825,6470,4324,4356,4324,4324,4324,4292,4324,4292,4292,4324,4292,4292,2243,6404,33905,36018,31727,27469,16872,12613,12743,10630,10597,10598,10630,10565,12710,10597,8485,8484,6404,8485,10629,6468,6404,2243,2211,4291,6436,4323,4291,6404,12741,16934,31692,40144,31660,25322,27402,25322,12711,10630,14889,14824,10662,10695,10663,8550,8582,6469,42},
{52889,52889,52889,52889,52889,50809,50777,52857,52857,52857,52857,50809,50809,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,52890,50809,50809,50841,50809,52857,54937,54937,52889,52857,52857,52857,50777,52857,52857,52857,52889,52857,52857,50809,50809,50809,50809,50809,50776,50809,33906,23374,25454,25487,25487,25487,25487,25519,27567,25486,25486,25486,25454,25422,17002,16969,19050,14856,14856,21163,21098,21163,27502,21130,14889,19148,21260,19180,19147,19180,21260,17067,19147,19115,27533,27533,35920,40112,38000,35887,33774,29581,29581,25356,23275,31694,33775,25356,25388,29614,27501,27468,33807,35920,33807,42258,38000,35952,33872,23307,29647,38130,36018,36018,36017,38098,38098,38098,40178,38098,38098,38098,38065,38065,38066,25421,12775,16968,23242,16999,19046,33805,44273,31565,14888,10630,8582,8581,27402,23112,23080,18952,16872,14823,21193,42324,44404,42192,54838,52724,46352,37934,48465,37933,25290,25355,25355,23209,18984,12710,8549,8549,14823,12710,6404,29549,54969,42160,50580,42226,50711,54969,54969,57049,35855,19016,33906,8550,4324,4324,4324,4324,4324,4324,4356,4324,4292,4324,4324,4292,4291,6404,31760,35986,33873,35985,23275,12645,14856,17001,12840,12776,12776,10630,12711,8517,6404,6404,4323,6404,10630,6468,6468,6436,6404,4323,6436,6436,6436,6436,8548,8515,12709,31725,33773,27370,27402,25290,14791,12775,16937,14856,12743,8549,12743,23242,12775,6469,40},
{54970,52890,52890,52889,52857,52857,50809,52857,52857,52857,52857,50809,50809,50777,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50841,52857,52857,52889,54970,52889,52857,52857,52857,52889,52857,50777,50809,52857,50809,52857,52857,50809,50777,50809,50777,50809,31826,23374,25454,25454,25487,25487,25487,25487,27567,25454,25454,25487,25454,25422,17002,16905,16937,14889,14856,21130,19050,23244,29582,21098,19083,21228,38098,27566,23373,21228,21228,19180,19147,19147,25452,29614,37967,40015,40047,37935,33742,31661,33775,27501,27436,31662,31694,25388,25388,29582,25388,25388,33775,35920,33839,44306,35920,33839,33839,23307,27501,40178,19114,17066,25518,35985,40178,38098,38098,38098,38098,38098,38066,38066,38066,33808,23275,21162,25322,19047,16966,40176,44274,33710,12776,8550,8550,14823,31596,25159,25192,21064,18984,12710,21128,42292,54937,54871,48465,48432,48464,48433,42126,25288,25322,27371,25322,23242,23210,21161,10661,4356,4324,4323,4324,27468,54969,54871,48532,40080,54969,57018,57049,52791,16903,16937,33906,8550,4324,4324,4324,4324,4292,4324,4292,2244,4292,4292,4292,4292,4324,4291,29680,33939,35986,25420,23243,12613,14790,12645,10564,12645,12677,12613,10598,10533,10565,10565,10565,10533,8549,8548,6468,6436,6404,4355,6468,8548,6436,6404,6403,4323,8549,12710,27435,27402,27402,25322,16936,19049,19017,16936,10630,8549,8550,10630,6469,6469,40},
{52890,52889,52857,52889,52857,50809,50809,50809,52889,52857,52857,50809,50809,50777,50809,50777,50809,50809,50809,50809,50841,50809,50841,50809,50809,50809,50841,50841,50809,50809,52890,52889,52889,52857,52857,52857,52857,50777,52857,52857,52857,52857,52857,50777,50777,52889,50777,50809,50809,50777,50809,50809,31761,23342,25422,25454,25454,25487,25487,25487,25487,25422,25454,25487,25454,25422,17002,16937,19050,16969,19017,21130,19049,21163,31662,29517,27469,23308,38097,27566,27566,23340,21228,21260,23340,25421,29646,27501,40080,40014,37934,37934,33741,31661,38000,33743,27436,33775,31694,25323,23275,27501,25388,27469,33775,33807,33839,44339,33806,31726,33807,23307,25388,38098,19115,6534,12808,35985,38098,38130,38130,38066,38098,35953,35985,38098,38098,33808,21098,19048,35952,25418,19014,40177,44274,44274,23275,8517,8549,14791,27273,25160,27370,21097,16904,16871,21128,35952,27500,40046,42126,42126,50577,44239,33739,27434,25322,25290,25322,23242,23242,19048,8548,4356,4356,6404,6372,29516,57049,54904,48532,48532,57050,52823,54871,33775,8550,14888,31857,12776,10662,10663,10663,10662,10630,10630,10630,10663,10663,10630,10663,10663,10630,8550,27599,33939,29614,23307,31661,27272,29514,27304,25191,27240,27272,27239,29449,25224,27304,27272,27272,25191,27369,18950,12677,8516,4323,6404,6468,6436,6468,6436,8517,8517,8582,6469,16936,27467,27403,27403,16936,19017,21097,23242,21129,16936,14791,14823,14856,14824,39},
{52889,52857,50809,52889,52857,50809,50777,52857,52889,50841,50809,50809,50777,48729,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50841,52889,52857,52889,52857,52889,52889,52889,52857,52857,52857,50809,52857,50809,52857,52857,52857,50777,52857,50809,50777,50809,50777,29712,23342,25486,25486,25487,25486,25486,25487,25487,25454,25454,25454,25454,23341,16970,16937,19082,19082,19017,21130,21130,21163,29614,25387,27468,23340,36017,27566,25453,23373,23308,23341,23373,25421,31759,38065,40113,44241,37934,39982,35854,33774,33807,33807,31630,33774,31694,29549,23275,27501,25388,27500,31694,31726,33774,40145,35887,31726,33807,23308,25420,38098,19115,10696,23308,35953,38066,38066,40179,38098,38098,35985,33904,38065,38065,33807,19017,19048,38064,27499,16934,44371,46354,48532,29613,8582,8550,18984,27241,25192,29548,23307,18984,21064,23240,14854,8516,40046,44239,46287,46319,33675,33707,33773,27370,25290,25322,25290,23242,14886,12773,10661,6468,6469,8484,27467,54969,54872,46387,48565,55002,57050,44338,14758,8550,12808,27534,14856,16969,14888,14888,14921,14888,14888,14888,17001,16969,16969,16937,16969,16969,16936,27599,33906,23308,21194,35756,37738,35853,31660,29482,29450,20965,33545,35756,27337,25224,25192,25223,35658,33708,12612,10596,8548,6435,10629,10596,4291,6371,8516,8550,8550,8550,8550,16936,27435,27435,27435,19016,16936,27435,29515,31628,35854,33773,35854,31661,19049,40},
{52890,50809,50777,52890,52857,50777,50777,50809,52857,52890,50777,50809,50809,50809,50777,50777,50777,50809,50777,50809,50809,50809,50809,50809,50841,50841,50841,50809,50841,50809,52889,52857,52857,52857,52889,52889,52889,52857,52889,52889,50809,52857,50809,52857,52857,50809,52857,52857,50809,50809,50809,50777,29713,23342,25454,25454,25487,25486,25486,25487,25486,25454,25454,25454,29615,33643,23144,16937,19082,16937,16904,19050,19049,23243,29614,23307,25388,23309,21260,19147,23308,23340,23308,25421,23308,21259,25388,25387,27468,35887,33709,33741,33741,31662,29614,31727,31662,31662,31726,27468,25356,27501,27500,29646,31727,33807,33807,38065,31694,31726,33807,27501,31694,35985,25356,23275,25388,31727,35985,35952,38065,33872,38065,35984,35952,35952,35952,33839,21161,19048,38032,25386,16967,46484,50578,50480,29581,10630,21129,31596,25192,25160,29483,27435,21065,21064,27467,14854,12741,40079,50546,48464,48465,42126,48530,35886,25289,25322,25322,25322,27467,14853,10661,10661,8549,8517,8484,23241,57017,52823,40048,52824,57083,54937,37902,23177,12743,16904,25388,21195,16936,19082,25356,23243,19017,25356,23243,19049,25356,21162,21097,19049,21130,21129,31760,33939,29614,27501,35691,37770,33609,31431,31399,31463,31431,37770,37770,33511,31431,33512,31431,37803,31530,18949,23143,16869,10596,14789,8516,4291,8452,29613,29548,23242,16968,12742,16903,29515,27435,27435,14823,19049,25387,38032,40112,40144,44305,42192,23242,10598,43},
{50809,50777,50777,50777,50809,50777,50777,50809,52857,50809,50809,50809,50809,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,50809,50841,50841,50841,50841,52889,52857,52857,52857,52857,52857,52857,50809,52857,52857,52857,52857,50777,50777,50776,50776,50776,50744,48696,48663,48663,46518,27535,23342,25454,25454,25486,25486,27534,27534,25486,25486,27535,25454,35985,54737,48333,25226,21130,19049,19017,21130,21130,23243,29581,25451,31759,23341,19180,19115,23340,25388,25421,27534,25420,23340,23308,25388,23275,27435,27468,29581,29581,25388,25356,25355,25355,21162,23274,25420,25387,21129,25355,23242,25388,23210,29581,23210,25387,19049,27435,23274,27435,25355,25323,23242,23242,25323,23242,27435,25355,23242,23242,29548,27435,29548,27500,31726,25322,29515,40113,25419,19015,42291,52593,50479,31661,10598,33709,31563,33611,23047,23112,18951,10630,10597,21160,19046,19014,35853,50546,50544,52658,48432,50610,33740,25289,25322,25290,23209,23241,12773,10660,12773,8548,8516,6436,21129,54936,50677,46452,54969,54969,52758,33708,33708,29451,18887,38034,40212,25420,40211,50744,48598,42292,50744,48566,42292,52824,46485,44372,44372,46452,46452,44405,33938,33873,35822,33545,37836,35625,35591,35591,35592,35624,37868,35689,37672,37672,35624,35624,37868,23143,18949,21030,14789,10564,10564,6436,2210,16935,40112,40144,40112,35886,25322,16903,27467,27467,21097,10662,16969,19017,29548,40080,38031,31660,18983,8517,8550,36},
{50809,50777,48729,48729,48729,48697,48729,50777,50809,50809,50809,50777,50809,50777,50777,50777,50777,50809,50809,50809,50809,52890,50809,50809,52890,50809,50841,50841,50809,50841,52889,52889,52857,50809,52857,52857,52857,50809,52857,52857,50809,52857,50711,48631,48663,48631,44437,44405,44405,44405,48631,48631,33841,25390,25421,25421,27502,27502,25454,27534,27534,27502,29615,29615,31694,48365,37769,29418,27403,16969,16937,21130,19049,23211,40113,27531,33839,31792,23341,23308,16969,25420,29614,21195,27533,21194,27501,33774,31694,31661,31693,31693,31661,29581,29581,27501,27500,27468,29613,27500,29548,29548,33773,29548,35888,29581,40113,31629,33806,27467,33805,33773,33806,33806,35951,35887,35887,35888,35887,35919,35887,31661,33774,35920,35887,35919,35887,40145,33741,37967,42226,31726,25386,42258,50480,50480,38000,23275,37935,46320,42126,31563,31628,27435,21162,21129,29580,29579,29579,42127,48465,48464,50577,48432,52724,35885,25321,25322,25322,25322,19047,14853,10692,12773,8581,8516,8516,23176,57017,48500,48532,57050,57082,50677,42127,37934,33610,39884,38002,42325,33807,46518,50743,48663,50744,50744,50744,50776,50776,52857,52889,52824,50776,52889,44438,31858,29615,31563,35624,33642,29319,35592,35592,25093,35625,37868,31464,37704,37672,27238,35657,35755,18917,21030,23143,12676,12709,10628,6371,4291,27500,40112,35886,27402,25322,23241,19016,27467,27435,12710,10598,16936,16969,16936,29548,40144,35853,25322,21161,19016,64},
{50777,48729,48729,48697,48697,50777,50777,50777,50777,50777,50809,50777,50777,48729,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,52890,50809,50809,50809,50809,52890,52890,52857,52889,52889,52857,52857,52857,52857,52857,52857,52857,52857,50809,52889,52857,52889,52857,50809,50777,50777,50744,50744,52857,40146,38033,35953,38001,38001,35953,35920,38001,35920,38000,38033,38001,48368,44108,46189,46222,21065,19017,21130,19050,21098,44338,40080,44339,38098,29647,29647,27631,31792,31792,27567,31759,27566,29712,29647,29614,31694,33806,29613,31695,29614,31727,31727,29646,31759,29646,31726,33839,33807,35951,33806,38065,31726,38033,31727,38032,29580,37999,31758,35951,33774,38031,33838,38032,35952,35919,38032,35919,35920,35887,35952,35919,31726,31725,40178,31661,33773,40177,33839,23241,40079,50447,50480,37968,16936,23242,35788,39981,29417,27435,21161,19080,16968,14920,19081,31660,46352,48465,48465,46384,48432,54837,29546,23241,25322,25290,23241,19015,12773,14918,12805,12774,8516,10629,31660,57017,40015,50710,57115,57115,50612,42094,42127,42061,42028,40081,38131,33840,48663,50744,40146,48598,50744,44404,50743,44372,19049,25355,48597,44436,50711,35986,31858,35986,35690,35591,35592,35592,35559,35592,35624,35624,37704,37672,37672,37672,35591,37672,33544,25190,23110,14757,10596,12677,10629,6404,4291,21161,29580,29580,25322,25322,25290,16871,29516,23210,10630,16904,16969,16969,16936,14856,29613,38031,37999,37967,37966,131},
{50777,48729,50777,48697,48729,50777,48697,50777,50777,50777,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,50841,52890,50809,50841,52890,52890,52890,52857,52889,52889,52857,50809,50809,52857,52857,52857,52857,52857,52889,50777,50809,50809,52857,52857,50809,50777,50777,50777,52857,54970,52823,50743,50743,50743,50743,50743,50743,50710,50678,50710,50743,52791,52724,42029,41996,41996,23144,25193,25225,23177,23177,37870,27305,27403,42292,38131,35986,33938,35986,31793,33905,31792,33872,31792,31792,33807,35952,38032,31759,29646,29646,29614,29646,27566,27534,27534,27534,29646,29614,31694,29646,31726,29647,29646,29614,38033,37967,31693,29678,29614,29646,29613,29613,29645,29613,29613,29613,31725,31661,25355,27468,27403,27435,25355,31629,27402,40112,44338,40145,29580,37933,48267,50479,37935,10598,12743,25355,25289,27403,14790,19048,16968,16936,10662,10630,27434,46384,48497,44206,42126,50578,48563,23207,25321,25322,25322,25289,21160,14853,12741,14886,8548,8549,14854,37901,50677,46419,54936,57050,52823,46352,33675,29482,35820,40078,29548,35952,40211,48695,48630,44405,50776,48663,50711,52889,31662,6339,25355,46485,40146,31727,21228,31891,35953,33544,35559,35559,37672,35592,37672,37672,37639,39752,37671,37704,37704,37671,37671,29318,29383,23143,12709,10628,10628,12677,8452,4258,4259,10630,21193,25354,25354,25322,19016,23242,10662,12775,19049,14856,16936,16937,14856,19016,37999,37999,37999,37999,149},
{50777,50809,50777,48697,48729,50777,50777,50777,50777,48729,48697,50809,50809,50777,48729,50809,50809,50809,50809,50841,50809,50841,50841,50841,52890,50809,50809,52890,50809,50809,52890,52890,50809,52857,52857,52889,52857,52857,52889,52889,52889,52889,52857,50809,50809,50777,50809,50777,50809,50809,50809,50809,52889,50743,50711,50711,50711,50711,50743,50743,50711,46451,46352,46352,48399,50512,44240,33512,44073,41928,41896,39783,39815,41896,41929,41929,37768,41995,44173,39980,42060,42060,40013,42061,37867,39914,39882,35721,41929,39882,35721,39916,42062,46352,42094,39948,39948,37835,39915,39947,37867,39948,37867,37868,39980,37868,37900,37867,37868,39948,37867,37933,37901,37868,37868,37900,37868,37932,35820,37900,40046,33610,27238,29351,29319,27271,29352,29384,35755,44239,42193,40210,35920,39947,50314,52592,37968,10598,19082,33710,27305,25257,18918,31628,31661,27500,27467,27435,40014,46384,48465,46319,44238,50610,44272,21126,25321,25322,25322,25290,23274,16998,14885,12741,10629,8549,16902,37965,44305,46452,57050,57082,57049,39982,31628,12677,27304,39915,33643,35953,44404,52824,50711,48566,50776,50744,50711,50776,46517,40114,33807,27501,25389,25421,25421,31891,31661,31367,31431,31399,33447,33479,35592,33511,35592,37672,35559,35559,35559,35559,35592,33479,27271,16870,10628,10628,12709,10628,6435,8516,8452,8485,19016,25354,25322,25322,23209,27435,19016,14823,16969,16969,16937,16969,16936,25387,40112,40079,40079,37999,149},
{50809,50777,50777,48697,48729,50777,48697,50777,50777,48729,48729,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52890,50809,50809,50809,52889,52889,52857,50809,50809,52857,52857,50809,52857,52857,52890,52889,52857,52857,50809,50809,52857,52857,50809,50809,50809,50809,52857,50711,50743,50710,50711,50711,48662,50710,50743,50743,48630,50645,50677,50611,50544,44239,46220,48300,42028,35656,41993,41928,46155,44075,46155,46187,44042,46154,44074,41961,48332,46220,46188,48333,46186,48300,50347,50311,50313,50380,50511,56984,59130,54837,46221,48301,44106,46220,46187,46251,46252,48300,46252,46220,46253,46188,48300,46187,50348,46187,48365,48300,48299,48267,48332,48268,46187,46219,46187,50479,50381,46121,48234,44073,44073,48267,46219,44107,44174,40080,40178,38000,46189,50314,52593,37967,10630,14823,42128,50546,48367,44206,44240,25321,16934,19015,27402,40014,46385,48465,44175,40013,50610,40079,23207,25289,25290,25290,25322,16903,14886,17030,14885,12774,10628,21095,40013,37966,46484,57115,57115,54904,35723,33643,35723,39882,31366,31595,40211,46517,50776,44340,50711,52824,48630,52824,52857,50711,23145,16839,12678,12710,12678,19049,33939,33643,33545,33611,33512,35592,29319,29319,37770,29384,31366,37704,31399,29286,39850,29384,33479,27271,10628,8516,8516,10596,10628,8547,21129,29548,35886,33741,27435,25354,25289,33773,44337,44305,40079,25354,16969,16969,16937,14856,33806,40144,37999,38031,38031,164},
{50809,50777,48729,48729,48729,48729,50777,50809,50777,48729,48729,50809,50777,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52857,52889,52889,52857,50809,52857,50809,52857,50809,50809,52857,52857,52857,52857,50809,52857,50809,50809,50809,52857,50809,50809,52857,50809,52857,48598,50743,50710,50711,50711,50711,50711,50711,50710,48630,50710,50711,50644,48399,42028,44075,42061,35855,16872,40080,40046,46320,44207,42126,46352,42126,44239,46352,42126,46352,46320,42126,48465,46319,46320,48433,46286,46319,48433,50644,59196,59196,57050,31662,23242,23307,21162,25355,23210,25323,23242,27436,23242,27500,23242,27501,25323,29581,25355,27500,27435,27434,31661,29580,29548,25322,29548,25289,50612,44273,27401,31627,29514,31627,31660,35853,46353,46418,42225,40146,38033,33708,44109,39982,40080,21162,21162,33740,48433,48465,46320,40079,35854,29547,27467,33806,42225,46418,46418,44240,44174,52658,35820,19013,25322,25322,25290,25322,19016,16968,16966,14885,12805,12741,31627,39981,42224,52856,57115,52856,50611,46352,42159,39980,42028,44142,48500,46485,48663,52824,48566,50744,52856,50711,52824,52889,50743,20999,14758,10564,8452,8420,14824,35986,33545,37770,33544,35559,37704,35592,35560,39915,35624,37671,39752,37704,35624,39948,35624,37672,31464,10628,4323,6436,8548,8548,10628,12741,16967,21128,23176,27402,27402,33740,42159,42224,42192,37934,27435,14856,16937,16936,14823,23242,40112,40079,40111,40111,185},
{50809,50809,48697,50777,50777,50809,50809,50809,50777,50777,50777,48729,50809,50777,50777,50777,50809,50809,50809,50809,50809,50841,50841,50841,52890,50841,52890,52857,52857,52889,52857,52857,50809,50777,50809,52857,52889,52857,50809,52857,50809,50809,50777,52889,52889,50809,50777,50809,50777,50809,50809,50809,52857,50744,50710,50711,50711,50711,50743,50711,50710,48630,50710,48630,52692,50577,42061,44108,44109,33741,18985,40048,40015,42159,42126,40046,44272,42126,42159,46353,42127,42192,42127,37934,42192,40080,40047,44273,40079,42160,46321,50645,59196,59229,57051,19050,8615,12841,10696,14922,6502,8616,6503,8616,8583,10696,8583,8648,8583,8615,8615,8615,8616,8583,8616,6503,8648,8583,12809,12775,46485,35951,27499,29645,29646,29613,31726,31726,42225,52757,50676,42226,29581,16936,27370,27305,40112,16903,16871,42127,54772,50643,52790,40112,37967,27434,23241,25419,40144,48498,48497,48433,46287,52691,31627,21126,25288,25322,25322,25322,23177,21162,16999,16998,16934,16934,35820,39916,42160,54969,57082,57050,48499,37901,21096,31627,44272,52789,46516,46518,50776,50743,50744,52857,50776,52824,52889,52889,52824,21032,16870,17000,8517,6339,12678,35855,35592,37900,35755,35723,37771,37770,37705,37867,35624,35624,35592,37672,39817,39948,33576,25158,23111,8516,10596,6404,4291,4323,8548,6468,6403,2178,8484,23176,27402,29515,25257,31628,29579,27402,21129,14823,16936,16936,14888,14823,23242,40112,40079,42192,203},
{50809,50777,48697,50777,50777,50809,50809,50809,50777,50777,48729,50777,50809,50777,50809,50777,50809,50809,50809,50809,50809,52890,52890,52890,52890,50841,52890,52857,52857,50809,50809,50809,52857,50809,52857,52857,50809,52889,52857,52857,52857,50809,50809,50809,52857,52857,50809,50776,50777,52857,50777,50777,50777,50744,48662,48663,50711,50711,50711,48630,50710,50678,50710,50710,50611,50611,44175,44142,44174,35756,37869,35724,33643,35724,35723,35756,35756,35756,35756,37868,29515,14856,14856,14824,14792,14824,14824,16904,14856,16936,21065,48500,59229,54970,48565,29582,23276,23308,23340,27534,21196,23341,23308,23308,23308,25421,21227,23340,21228,21260,21228,19147,19115,19082,19115,19082,17034,17002,19115,23307,46485,31726,27500,31726,33839,31726,33872,31694,42192,52757,54935,57050,29580,16935,44174,46221,44305,25290,18952,33675,48433,44240,44273,35919,29548,14821,14854,21258,40080,48465,50512,52690,48432,52692,23144,19014,25289,25322,25322,25322,23209,14823,10630,12742,14854,23207,40046,39883,44209,57083,55002,57017,42095,35788,16838,29384,42061,44174,40112,48631,52856,46485,46517,52889,46485,48630,52889,54969,50711,20999,14757,14757,12645,10532,16839,35724,37737,35820,33773,33708,35821,35755,39850,27304,18917,20966,20965,27270,39915,35756,21063,14789,12709,6436,8484,4291,2243,4291,8548,8548,8516,4323,10597,35821,44240,40080,25289,23209,29516,25355,16936,14823,14823,14888,14856,10663,10630,25322,40112,46353,196},
{50809,50777,50777,50777,50777,50809,50809,50809,50777,48729,48697,50777,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,52890,50809,52890,52890,50841,52889,52857,52857,52857,52857,52857,52857,52857,50777,50777,52857,52857,52857,52857,52857,50809,50809,52857,50809,50809,50809,50777,50809,50809,50777,50776,50776,50776,50744,50776,50744,50776,50776,48630,46484,46484,46484,48464,48498,48532,46451,46451,48532,48531,48532,48564,48532,48532,48532,46451,46483,48531,48564,38000,10663,14857,14857,14857,14856,12776,14889,14824,14857,21065,48565,59261,52856,50678,40179,25388,33873,25388,29712,23308,31825,33873,31792,23340,33905,31727,27566,25421,31792,27599,29680,29679,31792,31825,27534,27566,19114,27599,19114,42291,31726,35952,33871,40177,35920,40211,35952,33741,54870,54904,54969,23209,16935,50512,50413,44272,37933,39981,37868,39916,37835,35756,37967,31628,14822,16967,23338,40080,46320,50544,50610,48399,48531,21063,19014,29547,27435,25322,25322,23209,19016,12743,14888,14855,25353,42158,35657,48434,59195,59195,54936,39982,37901,39948,41963,27174,31367,42160,48663,50744,44339,52824,52856,48630,52857,52889,54970,50678,21031,14725,14758,10564,10532,14726,23111,27369,25224,23078,25159,25191,27239,29449,25191,25191,27271,27271,27304,31498,27272,23143,10629,6403,6436,4323,4291,4291,6371,10660,8548,8582,10662,16968,25322,27434,29515,25322,25289,29580,21129,19049,16936,14856,14888,12775,14888,12711,12711,23242,19016,67},
{50777,50777,50777,50777,50809,52857,50809,50809,50777,50809,50777,50809,50809,50777,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,50809,50809,50841,52890,52857,52857,52890,52889,52857,52890,52857,52857,52857,52857,52857,52857,52857,50777,52857,52857,50809,50809,50809,50809,50777,50809,52857,50809,50776,50809,50809,50777,50809,50777,50809,50809,48598,44371,44338,44338,48399,48466,46452,46452,44371,46451,46451,46452,46452,46419,44403,44371,44371,44371,44371,46452,38033,14857,17002,19050,21131,21131,16937,21131,19082,19050,25323,42258,54904,50743,54937,38131,27566,31857,29647,31825,23308,31825,25421,27599,19115,31857,29679,29712,27566,29712,29679,29680,31792,27599,31857,27534,27567,19114,27567,21227,36050,31792,31759,29679,31727,31792,35953,38033,25257,48467,57049,54904,25289,16935,25289,29449,44273,37901,44207,46320,44174,44239,52724,44273,31661,19079,16967,23306,40047,48334,50512,50577,48464,50611,21127,21095,35886,35886,31628,25322,25322,21129,21194,14856,16935,19014,33707,37835,42093,46417,42225,44272,46385,40046,42093,42093,50611,48301,42160,50744,52824,48598,52824,52824,50711,52889,54970,54969,50678,25257,16838,23242,6339,6372,14823,12613,12710,8517,4323,6404,8484,8484,10597,2210,2178,6372,6372,8452,6339,4258,8451,10661,8548,8548,8549,4356,2211,4323,10629,10662,10630,12743,19016,25322,27402,27435,27402,25354,29580,19016,23274,16936,10663,10662,12743,12743,12743,12743,12743,8517,22},
{50809,50809,50777,48728,50809,52857,50809,50777,50777,50777,50777,48729,50777,50777,50777,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,52890,52890,52890,52857,50809,50809,52857,52857,52890,52890,52857,52857,50809,50777,52857,50809,52857,52857,52857,50777,50809,50809,50809,50809,50776,50777,52857,50777,50776,50777,50777,50776,50777,50809,50809,50776,50678,50678,50678,50579,50677,50710,50711,48630,48630,48597,48630,48630,48598,48597,48597,48597,48597,48597,48597,46452,23243,25324,25291,25324,27404,25323,27404,25323,25291,27436,27403,33709,38065,42292,36018,29679,33905,25453,31793,23341,31792,23341,27599,23341,31760,31760,31760,29712,27599,29712,25486,31792,27567,31792,27566,27566,23341,25421,23340,29679,29712,25453,27599,27566,29712,25452,35886,25257,44240,57017,59163,37967,19016,23275,19049,42226,16871,14758,16871,14791,18984,27435,31661,31694,33805,21128,31627,48433,50415,50544,50578,44207,35853,21095,25321,40047,37966,37966,35821,31628,33774,35854,31661,31661,33740,31627,40078,31529,29513,25319,31594,40046,16903,25257,44272,52691,48267,44273,52889,52889,54937,54970,52889,54970,54937,48630,48565,48532,23144,14790,19049,6404,8517,14822,10565,12742,10662,4324,6404,8549,8517,8549,4291,4291,8517,6372,8484,6372,4291,6404,10596,10661,6436,8516,4323,4291,6436,8582,10663,10630,10662,16968,27403,27435,27435,27402,25289,27467,16936,21162,10630,8582,8550,14824,16969,16937,14824,10598,10630,56},
{50809,50777,50809,50777,50809,52857,52857,50809,48729,48697,48729,50777,50777,50777,50809,50777,50809,50809,50841,50809,50809,50809,52890,50841,52890,52890,52890,50809,52857,52857,52857,50809,52889,52857,52889,52857,50809,52889,52857,52857,52857,52857,52857,52857,50777,50809,50809,52857,50809,50809,50777,52889,50809,50777,50777,50776,50776,50809,50809,50776,50744,50711,50678,48597,50578,50677,48630,48663,48630,48630,48598,48597,48598,48597,48597,48565,48597,48598,46517,46516,48565,48565,46484,48532,46484,46484,48533,46452,46452,46484,46484,46484,46452,35953,35986,33937,29679,33906,25453,31825,25454,31760,25453,25486,25486,25486,31792,27501,31792,29647,31792,29712,33938,31792,31825,29679,23341,21228,21228,25421,23373,27599,27599,31792,25453,29679,21227,35919,29514,46418,57082,59163,29580,21128,33774,18984,42194,16872,12743,12743,10663,10631,8517,27468,29581,27467,12709,35853,46385,48432,48464,46384,42159,31595,14757,27467,37999,37967,37966,37934,46418,54903,54936,52757,54936,57016,46418,21127,8484,10597,27401,33675,35788,25257,33610,35657,37672,46187,52725,42291,35952,38033,38065,38065,40179,46517,46517,46484,42225,21031,14725,21162,19016,16903,16903,12678,12710,23242,16904,10597,8517,8517,12710,10630,10597,8517,6372,6404,6404,4291,8484,6403,8580,6403,6403,6372,8517,10663,10663,10663,8582,10630,14791,23209,27435,27467,23209,19016,25322,12743,10663,8582,8582,8550,12743,19017,19017,16904,27435,23274,85},
{52857,50809,52857,50777,52857,52889,52857,48729,50777,48729,48729,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,52890,50841,52857,52857,52857,52857,50777,50809,52889,50809,52889,52889,52889,52857,52857,52889,52889,52857,50809,50809,50777,50809,50809,50809,50809,50809,50777,50809,50777,50777,50777,50776,50809,50809,50809,50776,50744,48662,48630,50645,48498,48598,48631,48630,48630,50678,48598,48597,48597,48597,48598,48597,48630,48565,46516,48565,48565,48597,46517,48597,48565,48565,48597,48565,48565,48565,48597,48597,48565,35985,36050,33937,31760,33938,27566,31825,27566,29647,25486,23373,25486,25486,31824,31760,33905,29647,31792,29679,31825,27566,29679,27566,27534,27567,21195,27566,23340,29712,25486,31792,27566,27631,29581,42225,33773,48532,54936,40079,16903,27467,35888,23242,46420,14792,10630,10663,10663,10663,10630,29613,33839,19081,10661,33740,48498,48497,48399,37802,50546,29547,8483,31692,37966,37966,37966,37934,48563,54904,54936,52823,54968,46451,23272,10627,6435,12709,37999,44305,44239,44174,44108,35722,37769,50414,50578,16934,4323,4323,4291,4323,8484,35952,42258,46452,44371,23177,12645,14758,12613,10564,10565,10532,10533,10532,10565,10565,10565,8484,8484,8452,8452,8452,6372,6404,6372,6371,8548,10629,6468,8549,8549,21129,27468,16936,12743,12743,10630,16904,27435,25354,27435,29515,27402,21096,19049,8582,8550,8582,8582,8550,12775,19017,16936,21129,37999,40112,154},
{52857,50809,50809,52857,52857,52857,50809,50777,50777,50777,48729,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50841,52890,50841,50809,52889,52857,52889,52889,52889,50809,52889,52857,52857,52857,50809,52889,52857,52857,52857,52889,52889,52857,50809,50809,52857,50809,50809,50777,50809,50809,50809,50809,50809,50809,52857,50809,50777,50777,50777,50776,48630,50743,50678,48498,50678,48663,48630,48662,50743,48630,48597,48565,48630,48597,48598,48598,46517,48597,48565,48565,48565,48565,48565,48564,48565,48565,46516,46484,48564,46484,46516,46517,33839,33905,33808,31727,33873,31695,31727,27533,29647,29647,25421,29647,31759,33937,33840,35953,29679,33905,31792,33873,31759,27566,23308,21227,25389,17001,21228,17034,19147,16969,19147,14889,19082,29614,46451,44338,50613,52823,33740,19016,35887,37936,29580,48565,14824,8582,10630,10695,12743,10631,25420,31693,21128,12709,35853,48465,48465,48399,44043,40013,14789,12709,37966,37966,37966,37934,37934,50677,57017,50710,44338,46483,27498,12708,10692,14853,16966,29546,44240,31595,35788,42126,54837,50446,50512,48563,16934,8581,4324,4324,4323,6404,33807,40178,40145,42226,27435,12677,14791,12743,10630,10630,8485,6371,8452,6371,8484,10597,8485,6371,8484,8484,6404,6404,4259,4259,6436,8516,25387,23274,25355,23242,33774,37999,33741,23177,29581,16936,25355,44370,33773,27402,29548,29548,23177,16936,12775,8550,8582,8582,8550,12775,16937,16904,25387,31693,21129,125},
{52890,50809,50809,52857,52889,52857,50777,50777,50777,50777,50809,50777,50777,50777,50809,50810,50809,50809,50809,50809,50809,50809,50841,50809,50841,50841,52890,52889,52857,50809,52857,52857,52857,52857,52889,52857,52857,52857,52857,52857,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50777,50809,50809,50777,50777,50777,50809,50777,50777,50777,50776,50711,50743,50743,48597,48631,48631,46550,48631,48630,46550,46518,46550,48598,48597,48564,50678,48630,50677,50677,50677,50710,50677,50677,50645,50677,50677,50645,50710,50710,50710,50710,50678,48597,48565,48500,48532,48564,48532,48565,48532,48532,46516,42258,40112,44240,42160,50678,48532,25355,25356,27404,25323,23243,23275,33742,27371,23146,21130,19017,23275,21195,19049,19082,29516,27370,29548,52790,44338,50645,52790,35886,25322,40145,42194,38000,46453,14857,10662,10630,8517,10631,8518,12743,31693,31660,27402,40046,44271,48464,50545,48367,33739,21127,21127,37966,37966,37966,29515,25289,31660,35854,29515,27402,29515,23271,19078,16965,21158,16933,27465,40013,23112,21031,42061,48432,48235,50511,37998,12741,6469,4324,4324,4356,6404,29581,42291,38032,38032,33742,10564,14921,19114,12776,12776,10662,6404,6437,4259,6437,10662,6436,4323,10630,8582,6469,6437,4324,6404,6436,8548,21160,23274,27467,33741,37966,37967,38031,31693,18984,12775,19016,35886,35887,29515,29548,23144,25290,18984,21096,16936,10663,8550,8550,12743,14855,14823,16936,23242,12743,99},
{50809,52857,50809,52857,52889,52889,50809,48729,50777,50777,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,52890,52890,50809,52889,52890,52857,52857,52857,52857,52857,52857,52857,52857,52857,50809,50777,52857,52857,52857,50809,50809,52857,50777,50809,50809,50809,50809,50809,52857,52857,50777,50777,50777,50809,50777,50777,50809,50777,50809,46616,48696,44503,38230,38197,36116,36084,36052,33971,31858,31858,33938,44371,42192,48532,50677,48531,46451,46451,46451,48531,46451,48531,48531,48596,48563,52790,54936,57016,57017,57017,57017,57016,54968,57048,57017,57049,57049,57048,57016,40113,33807,31661,42029,48466,57049,38000,12743,12776,12776,12744,12776,12776,14856,27338,21032,12678,16937,14824,10663,16872,16905,35788,39916,27435,50612,42225,42259,35886,21160,14854,46452,46452,50646,48565,19017,10663,12743,10662,12743,10663,10662,25419,27434,27434,44272,46385,48432,50578,46384,29481,19013,27466,37999,37999,37966,40047,42095,40014,40046,40047,42094,40046,31658,23238,21191,25384,27401,31595,35787,37868,44108,33511,29285,46155,54804,33740,6436,4324,4323,8581,4356,4323,27500,44372,40178,44339,31661,10564,14888,17066,12808,10695,8582,4323,10663,12775,10662,8549,4323,4291,10662,8582,8517,8550,4324,6436,8580,8548,10693,8548,8516,27467,38031,37999,35886,31660,16935,10630,16903,21129,31628,27435,31628,37934,42192,35853,42160,23242,8582,8582,8582,10663,16936,16936,14823,8549,16936,105},
{50809,50777,50809,52857,52889,52889,52857,50809,50777,50777,50777,50777,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52922,52857,52857,52857,52857,52857,50809,50809,52889,52857,52857,52857,52857,52857,52857,52857,50809,52857,50809,50809,50809,50809,50809,52857,52857,50777,52857,50809,50777,50777,50777,50776,50777,50809,50777,52857,46584,48664,42390,36149,38197,36116,34003,34003,31923,31891,31858,31858,44404,44370,46386,48531,46451,48531,46451,46451,48499,46450,48499,48499,48564,48563,48531,48531,48563,50676,50612,50611,50643,52724,50643,48563,50644,50611,50611,46419,31694,27534,27501,37902,42095,52823,35887,14857,12808,12808,12808,12808,12776,12808,31498,46157,21032,16872,16937,14824,16872,18985,35723,37868,31661,54871,52726,40145,27466,16965,16967,46484,44339,48533,48565,19017,12711,16936,21129,16936,14855,10629,12806,12773,16934,44304,52757,44174,50578,46352,44272,25321,33805,37966,37966,37966,50610,50643,50611,50643,50643,50610,37998,25353,19046,19014,19015,25321,37998,40046,44239,44141,42028,46155,48300,33708,14823,8549,8517,10661,8549,4356,2211,23307,44372,42258,42258,27435,12645,14823,14856,10630,8517,8517,6404,10662,12743,10630,8517,6372,6404,10630,8550,8485,8517,4291,8548,10629,8580,10628,14855,21129,33806,33806,29515,23209,31660,35918,33773,27435,21128,25290,25322,29515,25354,19015,31660,25322,10630,8582,8550,8550,10630,16936,23210,16871,16903,23209,106},
{50809,50809,50809,52857,52890,52857,52857,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,50809,50841,52890,52889,52857,52857,52889,52889,50809,52857,50809,52857,52889,52889,52857,50809,50809,52889,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50777,50809,52857,50777,50777,50777,50809,50777,50776,50776,52857,46616,46616,42422,38197,36149,36084,34004,34003,34003,33971,31890,31858,33938,38099,46517,48532,44338,46419,46451,46451,46451,46451,46418,46451,46418,46450,48498,48531,48498,48498,48466,48498,46450,48531,48499,46418,46418,46418,44305,46451,33840,27534,29615,33742,42128,54871,48565,16937,12808,12809,12776,12776,12776,10663,33448,54346,46156,25160,20999,25192,18920,18920,31531,27370,29547,57017,50678,40145,25385,16998,16934,44338,50677,48597,46452,19017,12743,16936,21129,16936,16935,14854,12805,14918,23208,48465,48531,37836,50578,46351,42192,23209,33773,37998,37966,40079,50611,52822,52757,52757,50676,44271,18982,16934,21158,23239,19078,14853,16901,12676,25321,44271,50577,48333,27337,8550,8550,12743,19081,16934,8516,6404,2211,21162,42324,46452,46484,29516,12645,12645,10532,10532,10532,10532,10565,10565,10532,10532,8484,10532,10565,8452,8452,8452,6371,6371,8516,10660,10660,8516,23241,40080,37967,27402,31661,31661,37999,40144,40112,37999,25322,18984,27435,27435,19016,16935,27435,21161,8582,8582,8582,8582,10630,14823,27467,37933,46386,37934,105},
{50809,50777,50777,52857,52858,52890,50777,50777,50777,50809,50809,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,52890,52890,52889,52857,52889,52889,52857,52857,52889,52889,52857,52857,52857,52889,50809,50809,52857,50809,50809,50809,52857,50809,50809,50809,50809,50809,50777,50809,50809,50777,50777,50809,50809,50809,50809,50776,50777,50809,46616,48664,42390,38230,38197,36117,34036,34003,34003,34003,31923,29778,31826,36051,38131,42226,46484,52758,50710,50677,46451,52758,46418,52790,46418,48563,46450,52758,48531,48498,48466,48499,48563,50645,52790,50709,50677,50677,50677,48564,33839,27534,27534,31662,44338,54904,50678,14824,10696,10728,10696,10696,10696,10631,37673,54345,52298,50186,50251,48204,41964,18919,27404,21162,40080,59162,48597,42290,27434,25354,19048,44339,52790,44370,44338,19016,10630,16936,21096,16935,19016,19079,14886,8612,21095,48465,44239,44238,50577,42191,27402,25322,33806,37999,37966,37933,42191,54903,54936,52790,42224,50644,33773,16934,14885,16966,19046,21191,19046,10629,8484,25321,25256,18950,8550,8582,8583,12775,21160,14854,10662,6436,2211,19081,42324,44371,44371,37968,12613,12678,10565,12613,10532,10532,10565,10597,10532,10532,10532,8452,10565,8484,8420,8452,6371,6404,8548,10628,12741,8547,29548,38031,37999,40112,37966,35886,40080,35854,29515,25290,19016,16903,23209,25322,19016,23209,27402,25355,10630,8549,8549,8517,14823,25322,21096,21063,23176,31628,106},
{50809,50777,48697,50809,52857,52889,50809,50777,50777,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,52890,52890,52890,52889,52890,52890,52889,50809,52857,50809,52889,52889,52857,52857,50809,52857,52857,50809,52857,50809,52857,52857,50841,50809,50777,50777,50809,50809,50809,50777,50777,50809,50809,50744,50776,50744,50776,50744,50744,50777,46583,48664,42390,38230,38230,38197,36084,34004,34004,33971,31891,31858,33938,38164,33938,44307,46451,48532,48532,46451,46419,48532,46418,48564,46418,48563,46418,48564,48499,46450,46418,48499,48531,48531,48596,48564,48564,48564,48531,46450,33807,27534,27535,29614,40112,54871,44274,12743,10696,10696,10696,10696,10696,10663,29321,35496,39688,41769,39754,33545,33578,31465,27370,19082,27468,42225,46484,42258,25354,19081,19049,42290,50677,46483,48532,23210,14856,16904,23209,16936,19048,19047,16998,8580,21128,48465,48464,46351,48497,33708,25290,23210,31628,37999,37966,29515,37966,48596,50678,44403,31660,29580,21192,16966,19078,16933,19046,16965,19078,12741,8549,8484,10564,12710,19049,10663,8550,10662,21127,16966,10726,6468,6404,19114,42357,38033,33775,33774,12613,12678,12645,12613,10564,10533,10565,12678,10565,10565,8485,8452,8485,8517,8452,6371,6371,8484,10661,8548,10693,8515,19047,37999,37999,38031,29548,27435,27467,25289,23209,25290,21096,27402,33708,40047,33741,21064,21096,33774,35887,29548,27435,40079,46417,35885,33740,42127,42160,35854,105},
{50777,50777,50777,50777,50809,50777,50777,50777,48696,48729,50777,50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,52890,50841,50809,50841,52890,52889,52857,52889,52889,52857,52889,52889,52857,52857,52857,50809,52857,50809,50809,52857,50809,50809,50809,50809,50809,50809,50777,50809,52857,50777,50776,50809,50809,33873,23276,25454,25454,25454,25454,25454,25454,25454,23373,23374,23374,23374,23341,21261,21293,21261,21229,21261,23309,23341,25421,44307,48564,50645,48597,48564,48597,48564,48596,50677,48597,48596,50676,50677,50677,50676,50677,50677,50677,50677,50644,50612,48563,46451,44402,48597,31727,27534,27534,27566,42193,54904,50678,14824,10728,10728,10696,10663,10696,12743,27241,16775,16775,20935,18887,14727,23113,37641,42062,17034,12775,35887,50678,44372,21161,10694,10662,38065,44305,46419,52790,23177,10598,16903,25323,21129,16936,21160,19078,14885,29514,48497,48465,50545,42159,27370,25290,16937,27403,35854,37934,29450,29482,31562,29482,29514,27434,12741,10661,19046,21158,21223,21158,16933,16966,19078,12741,14823,27468,31596,25355,10663,8583,8550,16935,14886,8581,6501,4356,16937,42324,40146,33775,31726,12645,14790,14823,10565,10564,12645,10565,14791,12710,10532,8484,8452,8517,10565,8452,8484,6371,4323,8548,8548,8580,8548,6435,19047,37999,40080,31661,23209,25354,25290,25290,25322,21129,19016,33741,37934,31660,19016,21096,31660,44305,44337,46418,54869,50611,27401,21095,21128,21128,23209,106},
{50777,50809,50777,50777,50809,50777,50809,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,52889,52890,52890,52857,52857,52889,52857,52857,50809,52857,52857,52857,50809,52857,50809,50809,50777,50809,52857,50777,50809,50809,50809,50777,50777,52857,50809,52857,50809,52857,31761,14890,17035,17035,19116,19116,19148,17035,17035,17035,17035,17035,17003,14955,14923,14922,14890,14922,14954,14922,14922,17002,27501,27533,27501,27533,29581,29614,29614,29581,29613,29614,29646,29613,29613,29614,29613,29614,27565,27565,29613,31694,29646,29646,35854,40112,44338,31662,25454,25454,27534,42226,54904,50678,14824,10696,10728,10696,10663,8648,16871,31368,20936,25128,23015,18920,18888,16775,23048,37903,19082,14889,40146,46484,42226,21161,10662,8582,35920,46419,48532,52790,23209,10598,16871,31661,25323,12710,19047,16997,14853,31626,50545,48465,48496,42159,27402,27435,14856,27403,42193,42127,52658,50611,48498,50644,50644,40079,19015,12741,21158,23303,23302,21190,21158,19078,19078,16966,16934,21160,27435,31629,10663,8583,8550,12742,19047,12773,8581,6436,14856,40244,40210,44339,35919,12677,12678,8484,10565,14790,10597,10565,14823,16968,14823,12711,10630,8517,8516,8483,10628,8516,6403,8548,12741,10692,10660,8548,6435,21161,29547,29515,27402,27403,25354,25322,23241,21129,14822,25322,29515,29515,21096,23209,25322,42192,42192,35852,46353,48563,21095,6435,6435,10596,12709,107},
{50809,52890,50809,50777,50809,50810,50777,50777,50777,50777,50777,50809,50809,50809,50809,50841,50809,50809,50809,50841,50809,52890,50841,50841,52890,52889,52890,52890,52889,52857,52857,52857,50809,50809,50809,52857,52857,52857,50809,52857,50809,50809,50809,50809,50777,50809,50809,50809,50777,50777,50809,50809,50777,52857,52857,33841,19083,21196,23309,23309,23309,23309,21228,21196,21196,21196,19116,19116,19083,19083,19083,17003,19083,17002,17002,17002,17002,16970,14922,14922,17002,16969,16969,19050,16969,19050,19018,16937,14857,12776,14825,14825,12776,12776,12744,12744,12776,12744,12744,27371,37934,46386,31694,25421,25421,25421,38000,52790,44306,14824,12776,12776,10696,10696,12776,27403,35529,27208,33546,25192,21000,18887,18888,21032,29517,21227,21194,44340,50709,42226,19048,12807,12774,35952,48597,48564,50677,37967,35821,35821,44306,33710,14790,23240,19046,14885,33771,48497,48465,48497,33740,23241,25322,12743,27435,50678,48498,52724,50709,50644,50676,46417,48498,35886,21127,19046,14885,19078,21222,21222,23302,21190,21191,16966,16934,31661,37967,12775,6502,8582,12775,19047,12805,8581,6435,14888,40211,42324,40145,37968,14726,12678,8484,6372,8419,8420,8484,14856,21195,16937,14823,14823,12742,10629,8483,10628,8548,6468,8516,10629,8548,8548,8548,6436,19048,31693,35887,25290,25322,23209,25322,23241,35887,40144,29515,29515,27402,29483,31628,29483,40111,42224,44337,50644,44338,21095,10628,12741,12741,16935,112},
{50809,52890,50809,48729,50809,50810,50809,50809,50809,50777,50777,50809,50777,50809,50809,50809,50809,52857,50841,52890,50841,52890,52890,52890,52890,50841,52857,52857,52889,52889,52857,52889,50809,50777,50809,52857,52857,52857,50809,50809,52857,50809,52857,50809,50809,50777,50809,50809,50809,50777,50809,50809,50809,50809,50776,40179,35953,35953,40179,38034,38066,38066,38066,35985,35985,38034,35954,35954,35953,35953,35953,35985,35985,35953,35985,35986,35985,35953,35985,35953,38033,35953,35953,35953,35953,38033,38001,35953,35953,35953,35921,35921,35888,35921,35921,35888,35888,35888,35888,37869,44272,48499,31662,27534,25454,27502,42193,50644,40113,25421,25421,23341,23373,23341,23341,29582,33612,27110,25062,23015,27273,29385,29352,31498,37870,21163,23242,44305,46484,42227,21193,14886,17032,23275,48630,52791,48597,44241,42160,40014,48467,40048,25322,19047,14885,16966,37965,48465,50545,37965,23208,23209,25323,16936,27403,27435,35854,46450,52823,52822,48629,44272,50709,35887,23240,14886,8580,8580,14853,16965,21190,16998,10692,6435,6468,27466,37967,14856,8614,10726,10660,21159,14886,8548,10660,14887,40179,40211,33807,37968,20999,18918,18853,16740,16773,16772,14692,16837,16773,16773,16740,16837,21126,14820,10596,14821,10628,8548,8516,8516,8548,10661,8548,6469,12743,12775,23242,25322,31661,35821,40047,23242,29580,44338,35788,35788,42159,37934,40047,37999,40144,44271,52624,50511,44172,16901,10628,12741,16934,19015,98},
{52857,52857,50809,50777,50809,50777,50777,50777,50809,50777,50777,50809,50809,50809,50809,50809,50809,50809,52890,52922,52890,50841,50841,50841,50841,50809,52890,52889,52889,52857,52857,52890,50809,52857,52857,52857,52857,52857,50809,52857,52857,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,31727,19050,21131,25389,21163,21195,21196,21163,19050,17002,17034,17002,17002,17002,17034,17002,17002,17002,19050,19050,19050,19083,19082,19083,21163,21163,21163,21163,21163,21163,21195,21195,23244,23243,23275,23243,23243,23243,23275,23275,23243,23276,25356,25355,31628,40080,40048,27501,25422,25421,25421,42193,52725,38065,29679,29647,29647,29647,29647,27567,27567,33710,46059,43816,37544,29321,27305,25160,33546,48238,18952,23241,48563,48598,46453,21194,17000,29613,16905,46485,50710,48532,35853,33740,37966,48499,46385,37999,21159,14853,16966,40078,48497,48465,50677,37999,27403,29515,25322,23242,23210,27403,40047,40046,37934,31659,25385,27466,12740,14853,14885,14917,16966,12772,14885,16965,12805,8547,8516,12742,21128,42193,14888,8614,17030,16965,21158,19046,14853,14886,12773,38098,40179,31694,37967,39817,41996,31464,31432,31432,33512,39849,44206,42029,37835,39948,37802,31561,21158,16869,18982,16869,14789,23209,6404,6436,8549,10662,10662,10630,8550,12742,25387,29548,31628,29515,14823,19016,35854,37998,40046,37934,35854,31628,23176,27402,42061,50445,52525,41993,25255,19014,12676,23208,27467,126},
{50809,52857,50809,50777,50777,48729,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,52857,50809,50841,52890,52890,50841,52890,52890,52890,52890,52890,52857,52889,52889,52857,52857,52889,52889,52889,52857,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,52889,40147,31728,33840,33840,33841,33873,33841,33808,33808,31760,31728,31728,31760,31728,31728,31695,31695,31728,31728,31727,31695,31727,31727,31695,31728,31727,31695,29614,31727,29646,29614,31695,29614,29614,29582,29582,29582,27533,27501,29582,27501,27501,27502,27501,33741,31628,33806,29614,25422,23341,25421,42162,52758,31727,27567,27534,27534,27567,27534,27599,27567,29647,35756,35560,41898,39819,29353,27272,33512,46059,18951,27500,44371,46420,48533,19017,19048,35920,16905,46453,54903,44338,33740,33708,40047,44273,42192,29547,19078,16998,19046,44239,48465,46384,52757,40079,31596,23209,25322,25322,23242,29580,35886,35820,40111,42224,25320,16965,14886,16934,19046,21191,21158,21158,14917,16998,14885,10692,10660,29580,42192,44338,14888,6470,8581,12806,16967,14854,8580,10628,10628,35986,40179,33774,35754,43977,41995,29318,29350,29350,33510,46188,42060,37834,37801,37834,37801,27367,23206,18981,16869,14789,16935,16935,14791,12775,8615,10663,8582,8582,8550,12743,25387,27435,25322,16904,12711,23177,23241,29548,29515,29515,35886,46450,46418,42192,44240,48465,50578,46319,27400,16901,12741,19047,29579,146},
{52857,50809,50809,50777,50777,48729,50809,50777,50809,50842,50810,50810,50842,50809,50809,50809,52889,52890,52890,50841,50809,50809,52890,50841,52890,50809,50809,52889,52889,52889,52857,52857,50809,52857,52857,52857,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50776,50776,50809,52890,31760,21163,25356,25389,25389,23308,23309,23308,23276,23276,23276,23276,23276,23308,23276,21227,23308,23308,23276,23276,23308,23308,23308,23308,23308,23308,25388,25389,25389,25388,23340,25421,25389,25421,25421,25389,27501,27501,27469,29582,27469,27469,27469,27469,35822,35821,31694,29582,27534,25454,27502,42226,44306,29582,29615,27535,27535,27567,27535,27567,25486,27534,16936,33675,52559,50413,41963,44043,52363,48105,18951,31726,48597,46452,48565,19049,25387,40113,18985,44371,52790,42225,31596,33676,37934,40079,42160,21160,10725,14918,19078,44239,48464,48432,37933,35886,31596,23178,25290,23210,23210,35886,37934,37933,48563,57016,44337,23239,21159,23272,25352,19047,21159,14885,10661,10693,12740,10692,8580,8516,29547,44338,19049,12743,6469,10695,14887,12806,8580,8579,12773,33905,35986,40145,42027,44074,44075,43976,46024,46057,46056,48333,46089,46056,46088,48169,44009,31528,25287,21127,19014,14821,23274,27467,29613,14856,8582,8582,8550,8582,8550,10663,25354,25322,33774,37967,31661,27402,23177,29516,27435,29548,29515,33741,46418,46385,52789,52822,52790,25322,10597,10693,12773,10660,14822,92},
{50809,50809,50809,50777,50777,48729,50809,50777,50809,50842,50810,50809,50809,50809,50809,50809,52890,52890,52857,50809,50809,52890,50809,50841,52890,50809,52890,52890,52889,52890,52889,52857,52857,52857,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50777,50809,38066,29647,31760,31727,31727,31727,31760,31760,31727,29647,27534,27534,27534,27534,27501,27502,27502,27502,27502,27502,27469,27469,27501,27502,27469,27469,27502,27469,27469,27469,25388,25388,25356,23276,25356,25388,25388,25356,23308,23243,23276,23275,21195,21195,33676,39981,37901,31662,27502,27534,27534,42194,50645,29582,29615,27502,27567,27534,27535,27567,25454,25421,16968,19016,27402,33675,27337,31497,44043,50218,20999,33807,46451,44307,44404,21162,31693,38000,35888,50743,50710,37999,35854,37934,40047,42160,27434,14854,10693,10661,19015,46352,48432,48432,42159,35886,31628,25323,25290,25322,27467,37966,35886,40079,52823,52758,44337,21127,19047,21127,29544,14853,8580,10725,8548,10660,14917,12805,10661,10629,31693,40111,35886,27436,8582,8550,19048,14854,10660,12804,12740,33872,38099,42193,41929,44076,35624,43944,43976,37639,44042,46188,39816,48169,43976,39751,46187,33641,25287,19014,14820,12708,10661,10596,27435,29580,23242,16968,12743,10630,8550,10630,25323,29515,40112,42224,42257,40112,23209,23209,29548,29548,29548,21129,31693,44305,44305,40112,23242,8518,8550,6437,10694,8581,10629,79},
{50809,50809,50809,48729,50777,50777,50809,50809,50777,50809,48729,50809,50809,50841,50809,50841,52890,52857,52890,52890,50809,52890,52890,50809,50841,52890,50841,52890,52857,52890,52889,52857,52857,50809,50809,50809,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50777,50809,33873,25421,29582,27502,27534,29582,27502,27534,29582,27534,27502,27502,27469,27501,27502,27501,27534,27502,27534,27534,29614,27534,29582,29582,29582,29614,29614,29614,29647,29647,29614,29614,29614,29614,29646,31694,29646,29614,29646,31695,31695,31695,29646,27534,35822,54838,54870,29613,25389,25389,25389,37967,46452,46453,44404,44372,44372,44372,42292,42291,42259,40178,23274,19081,16969,21130,14824,19049,39850,50186,23111,42194,48565,46420,46485,19082,35920,42193,35887,54904,48597,37967,35886,37966,42159,40079,21127,19014,14854,12774,19015,46352,46352,48464,44239,35854,31661,25290,35788,31595,29515,37967,35853,42192,52855,46418,25321,10596,25321,25320,29577,23270,12772,10692,14885,16998,16997,14885,10662,12775,40112,40014,40047,27435,8614,4356,16934,12741,10660,14885,14820,31791,40212,46320,43944,44009,43976,43976,46056,43976,46057,46089,46056,46056,46056,46056,48202,39880,29447,23207,21094,14789,6435,14822,33806,35919,35919,37967,35886,31693,25387,21161,25290,33741,40112,35886,29548,25354,16903,21129,29548,29516,29515,18951,18951,23144,23144,25290,16903,10630,8550,6469,8549,12743,27467,122},
{50809,50809,50777,48729,50809,50777,50777,50809,50810,50777,50809,50809,50809,50809,50809,52890,50841,52890,52922,52890,52890,50841,50841,52890,52890,50809,52890,52889,52857,52889,52889,52857,50809,52889,52889,52857,52857,52857,52857,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,52889,35921,27469,29582,29582,29550,27534,27469,27502,25421,25421,25389,25389,23341,23308,23308,23276,23276,23308,23308,23243,23276,23276,21195,21195,23276,21195,21195,21195,21196,21195,21163,21163,21163,21195,21163,21163,21163,19082,21130,21131,21131,21131,21130,21098,33774,56984,54871,27469,23341,25421,21162,37999,52823,54937,52856,52856,52824,52856,52824,52824,52856,52823,44371,25355,19081,23210,21162,23178,31497,46058,27305,42226,44339,42194,44372,21163,42227,48565,40113,50710,48564,35821,35854,37966,42128,37966,25320,27465,21159,16966,23240,48498,48465,48464,42159,33773,31628,33643,50414,31562,31629,37967,35853,44272,54903,50644,25321,14854,29547,31627,27432,23271,19077,16997,19110,16965,21191,17030,10694,12775,38032,44337,42224,21128,10693,8580,19046,12805,14885,12805,14853,31791,38099,44109,43943,43976,46024,46056,46056,46024,46024,46024,48104,48104,48136,46055,48136,46088,41928,33608,21094,12741,6435,14854,31694,35887,35887,33773,33806,37999,40079,37999,25322,29580,29515,25322,25322,25354,37999,35918,29515,29548,31628,33674,35721,31528,40046,46450,44305,40079,33806,23274,10629,17001,40112,173},
{50809,50809,50809,50777,50777,50777,50777,50777,50809,50777,50809,50809,50809,50809,50809,50809,50809,50841,52890,52890,52890,52890,50809,50810,52890,52890,52890,52857,50809,52857,52889,50809,50809,52857,52857,52857,52889,52857,52857,50809,50809,50809,50809,50777,50777,50809,50809,50809,50777,50809,50777,50809,50777,50809,50809,35986,29647,31727,31760,31760,31760,31760,33840,31760,31760,33808,31728,31728,31728,31760,31728,31728,31760,33808,33808,33808,33808,31727,33775,33808,33808,33807,33840,33840,33840,33808,33807,31727,33807,33840,33807,33775,33775,33807,33807,33840,33839,31759,33807,35887,46385,44305,35887,23276,25388,21097,33773,52791,52856,52823,52823,52823,52824,52823,52823,52823,52823,52823,29580,25354,29548,27403,23210,33676,33643,27370,48532,42291,35921,44372,31629,48565,44339,40113,52791,46451,35821,37934,35821,37934,35853,31658,31690,23272,19046,29514,54870,50578,46319,48465,33741,33773,44174,46189,31530,31661,37999,35853,48596,52790,50677,27466,12741,23274,19047,27465,21126,21158,21158,19110,16997,16965,19079,10694,10631,23242,31659,21128,14853,16966,16965,19078,12773,14885,14852,14820,31726,38098,39817,41864,39751,41831,41863,41831,41863,41896,41831,43943,43944,43944,43976,41864,43944,37703,23110,12708,10660,12741,12740,23209,25354,27468,27435,21129,31661,31660,23209,23209,27403,25322,25322,27403,23274,40112,42224,33773,40079,46351,54704,56783,52591,46352,44337,44337,42224,40047,33708,14823,10695,16968,152},
{50809,50809,50809,50777,48729,48697,50777,50809,50809,50777,50809,50777,50809,50809,50809,50809,50841,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,50809,52857,52889,52857,52857,52857,52857,52857,52857,50809,50809,50809,50777,50809,50809,50809,50777,50777,50809,50809,50809,50809,50777,50809,50809,50809,52857,33808,23244,25357,25356,25389,25389,25356,25324,25324,25356,25356,23244,23244,21163,21163,21163,21131,21131,21163,23243,21130,21162,21130,19082,21130,21131,21130,21162,21130,21131,19082,19050,19050,19082,19082,19050,19050,19050,19050,16969,19050,19050,19050,19050,31661,44305,46418,52758,18952,16905,19017,33806,52856,52824,50775,52824,52823,52824,50743,52823,52823,52824,52823,44306,44273,33709,35920,27403,27403,29483,33709,46452,38033,27534,46485,40081,50678,42226,40112,52823,44306,31596,33708,37934,40112,40079,46385,35885,14853,14853,27466,50578,48432,40014,42159,29514,31660,33741,35723,29482,31661,35886,37933,50709,48564,46450,27402,14822,19048,14821,21159,21158,21094,23174,23174,16933,10660,19077,21160,23242,21095,35852,40112,35886,27466,31594,27433,16934,16998,19078,16933,27533,42161,43977,44075,37704,46089,41832,35558,46220,39817,41831,48169,39784,41896,46253,33511,33511,20997,8515,14821,12773,12708,16934,33806,31725,31661,27467,14823,16935,23177,23209,23241,27403,25322,27435,25354,12775,19016,40079,44337,44304,48464,56849,54704,50479,42224,40079,33773,29547,29515,29515,16904,10662,10630,99},
{52857,52889,50809,50777,48697,48696,50777,50809,50809,50809,50809,50810,52890,50809,50809,50841,50809,50809,50841,52890,52890,52890,52922,52890,50841,50809,50809,52857,52889,52889,52857,52889,52889,52889,52889,52857,52857,50777,50809,52857,52857,52857,50809,50809,50809,50777,50809,52857,52857,50809,50809,50809,50777,50809,48696,40146,40113,40146,40146,40146,40146,40179,40146,40114,40114,40114,40114,40146,40146,38066,38066,38066,40146,40114,38066,40114,38066,38066,38066,38065,40146,40114,38065,38065,38033,38001,38033,38000,38033,38033,38000,37968,38001,38000,35920,37968,37968,37968,37968,37935,46418,48531,50613,18920,16872,21130,40112,54937,52824,52824,52856,52856,52857,50775,52856,50775,52824,52856,52856,44240,33708,46452,29483,23241,29547,42225,50646,35954,27502,46486,38000,48598,40145,42225,52790,42193,35821,35854,35821,37934,33708,42257,33805,10660,10628,31627,50545,48465,40015,42127,42127,31628,33708,33610,29483,33774,35886,37966,52757,54968,50709,23240,16902,16934,19047,19046,21159,25255,41832,33543,16934,8580,10693,12741,35886,44337,44369,46418,46418,46385,52789,44305,23240,16965,21158,16932,27532,42094,44042,44107,44009,46089,46089,46089,48301,46122,46121,46089,48169,48202,46220,35624,18981,12740,12740,10628,6403,6403,21193,33838,33774,29580,25355,14855,19049,23209,33741,29548,27402,27435,27435,23242,10663,12711,23176,42192,46384,48398,52624,54736,42125,31660,27467,29515,29515,29548,29548,19016,10630,14855,91},
{52889,52857,50777,48729,50777,48697,48729,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50841,52890,50841,52890,50809,52890,52889,50809,52857,52889,52857,50809,50777,50809,52889,52857,52857,52857,50777,50809,52857,52857,50809,50809,50809,50809,50809,50777,50809,52857,50809,50809,52857,50809,50777,50776,35920,31662,31662,31694,31662,31662,31694,31662,29582,27501,27501,27502,27501,27501,27501,27469,27501,27501,27501,27469,27501,27501,27469,27469,29581,29549,27501,29549,29581,29549,29549,29549,29549,27436,29549,27468,27403,29516,27436,27436,27436,29516,29516,29516,33709,50612,48499,44274,18953,14824,21130,38032,52856,50743,50743,50743,50743,52824,50743,52824,50711,50743,52791,50677,40014,42160,40112,21129,19016,23210,42129,46484,33872,27502,48599,33742,44372,40080,42226,50710,37967,33676,35821,40080,40080,37999,40112,27434,16933,19046,35885,48465,50611,50710,44271,44272,21128,29547,40047,42226,37934,35885,42160,54903,52823,50677,31660,25385,23240,23240,19046,12644,18950,27237,18917,19078,12805,6436,4355,10596,35886,40112,40144,44305,48498,35886,14789,23240,19046,19045,21126,29547,44043,46220,42126,39948,37835,39947,46155,46319,44174,39980,39948,41994,48333,39948,29449,21094,19046,10627,6435,6435,10628,29580,33806,25322,19016,21097,16936,23242,25290,23176,29515,33741,27403,27435,21129,10630,12743,16903,33773,50577,54736,54736,52624,35853,27467,27467,29548,29515,29516,29547,19016,10630,12742,63},
{52857,52889,50777,48729,50777,50777,50777,50777,50777,50809,50809,50809,50809,50809,50841,50809,50809,50841,50809,50809,52890,52890,52857,52857,52890,52857,52857,52857,52889,52857,52857,52857,50809,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50777,50777,50777,50777,50809,50809,50809,50777,50777,50777,50776,50809,42291,38033,40146,40178,40178,40146,40178,38098,40146,40146,40146,38066,38066,40146,40146,38066,40146,38066,38066,38066,38066,40114,40146,40146,40146,40114,40114,40113,40113,40081,40114,40081,40081,40080,40048,37968,37968,40081,38000,37968,37967,38000,37968,37967,35854,50645,46255,37608,18952,14792,21098,35952,48662,46517,46550,46550,46550,48598,48630,48630,46517,46549,48597,42258,25322,35854,35886,23210,23210,27469,44308,48597,29614,27535,44404,29582,40114,40112,48532,50710,37902,33708,35821,37934,37934,35886,23241,19047,40111,27368,40014,48465,42094,48531,44240,29548,16904,23209,31596,27467,35886,35853,44273,54871,50644,35821,16902,25289,23241,23239,23240,29547,23241,10628,8548,14885,12773,8581,14823,10597,12741,12708,21095,40079,40111,19013,14885,23272,16965,21159,35886,40014,44076,39915,39883,37802,37770,35625,39883,37803,35689,35689,35721,37801,42060,35689,27368,14821,14853,10660,6467,8516,14887,31693,33741,31629,33774,38000,27435,23209,25354,21095,23208,37999,35918,27435,14823,12743,12743,16871,27402,42126,46253,46253,46352,35886,29515,27467,29548,29548,29515,29515,21129,14855,16966,57},
{52889,52890,50777,48729,50777,50777,50777,48729,50809,50809,50809,50809,50809,50809,50841,52890,50809,50809,52890,50841,52890,50841,52889,52857,52890,52889,52857,52857,52857,52857,50809,52857,52857,52857,52857,52857,52857,52857,50777,50777,50809,52857,50809,50809,50777,50777,50777,50776,50776,50776,50777,50777,50777,50809,50744,35952,29582,29582,29615,29647,29647,29647,29614,29582,29582,27502,27501,27501,27501,27501,27469,27469,27469,27469,27469,27469,27469,29581,27501,27501,29582,29549,29549,27501,27501,27469,27501,27501,27468,27468,27436,27436,27501,27469,27469,27468,29549,27468,25356,31629,48564,52691,50383,21065,16937,21130,38032,46517,42291,40243,40211,40243,38162,38130,38130,38098,38130,36017,21227,16968,14823,29549,25322,40047,40178,40146,44372,21195,25422,40178,29582,31695,35887,46516,48596,40079,40079,40079,44273,37934,37934,33773,29514,46385,29481,42159,46255,44076,42159,27402,16904,14888,21096,29548,29548,37966,35853,44305,54903,54936,33773,16902,25355,16935,23240,27465,48597,35918,12708,10661,16998,16934,8582,16936,23177,21096,19047,21127,23239,21126,19045,16965,23271,19046,14852,23272,21127,19015,12710,25322,44305,37998,29418,14726,12613,16902,18982,21063,14789,16869,12708,16901,14853,16997,14884,10660,10660,10629,25387,31693,29548,23242,25354,23241,25322,21161,10629,10628,35886,37999,21129,12711,10630,10662,14823,23144,23144,25159,33675,44305,37967,29515,29548,29548,29580,29548,29516,23210,14823,19047,71},
{52857,52857,50809,50777,50777,48729,50777,50777,50777,50777,50809,50809,50809,50809,50809,50841,50841,50809,50809,52890,52890,52890,52857,52889,52889,52889,52857,52857,50809,52857,50809,52857,52857,52889,52857,52857,50809,50777,52857,52857,52857,52857,50777,50809,50809,50777,50777,50777,50809,50809,50777,50777,50809,50777,50777,40211,29615,25454,25421,25421,27502,27502,25421,25388,25388,27469,29549,29581,29549,27501,27469,27469,27469,27469,27469,27469,25388,27468,27436,27468,27468,27468,27436,27468,27469,27469,27469,25388,27436,27436,25356,25388,25388,25356,25356,27436,27436,27468,25356,29516,35821,37934,39982,27403,21195,21162,40178,46550,42356,40275,38195,38162,38162,38129,38130,38130,38130,23372,10663,16968,21130,31629,42225,50644,42226,42259,44372,14857,25422,38098,27501,6437,14823,44371,44338,35821,35853,40080,42160,33741,23240,21160,37966,27467,23208,44271,48367,46221,35821,18984,14856,16936,27435,37966,33708,37934,35853,50644,54936,54903,33805,19047,16968,10629,25353,23240,42225,42224,21126,16934,14821,12774,10630,14855,23177,23209,23207,23207,19047,12773,14854,12741,16966,14885,19078,14886,8549,10663,10663,10630,25355,33741,33708,33773,31693,19048,12742,14887,10629,14854,10660,12740,14821,16965,21158,16965,10693,4355,6436,27468,27435,19049,23242,25290,25322,19048,10660,14822,29483,31596,35854,37999,29581,23242,23177,31563,31595,31562,35852,44337,38031,29548,29548,29548,29516,29515,29515,23210,14823,25289,90},
{52857,50809,50809,50809,48729,50777,50777,50777,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,52890,50809,50841,50841,50809,50809,52890,52889,52890,52889,52857,52857,52857,52857,52857,52857,52857,52857,50777,50777,52857,52857,52857,52857,52857,50809,52857,50777,50777,50777,50777,50777,50777,50777,50777,50777,52857,38066,23276,21228,21228,21228,21228,21228,19115,17002,16970,21195,29613,27468,23275,23276,23243,23243,23275,23275,25324,25356,21130,23211,23243,23211,23242,25355,23243,25323,23275,23243,25355,25355,23243,23275,21162,23243,21162,21162,21130,23211,23243,23243,23243,25323,27403,25290,31596,29549,23308,21163,33872,38066,35985,33904,31824,38097,38064,33903,33871,31824,31792,19114,10663,25387,16903,31596,33806,23274,25420,40210,38001,12712,23341,40146,31695,6437,23243,48565,42193,31628,35821,42192,42160,37966,33805,23240,33772,18982,14789,42158,50545,48432,37901,21097,12744,19016,35853,37967,35821,37934,37934,52790,52822,50644,31692,23240,16967,8548,19048,33773,33741,42159,31627,16934,10661,8549,10662,14823,23210,21097,21128,23207,19047,12775,8581,12774,16966,4323,12709,14886,8614,10663,10663,8550,21097,37901,42159,40046,29547,19016,10629,10629,10629,14854,16901,16933,14885,12740,12740,10692,8580,4291,4291,10629,23242,23242,23242,23242,23242,23209,14854,19047,35821,40080,44305,44337,44305,44272,48499,46483,50644,52692,31562,29514,40112,29515,29515,29548,29515,29483,29483,23242,14823,37934,163},
{52857,50809,50809,50842,50809,50777,50809,50809,50777,50777,50777,50777,50809,50841,50841,50809,50809,50809,50809,52890,50809,50841,52890,52890,52890,52890,52857,52889,52889,52889,52889,52889,52857,52857,52889,52857,50777,50777,52825,52857,52857,52857,52857,50809,50809,50777,50777,50777,50777,50777,50776,50777,50776,50776,50809,40179,23276,19115,19116,19115,21196,19147,14922,14889,12776,14921,25356,25388,21163,21130,19050,19082,19082,19050,19050,19050,21130,19082,19050,19050,21162,21130,19050,19017,19017,21130,21162,19049,19049,19050,19050,19050,19049,19017,19017,19017,19017,21098,21130,21162,25355,27403,35855,29582,17002,17034,14889,16969,14856,17001,14889,31660,33643,25289,25322,12775,8583,10663,8582,19048,37967,37902,31661,16968,23307,42292,38033,8550,23308,40179,31727,19017,25323,33807,42161,35821,35854,40112,40047,35820,44305,31625,50644,35853,23208,48367,48399,48465,37966,16936,12711,21129,37934,33708,37966,35853,37966,52758,54903,42225,29579,23208,19047,14854,19015,27370,33676,46385,40112,19046,16934,10630,10662,12743,19049,14823,25321,35885,27435,8582,6470,12774,16966,4355,12805,14886,10663,10663,12743,10630,16936,29515,29547,25322,23177,18983,27467,27435,21128,16934,14820,19046,16933,14853,8515,8580,8516,2243,10629,23274,27435,23209,23242,23209,25322,27403,16936,12742,23209,33773,42192,40079,42159,44272,48530,48531,52691,50577,27400,18950,25321,25322,29515,29516,29548,29515,29548,25354,10629,16934,70},
{50809,50809,50809,50809,50809,50809,50810,50809,50777,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,52890,50841,50841,52890,50809,52857,52889,52889,52857,54937,54937,52889,52857,52857,52857,52857,52857,50809,50777,52857,52889,52857,50777,50777,50777,50777,50809,50776,50777,50777,50776,50776,50776,50777,50777,50777,46518,27469,19083,19115,19115,19115,19115,17002,14922,14889,14889,19050,25356,23243,21162,21163,21130,21163,21163,21163,23243,21163,21162,21163,21163,21163,21130,21163,21130,23211,21162,23275,21162,21130,21130,21162,23243,23243,21130,19050,19049,21098,21162,21130,23211,25323,27403,35854,42291,27533,29646,23275,27566,23373,31792,19082,40112,52691,46319,31693,12776,10695,10695,8582,12775,33772,50644,44305,21161,27500,44372,35952,12743,21260,35986,29646,21129,25356,31695,35854,31595,31628,33741,40047,42127,50644,35852,52789,48498,25289,48433,48464,48432,37934,16936,10663,25323,42192,42192,37966,33773,37966,46418,48531,33740,27434,21160,16934,16902,23240,33773,35853,44305,27498,19078,19079,10630,10630,12743,12743,8517,23209,29546,29548,16968,8549,12774,16966,6467,12773,16999,10630,8550,21194,31693,27467,25322,23209,23209,27403,21063,35854,37966,31659,23240,14821,19046,19013,16965,12773,8548,6436,4355,8517,19016,31661,23242,23274,25322,21064,25290,19016,12710,14855,29548,40112,40079,42159,50610,54804,52723,52723,50576,27367,16902,16902,27435,29516,27467,29548,29580,25354,19047,8515,10596,56},
{50809,50809,50809,50777,50809,50809,50809,50809,50809,50810,50809,50809,50809,50809,50841,50841,50841,50809,52890,52890,52890,52890,52890,52857,52857,52890,52890,52889,54937,54969,54937,52857,52857,52857,52857,50777,50777,52857,52857,52857,52857,52857,50777,50777,50776,50777,50776,50776,50776,50776,50777,50777,50809,52889,52889,48631,23243,14889,16970,16969,14889,14889,14889,14889,14889,14889,14857,16937,14889,14857,14856,14856,14889,14857,14857,14857,14856,14857,16937,16937,14856,14857,14856,14857,14889,14856,16937,16904,16937,14856,14856,16937,16937,16937,14856,14889,16937,14856,14856,16904,16904,16937,19017,25387,19114,19146,16969,21163,17034,21259,14889,23274,31596,27402,19017,10696,10695,12776,10695,8614,19015,48499,29451,18985,21065,29549,31661,14856,19148,33905,29679,21097,29549,33774,40112,37967,37934,40080,35821,42127,46450,35852,54838,31595,25257,48497,48464,44272,29515,19016,10630,29516,40079,40047,37966,35853,40046,44272,37934,25321,16967,16934,16934,14821,27466,29579,33675,39981,23240,16934,19080,10630,10630,12710,16936,14823,21096,33773,48531,42257,27499,8548,12741,8548,6435,19047,31725,25387,19048,33773,42257,25322,23209,23209,25354,35854,37999,33773,31659,27465,21159,19014,23239,16965,12741,6436,6436,6502,8550,19049,33774,23242,23242,29515,35821,42160,31628,12710,10630,21129,35886,37998,46352,54835,54770,54770,54802,50543,39979,27335,23175,29548,29548,29548,29580,29515,23241,16934,10628,8515,48},
{50809,50809,50809,50809,50809,50777,50777,50809,50809,50777,50809,50809,50809,50809,50841,50809,50809,50809,50809,52890,50841,52890,50841,50809,50809,52857,52890,52889,52889,54937,54937,52889,52857,52857,50777,52857,52889,52857,50809,50809,52857,52857,50809,50777,50777,50777,50777,50777,50809,50777,50777,50776,48664,38099,25389,21163,14889,14921,16970,16970,16970,16970,16970,14889,14889,14889,14889,14889,14857,12809,14889,14889,14857,14857,14889,12776,14889,14857,14857,14857,14857,12776,14857,14856,14857,14889,14889,14856,14857,14856,12776,14857,14889,16937,14856,14856,14857,14856,14857,14824,14824,12776,14824,12743,12744,12776,12744,12743,10663,10663,10696,10695,10663,10663,10631,8583,10663,14888,10695,10662,23241,42128,16774,10534,10534,10501,16872,10599,14922,31793,31759,21130,40081,44273,40014,37934,37967,42160,42159,46418,44304,33706,48498,31594,31562,48465,48464,46352,31628,19017,10662,33773,37999,37966,37967,37933,46450,54935,44273,27434,19047,21128,16934,14822,33741,35821,35723,46287,37900,19014,14855,10630,10630,14856,27436,25290,23208,29547,40112,31660,21192,12741,10661,6436,4291,6404,25322,40047,37966,31660,31628,23209,23242,21097,23209,19049,12710,12710,16903,19015,16934,16934,19079,14854,8581,8549,10630,8582,8582,10630,23275,25323,25354,25322,25322,27435,27403,25322,27468,25322,35853,40078,52691,52657,48431,54771,54803,48464,48464,39946,27368,29515,29548,29548,29548,29515,29515,23208,14853,14821,54},
{50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52890,52890,52890,52890,50809,52889,50809,52857,52857,52857,52889,52857,52889,52857,52857,52857,52889,52857,50777,50777,50777,50809,50809,52857,50777,50777,50777,50777,50777,50777,50777,46518,19083,10664,12776,17002,17002,17002,16970,17002,17002,17002,17002,14922,14922,17002,16970,16969,14889,14889,14889,14857,14857,14857,12809,12776,12809,12809,12809,12809,12776,12776,12776,12808,14889,14856,19050,19049,16937,14857,12808,12808,14889,14824,14856,14857,14856,14857,14856,14857,14857,14824,12744,14857,14856,12776,12776,12744,14824,14824,12776,12744,12776,12776,12776,10663,8583,12808,12743,10695,16968,27403,18952,12614,12647,12646,16840,10599,14889,33841,33808,12711,21130,42193,40014,37934,33708,42127,42159,48498,33739,31626,50611,37965,35755,48302,50545,46385,35854,19016,14823,37967,37999,37999,37934,40047,52790,54935,52790,29580,19015,23273,10629,10597,35821,35789,44076,48333,37802,21127,12774,10630,10662,21129,29581,27435,29580,33805,19047,8516,12741,14853,19080,16935,10663,19082,33774,44305,46385,40014,37934,25322,21129,23210,23210,12743,8550,6469,6469,6436,19048,23274,21162,19049,16969,25388,25388,21162,14888,10663,10630,23274,25354,25354,25322,25322,31693,35886,35854,35821,35854,44271,56949,54869,56916,54836,54835,58997,40045,23175,23175,29547,29548,29548,29548,29548,27402,21160,12708,12740,56},
{52889,50841,50841,50809,50809,50809,50809,50777,50809,50809,50841,50809,50809,50809,50809,50809,50841,52890,52890,52890,50841,50841,52890,52890,52889,52889,52889,52857,52857,52857,52857,52857,52889,52857,52857,52857,52857,50777,50777,50777,50777,50809,50777,50777,50777,50776,50777,50777,50809,50777,27535,19082,14857,17002,17035,17035,14922,17034,16970,17034,17002,17002,17002,14922,14922,17002,21195,21195,23308,23276,21163,16970,17002,17002,16970,14921,16970,14922,14889,14889,14857,14889,14889,16970,16969,14889,14889,14889,14889,14857,12808,14889,14889,14889,14889,14889,14889,14889,14889,14889,14889,14857,14857,14889,14856,12808,14856,19017,21130,21098,19082,14856,12776,10696,10696,8615,8550,16969,16968,14856,12743,23242,25323,25226,23145,25194,21033,10599,12776,33841,35920,10598,14856,35887,33741,33773,33774,33741,33708,37966,23240,25353,44273,33773,37965,52528,46255,48465,40046,19016,16936,37967,37999,37966,31628,35886,50677,50677,44338,19049,10629,19047,8549,19016,40014,35691,46057,44075,27303,19015,16903,8517,14856,23177,21129,21096,19079,12740,8547,8548,14886,16933,25386,31725,14856,10663,16968,40080,44304,44239,48466,27402,23177,21161,23242,23242,10630,8550,8549,8517,12742,19049,23242,23274,23274,29548,29581,25388,16936,12743,8550,23242,25355,25322,25322,25322,23241,31660,33773,27402,27402,37933,48465,50577,50512,56916,56916,42159,12677,6404,12709,27435,29580,29548,29548,27467,21127,16934,10596,8515,35},
{52890,50841,52890,50809,50809,50809,50809,50809,50809,50809,52890,52890,50809,50809,50809,52890,50841,50809,50809,50841,52890,52890,52890,52890,50809,52857,52857,52857,52857,52857,52857,52889,52857,52857,52857,52857,50777,50777,50809,50809,50777,50777,50777,50809,50809,52857,50777,50809,50809,25454,12776,14889,17035,19083,17002,17002,14922,17002,17002,19083,17002,17002,17002,17002,14922,12744,14889,14889,14889,14857,12809,12809,12809,12776,10728,10728,12776,12776,12744,12776,10696,10696,10696,12776,10728,10728,10696,12776,10728,12776,12776,12776,12776,12744,12776,12776,10696,12744,12776,12808,14889,12808,12776,12776,12776,12744,12776,16937,16969,16904,16905,10695,10695,8583,8583,10663,10663,12776,19081,16936,21161,25323,27404,25226,25258,27338,23146,12711,10696,33873,40114,16937,16969,25324,23275,19049,12743,10663,14791,33774,27466,21160,21095,35820,44271,48498,42094,48465,37933,16903,23210,37999,37966,35854,25224,23176,27337,27369,31628,16936,14823,14854,8548,27434,37933,35689,50250,39914,16902,33708,35821,16871,25322,23210,19016,19015,23240,16997,12772,8579,16933,19079,12709,10662,8582,8582,8550,25355,42192,44272,52757,27435,23210,21162,21129,16936,8550,8550,8518,8518,8550,4356,12742,10628,19081,27500,27467,25355,14856,8517,10662,23274,25354,25323,25322,25322,16935,12677,33806,44338,40111,42191,46417,48498,46384,52625,40014,12645,6437,6469,6436,23274,29548,29547,29580,33773,33805,29579,12708,12741,30},
{50841,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50841,52890,52890,50841,50809,50809,52890,50841,52890,52890,52890,50841,52889,52889,52889,52857,52889,52889,52857,52857,52889,52889,52889,50777,50777,50777,50809,50809,50809,50777,50777,50776,50809,50809,50776,50777,27535,10696,12809,14922,19115,19083,17002,17002,14889,14889,14889,17002,23276,23243,25356,23308,23275,19082,17002,17002,17002,17002,16970,14857,14889,12809,12777,12809,12809,12809,12809,12776,12809,12777,12809,12809,10728,12777,12777,12776,12776,12776,10696,12776,12776,12776,12776,12776,12744,12776,12808,12776,14889,14856,12776,12776,12776,12744,12776,14856,12776,12776,12776,12744,12744,10695,10663,10663,10696,10695,17001,16968,16935,25355,33742,25258,25226,27371,23113,12647,10663,29679,35953,10663,10695,8550,8550,6470,6470,6470,12711,37967,27466,25321,33739,48465,46352,48465,46352,48465,35853,21096,31629,37999,35918,37966,46384,48465,44304,48531,31693,16936,16935,19080,16935,35821,42160,37770,43944,33576,23208,37965,44239,37933,37934,23177,21129,21161,19015,27497,21223,14885,8579,16966,14853,12742,8582,8550,8582,12711,35853,44207,44240,25289,23210,23242,16968,8517,8550,8550,8517,6469,10662,12743,14855,19016,25387,29548,19049,14855,21194,19049,14823,21129,25323,23274,16903,14823,6436,4323,10596,33773,42192,48563,50676,52821,50644,44305,21096,8550,8550,8550,8517,23274,35854,37999,38031,35854,31628,16934,14853,14853,43},
{52889,52857,50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50809,52890,50841,52890,50841,52890,52890,52890,52890,52889,52889,52857,52857,52889,54937,52889,52857,52889,52889,50777,52889,52857,52857,52857,52857,50809,50809,50809,50777,50809,52857,52857,29647,10696,10761,12842,14922,17035,19115,17002,16970,14889,12777,14889,14889,16970,16937,16969,16969,16970,16969,16969,14889,16969,14889,14889,12809,12809,12776,10696,10728,10696,12776,10696,12776,12809,10696,10728,12777,10696,10696,12777,10696,10696,12776,12777,12808,12808,14857,14889,14857,12776,14889,12809,12776,16969,14856,12744,12776,12744,12776,14889,16937,19050,16969,14857,14889,14857,10695,10663,10696,10696,10696,12743,17000,25355,27468,35855,25258,27306,25226,21033,10599,10631,27534,33873,12744,12776,8583,8583,8550,8550,8550,14856,25355,29482,31691,33706,50577,48432,50545,48433,46384,35820,25355,33839,38031,37999,37966,40111,50709,52757,48564,27436,27435,29580,25386,29580,37999,40047,39915,46123,35755,35821,44240,42158,35820,29483,31595,21064,19016,18951,29515,31691,21158,14885,14853,12773,14854,29580,25323,16904,10630,21063,48498,46418,25290,21129,21129,23242,23210,16936,10598,8550,6437,10630,12710,19048,29613,29548,27500,16936,21194,29580,29548,25387,23241,21161,12774,6436,4323,4323,6468,6404,8484,29548,27402,25322,29483,29547,42225,29580,12710,8550,8550,8517,29548,40079,31627,27435,27402,27402,14822,19047,16934,63},
{52890,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50841,50809,52890,52890,52890,50809,52922,52922,52890,52890,52889,52857,52889,52889,52889,52857,52857,52889,50809,52857,52889,52857,52857,50777,50809,50777,50744,50776,50809,52857,29680,10697,10729,10761,12810,14922,16970,14890,19083,19083,19083,17035,14922,16970,19050,16970,17002,16970,16969,16970,17002,16970,17002,17002,16970,12809,14889,14857,12809,12841,12809,12809,12809,12776,12809,12808,12809,12809,10728,12776,12776,12776,12776,12777,12809,14857,14921,16970,17002,16970,14889,12776,12776,12776,14857,12808,12776,12776,12776,12744,12808,16969,19050,16969,14856,14856,14856,14856,14856,12776,10696,10696,10663,12775,29613,25355,35887,25258,27339,23145,21033,10598,8551,25422,33841,10663,12776,10663,10663,8583,6502,8583,16968,16903,27305,29385,35852,31626,46351,50545,42094,42158,29514,19016,33774,35854,35886,25321,27402,37935,40080,31629,10597,8484,16967,16966,21127,37998,37901,44043,46254,33675,40047,42160,37933,33676,18918,33708,29515,33741,35918,40080,29515,23239,21159,16966,12741,12741,21193,40112,37934,35918,35853,48497,44272,25289,23242,19049,19017,25355,27468,27468,23209,21128,29515,31595,33708,31629,29580,29613,25355,29581,27468,23242,23209,23241,16967,8548,6404,6468,6403,8516,6436,2211,4291,4259,2210,2178,14791,35886,27402,33773,33774,29581,16871,21097,31661,29515,29516,29515,27435,14823,21161,16934,51},
{52889,52890,52890,50809,50777,50809,50810,50809,50809,50809,50809,50809,52890,50809,50841,52890,52890,52890,50809,52890,50841,50841,52889,52890,52890,52857,52889,52857,52857,50809,52857,52857,52857,52857,50777,50777,52857,52857,50809,50809,50809,50777,50777,48728,48696,29680,10696,10729,10729,10729,12809,14922,19083,17035,19083,17003,19083,17035,14889,12809,19082,19082,19115,17002,16970,16970,16969,16969,17002,17002,14921,12809,12809,12776,12809,12809,12809,12809,12776,12776,12776,12776,12776,12809,12776,12776,12776,12776,12776,12777,12808,14857,14889,14921,14921,14857,12777,12809,12776,10696,12776,12808,12744,12777,12776,10696,12776,14889,19050,16937,14889,14856,12808,12776,12808,12776,10695,10695,10663,10663,31694,27436,35855,27306,25226,23145,21065,14759,8518,23341,33906,12743,12776,10663,8583,8583,8550,8583,21161,16967,25159,27208,29547,18982,39981,48497,48532,44207,21159,21161,35854,35854,35854,33707,33676,31563,29450,16935,6437,4356,4356,10661,21159,40111,39982,44140,42126,40014,42160,40079,42127,37870,44241,40047,31595,31563,35821,35821,33709,29515,21127,31692,35854,35886,14855,21097,40079,46417,50709,54903,54870,27402,21129,12743,6437,8517,12743,33806,37967,42257,50676,52723,44206,27434,29580,29580,19049,16969,14888,14823,25354,25386,12774,10629,8516,6468,6404,6404,6404,2243,4291,2211,2210,2178,16903,40014,46385,48497,44272,37934,21096,16904,29516,29515,27467,29516,25322,14823,27435,21096,51},
{52890,52890,50841,50842,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52890,50841,52890,50841,50841,50841,52890,52889,52857,50809,50809,52889,52889,50809,50809,52857,52889,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,42389,23341,10696,10761,10729,10761,10729,12842,14890,19083,17035,19083,17003,17002,17035,14922,14922,16970,16970,16970,14890,14889,12809,14921,14889,16969,16969,14889,14857,12809,12809,12809,12809,12776,12777,12809,10696,10728,12776,12776,14857,12777,12776,12809,12776,12776,12776,12776,14889,14857,12776,12776,12776,12744,12776,12776,12744,12744,12776,10696,10696,10696,10663,12744,12776,14824,12776,12744,10695,12743,10695,10663,10663,10663,10696,10663,14856,37968,25355,23211,25226,25226,23145,21033,14759,8550,23276,38034,14857,10695,8550,8551,8551,8583,8550,17000,21160,29320,29353,25289,27466,52692,50578,52757,42192,21159,23242,33774,33773,37934,46352,48498,48498,37934,14855,4356,6437,4324,4291,16903,40080,35756,48367,40014,31595,35788,37934,42192,46419,48499,25191,42126,52658,44240,40047,37967,25354,10662,19047,21127,19048,12743,21162,29547,42224,48499,40047,31660,25322,25322,23242,8550,8582,8517,21162,35918,44304,50643,48498,44240,40046,33773,27532,21162,14856,14856,14855,23240,14854,10661,8548,8548,10629,6404,4323,4291,2211,6436,4291,4291,2210,10597,23209,29547,35821,29482,29515,21096,19049,25355,25290,25290,27403,21097,21129,29547,31628,78},
{52890,52890,52890,50809,50809,50809,50777,50809,50777,50809,50809,50841,50841,50841,52890,50809,52890,50809,52890,52890,52890,52857,52889,52889,52889,52889,52857,50809,52857,52857,50809,52857,52857,52889,50809,50777,50809,50809,50809,52857,50809,50777,50809,29745,10696,10729,10761,10697,10729,10729,12809,16970,19115,17035,19083,17035,16970,17002,17002,17035,17002,17002,17003,17002,14922,12808,16970,17002,19082,19082,19082,14889,14889,12809,12841,12809,12809,12809,12809,12777,12776,12809,12809,12809,12776,12809,12776,12776,12809,12809,12808,14889,14857,14857,12776,12809,12809,12809,12809,12776,12777,12776,12776,14857,12776,10696,12744,16937,19017,14856,12808,12776,12776,12744,10696,10696,8583,12776,16904,21098,35888,21162,14824,23178,23113,23113,23113,16839,10598,23275,40211,16969,10695,6470,6470,6502,6502,6470,16968,27434,31530,23176,12710,25289,44271,46319,48465,31659,10628,23242,33741,33773,31628,33708,46450,50644,25322,8517,6436,4356,4324,4324,21129,40080,40015,44208,33708,27337,35789,40080,37967,50612,46419,42095,50577,37836,42192,40079,40112,23209,8550,12775,14887,10662,10630,23242,42225,42224,25289,8517,10630,21097,23209,25355,10630,16969,19017,16903,27435,35756,37901,35755,29515,25289,18983,19049,19082,14856,14856,16936,23240,14821,10628,6436,6436,6435,6403,4291,2211,4323,8517,2211,2211,4291,6403,2178,6371,27435,29548,29548,23209,14823,25322,31627,35821,37999,35822,27435,27402,33773,151},
{52922,52890,52890,50809,50777,50809,50777,50809,50809,50809,50809,52890,52890,52890,50841,50841,50841,52890,50809,50841,52890,52890,52857,52857,52857,52890,52857,52889,52890,52890,50809,50809,52857,52857,50809,50809,50809,50809,50809,50809,52857,50777,40212,10696,10729,10761,10761,10697,8649,8649,12809,16970,21196,19115,17002,17003,14922,17002,14922,17002,17002,17002,17035,16970,14922,14889,14857,12809,14857,14889,12809,12809,12841,12809,12809,12777,12809,12809,12777,12776,12776,12777,12776,12809,12776,12776,12776,12776,12776,12809,12808,14857,12809,14857,12776,12809,12777,14857,12776,12776,12808,12776,12776,12809,12776,10696,10696,12776,16937,12776,10695,12743,12744,12776,12744,12744,10663,21130,33774,25323,25356,21163,16937,18920,18887,18920,21033,18952,10598,25388,42259,14824,10663,8550,6470,8550,8550,18985,25258,23242,33642,23176,8549,21062,46351,42094,39949,37965,21159,21161,31661,33741,25257,21064,23208,25289,14791,8517,4356,2244,4292,6404,25355,33742,35789,44240,33741,27370,35821,35853,33676,31530,42095,59130,40112,25289,42257,40079,42192,35886,27435,16968,10663,10662,10663,10663,23274,33774,8517,6437,12743,29548,29548,14856,8517,10662,29581,33774,37966,46320,40014,31563,18983,14790,10662,16968,19082,14888,14888,14856,19079,19046,16933,10628,8516,6403,10628,6403,4291,4291,4291,2211,2211,6436,14886,10629,8452,27435,29548,29515,25322,14790,21128,35854,37934,37999,37934,29515,27435,31692,95},
{52889,50809,50809,50777,50777,50777,50777,50809,50809,50809,50841,50809,50809,52890,50841,50841,50809,50809,50809,52890,52890,52890,52889,52889,52857,50809,52857,52889,52889,52889,50809,50809,50809,52857,50809,50809,50809,50809,50809,50809,50809,50776,48631,29583,19083,10729,8616,8649,8649,10729,12810,12809,12776,21195,23276,19082,17002,17002,16970,19050,19083,17002,19083,16970,16969,17002,16970,14889,14922,14889,14857,14889,12809,12776,12776,12776,14889,12777,12809,12776,12777,12776,12808,16969,16937,16969,16937,16969,16970,14857,12776,12776,12776,12776,12776,14857,16969,16969,14856,16937,16969,14889,12744,14856,14856,14856,14856,12808,12776,12743,12743,14824,14857,12776,12744,10663,8583,16937,33742,25323,25324,23243,21130,18985,16774,14694,16774,16839,14759,25421,40211,12743,8582,6502,6470,6502,8550,12711,16904,19081,27369,27434,12742,27400,58864,48334,44076,40045,21159,19047,29548,33708,42159,44240,42159,40046,23242,8550,6437,4324,2243,8484,29548,27371,31563,40079,35853,27402,25289,25225,25289,42127,46385,50611,27435,23209,42193,37966,44337,44337,42224,33806,10598,10663,14856,12743,19048,31628,14823,12711,16935,31660,35886,25355,12743,10597,12742,33773,42159,29483,21097,10597,4356,6437,6437,4357,10663,14921,16969,21162,25386,23239,16933,14885,14822,8548,14886,10629,6403,4291,4323,4291,4259,6404,19079,12709,6339,27402,29548,29548,25354,14789,16935,29548,29515,27467,27435,29515,29515,33773,144},
{52890,50809,50841,50809,50777,50777,50809,52890,50809,50809,50809,50809,50809,50841,52890,50809,50809,52890,52922,50841,52890,52890,52857,52857,50809,50809,52857,52857,52857,50809,50841,50777,50809,50809,50809,50809,50809,50809,52857,50809,50809,52857,52890,46518,40179,35953,25421,17002,8616,8616,12809,12809,10696,10696,23308,25388,29582,29549,31694,27436,27469,27469,25388,27437,27501,27436,27469,27436,25356,27469,27436,27436,27437,25388,25388,27436,25356,25356,25388,25356,27436,25356,23275,27436,27436,25355,27436,27436,25355,25323,23275,25355,25323,23242,25323,25355,23275,25355,25323,23242,25323,23210,21162,23275,23243,23243,23243,21162,21130,21162,21130,21130,21162,21129,21130,21130,19017,25290,33742,23243,23243,23211,23243,21033,12614,12614,16807,16807,12646,27469,40211,12776,12776,6502,6502,6502,6437,4389,8582,19081,19080,21160,16967,35786,50445,42030,48432,35852,14853,23208,29547,31628,35821,44304,48499,46353,16936,4356,6437,4292,8550,19049,33774,29516,40047,44240,37933,27370,27402,29515,42225,50579,50547,44272,21064,27435,40112,35854,42224,44305,44370,37999,16936,10630,21129,29548,35821,42127,44273,42192,25354,31660,33774,19048,29581,29548,23243,25355,25290,25290,21097,10695,8550,12776,10662,6437,10663,14888,16937,19081,16936,21127,16966,14821,14821,10628,12708,16966,8580,4355,4355,6404,6371,8549,14821,10629,6371,27435,29548,29548,25322,10629,16902,29548,29515,29548,29515,29515,29515,29515,66},
{52890,50809,52890,50809,50777,50809,50777,50809,50809,52890,52890,50809,50809,50809,50809,50809,50841,52890,52890,52890,52890,52890,52857,52857,52857,52857,52889,52889,52857,50809,50809,50809,50809,50809,50809,50777,50809,50809,50809,50809,50809,52857,52922,42293,33872,42259,42291,42260,33840,25389,19083,16970,16969,16937,14889,14857,23340,25356,23243,14856,14889,14889,12809,14889,16969,14857,14889,14889,14857,16937,14889,14888,16969,16937,16969,17002,16969,16969,17002,14889,17002,17002,14889,17001,16969,16936,19050,19050,19017,19017,16969,19049,19082,19050,19082,19082,16969,21162,21130,19049,21162,21130,19050,21162,21130,19049,21163,21130,21130,21162,21130,21129,23242,21130,21162,21162,21130,33710,31661,23275,23275,21163,23210,18952,16775,14694,16774,16807,12646,27501,42292,16937,10663,6502,6470,6470,6437,4389,14888,25419,25385,23305,12773,35820,46320,42095,50545,42126,19014,27433,42160,33774,27436,31596,31661,31661,19049,14856,14888,12743,14857,16905,27436,31595,42094,40014,35821,27370,29515,40079,25257,33643,42094,37933,19016,31660,37934,37934,42192,42192,44337,44272,42192,33806,27435,33740,42159,46352,42127,33708,25290,31660,31661,23209,31629,29548,23274,23274,25322,29548,31660,10630,8518,12743,10630,6437,10630,14856,14888,12743,10662,23208,16933,19079,19047,16966,16902,19078,14853,10660,8516,10629,16935,10629,16934,12709,2178,23209,29515,29547,21128,8516,14790,29515,29515,29548,29515,29515,29515,27435,62},
{52890,50809,50841,50809,50777,50809,50809,50809,50809,52890,52890,52857,52858,50809,52890,50809,52890,52922,52890,52890,52890,52889,52889,52889,52890,52857,52889,52890,52857,50809,50809,50809,50777,50777,50777,50809,50809,50809,50809,50777,50777,50809,42358,36018,38098,42259,40178,42259,42227,42259,44307,40113,35887,29581,19083,10696,10696,10664,10696,8616,8648,8616,8615,8648,8616,8616,8648,8616,8616,8615,8615,8616,10696,8615,10696,8616,8615,8615,8615,8583,8616,8616,8583,8583,8583,8583,8616,10696,8615,8583,8583,8615,10664,8615,8615,8615,8615,10663,8615,8615,8615,8615,8583,10663,8583,8583,10663,8615,8583,8583,8583,8583,8583,8550,8583,8615,8583,16937,31694,23243,25324,23243,25388,21097,16742,16775,18888,16807,12646,27501,42324,19082,10663,6470,6502,6469,6437,4389,10663,23273,25384,23272,21127,40013,44271,44271,48464,35885,16902,37966,59163,44242,27469,21162,21130,19017,19081,16936,19050,17001,12744,14824,12710,25322,42159,40047,37935,25289,31595,37901,21032,27338,42126,33708,21064,42224,44337,46418,42159,42159,46450,31692,21095,35886,37999,42224,31628,31596,29515,29515,33773,42193,35887,29548,31628,29548,19015,6435,2178,14822,37967,33774,25387,16968,12710,8517,8550,14856,19049,27500,25387,25322,27466,25353,19046,19079,16934,14821,19079,19047,14853,14821,23273,16934,14854,6403,2146,21096,29547,29515,23240,14757,18983,29548,27467,27467,29515,29548,31628,23209,56},
{52890,50809,50809,50809,50777,50809,50810,50809,52889,52889,52889,52889,52890,52890,52890,52889,52889,52890,52889,52889,52857,52857,52889,52889,52857,50809,52857,52857,52890,50809,50841,50809,50809,50809,50809,42357,42357,48663,46551,44470,46518,46583,33873,38098,46517,48598,42291,42259,40178,42259,44371,40081,19050,10696,10664,12777,12809,12809,12777,12777,12809,12777,10728,12776,12809,12776,12777,10728,10728,10696,10696,10696,10696,10696,10696,10728,10696,10696,10696,8615,10696,8616,8616,10696,10696,12776,10696,10696,10696,10663,10664,10696,10728,10696,10663,10663,10696,10663,12809,10696,10663,10663,10663,10663,10663,10663,10663,8615,8583,10663,8583,8583,8583,8583,8583,8615,8583,19017,31661,21162,23243,23275,21162,23178,14662,14662,16775,16807,12646,27501,44372,16936,10630,6470,8582,8582,8614,12775,12743,27467,31692,27466,25322,42127,48497,50545,48464,31626,25287,46419,61309,46356,29550,25356,23275,23275,23275,21195,21163,19114,14856,16969,12743,25322,42095,39982,44241,29515,42160,42160,21064,27370,33708,16805,16838,37999,44304,42192,42191,44272,37998,14852,10628,33805,46418,44338,31628,29483,29515,27370,16903,27500,23307,19049,23274,16903,12774,8548,4323,29612,40112,40112,40112,40080,35919,31693,23242,16936,25355,33774,31629,27467,29483,27402,16935,8549,8549,12709,19047,21191,21127,14822,16902,19079,12709,6404,4323,21096,29580,27434,33740,35886,42193,31660,27467,29515,29515,29515,31660,40079,152},
{52890,50809,50841,50809,50777,50809,50809,50809,52890,52889,52889,52857,52889,54970,52890,52889,52889,52889,52890,52889,52857,52889,52889,52857,52890,50809,52890,52857,50809,52857,50841,50809,50809,50809,50841,44438,42357,48631,46583,46550,46582,48631,44437,44436,46517,46485,44372,42259,40178,42226,44371,35920,10631,10663,14921,21228,19050,16969,14889,16937,16969,16969,16969,16937,16937,16970,14889,14889,14889,12808,12809,12776,12776,12744,12776,12776,12777,10696,12744,10696,10696,10696,12776,12776,14856,16937,16937,14857,16905,14856,14824,14824,12744,12776,12776,12776,14889,14824,17002,14857,12776,12744,12743,12776,12776,12744,12744,10663,10663,12744,12744,12744,12776,12776,8582,8583,8583,19017,31694,21162,23243,25356,19049,25258,14630,12581,12582,12582,12646,29581,46517,25355,19049,19050,14824,14888,12775,19081,12742,21097,23242,27466,23175,46386,54869,48464,48465,42159,42127,50645,59195,44308,27469,19049,23210,21130,21162,19049,21130,21130,23210,25387,25323,33741,46385,37902,42159,29482,33709,33709,31596,37934,25224,14661,12678,19049,40144,42192,42192,46418,25322,12774,12806,25354,40112,35886,25322,29515,27402,27435,16904,10630,8517,8550,14855,6436,10661,12773,6468,14790,33806,40144,40079,40079,40079,40111,35919,19016,25387,27435,29516,31628,29548,31661,25354,16903,10629,14822,14789,16902,16934,12709,12709,12677,10629,6436,6404,19016,29547,23208,25288,25352,23240,27467,29548,29548,29515,29515,27403,16936,68},
{52890,50841,50809,50809,50809,50809,50809,50809,52889,54969,54969,54937,54937,54937,52889,52889,52889,52889,54970,52889,52857,52889,52889,50809,50809,50809,50809,52857,52857,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50744,50744,50776,48631,42292,38066,44437,40179,38131,40179,40146,44306,35887,23243,29647,35953,38065,40081,37967,40080,37967,37968,38000,38000,38000,35920,35887,35888,33807,33807,35887,35888,33774,33775,31694,31694,33774,31662,31629,31661,29516,29581,31661,29516,31629,31661,29516,31629,31629,29549,31596,29548,29483,29548,29516,29516,29548,27435,27468,29549,27404,27436,27436,27403,27435,27403,25323,25355,25323,25323,25323,25290,23274,25355,25290,21161,25322,23242,27436,31630,21195,23275,25388,19049,23145,14630,14663,14662,12582,14727,31661,46484,23242,12775,12744,8551,10663,8582,10663,8550,14824,21194,29579,23175,48498,52723,48432,31626,18982,40080,48499,59130,46388,29582,21194,23210,19049,21130,19082,19082,21162,16936,19081,16903,33773,42192,35853,44304,29450,29482,37966,35821,42095,35820,16773,12678,10630,27467,42224,40079,35854,12743,8582,6468,10629,37934,40047,29548,27402,27403,29548,14791,6469,6470,8550,8581,4323,6436,10693,8580,6468,12709,35918,35918,31660,40112,38031,29580,16936,17001,16968,27467,44338,31693,42225,44370,44305,40079,33773,40112,42225,40079,40015,40046,33741,14791,12710,14823,23274,25354,25321,19014,21127,19046,27402,29516,29515,29515,29516,21129,8517,42},
{52922,52922,50809,50809,50809,50809,50809,50809,52890,54970,54970,54937,54969,54937,54937,54969,54937,54970,54937,54937,52857,52889,52890,50809,50809,50809,50809,52857,52857,50809,50809,50809,50809,50841,50809,50809,52889,50809,50809,50809,50809,52857,50809,48631,44372,38098,29647,31825,40276,42259,44306,42193,38033,38065,40113,38033,44306,44306,46386,42225,44338,44338,42226,42226,44306,40080,38000,37967,35855,37967,37967,35855,37968,35855,35822,37935,35822,35822,35854,33709,33742,33806,31661,35822,33774,31628,33773,35854,33741,35854,35854,31660,35886,35822,33741,35886,33741,33741,35855,33710,33774,35887,33741,35822,37934,33709,35822,35822,33709,37903,35790,33709,35821,33741,31660,35821,35854,40080,27468,21163,23275,25388,19049,23145,12549,14630,14630,14662,18887,33774,48597,21194,10695,8550,8550,8583,8551,8550,6470,10695,21162,29580,21095,46351,50577,46319,29513,19015,37966,48499,59163,44307,29582,23275,21162,19049,21162,19049,19050,16969,12743,16969,14824,33774,37966,33708,44272,29450,31595,37966,29515,31530,44239,31562,12677,10631,12743,35918,27401,21096,12743,10661,8581,10629,35821,42127,29483,27403,29516,31628,23210,16936,10663,10630,10662,4323,6436,10661,8612,8580,6468,14822,16968,12710,25354,23242,14822,16936,16969,16936,19081,31693,37999,44337,44305,44337,44305,48531,52724,50643,54837,52756,54804,31629,14791,12743,14823,21161,25322,27402,23208,18982,16934,27434,29515,29516,27435,29515,16904,10630,48},
{52890,50841,50809,50809,50809,50841,50809,50809,50809,54937,54937,54969,54969,54970,54969,54937,54937,54969,54969,54937,52889,52889,52857,50809,52857,52890,52890,52890,52857,50809,50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,50776,46517,38066,29647,33971,38163,40243,44339,37999,31693,31726,33775,33808,31726,29548,46386,37967,37999,37999,37967,35887,37967,37967,35887,33806,31661,33774,33742,31661,33742,31661,31629,33742,31629,31629,31629,29516,29516,29581,27468,29548,31629,29483,29548,31629,27435,31629,29548,27435,29548,29516,29516,31628,27435,27403,29517,27436,27403,29516,27403,29483,29548,25323,27435,29516,27402,29516,29483,25322,29483,27435,25322,29515,33709,35822,27436,21130,23243,25323,19049,25194,12549,14630,12549,14662,18920,33774,44404,25420,10695,10663,8583,8583,8551,8550,6470,12776,21194,25387,29515,44207,46320,48466,37967,14823,37933,48531,57082,38033,29614,27468,25355,25356,25355,25323,23275,21163,14888,21162,27435,37967,42193,40080,44273,31564,27402,23209,18983,33708,44207,42159,27369,19017,12743,21128,29579,31693,37967,21128,12741,14886,23241,23241,25322,29516,29548,31629,18984,19049,29581,37934,29515,6436,6436,8516,8580,10660,10661,8549,6437,8550,16968,12742,19081,17001,16969,16969,19049,16903,40111,44337,44305,44337,44305,46418,46418,46418,52691,52724,44273,14790,21129,18984,21129,16936,25387,27434,27435,21160,19014,25354,31628,25354,23177,27403,23241,23209,85},
{52889,50809,50809,50841,50809,50809,50809,50777,52889,52890,54970,54937,54937,54969,54970,54937,54937,52889,54969,52889,52857,52889,52889,50809,52889,52890,52857,52857,52890,50809,50777,50809,50809,50809,50809,50809,52857,50809,50809,50777,50809,50809,50809,50809,52857,44404,38065,36051,38196,44437,44468,44372,35920,35953,31662,29582,21130,14790,46354,35887,33774,35854,33806,33774,33774,35855,35887,35855,31694,33774,33742,31661,33742,31694,29549,31661,31629,31629,31661,27468,27468,29581,27436,29516,31629,29484,29516,29548,27435,29548,29548,27435,29548,31596,29516,31597,29548,27403,31629,29549,27403,29516,27403,27371,29548,27403,27403,29516,27435,27403,29516,27370,27435,29516,27370,29451,33741,35789,27436,21162,25323,25356,19049,25194,14597,14629,14597,16677,20967,33775,46517,25388,10630,10663,8583,8583,8550,14856,25226,25258,25388,16935,23177,41964,35723,42193,19049,12711,35853,52758,54936,35855,29614,23275,23210,25355,21130,21162,19049,16969,10630,19049,29548,38000,38000,40080,44305,29450,25290,27370,31629,42126,42126,42158,40013,35788,40112,33773,31628,29580,23241,19081,6436,4387,4291,8484,27435,29548,27435,29516,19049,8517,19016,35854,27466,8580,6468,8548,8548,10661,12774,10629,10630,12775,12742,8516,6404,12775,19049,19049,14856,23210,44337,44337,44337,44305,40079,37868,46352,46352,44239,44239,42159,33805,37967,42160,35854,14790,27467,29548,31628,23241,14853,23241,27435,37967,40080,40111,42192,29547,78},
{52890,52889,50809,52890,52890,50809,50841,50809,50809,50842,52889,50809,52889,52889,54970,54970,54937,54937,54937,54937,52889,52857,50809,50809,50809,52857,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,52857,52857,52857,52890,50777,38098,35985,31857,38164,42324,42356,44404,40179,40146,38000,35952,38032,35919,46354,40080,40080,40080,38000,40080,40081,33806,33774,33774,33742,33774,33742,31661,31661,29581,29516,31661,31629,29516,31629,27468,27468,29581,27468,27436,29548,27436,29516,29548,27435,29483,31629,27435,29548,31629,31596,29548,31596,27402,31662,33710,27403,29515,27435,27403,29516,27468,27403,29548,27435,27370,29516,27403,27402,29516,27370,27403,35854,35821,27436,21162,23275,25324,21130,27209,20676,20741,20741,20741,25063,35920,46485,23243,10631,8583,8583,10631,8551,10663,12710,23210,21161,19016,31595,42062,44273,31596,12711,12743,37967,57082,50678,46452,38001,27502,27469,27501,27501,27469,25389,23243,14889,21130,31661,35919,31596,33676,46386,29515,27402,37934,40015,42158,42158,42126,42126,39981,40046,29580,8516,8516,6404,6436,4324,2275,4324,14790,27435,29516,29515,16968,8518,6469,6470,8517,8580,10661,8580,8581,6468,8516,23241,31660,33773,23241,12774,6436,4355,14856,19049,16936,12742,33806,44337,44304,44337,44304,44337,48531,48531,52789,50643,50611,44337,46417,44337,44305,40112,33741,35853,40079,40080,27435,14854,23209,29548,29516,29515,18983,23209,14823,37},
{52890,52857,50809,50841,50809,50809,52890,50809,50809,50809,52890,52890,50809,50809,52890,52890,54969,54937,52889,52889,52889,52857,52857,52890,52857,52889,52890,52890,52857,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52890,50809,52889,50776,48663,46550,48631,38196,38163,44437,44436,44468,44469,44469,44436,42324,44339,42193,44306,42160,42193,42193,42193,40113,42226,38032,35920,35919,35887,37968,35887,33774,33774,33774,31693,35855,35855,33710,33774,31661,31628,33742,31629,29548,33742,31629,31629,33742,31597,31564,33742,31629,31597,33709,31532,31564,33677,29483,31629,31597,29451,29515,31596,29451,29548,29516,27402,29515,29515,27402,29516,29483,27370,29516,29483,29482,37934,33740,27435,21130,23275,23243,21130,31272,26820,26852,26820,26884,29191,35887,48598,25388,10663,8583,8583,8615,8583,8583,6470,23242,19016,10597,33675,48400,54773,35854,27436,25356,38001,57082,52791,44339,23178,19050,23243,25389,25389,25389,25356,23276,14857,21163,31693,37967,35854,35854,46386,31595,29450,37869,37933,44239,42158,42126,42126,33707,12677,8516,8549,4355,6436,4355,6436,4356,4324,14823,29516,29516,27467,10630,8550,21162,14823,10630,8548,8612,8613,8548,6500,8548,14854,37966,40079,25322,12741,8581,6468,14856,19082,25388,25387,42257,44337,44305,44337,44272,48498,52692,50643,52756,50611,46450,44305,40079,35853,31660,42224,46450,42192,25321,23177,16903,14822,19048,29548,29516,27435,12743,12743,8550,40},
{52857,52857,50809,50809,50809,50809,52890,52890,50841,50841,50809,50841,50841,52890,52890,52889,52889,52889,52857,52889,52890,52889,52857,52890,52857,52857,52857,50809,50809,52890,50809,50809,50841,50809,50809,50809,52857,52857,50809,52857,52857,52857,52857,42324,42324,46550,46550,40276,38163,42356,42356,42356,42356,42356,42356,42357,42292,40211,44372,42291,42291,42291,42323,40178,42291,40211,40211,40179,38066,35985,35985,33872,33873,35953,33840,35953,33872,33808,33840,33840,33807,33840,33839,33807,33840,33807,31727,33839,33775,33774,33808,33775,31694,35887,42160,42192,44338,44306,42193,42161,42193,42193,44273,42160,40080,38000,40112,37999,35854,42094,37934,35822,33709,35821,37870,33741,40047,31628,25355,21130,23275,23243,25258,33223,32931,32995,32963,32995,33351,35887,50679,27437,10663,8583,8583,8583,8583,8583,8550,23274,21160,12806,31627,44239,48464,50644,40080,29581,38001,54936,57016,48501,21129,16936,19082,21162,25388,19050,23243,16970,10631,16969,21130,29549,29483,35821,46451,35789,35821,42128,40014,42159,42126,42126,37933,14789,6435,8581,6500,8580,8612,10693,10661,6436,6469,12743,27435,27435,21097,10566,16936,35887,29580,23274,14887,8548,6468,8548,6468,8581,10629,29580,44338,29547,10661,8613,8581,14823,19049,31726,37999,40111,44337,44305,44304,46417,48531,52724,52756,52756,50611,35853,31628,29515,27435,29547,31660,42192,44305,33708,35854,33741,18983,19016,29515,29516,23241,10630,10630,8582,39},
{52889,52890,50809,50809,50809,52890,50809,50809,50809,50809,52890,50841,50841,50809,50809,50809,52890,52890,52889,52889,52889,52889,52857,52889,50809,52857,52857,52857,50809,50809,50809,50809,50809,50809,50777,52857,52857,52857,50809,50809,50809,52857,52889,48696,48663,50744,50744,40277,38163,44437,44437,42388,42324,42356,42356,44469,42389,42356,44437,42388,42389,42356,42389,40276,42357,38164,38164,33970,33970,31793,33938,27632,29745,29744,27599,27632,27599,27599,27599,29648,29647,27567,25486,25486,25486,25454,25454,25422,25421,25389,25389,25389,23308,25388,42193,48564,50710,50678,48597,46451,48597,50677,50677,48629,46484,44339,50678,42194,33742,52692,40015,35757,35757,35757,33709,25321,23241,27434,25355,21130,23275,25324,27371,35173,39139,37091,37091,39171,39657,38000,52792,27469,10663,8582,8550,8583,6470,8583,16969,23241,19079,12774,29547,44239,50578,50677,44306,33742,42194,52790,46386,46387,21129,14856,21162,27501,27534,25389,25356,21163,14824,12743,12744,14857,18919,33709,42225,31595,31628,40015,31595,33708,42159,40046,31660,16934,14884,14917,12805,16998,16966,12773,19079,12742,6405,12743,29516,29548,25322,29548,31693,35854,33806,16903,6404,6468,6468,6468,6437,6469,6437,10597,35854,33806,16934,10660,14854,23275,27468,29612,33741,23209,29548,44338,44337,52789,50676,52757,54870,54869,48498,31628,29548,29548,29548,29548,29547,27434,40079,33708,35853,33741,21129,23242,25354,21096,21097,12743,10662,10630,38},
{52890,52890,50809,50809,50809,50809,50809,50809,50841,50809,50841,50841,50841,50809,50809,52890,50809,52857,52889,52857,52889,52889,52889,52889,52857,50809,52857,52890,52890,50809,50809,50809,50809,50809,50809,52858,50809,52857,52857,52857,50809,52889,52857,52857,52857,50809,52890,40277,38131,42356,42356,42356,42324,40276,42324,42356,42356,42324,42324,40243,42323,42324,42356,38163,38196,38164,36051,33938,31857,31825,33906,27600,27632,27632,25487,27567,25487,27600,27567,25486,27534,25486,25454,25454,25422,25422,25454,25422,23341,23341,23341,23341,23276,21195,37968,48564,48630,48630,48597,42291,46516,48565,48597,48597,48565,46484,48565,40081,31629,48530,37902,33709,33709,35757,31628,23241,19080,25386,27468,23243,25388,27436,29451,39301,41218,41218,41251,41315,41802,38000,50679,29549,10630,8582,8550,8583,8550,8582,10662,21161,19048,10629,31661,52789,46352,35854,40080,35822,46387,48500,35854,31629,21162,19017,21162,25388,27469,25389,23276,21163,21131,21195,14889,16970,16774,27338,42160,33676,29450,35756,33708,23176,40046,35788,27369,23240,19110,14852,19078,16933,23240,27434,31595,31595,23210,21129,27403,33708,35789,29548,25322,37999,29547,8580,6469,23242,19081,8549,6437,6405,8517,12678,12645,23209,21128,12774,10660,21161,27468,27467,21097,10598,8549,29580,42225,42160,42192,44305,40079,44272,44337,33741,29516,29515,29548,29547,29548,25289,29548,25354,29515,29548,21129,21161,44305,31595,35854,19016,8550,8550,35},
{52890,52890,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50809,50841,50809,52890,50809,50809,52889,52857,52889,52889,52889,52857,52857,52857,52890,52890,52857,50809,50809,50809,50809,50809,50809,50777,50809,52889,52889,50809,52857,52857,50809,50809,50809,52889,52890,40309,40244,42388,42356,44437,44437,42388,44437,42388,42357,42356,44437,42356,42356,42356,42389,40243,40277,38132,36051,36051,33938,31825,33938,29713,29712,31792,27631,27632,29680,29680,27567,25486,25486,27535,25486,27567,27567,25486,25454,27534,25454,25454,25421,25421,23308,23276,25421,31694,31694,29581,42226,38033,38033,35887,35920,35887,38001,38065,40146,37968,37934,50578,37902,35789,33709,31661,27499,25385,21192,25386,27468,23275,25355,25388,25128,41219,43234,43234,43331,43427,37674,42194,52824,33775,16904,8582,8550,8583,6470,10663,27468,27499,29580,29548,44338,54838,35821,25290,35854,23242,25322,40080,37966,25322,21130,21130,23243,27501,29582,29582,27502,27501,25356,27501,19083,17002,14694,23112,35853,31595,29450,40014,37966,23144,27370,31563,23209,25289,21127,19046,19046,19047,25353,23209,35853,48498,46418,33741,35821,44304,46386,16968,10630,33806,23241,8548,10629,31726,31693,8517,6405,8518,12743,12710,12678,19016,21064,19015,12709,12742,19016,21129,12775,8550,10630,21129,33774,21064,21064,29547,16838,31628,46450,31660,27435,29548,29547,29548,29547,25321,25322,25290,29548,29515,21096,19016,40112,29547,35821,27403,12710,14855,59},
{52890,52890,50809,50809,50809,50809,50841,50841,52890,52890,50841,50809,52890,50841,50809,50841,50841,50809,52889,52889,52857,52889,52889,52857,52857,52890,52890,52857,50809,52857,50809,50809,50809,52857,50809,50809,52857,52857,50809,52857,52857,50809,52857,52889,52889,52857,52857,50777,50776,50776,50776,50744,50776,50744,50776,48696,50744,50776,50776,50744,50744,48664,44471,42422,42390,38197,36116,36084,36052,31891,29810,29778,31858,31858,31826,31858,33971,31858,31825,31793,29680,27567,21261,21294,21261,21228,21261,21293,21261,23341,21293,21261,21228,21228,23276,31694,25388,21130,40146,35889,31728,27469,27469,25389,25356,23308,25421,23275,35822,48466,35756,33677,33709,29548,23305,19112,12806,25354,25388,21163,23275,23275,29355,35270,35237,39463,50093,43786,37772,50678,48565,37968,25290,10662,8583,8550,10630,10630,23210,19048,14887,19048,37901,40046,25290,25323,31629,19049,16969,35822,42191,31628,21162,19049,21130,27469,25388,27501,25389,25388,21163,27469,19050,19082,16774,23112,40080,29483,27370,29418,27369,21032,29516,25257,25290,21064,12580,16870,25353,27467,27434,14823,14791,25322,31660,23175,37998,44272,25289,12710,6469,19048,16967,8548,8548,6468,6468,6437,10598,16936,10597,14856,21162,25355,33773,35886,16903,14823,21129,16968,10630,8614,10662,21097,27435,19016,21097,25322,12743,16903,38032,33741,27435,29548,29515,29547,29548,23177,14790,23209,29548,33741,27369,33773,40079,14823,14822,42225,40144,35886,116},
{52890,52890,52890,50841,50841,50809,50809,50809,50809,50841,50809,50809,52890,50841,52890,52890,52889,52857,52857,52889,52889,52889,52889,52857,52889,52889,50809,50809,50809,50809,50809,50809,50809,50777,52857,52857,52857,52857,52857,52857,52857,52857,52857,52857,52857,52889,50809,50809,50809,52889,50809,50809,52857,52857,52857,50809,50809,50809,52857,50809,52857,50777,44503,44503,42423,38230,36149,36117,36116,31923,27730,29778,31891,33971,31858,38131,36084,31890,29712,31793,33874,27567,14955,14987,14987,14955,14955,14987,14955,14988,14988,14987,14955,27534,31662,37967,31726,27468,37968,31727,31695,27501,25421,25389,25356,23308,25422,23243,33709,46321,33644,33644,33644,31629,21193,14919,10694,21161,25323,21130,23243,23243,23243,25323,25291,33710,54904,37903,31596,54904,48598,38032,33708,19049,8550,14856,27468,21130,21129,16935,16967,16935,35820,37965,21128,23243,29581,21130,12743,31628,44241,29548,21130,21162,21162,29614,29615,29615,29582,29615,27502,27470,23276,21163,14758,16838,31629,25258,29450,29483,27402,21065,27370,25257,25322,27402,29515,31661,31693,27435,23242,10598,8549,21128,27434,19014,37966,44304,42192,35854,25322,14854,8548,8580,6468,10629,16935,6437,16936,27468,14791,12710,16969,19017,25355,27402,25322,25355,25322,27468,19049,14823,10630,18983,21096,21096,21097,12743,10630,10630,21129,29548,29547,29547,29515,29515,29515,29580,29515,27435,29548,33773,35853,31660,37967,16936,27467,46450,46418,46418,176},
{52857,50809,50841,50809,50809,52890,52889,50809,50809,50809,50809,50809,50809,52890,52890,52890,52890,52857,52857,52857,52857,52857,52857,52889,52857,52857,52857,50809,50809,50809,50841,52857,50809,52857,52890,52889,50809,52857,50809,50809,50809,50809,52857,52857,52857,52857,50777,50809,52857,52857,50809,52857,50809,50809,52857,52857,50809,50809,50777,50809,52857,48696,44503,44503,40342,38229,36117,36117,36084,36084,27730,29778,31891,31890,33938,44405,38132,29777,27664,27600,46550,36019,14955,12907,14987,14955,14988,14955,14987,14987,14988,14988,14955,38034,44305,42128,42226,48597,42258,33775,31727,27502,27469,27501,27469,23308,25422,21163,35854,44208,33644,33676,33676,25322,21225,19112,12775,21194,25355,21163,23243,23243,23243,23276,23243,31694,52791,38032,35822,52791,48597,42258,33741,23210,21098,29516,31628,21065,23242,16935,12806,16935,40013,35820,16935,23275,40113,23275,16936,33676,44241,23210,21130,19049,19081,27501,27469,29582,25388,31695,25356,27502,21163,21163,16839,27403,33742,23145,29450,31595,40046,31596,25289,27370,27370,27402,27402,35854,44337,31661,14823,10630,16999,16966,29611,29547,37934,37966,23176,35854,42224,21127,8579,8580,8580,14854,29581,10598,6437,12743,19049,12742,8517,8517,21161,27402,23209,16903,31660,42225,40144,37999,33741,37934,42192,37934,16871,8550,10630,10630,16968,27468,29548,29580,33709,35854,37966,42224,48531,33773,29515,29515,27402,12709,25322,25354,40144,44369,44337,44305,184},
{52890,52857,50809,50841,50809,52890,50809,50809,50841,50809,50841,52890,50841,50809,50809,52857,52857,52890,52857,52857,52857,52857,52857,50809,52857,52889,50809,50809,50809,52890,50809,52857,52857,52857,52857,52857,50809,52857,50809,52857,52889,50809,52857,52889,50809,50809,52857,52857,50809,50777,50809,52857,52857,50809,50809,50777,50809,50777,50776,50809,50777,48696,44471,42423,40342,38197,36084,36084,34003,38229,29746,29778,29811,31891,36019,38131,38164,36019,31858,29680,44437,42357,17100,15020,14988,17068,17068,14988,14988,17068,15020,14987,12875,23341,31694,33774,42291,48598,42226,31695,31695,29549,27469,29549,29549,25388,25422,21196,27436,29484,29484,27404,27436,14888,21226,21226,17001,23274,25356,23243,25355,25356,25356,23276,23275,31694,54904,42226,40080,52823,50646,44306,35822,25355,27404,38000,35919,35887,37967,25354,19047,21095,44272,33772,21161,23243,31661,21130,16936,37934,46419,25323,21162,21129,21129,27501,25389,29582,25356,29614,25356,27502,19082,19114,18984,35887,40145,33741,33675,40013,40014,29482,33676,33675,31627,27402,21096,37999,42225,35886,12743,14823,21127,23239,29546,40079,37967,29515,12710,16936,35886,16965,10725,10692,10692,8580,6404,8550,4357,6405,4356,8550,12678,10630,21129,25322,16968,12742,35919,40080,40112,40112,44337,50643,48499,44305,35919,27500,21129,14791,16903,31693,37999,40079,37966,35821,31628,25289,42193,35886,29515,29548,27435,16903,21128,37999,46450,44337,44337,46418,175},
{52890,50809,50809,50809,52890,50809,50841,50809,50809,50809,50841,50809,50809,50809,50809,52890,52857,54937,52857,54937,52889,52857,52857,50809,52857,52889,52857,52889,50809,52890,50809,52857,52890,52857,52857,52857,52857,52857,50809,52857,52889,50809,52857,52857,50809,50809,52857,52857,50809,50809,50809,50809,52857,50809,50777,50777,50809,50809,50809,50809,50809,48729,44503,42423,40342,38197,36117,36084,36116,38165,29778,29778,29811,33971,38099,44372,40212,38099,31858,31825,29679,36018,23439,23407,23374,25422,25454,23406,23373,23374,23342,23374,23374,23309,27566,33839,40146,38065,40145,40145,46452,48597,48565,48533,48565,48565,29647,25389,33775,29549,29550,27469,25389,14954,21227,23339,21227,25387,23243,21195,23275,25356,25356,25356,23275,31661,52823,44338,46387,50678,52824,52758,29548,14856,19017,23243,12743,21194,33807,25322,25353,29578,46353,29514,27467,25323,40015,23274,18984,42192,48500,27436,23210,21130,21130,29614,31695,31695,27502,31663,27469,29550,21195,21163,14791,27403,46419,46418,44271,42126,31562,29450,25224,25257,21064,14791,21129,40144,40079,35853,31628,33773,27496,33739,37966,27433,31627,29515,12743,8517,21128,16901,8580,6467,12741,10662,14824,12743,6437,4357,4324,8485,25322,25387,25322,21161,8516,16936,37999,37967,37999,37999,37999,42159,42192,42256,46450,46417,44305,35854,18984,29580,35886,29547,29547,29515,27435,19016,27402,31628,29515,29515,25355,10630,16968,42225,42192,40112,44305,44369,173},
{52890,52857,50809,50841,50809,50809,52890,50809,50809,50841,50809,50809,50809,52890,52890,52889,52857,54937,54937,54969,52889,52857,52889,52857,50809,52890,52857,50809,50809,52857,52857,52857,50809,52857,52890,52889,52857,52857,50777,50809,50809,50777,52857,50809,52857,52857,50809,52857,52889,50809,52857,52857,50809,52857,52857,50777,50777,50777,52857,50809,50809,50777,44503,42423,40342,38197,36117,36084,34004,33972,29779,27698,31859,31890,38099,48532,36018,38164,29680,29712,29713,31825,29745,33938,42291,38097,36017,33872,27567,31792,31759,38065,42259,35953,33839,40177,40145,33806,33807,38000,50710,52790,52823,52823,52823,50743,29647,25356,44273,37934,35757,33709,25355,10695,17033,25387,21193,29547,25356,23275,25388,27469,27469,25389,25356,31694,52823,46451,50645,50678,54937,50613,29548,21162,21130,12743,8517,16969,33840,16969,8549,29547,40047,35820,14822,23242,46386,31694,23209,50579,44274,25291,21130,23243,23210,29582,29582,31663,27502,29582,27437,27502,23308,21163,14758,25290,42226,44305,44272,42158,50545,44174,35788,37901,23177,8550,25419,42257,44305,42159,40014,42159,35884,25320,29547,29547,25322,12743,21130,25355,21128,16966,8580,6435,23274,29613,23242,14791,6372,14790,27500,37999,31692,42224,27435,19016,6435,25419,37967,35887,35918,37999,33676,37933,42192,44305,40079,33773,31627,31628,21129,21129,29547,29515,31628,29548,23242,19016,14791,23210,27434,29548,23242,8550,10630,25355,42192,40111,37966,40078,188},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,52890,54937,54937,52889,52889,52857,52857,52857,52857,52857,52857,52857,52857,52857,50809,50809,52857,50809,50809,52857,50809,52857,52857,50809,52857,52857,52857,52857,50809,50809,52857,50809,50809,52857,50809,50809,50809,52857,52857,50777,50809,52857,50777,50777,50777,48729,42423,42423,40310,36149,36117,34004,34004,31924,29778,27666,31891,31890,38131,44339,31857,38132,31825,29712,27600,29648,33874,38099,44403,42257,38096,33904,25454,31792,31791,42258,44306,35952,25421,38097,40145,31759,33807,38001,52758,52823,52823,52791,52791,50678,31728,29582,35919,25355,25323,31629,27436,16969,19113,27466,25386,29548,25388,25388,27501,27501,27501,27501,25388,33774,50743,52726,52823,48532,57050,42193,21130,21162,31694,27500,27468,29581,33775,19049,8549,27402,40079,31627,12742,25355,46353,25323,25290,40015,29484,25323,21130,25356,21130,27501,25420,29582,23243,29582,23211,27502,21163,21163,18984,23145,23209,37934,33707,44206,40013,33675,44239,42159,27435,8550,29580,40112,33740,35853,40014,48498,54870,37999,29547,33741,16969,8550,10630,25354,29546,14852,12804,10660,10628,14822,27403,27435,38032,50644,54838,46385,23238,29578,29548,19015,14822,33806,35886,35886,35886,37966,42159,42159,40047,31628,27467,27435,29515,31628,23209,14822,21128,29548,31628,29515,19016,14823,10598,21129,29548,29515,16936,8582,10662,10630,33805,44304,46385,48530,208},
{50809,50809,50809,50809,50809,50809,52890,52890,50809,50777,50809,50809,50809,52890,50809,50809,52890,52889,52889,52857,52857,52857,52857,52857,52889,50809,52857,52857,52857,52857,52857,52857,52857,52857,50809,50809,50809,52857,52857,52857,52857,52857,52857,52857,52857,50809,52889,52857,50809,50809,50777,52857,52889,50809,50809,50809,50777,50809,50777,50777,50776,48696,44503,42423,40310,36149,36117,34036,34004,31891,29810,29778,34003,33971,38098,44339,36019,38099,31825,29745,27600,29713,33874,36018,42290,40177,38064,31824,23373,31792,33871,44338,44305,40113,25388,42291,40145,31694,31694,35920,40113,40146,46452,52790,50710,44372,27502,27502,19083,16970,17002,29614,23307,23339,25452,31759,29581,29548,23243,23243,25356,25388,25356,25356,23275,29549,50742,50645,50678,48597,57017,37935,14824,19016,25354,25386,25354,25355,31726,21194,16968,29482,27434,16934,12741,27435,40047,23210,14791,14824,21130,25355,25290,27435,25323,31662,31694,31695,27436,29582,27437,27502,23276,21163,16904,29484,31629,31627,33739,44239,33741,23209,40046,37934,21129,12711,31726,42224,40079,44337,44305,40013,40046,29515,29483,12710,6470,8550,6470,12677,21126,16997,12804,14853,12742,19048,29516,33773,46418,52757,52790,44305,23207,19078,21160,12741,19048,33806,35886,33806,35886,37966,44305,46385,35886,29515,29548,29516,29548,29548,23209,10661,21128,27370,27370,27402,16936,10630,10630,21129,29515,27403,12743,10662,10663,8550,16936,40111,44304,37933,107},
{52857,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50841,50809,52889,50842,52890,52857,52890,52857,50809,52857,52889,52857,52857,52889,52857,52889,52889,52889,52857,52857,52857,52857,52857,52857,52857,52889,50809,52889,52857,50809,52857,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,50776,50777,50809,50809,48729,42423,44471,40342,36117,34068,34036,34004,31891,34004,29778,31891,31858,36018,44307,40245,38132,29712,27632,27632,31793,33906,33905,42290,40144,40145,31759,21293,31824,31791,33839,42193,44338,48564,48597,40178,31694,29614,40146,48597,44339,46452,48597,48597,42258,31727,29615,21229,21196,27502,35953,33840,31759,23339,25387,25388,29580,19082,21162,23275,23275,23276,23276,23243,27468,50710,52758,48597,50645,56985,31596,23307,25418,19078,14854,16966,16967,31726,25354,19015,23241,29580,25353,19047,23273,40047,29516,23275,16937,19050,33742,52757,50677,50677,48532,42193,27469,21162,21162,19049,16969,14856,12776,16936,33741,25289,29547,27401,42126,31627,25258,27370,27337,19016,16904,33774,37966,33740,42257,42224,46353,48498,37934,31628,29548,23242,14791,18984,31595,25319,19045,14885,23305,31725,27467,29548,29548,29516,35821,46353,48563,35853,19014,12709,8548,10661,19015,33806,33806,35886,40112,40079,44305,37967,29547,29515,31628,31628,29515,16902,12709,23208,37934,44240,44272,23209,10598,16903,23209,27403,23209,16904,12711,8582,8582,8549,27500,42224,35820,144},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50841,50841,50841,52890,50809,52890,50809,52889,50809,52857,52857,52857,52857,52857,52889,52889,52857,52857,52889,52889,52857,52857,52857,52857,52857,52889,52857,52857,52889,52889,52857,50809,50777,50809,50809,50809,52857,52857,52889,52857,50809,50809,50809,50809,50777,50776,50777,50809,50809,48729,44471,44471,40342,36149,36117,34036,34004,34004,34004,29778,29810,31858,38098,42259,40212,44438,31825,29712,27632,31793,38099,42292,42290,40177,38064,33936,23406,31824,33872,37968,42193,44370,54904,48565,40146,31694,31726,44404,54936,54936,52855,52855,52856,46517,38066,31695,23309,21196,29614,27534,27501,25420,21192,27531,25353,31629,21195,25388,27468,25420,27468,27469,25388,31661,50711,48532,48564,52856,52758,27467,19049,23241,27498,23305,23272,25353,33806,27435,21127,31660,46450,35852,19015,14854,35854,25355,27500,16969,23178,48467,50612,46419,40080,27468,21129,16969,14889,14856,12743,10663,8582,8550,23307,27467,14821,19014,12676,29547,33708,23209,23177,21096,19016,23274,40047,42225,42225,42224,44305,50645,46450,33805,29516,33709,44304,44304,50643,37964,19046,16933,14852,12805,16967,29516,29548,31629,25257,29482,46450,50676,52757,37999,12709,8516,8580,10661,19080,33741,35886,37967,31628,40112,40079,31628,31629,29548,29547,25353,12708,10596,21127,31628,31595,31595,23209,18984,29580,25322,27403,27435,25290,23209,21161,14855,10630,12710,35853,46418,213},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50841,52890,52857,50809,52890,52857,52857,52857,52857,52857,52857,52857,52857,52889,52857,52889,52857,52857,50809,50809,52857,52889,52889,52857,52889,52857,50809,50809,52857,52889,50809,52889,50809,50809,52857,52857,52857,50809,52857,50809,50809,52857,50809,50777,50777,50777,50809,48728,44503,44503,40310,36117,36084,34004,34004,36084,31923,29810,31891,31858,33938,38099,40212,46518,36018,31793,27632,31825,36051,42259,42322,40177,40145,35984,23406,31791,38097,46419,44305,46451,54969,46452,31662,25388,27501,38066,46485,46517,48565,46485,46485,42292,38034,33840,27502,25421,27501,25356,23340,21194,23305,29644,27466,31661,25355,27501,27501,27501,27501,27501,27500,31661,50743,52791,50645,54936,44339,25355,25355,23243,23274,27499,29579,29611,35919,29548,21128,37933,37965,27401,12741,12742,27436,25355,16936,18985,40018,40082,19016,16968,14856,14824,12743,10696,10663,8583,8582,8550,6501,10662,21160,14789,14789,16870,21128,40112,42128,44273,29483,21096,18984,21161,40144,42224,42225,42224,42225,27467,19015,19047,25322,29515,44304,44272,46384,19013,14885,14852,16966,12709,19016,29516,29516,29516,35854,50645,52822,52757,48531,33805,12773,8548,6468,8548,8548,14822,12709,8484,6339,12677,31693,29548,29548,29548,29547,25353,16901,10628,18983,29516,31628,44305,44305,31660,21129,19048,25323,23209,35821,42159,48531,42225,35886,25322,29547,52757,205},
{50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,50809,50841,52890,50841,50809,50809,50841,52890,52857,52889,52889,52889,52857,52857,52857,52857,52889,52889,52889,52857,52889,52857,52857,52857,52857,52857,50809,52889,52857,50809,50809,52857,52889,52857,52857,52857,52857,50809,50809,50809,50809,52857,50809,50777,50809,50777,50777,52857,50776,50777,48696,44503,44503,42423,36117,34036,34036,34004,31891,29779,29778,31923,31858,29745,33906,36051,42325,36051,29712,25487,31793,35986,42323,44370,40145,38097,31823,21293,29711,33936,42225,44273,48532,52888,48597,31694,23276,25421,25421,25421,25421,27501,25356,21163,23276,33873,38066,27469,31695,42259,29582,25421,21194,25386,23305,23242,33741,33709,25323,19016,23243,25323,25355,27435,31660,50710,48565,48564,57049,38000,25323,23275,23243,19050,25387,35886,31692,31660,29547,31594,37866,46353,44305,19014,14822,23243,12776,6437,29581,27436,19017,14824,12808,12744,10695,10663,10663,8550,8550,6502,6502,6469,16935,27433,23207,25256,21031,25289,35788,37901,33708,27338,19016,16936,12743,27468,42225,44305,35854,14823,12742,14886,16967,21097,37966,44272,42192,40111,19046,12772,14852,27498,29581,25323,27435,29483,29516,31596,46385,42192,25321,16934,14789,10693,6468,4356,4323,6436,6436,4291,2211,2211,2178,14790,29580,29548,29548,29515,27434,25320,16934,14757,29515,37999,44305,40144,21129,12711,10630,19016,12710,16903,18983,23209,38031,46418,44337,42159,31660,119},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,50809,52857,54937,54938,52857,52889,52889,52889,52889,52857,52889,52889,52857,52857,52857,52857,52857,52857,50809,52857,52857,52857,52857,52857,50809,50809,52857,50809,50809,50809,50777,50777,52857,50809,52857,52857,52857,50809,52857,50809,50777,50809,50777,50777,48729,42423,44503,40342,36117,36117,34004,31924,29778,29746,29778,31923,29777,29745,36019,33906,33906,31825,27632,25487,31793,33873,42323,44403,40177,40145,31759,25453,33872,35919,44305,42160,40081,40081,44306,35887,25356,27469,25389,23308,25421,25388,23276,19115,23276,35920,40049,23178,27468,38032,31759,31695,25388,23306,23305,25354,31628,31629,27371,14856,21130,23242,23242,23274,29547,52758,52823,48565,57017,35822,25323,23243,21162,21130,25323,42225,33773,35820,42191,48430,54637,46352,33740,35853,42192,31630,10631,8549,40048,25355,21130,19050,16969,14856,14856,12776,12776,10663,8582,6469,6501,6437,21194,40080,31594,27304,16838,25290,29482,42159,33708,23176,21064,19016,14823,12711,35886,42224,31628,16904,10662,12774,16935,10630,23242,42192,44272,37997,25351,14884,12772,12772,19047,27435,27435,29516,23176,31628,35886,16933,16934,14790,14854,6436,4323,4323,8549,8581,6436,4291,4291,4291,8549,16936,29548,29515,29516,29548,29514,27401,21095,21128,27435,33773,31660,23209,14791,14790,12743,12743,10630,8582,10630,8517,16870,35853,31627,23208,16901,47},
{50809,50809,50809,50841,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,52857,54937,54969,54937,54970,52857,52889,52889,52889,52889,52889,52889,52889,52857,52857,52857,50809,50809,52857,52889,50809,50809,52857,50809,52889,52857,50809,50809,52857,50809,52857,50777,50777,50809,52857,50777,50809,52857,50809,50777,50777,50776,50777,48696,42423,42423,40310,36149,34037,31924,34004,29811,29778,31859,31890,31858,33938,33970,29745,33970,33905,31825,31825,33873,33872,46485,46517,40145,38000,31694,35921,44404,40145,42160,37870,42227,44372,44338,48564,38065,38065,35953,29647,40145,38033,35984,35952,35951,46485,44339,31695,33808,40146,31727,29646,29613,29612,27467,23241,27403,31597,27436,16936,27403,25322,27403,27467,29547,50646,50678,50678,54937,33677,27468,27436,27436,25356,25323,42226,31628,35755,50545,48464,46286,31562,21095,35886,40047,29516,21130,14856,42160,29483,23210,19082,19017,16969,14889,16968,14887,6469,6469,4389,4356,4356,21162,40145,40047,27304,16805,33676,40013,44206,42159,33708,21064,21097,14856,8583,19081,35886,37934,31661,19049,14823,23307,14823,8550,21161,44305,35917,23238,14884,12804,10692,19016,27435,29548,29516,37967,50677,35885,16933,31659,35854,23241,6436,4356,6436,12741,10693,6468,4259,4259,8582,12775,14856,29515,29515,29515,29548,27434,25321,35821,40047,27467,27467,27435,25289,31628,29515,23242,14823,8582,10663,10630,8549,10564,14757,14724,18981,25349,75},
{50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50809,50841,50809,50809,50809,52889,54969,52889,54937,52857,52857,52889,52857,52889,52889,52889,52889,52857,52857,50777,52857,52857,50809,52857,50809,52857,52857,52889,52857,52857,52857,52857,52857,52857,50809,52857,50809,52857,50809,50777,50777,50809,50809,50777,50777,50777,50777,50809,48696,42423,42455,40342,36117,34004,31924,31891,29811,29746,31891,33971,31858,34003,33938,29745,33971,33938,33938,33938,36019,33905,42292,42323,40177,40210,31792,23341,33872,35952,35920,37936,42194,38033,40112,48596,40178,38098,33872,29647,40145,38097,38065,38064,38064,46452,40146,29647,25388,33807,33775,29581,29581,31693,31692,29580,21161,25323,29515,35853,42128,40014,40047,37934,33740,48565,50678,52758,52758,33677,29581,31662,31662,31662,29549,29548,37935,46353,50512,50644,42128,37868,27433,37967,33742,27403,27436,21130,37935,52757,35887,19050,19049,19082,25421,25388,14920,6469,4389,4356,4324,4324,21162,37935,37869,33577,14660,29515,44271,42158,42158,35820,21096,21096,19016,14823,10662,29547,44337,42257,31693,29548,33708,16936,8582,10630,21159,21126,21158,19045,14884,12741,21161,27435,27436,29548,27435,16871,10598,14822,14821,19047,25321,12774,6436,10661,12709,14854,10661,12677,19016,14791,12710,12742,25355,29548,29548,29548,27467,21095,12708,14820,29547,31628,40079,42192,42192,35821,35821,25322,8550,10630,8550,10630,12709,12676,10531,16901,23269,74},
{50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,52890,50841,50809,50809,52890,50841,50841,52890,52890,52889,52889,52857,52857,52889,52857,52889,52889,52889,52889,52889,52857,52825,52857,52857,50809,52857,50809,52857,52857,52857,52857,50809,50777,52857,52889,52857,50809,50777,50809,50809,50809,50777,50777,50777,50777,50777,50809,50777,50809,50809,48729,42423,42423,40342,36117,36117,34004,31891,29811,27698,29810,33971,31858,33938,31890,29777,31858,33938,33937,40244,31825,29680,31792,40177,38096,36016,29679,25421,35952,38033,29615,35888,42194,38000,37999,46483,38065,35984,40178,33872,35952,38064,38032,38032,38032,42226,48532,40113,31694,31727,33807,29614,29613,27500,27467,37966,27371,31563,44173,50546,50579,50546,50579,46352,33772,48597,48565,56984,46387,29516,23275,25323,23275,23275,23275,25355,25355,35853,44239,48499,48531,46319,46417,42224,42192,40080,27436,25291,40080,54871,31661,19082,19050,21163,29615,23308,12775,14888,6469,6469,6404,4356,16936,31597,37901,35625,14660,18918,42126,42126,42158,33740,21096,21096,23177,35887,35854,27433,27401,29580,23209,40144,37966,19049,8550,10630,21126,16932,21158,19077,14885,14853,25355,27435,27435,23177,25290,8485,16936,10597,8484,12645,31660,27499,10629,6403,10629,19048,14821,31692,44305,37999,31661,25322,27403,29580,29580,29548,29515,23207,19014,19014,27434,33741,44369,44305,42192,25322,21129,23242,14823,14791,14855,14821,19013,12740,6403,10563,21157,78},
{50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50841,50809,50809,50809,50809,52890,50841,50841,50841,50809,52890,52889,52889,52857,52889,52889,52889,52889,52889,52889,52889,52857,52889,52890,52857,52857,52857,52857,52857,50809,50777,52857,52857,52857,50777,52857,50809,50809,50809,50809,50777,50777,50777,50777,50777,50777,50776,50777,50809,50809,52857,48729,42423,42423,40310,36117,34036,31924,31923,29811,29778,34004,34003,31858,33938,33970,31858,29745,31858,33905,38131,29679,31760,29712,38097,35984,38064,29711,27534,35984,38032,33807,37935,42193,40112,42160,48564,40146,40145,40178,40178,38032,38032,38032,38032,35919,35888,52822,52790,44338,40178,33807,31759,31727,29581,27434,44272,37869,37868,48398,50579,50546,48498,50546,48465,40047,48564,50645,57050,37935,27436,25323,23275,23243,23243,23243,23242,21097,31629,27466,27401,46319,48432,50611,35853,35853,40015,33708,33708,50613,48500,23242,21162,19082,21163,29614,21194,8581,8550,6469,6437,6405,4324,4356,12710,31531,33479,29286,37803,44206,42126,44239,33708,23144,23144,23177,25289,40079,40111,27434,25322,21097,23242,16936,12743,19016,16935,21159,19045,14852,19046,16933,19015,27403,27403,27435,40080,42225,21096,33742,18984,10565,8452,10597,19080,16967,8516,14789,19047,23240,40144,44305,44305,42192,35886,29515,29548,29548,29515,29515,27466,21159,19014,25321,33773,35853,31595,29515,21097,8549,16968,35854,29547,23209,21127,16965,12740,4322,12740,19044,55},
{50809,50809,50809,50841,50809,52857,50809,50809,50809,50809,52890,52890,50809,50809,50809,52890,50809,50809,50809,50809,52890,52889,52889,52889,52857,52889,52857,52889,52889,52889,52857,52857,52857,52857,52857,50809,52857,50809,50809,52889,50809,50809,52857,52889,52857,52857,52889,50809,50809,50809,50809,50776,50777,50809,50777,50777,50809,50777,50777,50777,52857,48696,42423,42423,40310,36117,34004,34004,31891,31891,29778,36085,31891,31890,31825,33938,31793,36019,31793,29680,31760,27599,25487,25486,38097,35952,38064,29711,25454,35952,42225,50612,50579,48531,52724,52691,50709,40113,38000,40145,40145,44338,44371,37999,38032,42193,40048,57050,57049,50612,38032,29613,29581,29614,31694,29579,50579,42225,42094,44238,48498,48498,48465,48465,48498,44270,50645,48564,56985,27371,33742,35887,35887,35855,35887,37968,37968,31661,31628,23241,33707,48432,50545,48530,31660,37966,52724,50644,48499,31596,35855,29516,19082,21195,21162,27501,16967,10661,8614,8614,6436,6404,6404,4356,8549,25257,31368,37640,41930,44108,42125,40013,33676,21096,21096,21096,23209,27434,19015,21128,12742,10663,8550,8517,12743,33741,33708,27465,19045,14852,14822,14790,23242,27435,27435,27436,31628,37999,16871,21129,27435,21129,10597,8484,12742,25386,31692,37966,21127,27467,37967,33741,31628,29483,27435,27435,29548,29580,31660,35886,31693,19014,12772,25321,31661,25321,27369,31595,23209,10630,10630,29548,44305,31660,14821,12772,12772,8579,12739,21221,73},
{52857,52857,52890,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,50809,50809,50809,50809,50809,52890,52890,52889,52857,52889,52857,52857,52889,52857,52890,52857,52857,52857,52857,52857,52857,52857,52889,52857,52857,52857,50809,50809,52857,52857,52889,52857,50809,50809,52857,50809,50777,50809,50777,50809,50809,50809,50809,50809,50809,50777,52857,48729,44503,42423,40342,36149,34037,31924,31891,31891,29778,27698,31890,31858,31858,31825,31825,40212,29745,29713,29680,29680,25487,29648,40210,38064,38064,31759,23373,35952,35887,35854,40047,42193,42193,42160,42226,25420,23275,25388,27468,29581,33807,33774,35854,33806,33742,52758,48597,46451,33774,27501,25356,27468,21226,21161,40080,35887,31628,37901,40079,40015,39982,39982,37902,29449,46451,52791,52791,23177,44339,50677,50677,50710,50677,48597,50710,54936,37999,18982,37901,48433,50578,46417,31627,29579,42192,48531,44274,29483,27467,29548,19049,21163,19049,25419,16934,10694,10661,10694,6469,6469,10694,8581,8516,8517,14725,18918,23144,33707,40046,31627,27402,21096,19016,19016,21128,21127,12708,16935,10695,10663,12776,12743,8550,21161,44305,33739,19077,16933,14823,16839,23210,27435,27435,23177,33741,46451,12678,4324,6404,8549,10630,8550,14888,14855,16903,12677,12709,33773,29515,27435,29515,29516,29516,33741,37999,37967,35886,33773,27435,19047,19014,25353,31693,37966,42160,44272,35854,10630,8582,12742,37999,37965,16933,14852,12804,14884,12739,19076,75},
{52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50841,50809,52890,50841,52890,52890,50809,50841,52890,52890,52857,52889,52889,52857,52889,52857,52857,52889,52857,52889,52857,52889,52857,52857,52857,52857,52889,52890,52889,52889,52889,52890,52890,52890,52890,52889,52889,52890,52889,50809,52889,50809,52857,52889,52857,52857,52889,52857,50809,52889,48729,44503,42455,40310,36117,34036,31923,31891,31891,29843,29811,33971,36051,36083,33938,40212,36018,29712,27600,27600,27599,25487,31760,42258,38096,38096,29711,23341,35984,19081,21162,23274,25323,23274,25387,25355,14856,12808,16937,19049,19017,21129,29549,25355,17002,14857,19082,14823,16969,12743,12743,25388,35952,19082,10630,12743,25421,16937,19049,25388,21098,10630,10663,10663,14823,44338,52791,46453,23242,48597,50677,50645,50645,50677,35886,16901,25289,40014,29546,42126,50579,50545,50611,37966,21095,23209,35919,44371,29548,27468,44306,42225,40080,37999,33740,21127,14886,12806,8581,6469,8549,14886,10660,6436,6404,6404,10597,16902,27402,35821,42160,42193,23209,19016,21064,19016,16902,16902,14854,10695,10663,14856,21162,21129,16871,31627,23207,21126,14854,12775,16871,16871,27403,27403,37967,50644,48531,12711,4357,4357,6469,10663,8517,8549,6437,4291,4323,16967,40080,29515,27435,29515,29548,29515,35886,33741,29547,29483,29516,21129,23241,23239,23241,31628,29548,29515,31563,25322,19081,14823,12709,21095,25319,25350,16996,14852,19044,23269,23237,79},
{52890,50841,50809,50809,50777,50809,50841,50809,50809,50841,52890,52890,50809,50809,52890,50841,52890,50841,50809,50809,52889,50809,52889,52889,52857,52857,52857,52857,52857,52889,52857,52857,52857,52889,52889,52889,52890,42358,36051,38132,38132,38132,38164,38164,38164,38164,38164,38164,38164,38164,38164,38164,38164,38164,38196,40277,40277,40277,40277,40245,40245,38164,36051,34003,33939,29778,27698,27697,27665,25584,25552,25585,27665,31792,31825,29680,31793,31792,27632,27632,27632,31760,33873,35985,38065,33871,35952,38032,31727,31759,17002,16969,14888,23243,25355,25323,21194,16969,14856,17001,21130,25356,25356,27468,23275,14921,12808,12809,16970,14889,12777,16969,25356,19115,8583,8550,12776,19082,12776,12776,25388,19114,8550,8615,10696,14824,44338,57049,37969,12711,29582,31694,35920,44337,46449,29578,21159,25385,33740,25321,42158,40014,48464,46385,40111,25321,29580,38000,44339,29581,31629,50676,44240,46418,42127,40014,31562,21128,16967,10693,8581,12773,21191,14885,8580,6436,6436,8580,19047,21096,27434,37901,35821,21064,19016,19016,19016,16903,16967,19047,12775,10663,10631,14855,31659,37966,42159,35852,19014,12742,12743,23243,19049,16903,29483,31595,44305,48498,14791,4357,10630,12742,8548,6436,8548,8581,6468,6435,27467,40145,29515,27435,29516,29548,29548,29548,29483,31596,29516,27467,16936,27434,21159,23208,31596,29548,29515,29515,14822,23209,33773,27465,14852,12739,16932,21157,21125,21125,19077,21189,88},
{52857,50809,50809,50809,50777,50809,50809,50809,52890,50809,50809,52890,50809,50809,52890,50809,50841,52922,52890,50809,50809,52889,52857,52857,52889,52889,52857,52857,52889,52889,52857,50776,48696,44471,42390,44470,44438,31858,27633,27633,27633,27633,27633,27665,27665,27665,27665,27633,27665,27665,29713,29713,29745,27665,29713,29745,29745,29745,29745,29745,27665,27633,27632,27632,27600,25552,25520,25520,25487,23439,25487,23406,23406,23406,23374,23374,25454,25487,25486,27535,27567,33873,40146,40146,33808,29582,31662,35854,29549,29614,19115,21130,21130,25355,25355,25355,25323,19017,16969,19082,27468,27436,25387,27501,19114,14889,12808,14889,14889,12776,12743,19017,25388,8615,8583,8518,8518,8518,8583,10696,23340,17034,6470,6470,8550,10662,42226,56984,29549,6502,6470,8583,21130,35852,42188,29577,16998,21160,25386,27401,44271,50578,48529,46385,42192,27467,31660,40112,38065,25355,37967,52724,44207,42159,44305,44305,44273,31693,14855,12808,8549,16998,19046,14885,10693,8581,8549,8516,16934,25322,29483,29482,25289,23177,21097,18984,16903,14790,14822,23273,10695,10663,10663,10662,16967,33772,48530,52692,29547,10630,12743,23210,19049,12645,21064,35821,52724,52725,16904,10630,14855,8548,6468,6403,10660,12741,10628,10661,12709,27467,29548,29548,29516,29515,29548,27435,27467,31628,29548,25322,19016,29547,23240,21128,29516,29548,29547,18984,10630,16903,31660,25351,14851,16933,21093,31592,25286,10627,8546,14884,62},
{50809,50809,50809,50809,50810,50810,50809,50809,50809,50809,50809,50809,50841,50809,50841,50841,52890,52890,50809,50841,52890,52857,52857,52857,52889,52889,52889,52857,52889,52889,52889,38099,25454,27633,27600,27632,25552,27665,27665,27665,27665,27665,27665,27665,27665,29745,27665,27697,27697,27665,29745,27665,29745,29745,29745,29745,29745,29745,29778,29745,27697,27665,29713,29713,27632,25552,25520,25520,25519,25487,25519,23406,23406,23406,25487,23406,25454,25486,25454,25486,27566,33872,38033,38065,33808,29485,27404,29484,25259,31695,23276,27468,25388,25323,23275,25355,25323,31629,27468,27436,31694,31661,29548,27435,23307,17001,21195,29581,29548,31694,31661,33806,27501,8583,8551,8518,8518,8518,8551,12744,27501,17034,4390,6502,8615,10662,42258,57017,29516,10663,6470,10696,25323,35852,40108,23239,14918,8613,14854,31594,46351,42093,46351,37966,35854,21160,21160,35854,40179,25355,44306,46386,40080,42160,40080,44306,40079,31662,10663,10664,10662,16966,19078,14853,8580,6436,6404,10628,23272,31627,29482,31562,33709,21129,18984,19016,18984,12677,21096,31628,14856,8614,8614,10630,12775,12742,14790,14790,12743,10663,12743,16871,14725,14693,14725,27403,31563,27402,16871,16967,12741,10692,8548,12740,14853,12740,10628,14886,10660,8516,27435,29515,29515,29548,29515,27402,29516,27435,23209,23242,23274,29547,21128,21128,35854,29547,16935,10565,10630,21096,25256,25319,23238,27399,25286,18980,14820,6435,4322,12708,25},
{50809,50841,50809,50809,50810,52890,50809,50809,50809,50841,50841,50809,50809,50809,50809,52890,50841,52890,52890,52890,52890,52857,52889,52889,52857,52889,52889,52889,52889,52889,54970,33873,23374,27665,27665,27633,27633,27633,27665,27665,27665,27665,27665,27665,27665,27665,27665,29745,27665,27665,29713,27665,29745,27665,29745,29745,29745,27665,29745,27697,27665,27665,29745,29745,27632,27600,25520,25487,25519,23439,23439,25487,23406,23406,23439,23406,25486,25486,25486,27567,29615,33840,33872,38033,33840,29517,31630,31695,29484,50646,27500,25388,23275,21130,21162,29548,27435,31661,31629,27435,31629,31661,29548,25355,25388,14856,23275,29581,27435,33774,35886,35886,31694,12776,10599,10566,10566,10599,10599,17001,33872,16969,4389,6502,8615,12743,42258,52792,21064,10663,8518,14856,29549,35885,37963,21159,21224,19079,16934,35852,48465,44272,50578,38000,33742,27466,12708,25354,40211,31727,48531,40015,37967,38000,33774,33741,27468,21162,17001,19082,25386,21159,21158,16997,10660,6468,8548,16966,27433,44271,42094,44207,44240,23177,19016,19048,19016,25322,27466,31627,14856,10663,10630,16936,19049,10629,8485,10598,10630,10662,12743,16904,14725,14693,14725,10565,10500,16871,16904,12774,14885,16933,14820,14853,12740,14853,10628,14854,14886,10629,23242,27435,29515,29515,29548,27403,27435,35886,40079,40111,29547,29483,21096,19048,42192,31628,25354,27467,14823,18983,25288,21093,16932,21093,16899,14884,12772,8547,8547,12708,32},
{50809,50809,50777,50809,50809,50809,50809,50809,50809,52890,52890,50809,52890,50809,50841,50809,50809,50841,52890,52922,52890,52857,52857,52857,52857,52889,52889,52889,52889,52889,52890,31793,21327,27665,27665,25552,25520,31858,31891,31890,31858,31858,31891,31890,31890,31858,31858,31890,31858,31826,31890,31890,31858,31858,31858,31891,31858,31826,31890,31858,31858,29778,29777,31890,27697,27697,27632,27632,27632,25552,25552,25519,25487,23439,25487,25487,25486,27599,25519,25486,27566,33872,38033,40147,33840,31630,27436,25356,27371,46419,29580,25388,23210,21129,23242,29581,31661,25387,25355,27468,31693,27468,29581,21162,25387,21194,27436,31693,27403,33741,35886,35886,33774,12776,10631,12615,12647,12647,12647,19049,35920,16969,4389,4422,6470,12742,46419,48533,21130,25356,23276,27469,33742,35885,31690,23239,21127,27432,27433,40045,46352,52691,52691,35887,29548,29547,21192,19015,38033,44372,46418,40113,33807,29581,21162,19114,17001,14889,14889,14888,14887,16998,16965,19078,14917,10692,10725,10693,16934,40078,44239,44239,42094,25290,21097,18984,18983,21063,25256,25353,14823,10663,10662,21162,19048,10629,10597,14823,10630,10663,12743,14824,10598,12678,10597,8517,10565,27403,16936,6404,10596,14789,23208,23240,16901,16934,10628,6436,12741,12741,23241,29515,29515,29548,29580,29483,25290,29515,31595,29547,27435,31660,25322,29547,42192,35886,16903,19048,12743,12677,21064,23239,16964,12739,8546,16964,12739,8547,10627,10660,46},
{52857,50809,50777,50809,50809,50809,50809,50809,50809,50809,52890,52890,50809,50841,50841,50841,50809,50841,50809,50809,52890,52890,52857,50777,52889,52889,52889,52889,52889,52857,50777,27599,23407,29745,29713,33906,33906,31792,27567,25519,25519,25519,27567,27600,27567,25519,27600,27632,27567,27567,27600,27632,27600,27600,27632,27632,25519,27567,27567,25519,25519,23439,23406,23439,23406,21326,21326,21326,21293,21294,21294,19181,21261,21261,21261,21261,23374,25421,25454,25454,25454,27502,27534,29648,27534,31662,25388,17002,19083,29614,29549,29549,27436,25355,23275,29548,31661,23275,21162,23242,31661,31693,29581,23274,21162,19049,21129,29549,27468,33774,35886,35886,35887,14856,12679,14695,14695,14695,14695,21130,33807,17034,6470,8583,10696,14856,46452,35888,16904,12776,8518,16968,29581,31692,27465,23240,25353,25385,27433,44271,46319,48464,52659,31629,23210,35853,42225,19048,35984,38033,23242,10663,8550,8550,6470,6470,6470,6437,4357,4357,6437,14886,14886,14918,14885,10692,8548,8548,12773,31626,44238,42158,44239,29418,21031,27370,44241,46254,37868,29515,31661,29548,23209,21129,19049,6436,12711,16937,10630,10663,12743,16969,16904,12678,12678,12710,14758,31661,16936,12678,27403,42192,52757,52789,33740,23175,10596,6436,10661,10629,23241,29548,29548,29548,29548,29515,25322,27467,29516,29515,29515,31661,33773,35854,33708,31595,16903,16903,19016,18984,14790,16933,19077,10691,8547,14884,14884,14852,12772,12739,78},
{50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,50809,52890,50841,50809,50809,52890,52890,52890,52889,52889,52889,52889,52889,52889,52857,50776,33905,40212,48696,48664,50809,50809,38131,35986,35954,33906,33938,33906,33905,33905,33906,33906,33873,33873,33873,33873,33873,31793,31793,31760,31792,31728,31728,29648,29615,29615,27567,27567,25454,25454,23374,25422,23341,23341,23341,21229,21228,23341,23340,23341,23341,27502,27502,27534,29615,29582,25421,23309,23309,27501,27404,27501,17002,17003,16970,23307,31661,23275,25388,21162,27468,33774,27468,16968,27435,29548,29548,31629,25322,19049,21130,25387,25355,31661,33806,35919,37966,35919,14856,12711,16743,16743,16743,14695,21162,33871,19082,6470,6503,10663,12743,46419,27437,14856,10695,6502,16969,29581,29547,25352,19047,19047,16934,29482,48465,50579,48400,42158,25355,14823,33806,42225,16935,33903,25356,14824,6405,4324,6437,6437,4389,4357,4357,4357,4324,6404,14854,10693,8581,10661,10661,6436,6404,6436,19015,42158,37900,39980,35723,44241,57049,56885,50282,41994,35821,46450,46417,40079,21128,12742,6437,16969,19049,10630,10630,10662,19049,14856,12678,14758,12710,21129,33709,35854,50677,56983,54838,50643,52724,48498,42127,16934,10693,8548,8516,23274,29580,29548,29548,29515,27435,27403,29548,29548,29515,29515,29548,37934,33741,16903,33740,42094,42159,42127,31628,16871,21063,18981,12771,12740,14884,16965,16932,16965,12708,69},
{52857,50777,50777,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50841,50841,52890,50809,50841,52890,52889,52889,52889,52889,52889,52889,52889,52889,52889,52857,52857,40211,44437,52857,52889,50776,48696,52857,52889,52889,52889,52889,52857,50808,52857,52857,52889,52857,52857,50808,52856,50776,50776,50776,50808,52857,50808,50808,50809,50809,50744,50776,50776,48696,48696,46583,46583,42422,42390,42390,40245,38132,42324,40243,40244,38132,38099,38099,38099,40180,40179,36018,35987,38067,40113,31531,25388,17034,17035,16970,21162,31694,27468,23275,21097,29581,33742,29581,25355,31662,31661,29548,29516,31661,25323,23275,29581,25322,31693,33806,35886,35886,33806,12776,14727,16711,16743,16743,16743,21162,38065,19082,6470,6470,6470,10630,38000,19018,12743,12744,8551,16969,33774,29579,29609,25351,23240,27434,35852,46352,42060,48367,52659,33741,23242,25289,25322,16934,33871,27469,14856,19049,19049,14921,14857,19115,21163,19083,17002,14889,12809,17032,12837,6468,6436,6468,6436,6404,6436,23208,44272,42126,50579,52724,56983,57017,50479,50282,37768,21063,35886,44305,37966,16902,8548,8549,25388,23210,10630,10662,10663,16969,21130,14758,12710,14791,27435,31693,35822,37999,48498,52725,48466,35722,46385,46385,16902,10694,12742,12741,23273,31628,29548,29548,31628,29515,33741,31628,29580,29515,29515,29547,21129,14790,12775,16871,33708,40014,31563,16870,10597,25257,25256,19014,21062,18981,18917,16869,10563,10531,101},
{52890,50777,50809,50809,50809,52890,50809,50809,50809,52890,52890,50841,50809,50809,50841,52890,52890,50841,50841,52889,52889,52857,52857,52857,52890,52857,52857,52857,52889,52889,52857,40211,40179,50776,50809,50776,48631,50776,50776,50776,50808,50776,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50744,50776,50776,50776,50776,50743,48695,50744,48695,48695,48696,48663,46615,44535,44502,42358,42390,42357,40245,38165,40276,40243,40276,38100,36019,36051,38099,38067,38099,36018,33906,38003,48466,46223,14857,17002,17035,17002,21162,27468,23242,25388,21130,31662,27436,27468,23275,23243,29581,33774,31661,31629,25388,23242,29581,27468,31693,35854,35886,35918,35854,12776,14760,16743,16743,16775,16743,23243,35952,19114,6470,6470,6470,8550,10630,8550,10663,10663,6503,14856,31694,25386,19046,31690,29546,25256,37900,46352,46318,50512,50611,35854,33773,25256,31627,27433,35919,25421,14856,33806,25388,21195,19082,23308,27534,23309,21196,21196,14922,14951,12805,6468,6436,6468,6468,8581,10693,16934,37933,48465,56917,54771,48432,50578,48367,42028,25255,14823,12710,16935,25354,12741,6436,14823,29548,25323,14856,12743,12711,16936,21064,14758,14726,21096,33741,33741,33741,33741,35821,48564,52822,46353,46385,40047,12710,6404,6469,10629,21161,29548,29548,29547,35853,42160,33741,27467,29548,29548,29515,27435,12742,10663,12743,10630,16935,42257,44337,40079,33708,40046,44272,44273,42159,42159,44240,40046,40046,46385,167},
{52857,50809,50809,50809,50809,50809,50841,50809,50809,52890,50841,50809,50809,50809,50809,52890,52890,52890,52890,52890,52889,52889,52857,52857,52890,52857,52889,52889,52857,52857,52857,40212,44405,52857,50809,50809,50744,50776,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50808,50744,50776,50776,50776,50776,50776,50808,50776,50776,50776,50744,48695,48696,48696,46616,44503,44503,42357,42390,40309,40245,38133,40212,40244,40244,36019,38132,36019,36051,36018,38067,36018,33906,35955,50546,46287,16937,19083,17002,14922,21195,27468,21162,25355,21162,25355,31662,29581,27468,23275,25355,29581,29581,31629,23274,21162,25355,25387,29580,35886,35886,35886,33806,12776,18921,16743,18791,16743,16743,27404,38033,19082,6470,6502,6470,6470,8583,6502,10663,10663,6503,14856,31661,21193,16967,33804,29482,27369,40013,46319,50611,50609,46418,27434,31628,25288,31660,40079,38033,33840,19017,44307,29549,19082,19050,23276,25421,25389,23309,14889,12808,14918,14918,8581,6468,10661,10661,12741,12773,8548,12741,37965,46352,25224,12644,18983,19015,19016,33741,29548,10663,10662,19047,14854,6437,21195,29548,23275,10663,12775,12776,19016,16806,16773,14693,25322,33774,33741,33741,33741,33741,48498,52789,50611,50644,33773,19049,10597,8517,10629,21128,35854,35886,35886,35886,29548,19016,27468,29548,29548,29548,31628,25322,29580,16903,10630,8549,25354,44337,44304,48498,50644,46418,52757,52789,54870,54902,52756,52789,57048,182},
{50809,50809,50809,50841,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,52890,52890,52890,52890,50809,52889,52889,52889,52889,52889,52857,52890,52889,52857,52857,52890,40244,42292,50776,50808,50809,50776,50776,50808,50808,50776,50776,50776,50776,50776,50776,50776,50776,50808,50776,50776,50808,50776,50776,50776,50776,50776,50808,50776,50777,50744,48695,48696,48696,48664,44503,44503,40309,42358,40277,38197,38165,38164,40244,40212,38067,38099,38099,36019,36019,38066,36018,33938,35955,46355,42096,16970,19083,17034,17035,21195,25388,21130,25356,27436,27468,33774,25355,23243,27468,25388,29581,31661,27468,23242,21130,23275,29548,31693,35886,35886,35886,33806,14856,18921,18791,16743,16743,18823,27403,35920,21195,6470,6502,6502,6502,8583,6534,12776,14857,6470,14824,31725,19047,14886,31659,23176,27402,40013,46352,52691,50609,42192,14757,19016,18983,29515,42160,40178,38001,25290,52791,31630,16969,19050,23308,21227,23275,12808,6469,12808,16998,16965,12773,12805,16966,16966,14853,10693,6468,14822,21127,10628,6404,4356,4324,6404,14823,19016,16935,10663,16968,16999,12774,10630,27468,29516,25355,12711,10630,12743,18985,14758,16903,21064,31661,33774,33741,33773,33741,37934,42061,37836,52691,40014,29482,31660,37999,27435,12709,19047,37999,29547,27435,31596,23210,21161,29548,29515,29548,29548,27435,31661,35854,33709,23242,16903,14790,35885,42191,46385,54837,52756,52691,48498,48465,46353,37966,42192,48498,146},
{50777,50809,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,52890,50809,50809,52890,52890,52890,52890,52890,52889,52889,52857,52890,52889,52857,52857,52857,52857,52857,52890,42292,42292,50776,50808,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50808,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50776,50744,50776,50776,48696,46583,48696,44470,44503,40310,42390,40277,38197,38165,40212,40244,40244,38099,38132,38132,38131,36051,38066,38099,35986,33906,38034,33808,17002,17035,17034,17035,27502,27468,23275,25355,27468,25355,29581,27500,23242,29581,27468,27468,31694,27468,23275,19049,21162,27468,31661,35854,35886,35918,33806,12776,18889,18823,16743,16743,18855,27436,33807,25389,6502,6502,6502,6502,6502,8550,14889,14889,6502,14856,33806,23272,23240,33739,21095,29546,42126,48464,44206,50545,42159,19047,14822,23241,35854,25322,35921,29582,29483,57050,29517,17001,17001,23307,23307,16968,12775,17034,12807,19078,21158,19110,16933,16997,23239,18982,10628,12773,14854,16934,8548,6468,6404,6436,14823,25354,23209,16936,12743,16935,16934,8549,19016,31628,29516,27403,10663,10663,10630,14824,10598,21163,27468,31661,33741,33773,33773,33773,46419,52757,46353,48499,37934,31628,37934,35853,23241,10661,10629,27467,29548,29516,29548,19049,25355,29548,29515,27435,27435,14822,10662,12678,21096,40111,37999,31660,37933,42223,50676,52789,50611,40045,35787,31562,25256,27368,48498,44208,129},
{50809,50809,50809,52890,50841,50841,50809,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,52890,52890,52890,52889,52890,52857,52857,52889,52857,52857,52889,52889,52857,52922,42325,44405,50776,50808,50776,50776,50776,50776,50776,50808,50808,50776,50776,50776,50776,50776,50808,50808,50808,50808,50776,50776,50776,50776,50776,50776,50776,50776,50744,50744,48696,48728,48664,48696,44470,44503,42390,42422,40277,40277,38165,40212,40244,40244,38099,38100,38131,36050,36018,38099,38099,36018,31858,35986,33809,16970,17035,17034,17002,25388,27500,21162,21162,25388,25323,29548,27500,19049,25323,27500,21130,29581,27436,23242,25355,29581,31661,25387,29548,35886,33806,29613,12776,16840,18791,18823,18823,18855,29516,33807,25421,8550,6502,6502,6502,6502,6502,10695,14856,8551,12776,33805,29545,35916,44271,33674,35820,42191,48497,27401,31628,27434,16966,16934,27467,40079,18984,31727,31727,40081,57017,29484,19049,16968,21161,19080,12806,12807,14889,14854,23269,25349,23270,21157,23270,16966,10564,14822,19047,21126,16965,10660,19015,37968,23242,21129,29515,29548,19016,33806,33708,21128,8485,25323,31629,31596,27436,12743,10630,14856,25355,27468,25355,29516,33741,33741,33741,33773,35853,50644,48531,35821,25321,23241,14789,16902,25354,19047,12741,10628,23209,31629,31628,27436,16936,29516,29548,31693,29515,33741,31628,19017,12743,10630,29548,46385,46450,50643,50610,56917,54803,33609,16837,14757,12708,12676,21094,44304,31530,133},
{50809,50809,50809,50809,50809,50809,50809,50809,50841,50841,50809,50809,50809,50809,50809,50841,52890,52889,52890,54937,52889,52889,52857,52857,52857,52857,52889,52889,52889,52889,52889,50777,50777,50809,50809,50809,50776,50744,50776,50776,50776,50776,50744,50776,50744,50744,50776,50808,50776,50776,50776,50776,50809,50776,50776,50776,50776,50776,50776,50744,50744,48695,48696,48728,46616,44503,46616,42358,44470,42357,40277,42357,40245,40245,40276,38131,40212,40212,38131,38099,38099,38098,38066,33938,36018,35953,19082,17035,17034,19083,21195,27500,29581,25323,23242,27436,31694,27468,23242,23243,29613,23242,29581,29548,27468,16937,16969,27436,27468,27468,31693,23243,23243,12744,16808,16743,18823,16743,16775,29516,33839,23308,8551,6502,6470,6534,6502,6470,8615,10696,8551,12743,27530,29577,38029,46416,44239,33707,42126,37965,16935,12709,14854,14854,35886,33773,23208,12710,27534,29615,40081,50645,25323,19049,16936,17001,16968,17000,14888,10662,16998,21157,25414,23302,25382,23270,16934,16903,19015,19047,21158,19045,12773,12740,23209,21129,23210,23177,21129,16936,21129,42126,29482,14823,31661,31629,31628,29516,12711,16936,27436,27500,31661,27403,31629,33741,33774,33741,33741,37967,31595,23143,16966,12740,10660,8547,14854,25322,23209,19015,14854,23241,31628,27435,23210,23242,31628,27435,33741,35886,33740,37934,25323,14855,12743,14790,37998,44304,42191,44271,42126,37900,23111,18951,16870,14790,16870,25288,33707,35821,160},
{50809,50777,50809,50809,50809,50809,50809,50809,50841,50809,50809,50809,50841,50809,50841,50841,50809,52890,54970,54969,54970,52890,52857,52889,52857,52889,52857,52857,52889,52889,52889,52889,52890,52889,52857,52857,50777,50776,50809,50809,50776,50776,50777,50809,50776,50776,50776,50776,50808,50776,50776,50809,50809,50776,50776,50776,50776,50776,50776,50777,50776,42356,44470,42357,42357,42357,38164,38164,38164,38164,38131,40244,38099,35986,38131,38131,38099,38131,38131,35986,36018,38131,35985,35986,38131,35953,17002,19115,19115,17002,19049,27500,25387,23275,23243,25323,29581,27468,27468,27436,29581,25355,31661,27468,23243,19082,16936,23275,29516,31693,25355,27469,27501,12744,14728,18824,16775,16743,16775,23210,25388,19050,8583,6502,6502,6502,6502,6470,8583,10696,8583,12808,27465,31658,38029,44303,44206,33708,44272,33739,10661,14887,16935,23273,33806,23208,14886,8549,27502,31695,48533,50645,23210,16969,14889,14889,12776,12775,12775,12807,19110,14885,14885,14852,16965,14853,21160,21064,19015,21159,21158,16997,12805,10660,12741,23242,23210,16968,16935,37999,31660,35853,37933,27370,33741,31661,31661,31628,18984,27500,25355,27436,29581,31629,31661,33741,33741,33741,33773,16871,18984,18983,19046,19078,19078,16998,19046,25322,25322,19081,8549,21128,31661,35886,37999,31628,29548,27435,29548,27435,16903,19049,14823,29548,29580,23209,23209,21031,16838,14757,14725,14757,12709,12710,10597,10564,25289,42127,35821,46419,165},
{50809,50777,50777,50809,52857,52889,50841,50809,50809,50809,50809,50809,52890,52890,52890,52890,50809,52890,52889,54937,54937,52890,52857,52857,52890,52890,52889,52857,52857,50809,52857,52857,52857,50809,52889,50809,50809,52889,52857,52857,52857,50809,52857,50809,50809,52857,50777,50809,50777,50777,50809,52857,50777,50777,50809,50777,50776,48696,46583,46583,44471,33938,31825,31825,33873,31793,33873,36018,36019,38131,38131,40212,40179,38099,36019,36051,36019,38099,36051,36019,36051,38131,38099,38132,38132,31825,17002,19115,21195,19082,25388,25388,19082,19017,19017,29549,31629,25388,25388,21195,23275,21130,31661,27500,21130,25356,31662,31694,27500,27436,19049,21162,25323,10631,14728,16743,16775,16743,16743,27469,31727,21228,6503,6470,6502,6502,6470,6470,10695,23307,25355,21161,27465,31723,35917,46319,42126,40078,46352,42160,21128,19047,19015,27435,29515,25354,16935,8549,25389,33808,46452,40113,21162,16969,14889,14857,12808,12776,10695,10662,17030,14885,14917,14917,10661,8548,14854,21096,19015,21159,23239,21158,14885,12773,23242,33709,19017,8550,21162,42257,44305,48530,54804,33708,33741,31661,31628,35854,31564,31661,31661,29549,29548,29516,31661,31661,33741,35854,35822,18985,35887,25289,12644,14790,16967,14822,21127,25354,25322,21129,6436,16935,29516,31660,33708,31628,29548,29515,29515,25322,12710,10663,10630,16935,37967,42159,33675,27337,23144,18951,14790,12645,8484,8484,12677,12676,44304,48466,37966,46451,166},
{50809,50809,50777,50809,52857,50809,50809,50841,50809,50809,52890,50809,52890,52890,52890,52890,52890,50841,52889,54937,54970,52889,52889,52890,52889,52890,52857,52857,52889,50809,52857,52889,52889,52857,52857,52890,52890,52857,50809,52857,52889,52889,52857,50777,52857,52857,50809,52857,50809,50809,50809,50809,50777,50777,50809,50809,50777,46550,44438,42357,38132,36051,38164,38132,38132,40212,40244,42325,40245,44438,42357,40245,40212,38164,38132,38164,38164,38165,38132,36084,34003,36052,36084,36084,36052,29746,14922,19082,21195,21163,27468,27468,21195,21130,25356,29581,31661,27468,25355,25388,19082,21162,29613,23242,23243,25355,27436,31661,27500,27436,19049,29581,31661,10631,14695,18791,16743,18791,16743,31662,33840,25388,8583,4422,6470,6470,6470,6502,8550,25388,27468,23274,21193,21161,31627,46352,44239,33773,27403,44339,44305,19015,19048,29580,35854,31660,16966,8549,25389,33808,33774,31661,19050,17002,16969,14889,16970,14889,14888,8581,14886,19078,14886,10693,6500,6468,21161,21064,23242,25321,25288,21159,12772,12774,16903,31628,23242,8583,27500,44337,44305,54869,50644,33709,33774,31661,31628,44305,31597,21162,27436,29581,29548,27468,31661,29516,31628,37967,48531,21064,19049,29581,25290,10564,8484,8452,12709,25354,25322,21161,8516,14823,27468,29548,29548,29548,29548,31628,27435,29548,14823,10662,10663,10597,16902,42159,50577,54771,46286,29449,18950,8484,6339,10596,12708,18949,48465,40046,35821,42192,190},
{48697,50777,50809,52890,52857,50809,50809,50809,50841,50809,50809,50809,50809,50809,52890,52890,50809,52890,52889,52889,54937,52890,52890,52889,52890,52857,52857,52889,52889,52890,52889,50809,52857,52857,50809,52857,52857,52857,50777,52857,50809,52857,50809,50809,50809,50809,52857,50809,52857,50809,50809,50809,50809,50776,50776,50777,50777,46583,46518,44470,42325,38164,38164,36083,33939,38131,40244,38132,36084,36084,36051,33971,31890,33971,33971,36051,33971,33971,38164,36052,33971,33971,33939,31891,36084,29745,23276,33840,33807,35919,35854,29581,25388,27468,27468,31661,33806,25323,19049,23275,25388,31661,35887,23242,23243,27468,19050,27468,27468,27436,19017,27468,27467,16937,16808,16743,16742,18823,18823,31662,31726,25421,8583,6503,14889,16969,16969,17002,19082,27468,27435,23274,12840,21195,33773,46319,44240,27436,27501,29581,29613,12741,12774,14855,31694,35918,19047,12774,23275,38066,40146,29613,23243,19050,17002,17002,21196,23308,16968,12807,12807,14887,8613,8581,6468,6436,18984,25289,25355,27403,23208,16933,16934,16935,12710,14823,23242,10663,19049,42225,42192,40047,37902,33741,33741,31661,33741,48531,21097,12711,12742,19017,18984,21097,33774,31628,29516,35821,52790,25258,4324,8517,14823,16904,10565,8484,10597,25322,25322,19015,10596,14823,29548,29548,31628,29515,29515,40079,46386,31596,16904,10662,10630,10630,16870,23175,21062,18949,18950,14757,12677,10596,6403,12708,12675,31659,42159,33741,33708,46418,227},
{48729,50777,50809,50809,52857,50809,52890,50809,50809,50809,52890,50841,52890,50841,52890,52890,52890,52890,50809,52889,54937,52889,52890,52889,52889,52889,52857,52889,52889,52857,52889,50809,52857,52857,52857,50809,52857,50809,52857,52857,52857,52857,52857,50809,52857,52857,50809,50809,50777,50777,50809,52857,50809,50809,50809,50809,50776,48663,46583,46551,46583,44471,38131,36019,33906,38132,38132,36084,36052,33971,34004,33971,33939,33939,31890,31891,34004,36116,34004,31891,36084,40245,38099,40212,33938,27599,27501,42258,42226,42258,37966,29548,25388,27500,29581,25355,33807,31694,27436,25356,23275,29581,31693,31661,29581,25323,16936,27468,29548,29614,21130,19049,19017,16937,18856,18791,16743,18791,18823,29549,31759,25421,8583,6470,10663,8550,6470,10663,12743,17001,25322,25355,16969,17067,31629,44240,42160,29548,33806,29549,23274,14854,14919,19015,31693,33805,21127,12774,23274,35953,25388,31694,35855,19017,19050,19082,25389,27437,21162,21162,14855,10695,8549,10694,4356,4356,8484,31628,31628,29548,23208,37999,44274,21162,10662,10663,12743,14856,10630,29581,33806,27403,31596,33741,33741,31661,40080,42193,25323,16904,14791,16936,21097,21097,31661,29516,25290,37967,44272,21097,6405,6469,8550,14824,10597,8548,10596,21129,25322,16967,14854,29580,29516,29548,31661,27435,29483,35853,35821,31628,19048,10662,12743,14823,21127,8515,4291,4291,2210,4290,4291,4258,6402,14853,16900,35853,33676,35789,37999,40079,141},
{50777,50809,50841,52857,52889,52890,52890,52890,50809,50841,52890,50809,50841,52890,52890,52922,52890,52890,52890,52889,54938,52889,52857,52890,52889,52857,50809,52890,52857,52857,52857,52857,52857,52857,50809,52857,50809,50809,50809,50809,52857,50809,50809,50809,52857,52889,52857,50809,50809,50809,50777,50809,50809,50809,52889,52889,44503,38164,40277,40277,38132,33971,36084,33971,31859,31891,33939,36051,34003,36052,33971,33939,31825,33874,33906,36018,33939,31858,31826,29778,33939,44470,42358,42357,42390,35987,29614,33840,27533,31726,35887,25388,23275,25388,23275,23275,25421,23275,25388,27501,27501,27469,21195,25356,27468,25388,23275,27501,27501,25356,19050,21195,21195,14889,16840,18920,16840,16808,18888,25356,27534,23341,10663,8615,10663,8583,8583,8583,6502,8615,21162,21162,12808,17034,29516,44207,44239,50643,46385,27434,21128,21160,19048,29547,40079,31660,16966,12773,23338,33872,19049,40113,42225,38032,38032,35919,46420,42226,42290,35887,14887,8549,10693,12806,8548,6468,12742,25257,31594,37933,25320,25320,27369,16903,10630,10663,12743,31694,35887,27435,38000,35919,33741,35854,33774,33709,31530,25257,29581,31629,29548,29580,44305,46451,48564,44338,42160,46418,46352,21129,4357,4357,12711,23209,12740,10659,12708,23242,25322,19047,12709,23209,29515,29515,31661,37967,42128,42160,25322,14790,37967,29580,27435,23241,19014,10596,4323,6371,8483,4323,4291,4290,6403,16901,21094,29514,35853,37934,35854,37966,111},
{50809,50809,50841,52890,52889,52890,52890,52889,50841,50841,52890,50841,52890,52890,52890,52890,52922,52890,52890,52857,52889,52889,52890,52889,52889,52889,52889,52857,52857,52889,52857,52857,52889,52889,50809,52857,50809,50809,50809,52857,52857,52857,50809,50809,52857,50809,52857,50809,50777,52857,50777,50777,50809,52857,48696,33938,23406,33971,38197,36116,34004,29811,27698,27698,27763,29811,29843,34037,31956,29876,31924,31891,29810,31891,36052,36051,33971,34004,33972,33972,34004,31891,33971,34004,31891,29745,17034,14889,14856,19081,27501,21195,19115,21228,21195,19115,19083,19115,19115,19115,19115,19115,19083,19082,17002,17002,16969,17002,16969,14889,14857,17002,14889,17002,16970,17002,14889,16969,16970,16969,14889,14889,14857,14889,14921,14921,12841,10696,8615,8583,8583,10663,12809,19148,27469,42127,46384,54837,33707,16934,19112,19080,21128,37999,35821,25321,14886,12805,21192,38066,25323,42258,48564,50709,46451,48532,50710,48629,50710,37999,12741,10693,14918,16966,16966,14821,14854,29514,46319,46318,33705,25320,25321,31628,12678,10631,8582,16903,37967,44337,44305,35887,33773,33774,35854,37934,48498,44240,31628,33741,33709,42193,54903,54871,52822,50644,44272,54903,48564,21096,14790,29417,42028,50380,37800,25286,19014,21161,21096,16966,10628,10564,27467,29515,29515,29515,29483,23177,23209,27467,46482,46450,44305,27466,14821,8515,6403,12676,10628,6403,4323,4322,6370,21062,44239,33675,44338,37999,33741,35886,118},
{50809,50809,50809,52890,52922,52890,52857,52890,52890,50841,52890,52890,52890,52890,52890,52890,52890,52890,52890,52889,52857,52889,52890,52857,52889,52889,52889,52889,52890,52889,52889,50809,52889,52889,52857,50809,50809,52857,52857,52857,50809,50809,50777,52857,52857,50809,52857,52857,50777,50777,50809,52889,50777,38164,23438,19245,21358,31923,34004,33971,31923,31891,27698,27666,25585,27730,29843,29811,29811,29811,27730,29811,34036,31923,34003,34036,31956,34004,34036,33971,33971,38197,38197,38164,36116,29746,17002,19082,21163,31662,38066,23341,21260,23341,23341,23341,23308,23308,21228,23276,23308,21228,21228,21228,21228,21195,21196,17034,19115,17035,17034,19083,19083,17002,17034,21163,21162,19082,19115,19083,17034,17034,17034,17034,17034,12809,10728,12841,12809,10696,10696,14921,14954,19115,23276,37998,46384,54869,40046,14854,16967,19080,16902,25353,19047,16934,21192,16967,21160,40178,33774,46484,48499,40112,37999,46386,44306,46419,35886,23275,14855,12806,10694,14854,16966,12708,12708,33707,52625,52624,44205,29514,21128,42159,29515,10630,10663,16904,18951,33740,31627,21097,29516,33773,37934,35821,48532,37934,31628,25322,33741,48564,54903,54870,54870,54903,46386,42192,37934,40015,50512,54573,56554,56521,46057,31432,23208,19047,16902,16934,10660,8548,27435,29580,29548,29548,27435,14823,25322,42225,46418,46418,42224,23207,12707,8515,6403,12741,12740,8483,4323,6435,6370,33772,50578,33708,46385,40047,37934,35820,124},
{50809,50777,50842,50809,52890,52922,52889,50809,50809,50841,50841,50841,52890,52890,50809,50809,52890,52890,52890,52889,52889,52889,52889,52889,52890,52889,52857,52890,52889,52889,52857,52857,52889,52889,52857,50809,50777,52857,52857,52857,50809,52857,50809,50809,50809,52857,50809,50809,50809,52890,50809,40309,27632,21326,21358,21326,31825,36083,38196,36084,33971,29778,25617,27665,27666,27730,27698,27730,27698,29746,31923,38164,42357,40244,40277,42357,40244,40244,40276,36051,33939,36084,36084,36051,36084,31793,19115,23276,25356,35920,44405,23309,21228,21228,21228,21227,21228,23308,23308,23308,23308,21228,21196,19147,21195,21195,21195,17035,17035,17035,19115,19115,19115,17002,17002,44308,44372,19050,17035,17034,17034,17034,14954,19115,19082,10728,10728,12809,10728,10696,10728,10727,10727,14921,21227,35885,46417,54869,44304,16902,14854,14822,23241,23272,16966,19047,23305,14854,21160,40178,33774,46483,48531,40112,40079,46419,44273,46386,23209,10630,14855,8581,4324,4356,10629,12774,12741,16934,42192,33707,21030,16902,14790,31563,44272,25354,10630,18984,23144,21032,18951,14823,14823,27403,33773,23177,21129,27435,29548,18950,40079,50644,46418,44338,46386,44338,44338,44338,37934,37934,42127,48366,52460,52427,46220,44174,29450,16935,16966,16966,16934,10660,27435,27435,27467,27435,23210,12710,31693,44370,44337,46418,44337,29513,14788,10660,8547,12772,14853,8547,6435,8515,8483,42126,35723,29482,42160,46418,46320,42159,120},
{50809,50809,52890,50809,50809,52890,52922,50841,50841,50809,50841,50841,52890,50841,52890,50841,52890,52889,52857,52890,52889,52889,52889,52889,52857,52857,52857,52889,52857,52889,52857,52889,52857,52889,50809,52857,52857,50809,50809,50809,50777,52857,52857,50777,50809,50809,50809,52889,52857,44470,27664,21358,21326,21390,21358,21326,31825,38196,38197,38132,36084,34004,31924,31859,29810,31923,31924,34004,34004,36052,38230,40310,40277,40245,40277,38164,40244,40277,40277,36084,33939,33971,36052,38165,38132,38132,31728,31728,29647,38065,42292,21195,19147,19115,19115,19115,19147,21228,21228,21228,21228,21228,21228,19115,21196,19115,19115,17034,17034,17034,19115,21195,19147,17002,19115,29582,35888,17002,17035,17034,17034,17034,12809,23308,19115,10696,10696,12809,10696,10696,10728,12775,10695,17002,19114,35884,50643,56950,46417,21159,19079,23208,31627,23240,19079,16934,19015,16999,19048,42227,42194,48531,44273,35821,42192,44273,46419,40080,14855,8549,8549,6436,8517,6469,4356,4324,6436,12774,27500,21194,16935,16967,21097,40079,44272,42127,23209,16904,23112,23144,18984,16904,16936,16936,29548,21097,23178,27435,33708,33709,42094,42159,16806,6371,12677,10564,8451,27434,35886,35886,37934,37901,48530,56983,57015,52724,31628,25387,27466,23272,21159,16966,29548,33741,35886,37934,25355,10663,16936,37999,37998,37998,44240,40013,25351,16965,12740,16965,16932,12740,12740,14821,23240,48465,31530,33676,44240,56983,42061,35755,148},
{50809,50809,50809,50809,50809,50809,50841,50841,52890,50809,50841,50809,50809,52890,52890,52890,52890,52890,52889,52889,52889,52889,52889,52889,52857,52857,52857,52857,52857,50809,52857,52857,52857,52889,52889,52857,52890,52857,50809,52857,52857,50809,52857,52857,50777,52857,52890,46584,31825,21326,21358,21391,21358,21391,21390,19278,27664,42357,42358,38164,40244,36052,31826,31859,31858,29778,29745,33972,31891,31859,34004,33971,31858,31923,31891,31858,31858,31859,31891,33971,31891,29810,31858,34003,33971,33971,36019,29680,29648,29647,25453,19148,21228,21228,19148,19148,21228,19148,21228,21228,21195,21228,21195,19147,19147,17067,19148,19148,19147,19147,19147,21196,19147,19115,21228,21163,21163,19115,19115,19147,19115,19115,17034,23308,19114,14953,14921,14921,10728,10695,12840,12807,10695,19082,21162,37997,52723,56950,40078,21159,23240,27434,23241,23241,25385,12773,14854,16999,21128,44340,50678,48531,44370,37967,48531,48499,40079,16934,8581,6469,6437,6469,10662,8614,4356,4324,6436,12807,12807,10694,8549,12775,16936,25355,35821,33676,29515,27402,27337,25224,25257,21129,14823,16936,29548,35854,46418,37933,42094,42127,44239,44272,14791,2211,21161,37967,33774,35854,35886,35854,27370,40047,54903,52790,42193,35853,40079,42225,31628,25322,16934,12741,25354,35886,37999,40079,29580,10630,10630,25354,44337,44272,46450,54869,44239,23206,16965,16964,19045,16933,12772,8547,23240,35788,29418,33675,35787,39980,37933,31529,175},
{52890,50809,50809,50809,50809,52890,52890,50809,50841,50809,50809,50809,52890,52890,52890,52890,52890,52890,52857,52889,52857,52857,52889,52889,52857,50809,50809,52857,52889,50809,52857,52857,52889,52857,50809,52857,52857,52857,52890,52857,52857,50809,50809,52857,52889,46616,33971,23406,19278,21391,21358,21358,21358,21358,21391,19278,27664,36084,36084,36084,33971,29811,27666,27698,25650,27731,27763,27731,27731,25650,27731,29811,31924,27730,27730,29778,29778,31891,31956,31923,31891,31956,34004,34004,36117,36117,31858,14922,14921,14922,14955,12874,17068,17067,19148,17067,17067,14954,14954,17067,14922,17067,19148,17067,17067,17035,19148,17035,17035,17067,17034,17035,17035,17035,17035,17002,12841,14922,14921,14922,14954,14954,17034,17002,14921,21226,25419,14887,8582,8582,14919,17000,25420,21195,19081,42191,54837,56950,31659,16934,19079,10693,6468,16967,23240,21159,16934,16934,19048,42292,48597,48498,35885,37901,44273,42192,27499,12773,12774,8548,10630,23307,21162,19082,17001,14888,19048,16966,10661,6436,10629,18984,10630,10630,16903,21161,14790,31628,33642,48432,42094,23177,14823,16936,29548,48532,44240,33708,29449,42159,44239,44240,18951,2179,12678,16871,29515,35854,35886,35854,44273,46385,37998,21127,8514,8547,19015,35918,27434,25322,23241,10597,23209,29548,29547,29548,23274,10630,10662,12742,33838,44337,40014,29482,23176,21095,16965,16964,16964,14852,4321,16869,29449,37901,35853,33708,37901,31563,40015,33707,195},
{52922,52889,50809,50809,50809,50809,50809,52890,50809,52890,50841,52890,52890,52890,50841,52890,52890,52889,52889,52889,52857,52857,52889,52889,52889,52857,50809,52857,52889,50809,52889,52857,52857,52857,52890,52857,50809,50809,50809,52857,52857,50777,50809,50809,38164,23406,19246,21326,21358,21358,21358,21358,21358,21358,21358,19246,27632,33971,31891,29778,29778,27698,25618,25650,25650,27731,25683,25650,25618,25617,27731,27730,29779,29811,27730,27698,29811,31923,29778,29811,31924,31924,31892,31891,31923,34004,29745,21261,21261,19213,21261,21294,19213,21261,21293,23374,21325,23374,21293,21261,19180,21261,23373,21293,21293,21293,23341,21293,19148,21228,21228,21228,19147,19148,19148,19115,17002,17002,14921,17002,17034,17034,17034,19114,19114,23307,25419,17000,14888,12775,14920,17000,27500,21195,16968,44337,52725,42225,27434,19047,14854,8582,8549,16967,16934,33805,31692,19079,16967,42259,48532,50644,42160,46418,48564,50645,38031,12805,19080,19114,14888,27500,14856,12776,17002,10630,19111,16998,10628,6436,16935,37934,14790,10630,12711,12711,12678,23144,27336,33707,25289,16904,14856,16904,27435,46451,46419,46386,33643,42094,42159,42159,21064,2178,12678,14790,31661,35854,35822,37902,44337,40110,19045,12772,14852,10627,14853,21159,33740,35854,31661,12710,23209,29580,29548,29515,18984,12775,10662,10630,21129,42224,31562,21064,14790,10629,19045,16996,16932,16965,14820,44272,37868,44305,42160,31562,35820,29482,35821,42127,220},
{52889,52857,50809,50809,50809,50841,50809,50809,50809,52890,52890,50841,50841,52890,50841,52890,52890,52857,52890,52889,52857,52857,52889,52889,52889,52857,50809,52857,52857,52889,52857,52889,52889,52889,52857,52857,50809,50809,50777,50809,52889,50809,52857,48729,34004,25584,21358,21326,21358,21358,21358,21358,21358,21358,21326,19245,29712,38229,34004,31891,29811,27698,25650,25618,25651,25618,23570,27731,25618,25586,27763,27763,29843,29843,27731,29810,31891,34004,31858,31826,31859,29746,29778,31891,29811,29811,29778,23406,23374,23374,23374,23374,23374,23374,25487,25487,25519,27599,25487,25454,25454,25454,25486,25486,23373,25454,25454,23406,21261,21261,23341,19147,19147,21228,21228,19148,17002,17034,17034,17067,19115,17066,19147,21227,21227,27500,25387,21161,21161,16968,14888,14888,12775,12775,17001,33806,31629,25355,25321,23240,12806,10694,10661,21192,25386,42192,44305,29580,16935,40177,48564,50676,50611,52756,50644,44305,27434,16934,29646,33873,21227,33807,35887,33742,23275,14953,14919,14918,12806,6468,6403,35853,33741,12710,12711,16936,35854,50513,31529,25192,14790,14791,14791,14824,19016,25290,25257,21031,23144,40046,42159,31628,23210,14823,33774,40080,35886,35886,33708,29483,42160,29578,14852,16964,16964,14852,12772,6467,19048,27403,25354,12742,25354,31693,27435,31628,31628,40112,33773,23209,14790,29547,33740,23176,12677,8516,14852,16996,12772,10626,31659,44273,35821,46386,40047,20998,35788,31595,29515,54870,213},
{52889,50809,50777,50809,50841,50841,50841,50841,52890,52890,50809,50841,52890,52890,52890,52890,52890,52889,52857,52889,52889,52890,52857,52890,52890,52857,52857,50809,52857,52889,52889,52857,52889,50809,52857,50809,50809,50841,50809,50809,52857,52857,52889,48729,38230,38262,34036,25552,21326,21326,21358,21358,21391,21359,21358,19246,29744,36116,31891,31924,31923,27731,25650,25650,25683,25651,27731,25683,25651,25651,27764,27763,27796,29843,29811,34036,34004,34036,36084,33971,31891,31891,29843,31923,29843,31891,31956,29745,29713,29745,29713,29713,29745,29778,29778,29745,31858,33938,31826,29745,29745,29712,31826,31793,29713,29712,27599,25487,21261,21261,21228,21195,21228,23340,23341,23308,21195,21195,17034,17001,19114,17002,21227,23340,23340,29612,27499,21128,21161,16968,10695,10663,8549,10695,12776,23243,23308,23307,23241,19046,17031,16998,16966,23240,33740,44305,42192,29612,19015,42257,50677,50644,50611,48530,50610,42159,16934,14886,27533,33840,25388,46485,44339,38000,21129,14887,14886,8580,10660,10693,10629,33708,44272,31595,12678,16838,40014,52592,41995,23079,12645,14823,16936,16904,18984,25290,27403,23177,23210,35853,40047,25322,23243,8485,18983,31628,35886,33806,37934,52693,25322,10661,14886,14885,14884,16997,16997,6435,16936,25355,27402,14823,25354,42225,23209,29548,29547,31660,42192,46450,42192,37933,31659,14821,16901,16966,14884,12771,14852,12739,31627,37901,33741,40046,46419,40014,42126,33708,37934,57015,217},
{52889,52857,50809,50809,52890,52889,52857,50841,52890,50809,50841,52890,50841,50841,52890,52890,52890,52889,52889,52857,52889,52889,52857,52889,52857,52889,52889,50809,52857,52889,52889,50809,50809,52857,50809,50809,50777,50809,50809,50809,52857,52857,52857,50810,38229,38262,36182,36182,31891,23471,19245,21326,21358,21391,21359,21358,23406,38098,38098,40179,40211,33970,25520,27698,27633,27665,27633,29778,27730,27730,29811,29843,29811,29843,29811,31891,31923,31924,31923,31923,31923,34004,31956,34036,34004,34004,34036,36084,36084,36116,36084,36084,36084,33906,36019,33938,31825,31857,31825,36019,33938,31793,31857,31825,33938,31858,29647,29679,31792,29647,21228,27533,27501,27533,31695,31727,33839,29646,27501,23275,23339,23275,23307,23340,21226,33773,44371,19081,14856,25356,8582,8582,8614,10663,12808,23308,23308,21161,21192,19079,16998,16999,16998,19078,31659,46353,31628,19016,19047,44305,50677,48531,50611,48498,50643,29579,10660,23273,29580,46419,27436,19017,29549,27501,16969,16999,16998,12773,6468,6468,25354,46419,44272,40014,29482,42095,54772,56917,50577,16870,12645,23242,16936,16968,16936,23209,40047,16903,8517,31596,35854,21162,23242,6404,14823,29548,35887,35886,35853,46353,25290,14823,14790,10596,10628,8548,10661,10661,19048,27403,29516,29548,37967,44338,27435,23274,21161,12677,21064,37999,40078,27465,16933,16933,16933,12707,16964,14884,16964,14852,25353,35821,33740,40014,54837,40045,33707,37933,50644,56982,219},
{52857,50809,50777,50777,50809,52890,52890,50841,52890,50841,50809,52890,50841,50809,52890,52890,52890,52890,52889,52889,52889,52889,52889,52890,52857,52857,52857,52889,50809,52857,52857,52889,52890,52922,50809,50777,50809,50777,50809,52857,52857,50809,50809,50809,42390,38229,36149,36182,36214,36149,29778,23439,21326,21390,21359,19278,23406,40146,54936,54936,54969,44405,21195,31760,25421,31760,31727,27534,31760,29614,29614,31791,29679,29646,29679,31759,33873,33872,29679,33904,29711,33872,36017,33905,33905,35985,33905,35985,33905,33905,33905,35953,31791,31759,35984,35952,31727,25421,27501,33807,27501,29581,27501,27533,27501,27500,29582,27501,25420,27533,25388,25388,27500,29581,29613,29614,29580,27500,27468,23307,27500,25387,27468,27501,25387,35886,33773,14855,12775,25388,10695,8615,8582,10695,14888,23308,21227,16967,21160,23272,21191,17031,16998,21159,37998,44305,31628,23242,16967,35853,27402,33741,37934,23176,21160,21159,10693,12774,31693,40111,19016,25356,35888,29582,14856,14886,16965,19110,12773,8548,14789,38032,42160,31563,29450,39948,44174,35787,16902,10564,16902,25354,14824,16904,19016,25322,48466,16870,10598,29515,23177,19049,23242,10565,14823,31693,35886,35886,35886,50644,31629,31629,31661,14790,8451,10628,19047,40112,31661,27403,29548,31628,33709,29548,25322,12710,14790,14823,12710,16902,25320,16900,14820,14820,10627,12772,16964,16964,14853,8547,21128,33773,40047,37933,33642,35722,33643,40046,56983,56917,223},
{52889,52889,50777,50809,50809,52890,52857,52890,52890,52890,50809,52890,52890,52890,52890,52890,52890,52889,52921,54970,52890,52889,52857,52890,52857,50809,52857,52889,52857,50809,52857,52890,52857,52857,52857,50809,50809,50809,50809,52857,50777,50777,50809,52889,50809,46616,38262,36181,36214,38262,38295,36149,27697,21358,21326,19278,23439,40211,48598,46517,46516,48598,42259,44404,42291,44404,44404,44372,46484,44404,44371,46484,46452,44339,44372,46452,46485,46485,44339,44371,44371,44371,44403,44404,44371,44371,44371,42291,42291,44371,40178,42226,40113,44371,44371,42290,44372,42291,42258,44339,33742,42194,42259,42226,42290,42258,44339,42259,42259,42258,40145,40113,40113,40145,40178,40145,40113,40145,40145,38000,40112,40145,42225,42258,40112,40145,23241,14887,19081,19082,8582,6502,6502,8582,14921,21195,21195,19112,21192,21159,21159,27466,21192,21127,42192,44305,35886,21194,6469,19048,21161,29548,31692,16934,12773,16998,10661,10596,31660,33741,16904,19049,31694,27501,16969,17000,14886,19110,19110,12773,4323,12743,25322,21097,12710,31595,33609,19014,8580,6403,33773,29515,16904,16936,18984,25289,46385,23145,27435,37902,35789,18984,23275,10597,8516,14854,35854,35886,37934,52789,33709,12678,21161,27468,19015,14853,14853,29611,35886,27402,27467,31596,25290,19016,33741,35854,37934,33709,16935,14855,21127,19045,12739,8547,8547,10691,12740,8515,4290,6370,23273,46418,37933,35821,29515,40079,29449,44304,57015,54869,203},
{52890,52890,50777,50841,52890,52857,52890,52890,52890,52890,50809,52890,52922,52890,52890,52890,52890,52890,52889,54938,52890,52889,52889,52890,52889,52889,50809,50809,52889,52857,50809,52857,52857,52857,52890,50809,50841,50809,50809,50809,50777,50809,50809,50809,50777,50809,48729,42455,38230,36182,36214,36214,38262,34069,25584,21326,21326,25519,25519,27567,31759,52823,52857,54937,52824,52856,52888,50744,52824,50743,50743,52856,50711,52824,54937,50711,52824,52856,52824,52824,54969,50711,52823,50711,50678,52823,50678,48630,50743,52856,48597,50677,48565,50679,50743,48597,50743,48597,48597,52855,48564,52791,52857,48564,50742,48565,52824,54904,46452,48629,48629,52823,52823,50677,48565,50742,52823,50742,52823,46451,48564,50677,46451,50710,46483,50645,21161,12807,6469,8582,8583,6470,6470,8615,17034,21195,19115,21193,19079,16967,16934,27466,21127,19047,42192,40079,25321,12774,6469,10694,23275,27435,25353,19047,12773,16966,10661,27435,42192,33773,40113,38032,31661,23275,16969,19049,16999,14853,19078,14887,8517,8518,10663,10630,14758,29449,29481,14853,10661,14821,33740,21097,16904,16904,16936,23209,46385,23112,37935,37934,35788,14855,14887,6436,6500,6468,21128,35886,40079,57016,35855,4292,4324,8485,16966,16965,12836,14852,25321,27467,27435,18984,14888,12743,21129,35886,35788,21096,10597,21129,25352,16965,16964,12739,6434,6434,8547,4323,4258,4258,21128,50612,35788,31594,27337,46418,42093,54870,56950,52691,164},
{52889,52889,50777,50809,52890,52890,52890,50809,50809,50841,52890,52890,52890,52890,52890,52857,52857,52857,52889,52889,52889,52889,52889,52890,52889,52889,52889,52857,52889,52857,52857,52857,52890,50809,50809,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,48696,42423,38262,36214,36214,38327,38295,34004,25552,19245,21326,21326,23438,38164,31792,38131,31760,35985,35985,33840,35954,33872,31760,35985,33840,35953,38066,33840,35986,38098,38098,40179,42259,38065,40178,38066,35953,40146,35985,35985,42258,40178,52724,54837,48465,50611,50612,50580,50579,50579,50579,50612,48498,50645,50645,50579,50612,50612,52692,50644,48499,54904,48598,46484,44372,40178,46420,48598,46452,48597,48565,44371,40145,44338,40112,46452,42225,50677,25354,12775,6502,8615,8583,6470,6470,10695,19082,19115,17002,21162,23273,21127,19047,16966,19079,12709,31660,31693,16935,14919,8549,8549,29581,25321,19111,16998,12741,14886,19112,31693,35919,33774,42192,44273,35854,21129,16969,16968,16967,14886,16934,14855,10630,8517,8582,16903,42160,52658,29448,16934,4356,14822,33740,35822,16871,16936,16904,21129,46385,25225,37935,33708,14758,16903,16998,10692,12773,8580,8515,27434,48531,54870,37967,12678,14856,8517,14854,19078,16965,16997,19079,27467,29516,18983,21129,10663,8582,25355,46418,40112,19048,14823,19047,16964,16997,14916,8546,8579,8579,6403,6403,4291,14822,46451,42159,40046,31563,29449,52691,56950,52722,46351,182},
{52889,52857,50809,50809,52890,52857,52890,50841,50809,50841,52890,52890,52922,52890,52890,52857,52890,52857,52889,52889,52857,52857,52857,52889,52889,52889,52857,50809,52857,52889,52889,52890,52890,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,50809,50809,50809,50809,52890,48697,40375,36182,38263,38295,40375,38294,31890,23439,19278,19278,19213,19245,19246,17132,14987,15020,17068,12907,14955,14955,12874,12907,12874,12874,12906,14987,17100,19180,19148,23308,23340,21260,17034,14922,14922,14922,14922,14954,16937,46288,58899,48335,46190,46189,46190,46223,46222,44173,44141,46222,44142,44142,46222,44142,44141,44141,44109,44109,54838,35888,25388,21163,16970,27469,27469,27436,38000,25354,21160,14823,21161,25321,21160,19047,42160,27499,12807,8583,10630,10663,6502,6470,10695,17034,19082,17002,19114,19047,23273,19047,16902,19080,6469,16968,31661,16967,12806,6469,12775,23273,19046,12805,16966,16999,16967,21161,33806,38032,38000,40112,50612,37999,29614,16969,16968,17000,12742,14855,12775,10630,8550,10630,21096,42094,50480,29416,12741,4356,12741,37966,42160,19017,16936,16904,21097,46353,25289,35822,29451,10598,14855,19048,19112,21191,16965,10692,12709,19047,14789,21095,19049,8518,12711,16903,14854,14853,14852,19079,25322,31693,33741,37967,21129,10663,10630,33773,37966,29515,14822,12740,16965,16964,16997,14916,16996,12772,6467,4355,4291,12676,48531,54870,42126,35787,37899,56983,56950,52723,44272,180},
{52889,50809,50777,50809,50809,52857,52890,50809,52890,50841,52890,52890,52890,52890,52890,52857,52857,52890,52889,52889,52857,52889,52889,52889,52857,50809,52857,52857,52889,52857,52889,52890,50809,50809,50809,52890,50841,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,52857,50777,52857,52857,50809,46648,40342,38262,38295,38295,40407,40342,31858,19245,19246,17165,21326,17133,14988,15020,15052,12907,14987,15020,12907,12907,12939,12907,14987,17068,17067,17100,19180,21260,23340,23308,17067,14955,12874,12874,14954,14955,16938,48336,54737,46223,46223,46221,46190,46223,46254,46222,44142,46190,46189,44141,46189,44141,44141,44141,44141,44141,48499,31728,23309,19083,19051,27469,27501,29581,38000,19112,23306,19081,21161,23241,21193,16935,37967,27435,19080,14856,16968,25387,21097,10663,10695,19082,19083,14921,19082,19047,16934,23241,21160,16935,8549,19016,29548,21192,10661,8582,27500,23240,19078,14886,16967,19048,21129,25289,33806,40080,44305,52757,44241,35854,35920,23275,14888,12775,12807,12775,12711,10662,10565,25225,48433,54804,37933,18982,10629,8516,23208,50676,40047,18984,16936,16904,21097,44272,31563,35789,33709,14823,16936,21195,25388,21129,21160,14917,14886,10693,8548,12774,8517,14856,14791,12645,14788,16965,16965,14853,27435,23242,12678,29547,44305,31660,23242,23175,16901,14821,14822,8547,19046,16997,16964,19077,19077,14853,10628,4323,4291,10531,40079,46352,33643,33706,52723,56983,56982,44174,42159,188},
{52889,52857,50809,50809,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52889,52857,52857,52857,52857,52889,52857,52889,52857,52857,52890,52890,52890,52889,52857,50809,50809,50809,50777,50777,50841,50809,52857,50809,50777,50777,50809,52857,50809,52857,50809,50809,50809,50777,46616,40374,38294,40375,40407,44568,40310,29777,19213,19278,17100,12907,14987,14988,12874,12907,14955,12875,12874,12907,12907,14955,14987,14987,17100,17034,19148,19180,21228,14954,14922,12842,12874,12874,12841,16937,50480,54706,46222,46221,46189,46221,44140,46222,46222,46189,46221,46188,46188,46221,46221,46221,46221,44141,46189,40013,33808,27534,21195,21163,31726,27533,27436,33773,21225,23273,17000,16968,21161,21225,19048,35919,31693,19112,21193,21193,31595,37804,33774,17002,19115,19082,12808,16969,23275,21161,38031,35886,14822,10662,19113,29548,19047,10694,6436,14822,19079,16966,16966,25354,21097,29515,35854,33773,35918,40112,48531,35854,31596,33742,21195,12775,10663,19081,10630,10662,12711,12710,29449,23142,21062,23207,16934,10693,14854,27367,50643,42160,16903,14856,16904,21097,42159,37901,31595,35822,19049,23243,21162,23275,19082,19049,17000,14855,14919,10629,23242,16936,35887,23209,14757,23239,25350,23238,16966,25322,19016,16936,42224,46450,46418,44305,35852,21094,14821,10628,4355,10596,16997,16997,19077,19046,12740,14821,8516,4323,2210,25321,44174,33708,31561,56982,56983,50578,31562,40014,179},
{50809,52857,50809,50809,52889,52890,52890,50809,50841,52890,52922,52890,52922,52890,52890,52890,52890,52890,52890,52889,52889,52857,52857,52889,52890,52889,50809,52857,52857,52889,52889,50841,52890,52857,52889,50809,50777,50809,50777,50809,50809,52890,52857,50809,50809,50777,50809,50777,50809,50777,50809,50809,50809,50777,50809,50777,46648,40374,40375,42488,44568,46648,36116,27697,27697,25584,23471,23439,23439,23406,21326,21294,21326,23406,21326,21325,21293,23373,23373,23406,23406,23405,23405,21293,19212,19180,21261,21261,21228,23308,37934,46319,46188,46221,46222,46221,44140,46189,46222,46221,46253,46253,46221,46221,46221,46253,46220,46221,46221,44239,42259,38067,25389,23276,29613,25420,31629,40079,27499,19112,16968,19080,17000,19080,14887,38000,33806,19112,17000,17000,31660,37934,31694,12808,12744,12776,10663,16970,14824,19017,23209,23241,16935,12742,19080,31694,23241,10661,8549,16999,21159,19110,19078,23241,25290,31596,27337,27435,38064,37999,33741,23242,33774,38001,19082,17001,14856,21162,8517,12710,14791,16903,25256,16934,16935,25353,16934,8516,23240,40045,54804,46418,21129,16904,16936,19016,40079,35756,31595,37934,33774,25387,19081,21227,19114,17001,16969,12775,12775,16936,33742,16903,21161,31661,27435,14757,18981,27466,25322,25322,23242,31693,46450,44369,44337,46450,42159,23207,12740,12773,10660,10595,14885,19078,21158,19046,10628,16966,10628,4291,2178,25289,44239,39981,42191,59063,56918,37835,31627,37933,163},
{50777,50809,52857,50809,52890,52889,50809,52890,52890,52890,52922,52890,52890,50841,52890,52890,52890,52890,52890,52889,52890,52857,52857,52857,52889,52857,52857,50809,52889,52889,52889,52890,50809,50809,52857,50809,50777,50809,50809,50809,50809,52857,50809,50777,50777,50777,50809,50809,50809,50809,50809,50777,50809,50777,50777,50809,50809,48728,46616,44535,44503,44536,42455,34068,34068,31955,29810,29810,29777,29810,29777,27664,29745,29745,27664,27664,27664,29712,27664,27632,27632,27632,27599,27599,27599,27599,29679,29679,29712,29711,31726,40047,42126,42126,42127,42094,42126,42095,42095,42094,42094,42094,42062,42062,42094,42093,44174,42061,39948,46321,33841,29615,21195,17002,23276,23276,35887,37966,29548,23273,19113,21193,17032,17032,14855,21194,25355,19080,12807,12742,35821,29549,29581,12776,8550,14856,27469,38034,23210,21064,19016,21128,19015,19048,27435,27468,25354,10693,10661,19111,21191,16998,21159,29481,37902,23177,23242,23274,12710,25323,31662,21130,23243,35953,19082,14889,17001,16937,8517,10662,14823,21096,25256,21127,35919,23272,12741,10628,48530,52691,48497,46417,33677,14824,16936,21097,40047,35821,31628,42127,33741,35887,27500,23275,19082,17001,19050,10662,12743,25323,35855,12743,4324,6404,14790,19016,12709,12677,12710,21129,14856,19048,37999,46450,42224,33740,23175,16901,10627,14853,16965,16965,16965,14853,12772,19046,10596,12741,4322,2210,2178,21129,37933,44239,56950,56949,50578,42127,40014,40046,154},
{50777,52857,50809,50809,52890,52890,52890,52890,52890,52890,52922,52890,52922,52890,52890,52890,52890,52890,52890,52889,52890,52857,52889,52889,52857,52857,52857,52857,52890,52889,50809,50841,52889,52889,52857,50809,50809,50809,50809,50809,52857,50809,50777,50809,52857,50809,50809,50777,50809,52857,50809,50777,50777,50809,50777,50777,50777,50777,50809,48696,46648,44536,40375,31955,34036,31923,27729,29778,27664,29777,27664,27632,27664,27632,27599,27632,27599,27631,27632,27599,27599,27599,27599,27567,27566,27567,27599,27599,27598,29679,29647,29646,29646,29646,27533,29646,33839,31694,27533,29613,29581,27468,27436,27436,27436,27436,31661,29580,18984,29581,29647,23341,21164,19083,17035,21196,40080,33741,21162,25386,19113,14920,12839,14919,17032,10662,12807,17000,10695,16968,42160,29516,27469,12809,8550,29646,50743,50678,27403,21032,23177,23176,21160,23208,29548,23275,25386,14919,10693,19079,19078,16998,19045,40078,42160,23177,25387,29645,12710,27468,31727,23308,25389,35953,21162,12776,23307,14856,8549,12711,14791,16838,27369,21127,29580,23240,10596,18982,37869,40014,37900,39980,31596,14856,16936,18985,35854,37934,27434,37934,16871,21097,25355,19081,14889,19082,16936,12743,14856,31661,35887,16839,12678,23242,35919,48564,35918,16935,10662,12775,10695,10663,14823,37966,46417,35820,21125,19044,16932,14820,16964,19045,16932,12772,10660,12773,12708,8516,4291,2211,2178,19016,33708,48466,56982,54803,48431,46385,37966,37966,157},
{50809,50809,50777,50809,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52857,52890,52890,52889,52857,52889,52889,52889,52857,52890,50841,50809,50809,50809,50809,52857,50809,52890,50809,52857,50809,50809,50777,50809,50809,50809,52857,50777,50777,50777,50809,50809,50777,50777,52857,50809,50777,50777,50776,50777,50776,50777,50777,48696,40375,34035,34036,31923,29810,27697,27665,27665,27632,27664,27664,27632,27600,27632,27632,27664,27599,27599,27599,27599,27599,27599,29679,29679,31727,29679,29646,31727,29647,29679,31759,31727,29678,31759,33871,31726,29581,27502,25421,25356,23308,23308,25356,23275,31662,33806,16904,25420,29647,23309,19050,19083,17002,23276,37999,35854,23275,21161,21193,17000,12775,14887,19112,14888,10694,17032,19112,19048,29548,33741,27469,12809,8583,10630,27501,48597,29484,25193,25257,23144,25289,25321,23241,23243,23274,10694,10661,16998,14886,16998,21191,27401,27370,23177,23242,21129,12711,25356,42260,27469,21196,35953,21195,12776,31758,23275,6437,10663,18984,31562,31561,21127,14886,19046,16901,42192,37901,35821,29449,31529,25322,16936,14856,19016,35821,37967,21063,40047,16871,16904,16904,16968,12776,23275,19017,10598,25323,33806,33773,37967,50710,57016,54903,50644,35853,23209,19049,12775,10695,10695,10630,19015,33707,31626,25350,21157,21157,19045,14852,16965,19077,10660,12773,12741,12741,10628,6403,4290,4290,14822,42159,56950,54869,54836,52690,46385,37966,37933,155},
{50777,50809,52857,52857,50809,50809,52890,52890,52890,52922,52890,52890,52922,52890,52857,52890,52890,52890,52890,52890,52889,52857,52857,52889,52857,52857,52857,50809,50841,50809,50809,50809,52889,52857,50809,52890,50841,52857,52857,50809,50809,50777,50809,50809,52857,50777,50777,50809,52857,50809,50809,50809,50809,50809,50809,50776,50777,50776,50777,50744,50777,46584,40342,42423,38197,34036,31923,29811,27730,27698,27665,29778,31858,31891,29713,29777,31857,31858,31858,29777,27632,27600,29680,33873,42292,42291,46419,46451,44338,46419,42259,38033,48533,48532,46483,46483,46483,46451,50613,35920,27502,27502,23275,25388,42226,31596,33709,37934,21097,31727,31728,23341,17003,17035,17002,27502,40079,37934,27499,21160,23273,21193,12807,12775,19112,17032,12807,12775,27465,21158,29548,29549,27469,12808,10695,8549,6436,17001,19017,37935,35854,21096,14758,27468,25355,25388,19047,10693,12773,19111,12773,10693,16966,25321,25290,23242,23242,19049,12776,21130,46421,31663,19018,35953,21163,14888,38065,31694,8550,10631,18952,37803,44140,16902,8516,12741,23207,52724,48433,50612,44272,46354,25290,14856,16937,19017,33709,42127,21096,42128,16871,16936,19016,21130,19049,29614,40112,40081,35855,35822,33774,37934,42192,48563,52756,33707,27369,29547,33742,19049,10663,10662,12742,19014,14788,10594,19077,19077,19077,16964,14853,14820,19045,8548,12741,16934,16934,10596,6371,4323,4290,16934,54804,59030,56949,56884,59030,50579,37966,40014,155},
{50809,50809,50777,50809,50809,52890,52890,52889,52890,52922,52922,52890,52890,52890,52890,52857,52890,52857,52890,50809,50809,52889,52889,52857,52890,52889,52890,50809,50809,50809,50809,50777,50809,52857,50809,50809,52857,52857,52857,50809,52857,50809,50841,50809,50777,50809,50809,50809,50809,52857,50809,52857,52857,50809,52857,50809,50776,50777,50809,50809,50777,46584,40342,42423,40310,36084,31924,29811,27730,27698,27698,29778,31858,33939,29745,31858,31890,31857,31890,31890,27664,29713,29680,33873,42292,44339,46419,48499,46418,48531,48565,44339,46419,46419,44338,44338,44338,46386,48531,33807,23309,25422,23276,35856,48532,33644,37870,40015,19017,35920,29647,23341,17003,17002,19083,33775,42127,37934,25354,19048,21225,21225,14920,12807,19112,19112,14919,8614,19079,21191,16968,25355,33742,25323,19114,19082,19082,19050,23210,50645,42225,19048,12742,21162,23275,27468,21127,16966,12774,19111,19078,12805,16967,31660,25258,23210,19049,21162,14856,14823,27468,27502,23276,33808,21162,25355,38064,25355,14856,10630,18952,25224,35754,10596,6469,8516,21128,37836,54839,52692,42095,40014,27402,16904,16937,19017,31660,44240,23176,42160,18952,16936,16936,19049,19017,25356,25387,23209,35854,35886,35822,35854,35853,37934,42191,27465,12740,16934,19017,14856,10662,12711,19015,23239,14820,10627,16965,12739,14884,19077,14852,14852,16934,6469,6436,19048,21160,8516,4291,4291,4291,10596,29417,27336,29416,29416,29481,40046,42127,37933,152},
{50809,50809,50777,50809,52890,52922,52890,52890,52890,52922,52922,52890,52890,52890,52890,52890,52890,52890,52890,52890,50841,52890,50809,50809,52890,50809,50809,50841,50809,50777,50809,50809,52889,52857,50809,50809,52857,52857,52857,52857,50809,50809,50809,50809,50777,50809,50809,50809,50809,52889,50809,50809,50809,50777,50809,50809,50809,50777,50777,50809,50777,46616,42423,40310,40310,36117,31924,29811,27730,27730,27730,29778,31858,36019,31826,33939,33938,29777,29745,29745,29745,31825,29680,33905,40211,42291,40113,44274,46386,48499,44339,38000,46387,46354,42225,42225,44273,42160,40112,35888,21196,23277,23309,27469,44339,35789,42096,37934,21065,33774,38098,29680,19083,16970,23309,27468,39982,37934,31693,19080,21193,25386,14920,10662,14920,14919,17032,12807,21161,16999,8549,21096,44273,31661,19049,16969,23243,23276,29516,50677,38032,25387,25387,21163,23276,31629,29515,19081,10662,14854,16998,19110,19047,37902,27403,14856,14823,27501,16936,14856,25356,25388,23308,27469,21130,33774,33807,12743,19050,12710,18985,21063,23239,10693,6468,8516,12677,46386,54871,42063,52757,42127,27402,16904,16936,19016,29515,46321,23144,44240,18984,16936,14823,21130,23274,23275,23275,23242,33774,35854,35822,35821,35821,37901,40046,27401,21126,16934,10630,19049,25354,25289,23208,21158,14852,12740,16965,14884,19045,19044,23272,27467,16936,6404,10663,16969,23241,8483,4290,10596,8516,2210,2178,4290,4258,2210,4290,25288,37933,35820,166},
{50809,52857,52857,52857,52890,52890,52890,52890,52890,52890,52922,52890,52890,52890,52890,52890,52890,52890,52890,50809,50841,50809,50809,50841,50841,50841,50841,50841,50809,50809,50809,52857,50809,52857,52857,52857,50809,52857,52857,52857,50809,50809,50809,50777,50809,50777,52857,52857,50809,50809,50809,50809,50809,50777,50777,50777,50809,50776,50777,50809,50777,46616,40342,40310,38165,34036,31956,29811,27731,27698,27698,29810,31891,36019,36019,31858,31858,29745,27664,29745,29744,29745,29712,33938,40211,44371,40113,44306,46386,48498,42258,40145,44338,44306,44338,42225,44273,42193,40080,42194,27404,25357,25389,23276,38033,31629,40080,46386,31629,33775,35986,29647,21196,21196,19082,25355,40014,37901,23241,16968,19081,21193,14920,10695,17000,12839,17031,19080,21192,21192,14887,23241,52725,31661,19049,14888,23243,25356,35855,46451,33774,21162,23242,23276,23276,27435,31629,25323,14856,12743,14854,23304,23272,31563,27339,18985,25290,29581,14824,23308,25421,21228,23308,31662,23210,38032,23307,8583,14856,14791,19017,18983,19046,10693,10661,8548,25321,37867,46320,35821,44273,37837,31595,16904,16936,16937,23210,44272,25289,44240,19016,16904,21162,27468,35920,27500,25355,33741,35854,35854,35854,35854,35853,42192,44240,37933,42224,25321,12710,10662,31693,40111,33708,27432,19045,14852,19077,16932,12740,21125,31658,37999,27435,8517,17001,17001,27402,12741,8548,12740,8548,6403,2210,6371,4258,2178,8483,31626,35788,27402,119},
{50809,52857,52857,52857,52857,52890,52890,52922,50841,52890,52890,52890,52890,52890,52890,52889,52857,52890,52890,52890,50841,50841,50841,50809,50841,50809,52890,50809,50809,50809,50809,52857,50809,50809,50809,52857,50809,52857,52857,50809,50809,50809,50809,50777,50809,52857,52857,50777,50809,50776,50809,52857,50809,50809,50777,50777,50777,50776,50777,50777,50777,46583,40342,42423,38197,34036,31924,27698,27731,27698,27666,29746,31858,42325,38099,33938,31858,29745,29713,29777,31825,31793,29680,29712,40211,42291,42258,48499,46385,48531,44306,42225,44370,44306,46355,44306,44306,44306,46386,46322,37903,31598,25356,23243,33840,31597,40015,50612,27436,31727,31760,25421,25421,23341,17002,23275,37934,42094,46386,27500,17000,23274,10695,12807,21225,17000,19112,25384,21192,14855,14855,29547,56984,33710,21130,14888,21195,25355,42161,48597,21161,8517,21161,38065,23275,23210,35855,29516,16936,12808,12743,19080,23272,46386,29483,23177,25290,25355,14856,23309,27502,23309,27533,40113,31694,38000,14888,8583,10663,16936,21065,18983,21159,10628,10693,8548,37966,54837,40013,27401,25224,23112,27402,16936,12775,16904,23209,44272,25288,46386,21064,25323,27436,27468,33807,29548,27403,33741,35854,35886,35854,33773,37934,52822,57016,54935,54935,50612,18984,10630,16936,42225,48497,37964,19045,16997,19077,12740,6435,10627,16933,8450,12742,16969,17034,16968,21128,14821,14854,14821,16934,12741,6403,2178,4290,8547,14853,23143,35820,33676,127},
{52857,52857,50809,52857,52890,52889,52890,52890,52890,52922,52890,52890,52890,52890,52890,52889,52890,52890,52890,52890,50841,50841,50809,50841,50809,52890,52890,50809,50809,50809,50809,52857,50809,50809,52857,52889,52857,50777,52857,52857,50809,50777,50777,50809,50809,50809,50777,50777,50809,50777,50809,50809,50777,50777,50777,50777,50777,50776,50777,50777,50777,46616,40342,40342,40278,36085,31924,29779,29811,27730,27698,29746,31858,42293,35987,31858,31858,31858,31858,31825,29777,29713,31793,36018,42324,42323,42258,48532,46418,48531,42225,42225,44305,44306,46354,44274,42258,42225,46353,44241,48467,33743,25357,25356,40146,31597,37967,42193,25323,31663,40179,33840,31727,29614,25421,29548,37901,40046,52757,27499,19113,23274,8582,10695,21193,17032,16999,29577,21191,14887,12709,33707,52725,31629,21130,14856,23243,25356,37999,29612,14854,14854,31660,57049,33806,29549,31693,25388,10663,12743,12775,25322,27402,44305,27337,27402,33709,29548,14856,23276,27534,25389,25420,33774,35920,27468,10663,17002,17001,21096,25322,21127,19078,12773,14853,12741,35853,56984,35755,44305,37901,29385,27338,18984,14824,21162,27402,46385,25224,44305,29483,33774,27403,27436,33774,29581,29548,35822,35854,35854,35854,33773,40079,46321,48465,50643,44272,37933,27435,25355,16935,27434,33772,25351,16965,16997,19045,16965,12772,21128,27434,10597,16968,21195,16969,19048,23208,16934,12708,12740,14821,16966,8516,2145,10628,12772,10596,27402,33707,35821,154},
{52857,52857,52857,52857,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52889,52889,52890,52857,52890,52857,50809,50809,52890,50809,50809,50809,50809,50809,50841,50809,50809,52857,52889,50809,50777,50809,50809,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50777,50809,50777,50777,50777,50777,50777,50776,50744,50809,46616,40343,40310,40310,34037,31924,29811,29811,29778,27698,29778,31859,40212,42260,33905,33938,29745,29745,31858,29745,27599,27600,40244,38066,31792,38097,46451,46418,48531,46387,46387,44306,44338,44339,44307,44306,44338,46451,40015,48499,29550,25324,27437,42292,31629,35822,40112,29581,27469,23309,27534,27501,31727,31727,33709,39982,35853,37999,21161,19080,23274,10663,6502,14888,17032,21192,29609,25352,19112,14822,35821,44307,29581,21162,21129,23275,25356,38000,42225,29611,21127,27434,52855,35919,16967,16967,14855,8582,10662,21129,29548,27403,31660,42128,35789,25354,29548,19049,21195,27534,23308,23276,38000,29581,12776,10663,25388,42226,46353,46352,29512,19078,19078,16966,16901,42225,50580,37837,42127,46320,44176,29483,16936,19017,23210,25289,48466,25223,44240,37902,37967,35855,29548,38032,33774,33774,35854,35854,35854,35854,35886,50612,44240,40015,33741,16869,10628,10628,29612,40112,27401,14821,19014,19077,16965,16965,19109,19077,29611,42193,23177,29580,27468,16969,21129,21095,14821,12708,12709,12741,10628,4323,4226,14820,10595,8451,21096,23111,31562,179},
{50809,52857,52889,52890,52922,52922,52890,52890,52890,52890,52890,52890,52890,52890,52889,52857,52889,52890,52889,52889,52890,50809,50777,52857,52889,50809,50809,50809,50809,50809,50809,52857,52857,52889,52857,50777,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50841,50777,50809,50809,50809,50809,50809,50777,50777,50777,50809,50777,50777,50776,50809,46584,40310,40310,38262,34037,31924,29779,31891,29811,27698,29778,31826,38100,50646,44371,38163,29745,27632,31825,29777,29712,31825,42324,40179,33938,38065,44370,46418,48563,46387,46419,44273,44305,46387,46355,44273,44305,48565,40015,40080,27404,25356,27404,44340,37968,29581,31727,27469,21195,12809,19083,19147,17034,19082,25323,33708,48499,44305,23274,21193,19081,10662,8582,6502,8582,19048,27464,23272,21160,16935,27500,40211,29581,25387,27436,27468,25355,40081,57017,54968,42225,19046,33838,33805,16967,12806,12775,10662,8549,14823,29515,35821,33741,50580,23209,12711,33806,23242,21162,27534,25389,27469,44307,31662,10663,14856,33742,44273,50545,50447,35786,21190,19078,14853,14789,29514,46288,48466,52758,56983,48401,35822,16904,16937,19049,25257,48466,25192,42128,29451,23209,27435,29548,27435,27468,35854,35854,35854,35854,35854,42160,37935,19016,10630,4324,10694,8548,8516,8516,31692,29545,16933,16933,14821,19077,16965,16964,14884,12740,8484,19016,35854,33774,21162,14856,19048,14822,6403,4291,6371,2178,2178,8483,27432,35788,29450,27369,18983,23111,148},
{50809,52857,52889,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52889,52890,54938,52890,52857,50809,52889,52889,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,52857,52889,50809,50809,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50776,50776,50809,50777,50809,50809,50777,50777,50777,50777,50776,50776,44535,40310,38229,38230,36117,31923,29778,31859,29778,27665,27665,29713,33906,40178,42259,33905,27600,25519,25552,27600,27632,27599,35953,33873,29712,35985,42258,42225,46451,42225,44371,44306,42225,44338,44339,44306,44338,46419,40015,40048,29581,29549,29549,44372,40113,14856,21163,25389,25421,19114,21196,17035,14889,14889,23275,35821,33774,27500,21161,25353,21193,14888,10695,6502,10695,21160,25416,21191,16999,14855,29613,38066,29581,25355,27436,27468,25388,31661,48500,57017,40112,16934,14854,23272,14918,10726,10726,12806,10661,16935,27402,33740,35821,35821,18984,14824,29548,16936,23243,33808,27534,23243,33807,31662,14888,19082,38000,46385,52593,48366,37932,21191,16965,16998,16998,27434,46254,44174,42126,46320,33643,42193,21129,19017,19017,25322,48498,29418,42160,27371,14823,14823,21097,23242,21129,31693,35854,33806,35854,35854,44240,14758,4357,6469,8581,10661,8548,4355,4323,12708,21158,19046,16933,16933,14884,14852,23273,27434,12710,8452,31661,35854,35854,31694,16969,12775,8484,6372,8484,10629,4290,12677,27369,42127,42127,35755,31595,27402,31496,159},
{52890,52890,52889,52890,52890,52890,52890,52890,52890,52922,52890,52890,52890,52889,52889,54970,54970,54937,52889,52889,52857,52889,52889,52890,52890,50809,50809,50809,50809,50841,50809,50809,52857,52857,50809,52857,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,50777,50776,50777,50777,50777,50777,50776,50777,50777,50776,50809,46583,40310,38229,38230,36117,34004,29745,27600,27600,23374,17002,19083,17035,17002,17035,14954,14955,14987,14955,14954,14987,14955,14954,14987,14987,14987,17067,29711,33839,33806,33806,33774,33774,33806,35887,33838,33806,33774,33774,29581,29614,29581,29581,31662,31727,17001,21228,23276,23276,21195,19147,14922,19083,19082,25388,33775,16936,12776,19049,25385,21192,14887,12808,12775,19048,29545,27496,21191,12742,14823,29581,31825,27533,23275,25388,25388,25356,27468,46419,44306,16935,21160,12806,16999,14918,14886,12774,14886,12774,14790,42159,59031,46320,29548,21097,25258,27435,16969,25388,44372,40179,25324,31694,31726,23275,27468,42160,50577,50479,46253,25287,10628,10661,12805,19078,29547,44207,44207,33739,33675,27272,33677,16904,16936,19017,25322,46418,35790,44241,27435,16904,16904,19016,27468,27468,31661,33774,33774,33773,37999,54903,23242,4356,8549,16967,10693,10692,12741,6436,12740,19013,19046,12740,14885,14852,12772,33806,37999,19016,19016,35886,35854,35854,37967,27468,12743,10662,8517,12775,8516,6370,40079,52691,44305,35788,35788,35756,42093,56750,230},
{52889,50809,52889,52922,52890,52922,52890,52890,52890,52890,52890,52889,52890,52889,52889,54970,54969,54969,52889,52889,52889,52857,52889,52889,50809,50809,50841,50809,50809,52857,52857,52857,52857,52857,52857,52857,50777,50809,50809,50809,50809,50809,50809,50809,50809,50777,50777,50809,52857,50777,50777,50809,50777,50777,50777,50777,50777,50777,50776,50777,50777,44535,40310,38230,38197,36117,36084,23341,17002,19082,21195,23276,23308,23309,10793,10794,10794,10794,10794,10794,10794,12874,12874,12842,12874,12842,12874,12874,31825,29679,25388,27436,27468,27469,27468,27500,27532,27468,25420,29614,14889,21195,14921,19082,19082,16970,21195,23308,23243,25388,17002,17035,12809,29614,25356,23275,23243,21163,19082,19082,27466,21192,21192,16967,21129,23241,29577,25416,19079,19080,25289,38000,31792,29582,25355,25355,25356,27469,27501,40113,25354,16934,23273,16966,16966,16966,12806,10693,12838,8613,8581,29515,46352,37803,31595,23177,31596,37967,21097,12711,19049,38034,25356,31693,27468,27468,33774,42192,50544,48333,33674,14821,8580,6500,8580,10693,35853,52725,46320,35821,35788,33643,31660,16936,16937,19017,23242,46386,29387,37936,29548,16904,16968,19016,21161,23242,29581,29580,35854,33773,42160,52724,25322,4356,14888,19048,19078,12804,12773,8548,12773,16933,19046,14853,14885,12804,12772,16901,12708,10597,33741,35886,35853,33773,25290,16903,12743,8549,8548,12741,4290,19015,52757,50611,40111,31595,33707,37868,46221,48299,188},
{52857,52890,52889,52890,52922,52890,52890,52890,52890,52890,52890,52889,52890,52922,52890,52889,54937,52889,54970,52889,52857,52857,52889,52889,52857,50809,52890,50841,52890,52889,50809,52857,52890,52857,52857,50809,50809,50809,50809,50777,50809,50777,50777,50809,50809,50809,52857,50809,52857,52857,50777,50809,50777,50777,50777,50777,50777,50776,50776,50776,50777,46616,42423,40310,38229,36117,34004,23341,21163,21163,21196,25389,27469,25421,12842,10794,10794,10794,12874,12842,12874,12874,12842,12874,12874,10794,12874,14987,33970,29679,21195,23243,25388,25388,23275,25388,19115,17002,19082,27502,14921,19147,14921,19115,17035,14889,21195,25388,23308,21195,17002,21228,14856,35920,27436,23275,23243,23275,23243,21130,23306,23305,25353,23273,21128,27466,25383,25384,14919,12774,31595,52791,31760,29614,23275,25355,25356,27501,27501,42226,27500,19047,23209,14855,16967,14886,12838,12774,12838,12774,8581,16871,40046,37770,37934,42193,56984,50612,21129,12711,14856,33840,23308,29581,38000,27468,31661,44272,46287,39980,23239,14886,10661,8613,10661,8516,35886,59163,50579,54936,44273,44207,33676,18984,16936,19017,23209,44305,29452,37903,31628,16904,16936,16903,25387,23242,29548,25354,33741,37934,46418,42127,25257,8518,27500,23273,14885,16966,12773,14853,16966,19046,19046,16997,16933,14885,19047,25354,16903,23242,37967,35886,35854,33741,14822,12710,10630,10629,16966,10660,8515,23207,35853,42225,33806,33708,33675,33675,33642,27303,96},
{52889,54970,52890,52889,54970,52890,52890,52889,52890,52890,52890,52890,52889,52889,52922,52889,52889,52889,52922,52889,52857,52889,52857,52890,52890,50841,52890,50809,50809,52857,50777,52857,52890,50809,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50841,50809,50809,52857,50809,50809,50777,50777,50776,50777,50777,50809,50777,50777,50776,50744,50776,48664,42423,38230,38229,36117,36052,29713,27567,21261,23309,23308,25421,23373,10793,10794,10794,12874,12874,12874,12874,12842,12874,12874,12842,12842,12874,14987,33937,29711,29711,27533,29548,29548,29516,27469,12809,8648,10729,25421,14922,21228,14921,19115,19115,17001,23340,23276,21195,17002,16970,29582,19049,33741,29549,29548,29516,27468,27436,25355,21160,25353,25385,25353,23208,31658,25415,23272,21160,14854,33741,52823,33808,29614,25355,25388,25388,27534,31727,40114,27500,21160,16903,8549,12774,14918,12805,12838,12805,10725,10662,27435,27337,33577,52757,59097,57049,48531,16936,10663,21195,29615,23276,29581,35888,23243,21162,23209,21064,18982,14885,19078,14885,12773,12773,12709,31594,48465,50644,61276,48563,40014,31595,19016,16904,16936,21097,44305,29451,31628,35789,14823,16904,25355,31694,31694,27468,29516,31596,48532,52758,54903,33774,6405,10597,23274,21160,14854,14853,14853,14853,19046,23239,19078,16965,16933,23273,40079,31595,33773,35886,35886,35886,33773,16903,12743,10630,8484,19016,16933,16933,21127,27402,23274,38065,35821,33675,33643,31562,27336,99},
{52890,52890,54938,54938,54970,52922,52922,52889,52889,52890,52890,52889,52889,52889,52890,52889,52889,52889,52890,52890,52890,50809,52889,52890,52890,52857,52890,50809,50809,52889,52857,50809,52857,52857,52857,52857,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50809,50777,50777,50809,50809,50809,50777,50777,50777,50744,50776,50776,46583,40310,38230,38197,36117,33971,29713,29680,23374,21228,19147,23341,21228,12874,12906,12907,12906,14987,12907,14955,14955,14955,14955,12874,14955,12906,19148,36018,31726,33905,31759,31629,31661,31662,27502,12842,10697,12809,25454,14922,21196,17002,19115,21195,17034,21195,23308,21195,17034,14921,21195,19017,44338,54936,54903,54904,50710,50611,42094,25353,21160,23273,31660,31659,29576,27528,19079,14854,14886,29613,46484,33808,31727,25355,25355,27468,27534,31728,40146,27500,19079,14886,12838,19111,19111,16998,16998,14853,14886,8517,21129,27337,33545,46287,50644,50644,44240,16936,10663,25389,27535,25389,40145,35855,21097,25387,25355,21096,19046,16933,16997,14885,12741,12741,14854,31594,37835,42126,46385,52757,50644,46385,27370,16936,16936,21097,42192,33676,29515,37902,16871,25388,27468,31694,33774,27467,29548,27435,29483,29418,23112,23210,6437,6405,4356,8549,10565,10564,10564,10629,12741,21159,23271,23270,16933,10596,8484,25354,37966,35854,35886,37934,35854,19016,12710,6404,16968,18983,10531,14821,21127,29547,23209,31628,31562,33675,31530,31563,31530,127},
{52890,52890,54970,54970,54970,54970,54970,52890,52890,52890,52889,52890,52890,52889,52889,52922,52889,52889,52889,52889,52889,52857,52889,52890,52889,52857,52857,52857,50777,50809,52857,52857,52890,50809,50809,52857,52889,50809,50809,52890,50809,50809,50777,50809,50809,50809,50777,50809,50809,50809,50777,50777,50777,50776,50776,50777,50776,50776,50744,50744,50776,44503,42391,38230,38230,36117,33939,29648,27599,21228,19115,19115,21196,17035,17067,17100,17100,15019,14987,14987,14987,14987,14987,14987,17067,14987,14987,17067,29711,29646,27533,27533,27533,29646,33841,25487,12874,8648,10729,25454,14921,19147,14889,19083,19147,17034,19115,21163,23276,19083,17002,19147,14856,46354,56983,54838,54871,56821,54642,48433,25353,16999,16935,25386,38063,27496,23271,23305,23243,23243,29614,33807,29647,31695,25323,25388,27468,27502,31727,40114,27468,19080,14918,16999,19111,21191,19078,19111,19111,14886,8581,12774,23143,41930,39915,48564,50612,37902,21097,14856,23276,25421,29582,48532,46354,33709,35854,35822,31595,23239,23239,19078,12805,12805,12773,14822,19014,37998,44207,42192,40079,42159,42061,27402,14824,16936,21129,40111,40047,29514,37934,29516,27468,25355,29549,31662,27468,27468,29516,23210,21097,27402,25387,6404,6437,6405,6437,12679,12613,10533,14823,14823,14823,16934,25385,29547,14855,10597,35854,35886,35886,35886,35886,33741,27402,25322,16871,25387,29516,12612,10531,14757,31596,23177,23208,40047,33708,29482,29417,29417,132},
{54970,54970,52922,54970,54937,54937,54938,52890,52890,52890,52889,52890,52890,52890,52890,52889,52889,54970,54970,54970,52857,52857,52889,52889,52890,52857,52857,52857,52857,50809,52890,52857,50809,50809,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,50809,50809,50809,50777,50777,50776,50777,50777,50776,50776,50744,50744,50776,44503,40342,38230,38197,36117,33873,29648,25454,21228,21228,19115,21260,21229,21294,21326,21358,19213,17068,17100,17100,17100,19180,19180,21293,19180,14987,17067,19148,19180,17067,17067,17067,17067,29647,25454,14922,10697,10729,25421,14922,21196,14922,19115,19050,17034,21195,21195,23308,19083,17034,21196,17002,27468,27436,42128,54838,54837,54903,44338,23240,21192,21161,19016,21160,25385,21127,38032,29548,27468,29549,31694,27534,31727,25355,27436,27501,27501,27502,38034,25388,16999,19111,21159,19079,19111,19078,14885,16966,14886,16935,14855,23143,46090,52660,59196,59196,46387,29549,16969,31695,29647,29614,31694,50645,56950,54869,57016,48432,29512,25351,21158,14885,10692,12805,10660,10596,44306,54837,42127,40047,33642,35787,23177,14824,19017,23210,40047,37934,27401,42192,35886,35919,29581,29614,33840,27468,29549,33774,23242,23210,33742,29516,12710,8517,10597,21064,23145,16806,12613,10532,8485,8452,6371,21096,37934,27403,18984,37967,35886,35854,35854,37999,48564,48467,44273,25354,14790,19048,16903,10564,16837,29449,23143,52789,52756,33675,29482,27369,37901,133},
{54970,54970,52889,54970,54970,54970,52889,52889,52890,52889,52889,52889,52889,52889,52889,54937,54938,54937,52889,52889,52889,52889,52890,52857,52889,52890,50809,52857,52857,52857,52857,50809,50809,52858,52857,50809,52857,50809,50809,50809,50809,50809,50809,50809,50777,50777,52857,50777,50809,50809,50777,50777,50777,50809,50809,50776,50777,50776,50777,50776,50777,44503,40310,40310,38229,38197,40147,29615,25422,23309,21228,21228,21260,21293,19213,21293,25519,19213,17068,17068,17100,19148,17100,19180,21293,19212,17132,19180,19213,19213,19180,17100,17099,19180,27599,25454,14954,10729,12809,25422,19083,21195,16970,21196,21196,19115,21196,21195,23276,17002,19115,21163,14889,19082,14824,42161,56918,54870,52789,48531,23240,23273,23241,19047,23273,23272,27433,48532,27435,27436,29548,35919,27534,31727,25323,25356,27468,25421,25422,33808,21194,12806,21192,19111,16998,19046,19078,16998,19079,16998,19079,19079,23142,44108,59065,57115,57115,52823,25355,16936,29614,29647,27534,27469,31662,37934,29515,29483,25289,21126,25351,16997,14821,14886,14885,10692,16902,48433,48433,40046,46385,44208,52725,23209,16936,16936,23209,37966,40014,18983,27403,25322,29580,33742,29549,27501,25356,25387,27468,23210,27403,37967,33741,37869,37836,48301,41962,23144,10565,8484,8485,8452,6404,6372,6338,10596,16902,31629,37966,37934,37934,37967,37934,50612,35757,20999,16871,14823,10597,12710,21129,31627,50643,54903,54870,42093,33675,31595,35789,54871,127},
{55002,54970,52890,54970,55002,54970,52890,52890,52890,52889,52889,52890,52857,52890,52889,54937,54937,54937,52857,52889,52889,52857,52857,52889,52889,52890,52857,52857,52857,52857,52857,52857,52857,50777,50809,52889,52889,50809,50809,50809,50809,50809,50777,50809,50809,50777,50809,50777,52857,50777,50776,50777,50809,48696,50744,50777,50777,50776,50776,50776,50777,44503,40310,38230,38229,36084,38001,29615,27567,21261,21196,23341,21261,21326,19213,21326,23438,21293,17100,17100,17100,19213,21293,19180,21293,19213,19180,17100,17100,17100,17067,17068,17067,17067,27567,25454,17035,10761,10761,25422,19115,21228,16970,21196,19115,17034,19115,19050,23276,16970,17002,19115,16969,19083,14889,44273,52692,50676,52725,40079,19015,19048,25321,25321,27433,27464,31691,50645,29484,27436,29580,35952,27502,27534,25323,25388,27469,25421,25422,31760,23339,14951,14886,12806,14886,19110,21191,19046,19046,19079,16999,23272,25288,46320,48466,48499,57049,52791,23210,16936,42259,44339,29581,23308,27501,27468,16904,16935,14822,12708,16933,21190,16998,12773,14917,14885,16901,44337,44240,39949,42094,46320,44272,25257,14856,18984,23209,35854,42160,14791,14856,16904,16904,16936,23210,14790,25323,23242,8517,21129,33773,44338,46418,37803,37770,48334,29416,6371,4291,6371,6404,6372,4259,21097,33774,19016,23209,35919,35886,35886,37934,31595,33740,46418,37935,14759,14823,12710,6404,14823,23242,35821,52757,59162,54837,42094,33675,31595,48467,48499,81},
{55002,54970,52922,52922,54970,54970,54970,54970,54938,54970,54970,52890,52857,52889,52889,52889,52889,52857,52857,52889,54937,52889,52890,52857,50809,52889,52857,52857,50809,52857,52889,52857,50809,50809,52857,52857,52857,50809,50809,50809,50809,50809,50777,50841,50809,50777,50777,50809,52857,50777,50777,50776,50809,46484,44306,50776,50776,50776,50776,50776,50777,44536,40310,38165,29713,31793,37969,29583,25454,19148,21261,19180,21293,21326,21293,21326,23406,19213,19213,19212,19180,21293,21293,19213,21293,19213,17100,14987,14955,14954,14954,14954,14954,17035,27599,25454,17035,10761,12842,25421,19115,21228,17002,21228,19115,19115,19115,19083,23308,17002,19082,19115,17002,19115,14922,19050,21130,21130,19017,19016,23273,21128,21096,27434,35916,31688,35885,50645,29484,29548,31661,33839,27502,25421,25323,25356,25388,25388,17001,17000,19112,14918,14918,14918,12805,19111,21191,14918,16934,19080,14888,21128,33772,44272,29546,19015,18983,21096,23210,14824,23242,35919,33807,29582,29582,31661,18983,21159,16933,19046,21093,23270,19109,19078,14885,12772,16966,29546,44305,52756,44304,52724,50611,27370,16936,19016,21129,35854,44241,14824,16969,16904,16904,14823,23210,21064,21064,21064,14758,23209,37967,29515,33741,25225,23177,23208,10564,2243,4291,6372,4291,4258,4291,18983,33773,23177,31661,35886,35886,35886,35854,31595,44273,54935,40048,14791,14823,10630,6437,14823,19016,16838,33675,56918,39981,35788,33708,31563,44240,44239,77},
{54970,54970,52890,52890,52890,52890,54970,54970,54937,54970,54970,52889,52889,52889,52889,54969,52889,52857,54938,54937,54937,52889,52889,52889,52857,52857,50809,52857,52857,52857,52857,52857,52857,52889,52857,52857,50809,50809,50809,50809,50777,50809,50809,50841,50809,50777,50777,50809,50809,50809,50809,50777,50777,50743,50677,50776,50777,50777,50776,50776,50777,44503,36083,36019,29713,27600,29614,29550,25454,19180,19148,19180,19213,17133,15019,19180,19212,19180,17100,17067,17067,17100,19180,19148,19212,17100,14987,14987,17100,14987,14954,14955,14955,14954,27567,25486,17035,12809,14922,25421,19082,21195,17002,21228,19115,21195,21196,21195,23308,14921,17034,19115,17002,19115,14890,12842,14890,14857,10696,12807,23337,25353,25353,25355,46419,33805,23241,48565,27436,29614,27501,33840,27502,25421,23275,25356,29614,21193,12806,14887,19080,14918,16998,17030,19079,21159,21191,16998,16999,25354,14823,21096,35885,42160,29514,16966,21129,19016,25420,12776,10630,27500,33807,25389,29581,33741,33741,25384,19078,16965,23271,19077,19109,19109,14885,12773,16966,29579,35788,37901,35820,46353,52626,29482,19017,19017,21097,33709,48434,16871,8549,16904,16936,16904,21129,18854,16773,16773,16773,31596,37934,31629,37967,40079,40046,16901,6403,4291,4291,4291,2211,6435,12742,8549,6371,21129,37967,35886,35886,37934,37934,46386,52757,54935,42128,14758,14791,8517,10630,14790,16870,16806,33676,33577,31530,29482,33676,31562,40046,46352,71},
{54970,52889,50809,52889,52890,52889,54970,55002,54970,54970,54970,54937,54937,54937,52889,54937,54937,52889,52889,52889,52889,52889,52889,52889,52857,52857,52890,52857,50809,52857,52857,50809,52857,52857,50809,50809,50777,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50777,50776,50777,50743,50710,48663,50744,48696,48696,48663,48696,42357,33840,31759,33840,29679,27469,29582,29614,23374,21261,17133,17133,17133,17133,19181,21326,21325,21261,17100,17100,19213,19213,19180,23406,19213,19180,19180,21293,21293,19180,19180,19180,19180,27599,25454,17003,10728,10761,23341,16970,19147,14922,21196,19083,19115,10728,17002,23308,14889,17002,19115,17034,19083,14857,12809,14890,16970,12809,12775,19112,16999,14920,16936,31692,21160,23274,48564,29516,29581,23307,35921,27502,27534,23275,25356,25387,23273,19079,12838,14919,12838,12806,16966,21191,23240,14854,16999,19047,21161,14823,21128,16902,21128,29579,25320,40079,40079,25355,12743,12743,29581,31727,25389,31662,37966,37998,29578,19077,19045,19078,14917,16997,19078,14853,12773,14886,37966,35820,37901,37901,31496,46220,29482,14823,16936,21097,31596,50579,18919,8485,16936,16936,16936,21129,23209,18951,16740,25257,35886,37967,27370,16871,27337,33674,10628,6435,4323,4291,4291,2178,16935,37999,27435,14758,33774,35854,35886,35886,33741,29515,37901,50644,54902,44241,14790,10630,8517,14823,12743,18983,23210,27402,23176,33741,48499,33708,31563,35853,42191,55},
{52890,52890,52890,52889,52890,52922,52889,54970,52890,54970,57050,54970,54937,54937,54937,52890,52889,52889,52889,52857,52889,52890,52889,52857,52857,52889,52857,52857,52857,50809,52857,50809,50809,50809,50777,52857,50809,50809,50809,50809,52857,50809,50809,50809,50809,50809,50809,50777,50777,50777,50776,48598,48565,46484,48597,37967,44339,44371,44371,42291,42290,38032,35854,33773,35854,31661,23243,27436,27469,21261,19213,19213,19181,19181,19180,19180,19213,21293,21293,19180,17100,19212,21293,17100,21261,21325,17067,17100,19180,17100,19180,19148,19180,19148,27567,27567,17035,8648,10728,25389,17002,19147,14921,21196,19083,19115,14922,17002,25388,16970,17034,19115,17002,19115,14889,14889,14922,14889,16969,19081,21257,17032,14888,21160,27432,21127,23274,48564,29548,21162,21195,31727,23340,27534,23243,25356,29613,21160,19111,12838,10726,12806,10726,12838,21192,25352,19047,16967,21194,14855,16936,16967,12741,10628,14822,12709,18982,40046,23242,12743,12743,25355,23275,29647,29582,31661,25321,19078,19078,19110,19110,14885,12805,16998,10660,8548,12709,48596,46385,42159,48531,40013,48432,44208,16871,19017,21129,31596,48498,14725,16870,16936,16936,16936,21097,25322,21032,16740,29515,37967,37999,29515,33643,46188,35753,14821,8548,6468,6436,4291,6403,12741,23273,25289,27435,37967,35886,35854,35854,33741,35854,48563,54903,46386,37869,29516,25323,14791,14791,12743,14790,14725,25257,25289,25224,46418,42159,31562,35853,33774,35},
{52890,52922,52890,52890,52890,52890,52922,52890,52922,52890,54938,54969,54969,54969,52889,52889,52889,52889,52889,52857,52890,52890,52889,52857,52857,52857,52890,52857,52857,52857,52857,50809,52857,50809,52857,52857,50809,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50776,50777,50744,50776,48630,48630,50711,50711,50744,50743,50744,48695,44404,40145,38033,33840,31760,31727,27501,25388,21228,23406,27696,27664,21293,21293,19213,19213,19212,21293,21261,17099,21261,21261,19148,19180,23406,17067,14987,17067,17100,17100,17067,17099,19115,29647,27567,14987,10729,12809,25421,19115,21228,19115,21228,19083,19115,21195,21163,25421,17002,17034,21195,19082,21195,14889,14922,17002,14921,14920,19112,21225,10726,14887,27464,25383,19046,21161,48597,27436,16969,19115,23308,21228,27534,23275,23275,23275,16999,19143,21192,12806,10725,10694,8613,19079,21159,19079,23273,21195,19048,21160,14854,12741,16935,25321,19015,16903,40047,25323,12711,14856,29613,23243,35920,33807,33774,23241,12740,12805,12773,16998,19078,16965,19111,12805,8581,12741,40078,50611,44175,42030,37868,54837,48433,16903,16969,19017,29483,46418,21063,31628,19016,16936,16904,21097,16903,14758,16838,33709,37967,40080,37903,50480,44139,23206,19014,10628,8548,6435,4323,14822,21160,10565,16903,35887,37934,35886,35854,37934,37934,46450,52822,52790,52758,46386,44241,35822,16903,12743,10630,14822,14757,33676,25224,35821,50579,39981,31563,40047,40081,46},
{52890,52922,52890,52890,52922,52922,52890,52890,52890,52857,52889,52889,52889,54938,52889,52889,52922,54970,52889,52857,52857,52889,52889,52889,52857,52857,52857,50809,50809,50809,52857,52857,52857,50809,50777,50777,50809,52857,50777,50809,50809,50809,50809,50809,50809,50809,50777,50809,52857,50809,50777,50777,50776,50711,50711,50776,50777,50777,50777,50777,50777,46551,42291,46452,38033,27501,29646,25356,23276,21260,19213,19245,21326,17067,17067,14987,17067,17067,17067,14987,14987,17067,17067,14987,14987,23373,19180,17067,17067,17099,17067,17035,19180,19147,29679,25454,17035,10729,12809,25389,19115,21195,17002,21228,19115,19083,21163,19082,25421,14922,17002,19115,19082,21195,16969,17002,17002,16969,14889,17000,19144,17000,19079,25383,23303,21159,25419,48597,27436,14889,19050,17002,21228,25454,23243,23275,27500,19080,14886,19079,19111,16999,14886,10662,14886,16966,21160,35887,23275,14855,23240,16933,19046,21127,21127,21094,29450,31596,29549,12743,14823,44404,48597,46418,54936,52823,25353,14886,14919,12774,14885,19110,16998,12805,10661,8581,8548,21062,46385,50612,52659,44239,57016,46354,16903,16969,19016,27434,48498,21064,23210,19016,16903,16904,19048,25355,21097,25257,35886,29515,29515,21031,29482,29513,14820,19046,19046,10661,4356,4323,14821,40144,29548,25258,37967,35886,35886,35854,27402,33675,46386,54903,52757,54936,52725,23112,16903,14791,12710,8517,19016,27436,42126,27337,23111,31497,39949,33643,37934,37968,64},
{52889,52890,52922,52890,52889,52922,52890,52890,52890,52890,52890,52890,52890,52890,52889,52889,52922,52889,52889,52889,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,52857,50809,52857,50809,52857,52857,50809,50809,50809,52857,50809,50809,50809,50777,50809,50777,50809,50777,52857,50809,50776,50776,50809,50711,50744,50776,50776,50776,50776,50744,50776,44503,46583,50743,42193,31694,35888,29549,25389,21293,19245,17165,17133,19213,19245,19181,19180,19180,19148,17067,17100,19213,19180,17100,17067,25486,25486,21325,21293,23438,23373,25486,23406,25485,40243,40212,19115,10761,12841,25389,19083,19115,14921,21228,19083,19083,21163,19082,27502,17002,19115,21195,21163,23308,23275,25356,23308,19082,21194,21224,17063,14919,21191,29608,23336,21159,31694,48565,27468,19082,21163,16969,19147,27535,23275,23275,23275,23275,21227,19145,19112,14918,16999,14887,10693,14854,27498,40111,27468,14791,23241,23272,23304,23271,19014,27401,33643,21031,29581,25355,25290,33741,37967,35788,48499,44306,19015,19047,27467,21160,19078,19046,14885,12741,16966,12741,6436,21160,37932,40013,39949,46352,50643,40014,14823,16936,19016,25322,48498,27402,23177,18984,16936,16904,19016,25257,18951,33741,35886,37934,35822,44272,40078,27465,16933,19014,14853,8548,4356,6404,16934,21127,18982,31628,37967,35919,35886,35886,35886,48499,54871,52790,54871,54903,46386,18951,14791,14791,8550,8549,23242,25355,39981,42159,48500,54903,35788,33643,35788,48532,133},
{52890,52890,52857,52890,52890,52922,52890,52890,52857,52890,52890,52890,52890,52922,52889,52889,54970,52889,52889,52889,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,52890,50809,52857,50777,50809,50809,52857,52857,50809,50809,50809,50777,50809,50777,50777,50809,50777,50777,50777,50776,50776,48630,50744,50777,50776,50777,50777,50776,50777,44471,40310,46551,42259,29614,33807,27501,25421,23374,19246,19245,19245,19245,19278,19245,17132,17100,17100,17068,17100,21293,19213,19180,17100,23406,23406,23406,23406,23438,23373,25519,25486,29646,50776,57082,23309,12809,12841,25421,21195,21196,17002,23309,19115,21195,23276,19082,25421,23341,23341,25389,23308,25389,25388,25389,25356,16969,19113,21224,19111,21192,19111,25385,14854,19079,29613,48565,29581,27501,23276,16969,19147,27567,23243,23275,19049,27469,27534,25421,23307,14887,16967,17031,14919,16967,33773,40047,29516,16936,14855,16936,19048,23304,21127,23144,25256,25257,31629,44274,40079,35822,31596,29450,31595,29482,16966,19047,40111,33740,25320,21158,10692,10661,10692,19079,12773,23241,46450,42126,35788,31561,29448,33741,16936,16936,19049,25322,48530,37901,42193,23210,16968,16936,19048,21031,23046,35886,35886,27402,18983,31594,29512,21158,21158,16965,12773,4387,4323,4323,14853,19014,25321,37999,37967,35919,35886,37934,42159,50644,52822,52790,54903,50579,40047,21064,12710,12710,6437,14855,21064,14757,37934,57016,54838,50612,35755,35756,35788,46353,142},
{52889,52922,52890,52890,52922,52890,52890,52890,52890,52922,52890,52857,52890,52889,54970,54937,52889,52889,52857,52889,52857,52889,52890,52890,52857,50809,50809,50809,50809,50809,50777,50809,50841,52857,50777,50777,50777,50809,50809,50809,50809,50809,50777,50777,50809,50809,50777,50809,50777,50777,50809,50809,50776,48631,50744,50777,50809,50776,50744,50776,50776,44503,40310,40310,42390,40277,38099,29648,27567,23406,23439,21326,21293,21293,21293,21260,19180,19180,19148,19115,19180,21228,21293,19180,19180,21260,21260,21260,23341,21260,21228,21228,23341,25453,29646,38065,23276,17034,17002,25421,19115,21195,17002,21228,17002,21195,23276,14889,17002,12809,12841,14889,14857,19082,16969,17002,19050,14857,14920,19144,19144,21224,23272,33773,19047,21160,31693,48597,27500,25388,25388,17002,19115,27567,23243,23275,23275,25356,23309,21196,21195,14919,14919,12774,14919,16966,35886,37966,27403,19017,16937,12775,19048,23272,16966,12709,23209,25321,38000,44273,44273,33741,33773,44305,48531,48531,31692,27402,31627,40013,33707,21094,12805,8548,10661,19046,16966,40078,46352,39981,37933,46352,42126,40048,16936,16936,19016,25322,40079,35821,40046,21096,16936,16936,19048,23111,18853,29450,37934,29450,33642,37802,23207,14788,14788,14853,8548,4355,4323,4323,14886,19014,33773,37967,37967,37967,31596,27369,42160,54903,52789,52822,54935,54870,44240,18983,12710,10598,8517,21064,12579,12644,16902,18983,23144,42192,40014,35788,33675,35853,177},
{52890,52922,52890,52890,52922,52922,52890,52890,52890,52890,52890,52890,52890,52890,54970,54937,52889,52889,52889,52889,52857,50809,50842,52890,52857,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,50777,50809,52889,50809,50777,52857,52857,50777,50777,50809,50809,50777,50777,50776,50777,50777,50777,50776,48630,50744,50777,50776,50777,50776,50776,50776,42455,40310,40310,40310,36117,31825,27567,25422,23374,25454,27535,27535,27470,27469,27533,25421,27501,27469,25421,27469,25421,27501,27469,25389,27501,27501,27502,27469,27502,29582,27501,27501,29614,23309,14922,19115,21228,17034,25389,21196,21195,17034,21228,16969,19115,21195,16969,21196,17002,17002,19083,17002,23308,23243,25356,23308,19082,21194,17031,17063,19111,23304,38031,25321,25321,31694,48565,29581,19049,19082,17002,19115,27567,23243,23243,19082,23276,23341,19116,21195,16999,14887,12774,14887,23273,40046,37934,21129,12743,12743,14856,19017,27434,16902,19015,33804,33740,37934,40047,40080,29548,37999,50612,50612,52757,37966,37934,46353,37901,27401,21126,19046,14853,14886,12774,10629,33773,57015,44207,46385,56982,52691,42128,16903,16936,19016,23210,23209,33740,37869,18984,16936,19016,19016,25290,27337,21030,33708,40079,48432,25255,12708,16933,19046,14853,6435,4355,4323,4323,14854,27466,37967,37934,37967,37967,35886,46419,54870,54871,54903,54903,48499,48531,33709,18951,14791,6404,21162,23209,10531,10596,10628,6435,12741,35919,29482,35788,31562,35854,152},
{52922,52922,52890,52890,52890,52890,52922,52890,52890,52890,52890,52890,52890,52889,54937,52922,52889,52889,52857,52857,52890,50809,50809,50809,50841,50809,50841,50809,50809,50809,50809,50809,52889,52857,52857,52857,52857,50809,50777,50777,50809,52857,50777,50777,50809,50777,50777,50777,50776,50777,50776,50744,50776,48663,50744,50777,50776,50776,50776,50744,50777,44503,40310,40278,38197,36116,33938,31727,31760,27599,23341,25454,23374,23341,23341,23341,23341,23308,21228,21228,23308,23341,25389,23341,25389,23308,25389,23308,23308,25421,25421,25389,25389,27534,21228,12841,12874,14922,14954,23341,21228,21228,17002,21228,19115,21195,21195,19083,23276,17002,19083,19115,19082,25388,25356,25356,25356,21227,19112,19111,19112,21224,27465,37998,23240,23240,27468,46484,31662,16969,14921,17002,19147,27567,23308,23243,23243,23276,21228,19115,21195,16935,14919,14854,10661,31659,37933,37934,23210,16936,21097,12743,12711,21128,21096,16903,25321,33740,21096,27403,33839,33774,44306,52725,48531,42127,23208,16902,35820,44207,31594,21158,21191,19046,12741,8581,6436,12742,31628,42094,48432,37836,42159,46386,21097,16936,16968,21129,21162,33741,37901,16903,16936,16936,21097,29548,33774,18918,16838,21128,31595,25353,16966,19078,21158,10628,8548,6435,4323,2211,10628,33805,37967,35886,37967,37934,35853,44240,52757,52789,54903,52724,44305,42160,37935,33741,35854,25290,23209,25321,14788,8547,10660,27434,16902,42226,46353,35788,33642,35854,141},
{52922,52890,52890,52890,52890,52890,52922,52890,52890,52890,52890,52857,52857,52889,54969,52889,52889,52889,52857,52890,52889,50809,50809,50809,50809,50809,50841,50809,50809,50809,50809,50809,50809,50809,52857,52857,52857,50809,50776,50777,50809,50809,52857,50809,50809,50777,50777,50809,50809,50776,50777,50777,50744,50744,50776,50777,50777,50776,50744,50776,50776,42423,38230,38230,40278,36149,36051,33873,31760,21325,23439,23439,21358,19245,19213,17133,17100,17100,15019,14987,17067,19213,19213,19180,17100,17067,19180,17100,17100,19180,19180,19180,21261,25454,21228,10793,12874,12841,14922,25421,21196,21195,17002,21228,17002,19115,19115,16969,23276,19082,21163,19115,17002,25389,23276,25388,25388,21194,17032,17063,19144,19144,23272,37999,23273,14853,27465,46484,31662,16969,14921,17002,19115,27535,23276,23243,19082,23275,21261,19148,21162,21193,12806,14919,19047,37965,40046,40014,25322,16903,35822,31661,29547,40046,21064,12742,8548,21193,16968,27468,31694,23210,31628,33773,25322,16903,14790,18951,35821,42126,37933,23271,21158,19046,14854,8548,6436,12742,31628,31595,25288,16805,27370,29450,19016,16968,16968,19049,21129,31661,33741,25290,16936,16936,19016,27370,29483,18885,25224,37998,23176,14789,16933,23270,19046,6467,6435,8548,6435,6403,8483,31660,37967,37966,37967,29515,31628,48531,54903,52789,54903,54903,46451,31661,40047,37902,37966,23209,16903,16966,16933,14852,12773,25321,33709,59129,50579,35755,33643,35821,171},
{52857,52890,52890,52890,52890,52890,52890,52890,52890,52890,52857,52857,52890,52889,54937,52889,52889,52889,52857,52890,52890,52857,52857,50809,50841,50809,50809,50809,50809,50809,50809,50809,50777,52857,52857,52857,50809,50809,50809,50809,50777,50809,50809,50809,50777,50776,50777,50777,50777,50777,50776,50777,50744,50776,50777,50777,50777,50777,50744,50776,50777,42423,38230,38230,40310,38197,38132,33775,25356,19148,17133,19213,19213,17165,17165,15020,17100,17100,15019,14987,14987,19180,19213,17100,15019,17067,15019,17067,19212,19213,17132,17100,19180,23406,19180,12841,14954,14922,14922,23341,21196,21163,16970,21228,14921,19082,19115,17002,23276,19082,19082,19050,16969,23308,21162,23307,25355,23371,19176,17031,17063,14919,16967,35919,23273,14886,31689,48531,33742,16969,16969,17002,19115,27567,21195,23243,21195,21195,23309,19115,23243,19048,21162,25420,31661,42127,40014,40046,25355,16904,25322,44272,46352,48465,12710,8550,12775,16934,27501,31728,25290,23275,23275,12710,6404,8517,21161,31595,31563,37966,37901,29546,23239,19110,16966,12741,8580,14886,31661,19016,8484,8484,27402,29483,18984,16936,19016,21130,21129,23210,27435,37967,29548,18984,16936,23144,18852,18853,18885,25287,14853,10660,19078,23238,14853,6403,6435,10693,6435,8580,6435,10596,33773,37999,37967,40079,50677,54870,52790,54903,54903,52757,37902,27468,27467,21031,16838,14791,14791,10661,16934,14852,10659,29546,54904,52724,37835,35820,33675,35820,215},
{52890,52922,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52890,52889,54937,54937,54937,52857,52857,52857,52857,52857,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,50809,52857,52857,52857,52857,50809,52889,52857,50809,52857,50777,50777,50777,50777,50809,50777,50809,50809,50776,50777,50809,50777,50776,50777,50776,50776,50744,48696,50776,44503,40310,38230,40342,36117,42325,54903,54904,38131,21358,23471,23471,23472,21391,23439,23503,23471,23471,23471,23471,25519,25551,23471,23471,23471,23438,25519,25551,25551,25551,25551,29711,29711,21228,14954,14922,14954,14922,25389,25421,25389,23275,25421,21195,23308,25388,23308,27469,23276,25388,25356,23308,27469,25355,25388,25388,23306,21224,23337,23304,17032,19080,33806,21160,19079,27496,46450,33774,17001,16969,16969,19083,27599,23275,23275,19082,21195,23341,23308,23275,23209,38000,33839,31693,37966,37966,37966,27403,14856,14823,31628,42127,27435,16936,14954,14888,27467,33742,33775,31630,25389,25420,12774,6437,8549,16936,29483,25322,27467,27370,23176,21159,21126,14885,16998,14853,16966,29515,14822,8517,8516,37999,46386,23209,16904,16936,21162,19049,19017,31693,35854,35886,33741,23177,23144,16772,16740,16804,23206,16965,16933,21126,23271,14820,6435,8580,10660,6435,8580,6468,4290,14790,35887,29547,35821,48531,52822,52822,54935,56983,48499,29483,27435,29548,21097,12710,12710,10630,6437,14854,16934,16901,44304,57049,54903,42061,35820,33675,33675,149},
{52889,52889,52890,52922,52922,52890,52890,52857,52890,52890,52890,52890,52890,52889,52889,54970,54970,52889,52857,50809,50809,50809,50809,52857,52890,50809,50777,50777,50809,50809,50809,50777,52857,52857,50809,50809,52889,50809,52857,52889,50809,50809,50809,50777,50777,50809,50809,50777,50809,50809,50809,50776,50777,50809,50777,50744,50776,50776,50776,50744,50776,42423,40310,40310,42390,36116,38132,42325,42325,40244,27697,25584,25616,25584,25584,25616,25616,25616,25584,25584,27664,27729,27696,27664,27664,27664,27696,27696,29776,31922,29744,29744,46550,46583,31760,17002,17002,19148,19115,19082,25388,27469,27468,27501,27501,27501,29581,29549,29581,29581,27501,29582,29582,27501,29582,29582,29581,25388,23307,25387,25387,21195,21195,25387,23274,21194,23241,44370,33774,16969,16969,17002,19083,27599,23308,23243,21162,21195,23373,29648,29614,31596,48466,35854,19048,27434,35853,35821,25322,19016,27500,25290,23242,12711,25420,17000,10694,21128,31661,31662,46420,23243,17000,12806,10662,12775,10663,10598,8550,23210,23274,16903,16967,19046,16966,19078,21158,16933,25321,14854,6404,10597,46418,48499,23145,14856,16936,21162,19017,27467,35886,35886,35886,37934,35854,35723,35623,35591,35623,35688,25285,16932,21126,21126,12772,10628,16966,14853,8548,10661,6468,6435,6403,21096,31660,46386,52822,52790,54871,48532,40079,31628,31661,25322,31629,23177,12710,12710,6469,6437,14823,14822,12676,44305,56983,48433,35788,35756,35788,35723,123}
};

const uint16_t Denver PROGMEM [320][241] = {
{48597,48629,48629,48597,48597,48630,48629,48630,48630,48662,50710,50710,50710,50710,50742,52791,52791,52791,50742,50710,50710,50710,50710,52791,50710,50710,50710,50710,50710,50710,50710,50678,50678,50678,50678,50710,50710,50710,50710,52758,52758,52791,52791,52791,52791,52791,52758,52758,52758,52758,52758,52758,52726,52726,52726,52758,52758,25550,6631,6599,6599,6631,6599,6599,4519,4518,6566,4486,4486,4454,4421,4421,2373,2373,2341,2341,2341,2341,2308,2308,2308,2308,2308,2276,2276,2276,17033,10727,14920,23241,17033,27403,14920,25322,14920,21194,19114,21194,21161,17033,21161,6534,4388,2276,6436,14725,12645,12645,10565,10565,10565,31530,39819,37674,37674,41868,31400,37674,29320,4388,2340,6533,31433,33481,4388,2308,14790,29288,35529,2211,163,8517,27337,37740,37740,37804,37804,37772,37772,29418,10791,12840,12872,12840,12840,12872,12840,14920,25354,31530,18821,8484,12807,12807,10726,10661,6436,14627,16740,12547,10499,2178,4226,4226,4258,4291,2178,2210,4259,6339,6339,6339,4259,4291,4291,6339,6371,8419,12580,12612,12580,12612,12612,14660,16741,16870,10531,12579,14660,10499,10499,10532,12580,10499,12580,8419,8451,6371,10532,12612,10499,8419,8451,8451,6339,4259,6339,4259,2210,2178,4291,6339,4291,6339,4291,4291,6339,6371,4291,4259,4259,4259,4291,6339,8419,8419,8419,4258,98,2178,4291,6339,10499,8419,8387,8419,8451,8419,6339,6371,31},
{48630,48630,48629,48597,48630,48630,48630,48630,48630,48630,50710,50710,50710,50743,50743,52791,52791,52791,52791,50742,50742,50742,50743,52791,50710,50710,50710,50710,50710,50710,50710,50678,50678,50678,50710,50710,50710,50710,50710,52758,52790,52791,52791,52791,52791,52791,52790,52758,52758,52758,52758,52758,52726,52726,52758,52758,54806,16969,4421,6501,6501,6501,6501,6501,6501,6501,8581,6501,6501,6533,8581,6533,8581,8581,6501,8582,8582,8582,6533,6501,4421,6501,6501,6501,6533,6501,14887,16903,19048,25322,14888,25387,17001,25322,16968,21193,21161,19113,21194,17033,19113,6534,4389,2308,6469,14725,12645,12645,10565,10564,10565,29482,39820,37674,37739,41868,31400,37674,31400,4356,4356,8581,31433,35529,4388,20966,12677,29320,35561,4291,163,8549,23144,37804,37772,29548,27467,25387,35724,29450,10759,10792,14952,12872,12840,10792,10824,12872,27402,19081,25094,12644,10759,10726,10694,10694,4323,10499,10629,6404,8452,4226,4226,4226,2210,6501,163,2211,4291,4291,4259,4258,4259,4259,6339,8451,6371,8419,10532,12612,14693,16773,16740,14660,12612,16805,16773,12580,14660,14692,12580,12580,10531,8419,8419,8451,8419,12580,14693,12612,12580,8419,10500,10500,8419,4259,6339,4259,4259,6339,6371,6339,4259,4259,4291,4291,4291,6339,6339,6339,4291,6339,4291,6339,8419,8419,8419,2178,98,4259,6339,6339,8419,8419,6339,6339,8419,8419,6371,8419,27},
{48630,48630,48629,48630,48630,48630,48630,48630,48630,48662,50710,50743,50743,50743,50743,52791,52791,52791,52791,50743,50742,50743,52791,52791,50742,50710,50710,50710,50710,50710,50710,50710,50678,50710,50710,50710,50710,50710,52758,52758,52758,52791,52791,54839,52791,52791,52791,52758,52790,54838,52758,52758,52726,52726,46549,23437,48662,17001,6534,10727,6534,10727,8614,8646,8646,8614,14855,6566,10759,8614,10727,8614,8646,10694,8614,12774,8614,10726,6566,8614,6566,8614,8582,6501,8614,6501,21161,19113,17065,23306,14953,21226,19114,21194,19113,19113,19113,17033,19113,12872,15017,6566,4421,4421,6469,14725,12645,12645,12613,10565,10565,29450,39819,37707,37707,41900,33481,37642,35529,27175,29255,29287,35561,35561,29287,29287,29255,27239,35561,29223,29223,27207,23144,37837,37772,10630,19016,14887,35724,31498,12775,16936,21161,14920,12775,10662,14887,14952,29515,10597,12774,8484,2243,2243,2308,2308,4324,14627,18788,10499,12547,4226,4226,4226,2210,6469,2276,6436,6371,6339,6339,4291,4259,4259,6339,6339,6339,8419,10499,8419,12580,12612,10499,14660,16773,12612,14693,18853,14692,12580,12580,10499,12612,10531,8419,6339,10500,12580,10500,10499,10500,10500,10500,10531,6339,2211,4259,8451,8451,6371,4291,6339,6339,6339,6339,4291,4291,4259,4259,6339,4291,4259,4291,6339,6371,6339,8419,2178,98,6339,6339,6339,6339,10499,6339,6339,6339,8419,8419,8419,24},
{48630,48630,48630,48630,48630,48630,48630,48630,48630,48630,50710,50743,50743,52791,50743,52791,52791,52791,52791,50743,50742,50743,52791,50742,50742,50742,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52758,52758,52758,52791,52791,54839,54839,54839,52791,52790,52790,54838,52758,52758,52726,52726,29646,8582,29645,14888,6534,10727,6502,10726,8614,8646,8646,8614,12807,6566,10759,6534,10726,8614,8614,8614,8614,12774,8614,10726,6534,6534,6501,6533,6534,6501,6566,4453,17001,10792,10792,8711,8679,8679,8679,8679,6534,6599,8679,8679,6534,6566,15050,6566,4421,2276,6436,14725,14725,12645,12645,10565,10565,29450,39787,37707,37707,41900,35529,37642,33513,16968,16968,19080,33546,37642,16968,14855,21063,29320,37641,12774,10694,14855,25224,37805,37772,10630,21193,17033,35757,31498,12840,17098,23307,14953,12807,10694,14920,14952,29483,8420,8549,8517,2243,2243,2276,2276,4356,14660,23111,4421,6436,2178,4226,4226,2211,8646,4453,8581,8484,6339,6339,6339,4291,6339,4291,6371,6339,8419,8451,8419,8451,10499,12612,14692,14692,16740,16773,12612,14692,16805,16740,10499,10532,10532,4291,10499,10499,8451,10532,10499,12612,12612,16805,12612,4291,8419,6371,4291,6371,6339,4259,6339,8419,8419,8419,6339,4291,4259,4259,6339,4291,4291,4291,4291,6371,6339,6339,2178,2178,6371,6339,6339,6339,8419,6339,6339,8419,8419,6371,8419,23},
{48630,48630,48630,48630,48630,48630,48630,48630,48630,50710,50710,50743,50743,50743,52791,52791,52791,52791,52791,50710,50742,50743,52791,50743,50742,50742,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52758,52790,52758,52791,54839,54839,54839,54839,54839,54838,54838,54838,54806,52758,52726,52725,29614,8615,29516,14888,6534,10727,6534,10727,8614,8646,8646,8614,10759,6566,10726,6534,8646,6534,8614,8614,8614,12774,6533,8646,6534,6501,4421,4389,4388,2308,4388,2308,2340,2308,2308,2276,2276,2276,2276,2276,2244,2276,2243,2276,2244,12905,17130,6566,4421,2243,6436,14725,14725,12645,12645,10597,10597,27370,39787,37675,39787,41900,35561,39754,35561,4356,4356,6533,29417,37642,6436,4356,14758,31401,37674,4291,163,8517,25192,37805,37804,33578,35724,35724,39885,31531,12872,14985,14985,12904,12872,14952,14952,12872,27435,33546,20998,6371,2243,2243,2276,2276,4356,14660,16837,4258,4258,2178,4226,4226,4258,6566,4421,6533,6436,4291,4259,4291,4259,2211,4259,6339,4259,6371,6371,8419,8419,12580,12612,16773,16740,14692,14692,14660,18821,16805,18853,14660,10499,4291,4291,12580,12612,10532,12580,12580,12612,12612,8451,4291,6371,6339,2178,2178,4291,4259,6371,6371,6339,6339,6339,6339,4291,4259,4291,6339,4259,4259,4291,4259,6339,6339,6339,130,130,8419,6339,6339,6339,8419,6339,6307,8419,8419,6339,8419,25},
{48630,48630,48630,48630,48630,48630,48630,48630,48630,48662,50710,50743,52791,52791,52791,52791,52791,52791,52791,50710,50743,52791,52791,50743,50742,50742,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52758,50742,52758,52791,54839,54839,54839,54839,54839,54839,54806,54838,54838,52758,52726,52725,29613,8615,21291,14920,6566,10759,8646,8679,6534,8646,8646,8614,10727,6534,10727,6534,8646,6533,8614,8614,8614,12774,6501,8614,4453,4421,2308,2308,2308,2276,2308,2244,2243,2243,2276,2276,2276,2276,2243,2276,2243,2243,2243,2243,8614,19211,17130,6566,4421,2341,6469,14725,12645,12645,10565,10565,10565,27369,39787,37674,39787,41900,33513,37706,35561,12612,10532,12709,31433,37641,12644,12612,16805,31368,37641,14628,12548,16773,23111,37805,35724,37837,37837,39917,39885,33611,14920,12872,12872,12872,12904,12872,12872,12872,29451,31466,18950,8419,2243,2243,2276,2276,4356,12580,18918,8451,6339,4226,4226,4226,4226,2210,2178,4258,4259,6339,4291,4259,4259,2211,4259,6339,8419,8451,6339,10499,10499,16773,16740,18853,12612,14660,12612,14660,14692,12612,16773,12579,14660,6339,10500,10532,14725,16773,14693,12612,12612,8451,10500,4259,6339,4291,4259,4258,4259,4259,4291,6339,6339,6371,6339,4291,4259,4259,4259,4259,6339,4259,4259,4259,4291,6339,4258,98,2210,10499,6339,4259,6339,6339,8387,4259,8451,8419,8419,8419,24},
{48630,48630,48630,48630,48630,48630,48630,48662,48630,50710,50710,50743,52791,52791,52791,52791,52791,52791,52791,50710,50743,52791,52791,50743,50743,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,50710,52790,52790,52823,54871,54839,54871,54871,54839,54839,54839,54839,54838,52758,52726,52726,29613,8615,8647,10760,6534,8646,8614,8646,6566,8614,6566,6534,8614,6534,8614,6566,6566,6534,6534,6534,6566,6534,6534,6533,4389,4389,2276,2276,2244,2244,2276,2244,2243,2243,2244,2243,2243,2276,2243,2243,2243,2243,2243,2276,17098,19211,17098,6566,4421,4421,6469,14725,12645,10565,10565,10565,10565,27337,39819,37674,39787,41900,33513,37642,37641,37738,35658,35658,35626,33578,33578,33610,27305,31433,37674,29385,27337,21128,29385,27402,25354,25322,25289,23241,21161,21096,14823,12742,10694,10694,8582,10662,12742,10662,14887,17000,10661,6371,2243,2211,2276,2276,2243,8451,10564,12677,12612,4226,4226,4226,2178,2178,2178,4258,4258,6339,6339,6339,4259,4259,6339,8419,10500,10499,10499,8419,12612,16773,16740,14660,16740,16805,18918,14725,16773,16773,14692,14725,12612,10532,16773,14692,10532,10564,12644,8452,10564,6339,10500,8419,4259,4291,6339,6339,4259,4258,4259,8419,8419,8419,6339,4291,4259,4291,4259,4291,6339,4259,6339,4259,6339,6371,2178,98,4291,10499,6339,6339,6371,6339,6339,6339,8387,8387,8419,8419,27},
{48630,48630,48630,48630,48630,48630,48630,48662,48662,50710,50710,50743,50743,52791,52791,52791,52791,52791,52791,50743,50743,52791,52791,50743,50743,50742,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52758,50742,52791,54871,54871,54871,54871,54871,54871,54839,54839,54839,54838,52758,52726,52726,29581,8615,2276,6502,6534,8678,6566,8646,6566,8614,8614,8614,8614,8614,8646,6566,8646,6534,8614,6566,8614,10694,6534,8614,4421,4356,2276,2276,2244,2243,2276,2243,2243,2243,2244,2243,2243,2243,2243,2243,2243,2243,2243,10760,19211,19211,17098,6566,4421,2308,6436,12645,12645,10565,10565,10565,10565,25289,39820,37707,39787,41900,35561,37674,35594,10629,4388,12774,10759,6565,4388,2276,2308,18983,35561,4291,131,2276,27305,21031,14790,16838,14758,12678,12677,14822,18951,12677,10597,10597,6436,10565,14758,10629,10597,12710,14757,6371,4324,8484,8517,8517,2211,2211,4259,2211,6404,2178,130,130,130,2178,130,2178,4259,6339,4291,6339,6339,6339,6339,4259,4291,10499,12580,14660,14660,16740,14692,12579,16773,14692,14725,14692,14660,14660,12612,14692,12612,12612,16773,14693,14725,10532,10532,6339,2211,8484,12645,8419,4259,4259,4291,6371,6339,6339,6371,8419,6339,6339,6339,6339,6339,4259,4259,4258,4291,4259,6371,6339,6339,4259,130,98,8419,10499,8387,6339,6339,6339,6339,6339,6339,8419,10467,8419,23},
{48630,48662,48630,48662,48630,48662,48662,48630,48630,50710,50710,50743,50743,50743,52791,52823,52791,52791,52823,50743,50743,52823,52823,50743,50743,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52791,52791,54871,54871,54871,54871,54871,54871,54871,54839,54839,54838,52758,52726,52726,29613,8615,4356,6502,6534,10727,6534,10726,6534,8614,8614,8614,8646,6566,10694,6534,8646,6534,8614,8614,6566,10694,6534,8614,4389,2308,2276,2276,2243,2243,2276,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2276,17130,19211,19211,15018,6598,4421,2276,6436,8581,8549,6436,6436,6437,6469,23209,39787,35626,39787,41900,35593,37707,37674,10597,4388,10694,12806,8646,6469,2308,4388,18983,35561,6339,131,2308,27305,18983,14822,14790,12710,12677,10629,14822,16903,10629,10629,10597,8517,10629,14790,10629,8517,10662,8549,6339,4389,12710,14855,14790,10499,12580,12612,6371,10564,2210,130,130,130,130,130,2211,4259,4291,6339,6339,6371,6339,6371,6339,6371,10499,10532,12612,16741,14692,14692,14660,12612,14693,14693,16741,16773,16740,14692,14693,10500,14693,14692,10564,10500,8419,10532,4259,6339,8451,8451,6339,6339,6339,4291,4259,6339,8419,8419,6339,6371,6339,6339,4291,6339,6339,4291,4259,4259,4259,6339,6339,6339,2178,98,130,8451,8419,6339,6339,6339,6339,6339,6339,6339,8419,8419,8419,24},
{48662,48662,48630,48662,48630,48630,48662,48662,50710,50710,50710,50743,50743,52791,52823,52823,52823,52823,52823,52791,50743,52823,52823,52791,50743,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52758,52791,54871,54871,54871,54871,54871,54871,54871,54839,54839,54839,52790,52758,50710,27565,10695,4421,6534,6534,10727,8614,10727,6534,8646,8614,8614,8646,8614,10694,6534,8646,6534,8614,6534,6534,10694,6533,8614,4356,2308,2276,2276,2243,2243,2276,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2276,17130,19211,19211,15018,6598,4421,4421,6469,14985,10694,6501,4388,6469,4389,23241,39787,35626,39820,41900,35594,37707,39754,14757,4388,10662,12806,8646,6469,4356,4356,18983,35561,6371,2211,2276,27272,12742,10630,10629,10597,8517,8517,10629,10629,6469,6436,6436,6404,6436,6468,8517,8517,8549,8549,4356,4388,8614,10694,8581,10500,10532,10597,4323,8516,2211,163,131,2179,131,131,2179,4259,4259,6339,4259,4259,4259,4259,6339,6339,8451,10499,12580,10499,10500,10532,14660,12580,10500,10532,14693,14660,12612,12580,12580,8452,12612,10532,10532,12580,10532,4259,6339,10532,10532,8419,6371,6339,8419,6339,4259,6339,8419,10532,6371,8452,8419,6339,8419,4291,6371,6371,8451,8451,6371,2210,4291,2210,98,4258,130,8451,10499,8419,6339,6339,4259,6339,6339,8419,6339,6339,8419,23},
{48662,48662,48662,48662,48662,48662,48662,48662,50710,50710,50710,50743,50743,52791,52823,52823,52823,52823,52823,52791,52791,52823,52823,52791,50743,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52791,52791,52791,54871,54871,54871,54871,54871,54871,54871,54871,54839,54839,52758,52758,50612,12873,8615,4389,6502,6566,10727,8614,10726,8614,10694,8646,8614,8646,8614,10694,6534,8646,6534,10662,8614,6534,8646,6533,8614,4389,4356,2276,2276,2244,2243,2244,2243,2244,2243,2243,2243,2243,2243,2243,2244,2243,2243,2276,15083,19211,17163,15050,8679,4421,2308,4389,10694,8581,8582,8549,8549,6501,21161,37707,35594,41868,41900,35594,37707,39754,23046,6404,10662,21128,6501,6501,2276,2276,18983,35593,6371,130,2276,19048,10630,14791,10630,10630,10630,10630,10662,12743,12710,12710,12710,14823,12710,19016,21129,12839,12840,12840,4324,8517,8517,8517,8484,8484,8484,6436,6436,8549,2211,2211,2211,2211,2211,2211,2211,4259,6339,6339,4259,4259,4291,6339,4291,4291,6339,6339,6339,8451,14692,12612,12580,12580,10499,12612,10532,12612,14660,14660,12612,10532,12612,14693,10532,12612,4291,8419,14692,12580,10499,10499,6339,4291,4291,2210,6371,8419,8451,8419,6339,6339,8419,8451,8451,8419,10499,8451,6403,6371,6339,6339,4259,130,2178,8419,2178,8451,12579,10499,8419,6339,6339,6339,4291,8419,8419,8419,8419,24},
{50710,48662,48662,48662,48662,48662,48662,50710,50710,50710,50710,50743,50743,52823,52823,52823,52823,52823,52823,52823,52791,52823,52823,52791,50743,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,52758,52791,52791,52791,52791,54871,54871,54871,54871,54871,54871,54871,54871,54871,54871,52790,52758,50677,10695,8615,4389,6501,6566,10727,8614,10727,10759,12840,12872,12840,12840,12840,12840,10759,12872,10759,12807,10727,6566,6566,6534,12775,12775,8582,8614,10695,10630,4389,10694,8614,6501,10727,6534,8582,10727,6501,8614,10694,6469,10694,6534,4454,8744,6534,4486,6566,2308,4421,4421,2308,6501,4389,4388,4453,4388,19081,37674,37707,41900,41900,35594,37707,39755,18982,12742,12742,19080,8613,8549,2276,4388,18983,35561,6372,163,2276,4389,12710,12743,12710,12710,12710,12710,12710,14823,14823,14823,14791,12742,14790,14823,16904,12807,12807,12807,4421,12807,12839,12839,12807,10694,8614,4421,4421,4388,6404,6404,6404,4356,4356,4356,4323,6339,6339,6339,4291,4259,4291,6371,6371,6339,6371,10499,10499,10499,14660,14660,12612,14692,14692,14692,12612,14660,10532,12612,12612,10532,14692,10500,8451,10500,6339,12612,12612,14660,14692,10532,6339,6339,6339,4291,6371,6339,10499,12644,12612,10596,10532,10500,10500,8451,10499,6339,6371,6339,6339,4291,4259,130,6371,10499,4226,6371,12579,10499,6339,4259,2210,2211,2211,8419,8419,8419,8419,23},
{50710,50710,48662,48662,48662,48662,48662,50710,50710,50710,50710,50743,50743,52823,52823,52823,52823,52823,52823,52823,52791,52823,52823,52823,50743,50743,50710,50710,50710,50710,50742,50710,50710,50742,50710,50710,52791,52791,52790,52791,52823,54871,54871,54871,54871,54871,54871,54839,54871,54871,54871,54838,52758,50645,10695,8615,4389,6502,12840,14985,12937,14985,12905,8679,8679,6599,8679,8679,6566,6534,6534,4453,4389,4356,2308,2276,2308,6566,6566,6534,6534,6534,4421,4389,4486,2308,4389,4453,2276,4421,4389,2276,4389,4389,2276,4421,2308,2308,2341,2276,2276,2308,2276,2308,2308,2308,2308,2276,2276,2308,2276,17000,35626,37707,41900,41900,35594,37674,37674,20966,16805,21030,23143,18950,18853,14692,14693,23111,35561,18821,14660,14660,10532,12710,12710,18983,16903,14855,14823,12710,14823,14856,14888,14791,12743,12807,19081,23241,19081,17000,21129,12709,8614,8581,10727,12742,2211,2179,2211,131,2211,6436,6404,6436,6468,4291,131,2211,4259,6339,6339,4291,4291,6371,8419,8419,8452,8452,10532,10532,12580,12612,12612,12612,12612,12612,14692,12580,10499,10532,8452,10564,8451,10532,10499,6371,8451,12612,10499,12612,10499,10499,10499,10532,10499,8419,8419,8419,10564,10500,8451,12580,10499,10499,8451,8419,8419,8419,8419,6371,8419,8419,6339,2178,2178,8451,10500,6339,130,6339,6339,6339,4259,2178,4258,2210,6371,8419,8419,8419,28},
{50710,50710,50710,48662,48662,48662,50710,50710,50710,50710,50742,50743,50743,52823,52823,52823,52823,52823,52823,52823,52823,52823,52823,52823,50775,50742,50710,50710,50742,50710,50742,50710,50710,50710,50710,50710,52791,52791,52791,52791,54871,54871,54871,54871,54871,54871,54871,54839,54871,54871,54871,54838,52758,50645,10695,8615,4356,10663,21356,21453,23534,19179,8712,10792,8712,8680,6631,8712,8680,8680,8679,8647,6599,6599,8647,6599,6599,6599,6567,6599,6599,6599,6599,6599,6567,6599,6599,6599,6599,6599,6599,6567,6567,6599,6599,4551,4551,4551,4519,4518,4486,4486,4518,4518,4518,4518,4518,4486,4486,4486,4486,17033,35626,35659,41900,41900,39787,37674,39754,37739,37739,39819,39755,41835,37739,35658,31433,35562,37674,31498,29450,27337,25160,12775,12775,17033,12677,2211,16936,14823,8517,131,10662,14791,14790,2179,2276,16936,12775,6404,8517,8452,12807,18918,10597,12645,2178,2210,2243,2211,2243,6404,6436,6436,4388,4323,2211,2211,4291,6339,6339,6339,4291,6371,4291,4291,6339,6371,6339,8419,10532,10532,10532,12612,10500,12580,14660,12580,10532,10499,12580,12612,10500,10532,10532,8452,8451,12612,10532,14693,10532,10500,10499,10532,8419,8419,6339,8419,8419,8451,8451,10500,10532,8419,8484,8419,6339,8419,8419,8419,6371,8419,4259,130,4291,10499,12580,8419,2178,8419,8419,4258,4259,4259,6339,6339,8419,6339,6339,6371,26},
{50710,50710,50710,48662,50710,50710,50710,50710,50710,50710,50742,50743,50743,52823,52823,52823,52823,52823,52823,52823,52823,52823,52823,50775,50743,50743,50710,50710,50742,50743,50742,50710,50710,50710,50710,50710,52791,52791,52791,52823,54871,54871,54903,54871,54871,54871,54871,54871,54871,54871,54839,54839,52790,48597,10695,8614,4389,10695,23469,21486,21486,19211,2308,2341,2341,2341,2308,2276,2276,2276,2276,2276,2243,2244,2276,195,2244,2244,163,2244,2244,163,2243,2243,2243,2243,2211,2243,163,2211,2243,2211,2243,2244,2243,163,2243,2211,163,2211,2243,163,2211,2211,163,163,2211,163,2211,2211,2211,12775,35626,35627,41900,41900,37674,37706,39754,8581,4421,10726,29417,39787,10661,4421,10662,33481,39754,8484,195,6436,27370,12775,12775,14985,14822,10694,16968,14823,10597,6436,12775,14791,12742,6404,6501,18984,14791,8549,10661,10499,16707,16707,14595,14627,2178,2210,8549,14855,12710,6404,6404,6436,6501,6436,2276,2276,4323,8419,6339,6339,8452,8452,8452,6339,4291,6339,4291,6371,6339,6371,8419,10532,10532,12580,16740,16773,10499,12580,12612,8452,6339,10499,8451,8451,12612,12612,12644,12612,8419,8451,14660,10499,14660,12580,8419,10532,8451,6371,8419,8419,8451,8419,10500,8419,8451,8419,6371,8451,10499,8419,2178,2178,8419,10499,12579,10499,4258,2211,8451,8419,6339,6339,6339,6339,6339,6371,4259,4291,24},
{50710,50710,50710,50710,50710,50710,50710,50710,50710,50710,50742,50743,50743,52823,52823,52823,52823,52823,52823,52823,52823,52823,52823,50775,50743,50743,50710,50710,50710,50743,50742,50742,50742,52791,52791,52791,52791,52791,52791,54871,54871,54903,54903,54903,54871,54871,54871,54871,54871,54871,52790,54871,52790,46419,10695,8614,4389,8615,19276,21453,21486,15018,2243,2276,2308,2276,2276,2244,2244,2243,2243,2243,2243,4324,2275,2243,2275,2276,2243,2276,2276,2276,2243,4324,4324,2275,4356,2276,2275,2276,2276,4324,4324,2276,4356,2275,2276,2308,2243,2276,2276,2243,2308,2276,2243,2308,2275,2243,4356,2276,2243,12807,35626,35659,39820,41900,37674,37674,39787,8516,4388,12742,27337,41835,10597,4420,10629,35562,39754,8484,2243,6436,25159,27305,8614,12839,14790,14726,12743,14791,8549,12677,14790,8614,8581,10629,16838,12710,12775,16903,18886,12547,16675,16675,14594,14627,8419,10467,10564,4324,4324,6404,6404,6436,6533,6468,4356,4356,4356,8452,8419,6371,8484,6371,6339,6339,6371,8419,8451,6339,6339,6339,6371,8451,12612,6371,14692,14660,16773,14660,8419,10532,8419,10532,6371,8451,14692,12612,14692,12580,12580,10532,14693,10532,12580,8451,16740,8419,8419,8451,6371,6339,6371,8419,12612,12612,10532,8419,6339,6339,8451,4258,2178,4291,8419,10499,12580,10499,8419,2178,4323,8419,6339,8419,8387,6339,6371,6339,6339,6339,29},
{50710,50710,50743,50742,50742,50742,50742,50710,50710,50710,50742,50743,50743,52823,52823,52823,52855,52823,52823,52823,52823,52823,52823,50743,50743,50743,50710,50710,50710,50743,50743,50742,50742,50742,52791,52791,52791,52791,52791,54871,54904,54904,54904,54904,54904,54904,54903,54871,54871,54839,54839,54871,54871,52725,14856,8647,8647,8614,17195,21453,21486,12905,2211,2276,4388,6436,6436,6436,6436,4356,8484,6404,6436,12644,4356,6404,4356,6436,10564,12644,4356,4356,4356,4356,4356,4356,10564,4356,4356,2276,4356,8484,6436,4356,4356,2243,2276,2275,2243,2276,2243,2243,2276,2243,2243,2275,2243,2243,2276,2243,2243,4421,8614,6534,6566,6566,23144,37642,39787,31368,31400,33513,35626,41867,33481,31368,29320,37674,39754,33416,33384,31336,31466,39982,2243,2276,10662,12807,8582,12743,2211,6468,4388,2243,4356,4356,6501,16838,10661,19048,27207,12547,16675,16675,16675,14627,12580,14660,16870,14660,14659,6404,6436,6404,6436,4356,4324,4323,6404,10532,8452,8419,6371,6371,6339,6339,4291,8419,10532,8484,8419,6339,10500,10500,10500,10532,16740,20934,14692,6371,6371,8419,8419,10500,12612,12612,14660,16773,12612,12612,10532,12612,10532,10532,10532,12612,8451,8451,6371,8419,6371,8419,8451,10532,8452,8451,8451,10564,6339,4259,2211,2178,2178,10532,10499,10499,10499,6371,8419,6339,2178,8419,8419,8419,10467,8419,6339,6339,6339,6371,23},
{50710,50710,50710,50743,50742,50743,50742,50710,50710,50742,50742,50743,50743,52823,52823,52823,52823,52823,52823,54871,54871,52823,52823,50743,50743,50743,50710,50710,50742,52791,50743,50742,50742,50742,52791,52791,52791,52791,52791,54903,54904,54904,54904,54904,54904,54871,56951,56919,56919,54871,54839,54871,50677,44403,21162,12775,8615,14790,23339,19373,21486,15017,10662,12742,12742,12774,12742,10694,10694,16935,16903,12742,10694,14887,10694,10662,10694,10694,12742,16967,10694,10662,14823,10662,8614,16871,10694,8614,8646,8614,8614,10726,8614,8646,8614,8614,8614,8614,6566,6566,4485,4486,6566,6566,6566,6566,6566,6566,6598,6566,6566,6598,6566,4453,6598,4486,23176,37674,39787,21128,17000,19113,31530,41868,21096,14887,16967,35594,39755,16903,10726,10726,31433,37902,4291,4323,10694,12775,10630,12742,2243,6436,6468,4388,4324,4356,8549,8549,4388,6533,14822,12547,18723,16675,16675,14627,12580,14660,18885,16772,20933,6404,14823,8484,6436,6436,6436,6404,8484,12612,10532,8451,8451,6371,6371,6339,6339,6339,8452,10532,14757,12612,12644,12645,18918,25126,16870,12644,8419,6339,6339,6339,8451,10500,10499,8452,14660,12580,12612,14660,12580,10499,10499,8419,10500,12612,10532,8419,8419,6371,4291,10564,14725,10532,6339,8419,6339,8451,10499,8419,6339,2178,2211,6371,12580,16740,10499,6339,6339,8419,4258,4259,8419,8419,10499,8419,6339,6339,6339,6339,23},
{50710,50742,50743,50743,50743,50743,50742,50710,50710,50710,50743,50743,50743,52823,52823,52823,52823,54871,52823,54871,52823,52823,52823,52823,50743,50743,50710,50710,50743,52791,50743,50743,50710,52791,52791,52791,52791,52791,52823,54903,54904,54904,54904,54904,54904,54904,56951,56919,56919,56919,54871,54871,52725,48401,31628,16936,6502,23274,21290,10922,13002,15050,17195,17195,19243,21356,17163,17162,15050,15050,15050,15050,15017,15049,12969,10857,12937,15018,10824,15050,10824,27598,31629,4389,14920,44209,8550,2308,2340,2308,2308,2276,2308,2276,2276,2276,2276,2276,2244,4324,2276,4324,2244,2244,2243,2276,2243,2243,4292,4292,2211,4292,4291,4291,2211,4259,25160,37706,41867,10597,4421,10662,25257,41867,12677,4388,10662,33514,39787,12645,2276,6436,29353,39982,4291,130,6469,163,6469,12742,2243,2179,130,163,4324,2211,130,2211,2276,2211,4388,10499,16675,16675,14594,14627,14660,16740,16838,10500,14757,8484,19113,6371,2243,2243,2243,2243,4323,12612,16740,10532,10532,8419,6371,8419,8419,8419,8452,10532,10532,10500,10564,12612,16838,18885,16772,10499,10500,4291,4291,8419,10500,10532,10532,8451,14725,12612,16773,12612,8451,10499,10499,12580,12612,12612,8451,8451,8419,8419,4291,10564,4259,4291,8419,8419,8419,10500,10499,8419,6339,2210,6339,6371,14660,14660,8419,4259,6339,8419,4291,6339,8419,8419,10499,8419,6339,6339,6339,6339,22},
{50742,50742,50743,50743,50743,50743,50743,50742,50742,50742,50742,50743,52823,52823,52823,52823,52823,54871,54871,52823,52823,54871,54871,52823,52823,50743,50710,50710,50743,52791,52791,52791,50710,52791,52791,52791,52791,52791,52823,54903,54936,54936,54936,54904,54904,54904,56951,56951,56951,56919,54871,54871,48597,42355,38000,27403,4389,19113,10793,10760,10760,10824,10921,10889,10922,13002,10889,10857,10857,8744,10825,8777,12937,8776,8776,12937,12905,10824,12937,10824,12937,33937,42161,33645,37902,46419,37805,35724,37773,37773,37805,37805,37805,39886,39886,39918,39918,39918,39950,39885,37805,41999,42031,42031,42031,44079,44111,44111,44143,44143,44143,44144,42031,42063,46224,46257,39819,37674,41835,20934,18885,25159,31433,39787,25126,18886,23046,35594,39754,23014,18853,20934,31433,39950,4291,2243,8581,4356,6501,12710,2243,2243,2275,2211,4324,12676,2275,163,2243,4388,6501,10499,16675,16675,14594,12547,8419,8419,8419,6371,8484,4291,6469,2178,130,130,2178,2179,2211,16740,14660,12612,8419,8419,10500,10499,8419,6371,8452,8452,10532,8451,10500,12645,16773,20901,12580,10500,10500,4291,4259,6371,8419,8419,12612,10532,10532,12612,12612,12580,10499,10500,12580,10500,10499,8452,8452,8451,8419,8419,8452,6403,2178,6339,6339,8419,10532,10499,8451,8419,4259,2211,10500,12580,16773,12579,6339,6339,6339,8419,6339,6371,8451,10499,8419,8419,8419,8419,6339,6339,22},
{50742,50743,50743,50743,50743,50743,50743,50742,50742,50742,50743,50743,50775,52823,52823,52823,52823,54871,54871,52823,52823,54871,54871,54871,52823,50743,50743,50743,50743,52791,52791,52791,52791,52791,52791,52791,52791,52791,52823,54903,54904,54904,54936,54904,54904,54904,56951,56952,56952,56951,54871,54871,50612,48434,46289,33741,8582,14920,6534,6566,8647,8712,8809,6664,8744,8809,6664,8777,8712,6599,6664,6631,10824,6696,6664,10857,10856,8744,10857,8776,10857,33937,35919,17001,27468,46451,44370,44370,46419,46418,46419,46419,46418,46451,46419,46451,46451,46451,46419,42225,42193,46451,46419,46419,46451,46419,46419,46418,46451,46419,46451,46451,42225,44306,46451,46451,44110,44012,48173,25289,19113,21225,31595,48173,25289,17000,21160,41900,46125,27304,16968,17000,37707,40015,4291,4324,8581,12677,8517,12742,2211,4356,6404,2211,4323,4323,6436,2178,4323,2211,4356,10467,16675,16675,16643,14595,14660,16740,16838,10564,14757,6371,4324,2178,2178,2211,2211,2211,2243,16772,12612,8451,8419,8419,10532,10499,8451,8419,10500,10532,10532,12612,16805,10532,14692,16740,12612,10532,12580,4258,4291,8419,6339,8419,10532,8419,8419,12612,10532,12580,10499,14692,12612,10532,8419,4259,4259,6339,6339,6371,8419,2178,4259,6339,6339,6339,8451,12580,8451,6339,2211,4259,10500,14692,14660,10499,10500,6339,6371,8419,8419,4291,10499,8419,10467,8419,8419,8419,6339,8419,25},
{50742,50743,50743,50743,50743,50743,50743,50743,50743,50743,50743,50743,50775,52823,52823,52823,52824,52823,52823,52823,52823,54871,54871,54871,52823,50743,50743,50743,50743,52823,52823,52791,52791,52791,52791,52791,52791,52823,52823,54904,54904,54936,56984,54936,54904,54904,56952,56951,56952,54903,54871,54871,54839,54838,54838,33806,14888,14856,2276,4356,6501,6599,8744,6631,6664,8744,6599,8744,6664,6599,6631,6631,4519,6632,6631,6664,6664,6696,6631,6664,8744,31856,42258,35984,38097,46451,33936,33936,33968,33968,33968,31888,31856,29775,31856,29807,29775,29775,29743,27630,27630,29743,29743,27662,27662,27630,25582,27630,27695,25550,23469,23437,19243,21324,21357,21356,31595,41899,48205,27272,21096,23208,31530,48173,29352,18983,23144,41868,46125,29352,21096,21096,35756,42063,8452,10565,14790,18951,10597,12742,8452,12677,12645,4291,6404,12612,12677,6372,8484,8484,8517,18755,27011,27011,27011,24995,16740,14660,14725,16741,14789,6403,4324,2178,2178,2211,2243,2211,2211,18821,18820,16740,12579,10499,8419,12580,10500,10499,12580,10532,12612,10532,10532,10532,14660,16740,12580,14757,20933,6339,2211,4291,6339,8452,8451,10500,10532,10499,10532,14660,14660,14693,16805,14660,12612,10532,8451,6371,8451,6371,6339,2210,8451,10499,8419,8419,10500,10500,8419,6371,2178,4291,12580,14692,12580,10499,10499,8419,8419,10499,8419,4258,6339,8387,6339,8419,8419,6371,6339,6371,22},
{50710,50743,50743,50743,50743,50743,50743,50743,50743,50743,50743,50743,50775,52823,52823,52823,52824,52824,52823,52823,52823,54904,54904,54871,52823,50743,50743,50743,50743,52823,52823,52791,52791,52791,52791,52791,52791,52823,52823,54904,54903,54904,54936,54936,54904,54904,56952,56952,56952,54871,54871,54871,54871,54871,54871,37967,19081,16968,16935,12774,16968,12904,8776,6664,8744,8744,6631,8712,6664,6631,8744,6664,6664,6696,6664,6664,8744,6696,10889,10857,8777,31888,33709,10565,23210,46419,16806,12613,12646,14726,16839,14694,14694,16774,16806,18887,16774,16806,16774,14726,16806,20967,20967,20935,18887,20967,20968,21000,27273,23080,23080,23048,20967,23048,25161,25161,33546,41867,48173,29352,23143,25224,31497,48173,31433,21063,23176,41900,46125,31433,23144,19016,25289,40015,10662,17000,25321,29482,14790,14791,10694,19080,18983,4388,6468,10726,12807,6404,4324,6501,16871,14692,18918,14789,18982,25159,14660,18821,16773,8484,12742,2243,2276,4291,2178,2211,4291,2211,2211,16772,18821,16740,12612,12580,6339,12612,12580,10532,14660,12612,12612,10532,8419,10500,14660,14692,12580,12580,14692,8419,4259,8484,8484,4291,4291,12580,12612,8484,8451,10532,10532,14693,12612,12580,12612,10532,8419,6371,4259,4323,4291,6339,6371,6339,6339,8419,8451,8451,8419,6339,2178,8452,12580,14660,12580,10499,8451,6371,6339,10499,10499,8419,6339,8419,10467,8419,8451,8419,6371,6339,21},
{50710,50743,50743,50743,50743,50743,50743,50743,50743,50743,50743,50743,50775,50775,52823,52823,52823,52824,52823,54904,54904,54904,54904,54904,52823,50743,50743,50743,50743,52823,52823,52791,52791,52791,52791,52791,52823,52823,52823,54904,54904,54904,54936,56984,56984,56952,56952,56952,56952,54871,54871,54903,54871,54871,54871,42193,25355,15018,17260,17260,19276,10889,8776,8744,8744,8777,8712,8744,6664,6664,6696,6664,6599,6696,6664,6663,6664,6664,6663,6664,8744,31824,42258,35984,38065,46451,46386,46386,46418,46418,46451,46451,46418,46419,46418,46419,46419,46419,46386,44273,44338,48499,46451,46451,46451,46451,48499,48499,48500,48499,48531,46386,42225,46451,48531,48531,46256,43947,48206,29320,20998,23111,29417,48173,31400,18918,21063,41900,46125,31433,21031,21063,35626,37934,4324,8581,16903,25257,12742,12743,4291,8549,12742,4324,4324,4323,6436,4323,4323,6469,16903,14692,27434,16740,22981,27174,16740,16773,12612,8484,10597,4291,2243,4356,2211,2211,2243,2211,2243,14692,12612,10629,8452,2211,6339,6371,12580,12580,14693,10532,14660,12580,8451,10500,14692,16773,10532,12580,12580,8419,2211,2243,4259,6339,8451,10499,10532,8451,8419,10532,12580,12612,10532,12612,10499,6371,6371,10532,6339,6371,2178,2211,6339,6339,6339,6339,6371,8419,8451,6339,2178,10500,12580,14660,10499,8419,8419,8419,6339,8419,10499,8419,6339,8419,8419,8419,10499,8451,8419,6339,21},
{50710,50743,50743,50743,50743,50743,50743,50743,50743,50743,50775,50775,50743,50775,52823,52823,54872,54872,54904,54871,54904,54904,54904,54904,52823,50743,50743,50743,50743,52791,52791,52791,52791,52791,52791,52823,52823,52823,52823,54904,54904,54936,54969,54968,56984,56952,56952,56952,54904,54871,54871,54903,54903,54871,54903,48467,33709,12937,10922,10921,15082,12937,8776,8776,8809,8744,6664,8776,8744,6696,8776,8776,8744,10857,8776,8776,8776,10889,10857,15050,12969,33969,40048,29451,33709,46419,44338,44370,46451,46451,46451,46451,46419,46451,46451,46451,46451,46451,44338,42225,44371,46451,46451,46451,46451,46451,46483,46451,46451,46451,46483,42290,42257,46451,46483,46483,44272,43948,48206,27272,14790,16902,25224,48206,29320,14725,16870,37707,46093,29320,16806,16806,35593,39982,4291,163,8614,12840,10662,12743,2243,2275,195,2243,6404,2211,163,163,4323,4356,4356,12547,21063,16675,16675,16708,12579,12612,6339,4291,4324,2211,2211,4356,6403,6371,6371,4291,2211,16740,12612,8516,6371,4259,6339,10500,12580,12580,12580,10499,16773,14660,8451,10500,16773,16740,10500,10532,14660,8451,4291,2211,4259,2211,4291,10500,10564,10532,8419,8451,12580,14693,14692,16740,8419,8419,10499,10499,8419,8451,4291,2178,2211,6339,6371,6339,8451,10500,10499,2210,4291,12580,12580,10532,6339,8419,6371,6339,6339,8451,10499,8419,6339,6339,6371,6339,8451,8451,8451,8419,21},
{50743,50743,50743,50743,50743,50743,52823,50743,50743,50743,50775,50743,50775,50743,50743,52823,54872,54872,54871,54904,54904,54904,54904,52856,52823,50775,50743,50743,52791,52823,52823,52823,52823,52791,52791,52823,52823,52823,52823,54904,54904,54936,57017,54968,56984,56952,56952,56952,54903,54871,54871,54903,54903,54903,54903,52725,35790,12905,10889,10889,13002,12970,15050,17098,17098,15017,17098,17098,17065,17098,19178,17098,17098,19146,17065,19113,21226,19146,21194,21193,19145,36017,38000,19211,27565,46386,21226,19146,19146,19114,17066,17066,19114,19113,14985,19113,17000,17033,14920,14887,14920,19080,25256,16968,12840,16968,23241,12807,27370,16935,12775,8614,10662,8614,12742,10662,16936,39754,48174,29385,14822,14855,21128,48173,29384,12709,14822,37707,46093,29352,12710,12742,37707,42063,4291,2243,8614,12872,8614,12742,4291,4356,2275,4356,6404,2243,2243,2211,4323,4324,6436,18755,24963,20835,20835,22916,12547,12580,6404,2275,2275,2243,2211,6371,8452,10564,8452,6339,2211,14660,12612,8452,6371,6339,6339,8419,8419,10532,14692,10532,10532,12612,10500,10500,16773,12580,10532,12612,10532,6371,6339,2178,2211,6339,6371,4291,4291,8451,6371,2210,8452,14693,23014,20868,8419,10499,12612,10532,10500,8451,4259,4259,4259,8419,8419,8419,8419,10499,12580,2210,6371,10532,12580,8419,8419,8419,6339,4259,6371,8419,12612,10499,6339,6339,6339,2210,4291,6339,8419,8419,26},
{50743,50743,50743,50743,50743,50743,52823,50775,50775,50775,50775,50743,50743,50743,50775,52823,52824,54904,54904,54904,54904,54904,54904,52855,52823,50743,50743,50743,52791,52823,52823,52823,52823,52791,52791,52823,52823,52823,52823,54904,54904,54936,54969,54969,56984,56952,56952,56952,54904,54871,54903,54903,54936,54903,54903,54903,37870,15018,10857,10889,13002,19049,31563,29547,31563,31531,29548,31531,29483,25419,31531,27403,23307,31563,25355,23306,33644,27467,46256,46257,46224,50580,50417,35626,37805,52660,33513,39721,35528,35561,31433,35561,37641,37674,35593,41802,41802,41834,35593,39721,39754,41867,44011,41899,35626,37739,41932,35659,44012,39820,35691,31466,35659,35659,39852,37772,37740,37642,44013,31465,16967,19016,23209,48173,33545,14855,16967,37707,46093,31465,14855,14855,37869,40014,4291,2243,8582,12840,8614,12775,2243,4356,6404,6436,6404,2243,4356,4356,4324,4356,12710,20933,23014,18853,18853,20933,18820,12612,8484,4324,2275,4258,6339,8419,12612,10532,8451,6371,6339,6371,8419,6339,6339,8451,6371,6371,8419,12612,14692,14693,14660,12612,12580,12580,8419,10532,10500,12677,10532,6371,4291,2211,4259,6371,4259,6371,10532,10564,10499,2210,8452,18886,23047,22949,16740,12580,10532,10499,8419,8451,6339,4259,2211,4291,10564,12644,12612,12580,8419,2178,4291,10532,10500,8451,12580,12579,8419,8451,8451,8419,10532,8419,4291,6371,6339,4259,4259,6339,6371,6371,24},
{50743,50743,50743,50743,50743,52823,52823,52823,52823,50775,50743,50743,50743,50743,52823,52823,54904,54904,54904,54904,54904,54904,52856,52823,52823,50743,50743,50743,52791,52823,52855,52823,52823,52791,52791,52823,52823,52791,54871,54904,54904,54936,54968,54969,54936,56984,56952,56952,54903,54871,54903,54936,54936,54903,54903,54935,40016,17131,10890,10890,12970,19081,23177,10856,23242,23242,27759,25322,16968,8776,25257,14887,8646,27338,12807,8679,29418,21227,48565,48565,48565,50710,46419,44370,44370,46483,44338,44370,44403,44403,44403,44403,44403,44403,44403,44403,42355,42355,40242,38096,42355,42355,42355,40275,42323,40274,42323,40242,40242,38194,38162,33936,33936,36081,36081,36081,36016,35594,43980,35594,21096,21096,25257,46093,35593,16902,21096,35658,46093,33545,19015,19015,35627,39982,4291,131,6501,12839,10662,14823,4291,2275,2243,6501,6436,2243,2243,163,4356,4388,19015,18886,29320,18853,18853,23014,18821,14693,10597,4323,4323,4259,6306,6339,10532,12612,10532,6371,8452,10532,8452,10532,8452,8452,8484,8516,8484,12645,16773,14692,14692,10500,10532,10532,10532,8419,10532,10532,10564,12677,6339,4259,6371,6404,4323,6403,8484,8516,10564,6371,4291,16870,21031,20868,14660,14660,12580,10532,8451,10500,8419,8419,4259,2243,10629,8419,10532,14660,8451,4323,4291,8452,8452,8419,10499,10499,8451,10500,8419,8419,10500,6339,4258,10499,6339,4258,6339,8419,10499,8419,26},
{50743,50743,50743,50743,50743,52823,52823,52823,52823,50775,50743,50743,50743,50743,52823,52856,54904,54904,54904,54904,54904,54904,52856,52823,52823,50775,50743,50743,52791,52823,52855,52823,52823,52791,52791,52823,52791,52823,52823,54904,54904,54936,54968,54968,56984,56984,56952,56952,54904,54903,54904,54936,56984,54903,54903,54935,44274,21324,15147,15180,17163,19081,33611,29515,33611,31563,29548,31563,31531,29483,33611,29483,29482,33579,29482,29483,35692,33742,48565,48565,48564,50678,33806,8679,19179,46386,12840,6566,6599,6566,6534,6534,4453,4453,6501,14855,4421,4453,4389,4389,4389,4389,4356,4389,4388,6501,14823,4356,4356,2308,2243,2276,2243,2243,2243,2243,4388,33481,43948,35561,21063,21063,23176,46093,35626,18951,21095,33546,46061,35593,21063,21063,31465,19081,12678,12710,16935,14888,14855,14823,10629,12774,14855,12710,12677,8549,8614,12710,10630,8581,14887,6436,16967,12677,6436,10565,14725,14693,8484,6372,10532,8387,6339,8419,10532,14693,12645,8451,8451,8419,10532,6371,4259,4291,4259,6371,6371,10564,18853,20901,14692,14693,14757,12612,14660,8451,8451,4259,6371,6371,8484,2210,6404,8452,6339,6404,6371,8484,10500,4258,2178,12677,16838,20901,16708,12580,10499,8451,8452,10532,12580,8419,6339,6339,4323,8484,6404,6371,2211,4258,6371,6371,4291,6339,6339,8419,12580,10532,6371,6371,8419,8419,4291,8419,6339,4259,6339,8419,10499,8419,24},
{50743,50743,50743,50743,50743,50743,52823,52823,52823,50775,50743,50743,50743,50743,52823,52856,54904,54904,54904,54904,54904,54904,52856,52823,52823,50743,50743,50743,52791,52823,52823,52823,52823,52791,52791,52823,52823,52823,52823,54904,54904,54936,54936,54936,56984,56984,56984,56952,54904,54904,56984,56984,56984,54904,54903,54936,52823,27663,19405,19405,19340,21162,21097,8776,21097,21162,8776,21097,16968,8808,25257,14920,8743,27338,12840,6599,29451,21227,48597,48565,46516,48630,31661,4388,17001,46386,18918,12644,12677,16805,14725,18885,12644,18885,12644,23110,12644,16805,8516,8516,10564,8484,10596,10564,12644,12677,16870,8484,8484,8516,8484,6404,6404,6436,4324,2243,6436,33513,43980,37641,21031,21063,23144,46093,35626,16903,21063,35626,46093,37674,21031,21063,31433,12743,14823,6436,21161,16935,21129,14823,14823,21161,25322,16871,14791,6436,4356,16936,14823,14790,4388,8581,12710,12677,12677,8484,6371,10500,18853,16740,14660,10499,8387,6339,10564,14758,14725,14725,8516,6339,8419,6371,6339,4291,6339,6339,6371,8484,18853,16773,12612,14692,14692,14692,14693,10532,10500,4291,6339,8451,6371,6371,6339,10564,10532,12612,8419,6371,8419,4258,2178,10661,12677,18853,12580,10532,6339,6371,10532,8419,10532,10499,10499,12580,14692,10564,8451,4258,6339,8451,14660,8419,4291,8419,8451,8451,10499,8419,6371,10499,8419,6371,2210,6339,8419,8419,6339,8419,10499,8419,22},
{50743,50743,50743,50743,50743,52823,52823,52823,52823,50775,50743,50743,50743,50743,52823,52824,54904,54904,54904,54904,54904,54904,54904,52856,52823,52823,52823,52791,52823,52823,54904,52823,52823,52823,52823,52823,52823,52823,52823,54904,54904,54936,54936,54936,56984,56984,56984,56952,54903,54904,54936,56984,56984,54936,54936,54936,52888,29808,19373,19373,19308,21162,29418,25290,29450,29450,25322,31498,29418,25322,33579,29418,27337,33579,29450,27370,35692,37902,48597,48565,37903,40113,31661,6437,17001,44273,14758,4356,2276,2276,2276,4324,2276,4324,4324,8549,4356,2276,2276,2276,2276,4356,4324,4324,2276,2276,4356,2276,2211,2276,2211,2276,2243,2243,2243,2211,2276,33546,44012,39754,18918,20999,23144,46125,37674,16870,21031,33578,46061,37674,18951,18983,27337,12775,14855,6437,21161,14887,21129,14823,14855,21291,25451,16871,14791,4259,2211,16936,16871,14758,2211,10662,14855,12677,12677,10532,12612,16773,18853,12580,12612,8419,6339,6339,10532,12645,12677,10564,8452,8451,8419,6339,4291,6371,4291,4291,4259,8452,14693,12612,12612,12612,12612,12612,10532,10500,8451,6371,6371,6371,8451,8451,6371,8516,8484,10532,6339,4259,6339,6339,2210,4324,10597,14693,10499,6371,4291,4291,6371,8484,8451,8451,10532,8451,8419,6371,2210,6339,6371,8419,10532,10500,10532,6371,8452,6371,8451,6339,6339,8419,6339,4259,2211,4291,8419,8419,8419,8419,10499,8419,21},
{50743,50743,50743,50743,50743,50743,52823,52823,52823,50775,50743,50743,50743,50743,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,52855,52823,52823,52791,52823,52823,54904,52823,52823,52823,52823,52823,54871,52823,54871,54904,54936,54936,54936,54936,56984,56984,56984,56984,54904,56984,56984,56984,56984,56984,54936,54936,52888,27760,19373,21486,19341,21194,23242,10921,23210,21161,12969,25290,17001,10856,27338,14952,10792,27370,12872,8776,31499,21291,48597,48565,48565,50678,40048,31467,33677,44371,31564,29451,29419,29418,29451,29451,31531,31531,31532,35757,33612,33612,31499,31531,33644,35725,35725,35725,35757,35757,35789,35757,37838,35789,35757,33676,35757,37837,37838,39918,39918,39820,43980,39787,6534,4486,8614,41965,35594,4421,4421,6566,41965,35594,2276,2308,2340,12775,14855,14823,19016,16968,16936,14823,14855,16968,16968,14823,14823,14823,16904,16904,16903,16903,14758,12742,16805,18853,20933,14693,14692,18853,12612,10532,10532,8451,10499,10499,14693,12645,8484,8484,6339,6371,8452,6371,8452,6371,4291,4291,6371,10532,14692,14692,14692,14660,10532,12612,10532,8451,4291,4291,2211,4259,4291,6339,4291,4291,6404,12612,8451,4291,4291,4259,4291,4259,4291,4291,2178,4291,4291,2178,2178,2243,4291,2211,4259,4259,2211,2211,6339,8419,6339,8419,8451,8419,6339,6371,4259,4291,6339,4291,4259,2211,2178,2178,2211,6339,8451,10499,8419,10500,12612,8419,21},
{50743,50743,50743,50743,50743,52823,52823,52823,52823,50743,50743,50743,50743,50743,52824,54904,54904,54904,54904,54904,54904,54904,54904,54904,52823,52823,52823,52791,52823,52823,54904,52823,54904,52823,52823,52823,54871,54871,54871,54936,54936,54936,54936,54968,56984,56984,56984,56984,56984,56984,56984,56984,56984,57016,54936,54936,52888,27760,17260,19341,15115,19081,25257,17000,25257,25257,19081,27338,23144,19049,29418,23177,19016,31499,23177,21096,33579,29548,48597,48565,48565,50677,40177,38129,38097,42290,31856,33936,31888,31888,31856,31888,31856,31855,29775,29775,29743,29743,27598,25550,27663,27663,29743,27662,27662,27662,27662,25582,27663,25550,25517,21324,23469,25517,23436,23437,23404,21194,21161,21129,10662,10694,16871,25322,16935,12677,14725,16838,25353,25288,16806,14725,14725,12775,14855,16903,16904,16903,14823,14823,14823,16904,16904,14823,14823,14823,16904,18984,16903,14791,14790,14790,20868,22948,20868,16772,18853,16805,16773,14693,14693,10499,8451,12612,12612,10532,8484,8419,8419,6371,8451,6371,4323,8452,6403,8451,6339,8484,8452,10500,16773,16740,10532,8452,4291,4259,8451,6371,4291,4291,4259,4259,4258,2211,2210,4323,4323,2211,4291,4259,2211,6339,2210,2211,2178,2178,4291,2211,2178,2178,2211,2211,4388,8516,2178,2210,2178,4291,4291,4291,4259,4291,6339,4291,4259,2178,130,130,130,130,2178,2178,4291,4291,10499,10499,10499,12580,12612,8419,22},
{50743,50743,50743,50743,52791,52823,52823,52823,50775,50743,50743,50743,50743,52823,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,52823,52855,52823,52823,52823,52823,54904,54904,54904,52823,52823,52823,54904,54903,54904,54936,54936,54936,54936,54936,57016,56984,56984,56984,56984,56984,56984,56984,56984,57016,54968,54936,54935,27759,19341,21486,19341,21162,27402,21258,27402,25355,19210,27435,21226,17130,29450,21194,17065,29451,19145,15017,31531,25485,48565,48564,48565,50678,35823,23178,31629,46419,18887,16807,16839,16839,20968,18919,18919,18919,20967,21032,21000,21032,18919,21000,23080,23112,23080,23112,25193,23112,25193,25225,31466,25193,25193,23113,31530,27111,27015,12516,18984,27338,21097,25258,27338,31531,29451,10694,6469,14758,14758,21064,8517,195,2243,10597,16806,14823,16968,16903,16904,16903,14855,14823,16936,16903,16903,14855,16936,14823,16904,18984,16936,16903,14791,12677,14659,20900,20933,16805,16773,16773,12612,12612,14725,18821,16772,14660,12547,8419,6339,8419,6339,6339,8419,6339,4259,6371,6371,8452,10532,6371,4291,6371,12612,8451,2211,12580,12612,14660,12580,12580,6339,4259,4259,4291,4259,2211,2211,2178,2178,2178,2211,2211,6339,4259,2178,2178,2178,2178,2211,4259,130,2178,4259,4259,2210,2178,2178,2178,2178,2178,4291,6371,4259,2211,6371,6371,4259,4259,2178,2178,2178,2178,2178,2211,2211,6339,8419,10499,12580,16740,14660,6339,22},
{50743,50743,50743,50743,52823,52823,52823,52823,50743,50743,50743,50743,50775,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,52855,52823,52823,52823,54904,54904,54904,54904,52823,52823,52823,54904,54903,54904,54936,54936,54936,57016,57016,57016,57016,56984,56984,56984,56984,56984,56984,57016,54968,54968,54936,54936,27727,19341,21486,19341,21162,21096,10792,21097,21129,14985,25257,19016,12872,27337,16936,12775,29418,16936,14855,31498,25388,48597,48564,48565,50710,42290,36017,40210,48564,46451,46451,48499,48499,46451,48499,46451,48531,46483,48531,46483,46451,44306,44370,48531,48531,48532,48532,48532,48532,48532,48532,48532,48532,46419,44306,46451,44176,38032,16904,16871,27274,21097,33839,46419,46419,31531,14790,2276,14790,14758,16871,4292,131,131,10597,16838,14823,16968,16903,16904,16903,16903,16903,16936,16904,16904,14855,16904,14823,16904,16936,16936,16903,10662,12710,14660,18820,29320,20998,12612,16805,12612,10532,16805,20901,18788,16708,12579,12580,10499,10499,10467,8419,10499,6339,4291,6371,4259,4291,6371,4291,6371,6371,4291,2178,8452,22981,16740,16773,12612,14692,10499,8451,4291,6339,4291,2211,2210,2178,4291,4258,4259,4259,6339,6371,6339,4291,4259,2210,130,130,2178,6339,8419,8451,10499,8419,8419,8419,6339,4291,6371,6339,6339,4291,8419,8452,6339,4259,4291,6371,4291,2211,2210,4259,4259,6339,6339,10499,12580,16740,14660,8419,23},
{50743,50743,50743,50743,50743,52823,52823,52823,50775,50743,50743,50743,50775,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,52855,52823,52823,54904,54904,54904,54904,54904,52823,54871,54903,54904,54936,54936,54936,54936,54936,57017,57016,57016,56984,56984,56984,56984,56984,57016,57016,57017,54968,54968,52855,27695,17292,21486,19308,21162,31563,27499,31563,29515,25387,31563,27435,25419,33611,25387,23306,33611,25387,23306,35692,31726,52726,52725,54773,52790,42161,37870,42161,48564,46451,46484,46516,46484,46484,46484,46483,46484,46484,46484,46483,44403,42258,46483,46484,46484,46484,46516,46516,46484,46516,46484,44436,44403,42258,40113,44403,42225,31726,21097,25388,42323,44338,44371,44371,44371,31563,23274,2276,14790,14758,14725,131,131,2178,12645,16838,12775,16903,16904,16936,16904,16903,16904,16903,16903,16903,14823,14823,16871,16903,16903,14855,14823,12742,14692,33252,33284,31204,18820,16740,14692,14692,16773,12612,16740,12547,14660,10499,10532,10499,6339,6339,6339,6339,6371,4291,4259,4259,4259,4291,8452,6371,6371,4291,4291,6371,8484,12612,12612,10532,8419,6371,8451,8451,6371,6339,4291,4291,4291,8419,8419,6339,8451,10532,10597,6404,2178,130,2178,4259,4259,8419,8451,8419,6371,10532,10532,12580,12580,10532,10532,12612,10500,10532,12580,10532,8451,8419,8419,8419,4258,2211,4259,4259,4258,4259,6371,6339,10500,10499,14660,14660,8419,23},
{50743,50743,50743,50743,52823,52823,52823,50775,50743,50743,50743,50743,50775,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,52855,52855,54904,54904,54904,54904,54904,52823,54871,54904,54936,54936,54936,54936,54936,57017,57017,57017,57016,57016,56984,56984,56984,56984,56984,57016,55001,55001,55001,52887,27695,17260,17260,19276,21194,21097,10856,23177,19081,8744,25258,14920,10856,25257,12840,8646,29418,10759,8614,31499,19114,50579,52627,52627,52758,35952,23372,31823,46484,14985,12905,14985,12905,17066,12905,10792,10825,8744,8744,8712,8712,8647,8679,8647,8647,8615,8615,6566,6566,6534,12646,12549,10566,4389,4421,4453,6469,6502,33904,14791,4324,4356,8582,23210,18887,8614,25355,4356,14758,16806,16805,6436,8549,16935,19016,16903,14855,16936,14823,16968,8614,16936,14823,12743,8582,12807,16871,14823,21258,25452,23177,14823,14855,12807,20933,43684,41604,31204,22949,25061,22981,18821,16773,14692,16740,16740,14660,12580,10532,12580,14693,12580,10499,6339,12612,4291,4259,4259,4259,6371,12612,16740,14692,10499,6371,4259,6371,8451,8419,8419,6339,6339,4291,6339,6339,6371,8452,8419,6339,6371,6371,8419,8419,4259,2178,130,2178,6339,6339,8419,6339,8419,6339,6371,6371,8451,10532,10500,10499,12580,12612,12580,12580,10500,10500,10532,10499,12612,6339,6339,4291,2178,2178,2211,4291,6371,6339,6371,8451,10499,14660,12580,8419,22},
{50743,50743,50743,50743,52823,52823,52823,50775,50743,50743,50775,50775,52823,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,52856,52856,54904,54904,54904,54904,54904,52823,54871,54904,54936,54936,54936,54936,54936,57017,57017,57017,57017,57017,57016,56984,57016,56984,56984,57016,57049,55001,55001,52887,25615,17260,15148,17163,23210,31531,29450,33579,31531,29483,33579,29483,27435,31531,29483,27435,35692,29483,27467,33644,29547,48369,50384,50384,52693,42161,35790,40080,48532,33677,33644,35757,35725,37870,37838,37838,39886,37838,39918,39918,39886,37805,39951,41999,42031,42031,42031,42063,44111,42031,42031,41998,41836,31304,31369,27047,33482,37870,27533,25323,44208,44176,46257,35562,35594,44208,31661,4356,16838,20999,23047,4389,4421,4421,4453,6534,14856,16936,8517,12775,2211,14855,14823,12678,2211,8549,16903,14823,21258,25516,25289,14855,12807,14855,16740,33284,33284,27076,20900,22981,20901,16740,16805,14725,20934,18821,16773,14693,14692,14725,14692,10532,12580,12612,14660,8451,6371,4291,6339,6371,14693,22982,20966,14692,16740,16740,14692,8452,8451,8451,10499,8451,6339,6371,6371,6339,10565,8419,8452,8452,8452,6339,4259,4259,6339,4291,14660,10499,10499,6339,6339,8419,6339,8419,8452,8451,8451,10499,12612,14660,12612,14693,10532,8451,8451,10532,8419,6339,8451,8419,2178,2211,2178,2178,2178,4259,4291,8419,10499,8419,12580,12580,8419,23},
{50743,50743,50743,50743,52823,52823,52823,52823,50775,50743,50775,50775,52823,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,52856,54904,54904,54936,54936,54904,52823,54904,54936,54936,54968,54969,54968,54969,57017,57017,57017,57017,57017,57017,57016,57016,56984,56984,57016,57049,55001,55001,52888,27727,17292,17260,15083,23210,21096,10856,23177,17001,8808,25257,12840,6696,25290,12839,6631,27338,10759,8711,29418,17098,44208,50384,50384,52693,35952,23372,33839,48564,46451,46484,48532,48564,48532,48564,48532,48532,48532,48532,48532,46419,44370,48564,48532,48564,48532,48532,46484,46484,48564,48564,48564,48564,44241,41966,41868,31337,42160,21097,14888,38064,42193,42193,42095,42030,42127,27370,4356,29385,37673,19015,4389,4421,4421,4421,6534,14855,16936,10597,14888,10630,16936,14855,10662,6469,8614,14855,14823,21291,25516,21129,14823,10662,12677,25028,35331,35332,27076,20901,22981,18820,14725,23111,16805,18886,16805,18886,14693,14725,12644,14692,12612,12644,14725,12612,10500,6339,4323,4291,6404,18886,20934,20934,16773,16740,16773,8419,4291,10500,16773,12612,10500,6371,8451,6371,4291,6371,6371,8419,8452,6371,6339,4259,4291,6371,12645,14660,10499,10499,6339,6339,6371,8419,6371,8419,12612,10532,12580,12612,14660,14692,16773,12612,10532,10532,14692,6371,4259,6371,10500,4258,2211,130,2178,2178,130,2178,4291,6371,6339,10532,10499,6339,24},
{50743,50743,50743,50743,52823,52823,52823,52823,50775,50775,50775,50775,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54936,54904,52823,54904,54936,54936,54969,54969,54969,57017,57017,57017,57017,57017,57017,57017,57016,57016,57016,56984,57017,57049,55001,55001,52888,25679,19373,19341,19341,23242,29418,25290,31498,29418,25289,33547,27338,25257,33579,27370,25289,33579,27370,27370,35659,29515,37902,42062,40014,48564,44371,42258,44371,48564,38162,38162,36082,38130,38162,38162,38130,38130,36049,36017,33969,31855,31856,33936,33936,31856,31888,31856,27565,29808,29808,29807,29807,29775,27630,27598,29678,23112,29548,21097,4324,8517,14855,16936,16903,21096,16839,23209,4324,25224,8549,10565,4389,4421,4421,4421,6534,29580,10597,10662,19016,29450,23177,16903,6436,4421,4388,8582,6436,12710,27305,21096,16903,14822,23144,20966,31301,27141,27142,20901,18821,14692,10532,12645,18854,25159,18853,18886,18854,14725,14693,12612,14693,12612,14693,8452,6371,6371,4291,4291,4291,16805,20966,16773,18820,10532,8451,4291,10499,12580,12612,10532,6339,8452,8484,8451,6371,6339,6371,8451,8452,4291,4291,8419,6371,14725,16806,14660,12579,8419,6371,6339,6339,8419,8452,8451,12612,12580,14692,14660,12580,10532,12580,12580,12612,14692,10532,6371,6339,6339,6339,2178,2178,130,130,2210,2178,98,130,130,130,130,2178,2178,20},
{50743,50743,50743,52823,52823,52823,52823,52823,50775,50775,50775,50775,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54936,54936,54904,52823,54904,54968,54968,54969,54969,54969,57017,57017,57017,57017,57017,57017,57017,57016,57016,57016,56984,57017,57049,55001,55001,50807,25647,17293,17260,19276,23274,23210,15050,25322,19113,12937,25290,17001,12904,29418,14952,8711,29450,10824,10792,29483,17195,8711,29483,8679,38098,46256,37772,42063,52660,35462,27109,29253,31301,35462,41701,27174,39623,35463,39621,33349,33349,27109,39588,41636,25029,29189,35429,39557,27109,22949,31269,29157,25029,20869,16773,25094,27109,25127,33514,14597,18660,20836,18788,20868,20901,16709,23209,4324,25289,33480,37641,4389,4421,4421,4453,6534,21226,8452,130,10629,8517,6436,14887,4323,4324,4324,14888,8484,6501,17000,14887,19016,6404,10694,4356,4388,6436,25028,20868,18787,16740,16740,14725,14725,18886,18886,16805,14693,14692,10532,12612,14693,12612,12645,10564,8419,6371,4291,4291,6371,8452,8452,14725,16740,8451,8419,10532,12580,14660,14660,10499,6371,6371,6371,6371,6371,6371,6339,6371,2211,4291,10500,10499,10499,12677,14725,14660,12579,6371,6339,6339,6339,8419,8451,10532,12612,14660,14660,14692,12580,14692,14660,12580,8451,6371,10499,10499,6339,2210,2178,2178,130,2178,2178,2178,2178,130,130,130,130,130,2178,2178,27},
{50743,50743,52823,50743,52823,52823,52823,52823,50775,50775,50775,50775,52823,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54904,54904,54904,54936,54936,54936,54936,54904,52823,54904,54969,54969,54968,54969,54969,57017,57017,57017,57017,57017,57017,57017,57016,57017,56984,56984,57017,57049,55001,54969,48662,23534,17293,17260,15083,23210,23177,19048,27338,23177,19048,29418,21096,19048,31499,23177,19016,31499,21129,21096,33644,25419,21129,33644,25257,44339,50449,41933,46256,56854,43881,35495,37608,37575,37543,41671,35496,43849,37609,43817,39656,37576,33383,43848,41768,31303,33416,37608,41769,35528,33448,35528,35528,35528,29287,27207,27142,31303,29418,12873,29354,31304,31336,31336,31336,33449,31337,27370,4356,23176,41834,41802,4389,4421,4453,4453,6534,21194,10532,6404,14822,12807,10727,10694,6372,4388,4421,4356,4356,8549,17032,17000,19016,10597,6469,2276,2276,6404,35364,33284,31204,29124,25028,14725,14725,14758,23046,18853,12580,12612,10532,6371,8516,6404,10564,8484,6371,4291,6371,6371,6371,8419,6371,10564,8419,8484,14692,12612,10532,12580,16740,14660,8419,8451,6371,6371,8451,6371,4291,6371,4259,6404,10532,10532,12612,16838,14725,10499,8419,6371,6339,6339,6339,6339,12580,12580,10532,12612,14692,16740,12612,14692,10532,8451,4291,4291,8419,8452,4259,2178,130,2178,2178,6339,6339,6339,6339,4258,2178,2178,130,2178,2178,4259,28},
{50743,50743,52823,52823,52823,52823,52823,52823,50775,50775,50775,52823,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54904,54904,54936,54936,54936,54936,54904,52823,54904,54936,54969,54969,54969,57017,57017,57017,57017,57017,57017,57017,57017,57016,57017,57017,56984,57017,57049,55001,44533,40145,23534,15147,15115,12970,23242,27435,21258,29483,25354,19178,29451,23306,25484,31531,21226,17097,31531,19113,14985,31563,23404,14953,31563,17130,36082,54773,50514,50612,56919,54773,54805,54805,54805,54805,54806,54806,54806,54806,54806,54805,52692,52692,54806,52660,54773,52757,52757,52725,52725,52725,52725,52725,50612,42063,46288,39820,46256,48369,44176,50612,50644,50644,50644,48564,48596,48564,35789,6469,23144,37674,35561,4389,6502,8582,4453,8614,21259,10564,4324,14790,8517,8517,4388,4356,4356,2308,2275,4356,6501,17032,17000,19080,14855,14855,6437,4388,6469,37412,33284,29189,29157,25061,14757,8549,12742,23046,20966,14693,14693,10532,6404,10564,10564,10564,10564,4291,6371,4291,4259,6371,8484,8452,6339,8419,12612,18821,14660,12580,14660,14660,8419,8419,6371,8451,4291,6371,6371,6371,8451,6371,10532,10532,10532,16773,18919,18918,8419,6339,8419,6371,4291,4259,4291,12580,12580,10499,14660,16773,12612,8484,6339,2211,2211,2178,4291,4291,2211,2211,4259,4259,4259,4259,6371,8419,8419,8419,10499,12612,8419,6339,4259,6339,6339,30},
{50743,50743,52823,52823,52823,52823,52823,52823,50775,50775,52823,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54904,54904,54936,54936,54936,54936,54936,52823,54904,54936,54969,54969,54969,57017,57017,57017,57017,57017,57017,57017,56984,57016,57016,57017,56984,57017,57049,48695,33871,33806,19308,17228,17260,17195,23242,19048,10792,25257,19048,12807,27337,19081,25549,29386,14887,12775,31466,14855,12775,31498,23339,14823,33579,16968,29678,54838,46418,48531,54903,48500,48435,48467,46387,46387,48467,46387,46387,46387,46387,46354,44209,42161,44273,46354,46354,46322,46321,46321,46321,46321,44241,44144,39950,35692,37773,44111,44273,44273,44241,44240,44240,44208,42192,42160,44241,42192,33644,8582,25289,39754,31432,4389,10727,14888,4421,12839,27565,10532,2211,12677,6339,4324,4356,4356,2243,2243,2211,4356,6469,12872,12839,12807,4324,4388,2243,2243,2276,18853,12645,10597,12677,10629,8484,6404,14725,10564,10532,8452,6371,6371,6371,6403,8452,8419,8452,6339,4291,2211,2211,6371,6371,6371,8419,10532,12580,14660,12612,12580,12612,12580,10500,6339,6339,8451,6371,6371,6371,4291,6403,6371,10500,10500,12612,12612,18918,14725,8419,6371,8451,6339,6339,4291,6339,12580,10499,6371,4291,4259,4291,4291,6371,6339,6339,8451,12580,6339,6339,6371,8419,6339,4291,6339,6339,6339,8419,10499,12612,12580,10499,8451,8419,8419,8419,32},
{50743,50743,52823,52823,52823,52823,52823,50775,50775,50775,52823,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54936,54904,54936,54936,54936,54936,54936,54936,52823,54904,54936,57017,54969,55001,57049,57049,57017,57017,57017,57017,57017,56984,56984,56984,57017,57017,57049,57049,48727,33838,33806,19340,17260,15180,15115,23242,31531,27467,33611,31563,27435,33611,27402,25387,33579,27402,25322,33611,25354,23274,35692,29580,25354,35692,25387,27565,56919,29613,27533,50710,44339,29678,27598,33839,29646,29645,27533,29613,27533,27533,29580,23307,23307,25420,27468,27468,25420,25387,25388,25355,25355,23242,21097,25257,19016,23242,23274,25355,23274,23274,23274,21194,21162,21161,19113,21129,21162,21194,8614,21096,41802,43914,6469,8679,14888,4453,12807,25517,10565,6469,16967,23273,19048,6469,4324,8581,18951,8484,6436,4356,12807,12807,10629,2243,6501,4388,4356,4356,6468,8581,14855,14855,12710,14725,16805,18886,18886,12612,8452,8452,10532,8452,6371,10532,8452,8452,4259,2211,4259,4259,4259,6371,8452,12612,14692,18853,18853,14692,16773,14660,8452,6371,6339,8451,6371,6371,4259,4291,6339,2243,6339,10532,10532,10532,12580,14725,12612,6339,8452,6371,4259,4259,2178,8419,8451,4259,2178,2178,6339,10499,8419,10532,10531,10532,12580,10532,10499,8419,8451,6339,4259,4291,6371,6339,6339,6371,12612,12579,8419,10499,8451,8419,6339,6339,32},
{50743,50743,52823,52823,52823,52823,50775,50775,50775,50775,52823,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,54904,54968,57017,57017,57049,57049,57049,57017,57017,57017,57017,57017,56984,56984,57016,57017,57017,57049,57049,31791,33806,33838,19308,15147,13002,12969,23210,19081,8776,25257,17001,8679,25257,12807,6631,27338,12807,6566,29386,10727,8647,31498,23469,8646,31466,10792,10792,54871,39982,37869,50645,44241,23275,23275,25387,23275,27468,21194,21194,21194,21194,21162,19049,21194,19113,17033,21162,17033,19082,19049,21065,16871,21000,16839,16968,19016,19049,19016,16936,16969,14856,19049,16936,19049,16968,19017,16936,19016,16968,12743,21096,39754,39786,6469,4453,6502,6502,8614,19179,10565,12677,21064,25257,16870,6404,4324,12710,21031,14725,16806,20967,25160,20999,18886,16806,21031,4324,2276,4388,10597,10629,12742,12710,10597,18853,14693,16805,18853,12644,12612,10532,8452,8452,8484,10532,8452,6339,6371,4291,8419,10532,6339,8452,10532,16773,14692,16773,18853,16772,16773,6339,10499,8452,8452,8452,8419,8451,8452,6339,8451,4291,8451,10500,12612,14692,14692,14725,16805,10499,10499,8419,6371,8451,8419,4291,2178,130,4259,10499,14692,18821,14660,14660,12612,14692,12612,8419,8451,10499,10467,4259,4291,6339,6339,4291,6339,8452,14660,12612,10499,10499,8419,6339,6339,6339,32},
{50743,52823,52823,52823,52823,50775,50775,50775,50775,52823,52823,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,54904,57017,57017,57049,57049,57049,57049,57017,57017,57017,57017,57017,57016,56984,57017,57017,57017,57049,54968,33774,33806,31726,19308,15147,13002,15050,23209,33546,31466,33579,33546,31466,33546,33546,31466,35627,33546,31466,35627,33546,35627,37739,35659,33579,37740,35691,35692,54839,50547,48434,54806,52693,48467,48467,48467,48467,48499,48499,48467,48467,48434,46322,42161,46419,46387,46419,46354,44241,42128,42095,42031,42096,44306,44306,42193,40080,42225,42225,42225,42193,42193,42193,42193,40113,42161,40112,40112,40080,35886,14823,12775,14887,16968,4421,4421,4421,6501,6534,19146,12677,23176,33643,35789,29450,16870,6436,19015,29450,33579,33579,33644,37772,35724,33644,31563,35691,6436,4388,6501,8549,10565,12645,14725,10565,18885,18918,18853,18853,12612,10532,8484,8452,10564,8419,6371,8451,12580,10499,10500,10564,12612,8451,12612,12612,16773,16741,14692,18853,12580,10499,8451,12580,10500,10532,8451,8451,8451,8451,8419,8419,4259,6371,8451,14660,14660,14693,16838,20966,16708,14660,8419,8419,10499,10499,2210,130,6371,12612,14692,16740,16740,16740,14692,12580,12612,12580,8419,8419,12580,10499,8419,6339,6339,4291,6339,8419,10532,12612,12580,10499,8419,6371,6339,4259,6371,40},
{50743,52823,52823,52823,52823,50775,50743,50775,50775,52823,52855,52856,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,54904,57017,57017,57049,57049,57049,57049,57017,57017,57017,57017,57017,56984,56984,57017,57017,57017,57049,57049,44208,37966,29613,17227,15147,10954,13002,37869,48303,48433,48271,48303,48433,48239,48336,48433,48271,48368,50481,50319,50448,50481,50384,50514,50513,52464,50546,50481,54806,48499,44241,50678,54838,48435,48435,50515,50515,50516,50547,50515,48402,48435,48402,44241,50547,50482,44014,46257,48304,46191,50450,50548,50548,50580,50580,48467,46354,50580,50580,50612,50580,50580,50580,50580,50580,50580,50547,50580,50579,44240,21129,8614,12807,19113,23274,21129,8582,4388,2308,19114,12677,17000,21129,8614,17000,16903,6436,2276,6566,33643,35724,10694,6631,29548,35724,21129,8582,2244,2308,6469,10597,12645,16806,18918,16806,16773,16773,16773,16773,14725,14725,12645,12612,10564,6371,8419,14660,14692,8451,8419,8484,6371,10500,12612,12612,16740,14692,16740,16740,10499,12612,14660,12612,12612,10532,6371,6371,8419,8419,8419,6371,6371,4259,6371,12612,10532,14693,18951,20999,20901,16740,10499,8419,8451,2210,130,4291,10532,12612,14692,12580,14660,16740,16740,14660,12580,12579,8419,8419,12580,10499,8419,6371,6371,6339,6339,10499,12580,12580,12580,10532,8419,6339,6339,6339,8419,45},
{50743,52823,52823,52823,52823,50743,50743,50743,50775,52823,52856,52856,54904,54936,54904,54904,54904,54904,54904,54904,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,54904,57017,57017,57049,57049,57049,57049,57049,57017,57017,59097,57017,57017,56984,57017,59065,57017,57049,57081,46386,37934,27532,17228,15147,10889,15083,33741,48401,48693,48401,48433,48693,48401,48433,50708,50416,48466,50708,50384,48498,50676,50417,50546,50644,52497,50611,50611,52660,52725,52627,52693,52822,52725,52692,52725,52692,52660,52692,50579,52659,52724,46418,46321,48498,48369,48304,48303,48401,50546,52692,50514,50514,46418,44305,40047,31758,46353,40079,33871,46353,37999,35919,48401,37967,33839,48369,33806,31758,39982,16935,8646,14920,17033,21226,17065,14888,6501,8582,19114,14758,14919,16935,4324,14855,18951,6404,2275,8614,31563,33644,8517,4356,25386,31628,23209,12742,2276,4388,6436,12677,10564,10564,12645,14725,20998,20998,20934,18886,10532,10564,10532,10532,10532,12612,12645,14692,12580,10500,8452,4291,12612,16773,16773,14692,16740,16740,18820,14660,16740,14660,12612,10500,8452,8484,8452,6371,8452,8419,8451,10499,8419,6371,4259,4323,8451,8484,12709,14757,16772,12580,8451,6371,2210,130,6339,14660,12580,10532,14660,14692,16740,20901,18821,14660,10499,8419,8419,8419,10499,8419,6339,8451,8419,4259,8419,12580,10500,12580,12580,10499,8419,6339,6339,6371,8419,44},
{52823,52823,52823,52823,52823,50743,50743,50743,50775,52823,52856,52856,54904,54904,54936,54904,54936,54904,54904,54904,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,54904,57017,57049,57049,57049,57049,57049,57049,57049,57017,59097,59097,57017,56984,57017,59065,57017,57049,57081,52758,46289,31564,29710,33871,33903,33838,31660,50384,48693,48434,48369,48725,46353,48369,50741,48401,48401,50773,48369,50513,50773,50417,50546,50741,50417,50578,52756,50416,50546,52691,50416,50611,50578,50417,52626,50513,52432,50513,48401,50416,50578,42030,41932,46287,44012,48238,52658,48336,50416,52691,50384,50416,48465,44143,39884,29515,44143,41997,33709,44175,37837,33741,46223,37901,31660,46255,33708,29580,41997,16935,8614,10727,17033,14920,12808,19146,4356,8582,19114,14758,14887,16935,10565,16903,18983,6404,8452,14790,31595,31563,16806,14758,23273,25386,21064,16871,10662,14855,12775,16903,6404,8451,8451,8516,12677,12709,23111,20966,10532,10564,10532,12612,10532,10532,10532,12612,12580,10532,8419,4291,12612,16805,16773,18853,18853,20933,22981,18820,16740,14660,12612,10532,10532,8452,10564,8484,6371,10532,10532,10500,6371,8419,6339,2178,2211,4259,4291,4259,2211,2178,2211,2178,130,4291,14692,14692,12580,12580,12612,14660,20901,22981,16740,10499,6371,8451,8419,10499,10499,10499,8419,6339,6339,4259,8419,10499,12580,12580,14660,10499,8419,6339,6339,8419,10499,41},
{50775,52823,52823,52823,50775,50743,50743,50743,50775,52823,52856,52856,54904,54936,54936,54904,54936,54936,54904,54936,54936,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,57017,57017,57049,57049,57049,57049,57049,57049,59097,59097,59097,57017,57017,57017,59097,57049,57049,57082,55001,48564,37772,33936,42451,42484,40371,40274,50352,50644,48531,50416,48628,46418,50417,48660,48433,50417,48692,48433,50449,50708,48401,50481,50741,50449,50514,52756,50416,50513,52691,50416,52561,52658,50417,50513,50481,50384,50546,48400,48238,46320,39852,43948,50480,48368,50384,52691,48368,50384,52691,50384,48336,50513,44143,39884,29579,42062,41997,33773,44110,35756,27499,44143,33643,25354,44143,29450,21161,41965,16871,10662,25290,29580,19016,14953,21227,4356,6534,17066,14758,21128,33643,35788,31563,19015,8517,16967,29482,19113,19081,23242,19081,14887,12807,19080,27402,12774,14920,10727,10759,6436,12612,12677,6404,10597,8484,6436,8484,10564,12645,14693,14693,10532,12612,12612,12612,12612,8451,8419,6371,12709,4291,6404,16773,18821,18821,25061,18820,14660,14660,14692,10564,8452,8452,8452,6371,8452,8419,12644,10499,8419,4291,4291,8419,10499,10532,14725,16838,10499,6339,2178,98,6339,12580,16740,12580,12580,10532,10500,14660,20901,20869,14692,6371,8451,10467,8419,12547,10499,8419,8419,6339,6339,8419,8451,10499,12612,12580,12580,8419,6339,6339,8419,8419,10531,43},
{50775,52823,52823,52823,50775,50743,50743,50743,50775,52823,52856,52856,54936,54936,54936,54936,54904,54904,54936,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,57017,57049,57049,57049,57049,57049,57049,57049,59097,59097,59097,57017,57017,59097,59097,57049,57049,57082,55034,57049,56984,42290,42484,40371,40371,44500,44110,48466,48596,48303,46483,48563,48304,48563,48498,50384,48628,48466,50384,46547,46385,50449,50773,50481,50449,52788,50384,50449,54804,50384,50513,54804,50384,48336,52691,50351,44110,46255,46126,44012,44110,46158,48498,48433,50384,50643,48400,50384,50643,48368,48336,50642,48303,44077,46287,48303,46190,42062,44110,41997,37836,46191,37836,27467,44143,33643,25354,41997,29482,27434,44045,41964,21129,10760,14985,6501,10694,19114,12677,10629,18983,27305,16870,4388,6404,6436,14758,2243,6436,2243,12775,6436,6469,2243,10597,4388,2341,4389,4421,6436,10532,8452,4324,10597,4323,6404,6404,12612,14693,16773,14693,14693,18853,14693,12580,10532,14692,16740,16740,10532,8484,8484,16773,14660,18853,22981,14660,12580,12580,12612,8452,8452,6371,6371,4291,8484,6339,12645,10500,6371,4291,8419,8451,14660,10532,10564,16837,10499,2211,2178,130,8452,12612,18821,12612,12580,10500,10532,16773,18853,16740,10531,8451,10499,10499,10499,12579,14660,8419,8419,6339,8419,10499,10499,12580,12612,14660,10532,8419,6339,6339,10499,10499,8419,29},
{50775,52823,52823,52823,50775,50743,50743,50743,50775,52823,52856,52856,54936,54936,54936,54936,54936,54936,54936,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54904,57017,57049,57049,57049,57081,57082,57082,57049,59097,59097,59097,59097,57017,59097,59097,57049,57049,57082,55034,57082,57082,46451,42484,40339,40339,42484,44143,48433,48693,48304,46386,48628,48271,46450,48595,48336,46417,42192,50384,42160,44240,50417,38063,37966,50449,50675,52529,50416,52723,50449,50481,54739,50384,50416,50481,48239,46190,46125,48239,48368,42094,46191,48400,46287,50416,48432,42062,50384,50545,48368,50384,52658,46255,44078,50577,48303,48303,50513,44175,44143,46384,44110,37804,21194,40014,31530,19048,39917,25289,21161,46190,48140,25159,10662,4421,10760,14920,19146,14725,6469,16935,21096,18983,2243,6436,6436,10662,4388,6468,2275,6469,6436,6436,4323,14790,2276,2276,2276,2308,4324,6371,6371,2243,4388,8484,10564,10565,12612,16805,14693,14693,18853,16773,14693,10532,10532,12612,12580,12580,8452,8419,6371,14692,20901,20901,22981,16740,14660,12612,12612,6339,8484,10564,8419,4259,8452,8419,12612,14660,4259,8452,8451,10500,12580,10532,12645,10532,6371,2178,4258,2211,10532,12580,16740,12612,12580,12580,10499,14692,18821,12612,10499,10531,10499,10499,10499,10499,12547,8419,8419,8419,10500,12612,12580,14660,12580,12580,10499,8419,6339,8419,10499,10499,10467,29},
{50775,50775,52823,52823,50775,50775,50743,50775,50775,52823,52855,54904,54936,54936,54936,54936,54936,54936,54936,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54969,57017,57017,54936,57017,57049,57049,57049,57081,57082,57082,57082,57049,57049,59097,59097,59097,59097,59097,57049,57081,57082,55034,55034,57082,48597,40371,40338,40338,42452,40079,46288,46547,44240,44272,46547,46255,46353,46547,46288,46417,46514,48336,40079,46417,48400,44337,42192,50449,50708,50513,50416,54771,50449,48368,50643,42062,48271,50448,46126,48335,52691,48304,48400,42191,44143,48368,44239,48304,48465,50513,50384,50577,48433,50352,46416,40013,44078,44239,42062,48303,48497,46223,44077,42094,44110,44045,27337,42030,35691,23209,39917,33611,29483,44143,46092,31466,25289,2179,6534,12872,14985,14757,2243,8581,6404,12839,2243,6436,4323,4324,4388,8581,4323,4356,4388,8581,4323,4324,2243,2276,2276,2276,4324,8419,6339,6339,10565,10565,14725,14725,14693,18853,12613,12645,12644,16773,14660,12612,10532,12580,12580,12612,10532,8419,8451,16773,18820,20933,22949,14660,14660,14660,14692,6371,8452,8452,10532,4291,6371,6371,10564,4291,8452,10532,8451,10532,10532,10532,12677,14757,10499,2211,2178,6371,12612,14660,14692,12612,10532,8451,10532,10532,12612,10532,10499,10499,12579,12579,10499,10467,8419,8419,8451,6371,12580,12580,14692,14660,14692,12580,8419,6339,8419,8419,10499,8419,8419,26},
{50775,52823,50775,50775,50775,50775,50743,50775,50775,52823,52855,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54937,54937,57017,54937,57017,57017,57017,54936,57017,57049,57049,57049,57082,57082,57082,57082,55034,57082,59097,59097,57049,57049,59097,57049,57081,57082,55034,57082,57082,52823,36081,40306,42419,40338,40306,42354,42419,42354,42354,44499,42354,40273,42418,36015,33967,38193,40241,40273,40273,42353,42386,44401,48336,50611,50546,52465,52659,46223,48271,50545,46158,46125,46385,42159,46223,31725,42127,42062,25354,42095,46288,35853,46256,35821,29612,48336,35821,33773,50384,29547,27467,44078,23306,29580,46191,27499,35821,44110,29612,35821,37836,21161,37902,35723,19080,37837,31563,27467,42257,42225,40112,23274,2179,2211,4389,14953,14725,2211,8581,2276,8679,2243,6436,2243,163,2243,8549,2275,4356,4388,4388,4323,4388,2276,163,2243,2276,17033,21161,16870,4259,12677,12677,14725,14725,14693,16773,14693,12645,14693,14693,14693,14692,14692,12580,12580,14660,14660,12612,10532,16740,18820,20901,22981,16708,14660,12612,10500,6371,8452,6371,8419,4291,6371,4291,2211,8452,14693,12612,8451,10499,10499,10500,10564,12612,12579,130,6371,12580,14660,12612,14660,12580,10499,10499,8451,10532,12580,8451,10499,10499,12580,12579,10499,10499,8419,8451,10499,8451,10532,14660,16740,16740,14660,8451,8419,6339,8419,10499,10499,8419,6339,27},
{50775,52823,50775,50775,50743,50743,50775,50775,50775,52823,52856,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54937,57017,57017,57017,57017,57017,57017,54936,57017,57049,57049,57049,57082,57082,57082,57082,55034,57082,57050,59097,57049,57049,59097,57049,57081,57082,55034,57082,57082,57081,46483,42419,42387,42354,42354,44467,44402,44402,46515,46483,44402,44337,42257,42257,40176,38096,38031,33838,31790,27661,29742,29742,42095,46450,48530,48336,48304,46224,44077,41965,39885,48336,37869,39982,46223,37869,42030,44078,31531,41998,41997,35724,42062,39884,37772,46191,39852,39852,46191,39852,37772,41965,37739,39852,44110,39884,44078,44045,39884,41997,41997,39852,41997,41965,37707,39853,41932,39885,42257,42257,25322,16903,8452,6372,6534,14953,14725,2275,8646,19048,17000,16903,8484,4388,8614,10694,10629,4356,6534,8614,14855,8517,12807,4356,131,163,2276,14823,14823,14725,8419,10597,14790,12677,16805,14692,20934,14693,14693,14725,12612,12612,12612,12612,16773,12612,10499,12580,12612,14660,18821,18821,18853,22981,16740,10499,8451,6371,8419,4291,4323,8452,6371,8419,4259,6371,12612,12580,12580,10500,10532,10532,8451,10564,12645,20933,2178,8484,12612,12612,12612,10532,10532,10499,8451,8419,10532,12580,10499,10531,10499,12579,12579,12547,8419,8419,10499,10499,8419,12612,16773,18821,16740,12580,8419,6339,6339,10499,12547,12579,6339,8419,31},
{52823,52823,50775,50775,50775,50775,50775,50775,50775,52823,52856,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54937,57017,57017,57017,57017,57017,57017,54936,57017,57049,57049,57082,57082,57082,57082,55034,55034,57082,57082,57050,57050,57049,59097,57049,57081,57082,57082,57082,57082,57082,57049,57049,57049,57049,57049,59097,59129,59129,59129,59129,59129,59129,59129,59130,59130,59130,59129,33709,23274,27435,29548,29548,29548,31563,44110,46224,46256,44013,25224,37772,41933,41933,41900,41933,39852,41901,41933,37739,33547,39820,39820,39852,39820,39820,37739,37740,37740,37740,39820,39820,37739,35627,37707,39852,39852,39820,39852,39820,39820,39852,39820,39852,39852,39820,35627,35627,37772,37805,42257,42225,21162,21193,27402,23144,6501,14953,14725,2211,8581,14790,12678,16968,8484,4388,6501,4356,10661,4356,6469,6469,12807,4323,4388,4388,131,163,2276,10759,4388,4356,12547,10564,12742,14790,12677,16773,16773,12613,12645,14725,16773,10532,10500,10532,12612,10532,12612,10532,6371,8452,18821,18820,22981,20901,14660,10499,6371,6339,4291,4323,6404,6371,6371,8419,8451,12580,12580,10500,12612,12612,10499,8451,6339,6339,6403,10532,2211,2211,10532,12580,10499,8451,6339,10500,10500,10499,10532,10499,10467,8419,8419,10499,10499,10499,8419,8451,10499,10499,6371,14693,18821,18820,14660,10499,8419,8419,6339,10499,14660,10499,8419,6339,26},
{52823,52823,52823,50775,50775,50775,50775,50775,52823,52823,52856,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54937,54937,57017,57017,57017,57017,57017,57017,57017,54936,57017,57049,57049,57082,55034,57082,57082,55034,55034,57082,57082,59130,57082,57049,57049,57049,57081,57082,55034,57082,57082,57082,57082,57082,57114,57114,57114,57114,57114,59162,59130,59162,59130,59162,59162,59162,59162,59162,59130,37772,31498,27467,29516,31531,39918,44144,41965,46126,50352,50351,25160,37740,41932,41933,41933,44013,44045,41933,41933,37739,35659,41900,41900,41932,39852,39820,39820,39820,39852,39788,37739,39787,37739,35627,39820,39820,39820,39820,39820,37740,39852,41900,39820,39852,39820,41932,35659,37739,16871,27467,42257,40177,23209,14790,21161,16838,4356,14953,14693,2276,8582,10759,12807,6533,6404,2243,6469,2276,6468,163,2308,4388,6469,2211,6501,8549,131,163,2276,8646,8517,8517,10629,12677,12677,16871,16806,14693,14725,14725,16806,16805,14725,12612,10532,12612,10500,6339,8419,4291,4291,10564,18853,18853,22981,18820,12580,10532,6339,4259,4291,4323,4291,4259,4291,8419,8451,14660,10532,10532,10532,12580,10532,10532,8419,8452,8451,4291,4259,4259,4291,8419,8419,6371,6371,8451,8451,8451,8419,10499,10499,8419,10499,10499,10499,10499,8419,8451,10532,10499,12612,16773,18821,18853,14660,8451,8419,8419,8419,10499,10499,10467,8419,6339,24},
{50775,52823,52823,52823,50775,50775,50775,50775,52823,52823,52856,54904,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54937,57017,57017,57017,57017,57017,57017,57017,57016,57017,57049,57049,57082,55034,57082,57082,55034,55034,57082,57082,57082,57082,57049,57049,57049,57082,57082,55034,57082,57082,57114,57114,57114,57114,57114,57114,57114,57114,59130,59130,59130,59130,59130,59130,57114,57114,59162,59162,50352,46125,29516,31596,37935,42096,27338,35724,48238,50319,48238,29417,37739,41900,41933,41933,41965,44013,41933,41933,37739,37707,41932,41900,41900,41900,41900,41900,41900,41900,39852,39820,39820,37707,35626,39820,39820,39820,39820,39852,39820,39820,41900,41900,41932,41900,41900,33546,37739,14790,21259,42257,23274,16968,25224,21161,21096,14790,17033,12645,2276,6469,6501,8581,6469,6436,2275,6469,4356,6436,2211,163,2276,4356,4291,10662,8517,2211,163,2276,8582,2211,2211,6469,12775,16935,21161,18983,14757,14725,14758,14693,14693,18886,12612,12612,12612,10532,8419,8419,4291,2211,12612,18853,20901,25094,22981,12612,10532,8451,6339,6371,6371,6404,6371,6371,8452,12580,14660,10532,10532,10532,8451,8451,10532,10532,8451,8452,4291,4291,8452,10532,8451,6339,4291,6371,8419,6371,6339,8419,10499,8419,8419,10499,8419,10499,12580,10499,8419,10499,10532,14693,16773,18821,16740,10499,8419,6339,8419,10499,12579,10499,8419,6339,4259,17},
{52823,52823,52823,52823,52823,52823,52823,50775,52823,52856,52856,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,57017,57017,57017,57017,57017,57017,57017,57017,57017,57049,57049,57082,55034,57082,57082,57082,55034,57082,57082,57082,57082,57049,57081,57081,57082,57082,55034,57082,57114,57114,57082,57114,57114,57114,57114,57114,57114,59130,59130,59130,59130,59130,59162,57114,57114,57114,57114,52497,46125,31596,23145,29386,31628,25322,29483,50319,50351,50351,31466,37739,44013,44013,44013,43981,41933,41933,41933,39820,39820,44013,41933,44013,41932,41933,41933,41932,41933,41933,39820,39820,35626,37707,39820,41933,41965,39852,39820,39787,39820,39820,39852,41933,41933,39820,35626,39820,18951,25420,42257,25258,14823,29417,25225,21161,10759,21226,18886,12677,16838,18951,16838,10597,14725,16806,16838,10500,14725,14693,14725,14725,14758,16773,18919,10630,163,163,2276,2340,4388,4356,2276,6501,14887,10597,8517,12677,12613,10532,12613,14725,16805,12612,10564,10532,10532,8419,8451,8452,6371,16740,18853,18853,18853,14660,10499,12612,8451,8419,4291,6404,6404,4291,6371,6372,6371,10500,12580,8451,8419,8451,6339,12612,8452,6404,8452,6339,4291,6371,12580,10499,6339,6339,6339,6339,6339,6339,6339,10499,8419,10499,8419,8419,10499,12580,12580,10532,12580,12612,14660,14692,16772,10531,8419,8419,8419,8419,12579,10499,8419,8419,6339,4259,17},
{52823,52823,52823,52823,52823,52855,52855,52824,52855,52856,52856,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,56984,56984,57017,57017,57017,57017,57017,57017,57017,57017,57017,57049,57081,57082,57082,57082,57082,57082,55034,57082,57082,57082,57082,57081,57081,57082,57082,57082,55034,57082,57114,57114,57082,57114,57114,57114,57114,57114,57114,59130,59130,59130,59130,59130,59130,57114,57114,57114,57114,54708,46125,31596,27338,29580,31661,23274,21129,48238,48238,46093,33578,33579,41900,43981,41933,41933,44013,41933,41933,39820,37739,41933,39852,41900,41900,39820,39820,39820,39852,39820,39820,41900,37707,39820,41932,41932,41900,41932,41933,41900,41900,41900,41933,41900,41900,39787,35627,39787,18919,16968,42258,42193,29451,29450,23112,2308,2308,29580,39852,39885,39917,39918,41998,39917,37837,41998,41998,39918,39885,39917,39950,39950,39917,39917,39885,16871,2211,163,2276,2308,2308,2308,2243,6436,10662,14855,8517,10597,10565,10564,12677,10532,12613,10532,10564,10532,10532,6371,4291,4291,4291,16805,22981,14692,23014,16740,14660,12580,6371,6371,2211,4291,4291,4291,4291,6339,6371,10532,8451,8451,8451,8419,10499,12612,6371,6371,6371,4291,4291,4323,12580,6371,4291,6371,6371,6339,6339,4259,6339,8451,8419,8419,8419,8419,10499,12612,10499,12580,12612,12612,14660,16740,14660,10499,6339,6371,8419,12547,12579,10499,8419,6339,4259,4259,17},
{52823,52823,52823,52823,52823,52856,52856,52856,52856,52856,52856,54904,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,56984,56985,56985,57017,57017,57017,57017,57017,57017,57017,57049,57081,57082,57082,57082,57082,57082,55034,57082,57082,57082,59130,57081,57082,57082,57082,57082,55034,57082,57114,57114,57114,57114,57114,57114,57114,57114,57114,59130,59130,59130,59129,59130,59130,57082,57114,57081,57081,54805,46093,29516,31661,31693,31693,25354,14855,50351,52432,50384,41965,33579,39885,39917,39917,37837,37837,37837,39917,35756,33611,35724,33676,35756,35724,33643,33611,31563,33643,31563,31563,31531,25289,29483,29483,29483,27434,27370,27402,27402,27402,27402,27402,27434,27434,23209,23209,25289,14823,27532,42290,44370,29515,31498,29418,21031,2276,29580,39917,39950,39950,39982,42031,42030,39950,42031,42030,42030,41998,39950,42030,41998,41998,39950,39917,16838,2211,163,2276,2308,2308,2308,2276,8614,6469,12742,12710,10597,10597,10597,10565,8484,10532,10564,10564,10564,8484,2211,2243,4291,4291,16773,18821,20901,35593,14659,8451,6371,4323,4291,2211,4291,4291,4259,4291,4291,8452,14660,8419,8419,10532,6371,8451,12612,8419,6371,8451,6371,4291,2243,8451,4259,2211,6371,6339,4291,6339,4291,8419,8419,10499,8419,6339,8419,10500,12580,12580,10532,12580,12580,12612,14660,10499,8419,6339,6339,10499,12580,12579,10499,10467,6339,4258,2178,18},
{52823,52823,52823,52856,52823,52856,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,56984,56985,56985,57017,57017,57017,57017,57017,57017,57049,57049,57049,57082,57082,57082,57082,57082,55034,57082,57082,57082,59130,57082,57082,57082,57082,57082,55034,55034,57114,57114,57082,57114,57114,57114,57114,57114,57114,59130,59130,59130,59130,59130,59130,57081,57081,57081,57081,59097,59031,31661,31661,31661,31661,23274,8582,42062,46223,42094,35788,4356,2308,4356,2276,2276,2276,2276,2308,2276,2276,2276,2243,2276,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,4291,4292,4291,4291,4292,4324,4324,4324,8549,19081,42290,44370,25290,29418,31531,25160,2211,29580,39917,39950,39982,42063,42063,42031,39982,42031,42030,41998,39950,39950,39950,42030,39950,39950,39950,31498,2211,163,2276,2308,2308,2308,2308,6501,10694,8517,10597,10629,10597,8549,10597,10565,10565,8517,8517,8517,8484,2178,2211,6371,10532,23014,20901,14692,29255,12579,12547,10499,6404,2211,2211,4323,4291,4291,6371,6371,6339,10532,6371,10500,8452,6371,6371,10500,10532,10532,8484,4259,2178,2178,130,130,2178,130,2211,4259,6339,6339,8419,6371,8419,6371,8419,6339,8451,10499,10499,8451,12580,10532,14692,12580,8419,6339,4259,6339,12579,12580,12579,10499,8419,6307,4259,2178,16},
{52823,52823,52823,52856,52856,52855,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,56984,56985,57017,57017,57017,57017,57017,57017,57017,57049,57049,57081,57081,57082,57082,57082,57082,55034,57082,57082,57082,57082,57082,57082,57082,57082,57082,55034,55034,57082,57114,57114,57114,57114,57082,57114,57114,59130,59130,59130,59130,59130,59130,59130,57081,57081,57081,57081,57081,57049,35822,35822,33774,33741,33709,27403,29548,31628,25355,25355,25322,25322,23242,23242,23274,21194,21194,21194,19049,19081,19113,19081,19113,19081,19081,19081,19081,19081,19049,19049,17000,14920,14920,17000,14920,14920,14920,14920,14920,14920,14920,12839,12840,12840,10727,10727,12807,10630,21194,44370,44402,33676,35724,35724,31498,4324,29548,39918,41998,42030,39982,42030,42031,39982,42063,42031,41998,39950,39950,42030,42030,39950,39950,39917,33546,4291,163,2276,2308,2308,2308,2308,6469,10694,10629,12645,10629,10597,10597,10597,10597,8549,8549,8549,8549,6436,4324,4291,4291,8484,22981,18820,16740,25029,12547,12579,12579,6339,6371,2211,4323,2243,2211,6371,6371,6371,12580,6371,6339,6339,8419,10499,10500,6371,6436,2210,4259,8419,4291,2178,2178,2178,2178,2178,98,2210,4291,6339,6371,6339,6371,6371,6339,10532,12580,10499,8419,8451,8451,10500,8419,6339,6339,6371,6371,10499,10499,12580,10467,8419,4259,2178,2178,15},
{52823,52823,52823,52823,52856,52823,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,56984,57017,57017,57017,57017,57017,57017,57049,57049,57049,57049,57081,57081,57082,57082,57082,57082,55034,57082,57082,59130,59130,57082,57082,57082,57082,57082,55034,55034,57082,57114,57114,57114,57082,57082,57114,59130,59130,59130,59130,59130,59130,59130,59129,57081,57081,57081,57081,57081,57048,37903,35790,35822,35854,27435,6469,12808,21161,4388,4356,4356,2308,2276,2244,2276,2276,2243,2276,2243,2243,2243,2243,2244,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2211,2211,2243,2211,2211,2211,2211,2211,2211,2211,2211,2211,2243,2211,8549,12775,42225,44273,35789,44111,29515,23209,4324,29548,39917,35789,35789,29548,29548,29580,35757,27467,27500,27500,35821,31628,29612,29580,29548,35757,29580,27435,4291,163,2276,2308,2308,2308,10662,6436,19048,25354,16902,10597,10597,10597,10629,8581,8549,8549,8549,8549,8517,4356,4291,6371,12612,22981,20869,14692,20868,16805,14692,12612,4291,6371,4291,4291,4291,4291,6371,4291,6371,6371,4291,2210,2211,2211,4291,4291,4259,6371,8452,6339,4291,2210,2178,2178,2178,2211,4291,4258,2178,98,130,130,2211,4259,4259,6371,10532,12580,10532,6339,2211,4291,4291,4291,4259,4259,4259,8419,8419,8419,10499,8419,10467,4259,4259,4259,13},
{52823,52823,52823,52823,52823,52823,52856,52856,54936,52856,52856,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,57017,57017,57017,57017,57017,57017,57049,57049,57049,57049,57082,57082,57082,57082,57082,57082,55034,57082,57082,59130,59130,57082,57082,57082,57082,57082,55034,55034,57082,57114,57114,57114,57114,57114,59130,59130,59130,59130,59130,59129,59129,59129,59129,57081,57081,57081,57081,57081,54968,31403,37774,29387,35886,27435,2276,12775,21161,2276,4324,2276,2276,2276,2244,2276,2276,2276,2276,2244,2244,2244,2243,2244,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,8549,12742,40209,46385,48336,48271,10532,131,6372,33676,42030,35724,37739,29385,31466,33579,39885,33546,35627,35659,39885,37772,39852,39884,39917,41965,39884,37771,6372,163,2276,19016,10662,10694,10662,10630,8549,14822,14725,10597,10629,10597,10727,4356,4356,4356,8549,8517,6436,4291,4291,4291,12612,22981,22981,18821,18820,14757,16773,12580,8451,6371,4291,6372,4291,4291,6371,6339,6371,6339,10532,6371,6339,4259,6339,10532,6371,8484,10532,12580,6371,4259,2211,4259,4259,4259,2178,2178,2178,2178,4259,2178,2178,98,98,98,130,2178,130,98,98,98,98,98,130,2178,4259,10499,8419,8419,10499,8419,6371,4259,4323,4323,14},
{52823,52823,52823,52856,52856,52856,52856,54936,54936,54936,54904,54904,54936,54936,54936,54937,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,57017,57017,57017,57017,57017,57017,57049,57049,57049,57049,57082,57082,57082,57082,57082,57082,55034,57082,57082,59130,59130,57082,57082,57082,57082,55034,55034,55034,57082,57114,57114,57114,57114,57114,59130,59130,59130,59129,59129,59129,59129,57081,59129,57081,57081,57081,57081,57016,50612,31370,39918,27080,35854,27467,2276,12808,21161,2276,4324,2276,2276,2276,2243,2276,2243,2243,2276,2243,2243,2243,2243,2243,2243,2243,2243,2211,2243,2211,2243,2243,2243,2243,2211,2211,2243,2211,2243,2211,2211,2243,2211,2211,2211,2243,2243,2211,8549,6436,2341,42062,48173,50579,12645,163,35724,42062,23144,27337,35659,37739,39852,39917,39917,39885,41965,41965,39884,39885,41933,41965,41965,39852,37739,18983,4356,163,2276,25419,23177,23209,21096,6371,10662,12742,18918,10597,10629,10597,10629,8485,6436,6436,8485,8484,6404,2243,6371,2211,14693,22981,20901,20901,18820,16740,14660,10532,4291,2211,4291,8452,6371,6371,6371,6371,6339,8452,10532,8451,8419,12580,10500,14660,8419,10532,14692,12580,4259,4259,4259,4291,4291,2178,4259,6339,4291,4259,6371,6371,4259,6339,4226,6339,2178,98,98,98,98,2178,2178,130,2178,4259,10532,12645,8484,8549,6501,8582,6469,8582,8581,4388,22},
{52823,52855,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54936,54936,54937,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,54936,57017,57017,57017,57017,57017,57017,57049,57049,57049,57081,57082,57082,57082,57082,57082,57082,55034,55034,57082,57082,59130,57082,57082,57082,57082,55034,55034,55034,57082,57114,57114,57114,57114,57082,59130,59130,59130,59129,59129,59129,59129,57081,57081,57081,57081,57081,57081,57081,56951,31435,37903,31435,37935,29516,6502,19114,21161,2276,4324,2276,2276,2276,2243,2276,2244,2243,2276,2243,2243,2243,2243,2244,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2211,2243,2211,2211,2243,2243,2243,2211,8549,6404,2276,35789,37803,27532,2243,2211,35757,42030,33514,31433,35594,35627,37707,37739,37772,39852,41900,39852,37772,39853,41900,41901,39852,39820,39820,20999,4324,163,2276,25452,27565,31790,29515,8419,8484,10629,18918,27273,27305,27273,23144,21031,18983,16903,16870,20999,20967,8484,6371,4291,20965,25029,18821,20901,16740,14660,14692,10499,4291,8517,23112,14693,6371,6371,6371,6339,12612,6371,12645,10532,10500,12580,12612,14660,8451,12645,8451,6371,2211,4291,4259,4259,4259,2210,6371,8419,8419,4259,6339,8419,8451,8451,4291,2178,98,4258,6339,6371,6339,6339,4259,4291,8549,12775,12840,10695,10695,12807,8582,6533,4421,4388,4356,2276,14},
{52823,52823,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54936,54936,54937,54936,54937,54936,54936,54936,54936,54936,54936,54936,54936,54936,56985,54936,57017,57017,57017,57017,57017,57017,57017,57049,57049,57082,57082,57081,57082,57082,59130,57082,55034,55034,57082,57082,57082,57082,57082,57082,57082,55034,55034,55034,57082,57082,57082,57082,57082,57082,59130,59130,59130,57081,59129,59129,59129,57081,57081,57081,57081,57081,57081,57081,44403,25388,14921,27468,37934,29516,4389,14921,21161,2276,4324,2276,2276,2276,2243,2276,2244,2243,2276,2243,2244,2243,2243,2276,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2211,2243,2243,2243,2243,2211,2243,2243,2243,2243,2211,8549,6404,2276,42062,48238,37673,6371,2211,35724,41966,39853,37740,37739,37771,37772,39820,37837,39917,41965,41965,37804,41933,41965,41933,41965,39885,39852,21031,4356,131,2276,12872,14985,15017,12839,8484,6339,10597,16935,35691,35691,33611,27401,19048,23208,23144,21031,25192,25159,8452,4323,4356,25094,22949,20901,22981,14660,14660,14692,12580,8451,10727,29580,18918,8452,6371,6371,6339,16773,10564,18885,10532,10499,10499,12580,16740,12580,14693,12580,8419,4291,4291,4291,6339,2210,4259,4291,4291,4291,6339,8451,6339,2178,98,2146,6339,10532,10532,10500,8419,8419,8484,12807,17033,14953,14953,14952,12839,14888,12742,10694,10662,6501,6469,6468,6469,27},
{52823,52823,52856,52856,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54936,54937,54937,54937,54936,54936,54936,54936,54936,54936,54936,56984,56985,56985,57017,57017,57017,57017,57017,57017,57049,57049,57049,57049,57082,57081,57082,57082,59130,57082,55034,55034,57082,57082,57082,57082,57082,57082,57082,55034,55034,55034,57082,57082,57082,57082,57082,57082,59130,59130,57081,59129,59129,59129,59129,57081,57081,57081,57081,57081,57081,57081,42226,35887,12840,27500,37935,29516,2276,12808,21161,2276,4356,2276,2276,2276,2243,2276,2243,2243,2276,2243,2243,2243,2243,2244,2243,2243,2243,2211,2243,2243,2243,2244,2243,2243,2211,2211,2243,2211,2243,2211,2211,2243,2211,2243,2243,2243,2211,2211,8549,6404,2244,25386,25289,16935,4291,2211,35724,41966,41965,31531,31530,14823,14823,19016,33643,16871,16903,21064,29483,41966,41965,41965,41965,41933,39853,12710,6404,163,4356,4421,6469,4421,6469,10629,6339,12645,16935,25322,25322,25321,21128,21128,21031,21031,25159,29255,27175,16740,12580,12612,25061,20901,22981,25029,12579,10499,12580,10532,8484,6436,6436,6404,4291,4291,10532,4291,18853,12644,20933,12612,12580,12580,12580,25094,12580,12677,16740,12579,6339,4291,8419,6339,2211,4259,4259,6339,6339,8451,10500,6371,2178,2211,10532,12612,12612,10532,10532,8452,16936,19178,19178,19178,21226,19145,21226,21161,17000,14887,14822,12709,10629,8516,6436,4356,25},
{52823,52824,52856,52856,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54937,54937,54937,54937,54937,54936,54936,54936,54936,54936,54936,56984,56984,56985,57017,57017,57017,57017,57017,57017,57049,57049,57049,57050,57082,57082,57082,59130,59130,57082,55034,55034,57082,57114,57082,57082,57082,57082,57082,55034,55034,55034,57082,57082,57082,57082,57082,57082,59130,57081,57081,59129,59129,59129,57081,57081,57081,57081,57081,57081,57081,57081,50580,33806,10695,27500,37967,27467,2276,12840,21161,2276,4356,2276,2276,2276,2243,2276,2243,2243,2276,2243,2243,2243,2243,2244,2243,2243,2243,2211,2243,2211,2243,2244,2211,2243,2211,2211,2243,2211,2211,2211,2211,2243,2211,2211,2243,2211,2276,10630,10630,8517,4356,2276,4389,6469,2211,2211,40014,50384,50416,50384,50351,48303,48303,52464,44110,48303,48336,50416,46223,48304,48336,50417,46223,31725,31725,16936,2276,2243,6501,8614,8614,8614,8582,8549,10565,6339,10532,10500,10499,10499,8451,8452,16805,8452,23014,27174,16773,16805,18853,20901,22981,22981,25061,22981,12579,10499,12580,6371,4259,2243,8516,10500,6371,4291,8484,6371,25094,12644,18853,14660,12580,12612,12580,31335,10532,16838,22981,14628,8419,4291,6339,6339,4291,4291,6339,6371,10499,10499,10500,10499,10500,6403,10532,12612,12580,10532,10532,19146,23372,23339,23339,25452,25387,23274,17000,14822,12644,6371,8419,8419,6339,4259,4258,2178,23},
{52823,52824,52856,52856,52856,52856,52856,52856,52856,54936,54936,54936,54936,54936,54937,54937,54937,54937,54937,54936,54936,54936,54936,54936,56984,56984,56985,56985,57017,57017,57017,57017,57017,57049,57049,57049,57049,57082,57082,57082,57082,59130,59130,57082,55034,55034,57082,57114,57082,57082,57082,57082,57082,55034,55034,57082,57082,57082,57082,57082,57082,57082,59130,57081,57081,57081,59129,59129,57081,57081,57081,57081,57081,57081,57081,57081,56951,35854,12808,29613,37967,27468,2276,12808,21194,2276,4356,2276,2276,2276,2243,2276,2243,2243,2276,2243,2244,2243,2243,2243,2243,2243,2243,2211,2243,2211,2243,2243,2243,2243,2211,2211,2243,2211,2243,2211,2211,2243,2211,2243,2243,2211,2276,27532,14758,12710,12710,10597,6469,6469,2211,2211,37934,50449,44175,40046,42127,44175,44207,37998,19080,23338,27499,25451,19113,31693,35853,35886,31693,17066,17098,17098,4356,4421,6534,8614,8647,8679,8614,8614,6534,10629,16772,29156,29156,27076,16805,10564,14822,14693,22981,25029,20901,18853,18821,20933,22981,22981,25061,20869,12579,10499,14660,6371,4259,4356,21193,14725,8419,8452,12612,12612,29222,16805,25061,14660,16740,12612,14692,31335,14659,18918,22981,14660,6371,6339,6339,8419,4291,6339,8419,10499,12612,10499,8451,12580,12612,8451,12580,14660,10532,8452,14920,27565,27532,27500,23339,21193,18983,14692,10499,10532,8419,6339,6339,6339,4259,4258,4258,2210,18},
{52823,52823,52856,52856,52856,52856,52856,52856,52888,54936,54936,54936,54936,54937,54937,54937,54937,54937,54937,54936,54936,54936,54936,54936,56984,56984,56984,56985,56985,57017,57017,57017,57017,57049,57049,57049,57049,57082,57082,57082,57082,59130,59130,57082,55066,55034,57082,57114,57114,57082,57082,57082,57082,55034,55034,57082,57082,57082,57082,57082,57082,57082,59129,57081,57081,57081,59097,59097,57081,57081,57081,57081,57081,57081,57081,57049,36017,29613,10695,27500,37935,27435,2276,12808,21193,2276,4324,2276,2276,2276,2243,2276,2244,2276,2276,2244,2244,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2276,21227,14790,12710,12710,10630,8582,10727,4324,19081,37966,42160,27273,8516,12742,21129,14823,2308,6404,2243,6468,2211,8549,18983,8517,12839,19146,17066,17098,17098,17066,12840,10792,10792,10792,10792,8582,4324,2276,8549,20933,29156,29124,27076,18885,16772,16772,18853,20868,22948,18820,18821,16740,18853,22981,22982,22981,18821,14660,12580,14660,10532,10532,6371,8516,12645,8452,10564,12612,16805,29222,20933,25061,16740,14660,12612,14660,31367,14660,18951,20933,8419,6339,6339,6371,4291,4259,6339,8451,12580,12579,8419,8451,10532,12580,8419,10532,12612,8451,6404,19210,21194,21258,19113,12742,10532,12580,10532,10499,8419,6339,4291,4259,4259,4259,4259,4258,2178,14},
{52823,52823,52856,52856,52856,52856,52856,52856,52856,54936,54936,54936,54937,54969,57017,54937,54937,54937,54937,54936,54936,54936,54936,54936,54936,56984,56984,56985,56985,57017,57017,57017,57017,57049,57049,57049,57049,57082,57082,57082,57082,59130,59130,57082,55034,55034,57082,57114,57082,57082,57082,57082,55034,55034,55034,57082,57082,57082,57082,57082,57081,57081,57081,57081,57081,57081,59097,59097,57049,57081,57081,57081,57049,57049,57049,57048,29548,29581,10663,27500,35919,27468,2276,12808,21161,2276,4324,2276,2276,2276,2244,2276,2244,2276,2276,2243,2243,2243,2243,2244,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2243,2211,2243,2211,2211,2243,2211,2211,2243,2276,2276,19114,14823,8517,6437,6469,4389,4389,163,6566,10759,14985,25225,163,131,6534,6469,2243,4356,131,2211,2211,8549,4389,2211,163,6534,17066,17098,17098,17066,14985,12905,12873,12873,12872,10630,2243,10565,14758,12645,8452,8452,8452,8452,8452,8452,8452,31335,39656,22981,18821,18853,25094,20901,23014,23014,20901,18853,18853,12612,10532,14693,12645,14693,8452,6371,10532,12612,18886,29222,18853,22949,18820,16740,12580,14660,35463,12580,21096,20966,12547,6339,6339,6371,4259,4291,12612,14692,18853,14693,14692,12644,12645,12645,10564,14725,14757,12612,4356,12904,14919,12710,4291,2243,8452,8452,10532,8419,6339,6339,4258,4259,4259,4259,4259,4259,4259,14},
{52823,52856,52856,52856,52856,52856,52856,52856,52856,54936,54936,54936,54969,54969,57017,57017,57017,54937,54937,54936,54936,54936,54936,54936,56984,56984,56984,57017,56985,57017,57017,57017,57017,57049,57049,57049,57049,57082,57082,57082,57082,59130,59130,57082,55034,55034,57082,57082,57114,57114,57082,57082,55034,55034,55034,57082,57082,57082,57081,57081,57081,57081,57081,57081,57081,57049,59097,57049,57049,57049,57049,57049,57049,57049,57049,57048,33806,33774,33741,31661,33773,25322,4324,12775,19049,4324,4356,4324,4324,4324,4324,4324,4324,4324,6404,4324,6404,6404,6404,6404,6404,6404,6404,6436,6436,6436,6437,6437,6436,6436,8485,8485,8517,8485,8517,8517,8517,8517,8517,8517,8517,6469,4324,8582,8582,6404,2211,2244,8582,12710,4324,163,163,8614,23112,2243,131,6534,8582,163,4323,131,131