/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.context;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.context.DefaultSimpleHandler;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.midi.MIDIDeviceManager;
import org.rz.midiplayer.midi.MidiEventListener;
import org.rz.midiplayer.xmlmodule.deviceinfo.Instrument;

public class Player
implements Loggable {
    protected MidiDevice midiOutDevice;
    protected MidiDevice midiInDevice;
    protected long playTimeInMicroSeconds;
    protected Sequencer sequencer;
    protected File currentFile;
    protected File currentDirectory;
    private static final MidiEventListener emptyMidiEvtListener = new MidiEventListener(){

        @Override
        public boolean handleMidiEvent(int ch, int status, byte[] data, int length) {
            return false;
        }

        @Override
        public boolean handleSysExEvent(byte[] data, int length) {
            return false;
        }

        @Override
        public boolean handleMetaEvent(int type, byte[] data, int length) {
            return false;
        }
    };
    protected MidiEventListener midiEventListener = emptyMidiEvtListener;
    protected final Receiver receiverForListener = new Receiver(){

        @Override
        public void send(MidiMessage message, long time) {
            if (Player.this.midiEventListener == null) {
                return;
            }
            byte[] data = message.getMessage();
            int length = data.length;
            int status = message.getStatus();
            int channel = status & 0xF;
            if (status == 240) {
                Player.this.midiEventListener.handleSysExEvent(data, length);
            } else {
                Player.this.midiEventListener.handleMidiEvent(channel, status, data, length);
            }
        }

        @Override
        public void close() {
        }
    };

    public Player(MidiEventListener lisner) {
        this.midiEventListener = lisner;
        if (lisner == null) {
            this.midiEventListener = emptyMidiEvtListener;
        }
        try {
            this.sequencer = MidiSystem.getSequencer(false);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "cannot get the Sequencer INSTANCE.", e);
        }
    }

    public Player() {
        this(null);
    }

    public void dispose() {
        logger.info("************** Dispose THIS Player - begin ************** ");
        this.stop();
        MIDIDeviceManager.close(this.midiOutDevice);
        MIDIDeviceManager.close(this.sequencer);
        logger.info("************** Dispose THIS Player - end ************** ");
    }

    public synchronized boolean play(File f) {
        this.stop();
        try {
            if (f == null) {
                logger.warning("f is null.");
                return false;
            }
            if (this.sequencer == null) {
                logger.warning("sequencer is null.");
                return false;
            }
            if (this.midiOutDevice == null) {
                logger.warning("midiOutDevice is null.");
                return false;
            }
            if (!this.midiOutDevice.isOpen()) {
                this.midiOutDevice.open();
            }
            if (this.midiInDevice != null && !this.midiInDevice.isOpen()) {
                this.midiInDevice.open();
            }
            this.sequencer.open();
            this.sequencer.getTransmitter().setReceiver(this.midiOutDevice.getReceiver());
            this.sequencer.getTransmitter().setReceiver(this.receiverForListener);
            if (this.midiInDevice != null) {
                this.midiInDevice.getTransmitter().setReceiver(this.midiOutDevice.getReceiver());
                this.midiInDevice.getTransmitter().setReceiver(this.receiverForListener);
            }
            this.sequencer.setSequence(MidiSystem.getSequence(f));
            this.playTimeInMicroSeconds = this.sequencer.getMicrosecondLength();
            this.currentFile = f;
            this.currentDirectory = f.getParentFile();
            logger.info("Loaded MIDI file : " + f.toString());
            this.sequencer.start();
            return true;
        }
        catch (MidiUnavailableException ex) {
            logger.log(Level.SEVERE, "cannot open the Sequencer.", ex);
            if (this.midiOutDevice != null) {
                logger.warning("MIDI OUT : " + this.midiOutDevice.getDeviceInfo().getName());
            }
        }
        catch (InvalidMidiDataException im) {
            logger.log(Level.SEVERE, "Invalid MIDI data : " + f, im);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "I/O Error : " + f, ioe);
        }
        return false;
    }

    public synchronized boolean startRealTimeInput() {
        this.stop();
        try {
            if (this.sequencer == null) {
                logger.warning("sequencer is null.");
                return false;
            }
            if (this.midiOutDevice == null) {
                logger.warning("midiOutDevice is null.");
                return false;
            }
            if (this.midiInDevice == null) {
                logger.warning("midiInDevice is null.");
                return false;
            }
            if (!this.midiOutDevice.isOpen()) {
                this.midiOutDevice.open();
            }
            if (!this.midiInDevice.isOpen()) {
                this.midiInDevice.open();
            }
            this.midiInDevice.getTransmitter().setReceiver(this.midiOutDevice.getReceiver());
            this.midiInDevice.getTransmitter().setReceiver(this.receiverForListener);
            this.playTimeInMicroSeconds = 0L;
            return true;
        }
        catch (MidiUnavailableException ex) {
            logger.log(Level.SEVERE, "cannot open the Sequencer.", ex);
            if (this.midiOutDevice != null) {
                logger.warning("MIDI OUT : " + this.midiOutDevice.getDeviceInfo().getName());
            }
            if (this.midiInDevice != null) {
                logger.warning("MIDI IN : " + this.midiInDevice.getDeviceInfo().getName());
            }
            return false;
        }
    }

    public synchronized void stop() {
        MIDIDeviceManager.stop(this.sequencer);
        MIDIDeviceManager.close(this.midiInDevice);
        MIDIDeviceManager.close(this.midiOutDevice);
        MIDIDeviceManager.close(this.sequencer);
    }

    public boolean isPlaying() {
        return this.sequencer != null && this.sequencer.isRunning();
    }

    public synchronized void setMidiOutDevice(MidiDevice dev) {
        this.stop();
        this.midiOutDevice = dev;
        if (dev != null) {
            logger.info("set midi out device : " + dev.getDeviceInfo().getName());
            logger.info("Max Receivers : " + dev.getMaxReceivers());
            logger.info("Max Transmitters : " + dev.getMaxTransmitters());
        }
    }

    public synchronized void setMidiInDevice(MidiDevice dev) {
        this.stop();
        this.midiInDevice = dev;
        if (dev != null) {
            logger.info("set midi in device : " + dev.getDeviceInfo().getName());
            logger.info("Max Receivers : " + dev.getMaxReceivers());
            logger.info("Max Transmitters : " + dev.getMaxTransmitters());
        }
    }

    public synchronized void setMidiEventLister(MidiEventListener p) {
        this.midiEventListener = p == null ? emptyMidiEvtListener : p;
    }

    public int getPlayTimeInSecond() {
        return (int)(this.playTimeInMicroSeconds / 1000000L);
    }

    public int getCurrentTimeInSecond() {
        int t = 0;
        try {
            t = (int)(this.sequencer.getMicrosecondPosition() / 1000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return t;
    }

    public int getBPM() {
        int ret = 120;
        try {
            ret = (int)this.sequencer.getTempoInBPM();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static void main(String[] args) {
        Vector<MidiDevice> devList = MIDIDeviceManager.getDeviceList();
        try {
            File file = new File("C:/Users/Rose/Home/Documents/develop/java/j2se/MIDIPlayer/work/test0.mid");
            Context ctx = new Context();
            DefaultSimpleHandler h = new DefaultSimpleHandler(ctx){

                @Override
                public void programChange(int ch, Instrument inst) {
                    logger.info("PC: ch=" + ch + " inst:" + inst.getName());
                }
            };
            ctx.addMidiEventListener(h);
            ctx.play(file);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        MIDIDeviceManager.closeAllDevice();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            Thread.sleep(20000L);
            ctx.dispose();
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

