/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import javax.sound.midi.MidiDevice;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.logging.Log;
import org.rz.midiplayer.logging.Loggable;
import org.rz.midiplayer.midi.MIDIDeviceManager;
import org.rz.midiplayer.plugin.PluginManager;
import org.rz.midiplayer.plugin.info.PluginInfo;
import org.rz.midiplayer.plugin.renderer.RendererPlugin;
import org.rz.midiplayer.ui.CautionDialog;
import org.rz.midiplayer.ui.LafChangeAction;
import org.rz.midiplayer.ui.LogWindow;
import org.rz.midiplayer.xmlmodule.appconfig.ApplicationConfig;

public class MainWindow
extends JFrame
implements Loggable {
    private final ResourceBundle resourceBundle = ResourceBundle.getBundle("org.rz.midiplayer.ui.resources.MainWindow");
    private final Context context;
    private RendererPlugin renderer;
    private File selectedMidiFile;
    private final Vector<JRadioButtonMenuItem> midiOutMenuItemList = new Vector(32);
    private ButtonGroup deviceInfoButtonGroup;
    private JMenu deviceInfoMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private ButtonGroup lafButtonGroup;
    private JMenu lafMenu;
    private JMenuBar menuBar;
    private ButtonGroup midiInButtonGroup;
    private JMenu midiInMenu;
    private ButtonGroup midiOutButtonGroup;
    private JMenu midiOutMenu;
    private JMenuItem openLogWindpwMenuItem;
    private JMenuItem openMenuItem;
    private JMenu optionMenu;
    private JMenuItem playMenuItem;
    private JMenuItem realTimeMenuItem;
    private ButtonGroup rendererButtonGroup;
    private JMenu rendererMenu;
    private JMenuItem stopMenuItem;
    private JMenu toolMenu;

    public MainWindow(Context context_) {
        this.context = context_;
        this.initComponents();
    }

    private void initComponents() {
        this.lafButtonGroup = new ButtonGroup();
        this.rendererButtonGroup = new ButtonGroup();
        this.midiOutButtonGroup = new ButtonGroup();
        this.midiInButtonGroup = new ButtonGroup();
        this.deviceInfoButtonGroup = new ButtonGroup();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.openLogWindpwMenuItem = new JMenuItem();
        this.toolMenu = new JMenu();
        this.playMenuItem = new JMenuItem();
        this.stopMenuItem = new JMenuItem();
        this.realTimeMenuItem = new JMenuItem();
        this.optionMenu = new JMenu();
        this.midiOutMenu = new JMenu();
        this.midiInMenu = new JMenu();
        this.rendererMenu = new JMenu();
        this.deviceInfoMenu = new JMenu();
        this.lafMenu = new JMenu();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                MainWindow.this.onWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                MainWindow.this.onWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                MainWindow.this.onWindowOpened(evt);
            }
        });
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText(this.resourceBundle.getString("fileMenu.label"));
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText(this.resourceBundle.getString("openMenuItem.label"));
        this.openMenuItem.setToolTipText(this.resourceBundle.getString("openMenuItem.tooltip"));
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onOpenMenuAction(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.exitMenuItem.setMnemonic('X');
        this.exitMenuItem.setText(this.resourceBundle.getString("exitMenuItem.label"));
        this.exitMenuItem.setToolTipText(this.resourceBundle.getString("exitMenuItem.tooltip"));
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onExitMenuItemAction(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.openLogWindpwMenuItem.setMnemonic('L');
        this.openLogWindpwMenuItem.setText(this.resourceBundle.getString("openLogWindowItem"));
        this.openLogWindpwMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onOpenLogWindpwMenuItemAction(evt);
            }
        });
        this.fileMenu.add(this.openLogWindpwMenuItem);
        this.openLogWindpwMenuItem.setEnabled(Log.loggingEnabled);
        this.menuBar.add(this.fileMenu);
        this.toolMenu.setMnemonic('T');
        this.toolMenu.setText(this.resourceBundle.getString("toolMenu.label"));
        this.playMenuItem.setAccelerator(KeyStroke.getKeyStroke(32, 0));
        this.playMenuItem.setMnemonic('P');
        this.playMenuItem.setText(this.resourceBundle.getString("playMenuItem.label"));
        this.playMenuItem.setToolTipText(this.resourceBundle.getString("playMenuItem.tooltip"));
        this.playMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onPlayMenuItemAction(evt);
            }
        });
        this.toolMenu.add(this.playMenuItem);
        this.stopMenuItem.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.stopMenuItem.setMnemonic('S');
        this.stopMenuItem.setText(this.resourceBundle.getString("stopMenuItem.label"));
        this.stopMenuItem.setToolTipText(this.resourceBundle.getString("stopMenuItem.tooltip"));
        this.stopMenuItem.setEnabled(false);
        this.stopMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onStopMenuItemAction(evt);
            }
        });
        this.toolMenu.add(this.stopMenuItem);
        this.realTimeMenuItem.setAccelerator(KeyStroke.getKeyStroke(32, 2));
        this.realTimeMenuItem.setMnemonic('R');
        this.realTimeMenuItem.setText(this.resourceBundle.getString("realTimeMenu.label"));
        this.realTimeMenuItem.setToolTipText(this.resourceBundle.getString("realTimeMenuItem.tooltip"));
        this.realTimeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.onRealTimeMenuItemAction(evt);
            }
        });
        this.toolMenu.add(this.realTimeMenuItem);
        this.menuBar.add(this.toolMenu);
        this.optionMenu.setMnemonic('O');
        this.optionMenu.setText(this.resourceBundle.getString("optionMenu.label"));
        this.midiOutMenu.setMnemonic('O');
        this.midiOutMenu.setText(this.resourceBundle.getString("midioutMenu.label"));
        this.setupMidiOutMenu();
        this.optionMenu.add(this.midiOutMenu);
        this.midiInMenu.setMnemonic('I');
        this.midiInMenu.setText(this.resourceBundle.getString("midiInMenu.label"));
        this.setupMidiInMenu();
        this.optionMenu.add(this.midiInMenu);
        this.rendererMenu.setMnemonic('R');
        this.rendererMenu.setText(this.resourceBundle.getString("rendererMenuItem.label"));
        this.setupRendererMenu();
        this.optionMenu.add(this.rendererMenu);
        this.deviceInfoMenu.setMnemonic('D');
        this.deviceInfoMenu.setText(this.resourceBundle.getString("deviceInfoMenu.label"));
        this.deviceInfoMenu.setToolTipText(this.resourceBundle.getString("deviceInfoMenu.desc"));
        this.setupDeviceInfoMenu();
        this.optionMenu.add(this.deviceInfoMenu);
        this.lafMenu.setMnemonic('L');
        this.lafMenu.setText(this.resourceBundle.getString("optionMenu.laf.label"));
        String current = UIManager.getLookAndFeel().getName();
        for (UIManager.LookAndFeelInfo i : UIManager.getInstalledLookAndFeels()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            item.setSelected(i.getName().equals(current));
            item.setAction(new LafChangeAction(i, this));
            item.setText(i.getName());
            this.lafMenu.add(item);
            this.lafButtonGroup.add(item);
        }
        this.optionMenu.add(this.lafMenu);
        this.menuBar.add(this.optionMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void setupRendererMenu() {
        String current = this.context.getConfig().getPlugin().getRenderer().getName();
        for (PluginInfo i : this.context.getRendererPluginManager().getPluginInfoList()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            item.setSelected(i.getName().equals(current));
            item.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem it = (JMenuItem)e.getSource();
                    MainWindow.this.context.getConfig().getPlugin().getRenderer().setName(it.getText());
                    MainWindow.this.startRendering();
                }
            });
            item.setText(i.getName());
            item.setToolTipText(i.getDescription() + " - Author: " + i.getAuthor() + " (ver " + i.getVersion() + ")");
            this.rendererMenu.add(item);
            this.rendererButtonGroup.add(item);
        }
    }

    private void setupMidiOutMenu() {
        Vector<MidiDevice> devs = MIDIDeviceManager.getMidiOutDeviceList();
        String current = this.context.getConfig().getMidiout().getName();
        this.midiOutMenuItemList.removeAllElements();
        for (MidiDevice i : devs) {
            String name = i.getDeviceInfo().getName();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            item.setSelected(name.equals(current));
            item.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem it = (JMenuItem)e.getSource();
                    MainWindow.this.context.getConfig().getMidiout().setName(it.getText());
                }
            });
            item.setText(name);
            this.midiOutMenu.add(item);
            this.midiOutButtonGroup.add(item);
            this.midiOutMenuItemList.addElement(item);
        }
    }

    private void setupMidiInMenu() {
        Vector<MidiDevice> devs = MIDIDeviceManager.getMidiInDeviceList();
        String current = this.context.getConfig().getMidiin().getName();
        for (MidiDevice i : devs) {
            String name = i.getDeviceInfo().getName();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            item.setSelected(name.equals(current));
            item.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem it = (JMenuItem)e.getSource();
                    MainWindow.this.context.getConfig().getMidiin().setName(it.getText());
                }
            });
            item.setText(name);
            this.midiInMenu.add(item);
            this.midiInButtonGroup.add(item);
        }
    }

    private void setupDeviceInfoMenu() {
        String current = this.context.getConfig().getDevicefile().getFile();
        Vector<File> deviceDefs = this.context.getDeviceInfoList();
        for (File i : deviceDefs) {
            String name = i.getName();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            item.setSelected(name.equals(current));
            item.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem it = (JMenuItem)e.getSource();
                    try {
                        MainWindow.this.context.loadDeviceFile(it.getText());
                    }
                    catch (Throwable ex) {
                        Loggable.logger.log(Level.SEVERE, "cannot reload device info file : " + it.getText(), ex);
                    }
                }
            });
            item.setText(name);
            this.deviceInfoMenu.add(item);
            this.deviceInfoButtonGroup.add(item);
        }
    }

    private void onWindowClosed(WindowEvent evt) {
        this.terminateApp();
    }

    private void onPlayMenuItemAction(ActionEvent evt) {
        if (this.selectedMidiFile != null) {
            this.renderer.onMidiPlayingBefore(this.selectedMidiFile);
            if (this.context.play(this.selectedMidiFile)) {
                this.updateMenuItemEnabled(true);
            }
        }
    }

    private void onWindowOpened(WindowEvent evt) {
        this.startRendering();
        if (this.isMidiOutNotSelected()) {
            CautionDialog d = new CautionDialog((Frame)this, true);
            d.setVisible(true);
        }
    }

    private void onWindowClosing(WindowEvent evt) {
        this.stopRendering();
    }

    private void onOpenMenuAction(ActionEvent evt) {
        File current = new File(this.context.getConfig().getLastdirectory().getDir());
        JFileChooser chooser = new JFileChooser();
        if (current != null && current.exists() && current.isDirectory()) {
            chooser.setCurrentDirectory(current);
        }
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".mid");
            }

            @Override
            public String getDescription() {
                return "MIDI file(*.mid)";
            }
        });
        if (chooser.showOpenDialog(this) == 0) {
            this.selectedMidiFile = chooser.getSelectedFile();
        }
    }

    private void onStopMenuItemAction(ActionEvent evt) {
        this.context.stop();
        if (this.renderer != null) {
            this.renderer.onMidiStoped();
        }
        this.updateMenuItemEnabled(false);
    }

    private void onOpenLogWindpwMenuItemAction(ActionEvent evt) {
        LogWindow win = new LogWindow();
        win.setVisible(true);
    }

    private void onExitMenuItemAction(ActionEvent evt) {
        this.dispose();
    }

    private void onRealTimeMenuItemAction(ActionEvent evt) {
        if (this.context.startRealTimeInput()) {
            this.updateMenuItemEnabled(true);
        }
    }

    private synchronized void updateMenuItemEnabled(boolean play) {
        this.playMenuItem.setEnabled(!play);
        this.stopMenuItem.setEnabled(play);
        this.realTimeMenuItem.setEnabled(!play);
        this.midiOutMenu.setEnabled(!play);
        this.midiInMenu.setEnabled(!play);
        this.rendererMenu.setEnabled(!play);
        this.lafMenu.setEnabled(!play);
        this.deviceInfoMenu.setEnabled(!play);
    }

    private synchronized void startRendering() {
        try {
            this.stopRenderingImpl();
            ApplicationConfig conf = this.context.getConfig();
            String rendererName = conf.getPlugin().getRenderer().getName();
            PluginManager<RendererPlugin> mgr = this.context.getRendererPluginManager();
            this.renderer = mgr.newInstance(this.context, mgr.getPluginInfo(rendererName));
            Component screen = this.renderer.getComponent();
            this.setResizable(this.renderer.isEnabledResizeWindow());
            this.getContentPane().add(screen, "Center");
            this.pack();
            this.renderer.startRendering();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "cannot start rendering...", e);
        }
    }

    private synchronized void stopRendering() {
        logger.info("Main window closing...");
        this.stopRenderingImpl();
    }

    private synchronized void stopRenderingImpl() {
        if (this.renderer != null) {
            logger.info("Stop current renderer...");
            this.renderer.stopRendering();
            this.remove(this.renderer.getComponent());
            this.renderer.onDispose(this.context);
            this.renderer = null;
            logger.info("Stopped current renderer...");
        }
    }

    private void terminateApp() {
        this.context.saveAppConfig();
        this.context.dispose();
        System.exit(0);
    }

    private synchronized boolean isMidiOutNotSelected() {
        for (JRadioButtonMenuItem i : this.midiOutMenuItemList) {
            if (!i.isSelected()) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Throwable {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Context ctx = new Context();
                    PluginManager<RendererPlugin> pm = new PluginManager<RendererPlugin>(RendererPlugin.class, "data/plugin/renderer");
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    MainWindow win = new MainWindow(ctx);
                    win.setVisible(true);
                }
                catch (Throwable e) {
                    Loggable.logger.log(Level.SEVERE, "ERROR", e);
                }
            }
        });
    }
}

