/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayer.context;

import java.util.Arrays;
import org.rz.midiplayer.context.InstrumentList;
import org.rz.midiplayer.xmlmodule.deviceinfo.Instrument;

public class MidiChannel {
    public static final int SIZEOF_NOTE = 128;
    public static final int SIZEOF_CC = 128;
    private final int[] cc = new int[128];
    private final NoteInfo[] noteInfo = new NoteInfo[128];
    private int pitchBend;
    public Instrument instrument = InstrumentList.nullInstrument;
    private boolean drumMode;

    public MidiChannel() {
        for (int i = 0; i < 128; ++i) {
            this.noteInfo[i] = new NoteInfo();
        }
        this.reset();
    }

    public void reset() {
        Arrays.fill(this.cc, 0);
        for (NoteInfo i : this.noteInfo) {
            i.reset();
        }
        this.cc[7] = 100;
        this.cc[11] = 127;
        this.cc[10] = 63;
        this.cc[91] = 40;
        this.drumMode = false;
        this.pitchBend = 8192;
    }

    public int getCcValue(int ccNo) {
        return this.cc[ccNo];
    }

    public void setCcValue(int ccNo, int newValue) {
        this.cc[ccNo] = newValue & 0x7F;
    }

    public NoteInfo getNoteInfo(int noteNo) {
        return this.noteInfo[noteNo];
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument i) {
        if (i == null) {
            i = InstrumentList.nullInstrument;
        }
        this.instrument = i;
    }

    public int getPitchBend() {
        return this.pitchBend;
    }

    public void setPitchBend(int p) {
        this.pitchBend = p & 0x3FFF;
    }

    public boolean isDrumMode() {
        return this.drumMode;
    }

    public void setDrumMode(boolean drumMode) {
        this.drumMode = drumMode;
    }

    public class NoteInfo {
        private boolean noteOn;
        private int velocity;

        public NoteInfo() {
            this.reset();
        }

        public void reset() {
            this.noteOn = false;
            this.velocity = 0;
        }

        public boolean isNoteOn() {
            return this.noteOn;
        }

        public void noteOn(int vel) {
            this.noteOn = true;
            this.velocity = vel;
        }

        public void noteOff() {
            this.noteOn = false;
            this.velocity = 0;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int velocity) {
            this.velocity = velocity;
        }
    }
}

