//******************************************************************************
//
// MIDITrail / MTFirstPersonCam
//
// l̃JNX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// FPSQ[CNȎ_ړB
// {NXŃL[{[h^}EX̏Ԃ擾B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "DIKeyCtrl.h"
#include "DIMouseCtrl.h"
#include "DXCamera.h"
#include "SMIDILib.h"
#include "MTNoteDesign.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//Jʒuő͈
#define MTFIRSTPERSONCAM_CAMVECTOR_LIMIT  (1000000.0f)


//******************************************************************************
// l̃JNX
//******************************************************************************
class MTFirstPersonCam
{
public:

	//RXgN^^fXgN^
	MTFirstPersonCam(void);
	virtual ~MTFirstPersonCam(void);

	//NA
	int Clear();

	//
	int Initialize(HWND hWnd, SMSeqData* pSeqData);

	//Jʒuݒ
	void SetPosition(
			D3DXVECTOR3 camVector
		);

	//Jݒ
	//  ʊpFXZʏXƂ̊px +X=0x +Z=90x
	//  VpFYƂ̊px           +Y=0x XZʏ=90x
	void SetDirection(
			float phi,		//ʊp
			float theta		//Vp
		);

	//Jʒu擾
	void GetPosition(D3DXVECTOR3* pCamVector);

	//J擾
	void GetDirection(
			float* pPhi,
			float* pTheta
		);

	//}EXړ[ho^
	void SetMouseCamMode(bool isEnable);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice);

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

private:

	DXCamera m_Camera;
	D3DXVECTOR3 m_CamVector;
	float m_CamDirPhi;
	float m_CamDirTheta;

	DIKeyCtrl m_DIKeyCtrl;
	DIMouseCtrl m_DIMouseCtrl;
	bool m_IsMouseCamMode;
	HWND m_hWnd;
	MTNoteDesign m_NoteDesign;

	//ړx
	float m_VelocityFB;		//Oړ m/sec.
	float m_VelocityLR;		//Eړ m/sec.
	float m_VelocityUD;		//㉺ړ m/sec.
	float m_VelocityPT;		//ړ degrees/sec.
	float m_AcceleRate;		//{
	
	unsigned long m_PrevTime;
	unsigned long m_DeltaTime;

	unsigned long m_PrevTickTime;
	unsigned long m_CurTickTime;

	int _TransformEyeDirection();
	int _TransformCamPosition();
	int _SetCamPosition();
	int _ClipCursor(bool isClip);
	void _CalcDeltaTime();
	int _LoadConfFile();
	void _ClipCamVector(D3DXVECTOR3* pVector);

};


