//******************************************************************************
//
// MIDITrail / MTTimeIndicator
//
// ^CCWP[^`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTTimeIndicator.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTTimeIndicator::MTTimeIndicator(void)
{
	m_PosStart = 0.0f;
	m_PosEnd = 0.0f;
	m_CurPos = 0.0f;
	m_CurTickTime = 0;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTTimeIndicator::~MTTimeIndicator(void)
{
	Release();
}

//******************************************************************************
// ^CCWP[^
//******************************************************************************
int MTTimeIndicator::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
   )
{
	int result = 0;
	SMBarList barList;
	unsigned long vertexNum = 0;
	unsigned long indexNum = 0;
	MTTIMEINDICATOR_VERTEX* pVertex = NULL;
	unsigned long* pIndex = NULL;
	unsigned long i = 0;
	unsigned long totalTickTime = 0;

	Release();

	if (pSeqData == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//m[gfUCIuWFNg
	result = m_NoteDesign.Initialize(pSeqData);
	if (result != 0) goto EXIT;

	//V[PXf[^ԏ擾
	totalTickTime = pSeqData->GetTotalTickTime();

	//v~eBu
	result = m_Primitive.Initialize(
					sizeof(MTTIMEINDICATOR_VERTEX),	//_TCY
					_GetFVFFormat(),				//_FVFtH[}bg
					D3DPT_TRIANGLESTRIP				//v~eBu
				);
	if (result != 0) goto EXIT;

	//_obt@
	vertexNum = 4;
	result = m_Primitive.CreateVertexBuffer(pD3DDevice, vertexNum);
	if (result != 0) goto EXIT;

	//CfbNXobt@
	indexNum = 4;
	result = m_Primitive.CreateIndexBuffer(pD3DDevice, indexNum);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.LockVertex((void**)&pVertex);
	if (result != 0) goto EXIT;
	result = m_Primitive.LockIndex(&pIndex);
	if (result != 0) goto EXIT;

	//obt@ɒ_ƃCfbNX
	result = _CreateVertexOfIndicator(
					pVertex,		//_obt@݈ʒu
					pIndex,			//CfbNXobt@݈ʒu
					totalTickTime	//g[^`bN^C
				);
	if (result != 0) goto EXIT;

	//obt@̃bN
	result = m_Primitive.UnlockVertex();
	if (result != 0) goto EXIT;
	result = m_Primitive.UnlockIndex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// ړ
//******************************************************************************
int MTTimeIndicator::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice,
		D3DXVECTOR3 camVector
	)
{
	int result = 0;
	D3DXMATRIX worldMatrix;

	//tʒu
	m_CurPos = m_NoteDesign.GetPlayPosX(m_CurTickTime);

	D3DXMatrixIdentity(&worldMatrix);
	D3DXMatrixTranslation(&worldMatrix, m_CurPos, 0.0f, 0.0f);
	m_Primitive.Transform(worldMatrix);
	
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTTimeIndicator::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	result = m_Primitive.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTTimeIndicator::Release()
{
	m_Primitive.Release();
}

//******************************************************************************
// ^CCWP[^_
//******************************************************************************
int MTTimeIndicator::_CreateVertexOfIndicator(
		MTTIMEINDICATOR_VERTEX* pVertex,
		unsigned long* pIndex,
		unsigned long totalTickTime
	)
{
	int result = 0;
	unsigned long i;
	D3DXVECTOR3 vectorLU;
	D3DXVECTOR3 vectorRU;
	D3DXVECTOR3 vectorLD;
	D3DXVECTOR3 vectorRD;

	m_PosStart = m_NoteDesign.GetPlayPosX(0);
	m_PosEnd = m_NoteDesign.GetPlayPosX(totalTickTime);

	//              y x
	//  0+----+1    |/
	//   |    |  z--+0
	//   |    |
	//  2+----+3  3 _(0,0,0)

	//Đʒ_W擾
	m_NoteDesign.GetPlaybackSectionVirtexPos(
			0,
			&vectorLU,
			&vectorRU,
			&vectorLD,
			&vectorRD
		);

	//_W
	pVertex[0].p = vectorLU;
	pVertex[1].p = vectorRU;
	pVertex[2].p = vectorLD;
	pVertex[3].p = vectorRD;

	//@
	pVertex[0].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[1].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[2].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);
	pVertex[3].n = D3DXVECTOR3(-1.0f, 0.0f, 0.0f);

	//e_̃fBt[YF
	for (i = 0; i < 4; i++) {
		pVertex[i].c = m_NoteDesign.GetPlaybackSectionColor();
	}

	//CfbNXFTRIANGLESTRIP
	pIndex[0] = 0;
	pIndex[1] = 1;
	pIndex[2] = 2;
	pIndex[3] = 3;

	return result;
}

//******************************************************************************
// `bN^Cݒ
//******************************************************************************
void MTTimeIndicator::SetCurTickTime(
		unsigned long curTickTime
	)
{
	m_CurTickTime = curTickTime;
}

//******************************************************************************
// Zbg
//******************************************************************************
void MTTimeIndicator::Reset()
{
	m_CurTickTime = 0;
	m_CurPos = 0.0f;
}

//******************************************************************************
// ݈ʒu擾
//******************************************************************************
float MTTimeIndicator::GetPos()
{
	return m_CurPos;
}

