//******************************************************************************
//
// MIDITrail / MTDashboard
//
// _bV{[h`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// Ȗ^tԁ^e|^r[g^ߔԍ \B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "MTStaticCaption.h"
#include "MTDynamicCaption.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//tHgݒ
#define MTDASHBOARD_FONTNAME  _T("MS Gothic")
#define MTDASHBOARD_FONTSIZE  (40)

//JE^LvV
#define MTDASHBOARD_COUNTER_CHARS  _T("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:/ ")

//JE^LvVTCY
//   123456789012345678901234567890123456789012345678901234567890123  (63)
//  "TIME:00:00/00:00 BPM:000 BEAT:4/4 BAR:000/000 NOTES:00000/00000"
//  ]T݂70ɂĂ
#define MTDASHBOARD_COUNTER_SIZE  (70)

//gTCYisNZj
#define MTDASHBOARD_FRAMESIZE  (5.0f)

//ftHg\g嗦
#define MTDASHBOARD_DEFAULT_MAGRATE  (0.5f)


//******************************************************************************
// _bV{[h`NX
//******************************************************************************
class MTDashboard
{
public:

	//RXgN^^fXgN^
	MTDashboard(void);
	virtual ~MTDashboard(void);

	//
	int Create(LPDIRECT3DDEVICE9 pD3DDevice, const TCHAR* pSceneName, SMSeqData* pSeqData, HWND hWnd);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, D3DXVECTOR3 camVector);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//toߎԂƑtԂ̓o^
	void SetPlayTimeSec(unsigned long playTimeSec);
	void SetTotalPlayTimeSec(unsigned long totalPlayTimeSec);

	//e|o^
	void SetTempoBPM(unsigned long bpm);

	//ߔԍƑSߐ̓o^
	void SetBarNo(unsigned long barNo);
	void SetBarNum(unsigned long barNum);

	//qLo^
	void SetBeat(unsigned long numerator, unsigned long denominator);

	//m[gONo^
	void SetNoteOn();

	//Zbg
	void Reset();

private:

	HWND m_hWnd;
	
	MTStaticCaption m_Title;
	
	MTDynamicCaption m_Counter;
	float m_PosCounterX;
	float m_PosCounterY;
	float m_CounterMag;

	unsigned long m_PlayTimeSec;
	unsigned long m_TotalPlayTimeSec;
	unsigned long m_TempoBPM;
	unsigned long m_BeatNumerator;
	unsigned long m_BeatDenominator;
	unsigned long m_BarNo;
	unsigned long m_BarNum;
	unsigned long m_NoteCount;
	unsigned long m_NoteNum;

	unsigned long m_TempoBPMOnStart;
	unsigned long m_BeatNumeratorOnStart;
	unsigned long m_BeatDenominatorOnStart;

	D3DXCOLOR m_CaptionColor;

	int _GetCounterPos(float* pX, float* pY);
	int _GetCounterStr(char* pStr, unsigned long bufSize);
	int _LoadConfFile(const TCHAR* pSceneName);

};

